/*
    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) 2011  <copyright holder> <maurobender@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include "songinfo.h"

#include <QFont>

SongInfo::SongInfo(const Song &song, QGraphicsItem *parent , Qt::WindowFlags wFlags) 
 : QGraphicsWidget(parent, wFlags) {
	m_layout = new QGraphicsGridLayout(this);
	
	QFont labels_font = QFont();
	labels_font.setPointSize(9);
	labels_font.setBold(true);
	
	m_cover = new AlbumArt(this);
	//m_cover->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred);
	m_layout->addItem(m_cover, 0, 0, 3, 1);
	
	Plasma::Label *title_lbl = new Plasma::Label(this);
	title_lbl->setText(i18n("Title: "));
	title_lbl->setFont(labels_font);
	title_lbl->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
	m_layout->addItem(title_lbl, 0, 1);
	
	m_title = new Plasma::Label(this);
	m_title->setTextSelectable(true);
	m_layout->addItem(m_title, 0, 2);
	
	Plasma::Label *artist_lbl = new Plasma::Label(this);
	artist_lbl->setText(i18n("Artist: "));
	artist_lbl->setFont(labels_font);
	artist_lbl->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
	m_layout->addItem(artist_lbl, 1, 1);
	
	m_artist = new Plasma::Label(this);
	m_artist->setTextSelectable(true);
	m_layout->addItem(m_artist, 1, 2);
	
	Plasma::Label *album_lbl = new Plasma::Label(this);
	album_lbl->setText(i18n("Album: "));
	album_lbl->setFont(labels_font);
	artist_lbl->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
	m_layout->addItem(album_lbl, 2, 1);
	
	m_album = new Plasma::Label(this);
	m_album->setTextSelectable(true);
	m_layout->addItem(m_album, 2, 2);
	
	this->setLayout(m_layout);
	//this->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred);
	this->setMaximumHeight(50);
	
	setSong(song);
}

SongInfo::~SongInfo() {
}

void SongInfo::setSong(const Song &song) {
	m_song = song;
	updateInfo();
}

const Song& SongInfo::song() const {
	return m_song;
}

void SongInfo::updateInfo() {
	m_cover->setPixmap(m_song.cover);
	
	m_title->setText(m_song.title);
	m_title->setToolTip(m_song.title);
	
	m_artist->setText(m_song.artist);
	m_artist->setToolTip(m_song.artist);
	
	m_album->setText(m_song.album);
	m_album->setToolTip(m_song.album);
	
	update();
}