/***************************************************************************
 *   Copyright (C) 2004 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "honokapluginbase.h"

HonokaPluginBase::HonokaPluginBase(const String pluginType)
{
    type = pluginType;
}


HonokaPluginBase::~HonokaPluginBase()
{
}

String HonokaPluginBase::getPluginType()
{
    return type;
}

String HonokaPluginBase::getName()
{
    return String("PluginBase");
}



/*!
    \fn Honoka::HonokaPluginBase::findTimerEventId(int id)
 */
bool Honoka::HonokaPluginBase::findTimerEventId(int id)
{
    return timerEventId.count(id);
}


/*!
    \fn Honoka::HonokaPluginBase::timerEvent(int id)
 */
void Honoka::HonokaPluginBase::timerEvent(int id)
{
    return;
}


/*!
    \fn Honoka::HonokaPluginBase::appendDelayEvent(uint32 delay)
 */
int Honoka::HonokaPluginBase::appendDelayEvent(uint32 delay)
{
    int id = HonokaTimer::self()->appendDelayEvent(delay);
    timerEventId.insert(id);
    return id;
}


/*!
    \fn Honoka::HonokaPluginBase::removeTimerEventId(int id)
 */
bool Honoka::HonokaPluginBase::removeTimerEventId(int id)
{
    if (!timerEventId.count(id)) return false;
    timerEventId.erase(id);
    return true;
}



/*!
    \fn Honoka::HonokaPluginBase::clearTimerEvents()
 */
void Honoka::HonokaPluginBase::clearTimerEvents()
{
    timerEventId.clear();
}

