// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/event.h>
#include <gstreamermm/private/event_p.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstenumtypes.h>
#include <gst/gstutils.h>
#include <gstreamermm/message.h>
#include <gstreamermm/structure.h>
#include <gstreamermm/taglist.h>


namespace Gst
{

namespace Enums
{

Glib::ustring get_name(EventType t)
{
  return gst_event_type_get_name(GstEventType(t));
}

Glib::QueryQuark get_quark(EventType t)
{
  return Glib::QueryQuark(gst_event_type_to_quark(GstEventType(t)));
}

EventTypeFlags get_flags(EventType t)
{
  return static_cast<EventTypeFlags>(gst_event_type_get_flags(static_cast<GstEventType>(t)));
}

} //namespace Enums

Glib::RefPtr<Gst::Event> Event::create_writable()
{
  return
   Gst::wrap(GST_EVENT(gst_mini_object_make_writable(GST_MINI_OBJECT(gobj()))));
}

bool Event::is_downstream() const
{
  return GST_EVENT_IS_DOWNSTREAM(gobj());
}

bool Event::is_upstream() const
{
  return GST_EVENT_IS_UPSTREAM(gobj());
}

bool Event::is_serialized() const
{
  return GST_EVENT_IS_SERIALIZED(gobj());
}

EventFlushStart::EventFlushStart(GstEvent* castitem) :
Event(castitem)
{}

Glib::RefPtr<Gst::Event> EventFlushStart::create()
{
  GstEvent* event = gst_event_new_flush_start();
  return Gst::Event::wrap(event, false);
}

EventFlushStop::EventFlushStop(GstEvent* castitem) :
Event(castitem)
{}

Glib::RefPtr<Gst::Event> EventFlushStop::create()
{
  GstEvent* event = gst_event_new_flush_stop();
  return Gst::Event::wrap(event, false);
}

EventEos::EventEos(GstEvent* castitem) :
Event(castitem)
{}

Glib::RefPtr<Gst::Event> EventEos::create()
{
  GstEvent* event = gst_event_new_eos();
  return Gst::Event::wrap(event, false);
}

EventNewSegment::EventNewSegment(GstEvent* castitem) :
Event(castitem)
{}

Glib::RefPtr<Gst::Event> EventNewSegment::create(bool update, double rate,
  Format format, gint64 start, gint64 stop, gint64 position,
  double applied_rate)
{
  GstEvent* event = gst_event_new_new_segment_full(update, rate, applied_rate,
    GstFormat(format), start, stop, position);
  return Gst::Event::wrap(event, false);
}

void EventNewSegment::parse(bool& update, double& rate, Format& format,
  gint64& start, gint64& stop, gint64& position) const
{
  gboolean gst_update = FALSE;
  gst_event_parse_new_segment(const_cast<GstEvent*>(gobj()), &gst_update,
    &rate, (GstFormat*)&format, &start, &stop, &position);
  update = gst_update;
}

void EventNewSegment::parse(bool& update, double& rate, Format& format,
  gint64& start, gint64& stop, gint64& position, double& applied_rate) const
{
  gboolean gst_update = FALSE;
  gst_event_parse_new_segment_full(const_cast<GstEvent*>(gobj()), &gst_update,
    &rate, &applied_rate, (GstFormat*)&format, &start, &stop, &position);
  update = gst_update;
}

gint64 EventNewSegment::parse() const
{
  gint64 gst_position = 0;
  gst_event_parse_new_segment_full(const_cast<GstEvent*>(gobj()), 0, 0, 0, 0,
    0, 0, &gst_position);
  return gst_position;
}

bool EventNewSegment::parse_update() const
{
  gboolean gst_update = FALSE;
  gst_event_parse_new_segment_full(const_cast<GstEvent*>(gobj()), &gst_update,
    0, 0, 0, 0, 0, 0);
  return gst_update;
}

double EventNewSegment::parse_rate() const
{
  double gst_rate = 0;
  gst_event_parse_new_segment_full(const_cast<GstEvent*>(gobj()), 0, &gst_rate,
    0, 0, 0, 0, 0);
  return gst_rate;
}

Gst::Format EventNewSegment::parse_format() const
{
  GstFormat gst_format = GST_FORMAT_UNDEFINED;
  gst_event_parse_new_segment_full(const_cast<GstEvent*>(gobj()), 0, 0, 0,
    &gst_format, 0, 0, 0);
  return static_cast<Gst::Format>(gst_format);
}

double EventNewSegment::parse_applied_rate() const
{
  double gst_applied_rate = 0;
  gst_event_parse_new_segment_full(const_cast<GstEvent*>(gobj()), 0, 0,
    &gst_applied_rate, 0, 0, 0, 0);
  return gst_applied_rate;
}

EventTag::EventTag(GstEvent* castitem) :
Event(castitem)
{}

Glib::RefPtr<Gst::Event> EventTag::create(const Gst::TagList& taglist)
{
  //We create a copy because gst_event_new_tag() takes ownership:
  GstTagList* c_taglist = gst_tag_list_copy(taglist.gobj());
  GstEvent* event = gst_event_new_tag(c_taglist);
  return Gst::Event::wrap(event, false);
}

Gst::TagList EventTag::parse() const
{
  GstTagList* gst_taglist = gst_tag_list_new();
  gst_event_parse_tag(const_cast<GstEvent*>(gobj()), &gst_taglist);
  return Gst::TagList(gst_taglist);
}

EventBufferSize::EventBufferSize(GstEvent* castitem) :
Event(castitem)
{}

Glib::RefPtr<Gst::Event> EventBufferSize::create(Format format, gint64 minsize,
  gint64 maxsize, bool async)
{
  GstEvent* event = gst_event_new_buffer_size(GstFormat(format), minsize,
    maxsize, async);
  return Gst::Event::wrap(event, false);
}

void EventBufferSize::parse(Format& format, gint64& minsize, gint64& maxsize,
  bool& async) const
{
  gboolean gst_async = FALSE;
  gst_event_parse_buffer_size(const_cast<GstEvent*>(gobj()),
    (GstFormat*)&format, &minsize, &maxsize, &gst_async);
  async = gst_async;
}

gint64 EventBufferSize::parse() const
{
  gint64 gst_minsize = 0;
  gst_event_parse_buffer_size(const_cast<GstEvent*>(gobj()), 0, &gst_minsize,
    0, 0);
  return gst_minsize;
}

Gst::Format EventBufferSize::parse_format() const
{
  GstFormat gst_format = GST_FORMAT_UNDEFINED;
  gst_event_parse_buffer_size(const_cast<GstEvent*>(gobj()),
    reinterpret_cast<GstFormat*>(&gst_format), 0, 0, 0);
  return static_cast<Gst::Format>(gst_format);
}

gint64 EventBufferSize::parse_max_size() const
{
  gint64 gst_maxsize = 0;
  gst_event_parse_buffer_size(const_cast<GstEvent*>(gobj()), 0, 0,
    &gst_maxsize, 0);
  return gst_maxsize;
}

bool EventBufferSize::parse_async() const
{
  gboolean gst_async = FALSE;
  gst_event_parse_buffer_size(const_cast<GstEvent*>(gobj()), 0, 0, 0, &gst_async);
  return gst_async;
}

EventQos::EventQos(GstEvent* castitem) :
Event(castitem)
{}

Glib::RefPtr<Gst::Event> EventQos::create(double proportion,
  ClockTimeDiff diff, ClockTime timestamp)
{
  GstEvent* event = gst_event_new_qos(proportion, GstClockTimeDiff(diff),
    GstClockTime(timestamp));
  return Gst::Event::wrap(event, false);
}

void EventQos::parse(double& proportion, ClockTimeDiff& diff,
  ClockTime& timestamp) const
{
  gst_event_parse_qos(const_cast<GstEvent*>(gobj()), &proportion, &diff,
    &timestamp);
}

double EventQos::parse() const
{
  double gst_proportion = 0;
  gst_event_parse_qos(const_cast<GstEvent*>(gobj()), &gst_proportion, 0, 0);
  return gst_proportion;
}

Gst::ClockTimeDiff EventQos::parse_diff() const
{
  GstClockTimeDiff gst_diff = 0;
  gst_event_parse_qos(const_cast<GstEvent*>(gobj()), 0, &gst_diff, 0);
  return gst_diff;
}

Gst::ClockTime EventQos::parse_timestamp() const
{
  GstClockTime gst_timestamp = 0;
  gst_event_parse_qos(const_cast<GstEvent*>(gobj()), 0, 0, &gst_timestamp);
  return gst_timestamp;
}

EventSeek::EventSeek(GstEvent* castitem) :
Event(castitem)
{}

Glib::RefPtr<Gst::Event> EventSeek::create(double rate, Format format,
  SeekFlags flags, SeekType start_type, gint64 start, SeekType stop_type,
  gint64 stop)
{
  GstEvent* event = gst_event_new_seek(rate, GstFormat(format),
    GstSeekFlags(flags), GstSeekType(start_type), start,
    GstSeekType(stop_type), stop);

  return Gst::Event::wrap(event, false);
}

void EventSeek::parse(double& rate, Format& format, SeekFlags& flags,
  SeekType& start_type, gint64& start, SeekType& stop_type, gint64& stop) const
{
  gst_event_parse_seek(const_cast<GstEvent*>(gobj()), &rate,
    (GstFormat*)&format, (GstSeekFlags*)&flags, (GstSeekType*)&start_type,
    &start, (GstSeekType*)&stop_type, &stop);
}

gint64 EventSeek::parse() const
{
  gint64 gst_start = 0;
  gst_event_parse_seek(const_cast<GstEvent*>(gobj()), 0, 0, 0, 0, &gst_start,
    0, 0);
  return gst_start;
}

double EventSeek::parse_rate() const
{
  double gst_rate = 0;
  gst_event_parse_seek(const_cast<GstEvent*>(gobj()), &gst_rate, 0, 0, 0, 0,
    0, 0);
  return gst_rate;
}

Gst::Format EventSeek::parse_format() const
{
  GstFormat gst_format = GST_FORMAT_UNDEFINED;
  gst_event_parse_seek(const_cast<GstEvent*>(gobj()), 0, &gst_format, 0, 0, 0,
    0, 0);
  return static_cast<Gst::Format>(gst_format);
}

Gst::SeekFlags EventSeek::parse_flags() const
{
  GstSeekFlags gst_flags = GST_SEEK_FLAG_NONE;
  gst_event_parse_seek(const_cast<GstEvent*>(gobj()), 0, 0, &gst_flags, 0, 0,
    0, 0);
  return static_cast<Gst::SeekFlags>(gst_flags);
}

Gst::SeekType EventSeek::parse_start_type() const
{
  GstSeekType gst_type = GST_SEEK_TYPE_NONE;
  gst_event_parse_seek(const_cast<GstEvent*>(gobj()), 0, 0, 0, &gst_type, 0,
    0, 0);
  return static_cast<Gst::SeekType>(gst_type);
}

Gst::SeekType EventSeek::parse_stop_type() const
{
  GstSeekType gst_type = GST_SEEK_TYPE_NONE;
  gst_event_parse_seek(const_cast<GstEvent*>(gobj()), 0, 0, 0, 0, 0, &gst_type,
    0);
  return static_cast<Gst::SeekType>(gst_type);
}

gint64 EventSeek::parse_stop() const
{
  gint64 gst_stop = 0;
  gst_event_parse_seek(const_cast<GstEvent*>(gobj()), 0, 0, 0, 0, 0, 0,
    &gst_stop);
  return gst_stop;
}

EventNavigation::EventNavigation(GstEvent* castitem) :
Event(castitem)
{}

Glib::RefPtr<Gst::Event> EventNavigation::create(Gst::Structure& structure)
{
  // Make copy because event takes ownership of structure:
  GstStructure* copy = gst_structure_copy(structure.gobj());
  GstEvent* event = gst_event_new_navigation(copy);
  return Gst::Event::wrap(event, false);
}

EventLatency::EventLatency(GstEvent* castitem) :
Event(castitem)
{}

Glib::RefPtr<Gst::Event> EventLatency::create(ClockTime time)
{
  GstEvent* event = gst_event_new_latency(GstClockTime(time));
  return Gst::Event::wrap(event, false);
}

ClockTime EventLatency::parse() const
{
  GstClockTime gst_latency = 0;
  gst_event_parse_latency(const_cast<GstEvent*>(gobj()), &gst_latency);
  return gst_latency;
}

EventStep::EventStep(GstEvent* castitem) :
Event(castitem)
{}

Glib::RefPtr<Gst::Event> EventStep::create(Gst::Format format, guint64 amount,
  double rate, bool flush, bool intermediate)
{
  GstEvent* event = gst_event_new_step(static_cast<GstFormat>(format),
    amount, rate, flush, intermediate);
  return Gst::Event::wrap(event, false);
}

void EventStep::parse(Gst::Format& format, guint64& amount, double& rate,
  bool& flush, bool& intermediate) const
{
  gboolean gst_flush = FALSE;
  gboolean gst_intermediate = FALSE;

  gst_event_parse_step(const_cast<GstEvent*>(gobj()),
    reinterpret_cast<GstFormat*>(&format), &amount, &rate, &gst_flush,
    &gst_intermediate);

  flush = gst_flush;
  intermediate = gst_intermediate;
}

guint64 EventStep::parse() const
{
  guint64 gst_amount = 0;
  gst_event_parse_step(const_cast<GstEvent*>(gobj()), 0, &gst_amount, 0, 0, 0);
  return gst_amount;
}

Gst::Format EventStep::parse_format() const
{
  GstFormat gst_format = GST_FORMAT_UNDEFINED;
  gst_event_parse_step(const_cast<GstEvent*>(gobj()), &gst_format, 0, 0, 0, 0);
  return static_cast<Gst::Format>(gst_format);
}

double EventStep::parse_rate() const
{
  double gst_rate = 0;
  gst_event_parse_step(const_cast<GstEvent*>(gobj()), 0, 0, &gst_rate, 0, 0);
  return gst_rate;
}

bool EventStep::parse_flush() const
{
  gboolean gst_flush = FALSE;
  gst_event_parse_step(const_cast<GstEvent*>(gobj()), 0, 0, 0, &gst_flush, 0);
  return gst_flush;
}

bool EventStep::parse_intermediate() const
{
  gboolean gst_intermediate = FALSE;
  gst_event_parse_step(const_cast<GstEvent*>(gobj()), 0, 0, 0, 0,
    &gst_intermediate);
  return gst_intermediate;
}

EventSinkMessage::EventSinkMessage(GstEvent* castitem) :
Event(castitem)
{}

Glib::RefPtr<Gst::Event> EventSinkMessage::create(const Glib::RefPtr<Gst::Message>& msg)
{
  GstEvent* event = gst_event_new_sink_message(msg->gobj());
  return Gst::Event::wrap(event, false);
}

Glib::RefPtr<Gst::Message> EventSinkMessage::parse()
{
  GstMessage* gst_msg = 0;
  gst_event_parse_sink_message(gobj(), &gst_msg);
  return Gst::wrap(gst_msg);
}

Glib::RefPtr<const Gst::Message> EventSinkMessage::parse() const
{
  GstMessage* gst_msg = 0;
  gst_event_parse_sink_message(const_cast<GstEvent*>(gobj()), &gst_msg);
  return Gst::wrap(gst_msg);
}

Glib::RefPtr<Gst::Event> Event::wrap(GstEvent* event, bool take_copy)
{
  Gst::Event* wrapper = 0;
  Glib::RefPtr<Gst::Event> result;

  if(!event)
    return result;

  switch(GST_EVENT_TYPE(event))
  {
    case GST_EVENT_FLUSH_START:
      wrapper = new Gst::EventFlushStart(event);
      break;
    case GST_EVENT_FLUSH_STOP:
      wrapper = new Gst::EventFlushStop(event);
      break;
    case GST_EVENT_EOS:
      wrapper = new Gst::EventEos(event);
      break;
    case GST_EVENT_NEWSEGMENT:
      wrapper = new Gst::EventNewSegment(event);
      break;
    case GST_EVENT_TAG:
      wrapper = new Gst::EventTag(event);
      break;
    case GST_EVENT_BUFFERSIZE:
      wrapper = new Gst::EventBufferSize(event);
      break;
    case GST_EVENT_SINK_MESSAGE:
      wrapper = new Gst::EventSinkMessage(event);
      break;
    case GST_EVENT_QOS:
      wrapper = new Gst::EventQos(event);
      break;
    case GST_EVENT_SEEK:
      wrapper = new Gst::EventSeek(event);
      break;
    case GST_EVENT_NAVIGATION:
      wrapper = new Gst::EventNavigation(event);
      break;
    case GST_EVENT_LATENCY:
      wrapper = new Gst::EventLatency(event);
      break;
    case GST_EVENT_STEP:
      wrapper = new Gst::EventStep(event);
      break;
    default:
      wrapper = new Gst::Event(event);
  }

  result = Glib::RefPtr<Gst::Event>(wrapper);

  if(take_copy)
    result->reference();

  return result;
}

Gst::MiniObject* Event_Class::wrap_new(GstMiniObject* object)
{
  // Use the Gst::Event wrap() method to get the right type of Event class
  // and return the underlying object in the refptr.  The extra reference is
  // needed so that the object does not loose a reference when the local refptr
  // is destroyed.
  return Gst::Event::wrap((GstEvent*)object, true).operator->();
}

GstMiniObject* Event_Class::copy_vfunc_callback(const GstMiniObject* self)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(GST_MINI_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && GST_MINI_OBJECT_CLASS(base)->copy)
    return (*GST_MINI_OBJECT_CLASS(base)->copy)(self);

  return 0;
}
Glib::RefPtr<Gst::MiniObject> Event::copy_vfunc() const
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobj())) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && GST_MINI_OBJECT_CLASS(base)->copy)
  {
    return Gst::Event::wrap(GST_EVENT((*GST_MINI_OBJECT_CLASS(base)->copy)(
        GST_MINI_OBJECT(gobj()))));
  }

  return Glib::RefPtr<Gst::MiniObject>(0);
}
void Event_Class::finalize_vfunc_callback(GstMiniObject* self)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(GST_MINI_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && GST_MINI_OBJECT_CLASS(base)->finalize)
    (*GST_MINI_OBJECT_CLASS(base)->finalize)(self);
}
void Event::finalize_vfunc()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobj())) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && GST_MINI_OBJECT_CLASS(base)->finalize)
    (*GST_MINI_OBJECT_CLASS(base)->finalize)(GST_MINI_OBJECT(gobj()));
}

} //namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::SeekType>::value_type()
{
  return gst_seek_type_get_type();
}

// static
GType Glib::Value<Gst::SeekFlags>::value_type()
{
  return gst_seek_flags_get_type();
}

// static
GType Glib::Value<Gst::EventTypeFlags>::value_type()
{
  return gst_event_type_flags_get_type();
}


namespace Gst
{

Glib::RefPtr<Gst::Event> wrap(GstEvent* object, bool take_copy)
{
  //Note that we use Gst::wrap() instead of Glib::wrap() 
  //because we are dealing with a GstMiniObject, not a GObject:
  return Glib::RefPtr<Gst::Event>( dynamic_cast<Gst::Event*> (Gst::wrap_auto ((GstMiniObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Gst */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Event_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Event_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_event_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Event_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  GST_MINI_OBJECT_CLASS(klass)->copy = &copy_vfunc_callback;
  GST_MINI_OBJECT_CLASS(klass)->finalize = &finalize_vfunc_callback;
  
}


/* The implementation: */

GstEvent* Event::gobj_copy()
{
  // Use the mini object copying function to get a copy of the underlying
  // gobject instead of referencing and returning the underlying gobject as
  // would be done normally:
  return reinterpret_cast<GstEvent*>(gst_mini_object_copy(reinterpret_cast<GstMiniObject*>(gobj())));
}


Event::Event(GstEvent* castitem)
:
  Gst::MiniObject((GstMiniObject*)(castitem))
{}

Event::~Event()
{}


Event::CppClassType Event::event_class_; // initialize static member

GType Event::get_type()
{
  return event_class_.init().get_type();
}


GType Event::get_base_type()
{
  return gst_event_get_type();
}


Gst::Structure Event::get_structure() const
{
  return Glib::wrap(const_cast<GstStructure*>(gst_event_get_structure(const_cast<GstEvent*>(gobj()))), true);
}

bool Event::has_name(const Glib::ustring& name) const
{
  return gst_event_has_name(const_cast<GstEvent*>(gobj()), name.c_str());
}

guint32 Event::get_seqnum() const
{
  return gst_event_get_seqnum(const_cast<GstEvent*>(gobj()));
}

void Event::set_seqnum(guint32 seqnum)
{
gst_event_set_seqnum(gobj(), seqnum); 
}

 EventType Event::get_event_type() const
{
  return ((EventType)(gobj()->type));
}
 
 ClockTime Event::get_timestamp() const
{
  return (ClockTime)(gobj()->timestamp);
}
 
 Glib::RefPtr<Gst::Object> Event::get_source()
{
  Glib::RefPtr<Gst::Object> ref_ptr(Glib::wrap(gobj()->src));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gst::Object> Event::get_source() const
{
  Glib::RefPtr<const Gst::Object> ref_ptr(Glib::wrap(gobj()->src));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}
 

} // namespace Gst


