
/*
 *  devinfo.cpp
 *
 *  Copyright (C) 2009 David Hubner <hubnerd@ntlworld.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#include "devinfo.h"

K_PLUGIN_FACTORY(devInfoModuleFactory, registerPlugin<DevInfoPlugin>();)
K_EXPORT_PLUGIN(devInfoModuleFactory("kcmdevinfo"))

DevInfoPlugin::DevInfoPlugin(QWidget *parent, const QVariantList &)  : 
  KCModule(devInfoModuleFactory::componentData(), parent)
{
  
  KAboutData *about =
  new KAboutData(I18N_NOOP("kcmdevinfo"), 0, ki18n("KDE Solid Based Device Viewer"),
                  0, KLocalizedString(), KAboutData::License_GPL,
                  ki18n("(c) 2009 David Hubner"));
		  
  setAboutData(about);
  
  //Layout
  topLayout = new QVBoxLayout(this);
  
  //top 
  QSplitter *split = new QSplitter(Qt::Horizontal, this);
  split->setChildrenCollapsible(false);

  InfoPanel *info = new InfoPanel(split, this);
  DeviceListing *devList = new DeviceListing(split, info);
  
  split->setStretchFactor(1,1);
 
  //bottom
  QWidget *bottom = new QWidget(this);
  bottom->setMaximumHeight(30);
  
  QFont boldFont;
  boldFont.setBold(true);
  
  QLabel *udiLabel = new QLabel(i18n("UDI: "));
  udiLabel->setFont(boldFont);
  
  QHBoxLayout *bottomLayout = new QHBoxLayout(bottom);
  
  udiStatus = new QStatusBar(this);
  udiStatus->setSizeGripEnabled(false);
 
  //Adding
  
  split->addWidget(devList);  
  split->addWidget(info);
  
  bottomLayout->addWidget(udiLabel);
  bottomLayout->addWidget(udiStatus);
  
  topLayout->addWidget(split); 
  topLayout->addWidget(bottom);
  
  setButtons(Help);
}

DevInfoPlugin::~DevInfoPlugin() {
  
  delete topLayout; 

}
  
void DevInfoPlugin::updateStatus(QString message) {
  
  udiStatus->clearMessage();
  udiStatus->showMessage(message);
};