/* swfmovie.c	- SWFMovie class
 * $Id: swfmovie.c,v 1.3 2006/12/17 18:56:37 mcdonaec Exp $
 *
 * Copyright (C) 2004 IKEGAMI Daisuke <ikegami at madscientist dot jp>
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 */

#include <ming.h>
#include "ruby.h"
#include "mingc.h"

VALUE rb_cSWFMovie;

static void rb_SWFMovie_mark(movie)
     struct RSWFMovie *movie;
{
  mark_references(movie->table);

  return;
}

void
rb_free_SWFMovie(p)
	 struct RSWFMovie *p;
{
  /* destroySWFMovie(p->this); */
  
  return;  
}

static VALUE
rb_SWFMovie_s_new(argc, argv, self)
     int argc;
     VALUE *argv, self;
{
  VALUE obj, version;
  struct RSWFMovie *m = ALLOC(struct RSWFMovie);

  rb_scan_args(argc, argv, "01", &version);

  if(NIL_P(version))
    m->this = newSWFMovie();
  else
    m->this = newSWFMovieWithVersion(NUM2INT(version));

  m->table = ALLOC(struct References);
  init_references(m->table);

  obj = Data_Wrap_Struct(rb_cSWFMovie, rb_SWFMovie_mark,
			  rb_free_SWFMovie, m);
  
  return obj;
}

static VALUE
rb_SWFMovie_set_rate(self, f)
	 VALUE self, f;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_setRate(m->this, (float) NUM2DBL(f));

  return self;
}

static VALUE
rb_SWFMovie_set_dimension(self, w, h)
     VALUE self, w, h;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_setDimension(m->this, (float) NUM2DBL(w), (float) NUM2DBL(h));

  return self;
}

static VALUE
rb_SWFMovie_set_number_of_frames(self, n)
	 VALUE self, n;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_setNumberOfFrames(m->this, FIX2INT(n));

  return self;
}

static VALUE
rb_SWFMovie_add_export(self, block, n)
	 VALUE self, block, n;
{
  struct RSWFMovie *m;
  struct RSWFBlock *b;
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(block, struct RSWFBlock, b);

  add_references(m->table, n);
  SWFMovie_addExport(m->this, b->this, STR2CSTR(n));
  
  return self;
}

static VALUE
rb_SWFMovie_write_exports(self)
         VALUE self;
{
   struct RSWFMovie *m;

   Data_Get_Struct(self, struct RSWFMovie, m);
   SWFMovie_writeExports(m->this);

   return self;
}

static VALUE
rb_SWFMovie_set_background(self, r, g, b)
	 VALUE self, r, g, b;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_setBackground(m->this, FIX2INT(r), FIX2INT(g), FIX2INT(b));
  
  return self;
}

static VALUE
rb_SWFMovie_add(self, b)
	 VALUE self, b;
{
  struct RSWFMovie *m;
  struct RSWFBlock *p;
  struct RSWFDisplayItem *i;
  SWFDisplayItem item;
  VALUE obj;

  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(b, struct RSWFBlock, p);
  
  item = SWFMovie_add(m->this, p->this);

  if (item == NULL) {
    obj = Qnil;
  } else {
    add_references(m->table, b);
    i = ALLOC(struct RSWFDisplayItem);
    i->this = item;
    i->table = ALLOC(struct References);
    init_references(i->table);
    
    obj = Data_Wrap_Struct(rb_cSWFDisplayItem, 0,
			   rb_free_SWFDisplayItem, i);
    add_references(m->table, obj);
  }

  return obj;
}

static VALUE
rb_SWFMovie_remove(self, i)
	 VALUE self, i;
{
  struct RSWFMovie *m;
  struct RSWFDisplayItem *p;
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(i, struct RSWFDisplayItem, p);
  
  add_references(m->table, i);
  SWFMovie_remove(m->this, p->this);

  return self;
}

static VALUE
rb_SWFMovie_next_frame(self)
	 VALUE self;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_nextFrame(m->this);

  return self;
}

static VALUE
rb_SWFMovie_label_frame(self, label)
	 VALUE self, label;
{
  struct RSWFMovie *m;

  Data_Get_Struct(self, struct RSWFMovie, m);
  SWFMovie_labelFrame(m->this, STR2CSTR(label));

  return self;
}

static void simpleOutputMethod(byte b, void *data);
static void simpleOutputMethod(b, data)
	 byte b;
	 void *data;
{
  putchar(b);
}

static VALUE
rb_SWFMovie_output(argc, argv, self)
     int argc;
     VALUE *argv, self;
{
  int len, level;
  struct RSWFMovie *m;
  VALUE lobj;

  rb_scan_args(argc, argv, "01", &lobj);
  if(NIL_P(lobj))
    level = 0;
  else
    level = NUM2INT(lobj);

  Data_Get_Struct(self, struct RSWFMovie, m);
  Ming_setSWFCompression(level);
  len = SWFMovie_output(m->this, simpleOutputMethod, NULL);
  
  return INT2NUM(len);
}

static VALUE
rb_SWFMovie_save(argc, argv, self)
     int argc;
     VALUE *argv, self;
{
  struct RSWFMovie *m;
  int count, level;
  VALUE s, lobj;

  rb_scan_args(argc, argv, "11", &s, &lobj);
  if(NIL_P(lobj))
    level = 0;
  else
    level = NUM2INT(lobj);

  Data_Get_Struct(self, struct RSWFMovie, m);
  Ming_setSWFCompression(level);
  count = SWFMovie_save(m->this, STR2CSTR(s));

  return INT2NUM(count);
}

static VALUE
rb_SWFMovie_set_sound_stream(self, sound)
	 VALUE self, sound;
{
  struct RSWFMovie *m;
  struct RSWFSoundStream *s;
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(sound, struct RSWFSoundStream, s);
  SWFMovie_setSoundStream(m->this, s->this);
  
  return self;
}

static VALUE
rb_SWFMovie_set_sound_stream_at(self, sound, r)
     VALUE self, sound, r;
{
  struct RSWFMovie *m;
  struct RSWFSoundStream *s;

  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(sound, struct RSWFSoundStream, s);

  SWFMovie_setSoundStreamAt(m->this, s->this, NUM2DBL(r));

  return self;
}

static VALUE
rb_SWFMovie_start_sound(self, sound)
	 VALUE self, sound;
{
  struct RSWFMovie *m;
  struct RSWFSound *s;
  struct RSWFSoundInstance *i;
  SWFSoundInstance si;
  VALUE obj;
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(sound, struct RSWFSound, s);
  si = SWFMovie_startSound(m->this, s->this);
  
  add_references(m->table, sound);
  i = ALLOC(struct RSWFSoundInstance);
  i->this = si;
  i->table = ALLOC(struct References);
  init_references(i->table);
  obj = Data_Wrap_Struct(rb_cSWFSoundInstance, 0, 
                         rb_free_SWFSoundInstance, i);
  add_references(m->table, obj);
  
  return obj;
}

static VALUE
rb_SWFMovie_stop_sound(self, sound)
	 VALUE self, sound;
{
  struct RSWFMovie *m;
  struct RSWFSound *s;
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  Data_Get_Struct(sound, struct RSWFSound, s);
  SWFMovie_stopSound(m->this, s->this);
  
  return self;
}

static VALUE
rb_SWFMovie_import_character(self, filename, name)
     VALUE self, filename, name;
{
  struct RSWFMovie *m;
  struct RSWFCharacter *b = ALLOC(struct RSWFCharacter);
  VALUE obj;
  
  Data_Get_Struct(self, struct RSWFMovie, m);
  b->this = SWFMovie_importCharacter(m->this, 
                                     STR2CSTR(filename), STR2CSTR(name));
  b->table = ALLOC(struct References);
  init_references(b->table);

  obj = Data_Wrap_Struct(rb_cSWFCharacter, 0, rb_free_SWFCharacter, b);
  
  return obj;
}

void Init_swfmovie()
{
  rb_cSWFMovie = rb_define_class_under(rb_mMing, "SWFMovie",
                                       rb_cObject);

  rb_define_singleton_method(rb_cSWFMovie, "new",
                             rb_SWFMovie_s_new, -1);

  rb_define_method(rb_cSWFMovie, "set_rate",
                   rb_SWFMovie_set_rate, 1);
  rb_define_method(rb_cSWFMovie, "set_dimension",
                   rb_SWFMovie_set_dimension, 2);
  rb_define_method(rb_cSWFMovie, "set_number_of_frames",
                   rb_SWFMovie_set_number_of_frames, 1);
  rb_define_method(rb_cSWFMovie, "add_export",
                   rb_SWFMovie_add_export, 2);
  rb_define_method(rb_cSWFMovie, "write_exports",
                    rb_SWFMovie_write_exports, 0);
  rb_define_method(rb_cSWFMovie, "set_background",
                   rb_SWFMovie_set_background, 3);
  rb_define_method(rb_cSWFMovie, "add",
                   rb_SWFMovie_add, 1);
  rb_define_method(rb_cSWFMovie, "remove",
                   rb_SWFMovie_remove, 1);
  rb_define_method(rb_cSWFMovie, "next_frame",
                   rb_SWFMovie_next_frame, 0);
  rb_define_method(rb_cSWFMovie, "label_frame",
                   rb_SWFMovie_label_frame, 1);
  rb_define_method(rb_cSWFMovie, "output",
                   rb_SWFMovie_output, -1);
  rb_define_method(rb_cSWFMovie, "save",
                   rb_SWFMovie_save, -1);
  rb_define_method(rb_cSWFMovie, "set_sound_stream",
                   rb_SWFMovie_set_sound_stream, 1);
  rb_define_method(rb_cSWFMovie, "set_sound_stream_at",
                   rb_SWFMovie_set_sound_stream_at, 2);
  rb_define_method(rb_cSWFMovie, "start_sound",
                   rb_SWFMovie_start_sound, 1);
  rb_define_method(rb_cSWFMovie, "stop_sound",
                   rb_SWFMovie_stop_sound, 1);
  rb_define_method(rb_cSWFMovie, "import_character",
                   rb_SWFMovie_import_character, 2);

  return;
}
