#!/usr/bin/ruby
# alphafill.rb -k
# http://ming.sourceforge.net/examples/example.php?name=alphafill

require 'ming/ming'
include Ming

use_SWF_version(7)
set_scale(1.0)

m = SWFMovie.new
m.set_dimension(719,900)
m.set_background(0xcc, 0xcc, 0xcc)


s = SWFShape.new
alpha = SWFBitmap.new("alphafill.jpg", "alphafill.msk")

s.set_right_fill(s.add_fill(alpha))
s.draw_line(640, 0)
s.draw_line(0, 480)
s.draw_line(-640, 0)
s.draw_line(0, -480)

c = SWFShape.new
c.set_right_fill(c.add_fill(0x99, 0x99, 0x99))
c.draw_line(40, 0)
c.draw_line(0, 40)
c.draw_line(-40, 0)
c.draw_line(0, -40)

# draw checkerboard background
0.step(480, 40) do |y|
  0.step(640, 80) do |x|
    i = m.add(c)
    i.move_to(x, y)
  end

  y += 40

  40.step(640, 80) do |x|
    i = m.add(c)
    i.move_to(x, y)
  end
end

m.add(s)

m.save("alphafill.swf")

