/*
 * xmlformat - registration of xml object formats 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 * 
 */

#ifndef XMLFORMAT_EVENT_H
#define XMLFORMAT_EVENT_H

#include "xmlformat-common.h"
#include "xmlformat-calendar.h"

#define XMLFORMAT_EVENT_ROOT				"event"
#define XMLFORMAT_EVENT_VERSION				"version"

// AlarmAudio
#define XMLFORMAT_EVENT_ALARMAUDIO			"AlarmAudio"						// Type Alarm
#define XMLFORMAT_EVENT_ALARMAUDIO_ACTION		XMLFORMAT_CALENDAR_ALARM_ACTION
#define XMLFORMAT_EVENT_ALARMAUDIO_ACTION_AUDIO		XMLFORMAT_CALENDAR_ALARM_ACTION_AUDIO	
#define XMLFORMAT_EVENT_ALARMAUDIO_ACTION_DISPLAY	XMLFORMAT_CALENDAR_ALARM_ACTION_DISPLAY	
#define XMLFORMAT_EVENT_ALARMAUDIO_ACTION_EMAIL		XMLFORMAT_CALENDAR_ALARM_ACTION_EMAIL	
#define XMLFORMAT_EVENT_ALARMAUDIO_ACTION_PROCEDURE	XMLFORMAT_CALENDAR_ALARM_ACTION_PROCEDURE	
#define XMLFORMAT_EVENT_ALARMAUDIO_ATTACH		XMLFORMAT_CALENDAR_ALARM_ATTACH	
#define XMLFORMAT_EVENT_ALARMAUDIO_ATTENDEE		XMLFORMAT_CALENDAR_ALARM_ATTENDEE
#define XMLFORMAT_EVENT_ALARMAUDIO_DESCRIPTION		XMLFORMAT_CALENDAR_ALARM_DESCRIPTION
#define XMLFORMAT_EVENT_ALARMAUDIO_REPEAT		XMLFORMAT_CALENDAR_ALARM_REPEAT	
#define XMLFORMAT_EVENT_ALARMAUDIO_REPEATDURATION	XMLFORMAT_CALENDAR_ALARM_REPEATDURATION
#define XMLFORMAT_EVENT_ALARMAUDIO_SUMMARY		XMLFORMAT_CALENDAR_ALARM_SUMMARY
#define XMLFORMAT_EVENT_ALARMAUDIO_TRIGGER		XMLFORMAT_CALENDAR_ALARM_TRIGGER
#define XMLFORMAT_EVENT_ALARMAUDIO_VALUE		XMLFORMAT_CALENDAR_ALARM_VALUE
#define XMLFORMAT_EVENT_ALARMAUDIO_VALUE_DATETIME	XMLFORMAT_CALENDAR_TRIGGERTYPE_DATETIME
#define XMLFORMAT_EVENT_ALARMAUDIO_VALUE_DURATION	XMLFORMAT_CALENDAR_TRIGGERTYPE_DURATION
#define XMLFORMAT_EVENT_ALARMAUDIO_RELATEDTYPE		XMLFORMAT_CALENDAR_ALARM_RELATEDTYPE
#define XMLFORMAT_EVENT_ALARMAUDIO_RELATEDTYPE_START	XMLFORMAT_CALENDAR_RELATEDTYPE_START
#define XMLFORMAT_EVENT_ALARMAUDIO_RELATEDTYPE_END	XMLFORMAT_CALENDAR_RELATEDTYPE_END
#define XMLFORMAT_EVENT_ALARMAUDIO_ALTERNATIVETEXTREP	XMLFORMAT_CALENDAR_ALARM_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_ALARMAUDIO_LANGUAGE		XMLFORMAT_CALENDAR_ALARM_LANGUAGE
#define XMLFORMAT_EVENT_ALARMAUDIO_ATTACHVALUE		XMLFORMAT_CALENDAR_ALARM_ATTACHVALUE
#define XMLFORMAT_EVENT_ALARMAUDIO_ATTACHVALUE_URI	XMLFORMAT_CALENDAR_ATTACHMENTTYPE_URI
#define XMLFORMAT_EVENT_ALARMAUDIO_ATTACHVALUE_BINARY	XMLFORMAT_CALENDAR_ATTACHMENTTYPE_BINARY
#define XMLFORMAT_EVENT_ALARMAUDIO_FORMATTYPE		XMLFORMAT_CALENDAR_ALARM_FORMATTYPE
#define XMLFORMAT_EVENT_ALARMAUDIO_ENCODING		XMLFORMAT_CALENDAR_ALARM_ENCODING

// AlarmDisplay
#define XMLFORMAT_EVENT_ALARMDISPLAY			"AlarmDisplay"						// Type Alarm
#define XMLFORMAT_EVENT_ALARMDISPLAY_ACTION		XMLFORMAT_CALENDAR_ALARM_ACTION
#define XMLFORMAT_EVENT_ALARMDISPLAY_ACTION_AUDIO	XMLFORMAT_CALENDAR_ALARM_ACTION_AUDIO	
#define XMLFORMAT_EVENT_ALARMDISPLAY_ACTION_DISPLAY	XMLFORMAT_CALENDAR_ALARM_ACTION_DISPLAY	
#define XMLFORMAT_EVENT_ALARMDISPLAY_ACTION_EMAIL	XMLFORMAT_CALENDAR_ALARM_ACTION_EMAIL	
#define XMLFORMAT_EVENT_ALARMDISPLAY_ACTION_PROCEDURE	XMLFORMAT_CALENDAR_ALARM_ACTION_PROCEDURE	
#define XMLFORMAT_EVENT_ALARMDISPLAY_ATTACH		XMLFORMAT_CALENDAR_ALARM_ATTACH	
#define XMLFORMAT_EVENT_ALARMDISPLAY_ATTENDEE		XMLFORMAT_CALENDAR_ALARM_ATTENDEE
#define XMLFORMAT_EVENT_ALARMDISPLAY_DESCRIPTION	XMLFORMAT_CALENDAR_ALARM_DESCRIPTION
#define XMLFORMAT_EVENT_ALARMDISPLAY_REPEAT		XMLFORMAT_CALENDAR_ALARM_REPEAT	
#define XMLFORMAT_EVENT_ALARMDISPLAY_REPEATDURATION	XMLFORMAT_CALENDAR_ALARM_REPEATDURATION
#define XMLFORMAT_EVENT_ALARMDISPLAY_SUMMARY		XMLFORMAT_CALENDAR_ALARM_SUMMARY
#define XMLFORMAT_EVENT_ALARMDISPLAY_TRIGGER		XMLFORMAT_CALENDAR_ALARM_TRIGGER
#define XMLFORMAT_EVENT_ALARMDISPLAY_VALUE		XMLFORMAT_CALENDAR_ALARM_VALUE
#define XMLFORMAT_EVENT_ALARMDISPLAY_VALUE_DATETIME	XMLFORMAT_CALENDAR_TRIGGERTYPE_DATETIME
#define XMLFORMAT_EVENT_ALARMDISPLAY_VALUE_DURATION	XMLFORMAT_CALENDAR_TRIGGERTYPE_DURATION
#define XMLFORMAT_EVENT_ALARMDISPLAY_RELATEDTYPE	XMLFORMAT_CALENDAR_ALARM_RELATEDTYPE
#define XMLFORMAT_EVENT_ALARMDISPLAY_RELATEDTYPE_START	XMLFORMAT_CALENDAR_RELATEDTYPE_START
#define XMLFORMAT_EVENT_ALARMDISPLAY_RELATEDTYPE_END	XMLFORMAT_CALENDAR_RELATEDTYPE_END
#define XMLFORMAT_EVENT_ALARMDISPLAY_ALTERNATIVETEXTREP	XMLFORMAT_CALENDAR_ALARM_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_ALARMDISPLAY_LANGUAGE		XMLFORMAT_CALENDAR_ALARM_LANGUAGE
#define XMLFORMAT_EVENT_ALARMDISPLAY_ATTACHVALUE	XMLFORMAT_CALENDAR_ALARM_ATTACHVALUE
#define XMLFORMAT_EVENT_ALARMDISPLAY_ATTACHVALUE_URI	XMLFORMAT_CALENDAR_ATTACHMENTTYPE_URI
#define XMLFORMAT_EVENT_ALARMDISPLAY_ATTACHVALUE_BINARY	XMLFORMAT_CALENDAR_ATTACHMENTTYPE_BINARY
#define XMLFORMAT_EVENT_ALARMDISPLAY_FORMATTYPE		XMLFORMAT_CALENDAR_ALARM_FORMATTYPE
#define XMLFORMAT_EVENT_ALARMDISPLAY_ENCODING		XMLFORMAT_CALENDAR_ALARM_ENCODING

// AlarmEmail
#define XMLFORMAT_EVENT_ALARMEMAIL			"AlarmEmail"						// Type Alarm
#define XMLFORMAT_EVENT_ALARMEMAIL_ACTION		XMLFORMAT_CALENDAR_ALARM_ACTION
#define XMLFORMAT_EVENT_ALARMEMAIL_ACTION_AUDIO		XMLFORMAT_CALENDAR_ALARM_ACTION_AUDIO	
#define XMLFORMAT_EVENT_ALARMEMAIL_ACTION_DISPLAY	XMLFORMAT_CALENDAR_ALARM_ACTION_DISPLAY	
#define XMLFORMAT_EVENT_ALARMEMAIL_ACTION_EMAIL		XMLFORMAT_CALENDAR_ALARM_ACTION_EMAIL	
#define XMLFORMAT_EVENT_ALARMEMAIL_ACTION_PROCEDURE	XMLFORMAT_CALENDAR_ALARM_ACTION_PROCEDURE	
#define XMLFORMAT_EVENT_ALARMEMAIL_ATTACH		XMLFORMAT_CALENDAR_ALARM_ATTACH	
#define XMLFORMAT_EVENT_ALARMEMAIL_ATTENDEE		XMLFORMAT_CALENDAR_ALARM_ATTENDEE
#define XMLFORMAT_EVENT_ALARMEMAIL_DESCRIPTION		XMLFORMAT_CALENDAR_ALARM_DESCRIPTION
#define XMLFORMAT_EVENT_ALARMEMAIL_REPEAT		XMLFORMAT_CALENDAR_ALARM_REPEAT	
#define XMLFORMAT_EVENT_ALARMEMAIL_REPEATDURATION	XMLFORMAT_CALENDAR_ALARM_REPEATDURATION
#define XMLFORMAT_EVENT_ALARMEMAIL_SUMMARY		XMLFORMAT_CALENDAR_ALARM_SUMMARY
#define XMLFORMAT_EVENT_ALARMEMAIL_TRIGGER		XMLFORMAT_CALENDAR_ALARM_TRIGGER
#define XMLFORMAT_EVENT_ALARMEMAIL_VALUE		XMLFORMAT_CALENDAR_ALARM_VALUE
#define XMLFORMAT_EVENT_ALARMEMAIL_VALUE_DATETIME	XMLFORMAT_CALENDAR_TRIGGERTYPE_DATETIME
#define XMLFORMAT_EVENT_ALARMEMAIL_VALUE_DURATION	XMLFORMAT_CALENDAR_TRIGGERTYPE_DURATION
#define XMLFORMAT_EVENT_ALARMEMAIL_RELATEDTYPE		XMLFORMAT_CALENDAR_ALARM_RELATEDTYPE
#define XMLFORMAT_EVENT_ALARMEMAIL_RELATEDTYPE_START	XMLFORMAT_CALENDAR_RELATEDTYPE_START
#define XMLFORMAT_EVENT_ALARMEMAIL_RELATEDTYPE_END	XMLFORMAT_CALENDAR_RELATEDTYPE_END
#define XMLFORMAT_EVENT_ALARMEMAIL_ALTERNATIVETEXTREP	XMLFORMAT_CALENDAR_ALARM_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_ALARMEMAIL_LANGUAGE		XMLFORMAT_CALENDAR_ALARM_LANGUAGE
#define XMLFORMAT_EVENT_ALARMEMAIL_ATTACHVALUE		XMLFORMAT_CALENDAR_ALARM_ATTACHVALUE
#define XMLFORMAT_EVENT_ALARMEMAIL_ATTACHVALUE_URI	XMLFORMAT_CALENDAR_ATTACHMENTTYPE_URI
#define XMLFORMAT_EVENT_ALARMEMAIL_ATTACHVALUE_BINARY	XMLFORMAT_CALENDAR_ATTACHMENTTYPE_BINARY
#define XMLFORMAT_EVENT_ALARMEMAIL_FORMATTYPE		XMLFORMAT_CALENDAR_ALARM_FORMATTYPE
#define XMLFORMAT_EVENT_ALARMEMAIL_ENCODING		XMLFORMAT_CALENDAR_ALARM_ENCODING

// AlarmProcedure
#define XMLFORMAT_EVENT_ALARMPROCEDURE			"AlarmProcedure"					// Type Alarm
#define XMLFORMAT_EVENT_ALARMPROCEDURE_ACTION		XMLFORMAT_CALENDAR_ALARM_ACTION
#define XMLFORMAT_EVENT_ALARMPROCEDURE_ACTION_AUDIO	XMLFORMAT_CALENDAR_ALARM_ACTION_AUDIO	
#define XMLFORMAT_EVENT_ALARMPROCEDURE_ACTION_DISPLAY	XMLFORMAT_CALENDAR_ALARM_ACTION_DISPLAY	
#define XMLFORMAT_EVENT_ALARMPROCEDURE_ACTION_EMAIL	XMLFORMAT_CALENDAR_ALARM_ACTION_EMAIL	
#define XMLFORMAT_EVENT_ALARMPROCEDURE_ACTION_PROCEDURE	XMLFORMAT_CALENDAR_ALARM_ACTION_PROCEDURE	
#define XMLFORMAT_EVENT_ALARMPROCEDURE_ATTACH		XMLFORMAT_CALENDAR_ALARM_ATTACH	
#define XMLFORMAT_EVENT_ALARMPROCEDURE_ATTENDEE		XMLFORMAT_CALENDAR_ALARM_ATTENDEE
#define XMLFORMAT_EVENT_ALARMPROCEDURE_DESCRIPTION	XMLFORMAT_CALENDAR_ALARM_DESCRIPTION
#define XMLFORMAT_EVENT_ALARMPROCEDURE_REPEAT		XMLFORMAT_CALENDAR_ALARM_REPEAT	
#define XMLFORMAT_EVENT_ALARMPROCEDURE_REPEATDURATION	XMLFORMAT_CALENDAR_ALARM_REPEATDURATION
#define XMLFORMAT_EVENT_ALARMPROCEDURE_SUMMARY		XMLFORMAT_CALENDAR_ALARM_SUMMARY
#define XMLFORMAT_EVENT_ALARMPROCEDURE_TRIGGER		XMLFORMAT_CALENDAR_ALARM_TRIGGER
#define XMLFORMAT_EVENT_ALARMPROCEDURE_VALUE		XMLFORMAT_CALENDAR_ALARM_VALUE
#define XMLFORMAT_EVENT_ALARMPROCEDURE_VALUE_DATETIME	XMLFORMAT_CALENDAR_TRIGGERTYPE_DATETIME
#define XMLFORMAT_EVENT_ALARMPROCEDURE_VALUE_DURATION	XMLFORMAT_CALENDAR_TRIGGERTYPE_DURATION
#define XMLFORMAT_EVENT_ALARMPROCEDURE_RELATEDTYPE	XMLFORMAT_CALENDAR_ALARM_RELATEDTYPE
#define XMLFORMAT_EVENT_ALARMPROCEDURE_RELATEDTYPE_START	XMLFORMAT_CALENDAR_RELATEDTYPE_START
#define XMLFORMAT_EVENT_ALARMPROCEDURE_RELATEDTYPE_END	XMLFORMAT_CALENDAR_RELATEDTYPE_END
#define XMLFORMAT_EVENT_ALARMPROCEDURE_ALTERNATIVETEXTREP	XMLFORMAT_CALENDAR_ALARM_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_ALARMPROCEDURE_LANGUAGE		XMLFORMAT_CALENDAR_ALARM_LANGUAGE
#define XMLFORMAT_EVENT_ALARMPROCEDURE_ATTACHVALUE	XMLFORMAT_CALENDAR_ALARM_ATTACHVALUE
#define XMLFORMAT_EVENT_ALARMPROCEDURE_ATTACHVALUE_URI	XMLFORMAT_CALENDAR_ATTACHMENTTYPE_URI
#define XMLFORMAT_EVENT_ALARMPROCEDURE_ATTACHVALUE_BINARY	XMLFORMAT_CALENDAR_ATTACHMENTTYPE_BINARY
#define XMLFORMAT_EVENT_ALARMPROCEDURE_FORMATTYPE	XMLFORMAT_CALENDAR_ALARM_FORMATTYPE
#define XMLFORMAT_EVENT_ALARMPROCEDURE_ENCODING		XMLFORMAT_CALENDAR_ALARM_ENCODING

// Attach
#define XMLFORMAT_EVENT_ATTACH				"Attach"						// Type Attachment
#define XMLFORMAT_EVENT_ATTACH_CONTENT			XMLFORMAT_CALENDAR_ATTACHMENT_CONTENT
#define XMLFORMAT_EVENT_ATTACH_VALUE			XMLFORMAT_CALENDAR_ATTACHMENT_VALUE
#define XMLFORMAT_EVENT_ATTACH_VALUE_URI		XMLFORMAT_CALENDAR_ATTACHMENTTYPE_URI	
#define XMLFORMAT_EVENT_ATTACH_VALUE_BINARY		XMLFORMAT_CALENDAR_ATTACHMENTTYPE_BINARY
#define XMLFORMAT_EVENT_ATTACH_FORMATTYPE		XMLFORMAT_CALENDAR_ATTACHMENT_FORMATTYPE
#define XMLFORMAT_EVENT_ATTACH_ENCODING			XMLFORMAT_CALENDAR_ATTACHMENT_ENCODING

// Attendee
#define XMLFORMAT_EVENT_ATTENDEE			"Attendee"						// Type Attendee
#define XMLFORMAT_EVENT_ATTENDEE_CONTENT		XMLFORMAT_CALENDAR_ATTENDEE_CONTENT
#define XMLFORMAT_EVENT_ATTENDEE_CUTYPE			XMLFORMAT_CALENDAR_ATTENDEE_CUTYPE
#define XMLFORMAT_EVENT_ATTENDEE_CUTYPE_INDIVIDUAL	XMLFORMAT_CALENDAR_CALENDARUSERTYPE_INDIVIDUAL
#define XMLFORMAT_EVENT_ATTENDEE_CUTYPE_GROUP		XMLFORMAT_CALENDAR_CALENDARUSERTYPE_GROUP
#define XMLFORMAT_EVENT_ATTENDEE_CUTYPE_RESOURCE	XMLFORMAT_CALENDAR_CALENDARUSERTYPE_RESOURCE
#define XMLFORMAT_EVENT_ATTENDEE_CUTYPE_ROOM		XMLFORMAT_CALENDAR_CALENDARUSERTYPE_ROOM	
#define XMLFORMAT_EVENT_ATTENDEE_CUTYPE_UNKNOWN		XMLFORMAT_CALENDAR_CALENDARUSERTYPE_UNKNOWN
#define XMLFORMAT_EVENT_ATTENDEE_MEMBER			XMLFORMAT_CALENDAR_ATTENDEE_MEMBER
#define XMLFORMAT_EVENT_ATTENDEE_ROLE			XMLFORMAT_CALENDAR_ATTENDEE_ROLE
#define XMLFORMAT_EVENT_ATTENDEE_ROLE_NEEDSACTION	XMLFORMAT_CALENDAR_ROLETYPE_NEEDSACTION
#define XMLFORMAT_EVENT_ATTENDEE_ROLE_ACCEPTED		XMLFORMAT_CALENDAR_ROLETYPE_ACCEPTED
#define XMLFORMAT_EVENT_ATTENDEE_ROLE_DECLINED		XMLFORMAT_CALENDAR_ROLETYPE_DECLINED
#define XMLFORMAT_EVENT_ATTENDEE_ROLE_TENTATIVE		XMLFORMAT_CALENDAR_ROLETYPE_TENTATIVE
#define XMLFORMAT_EVENT_ATTENDEE_ROLE_DELEGATED		XMLFORMAT_CALENDAR_ROLETYPE_DELEGATED
#define XMLFORMAT_EVENT_ATTENDEE_PARTSTAT		XMLFORMAT_CALENDAR_ATTENDEE_PARTSTAT
#define XMLFORMAT_EVENT_ATTENDEE_RSVP			XMLFORMAT_CALENDAR_ATTENDEE_RSVP
#define XMLFORMAT_EVENT_ATTENDEE_DELEGATEDFROM		XMLFORMAT_CALENDAR_ATTENDEE_DELEGATEDFROM
#define XMLFORMAT_EVENT_ATTENDEE_SENTBY			XMLFORMAT_CALENDAR_ATTENDEE_SENTBY
#define XMLFORMAT_EVENT_ATTENDEE_COMMONNAME		XMLFORMAT_CALENDAR_ATTENDEE_COMMONNAME
#define XMLFORMAT_EVENT_ATTENDEE_DIRECTORY		XMLFORMAT_CALENDAR_ATTENDEE_DIRECTORY
#define XMLFORMAT_EVENT_ATTENDEE_LANGUAGE		XMLFORMAT_CALENDAR_ATTENDEE_LANGUAGE

// CalendarScale
#define XMLFORMAT_EVENT_CALENDARSCALE			"CalendarScale"
#define XMLFORMAT_EVENT_CALENDARSCALE_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Categories
#define XMLFORMAT_EVENT_CATEGORIES			"Categories"						// Type Categories
#define XMLFORMAT_EVENT_CATEGORIES_CATEGORY		XMLFORMAT_COMMON_CATEGORIES_CATEGORY

// Class
#define XMLFORMAT_EVENT_CLASS				"Class"							// Type Class
#define XMLFORMAT_EVENT_CLASS_CONTENT			XMLFORMAT_COMMON_CLASS_CONTENT
#define XMLFORMAT_EVENT_CLASS_CONTENT_PUBLIC		XMLFORMAT_COMMON_CLASS_CONTENT_PUBLIC
#define XMLFORMAT_EVENT_CLASS_CONTENT_PRIVATE		XMLFORMAT_COMMON_CLASS_CONTENT_PRIVATE
#define XMLFORMAT_EVENT_CLASS_CONTENT_CONFIDENTIAL	XMLFORMAT_COMMON_CLASS_CONTENT_CONFIDENTIAL

// Comment
#define XMLFORMAT_EVENT_COMMENT				"Comment"						// Type MultiText
#define XMLFORMAT_EVENT_COMMENT_CONTENT			XMLFORMAT_COMMON_MULTITEXT_CONTENT
#define XMLFORMAT_EVENT_COMMENT_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_COMMENT_LANGUAGE		XMLFORMAT_COMMON_MULTITEXT_LANGUAGE

// Contact
#define XMLFORMAT_EVENT_CONTACT				"Contact"						// Type MultiText
#define XMLFORMAT_EVENT_CONTACT_CONTENT			XMLFORMAT_COMMON_MULTITEXT_CONTENT
#define XMLFORMAT_EVENT_CONTACT_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_CONTACT_LANGUAGE		XMLFORMAT_COMMON_MULTITEXT_LANGUAGE

// Created
#define XMLFORMAT_EVENT_CREATED				"Created"						// Type DateTimeContent
#define XMLFORMAT_EVENT_CREATED_CONTENT			XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_EVENT_CREATED_VALUE			XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_EVENT_CREATED_VALUE_DATE		XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_EVENT_CREATED_VALUE_DATETIME		XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_EVENT_CREATED_TIMEZONEID		XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID

// DateCalendarCreated
#define XMLFORMAT_EVENT_DATECALENDARCREATED		"DateCalendarCreated"					// Type DateTimeContent
#define XMLFORMAT_EVENT_DATECALENDARCREATED_CONTENT	XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_EVENT_DATECALENDARCREATED_VALUE	XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_EVENT_DATECALENDARCREATED_VALUE_DATE	XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_EVENT_DATECALENDARCREATED_VALUE_DATETIME	XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_EVENT_DATECALENDARCREATED_TIMEZONEID	XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID

// DateEnd
#define XMLFORMAT_EVENT_DATEEND				"DateEnd"						// Type DateTimeContent
#define XMLFORMAT_EVENT_DATEEND_CONTENT			XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_EVENT_DATEEND_VALUE			XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_EVENT_DATEEND_VALUE_DATE		XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_EVENT_DATEEND_VALUE_DATETIME		XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_EVENT_DATEEND_TIMEZONEID		XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID

// DateStarted
#define XMLFORMAT_EVENT_DATESTARTED			"DateStarted"						// Type DateTimeContent
#define XMLFORMAT_EVENT_DATESTARTED_CONTENT		XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_EVENT_DATESTARTED_VALUE		XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_EVENT_DATESTARTED_VALUE_DATE		XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_EVENT_DATESTARTED_VALUE_DATETIME	XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_EVENT_DATESTARTED_TIMEZONEID		XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID

// Description
#define XMLFORMAT_EVENT_DESCRIPTION			"Description"						// Type MultiText
#define XMLFORMAT_EVENT_DESCRIPTION_CONTENT		XMLFORMAT_COMMON_MULTITEXT_CONTENT
#define XMLFORMAT_EVENT_DESCRIPTION_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_DESCRIPTION_LANGUAGE		XMLFORMAT_COMMON_MULTITEXT_LANGUAGE

// Duration
#define XMLFORMAT_EVENT_DURATION			"Duration"						// Type Duration
#define XMLFORMAT_EVENT_DURATION_INADVANCE		XMLFORMAT_CALENDAR_DURATION_INADVANCE
#define XMLFORMAT_EVENT_DURATION_WEEKS			XMLFORMAT_CALENDAR_DURATION_WEEKS
#define XMLFORMAT_EVENT_DURATION_DAYS			XMLFORMAT_CALENDAR_DURATION_DAYS
#define XMLFORMAT_EVENT_DURATION_HOURS			XMLFORMAT_CALENDAR_DURATION_HOURS
#define XMLFORMAT_EVENT_DURATION_MINUTES		XMLFORMAT_CALENDAR_DURATION_MINUTES
#define XMLFORMAT_EVENT_DURATION_SECONDS		XMLFORMAT_CALENDAR_DURATION_SECONDS

// ExceptionDateTime
#define XMLFORMAT_EVENT_EXCEPTIONDATETIME		"ExceptionDateTime"
#define XMLFORMAT_EVENT_EXCEPTIONDATETIME_CONTENT	XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT		// Type DateTimeContent
#define XMLFORMAT_EVENT_EXCEPTIONDATETIME_VALUE		XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_EVENT_EXCEPTIONDATETIME_VALUE_DATE	XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_EVENT_EXCEPTIONDATETIME_VALUE_DATETIME	XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_EVENT_EXCEPTIONDATETIME_TIMEZONEID	XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID

// ExceptionRule
#define XMLFORMAT_EVENT_EXCEPTIONRULE			"ExceptionRule"						// Type ReccurenceRule
#define XMLFORMAT_EVENT_EXCEPTIONRULE_FREQUENCY		XMLFORMAT_CALENDAR_RECURRENCERULE_FREQUENCY
#define XMLFORMAT_EVENT_EXCEPTIONRULE_FREQUENCY_DAILY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_DAILY
#define XMLFORMAT_EVENT_EXCEPTIONRULE_FREQUENCY_WEEKLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_WEEKLY
#define XMLFORMAT_EVENT_EXCEPTIONRULE_FREQUENCY_MONTHLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_MONTHLY
#define XMLFORMAT_EVENT_EXCEPTIONRULE_FREQUENCY_YEARLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_YEARLY
#define XMLFORMAT_EVENT_EXCEPTIONRULE_UNTIL		XMLFORMAT_CALENDAR_RECURRENCERULE_UNTIL
#define XMLFORMAT_EVENT_EXCEPTIONRULE_COUNT		XMLFORMAT_CALENDAR_RECURRENCERULE_COUNT
#define XMLFORMAT_EVENT_EXCEPTIONRULE_INTERVAL		XMLFORMAT_CALENDAR_RECURRENCERULE_INTERVAL
#define XMLFORMAT_EVENT_EXCEPTIONRULE_BYDAY		XMLFORMAT_CALENDAR_RECURRENCERULE_BYDAY
#define XMLFORMAT_EVENT_EXCEPTIONRULE_BYMONTHDAY	XMLFORMAT_CALENDAR_RECURRENCERULE_BYMONTHDAY
#define XMLFORMAT_EVENT_EXCEPTIONRULE_BYYEARDAY		XMLFORMAT_CALENDAR_RECURRENCERULE_BYYEARDAY
#define XMLFORMAT_EVENT_EXCEPTIONRULE_BYMONTH		XMLFORMAT_CALENDAR_RECURRENCERULE_BYMONTH
#define XMLFORMAT_EVENT_EXCEPTIONRULE_TIMEZONEID	XMLFORMAT_CALENDAR_RECURRENCERULE_TIMEZONEID
#define XMLFORMAT_EVENT_EXCEPTIONRULE_TZCOMPONENT	XMLFORMAT_CALENDAR_RECURRENCERULE_TZCOMPONENT

// ExceptionRuleExtended
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED		"ExceptionRuleExtended"					// Type RecurrenceRuleExtended
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_FREQUENCY	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_FREQUENCY
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_UNTIL	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_UNTIL
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_COUNT	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_COUNT
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_INTERVAL	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_INTERVAL
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_BYSECOND	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYSECOND
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_BYMINUTE	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYMINUTE
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_BYHOUR	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYHOUR
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_BYDAY	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYDAY
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_BYMONTHDAY		XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYMONTHDAY
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_BYYEARDAY	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYYEARDAY
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_BYWEEKNO	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYWEEKNO
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_BYMONTH	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYMONTH
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_BYSETPOS	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYSETPOS
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_WKST	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_WKST
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_WKST_SUNDAY		XMLFORMAT_CALENDAR_WEEKDAY_SUNDAY
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_WKST_MONDAY		XMLFORMAT_CALENDAR_WEEKDAY_MONDAY
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_WKST_TUESDAY		XMLFORMAT_CALENDAR_WEEKDAY_TUESDAY
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_WKST_WEDNESDAY		XMLFORMAT_CALENDAR_WEEKDAY_WEDNESDAY
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_WKST_THURSDAY		XMLFORMAT_CALENDAR_WEEKDAY_THURSDAY
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_WKST_FRIDAY		XMLFORMAT_CALENDAR_WEEKDAY_FRIDAY
#define XMLFORMAT_EVENT_EXCEPTIONRULEEXTENDED_WKST_SATURDAY		XMLFORMAT_CALENDAR_WEEKDAY_SATURDAY

// FreeBusy
#define XMLFORMAT_EVENT_FREEBUSY			"FreeBusy"						// Type FreeBusy
#define XMLFORMAT_EVENT_FREEBUSY_ATTENDEE		XMLFORMAT_CALENDAR_FREEBUSY_ATTENDEE
#define XMLFORMAT_EVENT_FREEBUSY_ATTENDEE_CONTENT	XMLFORMAT_CALENDAR_ATTACHMENT_CONTENT
#define XMLFORMAT_EVENT_FREEBUSY_ATTENDEE_VALUE		XMLFORMAT_CALENDAR_ATTACHMENT_VALUE
#define XMLFORMAT_EVENT_FREEBUSY_ATTENDEE_VALUE_URI	XMLFORMAT_CALENDAR_ATTACHMENTTYPE_URI	
#define XMLFORMAT_EVENT_FREEBUSY_ATTENDEE_VALUE_BINARY	XMLFORMAT_CALENDAR_ATTACHMENTTYPE_BINARY
#define XMLFORMAT_EVENT_FREEBUSY_ATTENDEE_FORMATTYPE	XMLFORMAT_CALENDAR_ATTACHMENT_FORMATTYPE
#define XMLFORMAT_EVENT_FREEBUSY_ATTENDEE_ENCODING	XMLFORMAT_CALENDAR_ATTACHMENT_ENCODING
#define XMLFORMAT_EVENT_FREEBUSY_CONTACT		XMLFORMAT_CALENDAR_FREEBUSY_CONTACT
#define XMLFORMAT_EVENT_FREEBUSY_CONTACT_CONTENT	XMLFORMAT_COMMON_MULTITEXT_CONTENT
#define XMLFORMAT_EVENT_FREEBUSY_CONTACT_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_FREEBUSY_CONTACT_LANGUAGE	XMLFORMAT_COMMON_MULTITEXT_LANGUAGE
#define XMLFORMAT_EVENT_FREEBUSY_COMMENT		XMLFORMAT_CALENDAR_FREEBUSY_COMMENT
#define XMLFORMAT_EVENT_FREEBUSY_COMMENT_CONTENT	XMLFORMAT_COMMON_MULTITEXT_CONTENT
#define XMLFORMAT_EVENT_FREEBUSY_COMMENT_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_FREEBUSY_COMMENT_LANGUAGE	XMLFORMAT_COMMON_MULTITEXT_LANGUAGE
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT		XMLFORMAT_CALENDAR_FREEBUSY_CONTENT
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_TYPE		XMLFORMAT_CALENDAR_FREEBUSYELEMENT_TYPE
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_TYPE_STATUSCODE	XMLFORMAT_CALENDAR_REQUESTSTATUS_STATUSCODE
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_TYPE_STATUSDESCRIPTION XMLFORMAT_CALENDAR_REQUESTSTATUS_STATUSDESCRIPTION
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_TYPE_EXCEPTIONDATA	XMLFORMAT_CALENDAR_REQUESTSTATUS_EXCEPTIONDATA
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_TYPE_TIMEZONEID	XMLFORMAT_CALENDAR_REQUESTSTATUS_TIMEZONEID
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_TYPE_RELATIONSHIPTYPE	XMLFORMAT_CALENDAR_REQUESTSTATUS_RELATIONSHIPTYPE
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_TYPE_RELATIONSHIPTYPE_PARENT	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_PARENT
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_TYPE_RELATIONSHIPTYPE_CHILD	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_CHILD
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_TYPE_RELATIONSHIPTYPE_SIBLING	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_SIBLING
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD		XMLFORMAT_CALENDAR_FREEBUSYELEMENT_PERIOD
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_START	XMLFORMAT_CALENDAR_PERIOD_START
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_START_CONTENT	XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_START_VALUE	XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_START_VALUE_DATE	XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_START_VALUE_DATETIME	XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_START_TIMEZONEID	XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_DURATION	XMLFORMAT_CALENDAR_PERIOD_DURATION
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_DURATION_INADVANCE	XMLFORMAT_CALENDAR_DURATION_INADVANCE
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_DURATION_WEEKS	XMLFORMAT_CALENDAR_DURATION_WEEKS
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_DURATION_DAYS	XMLFORMAT_CALENDAR_DURATION_DAYS
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_DURATION_HOURS	XMLFORMAT_CALENDAR_DURATION_HOURS
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_DURATION_MINUTES	XMLFORMAT_CALENDAR_DURATION_MINUTES
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_DURATION_SECONDS	XMLFORMAT_CALENDAR_DURATION_SECONDS
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_END	XMLFORMAT_CALENDAR_PERIOD_END
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_END_CONTENT	XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_END_VALUE	XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_END_VALUE_DATE	XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_END_VALUE_DATETIME	XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_EVENT_FREEBUSY_CONTENT_PERIOD_END_TIMEZONEID	XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID
#define XMLFORMAT_EVENT_FREEBUSY_DATEEND		XMLFORMAT_CALENDAR_FREEBUSY_DATEEND
#define XMLFORMAT_EVENT_FREEBUSY_DATEEND_CONTENT		XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_EVENT_FREEBUSY_DATEEND_VALUE			XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_EVENT_FREEBUSY_DATEEND_VALUE_DATE		XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_EVENT_FREEBUSY_DATEEND_VALUE_DATETIME		XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_EVENT_FREEBUSY_DATEEND_TIMEZONEID		XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID
#define XMLFORMAT_EVENT_FREEBUSY_DATESTAMP		XMLFORMAT_CALENDAR_FREEBUSY_DATESTAMP
#define XMLFORMAT_EVENT_FREEBUSY_DATESTAMP_CONTENT	XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_EVENT_FREEBUSY_DATESTAMP_VALUE	XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_EVENT_FREEBUSY_DATESTAMP_VALUE_DATE	XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_EVENT_FREEBUSY_DATESTAMP_VALUE_DATETIME		XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_EVENT_FREEBUSY_DATESTAMP_TIMEZONEID	XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID
#define XMLFORMAT_EVENT_FREEBUSY_DATESTARTED		XMLFORMAT_CALENDAR_FREEBUSY_DATESTARTED
#define XMLFORMAT_EVENT_FREEBUSY_DATESTARTED_CONTENT		XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_EVENT_FREEBUSY_DATESTARTED_VALUE		XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_EVENT_FREEBUSY_DATESTARTED_VALUE_DATE		XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_EVENT_FREEBUSY_DATESTARTED_VALUE_DATETIME	XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME
#define XMLFORMAT_EVENT_FREEBUSY_DATESTARTED_TIMEZONEID		XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID
#define XMLFORMAT_EVENT_FREEBUSY_DURATION		XMLFORMAT_CALENDAR_FREEBUSY_DURATION
#define XMLFORMAT_EVENT_FREEBUSY_DURATION_INADVANCE	XMLFORMAT_CALENDAR_DURATION_INADVANCE
#define XMLFORMAT_EVENT_FREEBUSY_DURATION_WEEKS		XMLFORMAT_CALENDAR_DURATION_WEEKS
#define XMLFORMAT_EVENT_FREEBUSY_DURATION_DAYS		XMLFORMAT_CALENDAR_DURATION_DAYS
#define XMLFORMAT_EVENT_FREEBUSY_DURATION_HOURS		XMLFORMAT_CALENDAR_DURATION_HOURS
#define XMLFORMAT_EVENT_FREEBUSY_DURATION_MINUTES	XMLFORMAT_CALENDAR_DURATION_MINUTES
#define XMLFORMAT_EVENT_FREEBUSY_DURATION_SECONDS	XMLFORMAT_CALENDAR_DURATION_SECONDS
#define XMLFORMAT_EVENT_FREEBUSY_ORGANIZER		XMLFORMAT_CALENDAR_FREEBUSY_ORGANIZER
#define XMLFORMAT_EVENT_FREEBUSY_ORGANIZER_CONTENT	XMLFORMAT_CALENDAR_ORGANIZER_CONTENT
#define XMLFORMAT_EVENT_FREEBUSY_ORGANIZER_COMMONNAME	XMLFORMAT_CALENDAR_ORGANIZER_COMMONNAME
#define XMLFORMAT_EVENT_FREEBUSY_ORGANIZER_DIRECTORY	XMLFORMAT_CALENDAR_ORGANIZER_DIRECTORY
#define XMLFORMAT_EVENT_FREEBUSY_ORGANIZER_SENTBY	XMLFORMAT_CALENDAR_ORGANIZER_SENTBY
#define XMLFORMAT_EVENT_FREEBUSY_ORGANIZER_LANGUAGE	XMLFORMAT_CALENDAR_ORGANIZER_LANGUAGE
#define XMLFORMAT_EVENT_FREEBUSY_RSTATUS		XMLFORMAT_CALENDAR_FREEBUSY_RSTATUS
#define XMLFORMAT_EVENT_FREEBUSY_RSTATUS_STATUSCODE	XMLFORMAT_CALENDAR_REQUESTSTATUS_STATUSCODE
#define XMLFORMAT_EVENT_FREEBUSY_RSTATUS_STATUSDESCRIPTION	XMLFORMAT_CALENDAR_REQUESTSTATUS_STATUSDESCRIPTION
#define XMLFORMAT_EVENT_FREEBUSY_RSTATUS_EXCEPTIONDATA		XMLFORMAT_CALENDAR_REQUESTSTATUS_EXCEPTIONDATA
#define XMLFORMAT_EVENT_FREEBUSY_RSTATUS_TIMEZONEID	XMLFORMAT_CALENDAR_REQUESTSTATUS_TIMEZONEID
#define XMLFORMAT_EVENT_FREEBUSY_RSTATUS_RELATIONSHIPTYPE		XMLFORMAT_CALENDAR_REQUESTSTATUS_RELATIONSHIPTYPE
#define XMLFORMAT_EVENT_FREEBUSY_RSTATUS_RELATIONSHIPTYPE_PARENT	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_PARENT
#define XMLFORMAT_EVENT_FREEBUSY_RSTATUS_RELATIONSHIPTYPE_CHILD	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_CHILD
#define XMLFORMAT_EVENT_FREEBUSY_RSTATUS_RELATIONSHIPTYPE_SIBLING	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_SIBLING
#define XMLFORMAT_EVENT_FREEBUSY_UID			XMLFORMAT_CALENDAR_FREEBUSY_UID
#define XMLFORMAT_EVENT_FREEBUSY_UID_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT
#define XMLFORMAT_EVENT_FREEBUSY_URL			XMLFORMAT_CALENDAR_FREEBUSY_URL
#define XMLFORMAT_EVENT_FREEBUSY_URL_CONTENT		XMLFORMAT_CALENDAR_URLCONTENT_CONTENT

// Geo //TODO where is GeoValue defined?
#define XMLFORMAT_EVENT_GEO				"Geo"

// LastModified
#define XMLFORMAT_EVENT_LASTMODIFIED			"LastModified"						// Type DateTimeContent
#define XMLFORMAT_EVENT_LASTMODIFIED_CONTENT		XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_EVENT_LASTMODIFIED_VALUE		XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_EVENT_LASTMODIFIED_TIMEZONEID		XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID

// Location
#define XMLFORMAT_EVENT_LOCATION			"Location"
#define XMLFORMAT_EVENT_LOCATION_CONTENT		XMLFORMAT_COMMON_MULTITEXT_CONTENT			// Type MultiText
#define XMLFORMAT_EVENT_LOCATION_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_LOCATION_LANGUAGE		XMLFORMAT_COMMON_MULTITEXT_LANGUAGE

// Method
#define XMLFORMAT_EVENT_METHOD				"Method"						// Type StringContent
#define XMLFORMAT_EVENT_METHOD_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// NumberRecurrences
#define XMLFORMAT_EVENT_NUMBERRECURRENCES		"NumberRecurrences"					// Type IntegerContent
#define XMLFORMAT_EVENT_NUMBERRECURRENCES_CONTENT	XMLFORMAT_CALENDAR_INTEGERCONTENT_CONTENT

// Organizer
#define XMLFORMAT_EVENT_ORGANIZER			"Organizer"						// Type Organizer
#define XMLFORMAT_EVENT_ORGANIZER_CONTENT		XMLFORMAT_CALENDAR_ORGANIZER_CONTENT
#define XMLFORMAT_EVENT_ORGANIZER_COMMONNAME		XMLFORMAT_CALENDAR_ORGANIZER_COMMONNAME
#define XMLFORMAT_EVENT_ORGANIZER_DIRECTORY		XMLFORMAT_CALENDAR_ORGANIZER_DIRECTORY
#define XMLFORMAT_EVENT_ORGANIZER_SENTBY		XMLFORMAT_CALENDAR_ORGANIZER_SENTBY
#define XMLFORMAT_EVENT_ORGANIZER_LANGUAGE		XMLFORMAT_CALENDAR_ORGANIZER_LANGUAGE

// Priority
#define XMLFORMAT_EVENT_PRIORITY			"Priority"						// Type Priority
#define XMLFORMAT_EVENT_PRIORITY_CONTENT		XMLFORMAT_CALENDAR_PRIORITY_CONTENT
#define XMLFORMAT_EVENT_PRIORITY_CONTENT_MAX		XMLFORMAT_CALENDAR_PRIORITY_CONTENT_MAX
#define XMLFORMAT_EVENT_PRIORITY_CONTENT_MIN		XMLFORMAT_CALENDAR_PRIORITY_CONTENT_MIN

// ProductID
#define XMLFORMAT_EVENT_PRODUCTID			"ProductID"						// Type StringContent
#define XMLFORMAT_EVENT_PRODUCTID_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// RecurrenceDateTime
#define XMLFORMAT_EVENT_RECURRENCEDATETIME		"RecurrenceDateTime"					// Type RecurrenceDateTimeList
#define XMLFORMAT_EVENT_RECURRENCEDATETIME_CONTENT	XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_CONTENT
#define XMLFORMAT_EVENT_RECURRENCEDATETIME_TIMEZONEID	XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_TIMEZONEID
#define XMLFORMAT_EVENT_RECURRENCEDATETIME_VALUE	XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_VALUE
#define XMLFORMAT_EVENT_RECURRENCEDATETIME_VALUE_	XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_VALUE_DATETIME
#define XMLFORMAT_EVENT_RECURRENCEDATETIME_VALUE_DATE	XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_VALUE_DATE
#define XMLFORMAT_EVENT_RECURRENCEDATETIME_VALUE_PERIOD	XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_VALUE_PERIOD

// RecurrenceId
#define XMLFORMAT_EVENT_RECURRENCEID			"RecurrenceId"						// Type RecurrenceId
#define XMLFORMAT_EVENT_RECURRENCEID_CONTENT		XMLFORMAT_CALENDAR_RECURRENCEID_CONTENT	
#define XMLFORMAT_EVENT_RECURRENCEID_TIMEZONEID		XMLFORMAT_CALENDAR_RECURRENCEID_TIMEZONEID
#define XMLFORMAT_EVENT_RECURRENCEID_RANGE		XMLFORMAT_CALENDAR_RECURRENCEID_RANGE
#define XMLFORMAT_EVENT_RECURRENCEID_RANGE_THISANDPRIOR	XMLFORMAT_CALENDAR_RECURRENCEID_RANGE_THISANDPRIOR
#define XMLFORMAT_EVENT_RECURRENCEID_RANGE_THISANDFUTURE	XMLFORMAT_CALENDAR_RECURRENCEID_RANGE_THISANDFUTURE
#define XMLFORMAT_EVENT_RECURRENCEID_VALUE		XMLFORMAT_CALENDAR_RECURRENCEID_VALUE				
#define XMLFORMAT_EVENT_RECURRENCEID_VALUE_DATE		XMLFORMAT_COMMON_DATEVALUETYPE_DATE
#define XMLFORMAT_EVENT_RECURRENCEID_VALUE_DATETIME	XMLFORMAT_COMMON_DATEVALUETYPE_DATETIME

// Related
#define XMLFORMAT_EVENT_RELATED				"Related"						// Type RelatedTo
#define XMLFORMAT_EVENT_RELATED_CONTENT			XMLFORMAT_CALENDAR_RELATEDTO_CONTENT
#define XMLFORMAT_EVENT_RELATED_TIMEZONEID		XMLFORMAT_CALENDAR_RELATEDTO_TIMEZONEID	
#define XMLFORMAT_EVENT_RELATED_RELATIONSHIPTYPE	XMLFORMAT_CALENDAR_RELATEDTO_RELATIONSHIPTYPE
#define XMLFORMAT_EVENT_RELATED_RELATIONSHIPTYPE_PARENT	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_PARENT
#define XMLFORMAT_EVENT_RELATED_RELATIONSHIPTYPE_CHILD	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_CHILD
#define XMLFORMAT_EVENT_RELATED_RELATIONSHIPTYPE_SIBLING	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_SIBLING

// Resources
#define XMLFORMAT_EVENT_RESOURCES			"Resources"						// Type MultiText
#define XMLFORMAT_EVENT_RESOURCES_CONTENT		XMLFORMAT_COMMON_MULTITEXT_CONTENT
#define XMLFORMAT_EVENT_RESOURCES_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_RESOURCES_LANGUAGE		XMLFORMAT_COMMON_MULTITEXT_LANGUAGE

// RecurrenceRule
#define XMLFORMAT_EVENT_RECURRENCERULE			"RecurrenceRule"					// Type RecurrenceRule
#define XMLFORMAT_EVENT_RECURRENCERULE_FREQUENCY	XMLFORMAT_CALENDAR_RECURRENCERULE_FREQUENCY
#define XMLFORMAT_EVENT_RECURRENCERULE_FREQUENCY_DAILY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_DAILY
#define XMLFORMAT_EVENT_RECURRENCERULE_FREQUENCY_WEEKLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_WEEKLY
#define XMLFORMAT_EVENT_RECURRENCERULE_FREQUENCY_MONTHLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_MONTHLY
#define XMLFORMAT_EVENT_RECURRENCERULE_FREQUENCY_YEARLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_YEARLY
#define XMLFORMAT_EVENT_RECURRENCERULE_UNTIL		XMLFORMAT_CALENDAR_RECURRENCERULE_UNTIL
#define XMLFORMAT_EVENT_RECURRENCERULE_COUNT		XMLFORMAT_CALENDAR_RECURRENCERULE_COUNT
#define XMLFORMAT_EVENT_RECURRENCERULE_INTERVAL		XMLFORMAT_CALENDAR_RECURRENCERULE_INTERVAL
#define XMLFORMAT_EVENT_RECURRENCERULE_BYDAY		XMLFORMAT_CALENDAR_RECURRENCERULE_BYDAY
#define XMLFORMAT_EVENT_RECURRENCERULE_BYMONTHDAY	XMLFORMAT_CALENDAR_RECURRENCERULE_BYMONTHDAY
#define XMLFORMAT_EVENT_RECURRENCERULE_BYYEARDAY	XMLFORMAT_CALENDAR_RECURRENCERULE_BYYEARDAY
#define XMLFORMAT_EVENT_RECURRENCERULE_BYMONTH		XMLFORMAT_CALENDAR_RECURRENCERULE_BYMONTH
#define XMLFORMAT_EVENT_RECURRENCERULE_TIMEZONEID	XMLFORMAT_CALENDAR_RECURRENCERULE_TIMEZONEID
#define XMLFORMAT_EVENT_RECURRENCERULE_TZCOMPONENT	XMLFORMAT_CALENDAR_RECURRENCERULE_TZCOMPONENT

// RecurrenceRuleExtended
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED		"RecurrenceRuleExtended"				// Type RecurrenceRuleExtended
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_FREQUENCY	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_FREQUENCY
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_UNTIL	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_UNTIL
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_COUNT	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_COUNT
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_INTERVAL	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_INTERVAL
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_BYSECOND	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYSECOND
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_BYMINUTE	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYMINUTE
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_BYHOUR	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYHOUR
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_BYDAY	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYDAY
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_BYMONTHDAY		XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYMONTHDAY
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_BYYEARDAY	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYYEARDAY
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_BYWEEKNO	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYWEEKNO
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_BYMONTH	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYMONTH
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_BYSETPOS	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_BYSETPOS
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_WKST	XMLFORMAT_CALENDAR_RECURRENCERULEEXTENDED_WKST
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_WKST_SUNDAY		XMLFORMAT_CALENDAR_WEEKDAY_SUNDAY
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_WKST_MONDAY		XMLFORMAT_CALENDAR_WEEKDAY_MONDAY
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_WKST_TUESDAY		XMLFORMAT_CALENDAR_WEEKDAY_TUESDAY
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_WKST_WEDNESDAY		XMLFORMAT_CALENDAR_WEEKDAY_WEDNESDAY
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_WKST_THURSDAY		XMLFORMAT_CALENDAR_WEEKDAY_THURSDAY
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_WKST_FRIDAY		XMLFORMAT_CALENDAR_WEEKDAY_FRIDAY
#define XMLFORMAT_EVENT_RECURRENCERULEEXTENDED_WKST_SATURDAY		XMLFORMAT_CALENDAR_WEEKDAY_SATURDAY

// RStatus
#define XMLFORMAT_EVENT_RSTATUS				"RStatus"						// Type RequestStatus
#define XMLFORMAT_EVENT_RSTATUS_STATUSCODE		XMLFORMAT_CALENDAR_REQUESTSTATUS_STATUSCODE
#define XMLFORMAT_EVENT_RSTATUS_STATUSDESCRIPTION	XMLFORMAT_CALENDAR_REQUESTSTATUS_STATUSDESCRIPTION
#define XMLFORMAT_EVENT_RSTATUS_EXCEPTIONDATA		XMLFORMAT_CALENDAR_REQUESTSTATUS_EXCEPTIONDATA
#define XMLFORMAT_EVENT_RSTATUS_TIMEZONEID		XMLFORMAT_CALENDAR_REQUESTSTATUS_TIMEZONEID
#define XMLFORMAT_EVENT_RSTATUS_RELATIONSHIPTYPE	XMLFORMAT_CALENDAR_REQUESTSTATUS_RELATIONSHIPTYPE
#define XMLFORMAT_EVENT_RSTATUS_RELATIONSHIPTYPE_PARENT	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_PARENT
#define XMLFORMAT_EVENT_RSTATUS_RELATIONSHIPTYPE_CHILD	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_CHILD
#define XMLFORMAT_EVENT_RSTATUS_RELATIONSHIPTYPE_SIBLING	XMLFORMAT_CALENDAR_RELATIONSHIPTYPE_SIBLING

// Sequence
#define XMLFORMAT_EVENT_SEQUENCE			"Sequence"						// Type IntegerContent
#define XMLFORMAT_EVENT_SEQUENCE_CONTENT		XMLFORMAT_CALENDAR_INTEGERCONTENT_CONTENT

// Status
#define XMLFORMAT_EVENT_STATUS				"Status"						
#define XMLFORMAT_EVENT_STATUS_CONTENT			XMLFORMAT_CALENDAR_STATUS_CONTENT			// Type Status
#define XMLFORMAT_EVENT_STATUS_CONTENT_TENTATIVE	XMLFORMAT_CALENDAR_STATUS_CONTENT_TENTATIVE
#define XMLFORMAT_EVENT_STATUS_CONTENT_CONFIRMED	XMLFORMAT_CALENDAR_STATUS_CONTENT_CONFIRMED
#define XMLFORMAT_EVENT_STATUS_CONTENT_CANCELLED	XMLFORMAT_CALENDAR_STATUS_CONTENT_CANCELLED

// Summary
#define XMLFORMAT_EVENT_SUMMARY				"Summary"						// Type MultiText
#define XMLFORMAT_EVENT_SUMMARY_CONTENT			XMLFORMAT_COMMON_MULTITEXT_CONTENT
#define XMLFORMAT_EVENT_SUMMARY_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_SUMMARY_LANGUAGE		XMLFORMAT_COMMON_MULTITEXT_LANGUAGE

// TimeTransparency
#define XMLFORMAT_EVENT_TIMETRANSPARENCY		"TimeTransparency" 					// Type TimeTransparency
#define XMLFORMAT_EVENT_TIMETRANSPARENCY_CONTENT	XMLFORMAT_CALENDAR_TIMETRANSPARENCY_CONTENT
#define XMLFORMAT_EVENT_TIMETRANSPARENCY_CONTENT_OPAQUE	XMLFORMAT_CALENDAR_TIMETRANSPARENCY_CONTENT_OPAQUE
#define XMLFORMAT_EVENT_TIMETRANSPARENCY_CONTENT_TRANSPARENT	XMLFORMAT_CALENDAR_TIMETRANSPARENCY_CONTENT_TRANSPARENT

// Timezone
#define XMLFORMAT_EVENT_TIMEZONE			"Timezone" 						// Type Timezone
#define XMLFORMAT_EVENT_TIMEZONE_LASTMODIFIED		XMLFORMAT_CALENDAR_TIMEZONE_LASTMODIFIED
#define XMLFORMAT_EVENT_TIMEZONE_LASTMODIFIED_CONTENT	XMLFORMAT_COMMON_DATETIMECONTENT_CONTENT
#define XMLFORMAT_EVENT_TIMEZONE_LASTMODIFIED_VALUE	XMLFORMAT_COMMON_DATETIMECONTENT_VALUE
#define XMLFORMAT_EVENT_TIMEZONE_LASTMODIFIED_TIMEZONEID		XMLFORMAT_COMMON_DATETIMECONTENT_TIMEZONEID
#define XMLFORMAT_EVENT_TIMEZONE_TZURL			XMLFORMAT_CALENDAR_TIMEZONE_TZURL
#define XMLFORMAT_EVENT_TIMEZONE_XLOCATION		XMLFORMAT_CALENDAR_TIMEZONE_XLOCATION
#define XMLFORMAT_EVENT_TIMEZONE_TIMEZONEID		XMLFORMAT_CALENDAR_TIMEZONE_TIMEZONEID	
#define XMLFORMAT_EVENT_TIMEZONE_TZCOMPONENT		XMLFORMAT_CALENDAR_TIMEZONE_TZCOMPONENT

// TimezoneComponent
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT		"TimezoneComponent"					// Type TimezoneComponent
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_COMMENT	XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_COMMENT
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_COMMENT_CONTENT	XMLFORMAT_COMMON_MULTITEXT_CONTENT
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_COMMENT_ALTERNATIVETEXTREP	XMLFORMAT_COMMON_MULTITEXT_ALTERNATIVETEXTREP
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_COMMENT_LANGUAGE	XMLFORMAT_COMMON_MULTITEXT_LANGUAGE
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_RECURRENCEDATETIME	XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_RECURRENCEDATETIME
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_CONTENT	XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_CONTENT
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_TIMEZONEID	XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_TIMEZONEID
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_VALUE		XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_VALUE
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_VALUE_DATETIME	XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_VALUE_DATETIME
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_VALUE_DATE	XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_VALUE_DATE
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_VALUE_PERIOD	XMLFORMAT_CALENDAR_RECURRENCEDATETIMELIST_VALUE_PERIOD
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_DATETIMESTART	XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_DATETIMESTART
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_TZNAME	XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_TZNAME
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_TZOFFSETFROM	XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_TZOFFSETFROM
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_TZOFFSETTO	XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_TZOFFSETTO
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_TIMEZONEID	XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_TIMEZONEID
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_TZCOMPONENT	XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_TZCOMPONENT
#define XMLFORMAT_EVENT_TIMEZONECOMPONENT_LANGUAGE	XMLFORMAT_CALENDAR_TIMEZONECOMPONENT_LANGUAGE

// TimezoneRule
#define XMLFORMAT_EVENT_TIMEZONERULE			"TimezoneRule"						// Type ReccurenceRule
#define XMLFORMAT_EVENT_TIMEZONERULE_FREQUENCY		XMLFORMAT_CALENDAR_RECURRENCERULE_FREQUENCY
#define XMLFORMAT_EVENT_TIMEZONERULE_FREQUENCY_DAILY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_DAILY
#define XMLFORMAT_EVENT_TIMEZONERULE_FREQUENCY_WEEKLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_WEEKLY
#define XMLFORMAT_EVENT_TIMEZONERULE_FREQUENCY_MONTHLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_MONTHLY
#define XMLFORMAT_EVENT_TIMEZONERULE_FREQUENCY_YEARLY	XMLFORMAT_CALENDAR_BASICRECURRENCEFREQ_YEARLY
#define XMLFORMAT_EVENT_TIMEZONERULE_UNTIL		XMLFORMAT_CALENDAR_RECURRENCERULE_UNTIL
#define XMLFORMAT_EVENT_TIMEZONERULE_COUNT		XMLFORMAT_CALENDAR_RECURRENCERULE_COUNT
#define XMLFORMAT_EVENT_TIMEZONERULE_INTERVAL		XMLFORMAT_CALENDAR_RECURRENCERULE_INTERVAL
#define XMLFORMAT_EVENT_TIMEZONERULE_BYDAY		XMLFORMAT_CALENDAR_RECURRENCERULE_BYDAY
#define XMLFORMAT_EVENT_TIMEZONERULE_BYMONTHDAY		XMLFORMAT_CALENDAR_RECURRENCERULE_BYMONTHDAY
#define XMLFORMAT_EVENT_TIMEZONERULE_BYYEARDAY		XMLFORMAT_CALENDAR_RECURRENCERULE_BYYEARDAY
#define XMLFORMAT_EVENT_TIMEZONERULE_BYMONTH		XMLFORMAT_CALENDAR_RECURRENCERULE_BYMONTH
#define XMLFORMAT_EVENT_TIMEZONERULE_TIMEZONEID		XMLFORMAT_CALENDAR_RECURRENCERULE_TIMEZONEID
#define XMLFORMAT_EVENT_TIMEZONERULE_TZCOMPONENT	XMLFORMAT_CALENDAR_RECURRENCERULE_TZCOMPONENT

// Uid
#define XMLFORMAT_EVENT_UID				"Uid"							// Type StringContent
#define XMLFORMAT_EVENT_UID_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Url
#define XMLFORMAT_EVENT_URL				"Url"							// Type UrlContent
#define XMLFORMAT_EVENT_URL_CONTENT			XMLFORMAT_CALENDAR_URLCONTENT_CONTENT

// Version
#define XMLFORMAT_EVENT_Version				"Version"						// Type StringContent
#define XMLFORMAT_EVENT_Version_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

#endif /* XMLFORMAT_EVENT_H */
