/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.hssf.util.RangeAddress;
import org.apache.poi.hssf.util.SheetReferences;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Ref3DPtg
extends Ptg {
    public static final byte sid = 58;
    private static final int SIZE = 7;
    private short field_1_index_extern_sheet;
    private short field_2_row;
    private short field_3_column;
    private BitField rowRelative;
    private BitField colRelative;

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Ref3dPtg\n");
        buffer.append("Index to Extern Sheet = " + this.getExternSheetIndex()).append("\n");
        buffer.append("Row = " + this.getRow()).append("\n");
        buffer.append("Col  = " + this.getColumn()).append("\n");
        buffer.append("ColRowRel= " + this.isRowRelative()).append("\n");
        buffer.append("ColRel   = " + this.isColRelative()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(58 + this.ptgClass);
        LittleEndian.putShort(array, 1 + offset, this.getExternSheetIndex());
        LittleEndian.putShort(array, 3 + offset, this.getRow());
        LittleEndian.putShort(array, 5 + offset, this.getColumnRaw());
    }

    public int getSize() {
        return 7;
    }

    public short getExternSheetIndex() {
        return this.field_1_index_extern_sheet;
    }

    public void setExternSheetIndex(short index) {
        this.field_1_index_extern_sheet = index;
    }

    public short getRow() {
        return this.field_2_row;
    }

    public void setRow(short row) {
        this.field_2_row = row;
    }

    public short getColumn() {
        return (short)(this.field_3_column & 0xFF);
    }

    public short getColumnRaw() {
        return this.field_3_column;
    }

    public boolean isRowRelative() {
        return this.rowRelative.isSet(this.field_3_column);
    }

    public void setRowRelative(boolean rel) {
        this.field_3_column = this.rowRelative.setShortBoolean(this.field_3_column, rel);
    }

    public boolean isColRelative() {
        return this.colRelative.isSet(this.field_3_column);
    }

    public void setColRelative(boolean rel) {
        this.field_3_column = this.colRelative.setShortBoolean(this.field_3_column, rel);
    }

    public void setColumn(short column) {
        this.field_3_column = (short)(this.field_3_column & 0xFF00);
        this.field_3_column = (short)(this.field_3_column | column & 0xFF);
    }

    public void setColumnRaw(short column) {
        this.field_3_column = column;
    }

    public void setArea(String ref) {
        RangeAddress ra = new RangeAddress(ref);
        String from = ra.getFromCell();
        this.setColumn((short)(ra.getXPosition(from) - 1));
        this.setRow((short)(ra.getYPosition(from) - 1));
    }

    public String toFormulaString(Workbook book) {
        SheetReferences refs;
        StringBuffer retval = new StringBuffer();
        SheetReferences sheetReferences = refs = book == null ? null : book.getSheetReferences();
        if (refs != null) {
            boolean appendQuotes;
            String sheetName = refs.getSheetName(this.field_1_index_extern_sheet);
            boolean bl = false;
            if (sheetName.indexOf(" ") >= 0) {
                bl = true;
            }
            if (appendQuotes = bl) {
                retval.append("'");
            }
            retval.append(sheetName);
            if (appendQuotes) {
                retval.append("'");
            }
            retval.append('!');
        }
        retval.append(new CellReference(this.getRow(), this.getColumn(), this.isRowRelative() ^ true, this.isColRelative() ^ true).toString());
        return retval.toString();
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public Object clone() {
        Ref3DPtg ptg = new Ref3DPtg();
        ptg.field_1_index_extern_sheet = this.field_1_index_extern_sheet;
        ptg.field_2_row = this.field_2_row;
        ptg.field_3_column = this.field_3_column;
        ptg.setClass(this.ptgClass);
        return ptg;
    }

    private final /* synthetic */ void this() {
        this.rowRelative = BitFieldFactory.getInstance(32768);
        this.colRelative = BitFieldFactory.getInstance(16384);
    }

    public Ref3DPtg() {
        this.this();
    }

    public Ref3DPtg(RecordInputStream in) {
        this.this();
        this.field_1_index_extern_sheet = in.readShort();
        this.field_2_row = in.readShort();
        this.field_3_column = in.readShort();
    }

    public Ref3DPtg(String cellref, short externIdx) {
        this.this();
        CellReference c = new CellReference(cellref);
        this.setRow((short)c.getRow());
        this.setColumn(c.getCol());
        this.setColRelative(c.isColAbsolute() ^ true);
        this.setRowRelative(c.isRowAbsolute() ^ true);
        this.setExternSheetIndex(externIdx);
    }
}

