/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ColumnInfoRecordsAggregate
extends Record {
    List records;

    protected void fillFields(RecordInputStream in) {
    }

    protected void validateSid(short id) {
    }

    public short getSid() {
        return -1012;
    }

    public int getRecordSize() {
        int size = 0;
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            size += ((ColumnInfoRecord)iterator.next()).getRecordSize();
        }
        return size;
    }

    public Iterator getIterator() {
        return this.records.iterator();
    }

    public Object clone() {
        ColumnInfoRecordsAggregate rec = new ColumnInfoRecordsAggregate();
        int k = 0;
        while (k < this.records.size()) {
            ColumnInfoRecord ci = (ColumnInfoRecord)this.records.get(k);
            ci = (ColumnInfoRecord)ci.clone();
            rec.insertColumn(ci);
            ++k;
        }
        return rec;
    }

    public void insertColumn(ColumnInfoRecord col) {
        this.records.add(col);
    }

    public void insertColumn(int idx, ColumnInfoRecord col) {
        this.records.add(idx, col);
    }

    public int getNumColumns() {
        return this.records.size();
    }

    public int serialize(int offset, byte[] data) {
        Iterator itr = this.records.iterator();
        int pos = offset;
        while (itr.hasNext()) {
            pos += ((Record)itr.next()).serialize(pos, data);
        }
        return pos - offset;
    }

    public int findStartOfColumnOutlineGroup(int idx) {
        ColumnInfoRecord columnInfo = (ColumnInfoRecord)this.records.get(idx);
        short level = columnInfo.getOutlineLevel();
        while (idx != 0) {
            ColumnInfoRecord prevColumnInfo = (ColumnInfoRecord)this.records.get(idx - 1);
            if (columnInfo.getFirstColumn() - 1 != prevColumnInfo.getLastColumn() || prevColumnInfo.getOutlineLevel() < level) break;
            --idx;
            columnInfo = prevColumnInfo;
        }
        return idx;
    }

    public int findEndOfColumnOutlineGroup(int idx) {
        ColumnInfoRecord columnInfo = (ColumnInfoRecord)this.records.get(idx);
        short level = columnInfo.getOutlineLevel();
        while (idx < this.records.size() - 1) {
            ColumnInfoRecord nextColumnInfo = (ColumnInfoRecord)this.records.get(idx + 1);
            if (columnInfo.getLastColumn() + 1 != nextColumnInfo.getFirstColumn() || nextColumnInfo.getOutlineLevel() < level) break;
            ++idx;
            columnInfo = nextColumnInfo;
        }
        return idx;
    }

    public ColumnInfoRecord getColInfo(int idx) {
        return (ColumnInfoRecord)this.records.get(idx);
    }

    public ColumnInfoRecord writeHidden(ColumnInfoRecord columnInfo, int idx, boolean hidden) {
        short level = columnInfo.getOutlineLevel();
        while (idx < this.records.size()) {
            columnInfo.setHidden(hidden);
            if (idx + 1 < this.records.size()) {
                ColumnInfoRecord nextColumnInfo = (ColumnInfoRecord)this.records.get(idx + 1);
                if (columnInfo.getLastColumn() + 1 != nextColumnInfo.getFirstColumn() || nextColumnInfo.getOutlineLevel() < level) break;
                columnInfo = nextColumnInfo;
            }
            ++idx;
        }
        return columnInfo;
    }

    public boolean isColumnGroupCollapsed(int idx) {
        int endOfOutlineGroupIdx = this.findEndOfColumnOutlineGroup(idx);
        if (endOfOutlineGroupIdx >= this.records.size()) {
            return false;
        }
        if (this.getColInfo(endOfOutlineGroupIdx).getLastColumn() + 1 != this.getColInfo(endOfOutlineGroupIdx + 1).getFirstColumn()) {
            return false;
        }
        return this.getColInfo(endOfOutlineGroupIdx + 1).getCollapsed();
    }

    public boolean isColumnGroupHiddenByParent(int idx) {
        boolean startHidden;
        short startLevel;
        boolean endHidden;
        short endLevel;
        int endOfOutlineGroupIdx = this.findEndOfColumnOutlineGroup(idx);
        if (endOfOutlineGroupIdx >= this.records.size()) {
            endLevel = 0;
            endHidden = false;
        } else if (this.getColInfo(endOfOutlineGroupIdx).getLastColumn() + 1 != this.getColInfo(endOfOutlineGroupIdx + 1).getFirstColumn()) {
            endLevel = 0;
            endHidden = false;
        } else {
            endLevel = this.getColInfo(endOfOutlineGroupIdx + 1).getOutlineLevel();
            endHidden = this.getColInfo(endOfOutlineGroupIdx + 1).getHidden();
        }
        int startOfOutlineGroupIdx = this.findStartOfColumnOutlineGroup(idx);
        if (startOfOutlineGroupIdx <= 0) {
            startLevel = 0;
            startHidden = false;
        } else if (this.getColInfo(startOfOutlineGroupIdx).getFirstColumn() - 1 != this.getColInfo(startOfOutlineGroupIdx - 1).getLastColumn()) {
            startLevel = 0;
            startHidden = false;
        } else {
            startLevel = this.getColInfo(startOfOutlineGroupIdx - 1).getOutlineLevel();
            startHidden = this.getColInfo(startOfOutlineGroupIdx - 1).getHidden();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    public void collapseColumn(short columnNumber) {
        int idx = this.findColumnIdx(columnNumber, 0);
        if (idx == -1) {
            return;
        }
        ColumnInfoRecord columnInfo = (ColumnInfoRecord)this.records.get(this.findStartOfColumnOutlineGroup(idx));
        columnInfo = this.writeHidden(columnInfo, idx, true);
        this.setColumn((short)(columnInfo.getLastColumn() + 1), null, null, null, null, Boolean.TRUE);
    }

    public void expandColumn(short columnNumber) {
        int idx = this.findColumnIdx(columnNumber, 0);
        if (idx == -1) {
            return;
        }
        if (!this.isColumnGroupCollapsed(idx)) {
            return;
        }
        int startIdx = this.findStartOfColumnOutlineGroup(idx);
        ColumnInfoRecord columnInfo = this.getColInfo(startIdx);
        int endIdx = this.findEndOfColumnOutlineGroup(idx);
        ColumnInfoRecord endColumnInfo = this.getColInfo(endIdx);
        if (!this.isColumnGroupHiddenByParent(idx)) {
            int i = startIdx;
            while (i <= endIdx) {
                if (columnInfo.getOutlineLevel() == this.getColInfo(i).getOutlineLevel()) {
                    this.getColInfo(i).setHidden(false);
                }
                ++i;
            }
        }
        this.setColumn((short)(columnInfo.getLastColumn() + 1), null, null, null, null, Boolean.FALSE);
    }

    public static Record createColInfo() {
        ColumnInfoRecord retval = new ColumnInfoRecord();
        retval.setColumnWidth((short)2275);
        retval.setOptions((short)2);
        retval.setXFIndex((short)15);
        return retval;
    }

    public void setColumn(short column, Short xfIndex, Short width, Integer level, Boolean hidden, Boolean collapsed) {
        ColumnInfoRecord ci = null;
        int k = 0;
        k = 0;
        while (k < this.records.size()) {
            ci = (ColumnInfoRecord)this.records.get(k);
            if (ci.getFirstColumn() <= column && column <= ci.getLastColumn()) break;
            ci = null;
            ++k;
        }
        if (ci != null) {
            boolean columnChanged;
            boolean bl = false;
            if (xfIndex != null && ci.getXFIndex() != xfIndex.shortValue()) {
                bl = true;
            }
            boolean styleChanged = bl;
            boolean bl2 = false;
            if (width != null && ci.getColumnWidth() != width.shortValue()) {
                bl2 = true;
            }
            boolean widthChanged = bl2;
            boolean bl3 = false;
            if (level != null && ci.getOutlineLevel() != level.intValue()) {
                bl3 = true;
            }
            boolean levelChanged = bl3;
            boolean bl4 = false;
            if (hidden != null && ci.getHidden() != hidden.booleanValue()) {
                bl4 = true;
            }
            boolean hiddenChanged = bl4;
            boolean bl5 = false;
            if (collapsed != null && ci.getCollapsed() != collapsed.booleanValue()) {
                bl5 = true;
            }
            boolean collapsedChanged = bl5;
            boolean bl6 = false;
            if (styleChanged || widthChanged || levelChanged || hiddenChanged || collapsedChanged) {
                bl6 = true;
            }
            if (columnChanged = bl6) {
                if (ci.getFirstColumn() == column && ci.getLastColumn() == column) {
                    this.setColumnInfoFields(ci, xfIndex, width, level, hidden, collapsed);
                } else if (ci.getFirstColumn() == column || ci.getLastColumn() == column) {
                    if (ci.getFirstColumn() == column) {
                        ci.setFirstColumn((short)(column + 1));
                    } else {
                        ci.setLastColumn((short)(column - 1));
                    }
                    ColumnInfoRecord nci = (ColumnInfoRecord)ColumnInfoRecordsAggregate.createColInfo();
                    nci.setFirstColumn(column);
                    nci.setLastColumn(column);
                    nci.setOptions(ci.getOptions());
                    nci.setXFIndex(ci.getXFIndex());
                    this.setColumnInfoFields(nci, xfIndex, width, level, hidden, collapsed);
                    this.insertColumn(k, nci);
                } else {
                    short lastcolumn = ci.getLastColumn();
                    ci.setLastColumn((short)(column - 1));
                    ColumnInfoRecord nci = (ColumnInfoRecord)ColumnInfoRecordsAggregate.createColInfo();
                    nci.setFirstColumn(column);
                    nci.setLastColumn(column);
                    nci.setOptions(ci.getOptions());
                    nci.setXFIndex(ci.getXFIndex());
                    this.setColumnInfoFields(nci, xfIndex, width, level, hidden, collapsed);
                    this.insertColumn(++k, nci);
                    nci = (ColumnInfoRecord)ColumnInfoRecordsAggregate.createColInfo();
                    nci.setFirstColumn((short)(column + 1));
                    nci.setLastColumn(lastcolumn);
                    nci.setOptions(ci.getOptions());
                    nci.setXFIndex(ci.getXFIndex());
                    nci.setColumnWidth(ci.getColumnWidth());
                    this.insertColumn(++k, nci);
                }
            }
        } else {
            ColumnInfoRecord nci = (ColumnInfoRecord)ColumnInfoRecordsAggregate.createColInfo();
            nci.setFirstColumn(column);
            nci.setLastColumn(column);
            this.setColumnInfoFields(nci, xfIndex, width, level, hidden, collapsed);
            this.insertColumn(k, nci);
        }
    }

    private final void setColumnInfoFields(ColumnInfoRecord ci, Short xfStyle, Short width, Integer level, Boolean hidden, Boolean collapsed) {
        if (xfStyle != null) {
            ci.setXFIndex(xfStyle);
        }
        if (width != null) {
            ci.setColumnWidth(width);
        }
        if (level != null) {
            ci.setOutlineLevel(level.shortValue());
        }
        if (hidden != null) {
            ci.setHidden(hidden);
        }
        if (collapsed != null) {
            ci.setCollapsed(collapsed);
        }
    }

    public int findColumnIdx(int column, int fromIdx) {
        if (column < 0) {
            throw new IllegalArgumentException("column parameter out of range: " + column);
        }
        if (fromIdx < 0) {
            throw new IllegalArgumentException("fromIdx parameter out of range: " + fromIdx);
        }
        int k = fromIdx;
        while (k < this.records.size()) {
            ColumnInfoRecord ci = (ColumnInfoRecord)this.records.get(k);
            if (ci.getFirstColumn() <= column && column <= ci.getLastColumn()) {
                return k;
            }
            ci = null;
            ++k;
        }
        return -1;
    }

    public void collapseColInfoRecords(int columnIdx) {
        boolean columnsMatch;
        boolean adjacentColumns;
        if (columnIdx == 0) {
            return;
        }
        ColumnInfoRecord previousCol = (ColumnInfoRecord)this.records.get(columnIdx - 1);
        ColumnInfoRecord currentCol = (ColumnInfoRecord)this.records.get(columnIdx);
        boolean bl = false;
        if (previousCol.getLastColumn() == currentCol.getFirstColumn() - 1) {
            bl = true;
        }
        if (!(adjacentColumns = bl)) {
            return;
        }
        boolean bl2 = false;
        if (previousCol.getXFIndex() == currentCol.getXFIndex() && previousCol.getOptions() == currentCol.getOptions() && previousCol.getColumnWidth() == currentCol.getColumnWidth()) {
            bl2 = true;
        }
        if (columnsMatch = bl2) {
            previousCol.setLastColumn(currentCol.getLastColumn());
            this.records.remove(columnIdx);
        }
    }

    public void groupColumnRange(short fromColumn, short toColumn, boolean indent) {
        int fromIdx = 0;
        int i = fromColumn;
        while (i <= toColumn) {
            int level = 1;
            int columnIdx = this.findColumnIdx(i, Math.max(0, fromIdx));
            if (columnIdx != -1) {
                level = ((ColumnInfoRecord)this.records.get(columnIdx)).getOutlineLevel();
                level = indent ? ++level : --level;
                level = Math.max(0, level);
                level = Math.min(7, level);
                fromIdx = columnIdx - 1;
            }
            this.setColumn((short)i, null, null, new Integer(level), null, null);
            columnIdx = this.findColumnIdx(i, Math.max(0, fromIdx));
            this.collapseColInfoRecords(columnIdx);
            ++i;
        }
    }

    private final /* synthetic */ void this() {
        this.records = null;
    }

    public ColumnInfoRecordsAggregate() {
        this.this();
        this.records = new ArrayList();
    }
}

