/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LineFormatRecord
extends Record {
    public static final short sid = 4103;
    public static final short LINE_PATTERN_SOLID = 0;
    public static final short LINE_PATTERN_DASH = 1;
    public static final short LINE_PATTERN_DOT = 2;
    public static final short LINE_PATTERN_DASH_DOT = 3;
    public static final short LINE_PATTERN_DASH_DOT_DOT = 4;
    public static final short LINE_PATTERN_NONE = 5;
    public static final short LINE_PATTERN_DARK_GRAY_PATTERN = 6;
    public static final short LINE_PATTERN_MEDIUM_GRAY_PATTERN = 7;
    public static final short LINE_PATTERN_LIGHT_GRAY_PATTERN = 8;
    public static final short WEIGHT_HAIRLINE = -1;
    public static final short WEIGHT_NARROW = 0;
    public static final short WEIGHT_MEDIUM = 1;
    public static final short WEIGHT_WIDE = 2;
    private int field_1_lineColor;
    private short field_2_linePattern;
    private short field_3_weight;
    private short field_4_format;
    private BitField auto;
    private BitField drawTicks;
    private BitField unknown;
    private short field_5_colourPaletteIndex;

    protected void validateSid(short id) {
        if (id != 4103) {
            throw new RecordFormatException("Not a LineFormat record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_lineColor = in.readInt();
        this.field_2_linePattern = in.readShort();
        this.field_3_weight = in.readShort();
        this.field_4_format = in.readShort();
        this.field_5_colourPaletteIndex = in.readShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[LINEFORMAT]\n");
        buffer.append("    .lineColor            = ").append("0x").append(HexDump.toHex(this.getLineColor())).append(" (").append(this.getLineColor()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .linePattern          = ").append("0x").append(HexDump.toHex(this.getLinePattern())).append(" (").append(this.getLinePattern()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .weight               = ").append("0x").append(HexDump.toHex(this.getWeight())).append(" (").append(this.getWeight()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .format               = ").append("0x").append(HexDump.toHex(this.getFormat())).append(" (").append(this.getFormat()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .auto                     = ").append(this.isAuto()).append('\n');
        buffer.append("         .drawTicks                = ").append(this.isDrawTicks()).append('\n');
        buffer.append("         .unknown                  = ").append(this.isUnknown()).append('\n');
        buffer.append("    .colourPaletteIndex   = ").append("0x").append(HexDump.toHex(this.getColourPaletteIndex())).append(" (").append(this.getColourPaletteIndex()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/LINEFORMAT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, offset, (short)4103);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putInt(data, 4 + offset + pos, this.field_1_lineColor);
        LittleEndian.putShort(data, 8 + offset + pos, this.field_2_linePattern);
        LittleEndian.putShort(data, 10 + offset + pos, this.field_3_weight);
        LittleEndian.putShort(data, 12 + offset + pos, this.field_4_format);
        LittleEndian.putShort(data, 14 + offset + pos, this.field_5_colourPaletteIndex);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 16;
    }

    public short getSid() {
        return 4103;
    }

    public Object clone() {
        LineFormatRecord rec = new LineFormatRecord();
        rec.field_1_lineColor = this.field_1_lineColor;
        rec.field_2_linePattern = this.field_2_linePattern;
        rec.field_3_weight = this.field_3_weight;
        rec.field_4_format = this.field_4_format;
        rec.field_5_colourPaletteIndex = this.field_5_colourPaletteIndex;
        return rec;
    }

    public int getLineColor() {
        return this.field_1_lineColor;
    }

    public void setLineColor(int field_1_lineColor) {
        this.field_1_lineColor = field_1_lineColor;
    }

    public short getLinePattern() {
        return this.field_2_linePattern;
    }

    public void setLinePattern(short field_2_linePattern) {
        this.field_2_linePattern = field_2_linePattern;
    }

    public short getWeight() {
        return this.field_3_weight;
    }

    public void setWeight(short field_3_weight) {
        this.field_3_weight = field_3_weight;
    }

    public short getFormat() {
        return this.field_4_format;
    }

    public void setFormat(short field_4_format) {
        this.field_4_format = field_4_format;
    }

    public short getColourPaletteIndex() {
        return this.field_5_colourPaletteIndex;
    }

    public void setColourPaletteIndex(short field_5_colourPaletteIndex) {
        this.field_5_colourPaletteIndex = field_5_colourPaletteIndex;
    }

    public void setAuto(boolean value) {
        this.field_4_format = this.auto.setShortBoolean(this.field_4_format, value);
    }

    public boolean isAuto() {
        return this.auto.isSet(this.field_4_format);
    }

    public void setDrawTicks(boolean value) {
        this.field_4_format = this.drawTicks.setShortBoolean(this.field_4_format, value);
    }

    public boolean isDrawTicks() {
        return this.drawTicks.isSet(this.field_4_format);
    }

    public void setUnknown(boolean value) {
        this.field_4_format = this.unknown.setShortBoolean(this.field_4_format, value);
    }

    public boolean isUnknown() {
        return this.unknown.isSet(this.field_4_format);
    }

    private final /* synthetic */ void this() {
        this.auto = BitFieldFactory.getInstance(1);
        this.drawTicks = BitFieldFactory.getInstance(4);
        this.unknown = BitFieldFactory.getInstance(4);
    }

    public LineFormatRecord() {
        this.this();
    }

    public LineFormatRecord(RecordInputStream in) {
        super(in);
        this.this();
    }
}

