'''OpenGL extension SUN.triangle_list

Overview (from the spec)
	
	OpenGL has two chained triangle primitives, TRIANGLE_STRIP and
	TRIANGLE_FAN.  For multiple, consecutive triangle strips or
	triangle fans, the overhead of Begin and End, or separate calls to
	DrawArrays, can be significant depending on the number of triangles
	per strip or fan.
	
	Many surface tessellators produce triangle strips with very few
	triangles per strip before needing to restart a new strip.  Even
	sophisticated tessellators typically need to restart a new strip,
	or switch from a triangle strip to a triangle fan, many times
	within a single object.  Such tessellators can often produce a more
	efficient tessellation--one with fewer vertices--by mixing strips
	and fans within the same object.  The ability to switch from one to
	the other without restarting the strip or fan yields even more
	savings.  Unfortunately, the overhead of switching from a triangle
	strip to a triangle fan, or vice versa, can reduce, or even
	eliminate the benefit gained from reducing the number of vertices.
	
	A new triangle list primitive, along with an associated replacement
	code attribute, is defined by this extension to allow multiple
	triangle strips and fans to be specified within the same Begin/End
	pair or from a single call to DrawArrays.  The triangle list
	extension also provides the means to switch between triangle strips
	and triangle fans with or without restarting the strip or fan.
	
	TRIANGLE_LIST is a new primitive type (i.e., new Begin mode) that
	uses the ReplacementCodeSUN state attribute to determine whether the
	current vertex replaces the oldest vertex, as in a triangle strip,
	the middle vertex, as in a triangle fan, or restarts a new chained
	triangle list.  The first vertex of a new triangle list is
	implicitly treated as a RESTART.  The first three vertices complete
	the first triangle, after which the replacement codes of the vertex
	are used.  The two vertices immediately following a
	restart--including the implicit restart on the first vertex--are
	ignored.  The ReplacementCodeSUN attribute is part of the vertex
	state, and is only used by the TRIANGLE_LIST primitive.
	

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/SUN/triangle_list.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_RESTART_SUN = constant.Constant( 'GL_RESTART_SUN', 0x1 )
GL_REPLACE_MIDDLE_SUN = constant.Constant( 'GL_REPLACE_MIDDLE_SUN', 0x2 )
GL_REPLACE_OLDEST_SUN = constant.Constant( 'GL_REPLACE_OLDEST_SUN', 0x3 )
GL_TRIANGLE_LIST_SUN = constant.Constant( 'GL_TRIANGLE_LIST_SUN', 0x81D7 )
GL_REPLACEMENT_CODE_SUN = constant.Constant( 'GL_REPLACEMENT_CODE_SUN', 0x81D8 )
glget.addGLGetConstant( GL_REPLACEMENT_CODE_SUN, (1,) )
GL_REPLACEMENT_CODE_ARRAY_SUN = constant.Constant( 'GL_REPLACEMENT_CODE_ARRAY_SUN', 0x85C0 )
GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN = constant.Constant( 'GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN', 0x85C1 )
glget.addGLGetConstant( GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN, (1,) )
GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN = constant.Constant( 'GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN', 0x85C2 )
glget.addGLGetConstant( GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN, (1,) )
GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN = constant.Constant( 'GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN', 0x85C3 )
GL_R1UI_V3F_SUN = constant.Constant( 'GL_R1UI_V3F_SUN', 0x85C4 )
GL_R1UI_C4UB_V3F_SUN = constant.Constant( 'GL_R1UI_C4UB_V3F_SUN', 0x85C5 )
GL_R1UI_C3F_V3F_SUN = constant.Constant( 'GL_R1UI_C3F_V3F_SUN', 0x85C6 )
GL_R1UI_N3F_V3F_SUN = constant.Constant( 'GL_R1UI_N3F_V3F_SUN', 0x85C7 )
GL_R1UI_C4F_N3F_V3F_SUN = constant.Constant( 'GL_R1UI_C4F_N3F_V3F_SUN', 0x85C8 )
GL_R1UI_T2F_V3F_SUN = constant.Constant( 'GL_R1UI_T2F_V3F_SUN', 0x85C9 )
GL_R1UI_T2F_N3F_V3F_SUN = constant.Constant( 'GL_R1UI_T2F_N3F_V3F_SUN', 0x85CA )
GL_R1UI_T2F_C4F_N3F_V3F_SUN = constant.Constant( 'GL_R1UI_T2F_C4F_N3F_V3F_SUN', 0x85CB )
glReplacementCodeuiSUN = platform.createExtensionFunction( 
	'glReplacementCodeuiSUN', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLuint,),
	doc = 'glReplacementCodeuiSUN( GLuint(code) ) -> None',
	argNames = ('code',),
)

glReplacementCodeusSUN = platform.createExtensionFunction( 
	'glReplacementCodeusSUN', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLushort,),
	doc = 'glReplacementCodeusSUN( GLushort(code) ) -> None',
	argNames = ('code',),
)

glReplacementCodeubSUN = platform.createExtensionFunction( 
	'glReplacementCodeubSUN', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLubyte,),
	doc = 'glReplacementCodeubSUN( GLubyte(code) ) -> None',
	argNames = ('code',),
)

glReplacementCodeuivSUN = platform.createExtensionFunction( 
	'glReplacementCodeuivSUN', dll=platform.GL,
	resultType=None, 
	argTypes=(arrays.GLuintArray,),
	doc = 'glReplacementCodeuivSUN( GLuintArray(code) ) -> None',
	argNames = ('code',),
)

glReplacementCodeusvSUN = platform.createExtensionFunction( 
	'glReplacementCodeusvSUN', dll=platform.GL,
	resultType=None, 
	argTypes=(arrays.GLushortArray,),
	doc = 'glReplacementCodeusvSUN( GLushortArray(code) ) -> None',
	argNames = ('code',),
)

glReplacementCodeubvSUN = platform.createExtensionFunction( 
	'glReplacementCodeubvSUN', dll=platform.GL,
	resultType=None, 
	argTypes=(arrays.GLubyteArray,),
	doc = 'glReplacementCodeubvSUN( GLubyteArray(code) ) -> None',
	argNames = ('code',),
)

glReplacementCodePointerSUN = platform.createExtensionFunction( 
	'glReplacementCodePointerSUN', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLsizei, ctypes.POINTER(ctypes.c_void_p),),
	doc = 'glReplacementCodePointerSUN( GLenum(type), GLsizei(stride), POINTER(ctypes.c_void_p)(pointer) ) -> None',
	argNames = ('type', 'stride', 'pointer',),
)


def glInitTriangleListSUN():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_SUN_triangle_list' )
