/* vim:set noet ts=4: */
/** 
 * scim-python
 * 
 * Copyright (c) 2007-2008 Huang Peng <shawn.p.huang@gmail.com>
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *
 * $Id: $
 */
#ifndef __SCIM_PYTHON_LOOKUP_TABLE_H_
#define __SCIM_PYTHON_LOOKUP_TABLE_H_
#define Uses_SCIM_LOOKUP_TABLE
#include <Python.h>
#include <scim.h>

using namespace scim;
struct PyLookupTableObject;

class PyLookupTable : public CommonLookupTable {
private:
	PyLookupTableObject *self;

private:
	PyLookupTable (PyLookupTableObject *lookup_table, unsigned int page_size = 10);
	PyLookupTable (PyLookupTableObject *lookup_table, unsigned int page_size, const std::vector<WideString> &labels);
	virtual ~PyLookupTable ();

public:
	static PyObject *py_get_candidate (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_get_attributes (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_clear (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_page_up (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_page_down (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_append_candidate (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_get_current_page_start (PyLookupTableObject *self, PyObject *args);
	
	static PyObject *py_cursor_up (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_cursor_down (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_show_cursor (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_is_cursor_visible (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_set_cursor_pos (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_set_cursor_pos_in_current_page (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_get_cursor_pos (PyLookupTableObject *self, PyObject *args);
	static PyObject *py_get_cursor_pos_in_current_page (PyLookupTableObject *self, PyObject *args);

	static PyObject *py_set_page_size (PyLookupTableObject *self, PyObject *args);
	
	static PyObject *py_new (PyTypeObject *type, PyObject *args, PyObject *kwds);	
	static int py_init (PyLookupTableObject *self, PyObject *args, PyObject *kwds);
	static void py_dealloc (PyLookupTableObject *self);
	static const PyLookupTable &from_pyobject (PyObject *object);
	static PyMethodDef py_methods[];

};

void init_lookup_table (PyObject *module);
#endif //__SCIM_PYTHON_LOOKUP_TABLE_H_
