# -*- coding: utf-8 -*-
# vim: set noet ts=4:
#
# scim-python
#
# Copyright (c) 2007-2008 Yu Fan <yufanyufan@gmail.com>
#
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA  02111-1307  USA
#
# $Id: $
#

from ZhengJu import *
import scim
import os
from scim import KeyCode
from scim import KeyMask
from scim import Property
import traceback
import sys
from PYDict import *
from gettext import dgettext

_ = lambda a : dgettext ("scim-python", a)
class QuanPinEngine(Engine):
	def __init__ (self, factory, config, encoding, id):
		Engine.__init__(self, factory, config, encoding, id)
	def parse(self, str):
		strs = str.strip("'")
		if strs in PINYIN_LIST or strs in SHENGMU_LIST or strs in PINYIN_PARTIAL_LIST:
			return (str, )
		for i in range(len(strs), 0, -1):
			if strs[:i] in PINYIN_LIST and (strs[i:] in PINYIN_LIST or strs[i:] in SHENGMU_LIST or strs[i:] in PINYIN_PARTIAL_LIST):
				if str[0] == "'":
					return ( str[:i+1], str[i+1:])
				return ( str[:i], str[i:])
		raise InputException()
	def chinese_process_key_event (self, key):
		if key.mask == KeyMask.NullMask and (\
			(key.code >= KeyCode.KEY_a and key.code <= KeyCode.KEY_z) or \
			key.code == KeyCode.KEY_apostrophe):
			c = unichr (key.code)
			if key.code == KeyCode.KEY_apostrophe:
				if self._editor.current() == None or self._editor.current ().is_complete():
					self._editor.pinyinlist.append (PinYinWord("'"))
					if not self.progresivepromp:
						return True
				else:
					raise Exception()
			elif self._editor.current () == None:
				if c in SHENGMU_LIST:
					self._editor.pinyinlist.append (PinYinWord(c,""))
					if not self.progresivepromp:
						return True
				elif c in PINYIN_LIST:
					self._editor.pinyinlist.append (PinYinWord("",c))
				else:
					raise Exception()
			else:
				s = self._editor.current().get_screen_pinyin()
				s += c
				p = self.parse(s)
				self._editor.current().set_pinyin(pinyin = p[0])
				if len(p)>1:
					self._editor.pinyinlist.append (PinYinWord(pinyin = p[1]))
					if not self.progresivepromp:
						return True
			self._editor.auto_convert_quanpin ()
			return True
		elif self._editor.pinyinlist and key.code == KeyCode.KEY_BackSpace:
			p = self._editor.pinyinlist[-1].get_screen_pinyin()
			if len(p)>1:
				self._editor.pinyinlist[-1].set_pinyin(p[:-1])
			else:
				del self._editor.pinyinlist[-1]
			self._editor.update ()
			return True
		elif Engine.chinese_process_key_event (self,key):
			return True;
		return False

class QuanPinFactory (IMEngineFactory):
	def __init__ (self, config):
		IMEngineFactory.__init__ (self, config)
		self.name 		= _(u"QuanPin")
		self.uuid 		= "00c1690f-214c-447c-be18-1db199bae183"
		self.authors	= u"Yu Fan <yufanyufan@gmail.com>"
		self.icon_file 	= "/usr/share/scim/icons/scim-python.png"
		self.credits 	= u"GPL"
		self.help		= _(u"Help For QuanPin")
		self.set_languages ("zh")
		self._config	= config
	def create_instance (self, encoding, id):
		engine =  QuanPinEngine (self, self._config, encoding, id)
		return engine

	def reload_config (self, config):
		pass
