/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Vivien Chappelier

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/********************** floating point quantisation **************************/

/*  quantize                                                                 */
/*                                                                           */
/*  Description:                                                             */
/*    Postmultiply and quantize a block                                      */
/*                                                                           */
/*  Arguments:                                                               */
/*    short *block: the resulting 8x8 block of integer                       */
/*    dct_t *cache: a 8x8 block to quantize                                  */
/*    dct_t *qmatrix: 8x8 coefficients including postscale and quantisation  */
/*    dct_t *round: 8x8 matrix for correct rounding                          */
/*                                                                           */
/*  Return value:                                                            */
/*    None.                                                                  */

static void inline quantize(short *block,
			    dct_t *cache,
			    dct_t *qmatrix,
			    dct_t *round)
{
  int i;

  /* TODO: adjust quantization to avoid overflow at high quality */

#define sign0round(a, b) (((a)<0) ? -(b) : (((a)>0) ? (b)  : 0) )

  for(i = 0; i < 64; i++)
    block[i] = (short) ((cache[i]+sign0round(cache[i], round[i]))*qmatrix[i]);
}
