/* -- THIS FILE IS GENERATED - DO NOT EDIT *//* -*- Mode: C; c-basic-offset: 4 -*- */

#include <Python.h>



#line 3 "galago.override"
#include <Python.h>
#include <libgalago/galago.h>
#include "pygobject.h"

static PyObject *
pygalago_wrap_gobj_list(GList *list)
{
	GList *l;
	PyObject *item, *ret;

	ret = PyList_New(0);

	if (ret == NULL)
		return NULL;

	for (l = list; l != NULL; l = l->next)
	{
		item = pygobject_new((GObject *)l->data);

		if (item == NULL)
		{
			Py_DECREF(ret);
			return NULL;
		}

		PyList_Append(ret, item);
		Py_DECREF(item);
	}

	return ret;
}

GList *
pygalago_unwrap_gobj_list(PyObject *py_items, PyTypeObject *type,
						  gboolean *ok)
{
	int len, i;
	GList *items;

	*ok = TRUE;

	len = PyList_Size(py_items);

	for (i = 0; i < len; i++)
	{
		PyObject *item = PyList_GetItem(py_items, i);

		if (!pygobject_check(item, type))
		{
			char *err = g_strdup_printf("list item not a %s", type->tp_name);

			PyErr_SetString(PyExc_TypeError, err);

			g_free(err);
			g_list_free(items);
			*ok = FALSE;
			return NULL;
		}

		items = g_list_append(items, pygobject_get(item));
	}

	return items;
}
#line 73 "galago.c"


/* ---------- types from other modules ---------- */
static PyTypeObject *_PyGObject_Type;
#define PyGObject_Type (*_PyGObject_Type)


/* ---------- forward type declarations ---------- */
PyTypeObject PyGalagoObject_Type;
PyTypeObject PyGalagoImage_Type;
PyTypeObject PyGalagoCore_Type;
PyTypeObject PyGalagoContext_Type;
PyTypeObject PyGalagoAccount_Type;
PyTypeObject PyGalagoPerson_Type;
PyTypeObject PyGalagoPresence_Type;
PyTypeObject PyGalagoService_Type;
PyTypeObject PyGalagoStatus_Type;

#line 92 "galago.c"



/* ----------- GalagoObject ----------- */

static PyObject *
_wrap_galago_object_destroy(PyGObject *self)
{
    galago_object_destroy(GALAGO_OBJECT(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_object_set_dbus_path(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "obj_path", NULL };
    char *obj_path;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoObject.set_dbus_path", kwlist, &obj_path))
        return NULL;
    galago_object_set_dbus_path(GALAGO_OBJECT(self->obj), obj_path);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_object_get_dbus_path(PyGObject *self)
{
    const gchar *ret;

    ret = galago_object_get_dbus_path(GALAGO_OBJECT(self->obj));
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_object_set_watch(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "watch", NULL };
    int watch;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:GalagoObject.set_watch", kwlist, &watch))
        return NULL;
    galago_object_set_watch(GALAGO_OBJECT(self->obj), watch);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_object_is_watched(PyGObject *self)
{
    int ret;

    ret = galago_object_is_watched(GALAGO_OBJECT(self->obj));
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_object_get_origin(PyGObject *self)
{
    gint ret;

    ret = galago_object_get_origin(GALAGO_OBJECT(self->obj));
    return pyg_enum_from_gtype(GALAGO_TYPE_ORIGIN, ret);
}

static PyObject *
_wrap_galago_object_get_context(PyGObject *self)
{
    GalagoContext *ret;

    ret = galago_object_get_context(GALAGO_OBJECT(self->obj));
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_object_set_attr_string(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", "value", NULL };
    char *name, *value;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "ss:GalagoObject.set_attr_string", kwlist, &name, &value))
        return NULL;
    galago_object_set_attr_string(GALAGO_OBJECT(self->obj), name, value);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_object_set_attr_bool(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", "value", NULL };
    char *name;
    int value;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "si:GalagoObject.set_attr_bool", kwlist, &name, &value))
        return NULL;
    galago_object_set_attr_bool(GALAGO_OBJECT(self->obj), name, value);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_object_set_attr_int(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", "value", NULL };
    char *name;
    int value;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "si:GalagoObject.set_attr_int", kwlist, &name, &value))
        return NULL;
    galago_object_set_attr_int(GALAGO_OBJECT(self->obj), name, value);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_object_set_attr_double(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", "value", NULL };
    char *name;
    double value;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "sd:GalagoObject.set_attr_double", kwlist, &name, &value))
        return NULL;
    galago_object_set_attr_double(GALAGO_OBJECT(self->obj), name, value);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 312 "galago.override"
static PyObject *
_wrap_galago_object_set_attribute(PyGObject *self, PyObject *args,
								  PyObject *kwargs)
{
	static char *kwlist[] = { "name", "value", NULL };
	char *name;
	PyObject *value;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
									 "sO:GalagoObject.set_attribute",
									 kwlist, &name, &value))
	{
		return NULL;
	}

	if (PyString_Check(value))
	{
		galago_object_set_attr_string(GALAGO_OBJECT(self->obj), name,
									  PyString_AsString(value));
	}
	else if (PyBool_Check(value))
	{
		galago_object_set_attr_bool(GALAGO_OBJECT(self->obj), name,
									PyObject_IsTrue(value));
	}
	else if (PyLong_Check(value))
	{
		galago_object_set_attr_int(GALAGO_OBJECT(self->obj), name,
								   PyLong_AsLong(value));
	}
	else
	{
		/* TODO: Display an error */
		return NULL;
	}

	Py_INCREF(Py_None);
	return Py_None;
}
#line 268 "galago.c"


static PyObject *
_wrap_galago_object_remove_attribute(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", NULL };
    char *name;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoObject.remove_attribute", kwlist, &name))
        return NULL;
    ret = galago_object_remove_attribute(GALAGO_OBJECT(self->obj), name);
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_object_get_attr_string(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", NULL };
    char *name;
    const gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoObject.get_attr_string", kwlist, &name))
        return NULL;
    ret = galago_object_get_attr_string(GALAGO_OBJECT(self->obj), name);
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_object_get_attr_bool(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", NULL };
    char *name;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoObject.get_attr_bool", kwlist, &name))
        return NULL;
    ret = galago_object_get_attr_bool(GALAGO_OBJECT(self->obj), name);
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_object_get_attr_int(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", NULL };
    char *name;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoObject.get_attr_int", kwlist, &name))
        return NULL;
    ret = galago_object_get_attr_int(GALAGO_OBJECT(self->obj), name);
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_galago_object_get_attr_double(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", NULL };
    char *name;
    double ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoObject.get_attr_double", kwlist, &name))
        return NULL;
    ret = galago_object_get_attr_double(GALAGO_OBJECT(self->obj), name);
    return PyFloat_FromDouble(ret);
}

#line 274 "galago.override"
static PyObject *
_wrap_galago_object_get_attribute(PyGObject *self, PyObject *args,
								  PyObject *kwargs)
{
	static char *kwlist[] = { "name", NULL };
	char *name;
	const GValue *value;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
									 "s:GalagoObject.get_attribute",
									 kwlist, &name))
	{
		return NULL;
	}

	value = galago_object_get_attribute(GALAGO_OBJECT(self->obj), name);

	if (G_VALUE_HOLDS(value, G_TYPE_STRING))
	{
		return PyString_FromString(g_value_get_string(value));
	}
	else if (G_VALUE_HOLDS(value, G_TYPE_BOOLEAN))
	{
		return PyBool_FromLong(g_value_get_boolean(value));
	}
	else if (G_VALUE_HOLDS(value, G_TYPE_INT))
	{
		return PyLong_FromLong(g_value_get_int(value));
	}
	else
	{
		/* TODO: Put out some kind of warning */
		Py_INCREF(Py_None);
		return Py_None;
	}
}
#line 378 "galago.c"


static PyObject *
_wrap_galago_object_get_has_attribute(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", NULL };
    char *name;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoObject.get_has_attribute", kwlist, &name))
        return NULL;
    ret = galago_object_get_has_attribute(GALAGO_OBJECT(self->obj), name);
    return PyBool_FromLong(ret);

}

#line 353 "galago.override"
static PyObject *
_wrap_galago_object_get_attributes(PyGObject *self)
{
	GList *attrs, *l;
	PyObject *list;

	list = PyList_New(0);

	if (list == NULL)
		return NULL;

	attrs = galago_object_get_attributes(GALAGO_OBJECT(self->obj));

	for (l = attrs; l != NULL; l = l->next)
	{
		GalagoKeyValue *key_value = (GalagoKeyValue *)l->data;
		PyObject *tuple = PyTuple_New(2);

		PyTuple_SetItem(tuple, 0, PyString_FromString(key_value->key));
		PyTuple_SetItem(tuple, 1, pyg_value_as_pyobject(key_value->value,
														FALSE));
		PyList_Append(list, tuple);
	}

	return list;
}
#line 422 "galago.c"


static PyMethodDef _PyGalagoObject_methods[] = {
    { "destroy", (PyCFunction)_wrap_galago_object_destroy, METH_NOARGS },
    { "set_dbus_path", (PyCFunction)_wrap_galago_object_set_dbus_path, METH_VARARGS|METH_KEYWORDS },
    { "get_dbus_path", (PyCFunction)_wrap_galago_object_get_dbus_path, METH_NOARGS },
    { "set_watch", (PyCFunction)_wrap_galago_object_set_watch, METH_VARARGS|METH_KEYWORDS },
    { "is_watched", (PyCFunction)_wrap_galago_object_is_watched, METH_NOARGS },
    { "get_origin", (PyCFunction)_wrap_galago_object_get_origin, METH_NOARGS },
    { "get_context", (PyCFunction)_wrap_galago_object_get_context, METH_NOARGS },
    { "set_attr_string", (PyCFunction)_wrap_galago_object_set_attr_string, METH_VARARGS|METH_KEYWORDS },
    { "set_attr_bool", (PyCFunction)_wrap_galago_object_set_attr_bool, METH_VARARGS|METH_KEYWORDS },
    { "set_attr_int", (PyCFunction)_wrap_galago_object_set_attr_int, METH_VARARGS|METH_KEYWORDS },
    { "set_attr_double", (PyCFunction)_wrap_galago_object_set_attr_double, METH_VARARGS|METH_KEYWORDS },
    { "set_attribute", (PyCFunction)_wrap_galago_object_set_attribute, METH_VARARGS|METH_KEYWORDS },
    { "remove_attribute", (PyCFunction)_wrap_galago_object_remove_attribute, METH_VARARGS|METH_KEYWORDS },
    { "get_attr_string", (PyCFunction)_wrap_galago_object_get_attr_string, METH_VARARGS|METH_KEYWORDS },
    { "get_attr_bool", (PyCFunction)_wrap_galago_object_get_attr_bool, METH_VARARGS|METH_KEYWORDS },
    { "get_attr_int", (PyCFunction)_wrap_galago_object_get_attr_int, METH_VARARGS|METH_KEYWORDS },
    { "get_attr_double", (PyCFunction)_wrap_galago_object_get_attr_double, METH_VARARGS|METH_KEYWORDS },
    { "get_attribute", (PyCFunction)_wrap_galago_object_get_attribute, METH_VARARGS|METH_KEYWORDS },
    { "get_has_attribute", (PyCFunction)_wrap_galago_object_get_has_attribute, METH_VARARGS|METH_KEYWORDS },
    { "get_attributes", (PyCFunction)_wrap_galago_object_get_attributes, METH_NOARGS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGalagoObject_Type = {
    PyObject_HEAD_INIT(NULL)
    0,					/* ob_size */
    "galago.Object",			/* tp_name */
    sizeof(PyGObject),	        /* tp_basicsize */
    0,					/* tp_itemsize */
    /* methods */
    (destructor)0,	/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,	/* tp_getattr */
    (setattrfunc)0,	/* tp_setattr */
    (cmpfunc)0,		/* tp_compare */
    (reprfunc)0,		/* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,		/* tp_hash */
    (ternaryfunc)0,		/* tp_call */
    (reprfunc)0,		/* tp_str */
    (getattrofunc)0,	/* tp_getattro */
    (setattrofunc)0,	/* tp_setattro */
    (PyBufferProcs*)0,	/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL, 				/* Documentation string */
    (traverseproc)0,	/* tp_traverse */
    (inquiry)0,		/* tp_clear */
    (richcmpfunc)0,	/* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,		/* tp_iter */
    (iternextfunc)0,	/* tp_iternext */
    _PyGalagoObject_methods,			/* tp_methods */
    0,					/* tp_members */
    0,		       	/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,	/* tp_descr_get */
    (descrsetfunc)0,	/* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,		/* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GalagoImage ----------- */

#line 258 "galago.override"
static PyObject *
_wrap_galago_image_get_data(PyGObject *self)
{
	guchar *data;
	gsize len;

	galago_image_get_data(GALAGO_IMAGE(self->obj), &data, &len);

	if (data != NULL)
		return PyString_FromStringAndSize((char *)data, len);

	Py_INCREF(Py_None);
	return Py_None;
}
#line 513 "galago.c"


static PyMethodDef _PyGalagoImage_methods[] = {
    { "get_data", (PyCFunction)_wrap_galago_image_get_data, METH_NOARGS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGalagoImage_Type = {
    PyObject_HEAD_INIT(NULL)
    0,					/* ob_size */
    "galago.Image",			/* tp_name */
    sizeof(PyGObject),	        /* tp_basicsize */
    0,					/* tp_itemsize */
    /* methods */
    (destructor)0,	/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,	/* tp_getattr */
    (setattrfunc)0,	/* tp_setattr */
    (cmpfunc)0,		/* tp_compare */
    (reprfunc)0,		/* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,		/* tp_hash */
    (ternaryfunc)0,		/* tp_call */
    (reprfunc)0,		/* tp_str */
    (getattrofunc)0,	/* tp_getattro */
    (setattrofunc)0,	/* tp_setattro */
    (PyBufferProcs*)0,	/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL, 				/* Documentation string */
    (traverseproc)0,	/* tp_traverse */
    (inquiry)0,		/* tp_clear */
    (richcmpfunc)0,	/* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,		/* tp_iter */
    (iternextfunc)0,	/* tp_iternext */
    _PyGalagoImage_methods,			/* tp_methods */
    0,					/* tp_members */
    0,		       	/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,	/* tp_descr_get */
    (descrsetfunc)0,	/* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,		/* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GalagoCore ----------- */

PyTypeObject PyGalagoCore_Type = {
    PyObject_HEAD_INIT(NULL)
    0,					/* ob_size */
    "galago.Core",			/* tp_name */
    sizeof(PyGObject),	        /* tp_basicsize */
    0,					/* tp_itemsize */
    /* methods */
    (destructor)0,	/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,	/* tp_getattr */
    (setattrfunc)0,	/* tp_setattr */
    (cmpfunc)0,		/* tp_compare */
    (reprfunc)0,		/* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,		/* tp_hash */
    (ternaryfunc)0,		/* tp_call */
    (reprfunc)0,		/* tp_str */
    (getattrofunc)0,	/* tp_getattro */
    (setattrofunc)0,	/* tp_setattro */
    (PyBufferProcs*)0,	/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL, 				/* Documentation string */
    (traverseproc)0,	/* tp_traverse */
    (inquiry)0,		/* tp_clear */
    (richcmpfunc)0,	/* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,		/* tp_iter */
    (iternextfunc)0,	/* tp_iternext */
    NULL,			/* tp_methods */
    0,					/* tp_members */
    0,		       	/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,	/* tp_descr_get */
    (descrsetfunc)0,	/* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,		/* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GalagoContext ----------- */

static int
_wrap_galago_context_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char* kwlist[] = { NULL };

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":galago.Context.__init__", kwlist))
        return -1;

    pygobject_constructv(self, 0, NULL);

    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create %(typename)s object");
        return -1;
    }

    return 0;
}


static PyObject *
_wrap_galago_context_push(PyGObject *self)
{
    galago_context_push(GALAGO_CONTEXT(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyMethodDef _PyGalagoContext_methods[] = {
    { "push", (PyCFunction)_wrap_galago_context_push, METH_NOARGS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGalagoContext_Type = {
    PyObject_HEAD_INIT(NULL)
    0,					/* ob_size */
    "galago.Context",			/* tp_name */
    sizeof(PyGObject),	        /* tp_basicsize */
    0,					/* tp_itemsize */
    /* methods */
    (destructor)0,	/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,	/* tp_getattr */
    (setattrfunc)0,	/* tp_setattr */
    (cmpfunc)0,		/* tp_compare */
    (reprfunc)0,		/* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,		/* tp_hash */
    (ternaryfunc)0,		/* tp_call */
    (reprfunc)0,		/* tp_str */
    (getattrofunc)0,	/* tp_getattro */
    (setattrofunc)0,	/* tp_setattro */
    (PyBufferProcs*)0,	/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL, 				/* Documentation string */
    (traverseproc)0,	/* tp_traverse */
    (inquiry)0,		/* tp_clear */
    (richcmpfunc)0,	/* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,		/* tp_iter */
    (iternextfunc)0,	/* tp_iternext */
    _PyGalagoContext_methods,			/* tp_methods */
    0,					/* tp_members */
    0,		       	/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,	/* tp_descr_get */
    (descrsetfunc)0,	/* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_galago_context_new,		/* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GalagoAccount ----------- */

static PyObject *
_wrap_galago_account_set_connected(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "connected", NULL };
    int connected;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:GalagoAccount.set_connected", kwlist, &connected))
        return NULL;
    galago_account_set_connected(GALAGO_ACCOUNT(self->obj), connected);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_account_get_service(PyGObject *self)
{
    GalagoService *ret;

    ret = galago_account_get_service(GALAGO_ACCOUNT(self->obj));
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_account_get_person(PyGObject *self)
{
    GalagoPerson *ret;

    ret = galago_account_get_person(GALAGO_ACCOUNT(self->obj));
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_account_get_username(PyGObject *self)
{
    const gchar *ret;

    ret = galago_account_get_username(GALAGO_ACCOUNT(self->obj));
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_account_is_connected(PyGObject *self)
{
    int ret;

    ret = galago_account_is_connected(GALAGO_ACCOUNT(self->obj));
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_account_set_display_name(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "display_name", NULL };
    char *display_name;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoAccount.set_display_name", kwlist, &display_name))
        return NULL;
    galago_account_set_display_name(GALAGO_ACCOUNT(self->obj), display_name);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_account_get_display_name(PyGObject *self)
{
    const gchar *ret;

    ret = galago_account_get_display_name(GALAGO_ACCOUNT(self->obj));
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_account_is_display_name_set(PyGObject *self)
{
    int ret;

    ret = galago_account_is_display_name_set(GALAGO_ACCOUNT(self->obj));
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_account_add_contact(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "contact", NULL };
    PyGObject *contact;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!:GalagoAccount.add_contact", kwlist, &PyGalagoAccount_Type, &contact))
        return NULL;
    galago_account_add_contact(GALAGO_ACCOUNT(self->obj), GALAGO_ACCOUNT(contact->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_account_remove_contact(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "contact", NULL };
    PyGObject *contact;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!:GalagoAccount.remove_contact", kwlist, &PyGalagoAccount_Type, &contact))
        return NULL;
    galago_account_remove_contact(GALAGO_ACCOUNT(self->obj), GALAGO_ACCOUNT(contact->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_account_get_contact(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "username", "query", NULL };
    char *username;
    int query = TRUE;
    GalagoAccount *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|i:GalagoAccount.get_contact", kwlist, &username, &query))
        return NULL;
    ret = galago_account_get_contact(GALAGO_ACCOUNT(self->obj), username, query);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

#line 83 "galago.override"
static PyObject *
_wrap_galago_account_get_contacts(PyGObject *self, PyObject *args,
								  PyObject *kwargs)
{
	static char *kwlist[] = { "username", "query", NULL };
	PyObject *query = Py_True;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
									 "|O:GalagoAccount.get_contacts",
									 kwlist, &query))
	{
		return NULL;
	}

	return pygalago_wrap_gobj_list(
		galago_account_get_contacts(GALAGO_ACCOUNT(self->obj),
									PyObject_IsTrue(query)));
}
#line 850 "galago.c"


static PyObject *
_wrap_galago_account_create_presence(PyGObject *self)
{
    GalagoPresence *ret;

    ret = galago_account_create_presence(GALAGO_ACCOUNT(self->obj));
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_account_get_presence(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "query", NULL };
    int query = TRUE;
    GalagoPresence *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|i:GalagoAccount.get_presence", kwlist, &query))
        return NULL;
    ret = galago_account_get_presence(GALAGO_ACCOUNT(self->obj), query);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_account_set_avatar(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "avatar", NULL };
    PyGObject *avatar;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!:GalagoAccount.set_avatar", kwlist, &PyGalagoImage_Type, &avatar))
        return NULL;
    galago_account_set_avatar(GALAGO_ACCOUNT(self->obj), GALAGO_IMAGE(avatar->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_account_get_avatar(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "query", NULL };
    int query = TRUE;
    GalagoImage *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|i:GalagoAccount.get_avatar", kwlist, &query))
        return NULL;
    ret = galago_account_get_avatar(GALAGO_ACCOUNT(self->obj), query);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyMethodDef _PyGalagoAccount_methods[] = {
    { "set_connected", (PyCFunction)_wrap_galago_account_set_connected, METH_VARARGS|METH_KEYWORDS },
    { "get_service", (PyCFunction)_wrap_galago_account_get_service, METH_NOARGS },
    { "get_person", (PyCFunction)_wrap_galago_account_get_person, METH_NOARGS },
    { "get_username", (PyCFunction)_wrap_galago_account_get_username, METH_NOARGS },
    { "is_connected", (PyCFunction)_wrap_galago_account_is_connected, METH_NOARGS },
    { "set_display_name", (PyCFunction)_wrap_galago_account_set_display_name, METH_VARARGS|METH_KEYWORDS },
    { "get_display_name", (PyCFunction)_wrap_galago_account_get_display_name, METH_NOARGS },
    { "is_display_name_set", (PyCFunction)_wrap_galago_account_is_display_name_set, METH_NOARGS },
    { "add_contact", (PyCFunction)_wrap_galago_account_add_contact, METH_VARARGS|METH_KEYWORDS },
    { "remove_contact", (PyCFunction)_wrap_galago_account_remove_contact, METH_VARARGS|METH_KEYWORDS },
    { "get_contact", (PyCFunction)_wrap_galago_account_get_contact, METH_VARARGS|METH_KEYWORDS },
    { "get_contacts", (PyCFunction)_wrap_galago_account_get_contacts, METH_VARARGS|METH_KEYWORDS },
    { "create_presence", (PyCFunction)_wrap_galago_account_create_presence, METH_NOARGS },
    { "get_presence", (PyCFunction)_wrap_galago_account_get_presence, METH_VARARGS|METH_KEYWORDS },
    { "set_avatar", (PyCFunction)_wrap_galago_account_set_avatar, METH_VARARGS|METH_KEYWORDS },
    { "get_avatar", (PyCFunction)_wrap_galago_account_get_avatar, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGalagoAccount_Type = {
    PyObject_HEAD_INIT(NULL)
    0,					/* ob_size */
    "galago.Account",			/* tp_name */
    sizeof(PyGObject),	        /* tp_basicsize */
    0,					/* tp_itemsize */
    /* methods */
    (destructor)0,	/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,	/* tp_getattr */
    (setattrfunc)0,	/* tp_setattr */
    (cmpfunc)0,		/* tp_compare */
    (reprfunc)0,		/* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,		/* tp_hash */
    (ternaryfunc)0,		/* tp_call */
    (reprfunc)0,		/* tp_str */
    (getattrofunc)0,	/* tp_getattro */
    (setattrofunc)0,	/* tp_setattro */
    (PyBufferProcs*)0,	/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL, 				/* Documentation string */
    (traverseproc)0,	/* tp_traverse */
    (inquiry)0,		/* tp_clear */
    (richcmpfunc)0,	/* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,		/* tp_iter */
    (iternextfunc)0,	/* tp_iternext */
    _PyGalagoAccount_methods,			/* tp_methods */
    0,					/* tp_members */
    0,		       	/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,	/* tp_descr_get */
    (descrsetfunc)0,	/* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,		/* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GalagoPerson ----------- */

static PyObject *
_wrap_galago_person_set_me(PyGObject *self)
{
    galago_person_set_me(GALAGO_PERSON(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_person_is_me(PyGObject *self)
{
    int ret;

    ret = galago_person_is_me(GALAGO_PERSON(self->obj));
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_person_get_id(PyGObject *self)
{
    const gchar *ret;

    ret = galago_person_get_id(GALAGO_PERSON(self->obj));
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_person_get_session_id(PyGObject *self)
{
    const gchar *ret;

    ret = galago_person_get_session_id(GALAGO_PERSON(self->obj));
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_person_get_display_name(PyGObject *self)
{
    const gchar *ret;

    ret = galago_person_get_display_name(GALAGO_PERSON(self->obj));
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_person_set_photo(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "photo", NULL };
    PyGObject *photo;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!:GalagoPerson.set_photo", kwlist, &PyGalagoImage_Type, &photo))
        return NULL;
    galago_person_set_photo(GALAGO_PERSON(self->obj), GALAGO_IMAGE(photo->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_person_get_photo(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "query", NULL };
    int query = TRUE;
    GalagoImage *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|i:GalagoPerson.get_photo", kwlist, &query))
        return NULL;
    ret = galago_person_get_photo(GALAGO_PERSON(self->obj), query);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_person_has_accounts(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "query", NULL };
    int query = TRUE, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|i:GalagoPerson.has_accounts", kwlist, &query))
        return NULL;
    ret = galago_person_has_accounts(GALAGO_PERSON(self->obj), query);
    return PyBool_FromLong(ret);

}

#line 381 "galago.override"
static PyObject *
_wrap_galago_person_get_accounts(PyGObject *self, PyObject *args,
								 PyObject *kwargs)
{
	static char *kwlist[] = { "query", NULL };
	PyObject *query = Py_True;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
									 "|O:GalagoPerson.get_accounts",
									 kwlist, &query))
	{
		return NULL;
	}

	return pygalago_wrap_gobj_list(
		galago_person_get_accounts(GALAGO_PERSON(self->obj),
								   PyObject_IsTrue(query)));
}
#line 1086 "galago.c"


static PyObject *
_wrap_galago_person_get_priority_account(PyGObject *self)
{
    GalagoAccount *ret;

    ret = galago_person_get_priority_account(GALAGO_PERSON(self->obj));
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_person_get_account(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "service", "username", "query", NULL };
    PyGObject *service;
    char *username;
    int query = TRUE;
    GalagoAccount *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!s|i:GalagoPerson.get_account", kwlist, &PyGalagoService_Type, &service, &username, &query))
        return NULL;
    ret = galago_person_get_account(GALAGO_PERSON(self->obj), GALAGO_SERVICE(service->obj), username, query);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyMethodDef _PyGalagoPerson_methods[] = {
    { "set_me", (PyCFunction)_wrap_galago_person_set_me, METH_NOARGS },
    { "is_me", (PyCFunction)_wrap_galago_person_is_me, METH_NOARGS },
    { "get_id", (PyCFunction)_wrap_galago_person_get_id, METH_NOARGS },
    { "get_session_id", (PyCFunction)_wrap_galago_person_get_session_id, METH_NOARGS },
    { "get_display_name", (PyCFunction)_wrap_galago_person_get_display_name, METH_NOARGS },
    { "set_photo", (PyCFunction)_wrap_galago_person_set_photo, METH_VARARGS|METH_KEYWORDS },
    { "get_photo", (PyCFunction)_wrap_galago_person_get_photo, METH_VARARGS|METH_KEYWORDS },
    { "has_accounts", (PyCFunction)_wrap_galago_person_has_accounts, METH_VARARGS|METH_KEYWORDS },
    { "get_accounts", (PyCFunction)_wrap_galago_person_get_accounts, METH_VARARGS|METH_KEYWORDS },
    { "get_priority_account", (PyCFunction)_wrap_galago_person_get_priority_account, METH_NOARGS },
    { "get_account", (PyCFunction)_wrap_galago_person_get_account, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGalagoPerson_Type = {
    PyObject_HEAD_INIT(NULL)
    0,					/* ob_size */
    "galago.Person",			/* tp_name */
    sizeof(PyGObject),	        /* tp_basicsize */
    0,					/* tp_itemsize */
    /* methods */
    (destructor)0,	/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,	/* tp_getattr */
    (setattrfunc)0,	/* tp_setattr */
    (cmpfunc)0,		/* tp_compare */
    (reprfunc)0,		/* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,		/* tp_hash */
    (ternaryfunc)0,		/* tp_call */
    (reprfunc)0,		/* tp_str */
    (getattrofunc)0,	/* tp_getattro */
    (setattrofunc)0,	/* tp_setattro */
    (PyBufferProcs*)0,	/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL, 				/* Documentation string */
    (traverseproc)0,	/* tp_traverse */
    (inquiry)0,		/* tp_clear */
    (richcmpfunc)0,	/* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,		/* tp_iter */
    (iternextfunc)0,	/* tp_iternext */
    _PyGalagoPerson_methods,			/* tp_methods */
    0,					/* tp_members */
    0,		       	/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,	/* tp_descr_get */
    (descrsetfunc)0,	/* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,		/* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GalagoPresence ----------- */

static PyObject *
_wrap_galago_presence_set_idle(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "idle", "idle_start_time", NULL };
    int idle;
    time_t idle_start_time = time(NULL);

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i|i:GalagoPresence.set_idle", kwlist, &idle, &idle_start_time))
        return NULL;
    galago_presence_set_idle(GALAGO_PRESENCE(self->obj), idle, idle_start_time);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 401 "galago.override"
static PyObject *
_wrap_galago_presence_set_statuses(PyGObject *self, PyObject *args,
								   PyObject *kwargs)
{
	static char *kwlist[] = { "statuses", NULL };
	GList *items;
	PyObject *py_items;
	gboolean ok;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
									 "O!:GalagoPresence.set_statuses",
									 kwlist, &PyList_Type, &py_items))
	{
		return NULL;
	}

	items = pygalago_unwrap_gobj_list(py_items, &PyGalagoStatus_Type, &ok);

	if (!ok)
		return NULL;

	galago_presence_set_statuses(GALAGO_PRESENCE(self->obj), items);
	g_list_free(items);

	Py_INCREF(Py_None);
	return Py_None;
}
#line 1221 "galago.c"


static PyObject *
_wrap_galago_presence_add_status(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "status", NULL };
    PyGObject *status;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!:GalagoPresence.add_status", kwlist, &PyGalagoStatus_Type, &status))
        return NULL;
    galago_presence_add_status(GALAGO_PRESENCE(self->obj), GALAGO_STATUS(status->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_presence_remove_status(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "status_id", NULL };
    char *status_id;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoPresence.remove_status", kwlist, &status_id))
        return NULL;
    galago_presence_remove_status(GALAGO_PRESENCE(self->obj), status_id);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_presence_clear_statuses(PyGObject *self)
{
    galago_presence_clear_statuses(GALAGO_PRESENCE(self->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_presence_get_account(PyGObject *self)
{
    GalagoAccount *ret;

    ret = galago_presence_get_account(GALAGO_PRESENCE(self->obj));
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_presence_is_idle(PyGObject *self)
{
    int ret;

    ret = galago_presence_is_idle(GALAGO_PRESENCE(self->obj));
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_presence_get_idle_time(PyGObject *self)
{
    time_t ret;

    ret = galago_presence_get_idle_time(GALAGO_PRESENCE(self->obj));
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_galago_presence_get_idle_start_time(PyGObject *self)
{
    time_t ret;

    ret = galago_presence_get_idle_start_time(GALAGO_PRESENCE(self->obj));
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_galago_presence_is_discarded(PyGObject *self)
{
    int ret;

    ret = galago_presence_is_discarded(GALAGO_PRESENCE(self->obj));
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_presence_is_available(PyGObject *self)
{
    int ret;

    ret = galago_presence_is_available(GALAGO_PRESENCE(self->obj));
    return PyBool_FromLong(ret);

}

#line 430 "galago.override"
static PyObject *
_wrap_galago_presence_get_statuses(PyGObject *self)
{
	return pygalago_wrap_gobj_list(
		galago_presence_get_statuses(GALAGO_PRESENCE(self->obj)));
}
#line 1323 "galago.c"


static PyObject *
_wrap_galago_presence_get_active_status(PyGObject *self)
{
    GalagoStatus *ret;

    ret = galago_presence_get_active_status(GALAGO_PRESENCE(self->obj));
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_presence_is_status_exclusive(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "status_id", NULL };
    char *status_id;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoPresence.is_status_exclusive", kwlist, &status_id))
        return NULL;
    ret = galago_presence_is_status_exclusive(GALAGO_PRESENCE(self->obj), status_id);
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_presence_get_status(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "status_id", NULL };
    char *status_id;
    GalagoStatus *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoPresence.get_status", kwlist, &status_id))
        return NULL;
    ret = galago_presence_get_status(GALAGO_PRESENCE(self->obj), status_id);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_presence_has_status(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "status_id", NULL };
    char *status_id;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoPresence.has_status", kwlist, &status_id))
        return NULL;
    ret = galago_presence_has_status(GALAGO_PRESENCE(self->obj), status_id);
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_presence_has_status_type(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "type", NULL };
    PyObject *py_type = NULL;
    GalagoStatusType type;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:GalagoPresence.has_status_type", kwlist, &py_type))
        return NULL;
    if (pyg_enum_get_value(GALAGO_TYPE_STATUS_TYPE, py_type, (gint *)&type))
        return NULL;
    ret = galago_presence_has_status_type(GALAGO_PRESENCE(self->obj), type);
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_presence_compare(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "presence2", NULL };
    PyGObject *presence2;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!:GalagoPresence.compare", kwlist, &PyGalagoPresence_Type, &presence2))
        return NULL;
    ret = galago_presence_compare(GALAGO_PRESENCE(self->obj), GALAGO_PRESENCE(presence2->obj));
    return PyInt_FromLong(ret);
}

static PyMethodDef _PyGalagoPresence_methods[] = {
    { "set_idle", (PyCFunction)_wrap_galago_presence_set_idle, METH_VARARGS|METH_KEYWORDS },
    { "set_statuses", (PyCFunction)_wrap_galago_presence_set_statuses, METH_VARARGS|METH_KEYWORDS },
    { "add_status", (PyCFunction)_wrap_galago_presence_add_status, METH_VARARGS|METH_KEYWORDS },
    { "remove_status", (PyCFunction)_wrap_galago_presence_remove_status, METH_VARARGS|METH_KEYWORDS },
    { "clear_statuses", (PyCFunction)_wrap_galago_presence_clear_statuses, METH_NOARGS },
    { "get_account", (PyCFunction)_wrap_galago_presence_get_account, METH_NOARGS },
    { "is_idle", (PyCFunction)_wrap_galago_presence_is_idle, METH_NOARGS },
    { "get_idle_time", (PyCFunction)_wrap_galago_presence_get_idle_time, METH_NOARGS },
    { "get_idle_start_time", (PyCFunction)_wrap_galago_presence_get_idle_start_time, METH_NOARGS },
    { "is_discarded", (PyCFunction)_wrap_galago_presence_is_discarded, METH_NOARGS },
    { "is_available", (PyCFunction)_wrap_galago_presence_is_available, METH_NOARGS },
    { "get_statuses", (PyCFunction)_wrap_galago_presence_get_statuses, METH_NOARGS },
    { "get_active_status", (PyCFunction)_wrap_galago_presence_get_active_status, METH_NOARGS },
    { "is_status_exclusive", (PyCFunction)_wrap_galago_presence_is_status_exclusive, METH_VARARGS|METH_KEYWORDS },
    { "get_status", (PyCFunction)_wrap_galago_presence_get_status, METH_VARARGS|METH_KEYWORDS },
    { "has_status", (PyCFunction)_wrap_galago_presence_has_status, METH_VARARGS|METH_KEYWORDS },
    { "has_status_type", (PyCFunction)_wrap_galago_presence_has_status_type, METH_VARARGS|METH_KEYWORDS },
    { "compare", (PyCFunction)_wrap_galago_presence_compare, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGalagoPresence_Type = {
    PyObject_HEAD_INIT(NULL)
    0,					/* ob_size */
    "galago.Presence",			/* tp_name */
    sizeof(PyGObject),	        /* tp_basicsize */
    0,					/* tp_itemsize */
    /* methods */
    (destructor)0,	/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,	/* tp_getattr */
    (setattrfunc)0,	/* tp_setattr */
    (cmpfunc)0,		/* tp_compare */
    (reprfunc)0,		/* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,		/* tp_hash */
    (ternaryfunc)0,		/* tp_call */
    (reprfunc)0,		/* tp_str */
    (getattrofunc)0,	/* tp_getattro */
    (setattrofunc)0,	/* tp_setattro */
    (PyBufferProcs*)0,	/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL, 				/* Documentation string */
    (traverseproc)0,	/* tp_traverse */
    (inquiry)0,		/* tp_clear */
    (richcmpfunc)0,	/* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,		/* tp_iter */
    (iternextfunc)0,	/* tp_iternext */
    _PyGalagoPresence_methods,			/* tp_methods */
    0,					/* tp_members */
    0,		       	/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,	/* tp_descr_get */
    (descrsetfunc)0,	/* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,		/* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GalagoService ----------- */

static PyObject *
_wrap_galago_service_get_id(PyGObject *self)
{
    const gchar *ret;

    ret = galago_service_get_id(GALAGO_SERVICE(self->obj));
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_service_get_name(PyGObject *self)
{
    const gchar *ret;

    ret = galago_service_get_name(GALAGO_SERVICE(self->obj));
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_service_get_flags(PyGObject *self)
{
    guint ret;

    ret = galago_service_get_flags(GALAGO_SERVICE(self->obj));
    return pyg_flags_from_gtype(GALAGO_TYPE_SERVICE_FLAGS, ret);
}

static PyObject *
_wrap_galago_service_create_account(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "person", "username", NULL };
    PyGObject *person;
    char *username;
    GalagoAccount *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!s:GalagoService.create_account", kwlist, &PyGalagoPerson_Type, &person, &username))
        return NULL;
    ret = galago_service_create_account(GALAGO_SERVICE(self->obj), GALAGO_PERSON(person->obj), username);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_service_get_account(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "username", "query", NULL };
    char *username;
    int query = TRUE;
    GalagoAccount *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|i:GalagoService.get_account", kwlist, &username, &query))
        return NULL;
    ret = galago_service_get_account(GALAGO_SERVICE(self->obj), username, query);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

#line 438 "galago.override"
static PyObject *
_wrap_galago_service_get_accounts(PyGObject *self, PyObject *args,
								  PyObject *kwargs)
{
	static char *kwlist[] = { "query", NULL };
	PyObject *query = Py_True;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
									 "|O:GalagoService.get_accounts",
									 kwlist, &query))
	{
		return NULL;
	}

	return pygalago_wrap_gobj_list(
		galago_service_get_accounts(GALAGO_SERVICE(self->obj),
									PyObject_IsTrue(query)));
}
#line 1561 "galago.c"


static PyObject *
_wrap_galago_service_normalize(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "username", NULL };
    char *username;
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:GalagoService.normalize", kwlist, &username))
        return NULL;
    ret = galago_service_normalize(GALAGO_SERVICE(self->obj), username);
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyMethodDef _PyGalagoService_methods[] = {
    { "get_id", (PyCFunction)_wrap_galago_service_get_id, METH_NOARGS },
    { "get_name", (PyCFunction)_wrap_galago_service_get_name, METH_NOARGS },
    { "get_flags", (PyCFunction)_wrap_galago_service_get_flags, METH_NOARGS },
    { "create_account", (PyCFunction)_wrap_galago_service_create_account, METH_VARARGS|METH_KEYWORDS },
    { "get_account", (PyCFunction)_wrap_galago_service_get_account, METH_VARARGS|METH_KEYWORDS },
    { "get_accounts", (PyCFunction)_wrap_galago_service_get_accounts, METH_VARARGS|METH_KEYWORDS },
    { "normalize", (PyCFunction)_wrap_galago_service_normalize, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGalagoService_Type = {
    PyObject_HEAD_INIT(NULL)
    0,					/* ob_size */
    "galago.Service",			/* tp_name */
    sizeof(PyGObject),	        /* tp_basicsize */
    0,					/* tp_itemsize */
    /* methods */
    (destructor)0,	/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,	/* tp_getattr */
    (setattrfunc)0,	/* tp_setattr */
    (cmpfunc)0,		/* tp_compare */
    (reprfunc)0,		/* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,		/* tp_hash */
    (ternaryfunc)0,		/* tp_call */
    (reprfunc)0,		/* tp_str */
    (getattrofunc)0,	/* tp_getattro */
    (setattrofunc)0,	/* tp_setattro */
    (PyBufferProcs*)0,	/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL, 				/* Documentation string */
    (traverseproc)0,	/* tp_traverse */
    (inquiry)0,		/* tp_clear */
    (richcmpfunc)0,	/* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,		/* tp_iter */
    (iternextfunc)0,	/* tp_iternext */
    _PyGalagoService_methods,			/* tp_methods */
    0,					/* tp_members */
    0,		       	/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,	/* tp_descr_get */
    (descrsetfunc)0,	/* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,		/* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GalagoStatus ----------- */

static int
_wrap_galago_status_new(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    GType obj_type = pyg_type_from_object((PyObject *) self);
    GParameter params[4];
    PyObject *parsed_args[4] = {NULL, };
    char *arg_names[] = {"primitive", "id", "name", "exclusive", NULL };
    char *prop_names[] = {"primitive", "id", "name", "exclusive", NULL };
    guint nparams, i;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,  "OOOO:galago.Status.__init__" , arg_names , &parsed_args[0] , &parsed_args[1] , &parsed_args[2] , &parsed_args[3] ))
        return -1;

    memset(params, 0, sizeof(GParameter)*4);
    if (!pyg_parse_constructor_args(obj_type, arg_names, prop_names,
                                    params, &nparams, parsed_args))
        return -1;
    pygobject_constructv(self, nparams, params);

    for (i = 0; i < nparams; ++i)
        g_value_unset(&params[i].value);
    if (!self->obj) {
        PyErr_SetString(PyExc_RuntimeError, "could not create %(typename)s object");
        return -1;
    }

    return 0;
}


static PyObject *
_wrap_galago_status_duplicate(PyGObject *self)
{
    GalagoStatus *ret;

    ret = galago_status_duplicate(GALAGO_STATUS(self->obj));
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_status_set_presence(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "presence", NULL };
    PyGObject *presence;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!:GalagoStatus.set_presence", kwlist, &PyGalagoPresence_Type, &presence))
        return NULL;
    galago_status_set_presence(GALAGO_STATUS(self->obj), GALAGO_PRESENCE(presence->obj));
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_status_get_presence(PyGObject *self)
{
    GalagoPresence *ret;

    ret = galago_status_get_presence(GALAGO_STATUS(self->obj));
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_status_get_primitive(PyGObject *self)
{
    gint ret;

    ret = galago_status_get_primitive(GALAGO_STATUS(self->obj));
    return pyg_enum_from_gtype(GALAGO_TYPE_STATUS_TYPE, ret);
}

static PyObject *
_wrap_galago_status_get_id(PyGObject *self)
{
    const gchar *ret;

    ret = galago_status_get_id(GALAGO_STATUS(self->obj));
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_status_get_name(PyGObject *self)
{
    const gchar *ret;

    ret = galago_status_get_name(GALAGO_STATUS(self->obj));
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_status_is_exclusive(PyGObject *self)
{
    int ret;

    ret = galago_status_is_exclusive(GALAGO_STATUS(self->obj));
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_status_is_available(PyGObject *self)
{
    int ret;

    ret = galago_status_is_available(GALAGO_STATUS(self->obj));
    return PyBool_FromLong(ret);

}

static PyMethodDef _PyGalagoStatus_methods[] = {
    { "duplicate", (PyCFunction)_wrap_galago_status_duplicate, METH_NOARGS },
    { "set_presence", (PyCFunction)_wrap_galago_status_set_presence, METH_VARARGS|METH_KEYWORDS },
    { "get_presence", (PyCFunction)_wrap_galago_status_get_presence, METH_NOARGS },
    { "get_primitive", (PyCFunction)_wrap_galago_status_get_primitive, METH_NOARGS },
    { "get_id", (PyCFunction)_wrap_galago_status_get_id, METH_NOARGS },
    { "get_name", (PyCFunction)_wrap_galago_status_get_name, METH_NOARGS },
    { "is_exclusive", (PyCFunction)_wrap_galago_status_is_exclusive, METH_NOARGS },
    { "is_available", (PyCFunction)_wrap_galago_status_is_available, METH_NOARGS },
    { NULL, NULL, 0 }
};

PyTypeObject PyGalagoStatus_Type = {
    PyObject_HEAD_INIT(NULL)
    0,					/* ob_size */
    "galago.Status",			/* tp_name */
    sizeof(PyGObject),	        /* tp_basicsize */
    0,					/* tp_itemsize */
    /* methods */
    (destructor)0,	/* tp_dealloc */
    (printfunc)0,			/* tp_print */
    (getattrfunc)0,	/* tp_getattr */
    (setattrfunc)0,	/* tp_setattr */
    (cmpfunc)0,		/* tp_compare */
    (reprfunc)0,		/* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,		/* tp_hash */
    (ternaryfunc)0,		/* tp_call */
    (reprfunc)0,		/* tp_str */
    (getattrofunc)0,	/* tp_getattro */
    (setattrofunc)0,	/* tp_setattro */
    (PyBufferProcs*)0,	/* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL, 				/* Documentation string */
    (traverseproc)0,	/* tp_traverse */
    (inquiry)0,		/* tp_clear */
    (richcmpfunc)0,	/* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,		/* tp_iter */
    (iternextfunc)0,	/* tp_iternext */
    _PyGalagoStatus_methods,			/* tp_methods */
    0,					/* tp_members */
    0,		       	/* tp_getset */
    NULL,				/* tp_base */
    NULL,				/* tp_dict */
    (descrgetfunc)0,	/* tp_descr_get */
    (descrsetfunc)0,	/* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_galago_status_new,		/* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- functions ----------- */

static PyObject *
_wrap_galago_context_pop(PyObject *self)
{
    galago_context_pop();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_context_get(PyObject *self)
{
    GalagoContext *ret;

    ret = galago_context_get();
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_context_set_obj_path_prefix(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "prefix", NULL };
    char *prefix;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:context_set_obj_path_prefix", kwlist, &prefix))
        return NULL;
    galago_context_set_obj_path_prefix(prefix);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_context_get_obj_path_prefix(PyObject *self)
{
    const gchar *ret;

    ret = galago_context_get_obj_path_prefix();
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_context_get_service(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "id", "origin", NULL };
    char *id;
    PyObject *py_origin = NULL;
    GalagoOrigin origin = GALAGO_REMOTE;
    GalagoService *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|O:context_get_service", kwlist, &id, &py_origin))
        return NULL;
    if (pyg_enum_get_value(GALAGO_TYPE_ORIGIN, py_origin, (gint *)&origin))
        return NULL;
    ret = galago_context_get_service(id, origin);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

#line 103 "galago.override"
static PyObject *
_wrap_galago_context_get_services(PyGObject *self, PyObject *args,
								  PyObject *kwargs)
{
	static char *kwlist[] = { "origin", NULL };
	PyObject *py_origin = NULL;
	GalagoOrigin origin = GALAGO_REMOTE;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
									 "|O:galago.context_get_services",
									 kwlist, &py_origin))
	{
		return NULL;
	}

	if (py_origin != NULL &&
		pyg_enum_get_value(GALAGO_TYPE_ORIGIN, py_origin, (gint *)&origin))
	{
		return NULL;
	}

	return pygalago_wrap_gobj_list(galago_context_get_services(origin));
}
#line 1905 "galago.c"


static PyObject *
_wrap_galago_context_get_person(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "id", "origin", NULL };
    char *id;
    PyObject *py_origin = NULL;
    GalagoPerson *ret;
    GalagoOrigin origin = GALAGO_REMOTE;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|O:context_get_person", kwlist, &id, &py_origin))
        return NULL;
    if (pyg_enum_get_value(GALAGO_TYPE_ORIGIN, py_origin, (gint *)&origin))
        return NULL;
    ret = galago_context_get_person(id, origin);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_context_get_person_with_session_id(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "session_id", "origin", NULL };
    char *session_id;
    PyObject *py_origin = NULL;
    GalagoPerson *ret;
    GalagoOrigin origin = GALAGO_REMOTE;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|O:context_get_person_with_session_id", kwlist, &session_id, &py_origin))
        return NULL;
    if (pyg_enum_get_value(GALAGO_TYPE_ORIGIN, py_origin, (gint *)&origin))
        return NULL;
    ret = galago_context_get_person_with_session_id(session_id, origin);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

#line 128 "galago.override"
static PyObject *
_wrap_galago_context_get_people(PyGObject *self, PyObject *args,
								PyObject *kwargs)
{
	static char *kwlist[] = { "origin", NULL };
	PyObject *py_origin = NULL;
	GalagoOrigin origin = GALAGO_REMOTE;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
									 "|O:galago.context_get_people",
									 kwlist, &py_origin))
	{
		return NULL;
	}

	if (py_origin != NULL &&
		pyg_enum_get_value(GALAGO_TYPE_ORIGIN, py_origin, (gint *)&origin))
	{
		return NULL;
	}

	return pygalago_wrap_gobj_list(galago_context_get_people(origin));
}
#line 1968 "galago.c"


static PyObject *
_wrap_galago_context_get_object(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", NULL };
    char *path;
    GalagoObject *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:context_get_object", kwlist, &path))
        return NULL;
    ret = galago_context_get_object(path);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_init(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", "flags", NULL };
    char *name;
    PyObject *py_flags = NULL;
    int ret;
    GalagoInitFlags flags = GALAGO_INIT_CLIENT;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|O:init", kwlist, &name, &py_flags))
        return NULL;
    if (py_flags && pyg_flags_get_value(GALAGO_TYPE_INIT_FLAGS, py_flags, (gint *)&flags))
        return NULL;
    ret = galago_init(name, flags);
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_uninit(PyObject *self)
{
    galago_uninit();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_is_initted(PyObject *self)
{
    int ret;

    ret = galago_is_initted();
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_is_connected(PyObject *self)
{
    int ret;

    ret = galago_is_connected();
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_is_registered(PyObject *self)
{
    int ret;

    ret = galago_is_registered();
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_is_daemon_active(PyObject *self)
{
    int ret;

    ret = galago_is_daemon_active();
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_is_daemon(PyObject *self)
{
    int ret;

    ret = galago_is_daemon();
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_get_uid(PyObject *self)
{
    const gchar *ret;

    ret = galago_get_uid();
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_get_client_obj_path(PyObject *self)
{
    const gchar *ret;

    ret = galago_get_client_obj_path();
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_is_feed(PyObject *self)
{
    int ret;

    ret = galago_is_feed();
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_set_watch_all(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "watch_all", NULL };
    int watch_all;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "i:set_watch_all", kwlist, &watch_all))
        return NULL;
    galago_set_watch_all(watch_all);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_galago_get_watch_all(PyObject *self)
{
    int ret;

    ret = galago_get_watch_all();
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_galago_create_service(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "id", "name", "flags", NULL };
    char *id, *name = NULL;
    PyObject *py_flags = NULL;
    GalagoServiceFlags flags = 0;
    GalagoService *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|sO:create_service", kwlist, &id, &name, &py_flags))
        return NULL;
    if (py_flags && pyg_flags_get_value(GALAGO_TYPE_SERVICE_FLAGS, py_flags, (gint *)&flags))
        return NULL;
    ret = galago_create_service(id, name, flags);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

#line 205 "galago.override"
static PyObject *
_wrap_galago_get_service(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "id", "origin", "query", NULL };
    char *id;
    PyObject *py_origin = NULL;
    PyObject *query = Py_True;
    GalagoOrigin origin = GALAGO_REMOTE;
    GalagoService *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|OO:get_service",
									 kwlist, &id, &py_origin, &query))
	{
        return NULL;
	}

    if (py_origin != NULL &&
		pyg_enum_get_value(GALAGO_TYPE_ORIGIN, py_origin, (gint *)&origin))
	{
        return NULL;
	}

    return pygobject_new(
		(GObject *)galago_get_service(id, origin, PyObject_IsTrue(query)));
}
#line 2162 "galago.c"


#line 232 "galago.override"
static PyObject *
_wrap_galago_get_services(PyObject *self, PyObject *args, PyObject *kwargs)
{
	static char *kwlist[] = { "origin", "query", NULL };
	PyObject *py_origin = NULL;
	PyObject *query = Py_True;
	GalagoOrigin origin = GALAGO_REMOTE;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs,
									 "|OO:galago.get_services",
									 kwlist, &py_origin, &query))
	{
		return NULL;
	}

	if (py_origin != NULL &&
		pyg_enum_get_value(GALAGO_TYPE_ORIGIN, py_origin, (gint *)&origin))
	{
		return NULL;
	}

	return pygalago_wrap_gobj_list(
		galago_get_services(origin, PyObject_IsTrue(query)));
}
#line 2190 "galago.c"


static PyObject *
_wrap_galago_create_person(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "id", NULL };
    char *id = NULL;
    GalagoPerson *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|s:create_person", kwlist, &id))
        return NULL;
    ret = galago_create_person(id);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

#line 153 "galago.override"
static PyObject *
_wrap_galago_get_person(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "id", "origin", "query", NULL };
    char *id;
    PyObject *py_origin = NULL;
    PyObject *query = Py_True;
    GalagoPerson *ret;
    GalagoOrigin origin = GALAGO_REMOTE;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|OO:get_person",
									 kwlist, &id, &py_origin, &query))
	{
        return NULL;
	}

    if (py_origin != NULL &&
		pyg_enum_get_value(GALAGO_TYPE_ORIGIN, py_origin, (gint *)&origin))
	{
        return NULL;
	}

    return pygobject_new((GObject *)galago_get_person(id, origin,
													  PyObject_IsTrue(query)));
}
#line 2233 "galago.c"


#line 180 "galago.override"
static PyObject *
_wrap_galago_get_people(PyObject *self, PyObject *args, PyObject *kwargs)
{
	static char *kwlist[] = { "origin", "query", NULL };
	PyObject *py_origin = NULL;
	PyObject *query = Py_True;
	GalagoOrigin origin = GALAGO_REMOTE;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:galago.get_people",
									 kwlist, &py_origin, &query))
	{
		return NULL;
	}

	if (py_origin != NULL &&
		pyg_enum_get_value(GALAGO_TYPE_ORIGIN, py_origin, (gint *)&origin))
	{
		return NULL;
	}

	return pygalago_wrap_gobj_list(
		galago_get_people(origin, PyObject_IsTrue(query)));
}
#line 2260 "galago.c"


static PyObject *
_wrap_galago_get_me(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "origin", "query", NULL };
    PyObject *py_origin = NULL;
    int query = TRUE;
    GalagoPerson *ret;
    GalagoOrigin origin = GALAGO_REMOTE;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|Oi:get_me", kwlist, &py_origin, &query))
        return NULL;
    if (pyg_enum_get_value(GALAGO_TYPE_ORIGIN, py_origin, (gint *)&origin))
        return NULL;
    ret = galago_get_me(origin, query);
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_get_core(PyObject *self)
{
    GalagoCore *ret;

    ret = galago_get_core();
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_galago_object_type_get_dbus_signature(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "type", NULL };
    PyObject *py_type = NULL;
    const gchar *ret;
    GType type;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:galago_object_type_get_dbus_signature", kwlist, &py_type))
        return NULL;
    if ((type = pyg_type_from_object(py_type)) == 0)
        return NULL;
    ret = galago_object_type_get_dbus_signature(type);
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

PyMethodDef pygalago_functions[] = {
    { "context_pop", (PyCFunction)_wrap_galago_context_pop, METH_NOARGS },
    { "context_get", (PyCFunction)_wrap_galago_context_get, METH_NOARGS },
    { "context_set_obj_path_prefix", (PyCFunction)_wrap_galago_context_set_obj_path_prefix, METH_VARARGS|METH_KEYWORDS },
    { "context_get_obj_path_prefix", (PyCFunction)_wrap_galago_context_get_obj_path_prefix, METH_NOARGS },
    { "context_get_service", (PyCFunction)_wrap_galago_context_get_service, METH_VARARGS|METH_KEYWORDS },
    { "context_get_services", (PyCFunction)_wrap_galago_context_get_services, METH_VARARGS|METH_KEYWORDS },
    { "context_get_person", (PyCFunction)_wrap_galago_context_get_person, METH_VARARGS|METH_KEYWORDS },
    { "context_get_person_with_session_id", (PyCFunction)_wrap_galago_context_get_person_with_session_id, METH_VARARGS|METH_KEYWORDS },
    { "context_get_people", (PyCFunction)_wrap_galago_context_get_people, METH_VARARGS|METH_KEYWORDS },
    { "context_get_object", (PyCFunction)_wrap_galago_context_get_object, METH_VARARGS|METH_KEYWORDS },
    { "init", (PyCFunction)_wrap_galago_init, METH_VARARGS|METH_KEYWORDS },
    { "uninit", (PyCFunction)_wrap_galago_uninit, METH_NOARGS },
    { "is_initted", (PyCFunction)_wrap_galago_is_initted, METH_NOARGS },
    { "is_connected", (PyCFunction)_wrap_galago_is_connected, METH_NOARGS },
    { "is_registered", (PyCFunction)_wrap_galago_is_registered, METH_NOARGS },
    { "is_daemon_active", (PyCFunction)_wrap_galago_is_daemon_active, METH_NOARGS },
    { "is_daemon", (PyCFunction)_wrap_galago_is_daemon, METH_NOARGS },
    { "get_uid", (PyCFunction)_wrap_galago_get_uid, METH_NOARGS },
    { "get_client_obj_path", (PyCFunction)_wrap_galago_get_client_obj_path, METH_NOARGS },
    { "is_feed", (PyCFunction)_wrap_galago_is_feed, METH_NOARGS },
    { "set_watch_all", (PyCFunction)_wrap_galago_set_watch_all, METH_VARARGS|METH_KEYWORDS },
    { "get_watch_all", (PyCFunction)_wrap_galago_get_watch_all, METH_NOARGS },
    { "create_service", (PyCFunction)_wrap_galago_create_service, METH_VARARGS|METH_KEYWORDS },
    { "get_service", (PyCFunction)_wrap_galago_get_service, METH_VARARGS|METH_KEYWORDS },
    { "get_services", (PyCFunction)_wrap_galago_get_services, METH_VARARGS|METH_KEYWORDS },
    { "create_person", (PyCFunction)_wrap_galago_create_person, METH_VARARGS|METH_KEYWORDS },
    { "get_person", (PyCFunction)_wrap_galago_get_person, METH_VARARGS|METH_KEYWORDS },
    { "get_people", (PyCFunction)_wrap_galago_get_people, METH_VARARGS|METH_KEYWORDS },
    { "get_me", (PyCFunction)_wrap_galago_get_me, METH_VARARGS|METH_KEYWORDS },
    { "get_core", (PyCFunction)_wrap_galago_get_core, METH_NOARGS },
    { "galago_object_type_get_dbus_signature", (PyCFunction)_wrap_galago_object_type_get_dbus_signature, METH_VARARGS|METH_KEYWORDS },
    { NULL, NULL, 0 }
};


/* ----------- enums and flags ----------- */

void
pygalago_add_constants(PyObject *module, const gchar *strip_prefix)
{
  pyg_flags_add(module, "InitFlags", strip_prefix, GALAGO_TYPE_INIT_FLAGS);
  pyg_enum_add(module, "ObjectFlags", strip_prefix, GALAGO_TYPE_OBJECT_FLAGS);
  pyg_enum_add(module, "Origin", strip_prefix, GALAGO_TYPE_ORIGIN);
  pyg_flags_add(module, "ServiceFlags", strip_prefix, GALAGO_TYPE_SERVICE_FLAGS);
  pyg_enum_add(module, "StatusType", strip_prefix, GALAGO_TYPE_STATUS_TYPE);

  if (PyErr_Occurred())
    PyErr_Print();
}

/* initialise stuff extension classes */
void
pygalago_register_classes(PyObject *d)
{
    PyObject *module;

    if ((module = PyImport_ImportModule("gobject")) != NULL) {
        PyObject *moddict = PyModule_GetDict(module);

        _PyGObject_Type = (PyTypeObject *)PyDict_GetItemString(moddict, "GObject");
        if (_PyGObject_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name GObject from gobject");
            return;
        }
    } else {
        PyErr_SetString(PyExc_ImportError,
            "could not import gobject");
        return;
    }


#line 2383 "galago.c"
    pygobject_register_class(d, "GalagoObject", GALAGO_TYPE_OBJECT, &PyGalagoObject_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(GALAGO_TYPE_OBJECT);
    pygobject_register_class(d, "GalagoImage", GALAGO_TYPE_IMAGE, &PyGalagoImage_Type, Py_BuildValue("(O)", &PyGalagoObject_Type));
    pyg_set_object_has_new_constructor(GALAGO_TYPE_IMAGE);
    pygobject_register_class(d, "GalagoCore", GALAGO_TYPE_CORE, &PyGalagoCore_Type, Py_BuildValue("(O)", &PyGalagoObject_Type));
    pyg_set_object_has_new_constructor(GALAGO_TYPE_CORE);
    pygobject_register_class(d, "GalagoContext", GALAGO_TYPE_CONTEXT, &PyGalagoContext_Type, Py_BuildValue("(O)", &PyGalagoObject_Type));
    pyg_set_object_has_new_constructor(GALAGO_TYPE_CONTEXT);
    pygobject_register_class(d, "GalagoAccount", GALAGO_TYPE_ACCOUNT, &PyGalagoAccount_Type, Py_BuildValue("(O)", &PyGalagoObject_Type));
    pyg_set_object_has_new_constructor(GALAGO_TYPE_ACCOUNT);
    pygobject_register_class(d, "GalagoPerson", GALAGO_TYPE_PERSON, &PyGalagoPerson_Type, Py_BuildValue("(O)", &PyGalagoObject_Type));
    pyg_set_object_has_new_constructor(GALAGO_TYPE_PERSON);
    pygobject_register_class(d, "GalagoPresence", GALAGO_TYPE_PRESENCE, &PyGalagoPresence_Type, Py_BuildValue("(O)", &PyGalagoObject_Type));
    pyg_set_object_has_new_constructor(GALAGO_TYPE_PRESENCE);
    pygobject_register_class(d, "GalagoService", GALAGO_TYPE_SERVICE, &PyGalagoService_Type, Py_BuildValue("(O)", &PyGalagoObject_Type));
    pyg_set_object_has_new_constructor(GALAGO_TYPE_SERVICE);
    pygobject_register_class(d, "GalagoStatus", GALAGO_TYPE_STATUS, &PyGalagoStatus_Type, Py_BuildValue("(O)", &PyGalagoObject_Type));
    pyg_set_object_has_new_constructor(GALAGO_TYPE_STATUS);
}
