#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by astgen.boo.
//

namespace Boo.Lang.Compiler.Ast.Impl
{	
	using Boo.Lang.Compiler.Ast;
	using System.Collections;
	using System.Runtime.Serialization;
	
	[System.Serializable]
	public abstract class FieldImpl : TypeMember
	{
		protected TypeReference _type;

		protected Expression _initializer;

		protected FieldImpl()
		{
			InitializeFields();
		}
		
		protected FieldImpl(LexicalInfo info) : base(info)
		{
			InitializeFields();
		}
		
		protected FieldImpl(TypeReference type, Expression initializer)
		{
			InitializeFields();
			Type = type;
			Initializer = initializer;
		}
			
		protected FieldImpl(LexicalInfo lexicalInfo, TypeReference type, Expression initializer) : base(lexicalInfo)
		{
			InitializeFields();
			Type = type;
			Initializer = initializer;
		}

		new public Field CloneNode()
		{
			return Clone() as Field;
		}

		override public NodeType NodeType
		{
			get
			{
				return NodeType.Field;
			}
		}
		
		override public bool Matches(Node node)
		{	
			Field other = node as Field;
			if (null == other) return false;
			if (_modifiers != other._modifiers) return false;
			if (_name != other._name) return false;
			if (!Node.Matches(_attributes, other._attributes)) return false;
			if (!Node.Matches(_type, other._type)) return false;
			if (!Node.Matches(_initializer, other._initializer)) return false;
			return true;
		}
	
		override public bool Replace(Node existing, Node newNode)
		{
			if (base.Replace(existing, newNode))
			{
				return true;
			}
			if (_attributes != null)
			{
				Attribute item = existing as Attribute;
				if (null != item)
				{
					Attribute newItem = (Attribute)newNode;
					if (_attributes.Replace(item, newItem))
					{
						return true;
					}
				}
			}
			if (_type == existing)
			{
				this.Type = (TypeReference)newNode;
				return true;
			}
			if (_initializer == existing)
			{
				this.Initializer = (Expression)newNode;
				return true;
			}
			return false;
		}
		
		override public object Clone()
		{
			Field clone = (Field)FormatterServices.GetUninitializedObject(typeof(Field));
			clone._lexicalInfo = _lexicalInfo;
			clone._endSourceLocation = _endSourceLocation;
			clone._documentation = _documentation;
			clone._annotations = (Hashtable)_annotations.Clone();
		
			clone._modifiers = _modifiers;
			clone._name = _name;
			if (null != _attributes)
			{
				clone._attributes = _attributes.Clone() as AttributeCollection;
				clone._attributes.InitializeParent(clone);
			}
			if (null != _type)
			{
				clone._type = _type.Clone() as TypeReference;
				clone._type.InitializeParent(clone);
			}
			if (null != _initializer)
			{
				clone._initializer = _initializer.Clone() as Expression;
				clone._initializer.InitializeParent(clone);
			}
			return clone;
		}
		
		override internal void ClearTypeSystemBindings()
		{
			_annotations.Clear();
			if (null != _attributes)
			{
				_attributes.ClearTypeSystemBindings();
			}
			if (null != _type)
			{
				_type.ClearTypeSystemBindings();
			}
			if (null != _initializer)
			{
				_initializer.ClearTypeSystemBindings();
			}

		}
	

		[System.Xml.Serialization.XmlElement]
		public TypeReference Type
		{
			get
			{
				return _type;
			}

			set
			{
				if (_type != value)
				{
					OnReplace(_type, value);
					_type = value;
					if (null != _type)
					{
						_type.InitializeParent(this);
					}
				}
			}

		}
		

		[System.Xml.Serialization.XmlElement]
		public Expression Initializer
		{
			get
			{
				return _initializer;
			}

			set
			{
				if (_initializer != value)
				{
					OnReplace(_initializer, value);
					_initializer = value;
					if (null != _initializer)
					{
						_initializer.InitializeParent(this);
					}
				}
			}

		}
		
		private void InitializeFields()
		{

		}
	}
}

