/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2005 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __SCIM_TOMOE_PREFS_WIN_H__
#define __SCIM_TOMOE_PREFS_WIN_H__

#define Uses_SCIM_CONFIG_BASE
#include <gtk/gtk.h>
#include <scim.h>
#include <tomoe-gtk.h>

using namespace scim;

#define SCIM_TOMOE_TYPE_PREFS_WIN            (scim_tomoe_prefs_win_get_type ())
#define SCIM_TOMOE_PREFS_WIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCIM_TOMOE_TYPE_PREFS_WIN, ScimTomoePrefsWin))
#define SCIM_TOMOE_PREFS_WIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCIM_TOMOE_TYPE_PREFS_WIN, ScimTomoePrefsWinClass))
#define SCIM_TOMOE_IS_PREFS_WIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCIM_TOMOE_TYPE_PREFS_WIN))
#define SCIM_TOMOE_IS_PREFS_WIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCIM_TOMOE_TYPE_PREFS_WIN))
#define SCIM_TOMOE_PREFS_WIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), SCIM_TOMOE_TYPE_PREFS_WIN, ScimTomoePrefsWinClass))


typedef struct _ScimTomoePrefsWinClass ScimTomoePrefsWinClass;
typedef struct _ScimTomoePrefsWin      ScimTomoePrefsWin;

struct _ScimTomoePrefsWin
{
    GtkDialog      parent_instance;
    GtkWidget     *parent;
    ConfigPointer  config;

    GList         *widget_list;
};

struct _ScimTomoePrefsWinClass
{
    GtkDialogClass parent_class;
};


GType       scim_tomoe_prefs_win_get_type (void) G_GNUC_CONST;
GtkWidget  *scim_tomoe_prefs_win_new      (TomoeWindow *window,
                                           const ConfigPointer &config);

#endif /* __SCIM_TOMOE_PREFS_WIN_H__ */
