# lang_helper.rb - a sample script for Ruby on Rails
#
# Copyright (C) 2005 Masao Mutoh
#
# This file is distributed under the same license as Ruby-GetText-Package.

module LangHelper
  # If you need to bind yet another textdomain to your helper.
  # Separate the name space from ActionView::Base/ApplicationController.
  class YetanotherTextDomain
    include GetText::Rails

    def initialize
      # You need to call bindtextdomain in an instance of ActionView::Base.
      # The locale is set automatically or use Cookie value, parameter "lang".
      bindtextdomain("lang_helper") 

      # Or set locale forcely.
      #bindtextdomain("lang_helper", nil, "ja")
    end

    def show_language(actionview)
      langs = ["en"] + Dir.glob(File.join(RAILS_ROOT,"locale/*")).collect{|item| File.basename(item)}
      ret = "<h4>" + _("Select locale") + "</h4>"
      langs.sort.each do |lang|
	ret << actionview.link_to("[#{lang}]", :action => "cookie_locale", :lang => lang)
      end
      ret
    end
    def cookie_locale(cookies, flash, params)
      cookies["lang"] = params["lang"]
      flash[:notice] = _('Cookie &quot;lang&quot; is set: %s') % params["lang"]
    end
  end

  # This function shows supported languages with link to set cookie 
  # action (coolie_locale).
  def show_language
    YetanotherTextDomain.new.show_language(self)
  end

  # This function is called when the language link is set.
  def cookie_locale
    YetanotherTextDomain.new.cookie_locale(cookies, flash, @params)
    redirect_to :action => 'list'
  end
    
end
 
