# application.rb - a sample script for Ruby on Rails
#
# Copyright (C) 2005 Masao Mutoh
#
# This file is distributed under the same license as Ruby-GetText-Package.

# Require 'gettext/rails' first.
require 'gettext/rails'

# lang_helper is sample helper. It has its own textdomain(lang_helper).
# (See vendor/lang_helper.rb).
require 'lang_helper'

class ApplicationController < ActionController::Base
  # for lang_helper.
  helper LangHelper
  include LangHelper

  # Initialize GetText and Content-Type.
  # You need to call this once a request from WWW browser.
  # You can select the scope of the textdomain.
  # 1. If you call bindtextdomain in ApplicationControler,
  #    The textdomain apply whole your application.
  # 2. If you call bindtextdomain in each controllers
  #    (In this sample, blog_controller.rb is applicable)
  #    The textdomains are applied to each controllers/views.
  before_filter :init_gettext
  def init_gettext
    # The locale is set automatically or use Cookie value, parameter "lang".
    bindtextdomain("blog", request.cgi)  #You need to pass CGI object first.

    # Or set locale forcely.
    #bindtextdomain("blog", request.cgi, "ja")

    @headers["Content-Type"] = "text/html; charset=UTF-8"
  end
end
