=begin
  gettext/rails.rb - GetText for "Ruby on Rails"

  Copyright (C) 2005  Masao Mutoh

  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: rails.rb,v 1.1 2005/08/27 18:52:20 mutoh Exp $
=end

require 'gettext'
require 'gettext/cgi'

module GetText
  module Rails
    include GetText

    alias :_bindtextdomain :bindtextdomain

    def bindtextdomain(domainname, _cgi = nil, locale = nil, charset = "UTF-8")
      set_cgi(_cgi) if _cgi
      @gettext_container_domainname = domainname
      path = File.join(RAILS_ROOT, "locale")
      _bindtextdomain(domainname, path, locale, charset)
    end

    def callersrc
      @gettext_container_domainname
    end

  end
end

module ActionController
  class Base
    helper GetText::Rails
    include GetText::Rails
  end
end
