=begin
  locale_default.rb - Locale module for Default OS(Unix).

  Copyright (C) 2002-2005  Masao Mutoh <mutoh@highway.ne.jp>

  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: locale_default.rb,v 1.2 2005/08/20 17:05:34 mutoh Exp $
=end

module Locale
  @@locale_initialized = false
  alias :__set :set
  def __get(lctype = Locale::CTYPE)
    # Initialize CTYPE first lazily. 
    # This isn't called when 'gettext/cgi' is required.
    unless @@locale_initialized
      Locale.set(lctype, "") 
      @@locale_initialized = true
    end
    set(lctype, nil)
  end

  def set(lctype, loc)
    ret = __set(lctype, loc)
    if loc and ! @@locale_initialized
      @@locale_initialized = true
    end
    ret
  end

  module_function :__get, :set, :__set
end

