=begin
  locale.rb - Locale module

  Copyright (C) 2002-2005  Masao Mutoh

  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: locale.rb,v 1.3 2005/08/22 16:56:33 mutoh Exp $
=end

begin
  require 'gettext/_locale'
rescue LoadError
  # For rubygems
  begin
    require '_locale'
  rescue LoadError
    # This is used for installation process(from rake only)
    module Locale
      CTYPE = 0
      NUMERIC = 1
      TIME = 2
      COLLATE = 3
      MONETARY = 4
      MESSAGES = 5
      ALL = 6

      module_function
      def codeset; "UTF-8"; end
      def set(lc, val);	"C"; end
      def __locale_id; [0x00, 0x00]; end
    end
  end
end

if /cygwin|mingw|mswin32|bccwin32/ =~ RUBY_PLATFORM
  require 'gettext/locale_win32'
else
  require 'gettext/locale_default'
end

module Locale
  def get
    ret = __get
    return ret if ret
    
    ret = nil
    ["LC_ALL", "LC_MESSAGES", "LANG"].each do |env|
      ret = ENV[env]
      break if ret
    end
    
    ret = "C" unless ret
    ret
  end
  
  alias :setlocale :set
  alias :charset :codeset
  
  module_function :get, :setlocale, :charset
end

if __FILE__ == $0
  p Locale.set(Locale::CTYPE, "")
  p Locale.set(Locale::CTYPE, nil)
  p Locale.set(Locale::CTYPE, "ja_JP.eucJP")
  p Locale.set(Locale::MESSAGES, nil)
  p Locale.get
  p Locale.codeset
end
