use tui::style::{Color, Modifier};

use crate::options::config::style::{utils::convert_hex_to_color, ColourPalette};

use super::{color, hex};

impl ColourPalette {
    pub(crate) fn gruvbox_palette() -> Self {
        Self {
            selected_text_style: hex!("#1d2021").bg(convert_hex_to_color("#ebdbb2").unwrap()),
            table_header_style: hex!("#83a598").add_modifier(Modifier::BOLD),
            ram_style: hex!("#8ec07c"),
            #[cfg(not(target_os = "windows"))]
            cache_style: hex!("#b16286"),
            swap_style: hex!("#fabd2f"),
            arc_style: hex!("#689d6a"),
            gpu_colours: vec![
                hex!("#d79921"),
                hex!("#458588"),
                hex!("#b16286"),
                hex!("#fe8019"),
                hex!("#b8bb26"),
                hex!("#cc241d"),
                hex!("#98971a"),
            ],
            rx_style: hex!("#8ec07c"),
            tx_style: hex!("#fabd2f"),
            total_rx_style: hex!("#689d6a"),
            total_tx_style: hex!("#d79921"),
            all_cpu_colour: hex!("#8ec07c"),
            avg_cpu_colour: hex!("#fb4934"),
            cpu_colour_styles: vec![
                hex!("#cc241d"),
                hex!("#98971a"),
                hex!("#d79921"),
                hex!("#458588"),
                hex!("#b16286"),
                hex!("#689d6a"),
                hex!("#fe8019"),
                hex!("#b8bb26"),
                hex!("#fabd2f"),
                hex!("#83a598"),
                hex!("#d3869b"),
                hex!("#d65d0e"),
                hex!("#9d0006"),
                hex!("#79740e"),
                hex!("#b57614"),
                hex!("#076678"),
                hex!("#8f3f71"),
                hex!("#427b58"),
                hex!("#d65d03"),
                hex!("#af3a03"),
            ],
            border_style: hex!("#ebdbb2"),
            highlighted_border_style: hex!("#fe8019"),
            text_style: hex!("#ebdbb2"),
            widget_title_style: hex!("#ebdbb2"),
            graph_style: hex!("#ebdbb2"),
            graph_legend_style: hex!("#ebdbb2"),
            high_battery: hex!("#98971a"),
            medium_battery: hex!("#fabd2f"),
            low_battery: hex!("#fb4934"),
            invalid_query_style: color!(Color::Red),
            disabled_text_style: hex!("#665c54"),
        }
    }

    pub(crate) fn gruvbox_light_palette() -> Self {
        Self {
            selected_text_style: hex!("#ebdbb2").bg(convert_hex_to_color("#3c3836").unwrap()),
            table_header_style: hex!("#076678").add_modifier(Modifier::BOLD),
            ram_style: hex!("#427b58"),
            #[cfg(not(target_os = "windows"))]
            cache_style: hex!("#d79921"),
            swap_style: hex!("#cc241d"),
            arc_style: hex!("#689d6a"),
            gpu_colours: vec![
                hex!("#9d0006"),
                hex!("#98971a"),
                hex!("#d79921"),
                hex!("#458588"),
                hex!("#b16286"),
                hex!("#fe8019"),
                hex!("#b8bb26"),
            ],
            rx_style: hex!("#427b58"),
            tx_style: hex!("#cc241d"),
            total_rx_style: hex!("#689d6a"),
            total_tx_style: hex!("#d79921"),
            all_cpu_colour: hex!("#8ec07c"),
            avg_cpu_colour: hex!("#fb4934"),
            cpu_colour_styles: vec![
                hex!("#cc241d"),
                hex!("#98971a"),
                hex!("#d79921"),
                hex!("#458588"),
                hex!("#b16286"),
                hex!("#689d6a"),
                hex!("#fe8019"),
                hex!("#b8bb26"),
                hex!("#fabd2f"),
                hex!("#83a598"),
                hex!("#d3869b"),
                hex!("#d65d0e"),
                hex!("#9d0006"),
                hex!("#79740e"),
                hex!("#b57614"),
                hex!("#076678"),
                hex!("#8f3f71"),
                hex!("#427b58"),
                hex!("#d65d03"),
                hex!("#af3a03"),
            ],
            border_style: hex!("#ebdbb2"),
            highlighted_border_style: hex!("#fe8019"),
            text_style: hex!("#ebdbb2"),
            widget_title_style: hex!("#ebdbb2"),
            graph_style: hex!("#ebdbb2"),
            graph_legend_style: hex!("#ebdbb2"),
            high_battery: hex!("#98971a"),
            medium_battery: hex!("#fabd2f"),
            low_battery: hex!("#fb4934"),
            invalid_query_style: color!(Color::Red),
            disabled_text_style: hex!("#665c54"),
        }
    }
}
