pub const ext = @import("ext.zig");
const webkit = @This();

const std = @import("std");
const compat = @import("compat");
const soup = @import("soup3");
const gio = @import("gio2");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
const javascriptcore = @import("javascriptcore6");
const gtk = @import("gtk4");
const gsk = @import("gsk4");
const graphene = @import("graphene1");
const gdk = @import("gdk4");
const cairo = @import("cairo1");
const pangocairo = @import("pangocairo1");
const pango = @import("pango1");
const harfbuzz = @import("harfbuzz0");
const freetype2 = @import("freetype22");
const gdkpixbuf = @import("gdkpixbuf2");
/// Represents an authentication request.
///
/// Whenever a client attempts to load a page protected by HTTP
/// authentication, credentials will need to be provided to authorize access.
/// To allow the client to decide how it wishes to handle authentication,
/// WebKit will fire a `webkit.WebView.signals.authenticate` signal with a
/// WebKitAuthenticationRequest object to provide client side
/// authentication support. Credentials are exposed through the
/// `webkit.Credential` object.
///
/// In case the client application does not wish
/// to handle this signal WebKit will provide a default handler. To handle
/// authentication asynchronously, simply increase the reference count of the
/// WebKitAuthenticationRequest object.
pub const AuthenticationRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.AuthenticationRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// This signal is emitted when the user authentication request succeeded.
        /// Applications handling their own credential storage should connect to
        /// this signal to save the credentials.
        pub const authenticated = struct {
            pub const name = "authenticated";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_credential: *webkit.Credential, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(AuthenticationRequest, p_instance))),
                    gobject.signalLookup("authenticated", AuthenticationRequest.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when the user authentication request is
        /// cancelled. It allows the application to dismiss its authentication
        /// dialog in case of page load failure for example.
        pub const cancelled = struct {
            pub const name = "cancelled";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(AuthenticationRequest, p_instance))),
                    gobject.signalLookup("cancelled", AuthenticationRequest.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Authenticate the `webkit.AuthenticationRequest`.
    ///
    /// Authenticate the `webkit.AuthenticationRequest` using the `webkit.Credential`
    /// supplied. To continue without credentials, pass `NULL` as `credential`.
    extern fn webkit_authentication_request_authenticate(p_request: *AuthenticationRequest, p_credential: ?*webkit.Credential) void;
    pub const authenticate = webkit_authentication_request_authenticate;

    /// Determine whether this `webkit.AuthenticationRequest` should allow the storage of credentials.
    ///
    /// Determine whether the authentication method associated with this
    /// `webkit.AuthenticationRequest` should allow the storage of credentials.
    /// This will return `FALSE` if WebKit doesn't support credential storing,
    /// if private browsing is enabled, or if persistent credential storage has been
    /// disabled in `webkit.WebsiteDataManager`, unless credentials saving has been
    /// explicitly enabled with `webkit.AuthenticationRequest.setCanSaveCredentials`.
    extern fn webkit_authentication_request_can_save_credentials(p_request: *AuthenticationRequest) c_int;
    pub const canSaveCredentials = webkit_authentication_request_can_save_credentials;

    /// Cancel the authentication challenge.
    ///
    /// This will also cancel the page loading and result in a
    /// `webkit.WebView.signals.load`-failed signal with a `webkit.NetworkError` of type `WEBKIT_NETWORK_ERROR_CANCELLED` being emitted.
    extern fn webkit_authentication_request_cancel(p_request: *AuthenticationRequest) void;
    pub const cancel = webkit_authentication_request_cancel;

    /// Get the `gio.TlsPasswordFlags` of the `WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_PIN_REQUESTED` authentication challenge.
    extern fn webkit_authentication_request_get_certificate_pin_flags(p_request: *AuthenticationRequest) gio.TlsPasswordFlags;
    pub const getCertificatePinFlags = webkit_authentication_request_get_certificate_pin_flags;

    /// Get the host that this authentication challenge is applicable to.
    extern fn webkit_authentication_request_get_host(p_request: *AuthenticationRequest) [*:0]const u8;
    pub const getHost = webkit_authentication_request_get_host;

    /// Get the port that this authentication challenge is applicable to.
    extern fn webkit_authentication_request_get_port(p_request: *AuthenticationRequest) c_uint;
    pub const getPort = webkit_authentication_request_get_port;

    /// Get the `webkit.Credential` of the proposed authentication challenge.
    ///
    /// Get the `webkit.Credential` of the proposed authentication challenge that was
    /// stored from a previous session. The client can use this directly for
    /// authentication or construct their own `webkit.Credential`.
    extern fn webkit_authentication_request_get_proposed_credential(p_request: *AuthenticationRequest) *webkit.Credential;
    pub const getProposedCredential = webkit_authentication_request_get_proposed_credential;

    /// Get the realm that this authentication challenge is applicable to.
    extern fn webkit_authentication_request_get_realm(p_request: *AuthenticationRequest) [*:0]const u8;
    pub const getRealm = webkit_authentication_request_get_realm;

    /// Get the authentication scheme of the authentication challenge.
    extern fn webkit_authentication_request_get_scheme(p_request: *AuthenticationRequest) webkit.AuthenticationScheme;
    pub const getScheme = webkit_authentication_request_get_scheme;

    /// Get the `webkit.SecurityOrigin` that this authentication challenge is applicable to.
    extern fn webkit_authentication_request_get_security_origin(p_request: *AuthenticationRequest) *webkit.SecurityOrigin;
    pub const getSecurityOrigin = webkit_authentication_request_get_security_origin;

    /// Determine whether the authentication challenge is associated with a proxy server.
    ///
    /// Determine whether the authentication challenge is associated with a proxy server rather than an "origin" server.
    extern fn webkit_authentication_request_is_for_proxy(p_request: *AuthenticationRequest) c_int;
    pub const isForProxy = webkit_authentication_request_is_for_proxy;

    /// Determine whether this this is a first attempt or a retry for this authentication challenge.
    extern fn webkit_authentication_request_is_retry(p_request: *AuthenticationRequest) c_int;
    pub const isRetry = webkit_authentication_request_is_retry;

    /// Set whether the authentication method associated with `request`
    /// should allow the storage of credentials.
    ///
    /// Set whether the authentication method associated with `request`
    /// should allow the storage of credentials.
    /// This should be used by applications handling their own credentials
    /// storage to indicate that it should be supported even when internal
    /// credential storage is disabled or unsupported.
    /// Note that storing of credentials will not be allowed on ephemeral
    /// sessions in any case.
    extern fn webkit_authentication_request_set_can_save_credentials(p_request: *AuthenticationRequest, p_enabled: c_int) void;
    pub const setCanSaveCredentials = webkit_authentication_request_set_can_save_credentials;

    /// Set the `webkit.Credential` of the proposed authentication challenge.
    ///
    /// Set the `webkit.Credential` of the proposed authentication challenge that was
    /// stored from a previous session. This should only be used by applications handling
    /// their own credential storage. (When using the default WebKit credential storage,
    /// `webkit.AuthenticationRequest.getProposedCredential` already contains previously-stored
    /// credentials.)
    /// Passing a `NULL` `credential` will clear the proposed credential.
    extern fn webkit_authentication_request_set_proposed_credential(p_request: *AuthenticationRequest, p_credential: *webkit.Credential) void;
    pub const setProposedCredential = webkit_authentication_request_set_proposed_credential;

    extern fn webkit_authentication_request_get_type() usize;
    pub const getGObjectType = webkit_authentication_request_get_type;

    extern fn g_object_ref(p_self: *webkit.AuthenticationRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.AuthenticationRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AuthenticationRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Automation Session.
///
/// WebKitAutomationSession represents an automation session of a WebKitWebContext.
/// When a new session is requested, a WebKitAutomationSession is created and the signal
/// WebKitWebContext::automation-started is emitted with the WebKitAutomationSession as
/// argument. Then, the automation client can request the session to create a new
/// `webkit.WebView` to interact with it. When this happens the signal `webkit.AutomationSession.signals.create`-web-view
/// is emitted.
pub const AutomationSession = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.AutomationSessionClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The session unique identifier.
        pub const id = struct {
            pub const name = "id";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {
        /// This signal is emitted when the automation client requests a new
        /// browsing context to interact with it. The callback handler should
        /// return a `webkit.WebView` created with `webkit.WebView.properties.is`-controlled-by-automation
        /// construct property enabled and `webkit.WebView.properties.automation`-presentation-type construct
        /// property set if needed.
        ///
        /// If the signal is emitted with "tab" detail, the returned `webkit.WebView` should be
        /// a new web view added to a new tab of the current browsing context window.
        /// If the signal is emitted with "window" detail, the returned `webkit.WebView` should be
        /// a new web view added to a new window.
        /// When creating a new web view and there's an active browsing context, the new window
        /// or tab shouldn't be focused.
        pub const create_web_view = struct {
            pub const name = "create-web-view";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) *webkit.WebView, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(AutomationSession, p_instance))),
                    gobject.signalLookup("create-web-view", AutomationSession.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when the given automation session is about to finish.
        /// It allows clients to perform any cleanup tasks before the session is destroyed.
        pub const will_close = struct {
            pub const name = "will-close";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(AutomationSession, p_instance))),
                    gobject.signalLookup("will-close", AutomationSession.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Get the the previously set `webkit.AutomationSession`.
    ///
    /// Get the `webkit.AutomationSession` previously set with `webkit.AutomationSession.setApplicationInfo`.
    extern fn webkit_automation_session_get_application_info(p_session: *AutomationSession) *webkit.ApplicationInfo;
    pub const getApplicationInfo = webkit_automation_session_get_application_info;

    /// Get the unique identifier of a `webkit.AutomationSession`
    extern fn webkit_automation_session_get_id(p_session: *AutomationSession) [*:0]const u8;
    pub const getId = webkit_automation_session_get_id;

    /// Set the application information to `session`.
    ///
    /// This information will be used by the driver service
    /// to match the requested capabilities with the actual application information. If this information
    /// is not provided to the session when a new automation session is requested, the creation might fail
    /// if the client requested a specific browser name or version. This will not have any effect when called
    /// after the automation session has been fully created, so this must be called in the callback of
    /// `webkit.WebContext.signals.automation`-started signal.
    extern fn webkit_automation_session_set_application_info(p_session: *AutomationSession, p_info: *webkit.ApplicationInfo) void;
    pub const setApplicationInfo = webkit_automation_session_set_application_info;

    extern fn webkit_automation_session_get_type() usize;
    pub const getGObjectType = webkit_automation_session_get_type;

    extern fn g_object_ref(p_self: *webkit.AutomationSession) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.AutomationSession) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AutomationSession, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// List of visited pages.
///
/// WebKitBackForwardList maintains a list of visited pages used to
/// navigate to recent pages. Items are inserted in the list in the
/// order they are visited.
///
/// WebKitBackForwardList also maintains the notion of the current item
/// (which is always at index 0), the preceding item (which is at index -1),
/// and the following item (which is at index 1).
/// Methods `webkit.WebView.goBack` and `webkit.WebView.goForward` move
/// the current item backward or forward by one. Method
/// `webkit.WebView.goToBackForwardListItem` sets the current item to the
/// specified item. All other methods returning `webkit.BackForwardListItem`<!-- -->s
/// do not change the value of the current item, they just return the requested
/// item or items.
pub const BackForwardList = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.BackForwardListClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// This signal is emitted when `back_forward_list` changes. This happens
        /// when the current item is updated, a new item is added or one or more
        /// items are removed. Note that both `item_added` and `items_removed` can
        /// `NULL` when only the current item is updated. Items are only removed
        /// when the list is cleared or the maximum items limit is reached.
        pub const changed = struct {
            pub const name = "changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_item_added: ?*webkit.BackForwardListItem, p_items_removed: ?*anyopaque, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(BackForwardList, p_instance))),
                    gobject.signalLookup("changed", BackForwardList.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Returns the item that precedes the current item.
    extern fn webkit_back_forward_list_get_back_item(p_back_forward_list: *BackForwardList) ?*webkit.BackForwardListItem;
    pub const getBackItem = webkit_back_forward_list_get_back_item;

    /// Obtain the list of items preceding the current one.
    extern fn webkit_back_forward_list_get_back_list(p_back_forward_list: *BackForwardList) *glib.List;
    pub const getBackList = webkit_back_forward_list_get_back_list;

    /// Obtain a list up to some number of items preceding the current one.
    extern fn webkit_back_forward_list_get_back_list_with_limit(p_back_forward_list: *BackForwardList, p_limit: c_uint) *glib.List;
    pub const getBackListWithLimit = webkit_back_forward_list_get_back_list_with_limit;

    /// Returns the current item in `back_forward_list`.
    extern fn webkit_back_forward_list_get_current_item(p_back_forward_list: *BackForwardList) ?*webkit.BackForwardListItem;
    pub const getCurrentItem = webkit_back_forward_list_get_current_item;

    /// Returns the item that follows the current item.
    extern fn webkit_back_forward_list_get_forward_item(p_back_forward_list: *BackForwardList) ?*webkit.BackForwardListItem;
    pub const getForwardItem = webkit_back_forward_list_get_forward_item;

    /// Obtain the list of items following the current one.
    extern fn webkit_back_forward_list_get_forward_list(p_back_forward_list: *BackForwardList) *glib.List;
    pub const getForwardList = webkit_back_forward_list_get_forward_list;

    /// Obtain a list up to some number of items following the current one.
    extern fn webkit_back_forward_list_get_forward_list_with_limit(p_back_forward_list: *BackForwardList, p_limit: c_uint) *glib.List;
    pub const getForwardListWithLimit = webkit_back_forward_list_get_forward_list_with_limit;

    /// Obtain the amount of items in the list.
    extern fn webkit_back_forward_list_get_length(p_back_forward_list: *BackForwardList) c_uint;
    pub const getLength = webkit_back_forward_list_get_length;

    /// Returns the item at a given index relative to the current item.
    extern fn webkit_back_forward_list_get_nth_item(p_back_forward_list: *BackForwardList, p_index: c_int) ?*webkit.BackForwardListItem;
    pub const getNthItem = webkit_back_forward_list_get_nth_item;

    extern fn webkit_back_forward_list_get_type() usize;
    pub const getGObjectType = webkit_back_forward_list_get_type;

    extern fn g_object_ref(p_self: *webkit.BackForwardList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.BackForwardList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *BackForwardList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// One item of the `webkit.BackForwardList`.
///
/// A history item is part of the `webkit.BackForwardList` and consists
/// out of a title and a URI.
pub const BackForwardListItem = opaque {
    pub const Parent = gobject.InitiallyUnowned;
    pub const Implements = [_]type{};
    pub const Class = webkit.BackForwardListItemClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Obtain the original URI of the item.
    ///
    /// See also `webkit.BackForwardListItem.getUri`.
    extern fn webkit_back_forward_list_item_get_original_uri(p_list_item: *BackForwardListItem) [*:0]const u8;
    pub const getOriginalUri = webkit_back_forward_list_item_get_original_uri;

    /// Obtain the title of the item.
    extern fn webkit_back_forward_list_item_get_title(p_list_item: *BackForwardListItem) [*:0]const u8;
    pub const getTitle = webkit_back_forward_list_item_get_title;

    /// Obtain the URI of the item.
    ///
    /// This URI may differ from the original URI if the page was,
    /// for example, redirected to a new location.
    /// See also `webkit.BackForwardListItem.getOriginalUri`.
    extern fn webkit_back_forward_list_item_get_uri(p_list_item: *BackForwardListItem) [*:0]const u8;
    pub const getUri = webkit_back_forward_list_item_get_uri;

    extern fn webkit_back_forward_list_item_get_type() usize;
    pub const getGObjectType = webkit_back_forward_list_item_get_type;

    extern fn g_object_ref(p_self: *webkit.BackForwardListItem) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.BackForwardListItem) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *BackForwardListItem, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A permission request for reading clipboard contents.
///
/// WebKitClipboardPermissionRequest represents a request for
/// permission to decide whether WebKit can access the clipboard to read
/// its contents through the Async Clipboard API.
///
/// When a WebKitClipboardPermissionRequest is not handled by the user,
/// it is denied by default.
pub const ClipboardPermissionRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{webkit.PermissionRequest};
    pub const Class = webkit.ClipboardPermissionRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_clipboard_permission_request_get_type() usize;
    pub const getGObjectType = webkit_clipboard_permission_request_get_type;

    extern fn g_object_ref(p_self: *webkit.ClipboardPermissionRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.ClipboardPermissionRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ClipboardPermissionRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A request to open a color chooser.
///
/// Whenever the user interacts with an <input type='color' />
/// HTML element, WebKit will need to show a dialog to choose a color. For that
/// to happen in a general way, instead of just opening a `gtk.ColorChooser`
/// (which might be not desirable in some cases, which could prefer to use their
/// own color chooser dialog), WebKit will fire the
/// `webkit.WebView.signals.run`-color-chooser signal with a `webkit.ColorChooserRequest`
/// object, which will allow the client application to specify the color to be
/// selected, to inspect the details of the request (e.g. to get initial color)
/// and to cancel the request, in case nothing was selected.
///
/// In case the client application does not wish to handle this signal,
/// WebKit will provide a default handler which will asynchronously run
/// a regular `gtk.ColorChooserDialog` for the user to interact with.
pub const ColorChooserRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.ColorChooserRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `gdk.RGBA` color of the request
        pub const rgba = struct {
            pub const name = "rgba";

            pub const Type = ?*gdk.RGBA;
        };
    };

    pub const signals = struct {
        /// Emitted when the `request` finishes. This signal can be emitted because the
        /// user completed the `request` calling `webkit.ColorChooserRequest.finish`,
        /// or cancelled it with `webkit.ColorChooserRequest.cancel` or because the
        /// color input element is removed from the DOM.
        pub const finished = struct {
            pub const name = "finished";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(ColorChooserRequest, p_instance))),
                    gobject.signalLookup("finished", ColorChooserRequest.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Cancels `request` and the input element changes to use the initial color.
    ///
    /// Cancels `request` and the input element changes to use the initial color
    /// it has before the request started.
    /// The signal `webkit.ColorChooserRequest.signals.finished`
    /// is emitted to notify that the request has finished.
    extern fn webkit_color_chooser_request_cancel(p_request: *ColorChooserRequest) void;
    pub const cancel = webkit_color_chooser_request_cancel;

    /// Finishes `request` and the input element keeps the current value of
    /// `webkit.ColorChooserRequest.properties.rgba`.
    ///
    /// Finishes `request` and the input element keeps the current value of
    /// `webkit.ColorChooserRequest.properties.rgba`.
    /// The signal `webkit.ColorChooserRequest.signals.finished`
    /// is emitted to notify that the request has finished.
    extern fn webkit_color_chooser_request_finish(p_request: *ColorChooserRequest) void;
    pub const finish = webkit_color_chooser_request_finish;

    /// Gets the bounding box of the color input element.
    extern fn webkit_color_chooser_request_get_element_rectangle(p_request: *ColorChooserRequest, p_rect: *gdk.Rectangle) void;
    pub const getElementRectangle = webkit_color_chooser_request_get_element_rectangle;

    /// Gets the current `gdk.RGBA` color of `request`
    extern fn webkit_color_chooser_request_get_rgba(p_request: *ColorChooserRequest, p_rgba: *gdk.RGBA) void;
    pub const getRgba = webkit_color_chooser_request_get_rgba;

    /// Sets the current `gdk.RGBA` color of `request`
    extern fn webkit_color_chooser_request_set_rgba(p_request: *ColorChooserRequest, p_rgba: *const gdk.RGBA) void;
    pub const setRgba = webkit_color_chooser_request_set_rgba;

    extern fn webkit_color_chooser_request_get_type() usize;
    pub const getGObjectType = webkit_color_chooser_request_get_type;

    extern fn g_object_ref(p_self: *webkit.ColorChooserRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.ColorChooserRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ColorChooserRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents the context menu in a `webkit.WebView`.
///
/// `webkit.ContextMenu` represents a context menu containing
/// `webkit.ContextMenuItem`<!-- -->s in a `webkit.WebView`.
///
/// When a `webkit.WebView` is about to display the context menu, it
/// emits the `webkit.WebView.signals.context`-menu signal, which has the
/// `webkit.ContextMenu` as an argument. You can modify it, adding new
/// submenus that you can create with `webkit.ContextMenu.new`, adding
/// new `webkit.ContextMenuItem`<!-- -->s with
/// `webkit.ContextMenu.prepend`, `webkit.ContextMenu.append` or
/// `webkit.ContextMenu.insert`, maybe after having removed the
/// existing ones with `webkit.ContextMenu.removeAll`.
pub const ContextMenu = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.ContextMenuClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `webkit.ContextMenu` object.
    ///
    /// Creates a new `webkit.ContextMenu` object to be used as a submenu of an existing
    /// `webkit.ContextMenu`. The context menu of a `webkit.WebView` is created by the view
    /// and passed as an argument of `webkit.WebView.signals.context`-menu signal.
    /// To add items to the menu use `webkit.ContextMenu.prepend`,
    /// `webkit.ContextMenu.append` or `webkit.ContextMenu.insert`.
    /// See also `webkit.ContextMenu.newWithItems` to create a `webkit.ContextMenu` with
    /// a list of initial items.
    extern fn webkit_context_menu_new() *webkit.ContextMenu;
    pub const new = webkit_context_menu_new;

    /// Creates a new `webkit.ContextMenu` object with the given items.
    ///
    /// Creates a new `webkit.ContextMenu` object to be used as a submenu of an existing
    /// `webkit.ContextMenu` with the given initial items.
    /// See also `webkit.ContextMenu.new`
    extern fn webkit_context_menu_new_with_items(p_items: *glib.List) *webkit.ContextMenu;
    pub const newWithItems = webkit_context_menu_new_with_items;

    /// Adds `item` at the end of the `menu`.
    extern fn webkit_context_menu_append(p_menu: *ContextMenu, p_item: *webkit.ContextMenuItem) void;
    pub const append = webkit_context_menu_append;

    /// Gets the first item in the `menu`.
    extern fn webkit_context_menu_first(p_menu: *ContextMenu) *webkit.ContextMenuItem;
    pub const first = webkit_context_menu_first;

    /// Gets the `gdk.Event` that triggered the context menu. This function only returns a valid
    /// `gdk.Event` when called for a `webkit.ContextMenu` passed to `webkit.WebView.signals.context`-menu
    /// signal; in all other cases, `NULL` is returned.
    ///
    /// The returned `gdk.Event` is expected to be one of the following types:
    /// <itemizedlist>
    /// <listitem><para>
    /// a `GdkEventButton` of type `GDK_BUTTON_PRESS` when the context menu was triggered with mouse.
    /// </para></listitem>
    /// <listitem><para>
    /// a `GdkEventKey` of type `GDK_KEY_PRESS` if the keyboard was used to show the menu.
    /// </para></listitem>
    /// <listitem><para>
    /// a generic `gdk.Event` of type `GDK_NOTHING` when the `gtk.Widget.signals.popup`-menu signal was used to show the context menu.
    /// </para></listitem>
    /// </itemizedlist>
    extern fn webkit_context_menu_get_event(p_menu: *ContextMenu) *gdk.Event;
    pub const getEvent = webkit_context_menu_get_event;

    /// Gets the item at the given position in the `menu`.
    extern fn webkit_context_menu_get_item_at_position(p_menu: *ContextMenu, p_position: c_uint) *webkit.ContextMenuItem;
    pub const getItemAtPosition = webkit_context_menu_get_item_at_position;

    /// Returns the item list of `menu`.
    extern fn webkit_context_menu_get_items(p_menu: *ContextMenu) *glib.List;
    pub const getItems = webkit_context_menu_get_items;

    /// Gets the length of the `menu`.
    extern fn webkit_context_menu_get_n_items(p_menu: *ContextMenu) c_uint;
    pub const getNItems = webkit_context_menu_get_n_items;

    /// Gets the user data of `menu`.
    ///
    /// This function can be used from the UI Process to get user data previously set
    /// from the Web Process with `webkit.ContextMenu.setUserData`.
    extern fn webkit_context_menu_get_user_data(p_menu: *ContextMenu) *glib.Variant;
    pub const getUserData = webkit_context_menu_get_user_data;

    /// Inserts `item` into the `menu` at the given position.
    ///
    /// If `position` is negative, or is larger than the number of items
    /// in the `webkit.ContextMenu`, the item is added on to the end of
    /// the `menu`. The first position is 0.
    extern fn webkit_context_menu_insert(p_menu: *ContextMenu, p_item: *webkit.ContextMenuItem, p_position: c_int) void;
    pub const insert = webkit_context_menu_insert;

    /// Gets the last item in the `menu`.
    extern fn webkit_context_menu_last(p_menu: *ContextMenu) *webkit.ContextMenuItem;
    pub const last = webkit_context_menu_last;

    /// Moves `item` to the given position in the `menu`.
    ///
    /// If `position` is negative, or is larger than the number of items
    /// in the `webkit.ContextMenu`, the item is added on to the end of
    /// the `menu`.
    /// The first position is 0.
    extern fn webkit_context_menu_move_item(p_menu: *ContextMenu, p_item: *webkit.ContextMenuItem, p_position: c_int) void;
    pub const moveItem = webkit_context_menu_move_item;

    /// Adds `item` at the beginning of the `menu`.
    extern fn webkit_context_menu_prepend(p_menu: *ContextMenu, p_item: *webkit.ContextMenuItem) void;
    pub const prepend = webkit_context_menu_prepend;

    /// Removes `item` from the `menu`.
    ///
    /// See also `webkit.ContextMenu.removeAll` to remove all items.
    extern fn webkit_context_menu_remove(p_menu: *ContextMenu, p_item: *webkit.ContextMenuItem) void;
    pub const remove = webkit_context_menu_remove;

    /// Removes all items of the `menu`.
    extern fn webkit_context_menu_remove_all(p_menu: *ContextMenu) void;
    pub const removeAll = webkit_context_menu_remove_all;

    /// Sets user data to `menu`.
    ///
    /// This function can be used from a Web Process extension to set user data
    /// that can be retrieved from the UI Process using `webkit.ContextMenu.getUserData`.
    /// If the `user_data` `glib.Variant` is floating, it is consumed.
    extern fn webkit_context_menu_set_user_data(p_menu: *ContextMenu, p_user_data: *glib.Variant) void;
    pub const setUserData = webkit_context_menu_set_user_data;

    extern fn webkit_context_menu_get_type() usize;
    pub const getGObjectType = webkit_context_menu_get_type;

    extern fn g_object_ref(p_self: *webkit.ContextMenu) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.ContextMenu) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ContextMenu, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// One item of a `webkit.ContextMenu`.
///
/// The `webkit.ContextMenu` is composed of `webkit.ContextMenuItem`<!--
/// -->s. These items can be created from a `GtkAction`, from a
/// `webkit.ContextMenuAction` or from a `webkit.ContextMenuAction` and a
/// label. These `webkit.ContextMenuAction`<!-- -->s denote stock actions
/// for the items. You can also create separators and submenus.
pub const ContextMenuItem = opaque {
    pub const Parent = gobject.InitiallyUnowned;
    pub const Implements = [_]type{};
    pub const Class = webkit.ContextMenuItemClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `webkit.ContextMenuItem` for the given `action` and `label`.
    ///
    /// On activation
    /// `target` will be passed as parameter to the callback.
    extern fn webkit_context_menu_item_new_from_gaction(p_action: *gio.Action, p_label: [*:0]const u8, p_target: ?*glib.Variant) *webkit.ContextMenuItem;
    pub const newFromGaction = webkit_context_menu_item_new_from_gaction;

    /// Creates a new `webkit.ContextMenuItem` for the given stock action.
    ///
    /// Stock actions are handled automatically by WebKit so that, for example,
    /// when a menu item created with a `WEBKIT_CONTEXT_MENU_ACTION_STOP` is
    /// activated the action associated will be handled by WebKit and the current
    /// load operation will be stopped. You can get the `gio.Action` of a
    /// `webkit.ContextMenuItem` created with a `webkit.ContextMenuAction` with
    /// `webkit.ContextMenuItem.getGaction` and connect to the `gio.SimpleAction.signals.activate` signal
    /// to be notified when the item is activated, but you can't prevent the associated
    /// action from being performed.
    extern fn webkit_context_menu_item_new_from_stock_action(p_action: webkit.ContextMenuAction) *webkit.ContextMenuItem;
    pub const newFromStockAction = webkit_context_menu_item_new_from_stock_action;

    /// Creates a new `webkit.ContextMenuItem` for the given stock action using the given `label`.
    ///
    /// Stock actions have a predefined label, this method can be used to create a
    /// `webkit.ContextMenuItem` for a `webkit.ContextMenuAction` but using a custom label.
    extern fn webkit_context_menu_item_new_from_stock_action_with_label(p_action: webkit.ContextMenuAction, p_label: [*:0]const u8) *webkit.ContextMenuItem;
    pub const newFromStockActionWithLabel = webkit_context_menu_item_new_from_stock_action_with_label;

    /// Creates a new `webkit.ContextMenuItem` representing a separator.
    extern fn webkit_context_menu_item_new_separator() *webkit.ContextMenuItem;
    pub const newSeparator = webkit_context_menu_item_new_separator;

    /// Creates a new `webkit.ContextMenuItem` using the given `label` with a submenu.
    extern fn webkit_context_menu_item_new_with_submenu(p_label: [*:0]const u8, p_submenu: *webkit.ContextMenu) *webkit.ContextMenuItem;
    pub const newWithSubmenu = webkit_context_menu_item_new_with_submenu;

    /// Gets the action associated to `item` as a `gio.Action`.
    extern fn webkit_context_menu_item_get_gaction(p_item: *ContextMenuItem) *gio.Action;
    pub const getGaction = webkit_context_menu_item_get_gaction;

    /// Gets the `webkit.ContextMenuAction` of `item`.
    ///
    /// If the `webkit.ContextMenuItem` was not
    /// created for a stock action `WEBKIT_CONTEXT_MENU_ACTION_CUSTOM` will be
    /// returned. If the `webkit.ContextMenuItem` is a separator `WEBKIT_CONTEXT_MENU_ACTION_NO_ACTION`
    /// will be returned.
    extern fn webkit_context_menu_item_get_stock_action(p_item: *ContextMenuItem) webkit.ContextMenuAction;
    pub const getStockAction = webkit_context_menu_item_get_stock_action;

    /// Gets the submenu of `item`.
    extern fn webkit_context_menu_item_get_submenu(p_item: *ContextMenuItem) *webkit.ContextMenu;
    pub const getSubmenu = webkit_context_menu_item_get_submenu;

    /// Checks whether `item` is a separator.
    extern fn webkit_context_menu_item_is_separator(p_item: *ContextMenuItem) c_int;
    pub const isSeparator = webkit_context_menu_item_is_separator;

    /// Sets or replaces the `item` submenu.
    ///
    /// If `submenu` is `NULL` the current
    /// submenu of `item` is removed.
    extern fn webkit_context_menu_item_set_submenu(p_item: *ContextMenuItem, p_submenu: ?*webkit.ContextMenu) void;
    pub const setSubmenu = webkit_context_menu_item_set_submenu;

    extern fn webkit_context_menu_item_get_type() usize;
    pub const getGObjectType = webkit_context_menu_item_get_type;

    extern fn g_object_ref(p_self: *webkit.ContextMenuItem) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.ContextMenuItem) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ContextMenuItem, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Defines how to handle cookies in a `webkit.WebContext`.
///
/// The WebKitCookieManager defines how to set up and handle cookies.
/// You can get it from a `webkit.WebsiteDataManager` with
/// `webkit_website_data_manager_get_cookie_manager`, and use it to set where to
/// store cookies with `webkit.CookieManager.setPersistentStorage`,
/// or to set the acceptance policy, with `webkit.CookieManager.getAcceptPolicy`.
pub const CookieManager = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.CookieManagerClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// This signal is emitted when cookies are added, removed or modified.
        pub const changed = struct {
            pub const name = "changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(CookieManager, p_instance))),
                    gobject.signalLookup("changed", CookieManager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Asynchronously add a `soup.Cookie` to the underlying storage.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.CookieManager.addCookieFinish` to get the result of the operation.
    extern fn webkit_cookie_manager_add_cookie(p_cookie_manager: *CookieManager, p_cookie: *soup.Cookie, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const addCookie = webkit_cookie_manager_add_cookie;

    /// Finish an asynchronous operation started with `webkit.CookieManager.addCookie`.
    extern fn webkit_cookie_manager_add_cookie_finish(p_cookie_manager: *CookieManager, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const addCookieFinish = webkit_cookie_manager_add_cookie_finish;

    /// Asynchronously delete a `soup.Cookie` from the current session.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.CookieManager.deleteCookieFinish` to get the result of the operation.
    extern fn webkit_cookie_manager_delete_cookie(p_cookie_manager: *CookieManager, p_cookie: *soup.Cookie, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const deleteCookie = webkit_cookie_manager_delete_cookie;

    /// Finish an asynchronous operation started with `webkit.CookieManager.deleteCookie`.
    extern fn webkit_cookie_manager_delete_cookie_finish(p_cookie_manager: *CookieManager, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const deleteCookieFinish = webkit_cookie_manager_delete_cookie_finish;

    /// Asynchronously get the cookie acceptance policy of `cookie_manager`.
    ///
    /// Note that when policy was set to `WEBKIT_COOKIE_POLICY_ACCEPT_NO_THIRD_PARTY` and
    /// ITP is enabled, this will return `WEBKIT_COOKIE_POLICY_ACCEPT_ALWAYS`.
    /// See also `webkit_website_data_manager_set_itp_enabled`.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.CookieManager.getAcceptPolicyFinish` to get the result of the operation.
    extern fn webkit_cookie_manager_get_accept_policy(p_cookie_manager: *CookieManager, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const getAcceptPolicy = webkit_cookie_manager_get_accept_policy;

    /// Finish an asynchronous operation started with `webkit.CookieManager.getAcceptPolicy`.
    extern fn webkit_cookie_manager_get_accept_policy_finish(p_cookie_manager: *CookieManager, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) webkit.CookieAcceptPolicy;
    pub const getAcceptPolicyFinish = webkit_cookie_manager_get_accept_policy_finish;

    /// Asynchronously get a list of `soup.Cookie` from `cookie_manager`.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.CookieManager.getAllCookiesFinish` to get the result of the operation.
    extern fn webkit_cookie_manager_get_all_cookies(p_cookie_manager: *CookieManager, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const getAllCookies = webkit_cookie_manager_get_all_cookies;

    /// Finish an asynchronous operation started with `webkit.CookieManager.getAllCookies`.
    ///
    /// The return value is a `glib.List` of `soup.Cookie` instances which should be released
    /// with `glib.List.freeFull` and `soup.Cookie.free`.
    extern fn webkit_cookie_manager_get_all_cookies_finish(p_cookie_manager: *CookieManager, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*glib.List;
    pub const getAllCookiesFinish = webkit_cookie_manager_get_all_cookies_finish;

    /// Asynchronously get a list of `soup.Cookie` from `cookie_manager`.
    ///
    /// Asynchronously get a list of `soup.Cookie` from `cookie_manager` associated with `uri`, which
    /// must be either an HTTP or an HTTPS URL.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.CookieManager.getCookiesFinish` to get the result of the operation.
    extern fn webkit_cookie_manager_get_cookies(p_cookie_manager: *CookieManager, p_uri: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const getCookies = webkit_cookie_manager_get_cookies;

    /// Finish an asynchronous operation started with `webkit.CookieManager.getCookies`.
    ///
    /// The return value is a `glib.List` of `soup.Cookie` instances which should be released
    /// with `glib.List.freeFull` and `soup.Cookie.free`.
    extern fn webkit_cookie_manager_get_cookies_finish(p_cookie_manager: *CookieManager, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*glib.List;
    pub const getCookiesFinish = webkit_cookie_manager_get_cookies_finish;

    /// Asynchronously replace all cookies in `cookie_manager` with the given list of `cookies`.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.CookieManager.replaceCookiesFinish` to get the result of the operation.
    extern fn webkit_cookie_manager_replace_cookies(p_cookie_manager: *CookieManager, p_cookies: *glib.List, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const replaceCookies = webkit_cookie_manager_replace_cookies;

    /// Finish an asynchronous operation started with `webkit.CookieManager.replaceCookies`.
    extern fn webkit_cookie_manager_replace_cookies_finish(p_cookie_manager: *CookieManager, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const replaceCookiesFinish = webkit_cookie_manager_replace_cookies_finish;

    /// Set the cookie acceptance policy of `cookie_manager` as `policy`.
    ///
    /// Note that ITP has its own way to handle third-party cookies, so when it's enabled,
    /// and `policy` is set to `WEBKIT_COOKIE_POLICY_ACCEPT_NO_THIRD_PARTY`, `WEBKIT_COOKIE_POLICY_ACCEPT_ALWAYS`
    /// will be used instead. Once disabled, the policy will be set back to `WEBKIT_COOKIE_POLICY_ACCEPT_NO_THIRD_PARTY`.
    /// See also `webkit_website_data_manager_set_itp_enabled`.
    extern fn webkit_cookie_manager_set_accept_policy(p_cookie_manager: *CookieManager, p_policy: webkit.CookieAcceptPolicy) void;
    pub const setAcceptPolicy = webkit_cookie_manager_set_accept_policy;

    /// Set non-session cookies.
    ///
    /// Set the `filename` where non-session cookies are stored persistently using
    /// `storage` as the format to read/write the cookies.
    /// Cookies are initially read from `filename` to create an initial set of cookies.
    /// Then, non-session cookies will be written to `filename` when the WebKitCookieManager::changed
    /// signal is emitted.
    /// By default, `cookie_manager` doesn't store the cookies persistently, so you need to call this
    /// method to keep cookies saved across sessions.
    ///
    /// This method should never be called on a `webkit.CookieManager` associated to an ephemeral `webkit.WebsiteDataManager`.
    extern fn webkit_cookie_manager_set_persistent_storage(p_cookie_manager: *CookieManager, p_filename: [*:0]const u8, p_storage: webkit.CookiePersistentStorage) void;
    pub const setPersistentStorage = webkit_cookie_manager_set_persistent_storage;

    extern fn webkit_cookie_manager_get_type() usize;
    pub const getGObjectType = webkit_cookie_manager_get_type;

    extern fn g_object_ref(p_self: *webkit.CookieManager) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.CookieManager) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *CookieManager, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A permission request for accessing user's audio/video devices.
///
/// WebKitUserMediaPermissionRequest represents a request for
/// permission to whether WebKit should be allowed to access the user's
/// devices information when requested through the enumerateDevices API.
///
/// When a WebKitDeviceInfoPermissionRequest is not handled by the user,
/// it is denied by default.
pub const DeviceInfoPermissionRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{webkit.PermissionRequest};
    pub const Class = webkit.DeviceInfoPermissionRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_device_info_permission_request_get_type() usize;
    pub const getGObjectType = webkit_device_info_permission_request_get_type;

    extern fn g_object_ref(p_self: *webkit.DeviceInfoPermissionRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.DeviceInfoPermissionRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DeviceInfoPermissionRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Object used to communicate with the application when downloading.
///
/// `webkit.Download` carries information about a download request and
/// response, including a `webkit.URIRequest` and a `webkit.URIResponse`
/// objects. The application may use this object to control the
/// download process, or to simply figure out what is to be downloaded,
/// and handle the download process itself.
pub const Download = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.DownloadClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether or not the download is allowed to overwrite an existing file on
        /// disk. If this property is `FALSE` and the destination already exists,
        /// the download will fail.
        pub const allow_overwrite = struct {
            pub const name = "allow-overwrite";

            pub const Type = c_int;
        };

        /// The local path to where the download will be saved.
        pub const destination = struct {
            pub const name = "destination";

            pub const Type = ?[*:0]u8;
        };

        /// An estimate of the percent completion for the download operation.
        /// This value will range from 0.0 to 1.0. The value is an estimate
        /// based on the total number of bytes expected to be received for
        /// a download.
        /// If you need a more accurate progress information you can connect to
        /// `webkit.Download.signals.received`-data signal to track the progress.
        pub const estimated_progress = struct {
            pub const name = "estimated-progress";

            pub const Type = f64;
        };

        /// The `webkit.URIResponse` associated with this download.
        pub const response = struct {
            pub const name = "response";

            pub const Type = ?*webkit.URIResponse;
        };
    };

    pub const signals = struct {
        /// This signal is emitted after `webkit.Download.signals.decide`-destination and before
        /// `webkit.Download.signals.received`-data to notify that destination file has been
        /// created successfully at `destination`.
        pub const created_destination = struct {
            pub const name = "created-destination";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_destination: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Download, p_instance))),
                    gobject.signalLookup("created-destination", Download.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted after response is received to
        /// decide a destination for the download using
        /// `webkit.Download.setDestination`. If this signal is not
        /// handled, the file will be downloaded to `G_USER_DIRECTORY_DOWNLOAD`
        /// directory using `suggested_filename`.
        ///
        /// Since 2.40, you may handle this signal asynchronously by
        /// returning `TRUE` without calling `webkit.Download.setDestination`.
        /// This indicates intent to eventually call `webkit.Download.setDestination`.
        /// In this case, the download will not proceed until the destination is set
        /// or cancelled with `webkit.Download.cancel`.
        pub const decide_destination = struct {
            pub const name = "decide-destination";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_suggested_filename: [*:0]u8, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Download, p_instance))),
                    gobject.signalLookup("decide-destination", Download.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when an error occurs during the download
        /// operation. The given `error`, of the domain `WEBKIT_DOWNLOAD_ERROR`,
        /// contains further details of the failure. If the download is cancelled
        /// with `webkit.Download.cancel`, this signal is emitted with error
        /// `WEBKIT_DOWNLOAD_ERROR_CANCELLED_BY_USER`. The download operation finishes
        /// after an error and `webkit.Download.signals.finished` signal is emitted after this one.
        pub const failed = struct {
            pub const name = "failed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_error: *glib.Error, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Download, p_instance))),
                    gobject.signalLookup("failed", Download.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when download finishes successfully or due to an error.
        /// In case of errors `webkit.Download.signals.failed` signal is emitted before this one.
        pub const finished = struct {
            pub const name = "finished";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Download, p_instance))),
                    gobject.signalLookup("finished", Download.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted after response is received,
        /// every time new data has been written to the destination. It's
        /// useful to know the progress of the download operation.
        pub const received_data = struct {
            pub const name = "received-data";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_data_length: u64, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Download, p_instance))),
                    gobject.signalLookup("received-data", Download.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Cancels the download.
    ///
    /// When the ongoing download
    /// operation is effectively cancelled the signal
    /// `webkit.Download.signals.failed` is emitted with
    /// `WEBKIT_DOWNLOAD_ERROR_CANCELLED_BY_USER` error.
    extern fn webkit_download_cancel(p_download: *Download) void;
    pub const cancel = webkit_download_cancel;

    /// Returns the current value of the `webkit.Download.properties.allow`-overwrite property.
    ///
    /// Returns the current value of the `webkit.Download.properties.allow`-overwrite property,
    /// which determines whether the download will overwrite an existing file on
    /// disk, or if it will fail if the destination already exists.
    extern fn webkit_download_get_allow_overwrite(p_download: *Download) c_int;
    pub const getAllowOverwrite = webkit_download_get_allow_overwrite;

    /// Obtains the destination to which the downloaded file will be written.
    ///
    /// You can connect to `webkit.Download.signals.created`-destination to make
    /// sure this method returns a valid destination.
    extern fn webkit_download_get_destination(p_download: *Download) ?[*:0]const u8;
    pub const getDestination = webkit_download_get_destination;

    /// Gets the elapsed time in seconds, including any fractional part.
    ///
    /// If the download finished, had an error or was cancelled this is
    /// the time between its start and the event.
    extern fn webkit_download_get_elapsed_time(p_download: *Download) f64;
    pub const getElapsedTime = webkit_download_get_elapsed_time;

    /// Gets the value of the `webkit.Download.properties.estimated`-progress property.
    /// Gets the value of the `webkit.Download.properties.estimated`-progress property.
    /// You can monitor the estimated progress of the download operation by
    /// connecting to the notify::estimated-progress signal of `download`.
    extern fn webkit_download_get_estimated_progress(p_download: *Download) f64;
    pub const getEstimatedProgress = webkit_download_get_estimated_progress;

    /// Gets the length of the data already downloaded for `download`.
    ///
    /// Gets the length of the data already downloaded for `download`
    /// in bytes.
    extern fn webkit_download_get_received_data_length(p_download: *Download) u64;
    pub const getReceivedDataLength = webkit_download_get_received_data_length;

    /// Retrieves the `webkit.URIRequest` object that backs the download
    /// process.
    extern fn webkit_download_get_request(p_download: *Download) *webkit.URIRequest;
    pub const getRequest = webkit_download_get_request;

    /// Retrieves the `webkit.URIResponse` object that backs the download process.
    ///
    /// Retrieves the `webkit.URIResponse` object that backs the download
    /// process. This method returns `NULL` if called before the response
    /// is received from the server. You can connect to notify::response
    /// signal to be notified when the response is received.
    extern fn webkit_download_get_response(p_download: *Download) *webkit.URIResponse;
    pub const getResponse = webkit_download_get_response;

    /// Get the `webkit.WebView` that initiated the download.
    extern fn webkit_download_get_web_view(p_download: *Download) *webkit.WebView;
    pub const getWebView = webkit_download_get_web_view;

    /// Sets the `webkit.Download.properties.allow`-overwrite property.
    ///
    /// Sets the `webkit.Download.properties.allow`-overwrite property, which determines whether
    /// the download may overwrite an existing file on disk, or if it will fail if
    /// the destination already exists.
    extern fn webkit_download_set_allow_overwrite(p_download: *Download, p_allowed: c_int) void;
    pub const setAllowOverwrite = webkit_download_set_allow_overwrite;

    /// Sets the destination to which the downloaded file will be written.
    ///
    /// This method should be called before the download transfer
    /// starts or it will not have any effect on the ongoing download
    /// operation. To set the destination using the filename suggested
    /// by the server connect to `webkit.Download.signals.decide`-destination
    /// signal and call `webkit.Download.setDestination`. If you want to
    /// set a fixed destination that doesn't depend on the suggested
    /// filename you can connect to notify::response signal and call
    /// `webkit.Download.setDestination`.
    ///
    /// If `webkit.Download.signals.decide`-destination signal is not handled
    /// and destination is not set when the download transfer starts,
    /// the file will be saved with the filename suggested by the server in
    /// `G_USER_DIRECTORY_DOWNLOAD` directory.
    extern fn webkit_download_set_destination(p_download: *Download, p_destination: [*:0]const u8) void;
    pub const setDestination = webkit_download_set_destination;

    extern fn webkit_download_get_type() usize;
    pub const getGObjectType = webkit_download_get_type;

    extern fn g_object_ref(p_self: *webkit.Download) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.Download) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Download, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Web editor state.
///
/// WebKitEditorState represents the state of a `webkit.WebView` editor.
/// Use `webkit.WebView.getEditorState` to get the WebKitEditorState
/// of a `webkit.WebView`.
pub const EditorState = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.EditorStateClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Bitmask of `webkit.EditorTypingAttributes` flags.
        /// See `webkit.EditorState.getTypingAttributes` for more information.
        pub const typing_attributes = struct {
            pub const name = "typing-attributes";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {
        /// Emitted when the `WebKitEdtorState` is changed.
        pub const changed = struct {
            pub const name = "changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(EditorState, p_instance))),
                    gobject.signalLookup("changed", EditorState.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Gets the typing attributes at the current cursor position.
    ///
    /// If there is a selection, this returns the typing attributes
    /// of the selected text. Note that in case of a selection,
    /// typing attributes are considered active only when they are
    /// present throughout the selection.
    extern fn webkit_editor_state_get_typing_attributes(p_editor_state: *EditorState) c_uint;
    pub const getTypingAttributes = webkit_editor_state_get_typing_attributes;

    /// Gets whether a copy command can be issued.
    extern fn webkit_editor_state_is_copy_available(p_editor_state: *EditorState) c_int;
    pub const isCopyAvailable = webkit_editor_state_is_copy_available;

    /// Gets whether a cut command can be issued.
    extern fn webkit_editor_state_is_cut_available(p_editor_state: *EditorState) c_int;
    pub const isCutAvailable = webkit_editor_state_is_cut_available;

    /// Gets whether a paste command can be issued.
    extern fn webkit_editor_state_is_paste_available(p_editor_state: *EditorState) c_int;
    pub const isPasteAvailable = webkit_editor_state_is_paste_available;

    /// Gets whether a redo command can be issued.
    extern fn webkit_editor_state_is_redo_available(p_editor_state: *EditorState) c_int;
    pub const isRedoAvailable = webkit_editor_state_is_redo_available;

    /// Gets whether an undo command can be issued.
    extern fn webkit_editor_state_is_undo_available(p_editor_state: *EditorState) c_int;
    pub const isUndoAvailable = webkit_editor_state_is_undo_available;

    extern fn webkit_editor_state_get_type() usize;
    pub const getGObjectType = webkit_editor_state_get_type;

    extern fn g_object_ref(p_self: *webkit.EditorState) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.EditorState) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EditorState, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Provides access to the icons associated with web sites.
///
/// WebKit will automatically look for available icons in <link>
/// elements on opened pages as well as an existing favicon.ico and
/// load the images found into a memory cache if possible. That cache
/// is frozen to an on-disk database for persistence.
///
/// If `webkit.Settings.properties.enable`-private-browsing is `TRUE`, new icons
/// won't be added to the on-disk database and no existing icons will
/// be deleted from it. Nevertheless, WebKit will still store them in
/// the in-memory cache during the current execution.
pub const FaviconDatabase = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.FaviconDatabaseClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// This signal is emitted when the favicon URI of `page_uri` has
        /// been changed to `favicon_uri` in the database. You can connect
        /// to this signal and call `webkit.FaviconDatabase.getFavicon`
        /// to get the favicon. If you are interested in the favicon of a
        /// `webkit.WebView` it's easier to use the `webkit.WebView.properties.favicon`
        /// property. See `webkit.WebView.getFavicon` for more details.
        pub const favicon_changed = struct {
            pub const name = "favicon-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_page_uri: [*:0]u8, p_favicon_uri: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FaviconDatabase, p_instance))),
                    gobject.signalLookup("favicon-changed", FaviconDatabase.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Clears all icons from the database.
    extern fn webkit_favicon_database_clear(p_database: *FaviconDatabase) void;
    pub const clear = webkit_favicon_database_clear;

    /// Asynchronously obtains a favicon image.
    ///
    /// Asynchronously obtains an image of the favicon for the
    /// given page URI. It returns the cached icon if it's in the database
    /// asynchronously waiting for the icon to be read from the database.
    ///
    /// This is an asynchronous method. When the operation is finished, callback will
    /// be invoked. You can then call `webkit.FaviconDatabase.getFaviconFinish`
    /// to get the result of the operation.
    extern fn webkit_favicon_database_get_favicon(p_database: *FaviconDatabase, p_page_uri: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const getFavicon = webkit_favicon_database_get_favicon;

    /// Finishes an operation started with `webkit.FaviconDatabase.getFavicon`.
    extern fn webkit_favicon_database_get_favicon_finish(p_database: *FaviconDatabase, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*gdk.Texture;
    pub const getFaviconFinish = webkit_favicon_database_get_favicon_finish;

    /// Obtains the URI of the favicon for the given `page_uri`.
    extern fn webkit_favicon_database_get_favicon_uri(p_database: *FaviconDatabase, p_page_uri: [*:0]const u8) [*:0]u8;
    pub const getFaviconUri = webkit_favicon_database_get_favicon_uri;

    extern fn webkit_favicon_database_get_type() usize;
    pub const getGObjectType = webkit_favicon_database_get_type;

    extern fn g_object_ref(p_self: *webkit.FaviconDatabase) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.FaviconDatabase) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FaviconDatabase, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A request to open a file chooser.
///
/// Whenever the user interacts with an HTML input element with
/// file type, WebKit will need to show a dialog to choose one or
/// more files to be uploaded to the server along with the rest of the
/// form data. For that to happen in a general way, instead of just
/// opening a `gtk.FileChooserDialog` (which might be not desirable in
/// some cases, which could prefer to use their own file chooser
/// dialog), WebKit will fire the `webkit.WebView.signals.run`-file-chooser
/// signal with a `webkit.FileChooserRequest` object, which will allow
/// the client application to specify the files to be selected, to
/// inspect the details of the request (e.g. if multiple selection
/// should be allowed) and to cancel the request, in case nothing was
/// selected.
///
/// In case the client application does not wish to handle this signal,
/// WebKit will provide a default handler which will asynchronously run
/// a regular `gtk.FileChooserDialog` for the user to interact with.
pub const FileChooserRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.FileChooserRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The filter currently associated with the request. See
        /// `webkit.FileChooserRequest.getMimeTypesFilter` for more
        /// details.
        pub const filter = struct {
            pub const name = "filter";

            pub const Type = ?*gtk.FileFilter;
        };

        /// A `NULL`-terminated array of strings containing the list of MIME
        /// types the file chooser dialog should handle. See
        /// `webkit.FileChooserRequest.getMimeTypes` for more details.
        pub const mime_types = struct {
            pub const name = "mime-types";

            pub const Type = ?[*][*:0]u8;
        };

        /// Whether the file chooser should allow selecting multiple
        /// files. See
        /// `webkit.FileChooserRequest.getSelectMultiple` for
        /// more details.
        pub const select_multiple = struct {
            pub const name = "select-multiple";

            pub const Type = c_int;
        };

        /// A `NULL`-terminated array of strings containing the list of
        /// selected files associated to the current request. See
        /// `webkit.FileChooserRequest.getSelectedFiles` for more details.
        pub const selected_files = struct {
            pub const name = "selected-files";

            pub const Type = ?[*][*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Ask WebKit to cancel the request.
    ///
    /// It's important to do this in case
    /// no selection has been made in the client, otherwise the request
    /// won't be properly completed and the browser will keep the request
    /// pending forever, which might cause the browser to hang.
    extern fn webkit_file_chooser_request_cancel(p_request: *FileChooserRequest) void;
    pub const cancel = webkit_file_chooser_request_cancel;

    /// Get the list of MIME types the file chooser dialog should handle.
    ///
    /// Get the list of MIME types the file chooser dialog should handle,
    /// in the format specified in RFC 2046 for "media types". Its contents
    /// depend on the value of the 'accept' attribute for HTML input
    /// elements. This function should normally be called before presenting
    /// the file chooser dialog to the user, to decide whether to allow the
    /// user to select multiple files at once or only one.
    extern fn webkit_file_chooser_request_get_mime_types(p_request: *FileChooserRequest) [*]const [*:0]const u8;
    pub const getMimeTypes = webkit_file_chooser_request_get_mime_types;

    /// Get the filter currently associated with the request.
    ///
    /// Get the filter currently associated with the request, ready to be
    /// used by `gtk.FileChooser`. This function should normally be called
    /// before presenting the file chooser dialog to the user, to decide
    /// whether to apply a filter so the user would not be allowed to
    /// select files with other MIME types.
    ///
    /// See `webkit.FileChooserRequest.getMimeTypes` if you are
    /// interested in getting the list of accepted MIME types.
    extern fn webkit_file_chooser_request_get_mime_types_filter(p_request: *FileChooserRequest) *gtk.FileFilter;
    pub const getMimeTypesFilter = webkit_file_chooser_request_get_mime_types_filter;

    /// Whether the file chooser should allow selecting multiple files.
    ///
    /// Determine whether the file chooser associated to this
    /// `webkit.FileChooserRequest` should allow selecting multiple files,
    /// which depends on the HTML input element having a 'multiple'
    /// attribute defined.
    extern fn webkit_file_chooser_request_get_select_multiple(p_request: *FileChooserRequest) c_int;
    pub const getSelectMultiple = webkit_file_chooser_request_get_select_multiple;

    /// Get the list of selected files associated to the request.
    ///
    /// Get the list of selected files currently associated to the
    /// request. Initially, the return value of this method contains any
    /// files selected in previous file chooser requests for this HTML
    /// input element. Once webkit_file_chooser_request_select_files, the
    /// value will reflect whatever files are given.
    ///
    /// This function should normally be called only before presenting the
    /// file chooser dialog to the user, to decide whether to perform some
    /// extra action, like pre-selecting the files from a previous request.
    extern fn webkit_file_chooser_request_get_selected_files(p_request: *FileChooserRequest) [*]const [*:0]const u8;
    pub const getSelectedFiles = webkit_file_chooser_request_get_selected_files;

    /// Ask WebKit to select local files for upload and complete the
    /// request.
    extern fn webkit_file_chooser_request_select_files(p_request: *FileChooserRequest, p_files: [*]const [*:0]const u8) void;
    pub const selectFiles = webkit_file_chooser_request_select_files;

    extern fn webkit_file_chooser_request_get_type() usize;
    pub const getGObjectType = webkit_file_chooser_request_get_type;

    extern fn g_object_ref(p_self: *webkit.FileChooserRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.FileChooserRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FileChooserRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Controls text search in a `webkit.WebView`.
///
/// A `webkit.FindController` is used to search text in a `webkit.WebView`. You
/// can get a `webkit.WebView`<!-- -->'s `webkit.FindController` with
/// `webkit.WebView.getFindController`, and later use it to search
/// for text using `webkit.FindController.search`, or get the
/// number of matches using `webkit.FindController.countMatches`. The
/// operations are asynchronous and trigger signals when ready, such as
/// `webkit.FindController.signals.found`-text,
/// `webkit.FindController.signals.failed`-to-find-text or
/// `webkit.FindController.signals.counted`-matches<!-- -->.
pub const FindController = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.FindControllerClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The maximum number of matches to report for a given search.
        pub const max_match_count = struct {
            pub const name = "max-match-count";

            pub const Type = c_uint;
        };

        /// The options to be used in the search operation.
        pub const options = struct {
            pub const name = "options";

            pub const Type = webkit.FindOptions;
        };

        /// The current search text for this `webkit.FindController`.
        pub const text = struct {
            pub const name = "text";

            pub const Type = ?[*:0]u8;
        };

        /// The `webkit.WebView` this controller is associated to.
        pub const web_view = struct {
            pub const name = "web-view";

            pub const Type = ?*webkit.WebView;
        };
    };

    pub const signals = struct {
        /// This signal is emitted when the `webkit.FindController` has
        /// counted the number of matches for a given text after a call
        /// to `webkit.FindController.countMatches`.
        pub const counted_matches = struct {
            pub const name = "counted-matches";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_match_count: c_uint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FindController, p_instance))),
                    gobject.signalLookup("counted-matches", FindController.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a search operation does not find
        /// any result for the given text. It will be issued if the text
        /// is not found asynchronously after a call to
        /// `webkit.FindController.search`, `webkit.FindController.searchNext`
        /// or `webkit.FindController.searchPrevious`.
        pub const failed_to_find_text = struct {
            pub const name = "failed-to-find-text";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FindController, p_instance))),
                    gobject.signalLookup("failed-to-find-text", FindController.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a given text is found in the web
        /// page text. It will be issued if the text is found
        /// asynchronously after a call to `webkit.FindController.search`,
        /// `webkit.FindController.searchNext` or
        /// `webkit.FindController.searchPrevious`.
        pub const found_text = struct {
            pub const name = "found-text";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_match_count: c_uint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(FindController, p_instance))),
                    gobject.signalLookup("found-text", FindController.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Counts the number of matches for `search_text`.
    ///
    /// Counts the number of matches for `search_text` found in the
    /// `webkit.WebView` with the provided `find_options`. The number of
    /// matches will be provided by the
    /// `webkit.FindController.signals.counted`-matches signal.
    extern fn webkit_find_controller_count_matches(p_find_controller: *FindController, p_search_text: [*:0]const u8, p_find_options: u32, p_max_match_count: c_uint) void;
    pub const countMatches = webkit_find_controller_count_matches;

    /// Gets the maximum number of matches to report.
    ///
    /// Gets the maximum number of matches to report during a text
    /// lookup. This number is passed as the last argument of
    /// `webkit.FindController.search` or
    /// `webkit.FindController.countMatches`.
    extern fn webkit_find_controller_get_max_match_count(p_find_controller: *FindController) c_uint;
    pub const getMaxMatchCount = webkit_find_controller_get_max_match_count;

    /// Gets the `webkit.FindOptions` for the current search.
    ///
    /// Gets a bitmask containing the `webkit.FindOptions` associated with
    /// the current search.
    extern fn webkit_find_controller_get_options(p_find_controller: *FindController) u32;
    pub const getOptions = webkit_find_controller_get_options;

    /// Gets the text that `find_controller` is searching for.
    ///
    /// Gets the text that `find_controller` is currently searching
    /// for. This text is passed to either
    /// `webkit.FindController.search` or
    /// `webkit.FindController.countMatches`.
    extern fn webkit_find_controller_get_search_text(p_find_controller: *FindController) [*:0]const u8;
    pub const getSearchText = webkit_find_controller_get_search_text;

    /// Gets the `webkit.WebView` this find controller is associated to.
    ///
    /// Do
    /// not dereference the returned instance as it belongs to the
    /// `webkit.FindController`.
    extern fn webkit_find_controller_get_web_view(p_find_controller: *FindController) *webkit.WebView;
    pub const getWebView = webkit_find_controller_get_web_view;

    /// Looks for `search_text` associated with `find_controller`.
    ///
    /// Looks for `search_text` in the `webkit.WebView` associated with
    /// `find_controller` since the beginning of the document highlighting
    /// up to `max_match_count` matches. The outcome of the search will be
    /// asynchronously provided by the `webkit.FindController.signals.found`-text
    /// and `webkit.FindController.signals.failed`-to-find-text signals.
    ///
    /// To look for the next or previous occurrences of the same text
    /// with the same find options use `webkit.FindController.searchNext`
    /// and/or `webkit.FindController.searchPrevious`. The
    /// `webkit.FindController` will use the same text and options for the
    /// following searches unless they are modified by another call to this
    /// method.
    ///
    /// Note that if the number of matches is higher than `max_match_count`
    /// then `webkit.FindController.signals.found`-text will report `G_MAXUINT` matches
    /// instead of the actual number.
    ///
    /// Callers should call `webkit.FindController.searchFinish` to
    /// finish the current search operation.
    extern fn webkit_find_controller_search(p_find_controller: *FindController, p_search_text: [*:0]const u8, p_find_options: u32, p_max_match_count: c_uint) void;
    pub const search = webkit_find_controller_search;

    /// Finishes a find operation.
    ///
    /// Finishes a find operation started by
    /// `webkit.FindController.search`. It will basically unhighlight
    /// every text match found.
    ///
    /// This method will be typically called when the search UI is
    /// closed/hidden by the client application.
    extern fn webkit_find_controller_search_finish(p_find_controller: *FindController) void;
    pub const searchFinish = webkit_find_controller_search_finish;

    /// Looks for the next occurrence of the search text.
    ///
    /// Calling this method before `webkit.FindController.search` or
    /// `webkit.FindController.countMatches` is a programming error.
    extern fn webkit_find_controller_search_next(p_find_controller: *FindController) void;
    pub const searchNext = webkit_find_controller_search_next;

    /// Looks for the previous occurrence of the search text.
    ///
    /// Calling this method before `webkit.FindController.search` or
    /// `webkit.FindController.countMatches` is a programming error.
    extern fn webkit_find_controller_search_previous(p_find_controller: *FindController) void;
    pub const searchPrevious = webkit_find_controller_search_previous;

    extern fn webkit_find_controller_get_type() usize;
    pub const getGObjectType = webkit_find_controller_get_type;

    extern fn g_object_ref(p_self: *webkit.FindController) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.FindController) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FindController, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents a form submission request.
///
/// When a form is about to be submitted in a `webkit.WebView`, the
/// `webkit.WebView.signals.submit`-form signal is emitted. Its request argument
/// contains information about the text fields of the form, that are
/// typically used to store login information, returned as lists by
/// `webkit.FormSubmissionRequest.listTextFields`. You can submit the
/// form with `webkit.FormSubmissionRequest.submit`.
pub const FormSubmissionRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.FormSubmissionRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Get lists of the text fields contained in the form associated to `request`.
    ///
    /// Get lists with the names and values of the text fields contained in
    /// the form associated to `request`. Note that names and values may be
    /// `NULL`.
    ///
    /// If this function returns `FALSE`, then both `field_names` and
    /// `field_values` will be empty.
    extern fn webkit_form_submission_request_list_text_fields(p_request: *FormSubmissionRequest, p_field_names: ?**glib.PtrArray, p_field_values: ?**glib.PtrArray) c_int;
    pub const listTextFields = webkit_form_submission_request_list_text_fields;

    /// Continue the form submission.
    extern fn webkit_form_submission_request_submit(p_request: *FormSubmissionRequest) void;
    pub const submit = webkit_form_submission_request_submit;

    extern fn webkit_form_submission_request_get_type() usize;
    pub const getGObjectType = webkit_form_submission_request_get_type;

    extern fn g_object_ref(p_self: *webkit.FormSubmissionRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.FormSubmissionRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *FormSubmissionRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Geolocation manager.
///
/// WebKitGeolocationManager provides API to get the geographical position of the user.
/// Once a `webkit.GeolocationPermissionRequest` is allowed, when WebKit needs to know the
/// user location `webkit.GeolocationManager.signals.start` signal is emitted. If the signal is handled
/// and returns `TRUE`, the application is responsible for providing the position every time it's
/// updated by calling `webkit.GeolocationManager.updatePosition`. The signal `webkit.GeolocationManager.signals.stop`
/// will be emitted when location updates are no longer needed.
pub const GeolocationManager = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.GeolocationManagerClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether high accuracy is enabled. This is a read-only property that will be
        /// set to `TRUE` when a `webkit.GeolocationManager` needs to get accurate position updates.
        /// You can connect to notify::enable-high-accuracy signal to monitor it.
        pub const enable_high_accuracy = struct {
            pub const name = "enable-high-accuracy";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// The signal is emitted to notify that `manager` needs to start receiving
        /// position updates. After this signal is emitted the user should provide
        /// the updates using `webkit.GeolocationManager.updatePosition` every time
        /// the position changes, or use `webkit.GeolocationManager.failed` in case
        /// it isn't possible to determine the current position.
        ///
        /// If the signal is not handled, WebKit will try to determine the position
        /// using GeoClue if available.
        pub const start = struct {
            pub const name = "start";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GeolocationManager, p_instance))),
                    gobject.signalLookup("start", GeolocationManager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// The signal is emitted to notify that `manager` doesn't need to receive
        /// position updates anymore.
        pub const stop = struct {
            pub const name = "stop";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(GeolocationManager, p_instance))),
                    gobject.signalLookup("stop", GeolocationManager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Notify `manager` that determining the position failed.
    extern fn webkit_geolocation_manager_failed(p_manager: *GeolocationManager, p_error_message: [*:0]const u8) void;
    pub const failed = webkit_geolocation_manager_failed;

    /// Get whether high accuracy is enabled.
    extern fn webkit_geolocation_manager_get_enable_high_accuracy(p_manager: *GeolocationManager) c_int;
    pub const getEnableHighAccuracy = webkit_geolocation_manager_get_enable_high_accuracy;

    /// Notify `manager` that position has been updated to `position`.
    extern fn webkit_geolocation_manager_update_position(p_manager: *GeolocationManager, p_position: *webkit.GeolocationPosition) void;
    pub const updatePosition = webkit_geolocation_manager_update_position;

    extern fn webkit_geolocation_manager_get_type() usize;
    pub const getGObjectType = webkit_geolocation_manager_get_type;

    extern fn g_object_ref(p_self: *webkit.GeolocationManager) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.GeolocationManager) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GeolocationManager, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A permission request for sharing the user's location.
///
/// WebKitGeolocationPermissionRequest represents a request for
/// permission to decide whether WebKit should provide the user's
/// location to a website when requested through the Geolocation API.
///
/// When a WebKitGeolocationPermissionRequest is not handled by the user,
/// it is denied by default.
///
/// When embedding web views in your application, you *must* configure an
/// application identifier to allow web content to use geolocation services.
/// The identifier *must* match the name of the `.desktop` file which describes
/// the application, sans the suffix.
///
/// If your application uses `gio.Application` (or any subclass like
/// `gtk.Application`), WebKit will automatically use the identifier returned by
/// `gio.Application.getApplicationId`. This is the recommended approach for
/// enabling geolocation in applications.
///
/// If an identifier cannot be obtained through `gio.Application`, the value
/// returned by `glib.getPrgname` will be used instead as a fallback. For
/// programs which cannot use `gio.Application`, calling `glib.setPrgname` early
/// during initialization is needed when the name of the executable on disk
/// does not match the name of a valid `.desktop` file.
pub const GeolocationPermissionRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{webkit.PermissionRequest};
    pub const Class = webkit.GeolocationPermissionRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_geolocation_permission_request_get_type() usize;
    pub const getGObjectType = webkit_geolocation_permission_request_get_type;

    extern fn g_object_ref(p_self: *webkit.GeolocationPermissionRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.GeolocationPermissionRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *GeolocationPermissionRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Result of a Hit Test.
///
/// A Hit Test is an operation to get context information about a given
/// point in a `webkit.WebView`. `webkit.HitTestResult` represents the
/// result of a Hit Test. It provides context information about what is
/// at the coordinates of the Hit Test, such as if there's a link,
/// an image or a media.
///
/// You can get the context of the HitTestResult with
/// `webkit.HitTestResult.getContext` that returns a bitmask of
/// `webkit.HitTestResultContext` flags. You can also use
/// `webkit.HitTestResult.contextIsLink`, `webkit.HitTestResult.contextIsImage` and
/// `webkit.HitTestResult.contextIsMedia` to determine whether there's
/// a link, image or a media element at the coordinates of the Hit Test.
/// Note that it's possible that several `webkit.HitTestResultContext` flags
/// are active at the same time, for example if there's a link containing an image.
///
/// When the mouse is moved over a `webkit.WebView` a Hit Test is performed
/// for the mouse coordinates and `webkit.WebView.signals.mouse`-target-changed
/// signal is emitted with a `webkit.HitTestResult`.
pub const HitTestResult = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.HitTestResultClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Bitmask of `webkit.HitTestResultContext` flags representing
        /// the context of the `webkit.HitTestResult`.
        pub const context = struct {
            pub const name = "context";

            pub const Type = c_uint;
        };

        /// The URI of the image if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_IMAGE`
        /// is present in `webkit.HitTestResult.properties.context`
        pub const image_uri = struct {
            pub const name = "image-uri";

            pub const Type = ?[*:0]u8;
        };

        /// The label of the link if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK`
        /// is present in `webkit.HitTestResult.properties.context`
        pub const link_label = struct {
            pub const name = "link-label";

            pub const Type = ?[*:0]u8;
        };

        /// The title of the link if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK`
        /// is present in `webkit.HitTestResult.properties.context`
        pub const link_title = struct {
            pub const name = "link-title";

            pub const Type = ?[*:0]u8;
        };

        /// The URI of the link if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK`
        /// is present in `webkit.HitTestResult.properties.context`
        pub const link_uri = struct {
            pub const name = "link-uri";

            pub const Type = ?[*:0]u8;
        };

        /// The URI of the media if flag `WEBKIT_HIT_TEST_RESULT_CONTEXT_MEDIA`
        /// is present in `webkit.HitTestResult.properties.context`
        pub const media_uri = struct {
            pub const name = "media-uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_EDITABLE` flag is present in
    /// `webkit.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_editable(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsEditable = webkit_hit_test_result_context_is_editable;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_IMAGE` flag is present in
    /// `webkit.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_image(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsImage = webkit_hit_test_result_context_is_image;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK` flag is present in
    /// `webkit.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_link(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsLink = webkit_hit_test_result_context_is_link;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_MEDIA` flag is present in
    /// `webkit.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_media(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsMedia = webkit_hit_test_result_context_is_media;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_SCROLLBAR` flag is present in
    /// `webkit.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_scrollbar(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsScrollbar = webkit_hit_test_result_context_is_scrollbar;

    /// Gets whether `WEBKIT_HIT_TEST_RESULT_CONTEXT_SELECTION` flag is present in
    /// `webkit.HitTestResult.properties.context`.
    extern fn webkit_hit_test_result_context_is_selection(p_hit_test_result: *HitTestResult) c_int;
    pub const contextIsSelection = webkit_hit_test_result_context_is_selection;

    /// Gets the value of the `webkit.HitTestResult.properties.context` property.
    extern fn webkit_hit_test_result_get_context(p_hit_test_result: *HitTestResult) c_uint;
    pub const getContext = webkit_hit_test_result_get_context;

    /// Gets the value of the `webkit.HitTestResult.properties.image`-uri property.
    extern fn webkit_hit_test_result_get_image_uri(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getImageUri = webkit_hit_test_result_get_image_uri;

    /// Gets the value of the `webkit.HitTestResult.properties.link`-label property.
    extern fn webkit_hit_test_result_get_link_label(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getLinkLabel = webkit_hit_test_result_get_link_label;

    /// Gets the value of the `webkit.HitTestResult.properties.link`-title property.
    extern fn webkit_hit_test_result_get_link_title(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getLinkTitle = webkit_hit_test_result_get_link_title;

    /// Gets the value of the `webkit.HitTestResult.properties.link`-uri property.
    extern fn webkit_hit_test_result_get_link_uri(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getLinkUri = webkit_hit_test_result_get_link_uri;

    /// Gets the value of the `webkit.HitTestResult.properties.media`-uri property.
    extern fn webkit_hit_test_result_get_media_uri(p_hit_test_result: *HitTestResult) [*:0]const u8;
    pub const getMediaUri = webkit_hit_test_result_get_media_uri;

    extern fn webkit_hit_test_result_get_type() usize;
    pub const getGObjectType = webkit_hit_test_result_get_type;

    extern fn g_object_ref(p_self: *webkit.HitTestResult) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.HitTestResult) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *HitTestResult, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Base class for input method contexts.
///
/// WebKitInputMethodContext defines the interface to implement WebKit input methods.
/// The input methods are used by WebKit, when editable content is focused, to map from
/// key events to Unicode character strings.
///
/// An input method may consume multiple key events in sequence and finally
/// output the composed result. This is called preediting, and an input method
/// may provide feedback about this process by displaying the intermediate
/// composition states as preedit text.
pub const InputMethodContext = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.InputMethodContextClass;
    f_parent_instance: gobject.Object,
    f_priv: ?*webkit.InputMethodContextPrivate,

    pub const virtual_methods = struct {
        pub const committed = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_text: [*:0]const u8) void {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_committed.?(gobject.ext.as(InputMethodContext, p_context), p_text);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_text: [*:0]const u8) callconv(.C) void) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_committed = @ptrCast(p_implementation);
            }
        };

        pub const delete_surrounding = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_offset: c_int, p_n_chars: c_uint) void {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_delete_surrounding.?(gobject.ext.as(InputMethodContext, p_context), p_offset, p_n_chars);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_offset: c_int, p_n_chars: c_uint) callconv(.C) void) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_delete_surrounding = @ptrCast(p_implementation);
            }
        };

        /// Allow `key_event` to be handled by the input method.
        ///
        /// If `TRUE` is returned, then no further processing should be
        /// done for the key event.
        pub const filter_key_event = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_key_event: *gdk.Event) c_int {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_filter_key_event.?(gobject.ext.as(InputMethodContext, p_context), p_key_event);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_key_event: *gdk.Event) callconv(.C) c_int) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_filter_key_event = @ptrCast(p_implementation);
            }
        };

        /// Get the pre-edit string and a list of WebKitInputMethodUnderline.
        ///
        /// Get the current pre-edit string for the `context`, and a list of WebKitInputMethodUnderline to apply to the string.
        /// The string will be displayed inserted at `cursor_offset`.
        pub const get_preedit = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_text: ?*[*:0]u8, p_underlines: ?**glib.List, p_cursor_offset: ?*c_uint) void {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_get_preedit.?(gobject.ext.as(InputMethodContext, p_context), p_text, p_underlines, p_cursor_offset);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_text: ?*[*:0]u8, p_underlines: ?**glib.List, p_cursor_offset: ?*c_uint) callconv(.C) void) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_get_preedit = @ptrCast(p_implementation);
            }
        };

        /// Notify `context` that cursor area changed in input associated.
        pub const notify_cursor_area = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_x: c_int, p_y: c_int, p_width: c_int, p_height: c_int) void {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_notify_cursor_area.?(gobject.ext.as(InputMethodContext, p_context), p_x, p_y, p_width, p_height);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_x: c_int, p_y: c_int, p_width: c_int, p_height: c_int) callconv(.C) void) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_notify_cursor_area = @ptrCast(p_implementation);
            }
        };

        /// Notify `context` that input associated has gained focus.
        pub const notify_focus_in = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_notify_focus_in.?(gobject.ext.as(InputMethodContext, p_context));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_notify_focus_in = @ptrCast(p_implementation);
            }
        };

        /// Notify `context` that input associated has lost focus.
        pub const notify_focus_out = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_notify_focus_out.?(gobject.ext.as(InputMethodContext, p_context));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_notify_focus_out = @ptrCast(p_implementation);
            }
        };

        /// Notify `context` that the context surrounding the cursor has changed.
        ///
        /// If there's no selection `selection_index` is the same as `cursor_index`.
        pub const notify_surrounding = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_text: [*:0]const u8, p_length: c_uint, p_cursor_index: c_uint, p_selection_index: c_uint) void {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_notify_surrounding.?(gobject.ext.as(InputMethodContext, p_context), p_text, p_length, p_cursor_index, p_selection_index);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_text: [*:0]const u8, p_length: c_uint, p_cursor_index: c_uint, p_selection_index: c_uint) callconv(.C) void) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_notify_surrounding = @ptrCast(p_implementation);
            }
        };

        pub const preedit_changed = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_preedit_changed.?(gobject.ext.as(InputMethodContext, p_context));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_preedit_changed = @ptrCast(p_implementation);
            }
        };

        pub const preedit_finished = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_preedit_finished.?(gobject.ext.as(InputMethodContext, p_context));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_preedit_finished = @ptrCast(p_implementation);
            }
        };

        pub const preedit_started = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_preedit_started.?(gobject.ext.as(InputMethodContext, p_context));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_preedit_started = @ptrCast(p_implementation);
            }
        };

        /// Reset the `context`.
        ///
        /// This will typically cause the input to clear the preedit state.
        pub const reset = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_reset.?(gobject.ext.as(InputMethodContext, p_context));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_reset = @ptrCast(p_implementation);
            }
        };

        /// Set whether `context` should enable preedit to display feedback.
        pub const set_enable_preedit = struct {
            pub fn call(p_class: anytype, p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_enabled: c_int) void {
                return gobject.ext.as(InputMethodContext.Class, p_class).f_set_enable_preedit.?(gobject.ext.as(InputMethodContext, p_context), p_enabled);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_context: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_enabled: c_int) callconv(.C) void) void {
                gobject.ext.as(InputMethodContext.Class, p_class).f_set_enable_preedit = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The `webkit.InputHints` of the input associated with this context.
        pub const input_hints = struct {
            pub const name = "input-hints";

            pub const Type = webkit.InputHints;
        };

        /// The `webkit.InputPurpose` of the input associated with this context.
        pub const input_purpose = struct {
            pub const name = "input-purpose";

            pub const Type = webkit.InputPurpose;
        };
    };

    pub const signals = struct {
        /// Emitted when a complete input sequence has been entered by the user.
        /// This can be a single character immediately after a key press or the
        /// final result of preediting.
        pub const committed = struct {
            pub const name = "committed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_text: [*:0]u8, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(InputMethodContext, p_instance))),
                    gobject.signalLookup("committed", InputMethodContext.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the input method wants to delete the context surrounding the cursor.
        /// If `offset` is a negative value, it means a position before the cursor.
        pub const delete_surrounding = struct {
            pub const name = "delete-surrounding";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_offset: c_int, p_n_chars: c_uint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(InputMethodContext, p_instance))),
                    gobject.signalLookup("delete-surrounding", InputMethodContext.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted whenever the preedit sequence currently being entered has changed.
        /// It is also emitted at the end of a preedit sequence, in which case
        /// `webkit.InputMethodContext.getPreedit` returns the empty string.
        pub const preedit_changed = struct {
            pub const name = "preedit-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(InputMethodContext, p_instance))),
                    gobject.signalLookup("preedit-changed", InputMethodContext.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a preediting sequence has been completed or canceled.
        pub const preedit_finished = struct {
            pub const name = "preedit-finished";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(InputMethodContext, p_instance))),
                    gobject.signalLookup("preedit-finished", InputMethodContext.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a new preediting sequence starts.
        pub const preedit_started = struct {
            pub const name = "preedit-started";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(InputMethodContext, p_instance))),
                    gobject.signalLookup("preedit-started", InputMethodContext.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Allow `key_event` to be handled by the input method.
    ///
    /// If `TRUE` is returned, then no further processing should be
    /// done for the key event.
    extern fn webkit_input_method_context_filter_key_event(p_context: *InputMethodContext, p_key_event: *gdk.Event) c_int;
    pub const filterKeyEvent = webkit_input_method_context_filter_key_event;

    /// Get the value of the `webkit.InputMethodContext.properties.input`-hints property.
    extern fn webkit_input_method_context_get_input_hints(p_context: *InputMethodContext) webkit.InputHints;
    pub const getInputHints = webkit_input_method_context_get_input_hints;

    /// Get the value of the `webkit.InputMethodContext.properties.input`-purpose property.
    extern fn webkit_input_method_context_get_input_purpose(p_context: *InputMethodContext) webkit.InputPurpose;
    pub const getInputPurpose = webkit_input_method_context_get_input_purpose;

    /// Get the pre-edit string and a list of WebKitInputMethodUnderline.
    ///
    /// Get the current pre-edit string for the `context`, and a list of WebKitInputMethodUnderline to apply to the string.
    /// The string will be displayed inserted at `cursor_offset`.
    extern fn webkit_input_method_context_get_preedit(p_context: *InputMethodContext, p_text: ?*[*:0]u8, p_underlines: ?**glib.List, p_cursor_offset: ?*c_uint) void;
    pub const getPreedit = webkit_input_method_context_get_preedit;

    /// Notify `context` that cursor area changed in input associated.
    extern fn webkit_input_method_context_notify_cursor_area(p_context: *InputMethodContext, p_x: c_int, p_y: c_int, p_width: c_int, p_height: c_int) void;
    pub const notifyCursorArea = webkit_input_method_context_notify_cursor_area;

    /// Notify `context` that input associated has gained focus.
    extern fn webkit_input_method_context_notify_focus_in(p_context: *InputMethodContext) void;
    pub const notifyFocusIn = webkit_input_method_context_notify_focus_in;

    /// Notify `context` that input associated has lost focus.
    extern fn webkit_input_method_context_notify_focus_out(p_context: *InputMethodContext) void;
    pub const notifyFocusOut = webkit_input_method_context_notify_focus_out;

    /// Notify `context` that the context surrounding the cursor has changed.
    ///
    /// If there's no selection `selection_index` is the same as `cursor_index`.
    extern fn webkit_input_method_context_notify_surrounding(p_context: *InputMethodContext, p_text: [*:0]const u8, p_length: c_int, p_cursor_index: c_uint, p_selection_index: c_uint) void;
    pub const notifySurrounding = webkit_input_method_context_notify_surrounding;

    /// Reset the `context`.
    ///
    /// This will typically cause the input to clear the preedit state.
    extern fn webkit_input_method_context_reset(p_context: *InputMethodContext) void;
    pub const reset = webkit_input_method_context_reset;

    /// Set whether `context` should enable preedit to display feedback.
    extern fn webkit_input_method_context_set_enable_preedit(p_context: *InputMethodContext, p_enabled: c_int) void;
    pub const setEnablePreedit = webkit_input_method_context_set_enable_preedit;

    /// Set the value of the `webkit.InputMethodContext.properties.input`-hints property.
    extern fn webkit_input_method_context_set_input_hints(p_context: *InputMethodContext, p_hints: webkit.InputHints) void;
    pub const setInputHints = webkit_input_method_context_set_input_hints;

    /// Set the value of the `webkit.InputMethodContext.properties.input`-purpose property.
    extern fn webkit_input_method_context_set_input_purpose(p_context: *InputMethodContext, p_purpose: webkit.InputPurpose) void;
    pub const setInputPurpose = webkit_input_method_context_set_input_purpose;

    extern fn webkit_input_method_context_get_type() usize;
    pub const getGObjectType = webkit_input_method_context_get_type;

    extern fn g_object_ref(p_self: *webkit.InputMethodContext) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.InputMethodContext) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *InputMethodContext, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A permission request for using an EME Content Decryption Module.
///
/// WebKitMediaKeySystemPermissionRequest represents a request for permission to decide whether
/// WebKit should use the given CDM to access protected media when requested through the
/// MediaKeySystem API.
///
/// When a WebKitMediaKeySystemPermissionRequest is not handled by the user,
/// it is denied by default.
///
/// When handling this permission request the application may perform additional installation of the
/// requested CDM, unless it is already present on the host system.
pub const MediaKeySystemPermissionRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{webkit.PermissionRequest};
    pub const Class = webkit.MediaKeySystemPermissionRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_media_key_system_permission_request_get_type() usize;
    pub const getGObjectType = webkit_media_key_system_permission_request_get_type;

    extern fn g_object_ref(p_self: *webkit.MediaKeySystemPermissionRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.MediaKeySystemPermissionRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *MediaKeySystemPermissionRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A policy decision for navigation actions.
///
/// WebKitNavigationPolicyDecision represents a policy decision for events associated with
/// navigations. If the value of `webkit.NavigationPolicyDecision.properties.mouse`-button is not 0, then
/// the navigation was triggered by a mouse event.
pub const NavigationPolicyDecision = opaque {
    pub const Parent = webkit.PolicyDecision;
    pub const Implements = [_]type{};
    pub const Class = webkit.NavigationPolicyDecisionClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `webkit.NavigationAction` that triggered this policy decision.
        pub const navigation_action = struct {
            pub const name = "navigation-action";

            pub const Type = ?*webkit.NavigationAction;
        };
    };

    pub const signals = struct {};

    /// Gets the value of the `webkit.NavigationPolicyDecision.properties.navigation`-action property.
    extern fn webkit_navigation_policy_decision_get_navigation_action(p_decision: *NavigationPolicyDecision) *webkit.NavigationAction;
    pub const getNavigationAction = webkit_navigation_policy_decision_get_navigation_action;

    extern fn webkit_navigation_policy_decision_get_type() usize;
    pub const getGObjectType = webkit_navigation_policy_decision_get_type;

    extern fn g_object_ref(p_self: *webkit.NavigationPolicyDecision) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.NavigationPolicyDecision) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *NavigationPolicyDecision, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Manages network configuration.
pub const NetworkSession = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.NetworkSessionClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The base caches directory used to create the `webkit.WebsiteDataManager`. If `NULL`, a default location will be used.
        pub const cache_directory = struct {
            pub const name = "cache-directory";

            pub const Type = ?[*:0]u8;
        };

        /// The base data directory used to create the `webkit.WebsiteDataManager`. If `NULL`, a default location will be used.
        pub const data_directory = struct {
            pub const name = "data-directory";

            pub const Type = ?[*:0]u8;
        };

        /// Whether to create an ephermeral `webkit.WebsiteDataManager` for the session.
        pub const is_ephemeral = struct {
            pub const name = "is-ephemeral";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// This signal is emitted when a new download request is made.
        pub const download_started = struct {
            pub const name = "download-started";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_download: *webkit.Download, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(NetworkSession, p_instance))),
                    gobject.signalLookup("download-started", NetworkSession.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Get the default network session.
    /// The default network session is created using `webkit.NetworkSession.new` and passing
    /// `NULL` as data and cache directories.
    extern fn webkit_network_session_get_default() *webkit.NetworkSession;
    pub const getDefault = webkit_network_session_get_default;

    /// Sets `settings` as the `webkit.MemoryPressureSettings`.
    ///
    /// Sets `settings` as the `webkit.MemoryPressureSettings` to be used by the network
    /// process created by any instance of `webkit.NetworkSession` after this function
    /// is called.
    ///
    /// Be sure to call this function before creating any `webkit.NetworkSession`.
    ///
    /// The periodic check for used memory is disabled by default on network processes. This will
    /// be enabled only if custom settings have been set using this function. After that, in order
    /// to remove the custom settings and disable the periodic check, this function must be called
    /// passing `NULL` as the value of `settings`.
    extern fn webkit_network_session_set_memory_pressure_settings(p_settings: *webkit.MemoryPressureSettings) void;
    pub const setMemoryPressureSettings = webkit_network_session_set_memory_pressure_settings;

    /// Creates a new `webkit.NetworkSession` with a persistent `webkit.WebsiteDataManager`.
    /// The parameters `data_directory` and `cache_directory` will be used as construct
    /// properties of the `webkit.WebsiteDataManager` of the network session. Note that if
    /// `NULL` is passed, the default directory will be passed to `webkit.WebsiteDataManager`
    /// so that `webkit.WebsiteDataManager.getBaseDataDirectory` and
    /// `webkit.WebsiteDataManager.getBaseCacheDirectory` always return a value for
    /// non ephemeral sessions.
    ///
    /// It must be passed as construct parameter of a `webkit.WebView`.
    extern fn webkit_network_session_new(p_data_directory: ?[*:0]const u8, p_cache_directory: ?[*:0]const u8) *webkit.NetworkSession;
    pub const new = webkit_network_session_new;

    /// Creates a new `webkit.NetworkSession` with an ephemeral `webkit.WebsiteDataManager`.
    extern fn webkit_network_session_new_ephemeral() *webkit.NetworkSession;
    pub const newEphemeral = webkit_network_session_new_ephemeral;

    /// Ignore further TLS errors on the `host` for the certificate present in `info`.
    ///
    /// If `host` is an IPv6 address, it should not be surrounded by brackets. This
    /// expectation matches `glib.Uri.getHost`.
    extern fn webkit_network_session_allow_tls_certificate_for_host(p_session: *NetworkSession, p_certificate: *gio.TlsCertificate, p_host: [*:0]const u8) void;
    pub const allowTlsCertificateForHost = webkit_network_session_allow_tls_certificate_for_host;

    /// Requests downloading of the specified URI string.
    ///
    /// The download operation will not be associated to any `webkit.WebView`,
    /// if you are interested in starting a download from a particular `webkit.WebView` use
    /// `webkit.WebView.downloadUri` instead.
    extern fn webkit_network_session_download_uri(p_session: *NetworkSession, p_uri: [*:0]const u8) *webkit.Download;
    pub const downloadUri = webkit_network_session_download_uri;

    /// Get the `webkit.CookieManager` of `session`.
    extern fn webkit_network_session_get_cookie_manager(p_session: *NetworkSession) *webkit.CookieManager;
    pub const getCookieManager = webkit_network_session_get_cookie_manager;

    /// Get whether Intelligent Tracking Prevention (ITP) is enabled or not.
    extern fn webkit_network_session_get_itp_enabled(p_session: *NetworkSession) c_int;
    pub const getItpEnabled = webkit_network_session_get_itp_enabled;

    /// Asynchronously get the list of `webkit.ITPThirdParty` seen for `session`.
    ///
    /// Every `webkit.ITPThirdParty`
    /// contains the list of `webkit.ITPFirstParty` under which it has been seen.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.NetworkSession.getItpSummaryFinish` to get the result of the operation.
    extern fn webkit_network_session_get_itp_summary(p_session: *NetworkSession, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const getItpSummary = webkit_network_session_get_itp_summary;

    /// Finish an asynchronous operation started with `webkit.NetworkSession.getItpSummary`.
    extern fn webkit_network_session_get_itp_summary_finish(p_session: *NetworkSession, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*glib.List;
    pub const getItpSummaryFinish = webkit_network_session_get_itp_summary_finish;

    /// Get whether persistent credential storage is enabled or not.
    ///
    /// See also `webkit.NetworkSession.setPersistentCredentialStorageEnabled`.
    extern fn webkit_network_session_get_persistent_credential_storage_enabled(p_session: *NetworkSession) c_int;
    pub const getPersistentCredentialStorageEnabled = webkit_network_session_get_persistent_credential_storage_enabled;

    /// Get the TLS errors policy of `session`.
    extern fn webkit_network_session_get_tls_errors_policy(p_session: *NetworkSession) webkit.TLSErrorsPolicy;
    pub const getTlsErrorsPolicy = webkit_network_session_get_tls_errors_policy;

    /// Get the `webkit.WebsiteDataManager` of `session`.
    extern fn webkit_network_session_get_website_data_manager(p_session: *NetworkSession) *webkit.WebsiteDataManager;
    pub const getWebsiteDataManager = webkit_network_session_get_website_data_manager;

    /// Get whether `session` is ephemeral.
    /// A `webkit.NetworkSession` is ephemeral when its `webkit.WebsiteDataManager` is ephemeral.
    /// See `webkit.WebsiteDataManager.properties.is`-ephemeral for more details.
    extern fn webkit_network_session_is_ephemeral(p_session: *NetworkSession) c_int;
    pub const isEphemeral = webkit_network_session_is_ephemeral;

    /// Resolve the domain name of the given `hostname` in advance, so that if a URI
    /// of `hostname` is requested the load will be performed more quickly.
    extern fn webkit_network_session_prefetch_dns(p_session: *NetworkSession, p_hostname: [*:0]const u8) void;
    pub const prefetchDns = webkit_network_session_prefetch_dns;

    /// Enable or disable Intelligent Tracking Prevention (ITP).
    ///
    /// When ITP is enabled resource load statistics
    /// are collected and used to decide whether to allow or block third-party cookies and prevent user tracking.
    /// Note that while ITP is enabled the accept policy `WEBKIT_COOKIE_POLICY_ACCEPT_NO_THIRD_PARTY` is ignored and
    /// `WEBKIT_COOKIE_POLICY_ACCEPT_ALWAYS` is used instead. See also `webkit_cookie_session_set_accept_policy`.
    extern fn webkit_network_session_set_itp_enabled(p_session: *NetworkSession, p_enabled: c_int) void;
    pub const setItpEnabled = webkit_network_session_set_itp_enabled;

    /// Enable or disable persistent credential storage.
    ///
    /// When enabled, which is the default for
    /// non-ephemeral sessions, the network process will try to read and write HTTP authentiacation
    /// credentials from persistent storage.
    extern fn webkit_network_session_set_persistent_credential_storage_enabled(p_session: *NetworkSession, p_enabled: c_int) void;
    pub const setPersistentCredentialStorageEnabled = webkit_network_session_set_persistent_credential_storage_enabled;

    /// Set the network proxy settings to be used by connections started in `session` session.
    ///
    /// By default `WEBKIT_NETWORK_PROXY_MODE_DEFAULT` is used, which means that the
    /// system settings will be used (`gio.proxyResolverGetDefault`).
    /// If you want to override the system default settings, you can either use
    /// `WEBKIT_NETWORK_PROXY_MODE_NO_PROXY` to make sure no proxies are used at all,
    /// or `WEBKIT_NETWORK_PROXY_MODE_CUSTOM` to provide your own proxy settings.
    /// When `proxy_mode` is `WEBKIT_NETWORK_PROXY_MODE_CUSTOM` `proxy_settings` must be
    /// a valid `webkit.NetworkProxySettings`; otherwise, `proxy_settings` must be `NULL`.
    extern fn webkit_network_session_set_proxy_settings(p_session: *NetworkSession, p_proxy_mode: webkit.NetworkProxyMode, p_proxy_settings: ?*webkit.NetworkProxySettings) void;
    pub const setProxySettings = webkit_network_session_set_proxy_settings;

    /// Set the TLS errors policy of `session` as `policy`.
    extern fn webkit_network_session_set_tls_errors_policy(p_session: *NetworkSession, p_policy: webkit.TLSErrorsPolicy) void;
    pub const setTlsErrorsPolicy = webkit_network_session_set_tls_errors_policy;

    extern fn webkit_network_session_get_type() usize;
    pub const getGObjectType = webkit_network_session_get_type;

    extern fn g_object_ref(p_self: *webkit.NetworkSession) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.NetworkSession) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *NetworkSession, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Holds information about a notification that should be shown to the user.
pub const Notification = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.NotificationClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The body for the notification.
        pub const body = struct {
            pub const name = "body";

            pub const Type = ?[*:0]u8;
        };

        /// The unique id for the notification.
        pub const id = struct {
            pub const name = "id";

            pub const Type = u64;
        };

        /// The tag identifier for the notification.
        pub const tag = struct {
            pub const name = "tag";

            pub const Type = ?[*:0]u8;
        };

        /// The title for the notification.
        pub const title = struct {
            pub const name = "title";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {
        /// Emitted when a notification has been clicked. See `webkit.Notification.clicked`.
        pub const clicked = struct {
            pub const name = "clicked";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Notification, p_instance))),
                    gobject.signalLookup("clicked", Notification.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a notification has been withdrawn.
        ///
        /// The default handler will close the notification using libnotify, if built with
        /// support for it.
        pub const closed = struct {
            pub const name = "closed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Notification, p_instance))),
                    gobject.signalLookup("closed", Notification.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Tells WebKit the notification has been clicked.
    ///
    /// This will emit the
    /// `webkit.Notification.signals.clicked` signal.
    extern fn webkit_notification_clicked(p_notification: *Notification) void;
    pub const clicked = webkit_notification_clicked;

    /// Closes the notification.
    extern fn webkit_notification_close(p_notification: *Notification) void;
    pub const close = webkit_notification_close;

    /// Obtains the body for the notification.
    extern fn webkit_notification_get_body(p_notification: *Notification) [*:0]const u8;
    pub const getBody = webkit_notification_get_body;

    /// Obtains the unique id for the notification.
    extern fn webkit_notification_get_id(p_notification: *Notification) u64;
    pub const getId = webkit_notification_get_id;

    /// Obtains the tag identifier for the notification.
    extern fn webkit_notification_get_tag(p_notification: *Notification) ?[*:0]const u8;
    pub const getTag = webkit_notification_get_tag;

    /// Obtains the title for the notification.
    extern fn webkit_notification_get_title(p_notification: *Notification) [*:0]const u8;
    pub const getTitle = webkit_notification_get_title;

    extern fn webkit_notification_get_type() usize;
    pub const getGObjectType = webkit_notification_get_type;

    extern fn g_object_ref(p_self: *webkit.Notification) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.Notification) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Notification, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A permission request for displaying web notifications.
///
/// WebKitNotificationPermissionRequest represents a request for
/// permission to decide whether WebKit should provide the user with
/// notifications through the Web Notification API.
///
/// When a WebKitNotificationPermissionRequest is not handled by the user,
/// it is denied by default.
pub const NotificationPermissionRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{webkit.PermissionRequest};
    pub const Class = webkit.NotificationPermissionRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_notification_permission_request_get_type() usize;
    pub const getGObjectType = webkit_notification_permission_request_get_type;

    extern fn g_object_ref(p_self: *webkit.NotificationPermissionRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.NotificationPermissionRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *NotificationPermissionRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents the dropdown menu of a `select` element in a `webkit.WebView`.
///
/// When a select element in a `webkit.WebView` needs to display a dropdown menu, the signal
/// `webkit.WebView.signals.show`-option-menu is emitted, providing a WebKitOptionMenu with the
/// `webkit.OptionMenuItem`<!-- -->s that should be displayed.
pub const OptionMenu = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.OptionMenuClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// Emitted when closing a `webkit.OptionMenu` is requested. This can happen
        /// when the user explicitly calls `webkit.OptionMenu.close` or when the
        /// element is detached from the current page.
        pub const close = struct {
            pub const name = "close";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(OptionMenu, p_instance))),
                    gobject.signalLookup("close", OptionMenu.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Activates the `webkit.OptionMenuItem` at `index` in `menu`.
    ///
    /// Activating an item changes the value
    /// of the element making the item the active one. You are expected to close the menu with
    /// `webkit.OptionMenu.close` after activating an item, calling this function again will have no
    /// effect.
    extern fn webkit_option_menu_activate_item(p_menu: *OptionMenu, p_index: c_uint) void;
    pub const activateItem = webkit_option_menu_activate_item;

    /// Request to close a `webkit.OptionMenu`.
    ///
    /// This emits WebKitOptionMenu::close signal.
    /// This function should always be called to notify WebKit that the associated
    /// menu has been closed. If the menu is closed and neither `webkit.OptionMenu.selectItem`
    /// nor `webkit.OptionMenu.activateItem` have been called, the element value remains
    /// unchanged.
    extern fn webkit_option_menu_close(p_menu: *OptionMenu) void;
    pub const close = webkit_option_menu_close;

    /// Gets the `gdk.Event` that triggered the dropdown menu.
    /// If `menu` was not triggered by a user interaction, like a mouse click,
    /// `NULL` is returned.
    extern fn webkit_option_menu_get_event(p_menu: *OptionMenu) *gdk.Event;
    pub const getEvent = webkit_option_menu_get_event;

    /// Returns the `webkit.OptionMenuItem` at `index` in `menu`.
    extern fn webkit_option_menu_get_item(p_menu: *OptionMenu, p_index: c_uint) *webkit.OptionMenuItem;
    pub const getItem = webkit_option_menu_get_item;

    /// Gets the length of the `menu`.
    extern fn webkit_option_menu_get_n_items(p_menu: *OptionMenu) c_uint;
    pub const getNItems = webkit_option_menu_get_n_items;

    /// Selects the `webkit.OptionMenuItem` at `index` in `menu`.
    ///
    /// Selecting an item changes the
    /// text shown by the combo button, but it doesn't change the value of the element. You need to
    /// explicitly activate the item with `webkit.OptionMenu.selectItem` or close the menu with
    /// `webkit.OptionMenu.close` in which case the currently selected item will be activated.
    extern fn webkit_option_menu_select_item(p_menu: *OptionMenu, p_index: c_uint) void;
    pub const selectItem = webkit_option_menu_select_item;

    extern fn webkit_option_menu_get_type() usize;
    pub const getGObjectType = webkit_option_menu_get_type;

    extern fn g_object_ref(p_self: *webkit.OptionMenu) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.OptionMenu) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *OptionMenu, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A permission request for locking the pointer.
///
/// WebKitPointerLockPermissionRequest represents a request for
/// permission to decide whether WebKit can lock the pointer device when
/// requested by web content.
///
/// When a WebKitPointerLockPermissionRequest is not handled by the user,
/// it is allowed by default.
pub const PointerLockPermissionRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{webkit.PermissionRequest};
    pub const Class = webkit.PointerLockPermissionRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_pointer_lock_permission_request_get_type() usize;
    pub const getGObjectType = webkit_pointer_lock_permission_request_get_type;

    extern fn g_object_ref(p_self: *webkit.PointerLockPermissionRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.PointerLockPermissionRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *PointerLockPermissionRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A pending policy decision.
///
/// Often WebKit allows the client to decide the policy for certain
/// operations. For instance, a client may want to open a link in a new
/// tab, block a navigation entirely, query the user or trigger a download
/// instead of a navigation. In these cases WebKit will fire the
/// `webkit.WebView.signals.decide`-policy signal with a `webkit.PolicyDecision`
/// object. If the signal handler does nothing, WebKit will act as if
/// `webkit.PolicyDecision.use` was called as soon as signal handling
/// completes. To make a policy decision asynchronously, simply increment
/// the reference count of the `webkit.PolicyDecision` object.
pub const PolicyDecision = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.PolicyDecisionClass;
    f_parent_instance: gobject.Object,
    f_priv: ?*webkit.PolicyDecisionPrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Spawn a download from this decision.
    extern fn webkit_policy_decision_download(p_decision: *PolicyDecision) void;
    pub const download = webkit_policy_decision_download;

    /// `webkit.ResponsePolicyDecision`, this would cancel the request.
    ///
    /// Ignore the action which triggered this decision. For instance, for a
    /// `webkit.ResponsePolicyDecision`, this would cancel the request.
    extern fn webkit_policy_decision_ignore(p_decision: *PolicyDecision) void;
    pub const ignore = webkit_policy_decision_ignore;

    /// Accept the action which triggered this decision.
    extern fn webkit_policy_decision_use(p_decision: *PolicyDecision) void;
    pub const use = webkit_policy_decision_use;

    /// Accept the navigation action and continue with provided `policies`.
    ///
    /// Accept the navigation action which triggered this decision, and
    /// continue with `policies` affecting all subsequent loads of resources
    /// in the origin associated with the accepted navigation action.
    ///
    /// For example, a navigation decision to a video sharing website may
    /// be accepted under the priviso no movies are allowed to autoplay. The
    /// autoplay policy in this case would be set in the `policies`.
    extern fn webkit_policy_decision_use_with_policies(p_decision: *PolicyDecision, p_policies: *webkit.WebsitePolicies) void;
    pub const useWithPolicies = webkit_policy_decision_use_with_policies;

    extern fn webkit_policy_decision_get_type() usize;
    pub const getGObjectType = webkit_policy_decision_get_type;

    extern fn g_object_ref(p_self: *webkit.PolicyDecision) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.PolicyDecision) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *PolicyDecision, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Controls a print operation.
///
/// A `webkit.PrintOperation` controls a print operation in WebKit. With
/// a similar API to `gtk.PrintOperation`, it lets you set the print
/// settings with `webkit.PrintOperation.setPrintSettings` or
/// display the print dialog with `webkit.PrintOperation.runDialog`.
pub const PrintOperation = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.PrintOperationClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The initial `gtk.PageSetup` for the print operation.
        pub const page_setup = struct {
            pub const name = "page-setup";

            pub const Type = ?*gtk.PageSetup;
        };

        /// The initial `gtk.PrintSettings` for the print operation.
        pub const print_settings = struct {
            pub const name = "print-settings";

            pub const Type = ?*gtk.PrintSettings;
        };

        /// The `webkit.WebView` that will be printed.
        pub const web_view = struct {
            pub const name = "web-view";

            pub const Type = ?*webkit.WebView;
        };
    };

    pub const signals = struct {
        /// Emitted when an error occurs while printing. The given `error`, of the domain
        /// `WEBKIT_PRINT_ERROR`, contains further details of the failure.
        /// The `webkit.PrintOperation.signals.finished` signal is emitted after this one.
        pub const failed = struct {
            pub const name = "failed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_error: *glib.Error, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(PrintOperation, p_instance))),
                    gobject.signalLookup("failed", PrintOperation.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the print operation has finished doing everything
        /// required for printing.
        pub const finished = struct {
            pub const name = "finished";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(PrintOperation, p_instance))),
                    gobject.signalLookup("finished", PrintOperation.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Create a new `webkit.PrintOperation` to print `web_view` contents.
    extern fn webkit_print_operation_new(p_web_view: *webkit.WebView) *webkit.PrintOperation;
    pub const new = webkit_print_operation_new;

    /// Return the current page setup of `print_operation`.
    ///
    /// It returns `NULL` until
    /// either `webkit.PrintOperation.setPageSetup` or `webkit.PrintOperation.runDialog`
    /// have been called.
    extern fn webkit_print_operation_get_page_setup(p_print_operation: *PrintOperation) *gtk.PageSetup;
    pub const getPageSetup = webkit_print_operation_get_page_setup;

    /// Return the current print settings of `print_operation`.
    ///
    /// It returns `NULL` until
    /// either `webkit.PrintOperation.setPrintSettings` or `webkit.PrintOperation.runDialog`
    /// have been called.
    extern fn webkit_print_operation_get_print_settings(p_print_operation: *PrintOperation) *gtk.PrintSettings;
    pub const getPrintSettings = webkit_print_operation_get_print_settings;

    /// Start a print operation using current print settings and page setup.
    ///
    /// Start a print operation using current print settings and page setup
    /// without showing the print dialog. If either print settings or page setup
    /// are not set with `webkit.PrintOperation.setPrintSettings` and
    /// `webkit.PrintOperation.setPageSetup`, the default options will be used
    /// and the print job will be sent to the default printer.
    /// The `webkit.PrintOperation.signals.finished` signal is emitted when the printing
    /// operation finishes. If an error occurs while printing the signal
    /// `webkit.PrintOperation.signals.failed` is emitted before `webkit.PrintOperation.signals.finished`.
    ///
    /// If the app is running in a sandbox, this function only works if printing to
    /// a file that is in a location accessible to the sandbox, usually acquired
    /// through the File Chooser portal. This function will not work for physical
    /// printers when running in a sandbox.
    extern fn webkit_print_operation_print(p_print_operation: *PrintOperation) void;
    pub const print = webkit_print_operation_print;

    /// Run the print dialog and start printing.
    ///
    /// Run the print dialog and start printing using the options selected by
    /// the user. This method returns when the print dialog is closed.
    /// If the print dialog is cancelled `WEBKIT_PRINT_OPERATION_RESPONSE_CANCEL`
    /// is returned. If the user clicks on the print button, `WEBKIT_PRINT_OPERATION_RESPONSE_PRINT`
    /// is returned and the print operation starts. In this case, the `webkit.PrintOperation.signals.finished`
    /// signal is emitted when the operation finishes. If an error occurs while printing, the signal
    /// `webkit.PrintOperation.signals.failed` is emitted before `webkit.PrintOperation.signals.finished`.
    /// If the print dialog is not cancelled current print settings and page setup of `print_operation`
    /// are updated with options selected by the user when Print button is pressed in print dialog.
    /// You can get the updated print settings and page setup by calling
    /// `webkit.PrintOperation.getPrintSettings` and `webkit.PrintOperation.getPageSetup`
    /// after this method.
    extern fn webkit_print_operation_run_dialog(p_print_operation: *PrintOperation, p_parent: ?*gtk.Window) webkit.PrintOperationResponse;
    pub const runDialog = webkit_print_operation_run_dialog;

    /// Set the current page setup of `print_operation`.
    ///
    /// Current page setup is used for the
    /// initial values of the print dialog when `webkit.PrintOperation.runDialog` is called.
    extern fn webkit_print_operation_set_page_setup(p_print_operation: *PrintOperation, p_page_setup: *gtk.PageSetup) void;
    pub const setPageSetup = webkit_print_operation_set_page_setup;

    /// Set the current print settings of `print_operation`.
    ///
    /// Set the current print settings of `print_operation`. Current print settings are used for
    /// the initial values of the print dialog when `webkit.PrintOperation.runDialog` is called.
    extern fn webkit_print_operation_set_print_settings(p_print_operation: *PrintOperation, p_print_settings: *gtk.PrintSettings) void;
    pub const setPrintSettings = webkit_print_operation_set_print_settings;

    extern fn webkit_print_operation_get_type() usize;
    pub const getGObjectType = webkit_print_operation_get_type;

    extern fn g_object_ref(p_self: *webkit.PrintOperation) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.PrintOperation) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *PrintOperation, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A policy decision for resource responses.
///
/// WebKitResponsePolicyDecision represents a policy decision for a
/// resource response, whether from the network or the local system.
/// A very common use case for these types of decision is deciding
/// whether or not to download a particular resource or to load it
/// normally.
pub const ResponsePolicyDecision = opaque {
    pub const Parent = webkit.PolicyDecision;
    pub const Implements = [_]type{};
    pub const Class = webkit.ResponsePolicyDecisionClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// This property contains the `webkit.URIRequest` associated with this
        /// policy decision.
        pub const request = struct {
            pub const name = "request";

            pub const Type = ?*webkit.URIRequest;
        };

        /// This property contains the `webkit.URIResponse` associated with this
        /// policy decision.
        pub const response = struct {
            pub const name = "response";

            pub const Type = ?*webkit.URIResponse;
        };
    };

    pub const signals = struct {};

    /// Return the `webkit.URIRequest` associated with the response decision.
    ///
    /// Modifications to the returned object are <emphasis>not</emphasis> taken
    /// into account when the request is sent over the network, and is intended
    /// only to aid in evaluating whether a response decision should be taken or
    /// not. To modify requests before they are sent over the network the
    /// `WebKitPage.signals.send`-request signal can be used instead.
    extern fn webkit_response_policy_decision_get_request(p_decision: *ResponsePolicyDecision) *webkit.URIRequest;
    pub const getRequest = webkit_response_policy_decision_get_request;

    /// Gets the value of the `webkit.ResponsePolicyDecision.properties.response` property.
    extern fn webkit_response_policy_decision_get_response(p_decision: *ResponsePolicyDecision) *webkit.URIResponse;
    pub const getResponse = webkit_response_policy_decision_get_response;

    /// Gets whether the request is the main frame main resource
    extern fn webkit_response_policy_decision_is_main_frame_main_resource(p_decision: *ResponsePolicyDecision) c_int;
    pub const isMainFrameMainResource = webkit_response_policy_decision_is_main_frame_main_resource;

    /// Gets whether the MIME type of the response can be displayed in the `webkit.WebView`.
    ///
    /// Gets whether the MIME type of the response can be displayed in the `webkit.WebView`
    /// that triggered this policy decision request. See also `webkit.WebView.canShowMimeType`.
    extern fn webkit_response_policy_decision_is_mime_type_supported(p_decision: *ResponsePolicyDecision) c_int;
    pub const isMimeTypeSupported = webkit_response_policy_decision_is_mime_type_supported;

    extern fn webkit_response_policy_decision_get_type() usize;
    pub const getGObjectType = webkit_response_policy_decision_get_type;

    extern fn g_object_ref(p_self: *webkit.ResponsePolicyDecision) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.ResponsePolicyDecision) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ResponsePolicyDecision, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Controls security settings in a `webkit.WebContext`.
///
/// The `webkit.SecurityManager` defines security settings for URI
/// schemes in a `webkit.WebContext`. Get it from the context with
/// `webkit.WebContext.getSecurityManager`, and use it to register a
/// URI scheme with a certain security level, or to check if it already
/// has it.
pub const SecurityManager = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.SecurityManagerClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Register `scheme` as a CORS (Cross-origin resource sharing) enabled scheme.
    ///
    /// This means that CORS requests are allowed. See W3C CORS specification
    /// http://www.w3.org/TR/cors/.
    extern fn webkit_security_manager_register_uri_scheme_as_cors_enabled(p_security_manager: *SecurityManager, p_scheme: [*:0]const u8) void;
    pub const registerUriSchemeAsCorsEnabled = webkit_security_manager_register_uri_scheme_as_cors_enabled;

    /// Register `scheme` as a display isolated scheme.
    ///
    /// This means that pages cannot
    /// display these URIs unless they are from the same scheme.
    extern fn webkit_security_manager_register_uri_scheme_as_display_isolated(p_security_manager: *SecurityManager, p_scheme: [*:0]const u8) void;
    pub const registerUriSchemeAsDisplayIsolated = webkit_security_manager_register_uri_scheme_as_display_isolated;

    /// Register `scheme` as an empty document scheme.
    ///
    /// This means that
    /// they are allowed to commit synchronously.
    extern fn webkit_security_manager_register_uri_scheme_as_empty_document(p_security_manager: *SecurityManager, p_scheme: [*:0]const u8) void;
    pub const registerUriSchemeAsEmptyDocument = webkit_security_manager_register_uri_scheme_as_empty_document;

    /// Register `scheme` as a local scheme.
    ///
    /// This means that other non-local pages
    /// cannot link to or access URIs of this scheme.
    extern fn webkit_security_manager_register_uri_scheme_as_local(p_security_manager: *SecurityManager, p_scheme: [*:0]const u8) void;
    pub const registerUriSchemeAsLocal = webkit_security_manager_register_uri_scheme_as_local;

    /// Register `scheme` as a no-access scheme.
    ///
    /// This means that pages loaded
    /// with this URI scheme cannot access pages loaded with any other URI scheme.
    extern fn webkit_security_manager_register_uri_scheme_as_no_access(p_security_manager: *SecurityManager, p_scheme: [*:0]const u8) void;
    pub const registerUriSchemeAsNoAccess = webkit_security_manager_register_uri_scheme_as_no_access;

    /// Register `scheme` as a secure scheme.
    ///
    /// This means that mixed
    /// content warnings won't be generated for this scheme when
    /// included by an HTTPS page.
    extern fn webkit_security_manager_register_uri_scheme_as_secure(p_security_manager: *SecurityManager, p_scheme: [*:0]const u8) void;
    pub const registerUriSchemeAsSecure = webkit_security_manager_register_uri_scheme_as_secure;

    /// Whether `scheme` is considered as a CORS enabled scheme.
    ///
    /// See also `webkit.SecurityManager.registerUriSchemeAsCorsEnabled`.
    extern fn webkit_security_manager_uri_scheme_is_cors_enabled(p_security_manager: *SecurityManager, p_scheme: [*:0]const u8) c_int;
    pub const uriSchemeIsCorsEnabled = webkit_security_manager_uri_scheme_is_cors_enabled;

    /// Whether `scheme` is considered as a display isolated scheme.
    ///
    /// See also `webkit.SecurityManager.registerUriSchemeAsDisplayIsolated`.
    extern fn webkit_security_manager_uri_scheme_is_display_isolated(p_security_manager: *SecurityManager, p_scheme: [*:0]const u8) c_int;
    pub const uriSchemeIsDisplayIsolated = webkit_security_manager_uri_scheme_is_display_isolated;

    /// Whether `scheme` is considered as an empty document scheme.
    ///
    /// See also `webkit.SecurityManager.registerUriSchemeAsEmptyDocument`.
    extern fn webkit_security_manager_uri_scheme_is_empty_document(p_security_manager: *SecurityManager, p_scheme: [*:0]const u8) c_int;
    pub const uriSchemeIsEmptyDocument = webkit_security_manager_uri_scheme_is_empty_document;

    /// Whether `scheme` is considered as a local scheme.
    ///
    /// See also `webkit.SecurityManager.registerUriSchemeAsLocal`.
    extern fn webkit_security_manager_uri_scheme_is_local(p_security_manager: *SecurityManager, p_scheme: [*:0]const u8) c_int;
    pub const uriSchemeIsLocal = webkit_security_manager_uri_scheme_is_local;

    /// Whether `scheme` is considered as a no-access scheme.
    ///
    /// See also `webkit.SecurityManager.registerUriSchemeAsNoAccess`.
    extern fn webkit_security_manager_uri_scheme_is_no_access(p_security_manager: *SecurityManager, p_scheme: [*:0]const u8) c_int;
    pub const uriSchemeIsNoAccess = webkit_security_manager_uri_scheme_is_no_access;

    /// Whether `scheme` is considered as a secure scheme.
    ///
    /// See also `webkit.SecurityManager.registerUriSchemeAsSecure`.
    extern fn webkit_security_manager_uri_scheme_is_secure(p_security_manager: *SecurityManager, p_scheme: [*:0]const u8) c_int;
    pub const uriSchemeIsSecure = webkit_security_manager_uri_scheme_is_secure;

    extern fn webkit_security_manager_get_type() usize;
    pub const getGObjectType = webkit_security_manager_get_type;

    extern fn g_object_ref(p_self: *webkit.SecurityManager) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.SecurityManager) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *SecurityManager, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Control the behaviour of a `webkit.WebView`.
///
/// `webkit.Settings` can be applied to a `webkit.WebView` to control text charset,
/// color, font sizes, printing mode, script support, loading of images and various
/// other things on a `webkit.WebView`. After creation, a `webkit.Settings` object
/// contains default settings.
///
/// ```c
/// // Disable JavaScript
/// WebKitSettings *settings = webkit_web_view_group_get_settings (my_view_group);
/// webkit_settings_set_enable_javascript (settings, FALSE);
/// ```
pub const Settings = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.SettingsClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether file access is allowed from file URLs. By default, when
        /// something is loaded in a `webkit.WebView` using a file URI, cross
        /// origin requests to other file resources are not allowed. This
        /// setting allows you to change that behaviour, so that it would be
        /// possible to do a XMLHttpRequest of a local file, for example.
        pub const allow_file_access_from_file_urls = struct {
            pub const name = "allow-file-access-from-file-urls";

            pub const Type = c_int;
        };

        /// Determine whether it's allowed to create and run modal dialogs
        /// from a `webkit.WebView` through JavaScript with
        /// <function>window.showModalDialog</function>. If it's set to
        /// `FALSE`, the associated `webkit.WebView` won't be able to create
        /// new modal dialogs, so not even the `webkit.WebView.signals.create`
        /// signal will be emitted.
        pub const allow_modal_dialogs = struct {
            pub const name = "allow-modal-dialogs";

            pub const Type = c_int;
        };

        /// Whether or not the top frame is allowed to navigate to data URLs. It is disabled by default
        /// due to the risk it poses when loading untrusted URLs, with data URLs being used in scamming
        /// and phishing attacks. In contrast, a scenario where it could be enabled could be an app that
        /// embeds a WebView and you have control of the pages being show instead of a generic browser.
        pub const allow_top_navigation_to_data_urls = struct {
            pub const name = "allow-top-navigation-to-data-urls";

            pub const Type = c_int;
        };

        /// Whether or not JavaScript running in the context of a file scheme URL
        /// should be allowed to access content from any origin.  By default, when
        /// something is loaded in a `webkit.WebView` using a file scheme URL,
        /// access to the local file system and arbitrary local storage is not
        /// allowed. This setting allows you to change that behaviour, so that
        /// it would be possible to use local storage, for example.
        pub const allow_universal_access_from_file_urls = struct {
            pub const name = "allow-universal-access-from-file-urls";

            pub const Type = c_int;
        };

        /// Determines whether images should be automatically loaded or not.
        /// On devices where network bandwidth is of concern, it might be
        /// useful to turn this property off.
        pub const auto_load_images = struct {
            pub const name = "auto-load-images";

            pub const Type = c_int;
        };

        /// The font family used as the default for content using a cursive font.
        pub const cursive_font_family = struct {
            pub const name = "cursive-font-family";

            pub const Type = ?[*:0]u8;
        };

        /// The default text charset used when interpreting content with an unspecified charset.
        pub const default_charset = struct {
            pub const name = "default-charset";

            pub const Type = ?[*:0]u8;
        };

        /// The font family to use as the default for content that does not specify a font.
        pub const default_font_family = struct {
            pub const name = "default-font-family";

            pub const Type = ?[*:0]u8;
        };

        /// The default font size in pixels to use for content displayed if
        /// no font size is specified.
        pub const default_font_size = struct {
            pub const name = "default-font-size";

            pub const Type = c_uint;
        };

        /// The default font size in pixels to use for content displayed in
        /// monospace font if no font size is specified.
        pub const default_monospace_font_size = struct {
            pub const name = "default-monospace-font-size";

            pub const Type = c_uint;
        };

        /// Enable or disable support for Web Security on pages.
        ///
        /// This setting disables the same-origin policy, allowing every website full control over
        /// all other websites. This is for use in special environments where you wish to disable
        /// all security and allow websites to hack each other. It is impossible to use this setting
        /// securely.
        pub const disable_web_security = struct {
            pub const name = "disable-web-security";

            pub const Type = c_int;
        };

        /// Whether to draw compositing borders and repaint counters on layers drawn
        /// with accelerated compositing. This is useful for debugging issues related
        /// to web content that is composited with the GPU.
        pub const draw_compositing_indicators = struct {
            pub const name = "draw-compositing-indicators";

            pub const Type = c_int;
        };

        /// Enable or disable 2D canvas acceleration.
        /// If this setting is enabled, the 2D canvas will be accelerated even if Skia CPU
        /// is used for rendering. However, the canvas can be unaccelerated even when this setting
        /// is enabled, for other reasons like its size or when willReadFrequently property is used.
        pub const enable_2d_canvas_acceleration = struct {
            pub const name = "enable-2d-canvas-acceleration";

            pub const Type = c_int;
        };

        /// Enable or disable horizontal swipe gesture for back-forward navigation.
        pub const enable_back_forward_navigation_gestures = struct {
            pub const name = "enable-back-forward-navigation-gestures";

            pub const Type = c_int;
        };

        /// Whether to enable accessibility enhanced keyboard navigation.
        pub const enable_caret_browsing = struct {
            pub const name = "enable-caret-browsing";

            pub const Type = c_int;
        };

        /// Determines whether or not developer tools, such as the Web Inspector, are enabled.
        pub const enable_developer_extras = struct {
            pub const name = "enable-developer-extras";

            pub const Type = c_int;
        };

        /// Determines whether or not to prefetch domain names. DNS prefetching attempts
        /// to resolve domain names before a user tries to follow a link.
        pub const enable_dns_prefetching = struct {
            pub const name = "enable-dns-prefetching";

            pub const Type = c_int;
        };

        /// Enable or disable support for Encrypted Media API on pages.
        /// EncryptedMedia is an experimental JavaScript API for playing encrypted media in HTML.
        /// This property will only work as intended if the EncryptedMedia feature is enabled at build time
        /// with the ENABLE_ENCRYPTED_MEDIA flag.
        ///
        /// See https://www.w3.org/TR/encrypted-media/
        pub const enable_encrypted_media = struct {
            pub const name = "enable-encrypted-media";

            pub const Type = c_int;
        };

        /// Whether to enable the Javascript Fullscreen API. The API
        /// allows any HTML element to request fullscreen display. See also
        /// the current draft of the spec:
        /// http://www.w3.org/TR/fullscreen/
        pub const enable_fullscreen = struct {
            pub const name = "enable-fullscreen";

            pub const Type = c_int;
        };

        /// Whether to enable HTML5 client-side SQL database support (IndexedDB).
        pub const enable_html5_database = struct {
            pub const name = "enable-html5-database";

            pub const Type = c_int;
        };

        /// Whether to enable HTML5 local storage support. Local storage provides
        /// simple synchronous storage access.
        ///
        /// HTML5 local storage specification is available at
        /// http://dev.w3.org/html5/webstorage/.
        pub const enable_html5_local_storage = struct {
            pub const name = "enable-html5-local-storage";

            pub const Type = c_int;
        };

        /// Determines whether or not hyperlink auditing is enabled.
        ///
        /// The hyperlink auditing specification is available at
        /// http://www.whatwg.org/specs/web-apps/current-work/multipage/links.html`hyperlink`-auditing.
        pub const enable_hyperlink_auditing = struct {
            pub const name = "enable-hyperlink-auditing";

            pub const Type = c_int;
        };

        /// Determines whether or not JavaScript executes within a page.
        pub const enable_javascript = struct {
            pub const name = "enable-javascript";

            pub const Type = c_int;
        };

        /// Determines whether or not JavaScript markup is allowed in document. When this setting is disabled,
        /// all JavaScript-related elements and attributes are removed from the document during parsing. Note that
        /// executing JavaScript is still allowed if `webkit.Settings.properties.enable`-javascript is `TRUE`.
        pub const enable_javascript_markup = struct {
            pub const name = "enable-javascript-markup";

            pub const Type = c_int;
        };

        /// Enable or disable support for media playback on pages. This setting is enabled by
        /// default. Disabling it means `<audio>`, `<track>` and `<video>` elements will have
        /// playback support disabled.
        pub const enable_media = struct {
            pub const name = "enable-media";

            pub const Type = c_int;
        };

        /// Enable or disable support for MediaCapabilities on pages. This
        /// specification intends to provide APIs to allow websites to make an optimal
        /// decision when picking media content for the user. The APIs will expose
        /// information about the decoding and encoding capabilities for a given format
        /// but also output capabilities to find the best match based on the device’s
        /// display.
        ///
        /// See also https://wicg.github.io/media-capabilities/
        pub const enable_media_capabilities = struct {
            pub const name = "enable-media-capabilities";

            pub const Type = c_int;
        };

        /// Enable or disable support for MediaStream on pages. MediaStream
        /// is an experimental proposal for allowing web pages to access
        /// audio and video devices for capture.
        ///
        /// See also http://dev.w3.org/2011/webrtc/editor/getusermedia.html
        pub const enable_media_stream = struct {
            pub const name = "enable-media-stream";

            pub const Type = c_int;
        };

        /// Enable or disable support for MediaSource on pages. MediaSource
        /// extends HTMLMediaElement to allow JavaScript to generate media
        /// streams for playback.
        ///
        /// See also http://www.w3.org/TR/media-source/
        pub const enable_mediasource = struct {
            pub const name = "enable-mediasource";

            pub const Type = c_int;
        };

        /// Enable or disable the Mock Capture Devices. Those are fake
        /// Microphone and Camera devices to be used as MediaStream
        /// sources.
        pub const enable_mock_capture_devices = struct {
            pub const name = "enable-mock-capture-devices";

            pub const Type = c_int;
        };

        /// Unsupported setting. This property does nothing.
        pub const enable_offline_web_application_cache = struct {
            pub const name = "enable-offline-web-application-cache";

            pub const Type = c_int;
        };

        /// Enable or disable the page cache. Disabling the page cache is
        /// generally only useful for special circumstances like low-memory
        /// scenarios or special purpose applications like static HTML
        /// viewers. This setting only controls the Page Cache, this cache
        /// is different than the disk-based or memory-based traditional
        /// resource caches, its point is to make going back and forth
        /// between pages much faster. For details about the different types
        /// of caches and their purposes see:
        /// http://webkit.org/blog/427/webkit-page-cache-i-the-basics/
        pub const enable_page_cache = struct {
            pub const name = "enable-page-cache";

            pub const Type = c_int;
        };

        /// Determines whether or not text areas can be resized.
        pub const enable_resizable_text_areas = struct {
            pub const name = "enable-resizable-text-areas";

            pub const Type = c_int;
        };

        /// Whether to turn on site-specific quirks. Turning this on will
        /// tell WebKit to use some site-specific workarounds for
        /// better web compatibility. For example, older versions of
        /// MediaWiki will incorrectly send to WebKit a CSS file with KHTML
        /// workarounds. By turning on site-specific quirks, WebKit will
        /// special-case this and other cases to make some specific sites work.
        pub const enable_site_specific_quirks = struct {
            pub const name = "enable-site-specific-quirks";

            pub const Type = c_int;
        };

        /// Enable or disable smooth scrolling.
        pub const enable_smooth_scrolling = struct {
            pub const name = "enable-smooth-scrolling";

            pub const Type = c_int;
        };

        /// Whether to enable Spatial Navigation. This feature consists in the ability
        /// to navigate between focusable elements in a Web page, such as hyperlinks
        /// and form controls, by using Left, Right, Up and Down arrow keys.
        /// For example, if an user presses the Right key, heuristics determine whether
        /// there is an element they might be trying to reach towards the right, and if
        /// there are multiple elements, which element they probably wants.
        pub const enable_spatial_navigation = struct {
            pub const name = "enable-spatial-navigation";

            pub const Type = c_int;
        };

        /// Determines whether the tab key cycles through the elements on the page.
        /// When this setting is enabled, users will be able to focus the next element
        /// in the page by pressing the tab key. If the selected element is editable,
        /// then pressing tab key will insert the tab character.
        pub const enable_tabs_to_links = struct {
            pub const name = "enable-tabs-to-links";

            pub const Type = c_int;
        };

        /// Enable or disable support for WebAudio on pages. WebAudio is an
        /// API for processing and synthesizing audio in web applications
        ///
        /// See also https://webaudio.github.io/web-audio-api
        pub const enable_webaudio = struct {
            pub const name = "enable-webaudio";

            pub const Type = c_int;
        };

        /// Enable or disable support for WebGL on pages. WebGL enables web
        /// content to use an API based on OpenGL ES 2.0.
        pub const enable_webgl = struct {
            pub const name = "enable-webgl";

            pub const Type = c_int;
        };

        /// Enable WebRTC support for loaded pages.
        ///
        /// Enabling this setting implies that `Settings.properties.enable_media_stream`
        /// will be enabled as well.
        ///
        /// See also https://www.w3.org/TR/webrtc/
        pub const enable_webrtc = struct {
            pub const name = "enable-webrtc";

            pub const Type = c_int;
        };

        /// Enable or disable writing console messages to stdout. These are messages
        /// sent to the console with console.log and related methods.
        pub const enable_write_console_messages_to_stdout = struct {
            pub const name = "enable-write-console-messages-to-stdout";

            pub const Type = c_int;
        };

        /// The font family used as the default for content using a fantasy font.
        pub const fantasy_font_family = struct {
            pub const name = "fantasy-font-family";

            pub const Type = ?[*:0]u8;
        };

        /// The `webkit.HardwareAccelerationPolicy` to decide how to enable and disable
        /// hardware acceleration. Disabling hardware acceleration might
        /// cause some websites to not render correctly or consume more CPU.
        ///
        /// Note that changing this setting might not be possible if hardware acceleration is not
        /// supported by the hardware or the system. In that case, you can get the value to know the
        /// actual policy being used, but changing the setting will not have any effect.
        pub const hardware_acceleration_policy = struct {
            pub const name = "hardware-acceleration-policy";

            pub const Type = webkit.HardwareAccelerationPolicy;
        };

        /// Whether JavaScript can access the clipboard. The default value is `FALSE`. If
        /// set to `TRUE`, document.`execCommand` allows cut, copy and paste commands.
        pub const javascript_can_access_clipboard = struct {
            pub const name = "javascript-can-access-clipboard";

            pub const Type = c_int;
        };

        /// Whether JavaScript can open popup windows automatically without user
        /// intervention.
        pub const javascript_can_open_windows_automatically = struct {
            pub const name = "javascript-can-open-windows-automatically";

            pub const Type = c_int;
        };

        /// Unsupported setting. This property does nothing.
        pub const load_icons_ignoring_image_load_setting = struct {
            pub const name = "load-icons-ignoring-image-load-setting";

            pub const Type = c_int;
        };

        /// List of media content types requiring hardware support, split by semicolons (:).
        /// For example: 'video/webm; codecs="vp*":video/mp4; codecs="avc*":video/&ast; codecs="av1*"'.
        pub const media_content_types_requiring_hardware_support = struct {
            pub const name = "media-content-types-requiring-hardware-support";

            pub const Type = ?[*:0]u8;
        };

        /// Whether media playback is full-screen only or inline playback is allowed.
        /// This is `TRUE` by default, so media playback can be inline. Setting it to
        /// `FALSE` allows specifying that media playback should be always fullscreen.
        pub const media_playback_allows_inline = struct {
            pub const name = "media-playback-allows-inline";

            pub const Type = c_int;
        };

        /// Whether a user gesture (such as clicking the play button)
        /// would be required to start media playback or load media. This is off
        /// by default, so media playback could start automatically.
        /// Setting it on requires a gesture by the user to start playback, or to
        /// load the media.
        pub const media_playback_requires_user_gesture = struct {
            pub const name = "media-playback-requires-user-gesture";

            pub const Type = c_int;
        };

        /// The minimum font size in pixels used to display text. This setting
        /// controls the absolute smallest size. Values other than 0 can
        /// potentially break page layouts.
        pub const minimum_font_size = struct {
            pub const name = "minimum-font-size";

            pub const Type = c_uint;
        };

        /// The font family used as the default for content using a monospace font.
        pub const monospace_font_family = struct {
            pub const name = "monospace-font-family";

            pub const Type = ?[*:0]u8;
        };

        /// The font family used as the default for content using a pictograph font.
        pub const pictograph_font_family = struct {
            pub const name = "pictograph-font-family";

            pub const Type = ?[*:0]u8;
        };

        /// Whether background images should be drawn during printing.
        pub const print_backgrounds = struct {
            pub const name = "print-backgrounds";

            pub const Type = c_int;
        };

        /// The font family used as the default for content using a sans-serif font.
        pub const sans_serif_font_family = struct {
            pub const name = "sans-serif-font-family";

            pub const Type = ?[*:0]u8;
        };

        /// The font family used as the default for content using a serif font.
        pub const serif_font_family = struct {
            pub const name = "serif-font-family";

            pub const Type = ?[*:0]u8;
        };

        /// The user-agent string used by WebKit. Unusual user-agent strings may cause web
        /// content to render incorrectly or fail to run, as many web pages are written to
        /// parse the user-agent strings of only the most popular browsers. Therefore, it's
        /// typically better to not completely override the standard user-agent, but to use
        /// `webkit.Settings.setUserAgentWithApplicationDetails` instead.
        ///
        /// If this property is set to the empty string or `NULL`, it will revert to the standard
        /// user-agent.
        pub const user_agent = struct {
            pub const name = "user-agent";

            pub const Type = ?[*:0]u8;
        };

        /// Whether `webkit.WebView.properties.zoom`-level affects only the
        /// text of the page or all the contents. Other contents containing text
        /// like form controls will be also affected by zoom factor when
        /// this property is enabled.
        pub const zoom_text_only = struct {
            pub const name = "zoom-text-only";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Convert `points` to the equivalent value in pixels.
    ///
    /// Convert `points` to the equivalent value in pixels, based on the current
    /// screen DPI. Applications can use this function to convert font size values
    /// in points to font size values in pixels when setting the font size properties
    /// of `webkit.Settings`.
    extern fn webkit_settings_font_size_to_pixels(p_points: u32) u32;
    pub const fontSizeToPixels = webkit_settings_font_size_to_pixels;

    /// Convert `pixels` to the equivalent value in points.
    ///
    /// Convert `pixels` to the equivalent value in points, based on the current
    /// screen DPI. Applications can use this function to convert font size values
    /// in pixels to font size values in points when getting the font size properties
    /// of `webkit.Settings`.
    extern fn webkit_settings_font_size_to_points(p_pixels: u32) u32;
    pub const fontSizeToPoints = webkit_settings_font_size_to_points;

    /// Gets the list of all available WebKit features.
    ///
    /// Features can be toggled with `Settings.setFeatureEnabled`,
    /// and their current state determined with
    /// `Settings.getFeatureEnabled`.
    ///
    /// Note that most applications should use
    /// `Settings.getDevelopmentFeatures` and
    /// `Settings.getExperimentalFeatures` instead.
    extern fn webkit_settings_get_all_features() *webkit.FeatureList;
    pub const getAllFeatures = webkit_settings_get_all_features;

    /// Gets the list of available development WebKit features.
    ///
    /// The returned features are a subset of those returned by
    /// `Settings.getAllFeatures`, and includes those which
    /// web and WebKit developers might find useful, but in general should
    /// *not* be exposed to end users; see `FeatureStatus` for
    /// more details.
    extern fn webkit_settings_get_development_features() *webkit.FeatureList;
    pub const getDevelopmentFeatures = webkit_settings_get_development_features;

    /// Gets the list of available experimental WebKit features.
    ///
    /// The returned features are a subset of those returned by
    /// `Settings.getAllFeatures`, and includes those which
    /// certain applications may want to expose to end users; see
    /// `FeatureStatus` for more details.
    extern fn webkit_settings_get_experimental_features() *webkit.FeatureList;
    pub const getExperimentalFeatures = webkit_settings_get_experimental_features;

    /// Creates a new `webkit.Settings` instance with default values.
    ///
    /// It must be manually attached to a `webkit.WebView`.
    /// See also `webkit.Settings.newWithSettings`.
    extern fn webkit_settings_new() *webkit.Settings;
    pub const new = webkit_settings_new;

    /// Creates a new `webkit.Settings` instance with the given settings.
    ///
    /// It must be manually attached to a `webkit.WebView`.
    extern fn webkit_settings_new_with_settings(p_first_setting_name: [*:0]const u8, ...) *webkit.Settings;
    pub const newWithSettings = webkit_settings_new_with_settings;

    /// Reads the contents of the given `group_name` from the given `key_file` and apply the value of
    /// each key/value to the corresponding property on the `settings`.
    ///
    /// Value types have to match with the corresponding setting property type and the group keys have to
    /// match existing setting property names. If those conditions are not met, the function will return
    /// `FALSE`.
    ///
    /// Supported value types are strings (unquoted), booleans (0, 1, true, false) and unsigned integers.
    extern fn webkit_settings_apply_from_key_file(p_settings: *Settings, p_key_file: *glib.KeyFile, p_group_name: [*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const applyFromKeyFile = webkit_settings_apply_from_key_file;

    /// Get the `webkit.Settings.properties.allow`-file-access-from-file-urls property.
    extern fn webkit_settings_get_allow_file_access_from_file_urls(p_settings: *Settings) c_int;
    pub const getAllowFileAccessFromFileUrls = webkit_settings_get_allow_file_access_from_file_urls;

    /// Get the `webkit.Settings.properties.allow`-modal-dialogs property.
    extern fn webkit_settings_get_allow_modal_dialogs(p_settings: *Settings) c_int;
    pub const getAllowModalDialogs = webkit_settings_get_allow_modal_dialogs;

    /// Get the `webkit.Settings.properties.allow`-top-navigation-to-data-urls property.
    extern fn webkit_settings_get_allow_top_navigation_to_data_urls(p_settings: *Settings) c_int;
    pub const getAllowTopNavigationToDataUrls = webkit_settings_get_allow_top_navigation_to_data_urls;

    /// Get the `webkit.Settings.properties.allow`-universal-access-from-file-urls property.
    extern fn webkit_settings_get_allow_universal_access_from_file_urls(p_settings: *Settings) c_int;
    pub const getAllowUniversalAccessFromFileUrls = webkit_settings_get_allow_universal_access_from_file_urls;

    /// Get the `webkit.Settings.properties.auto`-load-images property.
    extern fn webkit_settings_get_auto_load_images(p_settings: *Settings) c_int;
    pub const getAutoLoadImages = webkit_settings_get_auto_load_images;

    /// Gets the `webkit.Settings.properties.cursive`-font-family property.
    extern fn webkit_settings_get_cursive_font_family(p_settings: *Settings) [*:0]const u8;
    pub const getCursiveFontFamily = webkit_settings_get_cursive_font_family;

    /// Gets the `webkit.Settings.properties.default`-charset property.
    extern fn webkit_settings_get_default_charset(p_settings: *Settings) [*:0]const u8;
    pub const getDefaultCharset = webkit_settings_get_default_charset;

    /// Gets the `webkit.Settings.properties.default`-font-family property.
    extern fn webkit_settings_get_default_font_family(p_settings: *Settings) [*:0]const u8;
    pub const getDefaultFontFamily = webkit_settings_get_default_font_family;

    /// Gets the `webkit.Settings.properties.default`-font-size property.
    extern fn webkit_settings_get_default_font_size(p_settings: *Settings) u32;
    pub const getDefaultFontSize = webkit_settings_get_default_font_size;

    /// Gets the `webkit.Settings.properties.default`-monospace-font-size property.
    extern fn webkit_settings_get_default_monospace_font_size(p_settings: *Settings) u32;
    pub const getDefaultMonospaceFontSize = webkit_settings_get_default_monospace_font_size;

    /// Get the `webkit.Settings.properties.disable`-web-security property.
    extern fn webkit_settings_get_disable_web_security(p_settings: *Settings) c_int;
    pub const getDisableWebSecurity = webkit_settings_get_disable_web_security;

    /// Get the `webkit.Settings.properties.draw`-compositing-indicators property.
    extern fn webkit_settings_get_draw_compositing_indicators(p_settings: *Settings) c_int;
    pub const getDrawCompositingIndicators = webkit_settings_get_draw_compositing_indicators;

    /// Get the `webkit.Settings.properties.enable`-2d-canvas-acceleration property.
    extern fn webkit_settings_get_enable_2d_canvas_acceleration(p_settings: *Settings) c_int;
    pub const getEnable2dCanvasAcceleration = webkit_settings_get_enable_2d_canvas_acceleration;

    /// Get the `webkit.Settings.properties.enable`-back-forward-navigation-gestures property.
    extern fn webkit_settings_get_enable_back_forward_navigation_gestures(p_settings: *Settings) c_int;
    pub const getEnableBackForwardNavigationGestures = webkit_settings_get_enable_back_forward_navigation_gestures;

    /// Get the `webkit.Settings.properties.enable`-caret-browsing property.
    extern fn webkit_settings_get_enable_caret_browsing(p_settings: *Settings) c_int;
    pub const getEnableCaretBrowsing = webkit_settings_get_enable_caret_browsing;

    /// Get the `webkit.Settings.properties.enable`-developer-extras property.
    extern fn webkit_settings_get_enable_developer_extras(p_settings: *Settings) c_int;
    pub const getEnableDeveloperExtras = webkit_settings_get_enable_developer_extras;

    /// Get the `webkit.Settings.properties.enable`-dns-prefetching property.
    extern fn webkit_settings_get_enable_dns_prefetching(p_settings: *Settings) c_int;
    pub const getEnableDnsPrefetching = webkit_settings_get_enable_dns_prefetching;

    /// Get the `webkit.Settings.properties.enable`-encrypted-media property.
    extern fn webkit_settings_get_enable_encrypted_media(p_settings: *Settings) c_int;
    pub const getEnableEncryptedMedia = webkit_settings_get_enable_encrypted_media;

    /// Get the `webkit.Settings.properties.enable`-fullscreen property.
    extern fn webkit_settings_get_enable_fullscreen(p_settings: *Settings) c_int;
    pub const getEnableFullscreen = webkit_settings_get_enable_fullscreen;

    /// Get the `webkit.Settings.properties.enable`-html5-database property.
    extern fn webkit_settings_get_enable_html5_database(p_settings: *Settings) c_int;
    pub const getEnableHtml5Database = webkit_settings_get_enable_html5_database;

    /// Get the `webkit.Settings.properties.enable`-html5-local-storage property.
    extern fn webkit_settings_get_enable_html5_local_storage(p_settings: *Settings) c_int;
    pub const getEnableHtml5LocalStorage = webkit_settings_get_enable_html5_local_storage;

    /// Get the `webkit.Settings.properties.enable`-hyperlink-auditing property.
    extern fn webkit_settings_get_enable_hyperlink_auditing(p_settings: *Settings) c_int;
    pub const getEnableHyperlinkAuditing = webkit_settings_get_enable_hyperlink_auditing;

    /// Get the `webkit.Settings.properties.enable`-javascript property.
    extern fn webkit_settings_get_enable_javascript(p_settings: *Settings) c_int;
    pub const getEnableJavascript = webkit_settings_get_enable_javascript;

    /// Get the `webkit.Settings.properties.enable`-javascript-markup property.
    extern fn webkit_settings_get_enable_javascript_markup(p_settings: *Settings) c_int;
    pub const getEnableJavascriptMarkup = webkit_settings_get_enable_javascript_markup;

    /// Get the `webkit.Settings.properties.enable`-media property.
    extern fn webkit_settings_get_enable_media(p_settings: *Settings) c_int;
    pub const getEnableMedia = webkit_settings_get_enable_media;

    /// Get the `webkit.Settings.properties.enable`-media-capabilities property.
    extern fn webkit_settings_get_enable_media_capabilities(p_settings: *Settings) c_int;
    pub const getEnableMediaCapabilities = webkit_settings_get_enable_media_capabilities;

    /// Get the `webkit.Settings.properties.enable`-media-stream property.
    extern fn webkit_settings_get_enable_media_stream(p_settings: *Settings) c_int;
    pub const getEnableMediaStream = webkit_settings_get_enable_media_stream;

    /// Get the `webkit.Settings.properties.enable`-mediasource property.
    extern fn webkit_settings_get_enable_mediasource(p_settings: *Settings) c_int;
    pub const getEnableMediasource = webkit_settings_get_enable_mediasource;

    /// Get the `webkit.Settings.properties.enable`-mock-capture-devices property.
    extern fn webkit_settings_get_enable_mock_capture_devices(p_settings: *Settings) c_int;
    pub const getEnableMockCaptureDevices = webkit_settings_get_enable_mock_capture_devices;

    /// Get the `webkit.Settings.properties.enable`-offline-web-application-cache property.
    extern fn webkit_settings_get_enable_offline_web_application_cache(p_settings: *Settings) c_int;
    pub const getEnableOfflineWebApplicationCache = webkit_settings_get_enable_offline_web_application_cache;

    /// Get the `webkit.Settings.properties.enable`-page-cache property.
    extern fn webkit_settings_get_enable_page_cache(p_settings: *Settings) c_int;
    pub const getEnablePageCache = webkit_settings_get_enable_page_cache;

    /// Get the `webkit.Settings.properties.enable`-resizable-text-areas property.
    extern fn webkit_settings_get_enable_resizable_text_areas(p_settings: *Settings) c_int;
    pub const getEnableResizableTextAreas = webkit_settings_get_enable_resizable_text_areas;

    /// Get the `webkit.Settings.properties.enable`-site-specific-quirks property.
    extern fn webkit_settings_get_enable_site_specific_quirks(p_settings: *Settings) c_int;
    pub const getEnableSiteSpecificQuirks = webkit_settings_get_enable_site_specific_quirks;

    /// Get the `webkit.Settings.properties.enable`-smooth-scrolling property.
    extern fn webkit_settings_get_enable_smooth_scrolling(p_settings: *Settings) c_int;
    pub const getEnableSmoothScrolling = webkit_settings_get_enable_smooth_scrolling;

    /// Get the `webkit.Settings.properties.enable`-spatial-navigation property.
    extern fn webkit_settings_get_enable_spatial_navigation(p_settings: *Settings) c_int;
    pub const getEnableSpatialNavigation = webkit_settings_get_enable_spatial_navigation;

    /// Get the `webkit.Settings.properties.enable`-tabs-to-links property.
    extern fn webkit_settings_get_enable_tabs_to_links(p_settings: *Settings) c_int;
    pub const getEnableTabsToLinks = webkit_settings_get_enable_tabs_to_links;

    /// Get the `webkit.Settings.properties.enable`-webaudio property.
    extern fn webkit_settings_get_enable_webaudio(p_settings: *Settings) c_int;
    pub const getEnableWebaudio = webkit_settings_get_enable_webaudio;

    /// Get the `webkit.Settings.properties.enable`-webgl property.
    extern fn webkit_settings_get_enable_webgl(p_settings: *Settings) c_int;
    pub const getEnableWebgl = webkit_settings_get_enable_webgl;

    /// Get the `Settings.properties.enable_webrtc` property.
    extern fn webkit_settings_get_enable_webrtc(p_settings: *Settings) c_int;
    pub const getEnableWebrtc = webkit_settings_get_enable_webrtc;

    /// Get the `webkit.Settings.properties.enable`-write-console-messages-to-stdout property.
    extern fn webkit_settings_get_enable_write_console_messages_to_stdout(p_settings: *Settings) c_int;
    pub const getEnableWriteConsoleMessagesToStdout = webkit_settings_get_enable_write_console_messages_to_stdout;

    /// Gets the `webkit.Settings.properties.fantasy`-font-family property.
    extern fn webkit_settings_get_fantasy_font_family(p_settings: *Settings) [*:0]const u8;
    pub const getFantasyFontFamily = webkit_settings_get_fantasy_font_family;

    /// Gets whether a feature is enabled.
    extern fn webkit_settings_get_feature_enabled(p_settings: *Settings, p_feature: *webkit.Feature) c_int;
    pub const getFeatureEnabled = webkit_settings_get_feature_enabled;

    /// Get the `webkit.Settings.properties.hardware`-acceleration-policy property.
    extern fn webkit_settings_get_hardware_acceleration_policy(p_settings: *Settings) webkit.HardwareAccelerationPolicy;
    pub const getHardwareAccelerationPolicy = webkit_settings_get_hardware_acceleration_policy;

    /// Get the `webkit.Settings.properties.javascript`-can-access-clipboard property.
    extern fn webkit_settings_get_javascript_can_access_clipboard(p_settings: *Settings) c_int;
    pub const getJavascriptCanAccessClipboard = webkit_settings_get_javascript_can_access_clipboard;

    /// Get the `webkit.Settings.properties.javascript`-can-open-windows-automatically property.
    extern fn webkit_settings_get_javascript_can_open_windows_automatically(p_settings: *Settings) c_int;
    pub const getJavascriptCanOpenWindowsAutomatically = webkit_settings_get_javascript_can_open_windows_automatically;

    /// Setting no longer supported. This function returns `FALSE`.
    extern fn webkit_settings_get_load_icons_ignoring_image_load_setting(p_settings: *Settings) c_int;
    pub const getLoadIconsIgnoringImageLoadSetting = webkit_settings_get_load_icons_ignoring_image_load_setting;

    /// Gets the `webkit.Settings.properties.media`-content-types-requiring-hardware-support property.
    extern fn webkit_settings_get_media_content_types_requiring_hardware_support(p_settings: *Settings) [*:0]const u8;
    pub const getMediaContentTypesRequiringHardwareSupport = webkit_settings_get_media_content_types_requiring_hardware_support;

    /// Get the `webkit.Settings.properties.media`-playback-allows-inline property.
    extern fn webkit_settings_get_media_playback_allows_inline(p_settings: *Settings) c_int;
    pub const getMediaPlaybackAllowsInline = webkit_settings_get_media_playback_allows_inline;

    /// Get the `webkit.Settings.properties.media`-playback-requires-user-gesture property.
    extern fn webkit_settings_get_media_playback_requires_user_gesture(p_settings: *Settings) c_int;
    pub const getMediaPlaybackRequiresUserGesture = webkit_settings_get_media_playback_requires_user_gesture;

    /// Gets the `webkit.Settings.properties.minimum`-font-size property.
    extern fn webkit_settings_get_minimum_font_size(p_settings: *Settings) u32;
    pub const getMinimumFontSize = webkit_settings_get_minimum_font_size;

    /// Gets the `webkit.Settings.properties.monospace`-font-family property.
    extern fn webkit_settings_get_monospace_font_family(p_settings: *Settings) [*:0]const u8;
    pub const getMonospaceFontFamily = webkit_settings_get_monospace_font_family;

    /// Gets the `webkit.Settings.properties.pictograph`-font-family property.
    extern fn webkit_settings_get_pictograph_font_family(p_settings: *Settings) [*:0]const u8;
    pub const getPictographFontFamily = webkit_settings_get_pictograph_font_family;

    /// Get the `webkit.Settings.properties.print`-backgrounds property.
    extern fn webkit_settings_get_print_backgrounds(p_settings: *Settings) c_int;
    pub const getPrintBackgrounds = webkit_settings_get_print_backgrounds;

    /// Gets the `webkit.Settings.properties.sans`-serif-font-family property.
    extern fn webkit_settings_get_sans_serif_font_family(p_settings: *Settings) [*:0]const u8;
    pub const getSansSerifFontFamily = webkit_settings_get_sans_serif_font_family;

    /// Gets the `webkit.Settings.properties.serif`-font-family property.
    extern fn webkit_settings_get_serif_font_family(p_settings: *Settings) [*:0]const u8;
    pub const getSerifFontFamily = webkit_settings_get_serif_font_family;

    /// Get the `webkit.Settings.properties.user`-agent property.
    extern fn webkit_settings_get_user_agent(p_settings: *Settings) [*:0]const u8;
    pub const getUserAgent = webkit_settings_get_user_agent;

    /// Get the `webkit.Settings.properties.zoom`-text-only property.
    extern fn webkit_settings_get_zoom_text_only(p_settings: *Settings) c_int;
    pub const getZoomTextOnly = webkit_settings_get_zoom_text_only;

    /// Set the `webkit.Settings.properties.allow`-file-access-from-file-urls property.
    extern fn webkit_settings_set_allow_file_access_from_file_urls(p_settings: *Settings, p_allowed: c_int) void;
    pub const setAllowFileAccessFromFileUrls = webkit_settings_set_allow_file_access_from_file_urls;

    /// Set the `webkit.Settings.properties.allow`-modal-dialogs property.
    extern fn webkit_settings_set_allow_modal_dialogs(p_settings: *Settings, p_allowed: c_int) void;
    pub const setAllowModalDialogs = webkit_settings_set_allow_modal_dialogs;

    /// Set the `webkit.Settings.properties.allow`-top-navigation-to-data-urls property.
    extern fn webkit_settings_set_allow_top_navigation_to_data_urls(p_settings: *Settings, p_allowed: c_int) void;
    pub const setAllowTopNavigationToDataUrls = webkit_settings_set_allow_top_navigation_to_data_urls;

    /// Set the `webkit.Settings.properties.allow`-universal-access-from-file-urls property.
    extern fn webkit_settings_set_allow_universal_access_from_file_urls(p_settings: *Settings, p_allowed: c_int) void;
    pub const setAllowUniversalAccessFromFileUrls = webkit_settings_set_allow_universal_access_from_file_urls;

    /// Set the `webkit.Settings.properties.auto`-load-images property.
    extern fn webkit_settings_set_auto_load_images(p_settings: *Settings, p_enabled: c_int) void;
    pub const setAutoLoadImages = webkit_settings_set_auto_load_images;

    /// Set the `webkit.Settings.properties.cursive`-font-family property.
    extern fn webkit_settings_set_cursive_font_family(p_settings: *Settings, p_cursive_font_family: [*:0]const u8) void;
    pub const setCursiveFontFamily = webkit_settings_set_cursive_font_family;

    /// Set the `webkit.Settings.properties.default`-charset property.
    extern fn webkit_settings_set_default_charset(p_settings: *Settings, p_default_charset: [*:0]const u8) void;
    pub const setDefaultCharset = webkit_settings_set_default_charset;

    /// Set the `webkit.Settings.properties.default`-font-family property.
    extern fn webkit_settings_set_default_font_family(p_settings: *Settings, p_default_font_family: [*:0]const u8) void;
    pub const setDefaultFontFamily = webkit_settings_set_default_font_family;

    /// Set the `webkit.Settings.properties.default`-font-size property.
    extern fn webkit_settings_set_default_font_size(p_settings: *Settings, p_font_size: u32) void;
    pub const setDefaultFontSize = webkit_settings_set_default_font_size;

    /// Set the `webkit.Settings.properties.default`-monospace-font-size property.
    extern fn webkit_settings_set_default_monospace_font_size(p_settings: *Settings, p_font_size: u32) void;
    pub const setDefaultMonospaceFontSize = webkit_settings_set_default_monospace_font_size;

    /// Set the `webkit.Settings.properties.disable`-web-security property.
    extern fn webkit_settings_set_disable_web_security(p_settings: *Settings, p_disabled: c_int) void;
    pub const setDisableWebSecurity = webkit_settings_set_disable_web_security;

    /// Set the `webkit.Settings.properties.draw`-compositing-indicators property.
    extern fn webkit_settings_set_draw_compositing_indicators(p_settings: *Settings, p_enabled: c_int) void;
    pub const setDrawCompositingIndicators = webkit_settings_set_draw_compositing_indicators;

    /// Set the `webkit.Settings.properties.enable`-2d-canvas-acceleration property.
    extern fn webkit_settings_set_enable_2d_canvas_acceleration(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnable2dCanvasAcceleration = webkit_settings_set_enable_2d_canvas_acceleration;

    /// Set the `webkit.Settings.properties.enable`-back-forward-navigation-gestures property.
    extern fn webkit_settings_set_enable_back_forward_navigation_gestures(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableBackForwardNavigationGestures = webkit_settings_set_enable_back_forward_navigation_gestures;

    /// Set the `webkit.Settings.properties.enable`-caret-browsing property.
    extern fn webkit_settings_set_enable_caret_browsing(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableCaretBrowsing = webkit_settings_set_enable_caret_browsing;

    /// Set the `webkit.Settings.properties.enable`-developer-extras property.
    extern fn webkit_settings_set_enable_developer_extras(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableDeveloperExtras = webkit_settings_set_enable_developer_extras;

    /// Set the `webkit.Settings.properties.enable`-dns-prefetching property.
    extern fn webkit_settings_set_enable_dns_prefetching(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableDnsPrefetching = webkit_settings_set_enable_dns_prefetching;

    /// Set the `webkit.Settings.properties.enable`-encrypted-media property.
    extern fn webkit_settings_set_enable_encrypted_media(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableEncryptedMedia = webkit_settings_set_enable_encrypted_media;

    /// Set the `webkit.Settings.properties.enable`-fullscreen property.
    extern fn webkit_settings_set_enable_fullscreen(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableFullscreen = webkit_settings_set_enable_fullscreen;

    /// Set the `webkit.Settings.properties.enable`-html5-database property.
    extern fn webkit_settings_set_enable_html5_database(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableHtml5Database = webkit_settings_set_enable_html5_database;

    /// Set the `webkit.Settings.properties.enable`-html5-local-storage property.
    extern fn webkit_settings_set_enable_html5_local_storage(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableHtml5LocalStorage = webkit_settings_set_enable_html5_local_storage;

    /// Set the `webkit.Settings.properties.enable`-hyperlink-auditing property.
    extern fn webkit_settings_set_enable_hyperlink_auditing(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableHyperlinkAuditing = webkit_settings_set_enable_hyperlink_auditing;

    /// Set the `webkit.Settings.properties.enable`-javascript property.
    extern fn webkit_settings_set_enable_javascript(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableJavascript = webkit_settings_set_enable_javascript;

    /// Set the `webkit.Settings.properties.enable`-javascript-markup property.
    extern fn webkit_settings_set_enable_javascript_markup(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableJavascriptMarkup = webkit_settings_set_enable_javascript_markup;

    /// Set the `webkit.Settings.properties.enable`-media property.
    extern fn webkit_settings_set_enable_media(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableMedia = webkit_settings_set_enable_media;

    /// Set the `webkit.Settings.properties.enable`-media-capabilities property.
    extern fn webkit_settings_set_enable_media_capabilities(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableMediaCapabilities = webkit_settings_set_enable_media_capabilities;

    /// Set the `webkit.Settings.properties.enable`-media-stream property.
    extern fn webkit_settings_set_enable_media_stream(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableMediaStream = webkit_settings_set_enable_media_stream;

    /// Set the `webkit.Settings.properties.enable`-mediasource property.
    extern fn webkit_settings_set_enable_mediasource(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableMediasource = webkit_settings_set_enable_mediasource;

    /// Set the `webkit.Settings.properties.enable`-mock-capture-devices property.
    extern fn webkit_settings_set_enable_mock_capture_devices(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableMockCaptureDevices = webkit_settings_set_enable_mock_capture_devices;

    /// Setting no longer supported. This function does nothing.
    extern fn webkit_settings_set_enable_offline_web_application_cache(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableOfflineWebApplicationCache = webkit_settings_set_enable_offline_web_application_cache;

    /// Set the `webkit.Settings.properties.enable`-page-cache property.
    extern fn webkit_settings_set_enable_page_cache(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnablePageCache = webkit_settings_set_enable_page_cache;

    /// Set the `webkit.Settings.properties.enable`-resizable-text-areas property.
    extern fn webkit_settings_set_enable_resizable_text_areas(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableResizableTextAreas = webkit_settings_set_enable_resizable_text_areas;

    /// Set the `webkit.Settings.properties.enable`-site-specific-quirks property.
    extern fn webkit_settings_set_enable_site_specific_quirks(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableSiteSpecificQuirks = webkit_settings_set_enable_site_specific_quirks;

    /// Set the `webkit.Settings.properties.enable`-smooth-scrolling property.
    extern fn webkit_settings_set_enable_smooth_scrolling(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableSmoothScrolling = webkit_settings_set_enable_smooth_scrolling;

    /// Set the `webkit.Settings.properties.enable`-spatial-navigation property.
    extern fn webkit_settings_set_enable_spatial_navigation(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableSpatialNavigation = webkit_settings_set_enable_spatial_navigation;

    /// Set the `webkit.Settings.properties.enable`-tabs-to-links property.
    extern fn webkit_settings_set_enable_tabs_to_links(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableTabsToLinks = webkit_settings_set_enable_tabs_to_links;

    /// Set the `webkit.Settings.properties.enable`-webaudio property.
    extern fn webkit_settings_set_enable_webaudio(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableWebaudio = webkit_settings_set_enable_webaudio;

    /// Set the `webkit.Settings.properties.enable`-webgl property.
    extern fn webkit_settings_set_enable_webgl(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableWebgl = webkit_settings_set_enable_webgl;

    /// Set the `Settings.properties.enable_webrtc` property.
    ///
    /// Setting this property to `TRUE` implies the media-stream web-setting will also be enabled.
    extern fn webkit_settings_set_enable_webrtc(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableWebrtc = webkit_settings_set_enable_webrtc;

    /// Set the `webkit.Settings.properties.enable`-write-console-messages-to-stdout property.
    extern fn webkit_settings_set_enable_write_console_messages_to_stdout(p_settings: *Settings, p_enabled: c_int) void;
    pub const setEnableWriteConsoleMessagesToStdout = webkit_settings_set_enable_write_console_messages_to_stdout;

    /// Set the `webkit.Settings.properties.fantasy`-font-family property.
    extern fn webkit_settings_set_fantasy_font_family(p_settings: *Settings, p_fantasy_font_family: [*:0]const u8) void;
    pub const setFantasyFontFamily = webkit_settings_set_fantasy_font_family;

    /// Enables or disables a feature.
    ///
    /// The current status of the feature can be determined with
    /// `webkit.Settings.getFeatureEnabled`. To reset a feature to its
    /// initial status, pass the value returned by
    /// `webkit.Feature.getDefaultValue` as the `enabled` parameter.
    extern fn webkit_settings_set_feature_enabled(p_settings: *Settings, p_feature: *webkit.Feature, p_enabled: c_int) void;
    pub const setFeatureEnabled = webkit_settings_set_feature_enabled;

    /// Set the `webkit.Settings.properties.hardware`-acceleration-policy property.
    extern fn webkit_settings_set_hardware_acceleration_policy(p_settings: *Settings, p_policy: webkit.HardwareAccelerationPolicy) void;
    pub const setHardwareAccelerationPolicy = webkit_settings_set_hardware_acceleration_policy;

    /// Set the `webkit.Settings.properties.javascript`-can-access-clipboard property.
    extern fn webkit_settings_set_javascript_can_access_clipboard(p_settings: *Settings, p_enabled: c_int) void;
    pub const setJavascriptCanAccessClipboard = webkit_settings_set_javascript_can_access_clipboard;

    /// Set the `webkit.Settings.properties.javascript`-can-open-windows-automatically property.
    extern fn webkit_settings_set_javascript_can_open_windows_automatically(p_settings: *Settings, p_enabled: c_int) void;
    pub const setJavascriptCanOpenWindowsAutomatically = webkit_settings_set_javascript_can_open_windows_automatically;

    /// Setting no longer supported. This function does nothing.
    extern fn webkit_settings_set_load_icons_ignoring_image_load_setting(p_settings: *Settings, p_enabled: c_int) void;
    pub const setLoadIconsIgnoringImageLoadSetting = webkit_settings_set_load_icons_ignoring_image_load_setting;

    /// Set the `webkit.Settings.properties.media`-content-types-requiring-hardware-support property.
    extern fn webkit_settings_set_media_content_types_requiring_hardware_support(p_settings: *Settings, p_content_types: ?[*:0]const u8) void;
    pub const setMediaContentTypesRequiringHardwareSupport = webkit_settings_set_media_content_types_requiring_hardware_support;

    /// Set the `webkit.Settings.properties.media`-playback-allows-inline property.
    extern fn webkit_settings_set_media_playback_allows_inline(p_settings: *Settings, p_enabled: c_int) void;
    pub const setMediaPlaybackAllowsInline = webkit_settings_set_media_playback_allows_inline;

    /// Set the `webkit.Settings.properties.media`-playback-requires-user-gesture property.
    extern fn webkit_settings_set_media_playback_requires_user_gesture(p_settings: *Settings, p_enabled: c_int) void;
    pub const setMediaPlaybackRequiresUserGesture = webkit_settings_set_media_playback_requires_user_gesture;

    /// Set the `webkit.Settings.properties.minimum`-font-size property.
    extern fn webkit_settings_set_minimum_font_size(p_settings: *Settings, p_font_size: u32) void;
    pub const setMinimumFontSize = webkit_settings_set_minimum_font_size;

    /// Set the `webkit.Settings.properties.monospace`-font-family property.
    extern fn webkit_settings_set_monospace_font_family(p_settings: *Settings, p_monospace_font_family: [*:0]const u8) void;
    pub const setMonospaceFontFamily = webkit_settings_set_monospace_font_family;

    /// Set the `webkit.Settings.properties.pictograph`-font-family property.
    extern fn webkit_settings_set_pictograph_font_family(p_settings: *Settings, p_pictograph_font_family: [*:0]const u8) void;
    pub const setPictographFontFamily = webkit_settings_set_pictograph_font_family;

    /// Set the `webkit.Settings.properties.print`-backgrounds property.
    extern fn webkit_settings_set_print_backgrounds(p_settings: *Settings, p_print_backgrounds: c_int) void;
    pub const setPrintBackgrounds = webkit_settings_set_print_backgrounds;

    /// Set the `webkit.Settings.properties.sans`-serif-font-family property.
    extern fn webkit_settings_set_sans_serif_font_family(p_settings: *Settings, p_sans_serif_font_family: [*:0]const u8) void;
    pub const setSansSerifFontFamily = webkit_settings_set_sans_serif_font_family;

    /// Set the `webkit.Settings.properties.serif`-font-family property.
    extern fn webkit_settings_set_serif_font_family(p_settings: *Settings, p_serif_font_family: [*:0]const u8) void;
    pub const setSerifFontFamily = webkit_settings_set_serif_font_family;

    /// Set the `webkit.Settings.properties.user`-agent property.
    extern fn webkit_settings_set_user_agent(p_settings: *Settings, p_user_agent: ?[*:0]const u8) void;
    pub const setUserAgent = webkit_settings_set_user_agent;

    /// Set the `webkit.Settings.properties.user`-agent property by appending the application details.
    ///
    /// Set the `webkit.Settings.properties.user`-agent property by appending the application details to the default user
    /// agent. If no application name or version is given, the default user agent used will be used. If only
    /// the version is given, the default engine version is used with the given application name.
    extern fn webkit_settings_set_user_agent_with_application_details(p_settings: *Settings, p_application_name: ?[*:0]const u8, p_application_version: ?[*:0]const u8) void;
    pub const setUserAgentWithApplicationDetails = webkit_settings_set_user_agent_with_application_details;

    /// Set the `webkit.Settings.properties.zoom`-text-only property.
    extern fn webkit_settings_set_zoom_text_only(p_settings: *Settings, p_zoom_text_only: c_int) void;
    pub const setZoomTextOnly = webkit_settings_set_zoom_text_only;

    extern fn webkit_settings_get_type() usize;
    pub const getGObjectType = webkit_settings_get_type;

    extern fn g_object_ref(p_self: *webkit.Settings) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.Settings) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Settings, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents a URI request.
///
/// A `webkit.URIRequest` can be created with a URI using the
/// `webkit.URIRequest.new` method, and you can get the URI of an
/// existing request with the `webkit.URIRequest.getUri` one.
pub const URIRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.URIRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The URI to which the request will be made.
        pub const uri = struct {
            pub const name = "uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Creates a new `webkit.URIRequest` for the given URI.
    extern fn webkit_uri_request_new(p_uri: [*:0]const u8) *webkit.URIRequest;
    pub const new = webkit_uri_request_new;

    /// Get the HTTP headers of a `webkit.URIRequest` as a `soup.MessageHeaders`.
    extern fn webkit_uri_request_get_http_headers(p_request: *URIRequest) *soup.MessageHeaders;
    pub const getHttpHeaders = webkit_uri_request_get_http_headers;

    /// Get the HTTP method of the `webkit.URIRequest`.
    extern fn webkit_uri_request_get_http_method(p_request: *URIRequest) [*:0]const u8;
    pub const getHttpMethod = webkit_uri_request_get_http_method;

    /// Obtains the request URI.
    extern fn webkit_uri_request_get_uri(p_request: *URIRequest) [*:0]const u8;
    pub const getUri = webkit_uri_request_get_uri;

    /// Set the URI of `request`
    extern fn webkit_uri_request_set_uri(p_request: *URIRequest, p_uri: [*:0]const u8) void;
    pub const setUri = webkit_uri_request_set_uri;

    extern fn webkit_uri_request_get_type() usize;
    pub const getGObjectType = webkit_uri_request_get_type;

    extern fn g_object_ref(p_self: *webkit.URIRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.URIRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *URIRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents an URI response.
///
/// A `webkit.URIResponse` contains information such as the URI, the
/// status code, the content length, the mime type, the HTTP status or
/// the suggested filename.
pub const URIResponse = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.URIResponseClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The expected content length of the response.
        pub const content_length = struct {
            pub const name = "content-length";

            pub const Type = u64;
        };

        /// The HTTP headers of the response, or `NULL` if the response is not an HTTP response.
        pub const http_headers = struct {
            pub const name = "http-headers";

            pub const Type = ?*soup.MessageHeaders;
        };

        /// The MIME type of the response.
        pub const mime_type = struct {
            pub const name = "mime-type";

            pub const Type = ?[*:0]u8;
        };

        /// The status code of the response as returned by the server.
        pub const status_code = struct {
            pub const name = "status-code";

            pub const Type = c_uint;
        };

        /// The suggested filename for the URI response.
        pub const suggested_filename = struct {
            pub const name = "suggested-filename";

            pub const Type = ?[*:0]u8;
        };

        /// The URI for which the response was made.
        pub const uri = struct {
            pub const name = "uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Get the expected content length of the `webkit.URIResponse`.
    ///
    /// It can be 0 if the server provided an incorrect or missing Content-Length.
    extern fn webkit_uri_response_get_content_length(p_response: *URIResponse) u64;
    pub const getContentLength = webkit_uri_response_get_content_length;

    /// Get the HTTP headers of a `webkit.URIResponse` as a `soup.MessageHeaders`.
    extern fn webkit_uri_response_get_http_headers(p_response: *URIResponse) *soup.MessageHeaders;
    pub const getHttpHeaders = webkit_uri_response_get_http_headers;

    /// Gets the MIME type of the response.
    extern fn webkit_uri_response_get_mime_type(p_response: *URIResponse) [*:0]const u8;
    pub const getMimeType = webkit_uri_response_get_mime_type;

    /// Get the status code of the `webkit.URIResponse`.
    ///
    /// Get the status code of the `webkit.URIResponse` as returned by
    /// the server. It will normally be a `SoupKnownStatusCode`, for
    /// example `SOUP_STATUS_OK`, though the server can respond with any
    /// unsigned integer.
    extern fn webkit_uri_response_get_status_code(p_response: *URIResponse) c_uint;
    pub const getStatusCode = webkit_uri_response_get_status_code;

    /// Get the suggested filename for `response`.
    ///
    /// Get the suggested filename for `response`, as specified by
    /// the 'Content-Disposition' HTTP header, or `NULL` if it's not
    /// present.
    extern fn webkit_uri_response_get_suggested_filename(p_response: *URIResponse) [*:0]const u8;
    pub const getSuggestedFilename = webkit_uri_response_get_suggested_filename;

    /// Gets the URI which resulted in the response.
    extern fn webkit_uri_response_get_uri(p_response: *URIResponse) [*:0]const u8;
    pub const getUri = webkit_uri_response_get_uri;

    extern fn webkit_uri_response_get_type() usize;
    pub const getGObjectType = webkit_uri_response_get_type;

    extern fn g_object_ref(p_self: *webkit.URIResponse) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.URIResponse) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *URIResponse, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents a URI scheme request.
///
/// If you register a particular URI scheme in a `webkit.WebContext`,
/// using `webkit.WebContext.registerUriScheme`, you have to provide
/// a `webkit.URISchemeRequestCallback`. After that, when a URI request
/// is made with that particular scheme, your callback will be
/// called. There you will be able to access properties such as the
/// scheme, the URI and path, and the `webkit.WebView` that initiated the
/// request, and also finish the request with
/// `webkit.URISchemeRequest.finish`.
pub const URISchemeRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.URISchemeRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Finish a `webkit.URISchemeRequest` by setting the contents of the request and its mime type.
    extern fn webkit_uri_scheme_request_finish(p_request: *URISchemeRequest, p_stream: *gio.InputStream, p_stream_length: i64, p_content_type: ?[*:0]const u8) void;
    pub const finish = webkit_uri_scheme_request_finish;

    /// Finish a `webkit.URISchemeRequest` with a `glib.Error`.
    extern fn webkit_uri_scheme_request_finish_error(p_request: *URISchemeRequest, p_error: *glib.Error) void;
    pub const finishError = webkit_uri_scheme_request_finish_error;

    /// Finish a `webkit.URISchemeRequest` by returning a `webkit.URISchemeResponse`
    extern fn webkit_uri_scheme_request_finish_with_response(p_request: *URISchemeRequest, p_response: *webkit.URISchemeResponse) void;
    pub const finishWithResponse = webkit_uri_scheme_request_finish_with_response;

    /// Get the request body.
    extern fn webkit_uri_scheme_request_get_http_body(p_request: *URISchemeRequest) *gio.InputStream;
    pub const getHttpBody = webkit_uri_scheme_request_get_http_body;

    /// Get the `soup.MessageHeaders` of the request.
    extern fn webkit_uri_scheme_request_get_http_headers(p_request: *URISchemeRequest) *soup.MessageHeaders;
    pub const getHttpHeaders = webkit_uri_scheme_request_get_http_headers;

    /// Get the HTTP method of the `request`.
    extern fn webkit_uri_scheme_request_get_http_method(p_request: *URISchemeRequest) [*:0]const u8;
    pub const getHttpMethod = webkit_uri_scheme_request_get_http_method;

    /// Get the URI path of `request`.
    extern fn webkit_uri_scheme_request_get_path(p_request: *URISchemeRequest) [*:0]const u8;
    pub const getPath = webkit_uri_scheme_request_get_path;

    /// Get the URI scheme of `request`.
    extern fn webkit_uri_scheme_request_get_scheme(p_request: *URISchemeRequest) [*:0]const u8;
    pub const getScheme = webkit_uri_scheme_request_get_scheme;

    /// Get the URI of `request`.
    extern fn webkit_uri_scheme_request_get_uri(p_request: *URISchemeRequest) [*:0]const u8;
    pub const getUri = webkit_uri_scheme_request_get_uri;

    /// Get the `webkit.WebView` that initiated the request.
    extern fn webkit_uri_scheme_request_get_web_view(p_request: *URISchemeRequest) *webkit.WebView;
    pub const getWebView = webkit_uri_scheme_request_get_web_view;

    extern fn webkit_uri_scheme_request_get_type() usize;
    pub const getGObjectType = webkit_uri_scheme_request_get_type;

    extern fn g_object_ref(p_self: *webkit.URISchemeRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.URISchemeRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *URISchemeRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents a URI scheme response.
///
/// If you register a particular URI scheme in a `webkit.WebContext`,
/// using `webkit.WebContext.registerUriScheme`, you have to provide
/// a `webkit.URISchemeRequestCallback`. After that, when a URI response
/// is made with that particular scheme, your callback will be
/// called. There you will be able to provide more response parameters
/// when the methods and properties of a `webkit.URISchemeRequest` is not
/// enough.
///
/// When you finished setting up your `webkit.URISchemeResponse`, call
/// `webkit_uri_request_finish_with_response` with it to return the response.
pub const URISchemeResponse = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.URISchemeResponseClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The input stream to read from.
        pub const stream = struct {
            pub const name = "stream";

            pub const Type = ?*gio.InputStream;
        };

        /// The input stream length in bytes, `-1` for unknown length.
        pub const stream_length = struct {
            pub const name = "stream-length";

            pub const Type = i64;
        };
    };

    pub const signals = struct {};

    /// Create a new `webkit.URISchemeResponse`
    extern fn webkit_uri_scheme_response_new(p_input_stream: *gio.InputStream, p_stream_length: i64) *webkit.URISchemeResponse;
    pub const new = webkit_uri_scheme_response_new;

    /// Sets the content type for the `response`
    extern fn webkit_uri_scheme_response_set_content_type(p_response: *URISchemeResponse, p_content_type: [*:0]const u8) void;
    pub const setContentType = webkit_uri_scheme_response_set_content_type;

    /// Assign the provided `soup.MessageHeaders` to the response.
    ///
    /// `headers` need to be of the type `SOUP_MESSAGE_HEADERS_RESPONSE`.
    /// Any existing headers will be overwritten.
    extern fn webkit_uri_scheme_response_set_http_headers(p_response: *URISchemeResponse, p_headers: *soup.MessageHeaders) void;
    pub const setHttpHeaders = webkit_uri_scheme_response_set_http_headers;

    /// Sets the status code and reason phrase for the `response`.
    ///
    /// If `status_code` is a known value and `reason_phrase` is `NULL`, the `reason_phrase` will be set automatically.
    extern fn webkit_uri_scheme_response_set_status(p_response: *URISchemeResponse, p_status_code: c_uint, p_reason_phrase: ?[*:0]const u8) void;
    pub const setStatus = webkit_uri_scheme_response_set_status;

    extern fn webkit_uri_scheme_response_get_type() usize;
    pub const getGObjectType = webkit_uri_scheme_response_get_type;

    extern fn g_object_ref(p_self: *webkit.URISchemeResponse) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.URISchemeResponse) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *URISchemeResponse, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Handles storage of user content filters on disk.
///
/// The WebKitUserContentFilterStore provides the means to import and save
/// [JSON rule sets](https://webkit.org/blog/3476/content-blockers-first-look/),
/// which can be loaded later in an efficient manner. Once filters are stored,
/// the `webkit.UserContentFilter` objects which represent them can be added to
/// a `webkit.UserContentManager` with `webkit.UserContentManager.addFilter`.
///
/// JSON rule sets are imported using `webkit.UserContentFilterStore.save` and stored
/// on disk in an implementation defined format. The contents of a filter store must be
/// managed using the `webkit.UserContentFilterStore`: a list of all the stored filters
/// can be obtained with `webkit.UserContentFilterStore.fetchIdentifiers`,
/// `webkit.UserContentFilterStore.load` can be used to retrieve a previously saved
/// filter, and removed from the store with `webkit.UserContentFilterStore.remove`.
pub const UserContentFilterStore = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.UserContentFilterStoreClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The directory used for filter storage. This path is used as the base
        /// directory where user content filters are stored on disk.
        pub const path = struct {
            pub const name = "path";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Create a new `webkit.UserContentFilterStore` to manipulate filters stored at `storage_path`.
    ///
    /// The path must point to a local filesystem, and will be created if needed.
    extern fn webkit_user_content_filter_store_new(p_storage_path: [*:0]const u8) *webkit.UserContentFilterStore;
    pub const new = webkit_user_content_filter_store_new;

    /// Asynchronously retrieve a list of the identifiers for all the stored filters.
    ///
    /// When the operation is finished, `callback` will be invoked, which then can use
    /// `webkit.UserContentFilterStore.fetchIdentifiersFinish` to obtain the list of
    /// filter identifiers.
    extern fn webkit_user_content_filter_store_fetch_identifiers(p_store: *UserContentFilterStore, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const fetchIdentifiers = webkit_user_content_filter_store_fetch_identifiers;

    /// Finishes an asynchronous fetch of the list of stored filters.
    ///
    /// Finishes an asynchronous fetch of the list of identifiers for the stored filters previously
    /// started with `webkit.UserContentFilterStore.fetchIdentifiers`.
    extern fn webkit_user_content_filter_store_fetch_identifiers_finish(p_store: *UserContentFilterStore, p_result: *gio.AsyncResult) [*][*:0]u8;
    pub const fetchIdentifiersFinish = webkit_user_content_filter_store_fetch_identifiers_finish;

    /// Gets the storage path for user content filters.
    extern fn webkit_user_content_filter_store_get_path(p_store: *UserContentFilterStore) [*:0]const u8;
    pub const getPath = webkit_user_content_filter_store_get_path;

    /// Asynchronously load a content filter given its `identifier`.
    ///
    /// The filter must have been
    /// previously stored using `webkit.UserContentFilterStore.save`.
    ///
    /// When the operation is finished, `callback` will be invoked, which then can use
    /// `webkit.UserContentFilterStore.loadFinish` to obtain the resulting filter.
    extern fn webkit_user_content_filter_store_load(p_store: *UserContentFilterStore, p_identifier: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const load = webkit_user_content_filter_store_load;

    /// Finishes an asynchronous filter load previously started with
    /// `webkit.UserContentFilterStore.load`.
    extern fn webkit_user_content_filter_store_load_finish(p_store: *UserContentFilterStore, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*webkit.UserContentFilter;
    pub const loadFinish = webkit_user_content_filter_store_load_finish;

    /// Asynchronously remove a content filter given its `identifier`.
    ///
    /// When the operation is finished, `callback` will be invoked, which then can use
    /// `webkit.UserContentFilterStore.removeFinish` to check whether the removal was
    /// successful.
    extern fn webkit_user_content_filter_store_remove(p_store: *UserContentFilterStore, p_identifier: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const remove = webkit_user_content_filter_store_remove;

    /// Finishes an asynchronous filter removal previously started with
    /// `webkit.UserContentFilterStore.remove`.
    extern fn webkit_user_content_filter_store_remove_finish(p_store: *UserContentFilterStore, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const removeFinish = webkit_user_content_filter_store_remove_finish;

    /// Asynchronously save a content filter from a set source rule.
    ///
    /// Asynchronously save a content filter from a source rule set in the
    /// [WebKit content extesions JSON format](https://webkit.org/blog/3476/content-blockers-first-look/).
    ///
    /// The `identifier` can be used afterwards to refer to the filter when using
    /// `webkit.UserContentFilterStore.remove` and `webkit.UserContentFilterStore.load`.
    /// When the `identifier` has been used in the past, the new filter source will replace
    /// the one saved beforehand for the same identifier.
    ///
    /// When the operation is finished, `callback` will be invoked, which then can use
    /// `webkit.UserContentFilterStore.saveFinish` to obtain the resulting filter.
    extern fn webkit_user_content_filter_store_save(p_store: *UserContentFilterStore, p_identifier: [*:0]const u8, p_source: *glib.Bytes, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const save = webkit_user_content_filter_store_save;

    /// Finishes an asynchronous filter save previously started with
    /// `webkit.UserContentFilterStore.save`.
    extern fn webkit_user_content_filter_store_save_finish(p_store: *UserContentFilterStore, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*webkit.UserContentFilter;
    pub const saveFinish = webkit_user_content_filter_store_save_finish;

    /// Asynchronously save a content filter from the contents of a file.
    ///
    /// Asynchronously save a content filter from the contents of a file, which must be
    /// native to the platform, as checked by `gio.File.isNative`. See
    /// `webkit.UserContentFilterStore.save` for more details.
    ///
    /// When the operation is finished, `callback` will be invoked, which then can use
    /// `webkit.UserContentFilterStore.saveFinish` to obtain the resulting filter.
    extern fn webkit_user_content_filter_store_save_from_file(p_store: *UserContentFilterStore, p_identifier: [*:0]const u8, p_file: *gio.File, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const saveFromFile = webkit_user_content_filter_store_save_from_file;

    /// Finishes and asynchronous filter save previously started with
    /// `webkit.UserContentFilterStore.saveFromFile`.
    extern fn webkit_user_content_filter_store_save_from_file_finish(p_store: *UserContentFilterStore, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*webkit.UserContentFilter;
    pub const saveFromFileFinish = webkit_user_content_filter_store_save_from_file_finish;

    extern fn webkit_user_content_filter_store_get_type() usize;
    pub const getGObjectType = webkit_user_content_filter_store_get_type;

    extern fn g_object_ref(p_self: *webkit.UserContentFilterStore) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.UserContentFilterStore) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *UserContentFilterStore, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Manages user-defined content which affects web pages.
///
/// Using a `webkit.UserContentManager` user CSS style sheets can be set to
/// be injected in the web pages loaded by a `webkit.WebView`, by
/// `webkit.UserContentManager.addStyleSheet`.
///
/// To use a `webkit.UserContentManager`, it must be created using
/// `webkit.UserContentManager.new`, and then used to construct
/// a `webkit.WebView`. User style sheets can be created with
/// `webkit.UserStyleSheet.new`.
///
/// User style sheets can be added and removed at any time, but
/// they will affect the web pages loaded afterwards.
pub const UserContentManager = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.UserContentManagerClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {
        /// This signal is emitted when JavaScript in a web view calls
        /// <code>window.webkit.messageHandlers.<name>.`postMessage`</code>, after registering
        /// <code><name></code> using
        /// `webkit.UserContentManager.registerScriptMessageHandler`
        pub const script_message_received = struct {
            pub const name = "script-message-received";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_value: *javascriptcore.Value, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(UserContentManager, p_instance))),
                    gobject.signalLookup("script-message-received", UserContentManager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when JavaScript in a web view calls
        /// <code>window.webkit.messageHandlers.<name>.`postMessage`</code>, after registering
        /// <code><name></code> using
        /// `webkit.UserContentManager.registerScriptMessageHandlerWithReply`
        ///
        /// The given `reply` can be used to send a return value with
        /// `webkit.ScriptMessageReply.returnValue` or an error message with
        /// `webkit.ScriptMessageReply.returnErrorMessage`. If none of them are
        /// called, an automatic reply with an undefined value will be sent.
        ///
        /// It is possible to handle the reply asynchronously, by simply calling
        /// `gobject.Object.ref` on the `reply` and returning `TRUE`.
        pub const script_message_with_reply_received = struct {
            pub const name = "script-message-with-reply-received";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_value: *javascriptcore.Value, p_reply: *webkit.ScriptMessageReply, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(UserContentManager, p_instance))),
                    gobject.signalLookup("script-message-with-reply-received", UserContentManager.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new user content manager.
    extern fn webkit_user_content_manager_new() *webkit.UserContentManager;
    pub const new = webkit_user_content_manager_new;

    /// Adds a `webkit.UserContentFilter` to the given `webkit.UserContentManager`.
    ///
    /// The same `webkit.UserContentFilter` can be reused with multiple
    /// `webkit.UserContentManager` instances.
    ///
    /// Filters need to be saved and loaded from `webkit.UserContentFilterStore`.
    extern fn webkit_user_content_manager_add_filter(p_manager: *UserContentManager, p_filter: *webkit.UserContentFilter) void;
    pub const addFilter = webkit_user_content_manager_add_filter;

    /// Adds a `webkit.UserScript` to the given `webkit.UserContentManager`.
    ///
    /// The same `webkit.UserScript` can be reused with multiple
    /// `webkit.UserContentManager` instances.
    extern fn webkit_user_content_manager_add_script(p_manager: *UserContentManager, p_script: *webkit.UserScript) void;
    pub const addScript = webkit_user_content_manager_add_script;

    /// Adds a `webkit.UserStyleSheet` to the given `webkit.UserContentManager`.
    ///
    /// The same `webkit.UserStyleSheet` can be reused with multiple
    /// `webkit.UserContentManager` instances.
    extern fn webkit_user_content_manager_add_style_sheet(p_manager: *UserContentManager, p_stylesheet: *webkit.UserStyleSheet) void;
    pub const addStyleSheet = webkit_user_content_manager_add_style_sheet;

    /// Registers a new user script message handler in script world.
    ///
    /// After it is registered,
    /// scripts can use `window.webkit.messageHandlers.<name>.postMessage(value)`
    /// to send messages. Those messages are received by connecting handlers
    /// to the `webkit.UserContentManager.signals.script`-message-received signal. The
    /// handler name is used as the detail of the signal. To avoid race
    /// conditions between registering the handler name, and starting to
    /// receive the signals, it is recommended to connect to the signal
    /// *before* registering the handler name:
    ///
    /// ```c
    /// WebKitWebView *view = webkit_web_view_new ();
    /// WebKitUserContentManager *manager = webkit_web_view_get_user_content_manager ();
    /// g_signal_connect (manager, "script-message-received::foobar",
    ///                   G_CALLBACK (handle_script_message), NULL);
    /// webkit_user_content_manager_register_script_message_handler (manager, "foobar");
    /// ```
    ///
    /// Registering a script message handler will fail if the requested
    /// name has been already registered before.
    ///
    /// If `NULL` is passed as the `world_name`, the default world will be used.
    ///
    /// The registered handler can be unregistered by using
    /// `webkit.UserContentManager.unregisterScriptMessageHandler`.
    extern fn webkit_user_content_manager_register_script_message_handler(p_manager: *UserContentManager, p_name: [*:0]const u8, p_world_name: ?[*:0]const u8) c_int;
    pub const registerScriptMessageHandler = webkit_user_content_manager_register_script_message_handler;

    /// Registers a new user script message handler in script world with name `world_name`.
    ///
    /// Different from `webkit.UserContentManager.registerScriptMessageHandler`,
    /// when using this function to register the handler, the connected signal is
    /// script-message-with-reply-received, and a reply provided by the user is expected.
    /// Otherwise, the user will receive a default undefined value.
    ///
    /// If `NULL` is passed as the `world_name`, the default world will be used.
    /// See `webkit.UserContentManager.registerScriptMessageHandler` for full description.
    ///
    /// Registering a script message handler will fail if the requested
    /// name has been already registered before.
    ///
    /// The registered handler can be unregistered by using
    /// `webkit.UserContentManager.unregisterScriptMessageHandler`.
    extern fn webkit_user_content_manager_register_script_message_handler_with_reply(p_manager: *UserContentManager, p_name: [*:0]const u8, p_world_name: ?[*:0]const u8) c_int;
    pub const registerScriptMessageHandlerWithReply = webkit_user_content_manager_register_script_message_handler_with_reply;

    /// Removes all content filters from the given `webkit.UserContentManager`.
    extern fn webkit_user_content_manager_remove_all_filters(p_manager: *UserContentManager) void;
    pub const removeAllFilters = webkit_user_content_manager_remove_all_filters;

    /// Removes all user scripts from the given `webkit.UserContentManager`
    ///
    /// See also `webkit.UserContentManager.removeScript`.
    extern fn webkit_user_content_manager_remove_all_scripts(p_manager: *UserContentManager) void;
    pub const removeAllScripts = webkit_user_content_manager_remove_all_scripts;

    /// Removes all user style sheets from the given `webkit.UserContentManager`.
    extern fn webkit_user_content_manager_remove_all_style_sheets(p_manager: *UserContentManager) void;
    pub const removeAllStyleSheets = webkit_user_content_manager_remove_all_style_sheets;

    /// Removes a filter from the given `webkit.UserContentManager`.
    ///
    /// Since 2.24
    extern fn webkit_user_content_manager_remove_filter(p_manager: *UserContentManager, p_filter: *webkit.UserContentFilter) void;
    pub const removeFilter = webkit_user_content_manager_remove_filter;

    /// Removes a filter by the given identifier.
    ///
    /// Removes a filter from the given `webkit.UserContentManager` given the
    /// identifier of a `webkit.UserContentFilter` as returned by
    /// `webkit.UserContentFilter.getIdentifier`.
    extern fn webkit_user_content_manager_remove_filter_by_id(p_manager: *UserContentManager, p_filter_id: [*:0]const u8) void;
    pub const removeFilterById = webkit_user_content_manager_remove_filter_by_id;

    /// Removes a `webkit.UserScript` from the given `webkit.UserContentManager`.
    ///
    /// See also `webkit.UserContentManager.removeAllScripts`.
    extern fn webkit_user_content_manager_remove_script(p_manager: *UserContentManager, p_script: *webkit.UserScript) void;
    pub const removeScript = webkit_user_content_manager_remove_script;

    /// Removes a `webkit.UserStyleSheet` from the given `webkit.UserContentManager`.
    ///
    /// See also `webkit.UserContentManager.removeAllStyleSheets`.
    extern fn webkit_user_content_manager_remove_style_sheet(p_manager: *UserContentManager, p_stylesheet: *webkit.UserStyleSheet) void;
    pub const removeStyleSheet = webkit_user_content_manager_remove_style_sheet;

    /// Unregisters a previously registered message handler in script world with name `world_name`.
    /// If `NULL` is passed as the `world_name`, the default world will be used.
    ///
    /// Note that this does *not* disconnect handlers for the
    /// `webkit.UserContentManager.signals.script`-message-received signal;
    /// they will be kept connected, but the signal will not be emitted
    /// unless the handler name is registered again.
    ///
    /// See also `webkit.UserContentManager.registerScriptMessageHandler`.
    extern fn webkit_user_content_manager_unregister_script_message_handler(p_manager: *UserContentManager, p_name: [*:0]const u8, p_world_name: ?[*:0]const u8) void;
    pub const unregisterScriptMessageHandler = webkit_user_content_manager_unregister_script_message_handler;

    extern fn webkit_user_content_manager_get_type() usize;
    pub const getGObjectType = webkit_user_content_manager_get_type;

    extern fn g_object_ref(p_self: *webkit.UserContentManager) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.UserContentManager) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *UserContentManager, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A permission request for accessing user's audio/video devices.
///
/// WebKitUserMediaPermissionRequest represents a request for
/// permission to decide whether WebKit should be allowed to access the user's
/// audio and video source devices when requested through the getUserMedia API.
///
/// When a WebKitUserMediaPermissionRequest is not handled by the user,
/// it is denied by default.
pub const UserMediaPermissionRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{webkit.PermissionRequest};
    pub const Class = webkit.UserMediaPermissionRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether the media device to which the permission was requested has a microphone or not.
        pub const is_for_audio_device = struct {
            pub const name = "is-for-audio-device";

            pub const Type = c_int;
        };

        /// Whether the media device to which the permission was requested has a video capture capability or not.
        pub const is_for_video_device = struct {
            pub const name = "is-for-video-device";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    extern fn webkit_user_media_permission_request_get_type() usize;
    pub const getGObjectType = webkit_user_media_permission_request_get_type;

    extern fn g_object_ref(p_self: *webkit.UserMediaPermissionRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.UserMediaPermissionRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *UserMediaPermissionRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Message that can be sent between the UI process and web process extensions.
///
/// A WebKitUserMessage is a message that can be used for the communication between the UI process
/// and web process extensions. A WebKitUserMessage always has a name, and it can also include parameters and
/// UNIX file descriptors. Messages can be sent from a `webkit.WebContext` to all web process extensions,
/// from a web process extension to its corresponding `webkit.WebContext`, and from a `webkit.WebView` to its
/// corresponding `WebKitWebPage` (and vice versa). One to one messages can be replied to directly with
/// `webkit.UserMessage.sendReply`.
pub const UserMessage = opaque {
    pub const Parent = gobject.InitiallyUnowned;
    pub const Implements = [_]type{};
    pub const Class = webkit.UserMessageClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The UNIX file descriptors of the user message.
        pub const fd_list = struct {
            pub const name = "fd-list";

            pub const Type = ?*gio.UnixFDList;
        };

        /// The name of the user message.
        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        /// The parameters of the user message as a `glib.Variant`, or `NULL`
        /// if the message doesn't include parameters. Note that only complete types are
        /// allowed.
        pub const parameters = struct {
            pub const name = "parameters";

            pub const Type = ?*glib.Variant;
        };
    };

    pub const signals = struct {};

    /// Create a new `webkit.UserMessage` with `name`.
    extern fn webkit_user_message_new(p_name: [*:0]const u8, p_parameters: ?*glib.Variant) *webkit.UserMessage;
    pub const new = webkit_user_message_new;

    /// Create a new `webkit.UserMessage` including also a list of UNIX file descriptors to be sent.
    extern fn webkit_user_message_new_with_fd_list(p_name: [*:0]const u8, p_parameters: ?*glib.Variant, p_fd_list: ?*gio.UnixFDList) *webkit.UserMessage;
    pub const newWithFdList = webkit_user_message_new_with_fd_list;

    /// Get the `message` list of file descritpor.
    extern fn webkit_user_message_get_fd_list(p_message: *UserMessage) ?*gio.UnixFDList;
    pub const getFdList = webkit_user_message_get_fd_list;

    /// Get the `message` name.
    extern fn webkit_user_message_get_name(p_message: *UserMessage) [*:0]const u8;
    pub const getName = webkit_user_message_get_name;

    /// Get the `message` parameters.
    extern fn webkit_user_message_get_parameters(p_message: *UserMessage) ?*glib.Variant;
    pub const getParameters = webkit_user_message_get_parameters;

    /// Send a reply to an user message.
    ///
    /// If `reply` is floating, it's consumed.
    /// You can only send a reply to a `webkit.UserMessage` that has been
    /// received.
    extern fn webkit_user_message_send_reply(p_message: *UserMessage, p_reply: *webkit.UserMessage) void;
    pub const sendReply = webkit_user_message_send_reply;

    extern fn webkit_user_message_get_type() usize;
    pub const getGObjectType = webkit_user_message_get_type;

    extern fn g_object_ref(p_self: *webkit.UserMessage) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.UserMessage) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *UserMessage, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Manages aspects common to all `webkit.WebView`<!-- -->s
///
/// The `webkit.WebContext` manages all aspects common to all
/// `webkit.WebView`<!-- -->s.
///
/// You can define the `webkit.CacheModel` with
/// `webkit.WebContext.setCacheModel`, depending on the needs of
/// your application. You can access the `webkit.SecurityManager` to specify
/// the behaviour of your application regarding security using
/// `webkit.WebContext.getSecurityManager`.
///
/// It is also possible to change your preferred language or enable
/// spell checking, using `webkit.WebContext.setPreferredLanguages`,
/// `webkit.WebContext.setSpellCheckingLanguages` and
/// `webkit.WebContext.setSpellCheckingEnabled`.
///
/// You can use `webkit.WebContext.registerUriScheme` to register
/// custom URI schemes, and manage several other settings.
///
/// TLS certificate validation failure is now treated as a transport
/// error by default. To handle TLS failures differently, you can
/// connect to `webkit.WebView.signals.load`-failed-with-tls-errors.
/// Alternatively, you can use `webkit_web_context_set_tls_errors_policy`
/// to set the policy `WEBKIT_TLS_ERRORS_POLICY_IGNORE`; however, this is
/// not appropriate for Internet applications.
pub const WebContext = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.WebContextClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `webkit.MemoryPressureSettings` applied to the web processes created by this context.
        pub const memory_pressure_settings = struct {
            pub const name = "memory-pressure-settings";

            pub const Type = ?*webkit.MemoryPressureSettings;
        };

        /// The timezone override for this web context. Setting this property provides a better
        /// alternative to configure the timezone information for all webviews managed by the WebContext.
        /// The other, less optimal, approach is to globally set the TZ environment variable in the
        /// process before creating the context. However this approach might not be very convenient and
        /// can have side-effects in your application.
        ///
        /// The expected values for this property are defined in the IANA timezone database. See this
        /// wikipedia page for instance, https://en.wikipedia.org/wiki/List_of_tz_database_time_zones.
        pub const time_zone_override = struct {
            pub const name = "time-zone-override";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {
        /// This signal is emitted when a new automation request is made.
        /// Note that it will never be emitted if automation is not enabled in `context`,
        /// see `webkit.WebContext.setAutomationAllowed` for more details.
        pub const automation_started = struct {
            pub const name = "automation-started";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_session: *webkit.AutomationSession, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebContext, p_instance))),
                    gobject.signalLookup("automation-started", WebContext.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a `webkit.WebContext` needs to set
        /// initial notification permissions for a web process. It is emitted
        /// when a new web process is about to be launched, and signals the
        /// most appropriate moment to use
        /// `webkit.WebContext.initializeNotificationPermissions`. If no
        /// notification permissions have changed since the last time this
        /// signal was emitted, then there is no need to call
        /// `webkit.WebContext.initializeNotificationPermissions` again.
        pub const initialize_notification_permissions = struct {
            pub const name = "initialize-notification-permissions";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebContext, p_instance))),
                    gobject.signalLookup("initialize-notification-permissions", WebContext.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a new web process is about to be
        /// launched. It signals the most appropriate moment to use
        /// `webkit.WebContext.setWebProcessExtensionsInitializationUserData`
        /// and `webkit.WebContext.setWebProcessExtensionsDirectory`.
        pub const initialize_web_process_extensions = struct {
            pub const name = "initialize-web-process-extensions";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebContext, p_instance))),
                    gobject.signalLookup("initialize-web-process-extensions", WebContext.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a `webkit.UserMessage` is received from a
        /// web process extension. You can reply to the message using
        /// `webkit.UserMessage.sendReply`.
        ///
        /// You can handle the user message asynchronously by calling `gobject.Object.ref` on
        /// `message` and returning `TRUE`.
        pub const user_message_received = struct {
            pub const name = "user-message-received";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_message: *webkit.UserMessage, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebContext, p_instance))),
                    gobject.signalLookup("user-message-received", WebContext.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Gets the default web context.
    extern fn webkit_web_context_get_default() *webkit.WebContext;
    pub const getDefault = webkit_web_context_get_default;

    /// Create a new `webkit.WebContext`.
    extern fn webkit_web_context_new() *webkit.WebContext;
    pub const new = webkit_web_context_new;

    /// Adds a path to be mounted in the sandbox.
    ///
    /// `path` must exist before any web process has been created; otherwise,
    /// it will be silently ignored. It is a fatal error to add paths after
    /// a web process has been spawned.
    ///
    /// Paths under `/sys`, `/proc`, and `/dev` are invalid. Attempting to
    /// add all of `/` is not valid. Since 2.40, adding the user's entire
    /// home directory or /home is also not valid.
    ///
    /// See also `webkit_web_context_set_sandbox_enabled`
    extern fn webkit_web_context_add_path_to_sandbox(p_context: *WebContext, p_path: [*:0]const u8, p_read_only: c_int) void;
    pub const addPathToSandbox = webkit_web_context_add_path_to_sandbox;

    /// Returns the current cache model.
    ///
    /// For more information about this
    /// value check the documentation of the function
    /// `webkit.WebContext.setCacheModel`.
    extern fn webkit_web_context_get_cache_model(p_context: *WebContext) webkit.CacheModel;
    pub const getCacheModel = webkit_web_context_get_cache_model;

    /// Get the `webkit.GeolocationManager` of `context`.
    extern fn webkit_web_context_get_geolocation_manager(p_context: *WebContext) *webkit.GeolocationManager;
    pub const getGeolocationManager = webkit_web_context_get_geolocation_manager;

    /// Get the `webkit.NetworkSession` used for automation sessions started in `context`.
    extern fn webkit_web_context_get_network_session_for_automation(p_context: *WebContext) ?*webkit.NetworkSession;
    pub const getNetworkSessionForAutomation = webkit_web_context_get_network_session_for_automation;

    /// Get the `webkit.SecurityManager` of `context`.
    extern fn webkit_web_context_get_security_manager(p_context: *WebContext) *webkit.SecurityManager;
    pub const getSecurityManager = webkit_web_context_get_security_manager;

    /// Get whether spell checking feature is currently enabled.
    extern fn webkit_web_context_get_spell_checking_enabled(p_context: *WebContext) c_int;
    pub const getSpellCheckingEnabled = webkit_web_context_get_spell_checking_enabled;

    /// Get the the list of spell checking languages.
    ///
    /// Get the the list of spell checking languages associated with
    /// `context`, or `NULL` if no languages have been previously set.
    ///
    /// See `webkit.WebContext.setSpellCheckingLanguages` for more
    /// details on the format of the languages in the list.
    extern fn webkit_web_context_get_spell_checking_languages(p_context: *WebContext) [*]const [*:0]const u8;
    pub const getSpellCheckingLanguages = webkit_web_context_get_spell_checking_languages;

    /// Get the `webkit.WebContext.properties.time`-zone-override property.
    extern fn webkit_web_context_get_time_zone_override(p_context: *WebContext) [*:0]const u8;
    pub const getTimeZoneOverride = webkit_web_context_get_time_zone_override;

    /// Sets initial desktop notification permissions for the `context`.
    ///
    /// `allowed_origins` and `disallowed_origins` must each be `glib.List` of
    /// `webkit.SecurityOrigin` objects representing origins that will,
    /// respectively, either always or never have permission to show desktop
    /// notifications. No `webkit.NotificationPermissionRequest` will ever be
    /// generated for any of the security origins represented in
    /// `allowed_origins` or `disallowed_origins`. This function is necessary
    /// because some webpages proactively check whether they have permission
    /// to display notifications without ever creating a permission request.
    ///
    /// This function only affects web processes that have not already been
    /// created. The best time to call it is when handling
    /// `webkit.WebContext.signals.initialize`-notification-permissions so as to
    /// ensure that new web processes receive the most recent set of
    /// permissions.
    extern fn webkit_web_context_initialize_notification_permissions(p_context: *WebContext, p_allowed_origins: *glib.List, p_disallowed_origins: *glib.List) void;
    pub const initializeNotificationPermissions = webkit_web_context_initialize_notification_permissions;

    /// Get whether automation is allowed in `context`.
    ///
    /// See also `webkit.WebContext.setAutomationAllowed`.
    extern fn webkit_web_context_is_automation_allowed(p_context: *WebContext) c_int;
    pub const isAutomationAllowed = webkit_web_context_is_automation_allowed;

    /// Register `scheme` in `context`.
    ///
    /// Register `scheme` in `context`, so that when an URI request with `scheme` is made in the
    /// `webkit.WebContext`, the `webkit.URISchemeRequestCallback` registered will be called with a
    /// `webkit.URISchemeRequest`.
    /// It is possible to handle URI scheme requests asynchronously, by calling `gobject.Object.ref` on the
    /// `webkit.URISchemeRequest` and calling `webkit.URISchemeRequest.finish` later
    /// when the data of the request is available or
    /// `webkit.URISchemeRequest.finishError` in case of error.
    ///
    /// ```c
    /// static void
    /// about_uri_scheme_request_cb (WebKitURISchemeRequest *request,
    ///                              gpointer                user_data)
    /// {
    ///     GInputStream *stream;
    ///     gsize         stream_length;
    ///     const gchar  *path = webkit_uri_scheme_request_get_path (request);
    ///
    ///     if (!g_strcmp0 (path, "memory")) {
    ///         // Create a GInputStream with the contents of memory about page, and set its length to stream_length
    ///     } else if (!g_strcmp0 (path, "applications")) {
    ///         // Create a GInputStream with the contents of applications about page, and set its length to stream_length
    ///     } else if (!g_strcmp0 (path, "example")) {
    ///         gchar *contents = g_strdup_printf ("<html><body><p>Example about page</p></body></html>");
    ///         stream_length = strlen (contents);
    ///         stream = g_memory_input_stream_new_from_data (contents, stream_length, g_free);
    ///     } else {
    ///         GError *error = g_error_new (ABOUT_HANDLER_ERROR, ABOUT_HANDLER_ERROR_INVALID, "Invalid about:`s` page.", path);
    ///         webkit_uri_scheme_request_finish_error (request, error);
    ///         g_error_free (error);
    ///         return;
    ///     }
    ///     webkit_uri_scheme_request_finish (request, stream, stream_length, "text/html");
    ///     g_object_unref (stream);
    /// }
    /// ```
    extern fn webkit_web_context_register_uri_scheme(p_context: *WebContext, p_scheme: [*:0]const u8, p_callback: webkit.URISchemeRequestCallback, p_user_data: ?*anyopaque, p_user_data_destroy_func: ?glib.DestroyNotify) void;
    pub const registerUriScheme = webkit_web_context_register_uri_scheme;

    /// Send `message` to all web process extensions associated to `context`.
    ///
    /// If `message` is floating, it's consumed.
    extern fn webkit_web_context_send_message_to_all_extensions(p_context: *WebContext, p_message: *webkit.UserMessage) void;
    pub const sendMessageToAllExtensions = webkit_web_context_send_message_to_all_extensions;

    /// Set whether automation is allowed in `context`.
    ///
    /// When automation is enabled the browser could
    /// be controlled by another process by requesting an automation session. When a new automation
    /// session is requested the signal `webkit.WebContext.signals.automation`-started is emitted.
    /// Automation is disabled by default, so you need to explicitly call this method passing `TRUE`
    /// to enable it.
    ///
    /// Note that only one `webkit.WebContext` can have automation enabled, so this will do nothing
    /// if there's another `webkit.WebContext` with automation already enabled.
    extern fn webkit_web_context_set_automation_allowed(p_context: *WebContext, p_allowed: c_int) void;
    pub const setAutomationAllowed = webkit_web_context_set_automation_allowed;

    /// Specifies a usage model for WebViews.
    ///
    /// Specifies a usage model for WebViews, which WebKit will use to
    /// determine its caching behavior. All web views follow the cache
    /// model. This cache model determines the RAM and disk space to use
    /// for caching previously viewed content .
    ///
    /// Research indicates that users tend to browse within clusters of
    /// documents that hold resources in common, and to revisit previously
    /// visited documents. WebKit and the frameworks below it include
    /// built-in caches that take advantage of these patterns,
    /// substantially improving document load speed in browsing
    /// situations. The WebKit cache model controls the behaviors of all of
    /// these caches, including various WebCore caches.
    ///
    /// Browsers can improve document load speed substantially by
    /// specifying `WEBKIT_CACHE_MODEL_WEB_BROWSER`. Applications without a
    /// browsing interface can reduce memory usage substantially by
    /// specifying `WEBKIT_CACHE_MODEL_DOCUMENT_VIEWER`. The default value is
    /// `WEBKIT_CACHE_MODEL_WEB_BROWSER`.
    extern fn webkit_web_context_set_cache_model(p_context: *WebContext, p_cache_model: webkit.CacheModel) void;
    pub const setCacheModel = webkit_web_context_set_cache_model;

    /// Set the list of preferred languages.
    ///
    /// Set the list of preferred languages, sorted from most desirable
    /// to least desirable. The list will be used in the following ways:
    ///
    /// - Determining how to build the `Accept-Language` HTTP header that will be
    ///   included in the network requests started by the `webkit.WebContext`.
    /// - Setting the values of `navigator.language` and `navigator.languages`.
    /// - The first item in the list sets the default locale for JavaScript
    ///   `Intl` functions.
    extern fn webkit_web_context_set_preferred_languages(p_context: *WebContext, p_languages: ?[*]const [*:0]const u8) void;
    pub const setPreferredLanguages = webkit_web_context_set_preferred_languages;

    /// Enable or disable the spell checking feature.
    extern fn webkit_web_context_set_spell_checking_enabled(p_context: *WebContext, p_enabled: c_int) void;
    pub const setSpellCheckingEnabled = webkit_web_context_set_spell_checking_enabled;

    /// Set the list of spell checking languages to be used for spell
    /// checking.
    ///
    /// The locale string typically is in the form lang_COUNTRY, where lang
    /// is an ISO-639 language code, and COUNTRY is an ISO-3166 country code.
    /// For instance, sv_FI for Swedish as written in Finland or pt_BR
    /// for Portuguese as written in Brazil.
    ///
    /// You need to call this function with a valid list of languages at
    /// least once in order to properly enable the spell checking feature
    /// in WebKit.
    extern fn webkit_web_context_set_spell_checking_languages(p_context: *WebContext, p_languages: [*]const [*:0]const u8) void;
    pub const setSpellCheckingLanguages = webkit_web_context_set_spell_checking_languages;

    /// Set the directory where WebKit will look for web process extensions.
    ///
    /// This method must be called before loading anything in this context,
    /// otherwise it will not have any effect. You can connect to
    /// `webkit.WebContext.signals.initialize`-web-process-extensions to call this method
    /// before anything is loaded.
    extern fn webkit_web_context_set_web_process_extensions_directory(p_context: *WebContext, p_directory: [*:0]const u8) void;
    pub const setWebProcessExtensionsDirectory = webkit_web_context_set_web_process_extensions_directory;

    /// Set user data to be passed to Web Extensions on initialization.
    ///
    /// The data will be passed to the
    /// `WebKitWebProcessExtensionInitializeWithUserDataFunction`.
    /// This method must be called before loading anything in this context,
    /// otherwise it will not have any effect. You can connect to
    /// `webkit.WebContext.signals.initialize`-web-process-extensions to call this method
    /// before anything is loaded.
    extern fn webkit_web_context_set_web_process_extensions_initialization_user_data(p_context: *WebContext, p_user_data: *glib.Variant) void;
    pub const setWebProcessExtensionsInitializationUserData = webkit_web_context_set_web_process_extensions_initialization_user_data;

    extern fn webkit_web_context_get_type() usize;
    pub const getGObjectType = webkit_web_context_get_type;

    extern fn g_object_ref(p_self: *webkit.WebContext) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.WebContext) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebContext, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Access to the WebKit inspector.
///
/// The WebKit Inspector is a graphical tool to inspect and change the
/// content of a `webkit.WebView`. It also includes an interactive
/// JavaScript debugger. Using this class one can get a `gtk.Widget`
/// which can be embedded into an application to show the inspector.
///
/// The inspector is available when the `webkit.Settings` of the
/// `webkit.WebView` has set the `webkit.Settings.properties.enable`-developer-extras
/// to true, otherwise no inspector is available.
///
/// ```c
/// // Enable the developer extras
/// WebKitSettings *settings = webkit_web_view_get_settings (WEBKIT_WEB_VIEW(my_webview));
/// g_object_set (G_OBJECT(settings), "enable-developer-extras", TRUE, NULL);
///
/// // Load some data or reload to be able to inspect the page
/// webkit_web_view_load_uri (WEBKIT_WEB_VIEW(my_webview), "http://www.gnome.org");
///
/// // Show the inspector
/// WebKitWebInspector *inspector = webkit_web_view_get_inspector (WEBKIT_WEB_VIEW(my_webview));
/// webkit_web_inspector_show (WEBKIT_WEB_INSPECTOR(inspector));
/// ```
pub const WebInspector = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.WebInspectorClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The height that the inspector view should have when it is attached.
        pub const attached_height = struct {
            pub const name = "attached-height";

            pub const Type = c_uint;
        };

        /// Whether the `inspector` can be attached to the same window that contains
        /// the inspected view.
        pub const can_attach = struct {
            pub const name = "can-attach";

            pub const Type = c_int;
        };

        /// The URI that is currently being inspected.
        pub const inspected_uri = struct {
            pub const name = "inspected-uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {
        /// Emitted when the inspector is requested to be attached to the window
        /// where the inspected web view is.
        /// If this signal is not handled the inspector view will be automatically
        /// attached to the inspected view, so you only need to handle this signal
        /// if you want to attach the inspector view yourself (for example, to add
        /// the inspector view to a browser tab).
        ///
        /// To prevent the inspector view from being attached you can connect to this
        /// signal and simply return `TRUE`.
        pub const attach = struct {
            pub const name = "attach";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebInspector, p_instance))),
                    gobject.signalLookup("attach", WebInspector.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the inspector should be shown.
        ///
        /// If the inspector is not attached the inspector window should be shown
        /// on top of any other windows.
        /// If the inspector is attached the inspector view should be made visible.
        /// For example, if the inspector view is attached using a tab in a browser
        /// window, the browser window should be raised and the tab containing the
        /// inspector view should be the active one.
        /// In both cases, if this signal is not handled, the default implementation
        /// calls `gtk.Window.present` on the current toplevel `gtk.Window` of the
        /// inspector view.
        pub const bring_to_front = struct {
            pub const name = "bring-to-front";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebInspector, p_instance))),
                    gobject.signalLookup("bring-to-front", WebInspector.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the inspector page is closed. If you are using your own
        /// inspector window, you should connect to this signal and destroy your
        /// window.
        pub const closed = struct {
            pub const name = "closed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebInspector, p_instance))),
                    gobject.signalLookup("closed", WebInspector.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the inspector is requested to be detached from the window
        /// it is currently attached to. The inspector is detached when the inspector page
        /// is about to be closed, and this signal is emitted right before
        /// `webkit.WebInspector.signals.closed`, or when the user clicks on the detach button
        /// in the inspector view to show the inspector in a separate window. In this case
        /// the signal `webkit.WebInspector.signals.open`-window is emitted after this one.
        ///
        /// To prevent the inspector view from being detached you can connect to this
        /// signal and simply return `TRUE`.
        pub const detach = struct {
            pub const name = "detach";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebInspector, p_instance))),
                    gobject.signalLookup("detach", WebInspector.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the inspector is requested to open in a separate window.
        /// If this signal is not handled, a `gtk.Window` with the inspector will be
        /// created and shown, so you only need to handle this signal if you want
        /// to use your own window.
        /// This signal is emitted after `webkit.WebInspector.signals.detach` to show
        /// the inspector in a separate window after being detached.
        ///
        /// To prevent the inspector from being shown you can connect to this
        /// signal and simply return `TRUE`
        pub const open_window = struct {
            pub const name = "open-window";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebInspector, p_instance))),
                    gobject.signalLookup("open-window", WebInspector.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Request `inspector` to be attached.
    ///
    /// The signal `webkit.WebInspector.signals.attach`
    /// will be emitted. If the inspector is already attached it does nothing.
    extern fn webkit_web_inspector_attach(p_inspector: *WebInspector) void;
    pub const attach = webkit_web_inspector_attach;

    /// Request `inspector` to be closed.
    extern fn webkit_web_inspector_close(p_inspector: *WebInspector) void;
    pub const close = webkit_web_inspector_close;

    /// Request `inspector` to be detached.
    ///
    /// The signal `webkit.WebInspector.signals.detach`
    /// will be emitted. If the inspector is already detached it does nothing.
    extern fn webkit_web_inspector_detach(p_inspector: *WebInspector) void;
    pub const detach = webkit_web_inspector_detach;

    /// Get the height that the inspector view when attached.
    ///
    /// Get the height that the inspector view should have when
    /// it's attached. If the inspector view is not attached this
    /// returns 0.
    extern fn webkit_web_inspector_get_attached_height(p_inspector: *WebInspector) c_uint;
    pub const getAttachedHeight = webkit_web_inspector_get_attached_height;

    /// Whether the `inspector` can be attached to the same window that contains
    /// the inspected view.
    extern fn webkit_web_inspector_get_can_attach(p_inspector: *WebInspector) c_int;
    pub const getCanAttach = webkit_web_inspector_get_can_attach;

    /// Get the URI that is currently being inspected.
    ///
    /// This can be `NULL` if
    /// nothing has been loaded yet in the inspected view, if the inspector
    /// has been closed or when inspected view was loaded from a HTML string
    /// instead of a URI.
    extern fn webkit_web_inspector_get_inspected_uri(p_inspector: *WebInspector) [*:0]const u8;
    pub const getInspectedUri = webkit_web_inspector_get_inspected_uri;

    /// Get the `webkit.WebViewBase` used to display the inspector.
    ///
    /// This might be `NULL` if the inspector hasn't been loaded yet,
    /// or it has been closed.
    extern fn webkit_web_inspector_get_web_view(p_inspector: *WebInspector) *webkit.WebViewBase;
    pub const getWebView = webkit_web_inspector_get_web_view;

    /// Whether the `inspector` view is currently attached to the same window that contains
    /// the inspected view.
    extern fn webkit_web_inspector_is_attached(p_inspector: *WebInspector) c_int;
    pub const isAttached = webkit_web_inspector_is_attached;

    /// Request `inspector` to be shown.
    extern fn webkit_web_inspector_show(p_inspector: *WebInspector) void;
    pub const show = webkit_web_inspector_show;

    extern fn webkit_web_inspector_get_type() usize;
    pub const getGObjectType = webkit_web_inspector_get_type;

    extern fn g_object_ref(p_self: *webkit.WebInspector) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.WebInspector) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebInspector, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Represents a resource at the end of a URI.
///
/// A `webkit.WebResource` encapsulates content for each resource at the
/// end of a particular URI. For example, one `webkit.WebResource` will
/// be created for each separate image and stylesheet when a page is
/// loaded.
///
/// You can access the response and the URI for a given
/// `webkit.WebResource`, using `webkit.WebResource.getUri` and
/// `webkit.WebResource.getResponse`, as well as the raw data, using
/// `webkit.WebResource.getData`.
pub const WebResource = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.WebResourceClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `webkit.URIResponse` associated with this resource.
        pub const response = struct {
            pub const name = "response";

            pub const Type = ?*webkit.URIResponse;
        };

        /// The current active URI of the `webkit.WebResource`.
        /// See `webkit.WebResource.getUri` for more details.
        pub const uri = struct {
            pub const name = "uri";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {
        /// This signal is emitted when an error occurs during the resource
        /// load operation.
        pub const failed = struct {
            pub const name = "failed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_error: *glib.Error, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebResource, p_instance))),
                    gobject.signalLookup("failed", WebResource.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a TLS error occurs during the resource load operation.
        pub const failed_with_tls_errors = struct {
            pub const name = "failed-with-tls-errors";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_certificate: *gio.TlsCertificate, p_errors: gio.TlsCertificateFlags, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebResource, p_instance))),
                    gobject.signalLookup("failed-with-tls-errors", WebResource.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when the resource load finishes successfully
        /// or due to an error. In case of errors `webkit.WebResource.signals.failed` signal
        /// is emitted before this one.
        pub const finished = struct {
            pub const name = "finished";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebResource, p_instance))),
                    gobject.signalLookup("finished", WebResource.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when `request` has been sent to the
        /// server. In case of a server redirection this signal is
        /// emitted again with the `request` argument containing the new
        /// request sent to the server due to the redirection and the
        /// `redirected_response` parameter containing the response
        /// received by the server for the initial request.
        pub const sent_request = struct {
            pub const name = "sent-request";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_request: *webkit.URIRequest, p_redirected_response: *webkit.URIResponse, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebResource, p_instance))),
                    gobject.signalLookup("sent-request", WebResource.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Asynchronously get the raw data for `resource`.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.WebResource.getDataFinish` to get the result of the operation.
    extern fn webkit_web_resource_get_data(p_resource: *WebResource, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const getData = webkit_web_resource_get_data;

    /// Finish an asynchronous operation started with `webkit.WebResource.getData`.
    extern fn webkit_web_resource_get_data_finish(p_resource: *WebResource, p_result: *gio.AsyncResult, p_length: ?*usize, p_error: ?*?*glib.Error) ?[*]u8;
    pub const getDataFinish = webkit_web_resource_get_data_finish;

    /// Retrieves the `webkit.URIResponse` of the resource load operation.
    ///
    /// This method returns `NULL` if called before the response
    /// is received from the server. You can connect to notify::response
    /// signal to be notified when the response is received.
    extern fn webkit_web_resource_get_response(p_resource: *WebResource) *webkit.URIResponse;
    pub const getResponse = webkit_web_resource_get_response;

    /// Returns the current active URI of `resource`.
    ///
    /// The active URI might change during
    /// a load operation:
    ///
    /// <orderedlist>
    /// <listitem><para>
    ///   When the resource load starts, the active URI is the requested URI
    /// </para></listitem>
    /// <listitem><para>
    ///   When the initial request is sent to the server, `webkit.WebResource.signals.sent`-request
    ///   signal is emitted without a redirected response, the active URI is the URI of
    ///   the request sent to the server.
    /// </para></listitem>
    /// <listitem><para>
    ///   In case of a server redirection, `webkit.WebResource.signals.sent`-request signal
    ///   is emitted again with a redirected response, the active URI is the URI the request
    ///   was redirected to.
    /// </para></listitem>
    /// <listitem><para>
    ///   When the response is received from the server, the active URI is the final
    ///   one and it will not change again.
    /// </para></listitem>
    /// </orderedlist>
    ///
    /// You can monitor the active URI by connecting to the notify::uri
    /// signal of `resource`.
    extern fn webkit_web_resource_get_uri(p_resource: *WebResource) [*:0]const u8;
    pub const getUri = webkit_web_resource_get_uri;

    extern fn webkit_web_resource_get_type() usize;
    pub const getGObjectType = webkit_web_resource_get_type;

    extern fn g_object_ref(p_self: *webkit.WebResource) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.WebResource) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebResource, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The central class of the WPE WebKit and WebKitGTK APIs.
///
/// `webkit.WebView` is the central class of the WPE WebKit and WebKitGTK
/// APIs. It is responsible for managing the drawing of the content and
/// forwarding of events. You can load any URI into the `webkit.WebView` or
/// a data string. With `webkit.Settings` you can control various aspects
/// of the rendering and loading of the content.
///
/// Note that in WebKitGTK, `webkit.WebView` is scrollable by itself, so
/// you don't need to embed it in a `gtk.ScrolledWindow`.
pub const WebView = extern struct {
    pub const Parent = webkit.WebViewBase;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = webkit.WebViewClass;
    f_parent_instance: webkit.WebViewBase,
    f_priv: ?*webkit.WebViewPrivate,

    pub const virtual_methods = struct {
        pub const authenticate = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_request: *webkit.AuthenticationRequest) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_authenticate.?(gobject.ext.as(WebView, p_web_view), p_request);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_request: *webkit.AuthenticationRequest) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_authenticate = @ptrCast(p_implementation);
            }
        };

        pub const close = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(WebView.Class, p_class).f_close.?(gobject.ext.as(WebView, p_web_view));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(WebView.Class, p_class).f_close = @ptrCast(p_implementation);
            }
        };

        pub const context_menu = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context_menu: *webkit.ContextMenu, p_hit_test_result: *webkit.HitTestResult) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_context_menu.?(gobject.ext.as(WebView, p_web_view), p_context_menu, p_hit_test_result);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_context_menu: *webkit.ContextMenu, p_hit_test_result: *webkit.HitTestResult) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_context_menu = @ptrCast(p_implementation);
            }
        };

        pub const context_menu_dismissed = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(WebView.Class, p_class).f_context_menu_dismissed.?(gobject.ext.as(WebView, p_web_view));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(WebView.Class, p_class).f_context_menu_dismissed = @ptrCast(p_implementation);
            }
        };

        pub const create = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_navigation_action: *webkit.NavigationAction) *gtk.Widget {
                return gobject.ext.as(WebView.Class, p_class).f_create.?(gobject.ext.as(WebView, p_web_view), p_navigation_action);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_navigation_action: *webkit.NavigationAction) callconv(.C) *gtk.Widget) void {
                gobject.ext.as(WebView.Class, p_class).f_create = @ptrCast(p_implementation);
            }
        };

        pub const decide_policy = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_decision: *webkit.PolicyDecision, p_type: webkit.PolicyDecisionType) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_decide_policy.?(gobject.ext.as(WebView, p_web_view), p_decision, p_type);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_decision: *webkit.PolicyDecision, p_type: webkit.PolicyDecisionType) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_decide_policy = @ptrCast(p_implementation);
            }
        };

        pub const enter_fullscreen = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_enter_fullscreen.?(gobject.ext.as(WebView, p_web_view));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_enter_fullscreen = @ptrCast(p_implementation);
            }
        };

        pub const insecure_content_detected = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_event: webkit.InsecureContentEvent) void {
                return gobject.ext.as(WebView.Class, p_class).f_insecure_content_detected.?(gobject.ext.as(WebView, p_web_view), p_event);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_event: webkit.InsecureContentEvent) callconv(.C) void) void {
                gobject.ext.as(WebView.Class, p_class).f_insecure_content_detected = @ptrCast(p_implementation);
            }
        };

        pub const leave_fullscreen = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_leave_fullscreen.?(gobject.ext.as(WebView, p_web_view));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_leave_fullscreen = @ptrCast(p_implementation);
            }
        };

        pub const load_changed = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_load_event: webkit.LoadEvent) void {
                return gobject.ext.as(WebView.Class, p_class).f_load_changed.?(gobject.ext.as(WebView, p_web_view), p_load_event);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_load_event: webkit.LoadEvent) callconv(.C) void) void {
                gobject.ext.as(WebView.Class, p_class).f_load_changed = @ptrCast(p_implementation);
            }
        };

        pub const load_failed = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_load_event: webkit.LoadEvent, p_failing_uri: [*:0]const u8, p_error: *glib.Error) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_load_failed.?(gobject.ext.as(WebView, p_web_view), p_load_event, p_failing_uri, p_error);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_load_event: webkit.LoadEvent, p_failing_uri: [*:0]const u8, p_error: *glib.Error) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_load_failed = @ptrCast(p_implementation);
            }
        };

        pub const load_failed_with_tls_errors = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_failing_uri: [*:0]const u8, p_certificate: *gio.TlsCertificate, p_errors: gio.TlsCertificateFlags) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_load_failed_with_tls_errors.?(gobject.ext.as(WebView, p_web_view), p_failing_uri, p_certificate, p_errors);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_failing_uri: [*:0]const u8, p_certificate: *gio.TlsCertificate, p_errors: gio.TlsCertificateFlags) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_load_failed_with_tls_errors = @ptrCast(p_implementation);
            }
        };

        pub const mouse_target_changed = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_hit_test_result: *webkit.HitTestResult, p_modifiers: c_uint) void {
                return gobject.ext.as(WebView.Class, p_class).f_mouse_target_changed.?(gobject.ext.as(WebView, p_web_view), p_hit_test_result, p_modifiers);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_hit_test_result: *webkit.HitTestResult, p_modifiers: c_uint) callconv(.C) void) void {
                gobject.ext.as(WebView.Class, p_class).f_mouse_target_changed = @ptrCast(p_implementation);
            }
        };

        pub const permission_request = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_permission_request: *webkit.PermissionRequest) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_permission_request.?(gobject.ext.as(WebView, p_web_view), p_permission_request);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_permission_request: *webkit.PermissionRequest) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_permission_request = @ptrCast(p_implementation);
            }
        };

        pub const print = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_print_operation: *webkit.PrintOperation) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_print.?(gobject.ext.as(WebView, p_web_view), p_print_operation);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_print_operation: *webkit.PrintOperation) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_print = @ptrCast(p_implementation);
            }
        };

        pub const query_permission_state = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_query: *webkit.PermissionStateQuery) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_query_permission_state.?(gobject.ext.as(WebView, p_web_view), p_query);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_query: *webkit.PermissionStateQuery) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_query_permission_state = @ptrCast(p_implementation);
            }
        };

        pub const ready_to_show = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(WebView.Class, p_class).f_ready_to_show.?(gobject.ext.as(WebView, p_web_view));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(WebView.Class, p_class).f_ready_to_show = @ptrCast(p_implementation);
            }
        };

        pub const resource_load_started = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_resource: *webkit.WebResource, p_request: *webkit.URIRequest) void {
                return gobject.ext.as(WebView.Class, p_class).f_resource_load_started.?(gobject.ext.as(WebView, p_web_view), p_resource, p_request);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_resource: *webkit.WebResource, p_request: *webkit.URIRequest) callconv(.C) void) void {
                gobject.ext.as(WebView.Class, p_class).f_resource_load_started = @ptrCast(p_implementation);
            }
        };

        pub const run_as_modal = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(WebView.Class, p_class).f_run_as_modal.?(gobject.ext.as(WebView, p_web_view));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(WebView.Class, p_class).f_run_as_modal = @ptrCast(p_implementation);
            }
        };

        pub const run_color_chooser = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_request: *webkit.ColorChooserRequest) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_run_color_chooser.?(gobject.ext.as(WebView, p_web_view), p_request);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_request: *webkit.ColorChooserRequest) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_run_color_chooser = @ptrCast(p_implementation);
            }
        };

        pub const run_file_chooser = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_request: *webkit.FileChooserRequest) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_run_file_chooser.?(gobject.ext.as(WebView, p_web_view), p_request);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_request: *webkit.FileChooserRequest) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_run_file_chooser = @ptrCast(p_implementation);
            }
        };

        pub const script_dialog = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_dialog: *webkit.ScriptDialog) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_script_dialog.?(gobject.ext.as(WebView, p_web_view), p_dialog);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_dialog: *webkit.ScriptDialog) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_script_dialog = @ptrCast(p_implementation);
            }
        };

        pub const show_notification = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_notification: *webkit.Notification) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_show_notification.?(gobject.ext.as(WebView, p_web_view), p_notification);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_notification: *webkit.Notification) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_show_notification = @ptrCast(p_implementation);
            }
        };

        pub const show_option_menu = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_menu: *webkit.OptionMenu, p_rectangle: *gdk.Rectangle) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_show_option_menu.?(gobject.ext.as(WebView, p_web_view), p_menu, p_rectangle);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_menu: *webkit.OptionMenu, p_rectangle: *gdk.Rectangle) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_show_option_menu = @ptrCast(p_implementation);
            }
        };

        pub const submit_form = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_request: *webkit.FormSubmissionRequest) void {
                return gobject.ext.as(WebView.Class, p_class).f_submit_form.?(gobject.ext.as(WebView, p_web_view), p_request);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_request: *webkit.FormSubmissionRequest) callconv(.C) void) void {
                gobject.ext.as(WebView.Class, p_class).f_submit_form = @ptrCast(p_implementation);
            }
        };

        pub const user_message_received = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_message: *webkit.UserMessage) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_user_message_received.?(gobject.ext.as(WebView, p_web_view), p_message);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_message: *webkit.UserMessage) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_user_message_received = @ptrCast(p_implementation);
            }
        };

        pub const web_process_crashed = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_int {
                return gobject.ext.as(WebView.Class, p_class).f_web_process_crashed.?(gobject.ext.as(WebView, p_web_view));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_int) void {
                gobject.ext.as(WebView.Class, p_class).f_web_process_crashed = @ptrCast(p_implementation);
            }
        };

        pub const web_process_terminated = struct {
            pub fn call(p_class: anytype, p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_reason: webkit.WebProcessTerminationReason) void {
                return gobject.ext.as(WebView.Class, p_class).f_web_process_terminated.?(gobject.ext.as(WebView, p_web_view), p_reason);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_web_view: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_reason: webkit.WebProcessTerminationReason) callconv(.C) void) void {
                gobject.ext.as(WebView.Class, p_class).f_web_process_terminated = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The `webkit.AutomationBrowsingContextPresentation` of `webkit.WebView`. This should only be used when
        /// creating a new `webkit.WebView` as a response to `webkit.AutomationSession.signals.create`-web-view
        /// signal request. If the new WebView was added to a new tab of current browsing context window
        /// `WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_TAB` should be used.
        pub const automation_presentation_type = struct {
            pub const name = "automation-presentation-type";

            pub const Type = webkit.AutomationBrowsingContextPresentation;
        };

        /// Capture state of the camera device. Whenever the user grants a media-request sent by the web
        /// page, requesting video capture capabilities (`navigator.mediaDevices.getUserMedia({video:
        /// true})`) this property will be set to `WEBKIT_MEDIA_CAPTURE_STATE_ACTIVE`.
        ///
        /// The application can monitor this property and provide a visual indicator allowing to optionally
        /// deactivate or mute the capture device by setting this property respectively to
        /// `WEBKIT_MEDIA_CAPTURE_STATE_NONE` or `WEBKIT_MEDIA_CAPTURE_STATE_MUTED`.
        ///
        /// If the capture state of the device is set to `WEBKIT_MEDIA_CAPTURE_STATE_NONE` the web-page
        /// can still re-request the permission to the user. Permission desision caching is left to the
        /// application.
        pub const camera_capture_state = struct {
            pub const name = "camera-capture-state";

            pub const Type = webkit.MediaCaptureState;
        };

        /// The default Content-Security-Policy used by the webview as if it were set
        /// by an HTTP header.
        ///
        /// This applies to all content loaded including through navigation or via the various
        /// webkit_web_view_load_\* APIs. However do note that many WebKit APIs bypass
        /// Content-Security-Policy in general such as `webkit.UserContentManager` and
        /// `webkit_web_view_run_javascript`.
        ///
        /// Policies are additive so if a website sets its own policy it still applies
        /// on top of the policy set here.
        pub const default_content_security_policy = struct {
            pub const name = "default-content-security-policy";

            pub const Type = ?[*:0]u8;
        };

        /// Capture state of the display device. Whenever the user grants a media-request sent by the web
        /// page, requesting screencasting capabilities (`navigator.mediaDevices.`getDisplayMedia` this
        /// property will be set to `WEBKIT_MEDIA_CAPTURE_STATE_ACTIVE`.
        ///
        /// The application can monitor this property and provide a visual indicator allowing to
        /// optionally deactivate or mute the capture device by setting this property respectively to
        /// `WEBKIT_MEDIA_CAPTURE_STATE_NONE` or `WEBKIT_MEDIA_CAPTURE_STATE_MUTED`.
        ///
        /// If the capture state of the device is set to `WEBKIT_MEDIA_CAPTURE_STATE_NONE` the web-page
        /// can still re-request the permission to the user. Permission desision caching is left to the
        /// application.
        pub const display_capture_state = struct {
            pub const name = "display-capture-state";

            pub const Type = webkit.MediaCaptureState;
        };

        /// Whether the pages loaded inside `webkit.WebView` are editable. For more
        /// information see `webkit.WebView.setEditable`.
        pub const editable = struct {
            pub const name = "editable";

            pub const Type = c_int;
        };

        /// An estimate of the percent completion for the current loading operation.
        /// This value will range from 0.0 to 1.0 and, once a load completes,
        /// will remain at 1.0 until a new load starts, at which point it
        /// will be reset to 0.0.
        /// The value is an estimate based on the total number of bytes expected
        /// to be received for a document, including all its possible subresources
        /// and child documents.
        pub const estimated_load_progress = struct {
            pub const name = "estimated-load-progress";

            pub const Type = f64;
        };

        /// The favicon currently associated to the `webkit.WebView`.
        /// See `webkit.WebView.getFavicon` for more details.
        pub const favicon = struct {
            pub const name = "favicon";

            pub const Type = ?*gdk.Texture;
        };

        /// Whether the `webkit.WebView` is controlled by automation. This should only be used when
        /// creating a new `webkit.WebView` as a response to `webkit.AutomationSession.signals.create`-web-view
        /// signal request.
        pub const is_controlled_by_automation = struct {
            pub const name = "is-controlled-by-automation";

            pub const Type = c_int;
        };

        /// Whether the `webkit.WebView` is currently loading a page. This property becomes
        /// `TRUE` as soon as a new load operation is requested and before the
        /// `webkit.WebView.signals.load`-changed signal is emitted with `WEBKIT_LOAD_STARTED` and
        /// at that point the active URI is the requested one.
        /// When the load operation finishes the property is set to `FALSE` before
        /// `webkit.WebView.signals.load`-changed is emitted with `WEBKIT_LOAD_FINISHED`.
        pub const is_loading = struct {
            pub const name = "is-loading";

            pub const Type = c_int;
        };

        /// Whether the `webkit.WebView` audio is muted. When `TRUE`, audio is silenced.
        /// It may still be playing, i.e. `webkit.WebView.properties.is`-playing-audio may be `TRUE`.
        pub const is_muted = struct {
            pub const name = "is-muted";

            pub const Type = c_int;
        };

        /// Whether the `webkit.WebView` is currently playing audio from a page.
        /// This property becomes `TRUE` as soon as web content starts playing any
        /// kind of audio. When a page is no longer playing any kind of sound,
        /// the property is set back to `FALSE`.
        pub const is_playing_audio = struct {
            pub const name = "is-playing-audio";

            pub const Type = c_int;
        };

        /// Whether the web process currently associated to the `webkit.WebView` is responsive.
        pub const is_web_process_responsive = struct {
            pub const name = "is-web-process-responsive";

            pub const Type = c_int;
        };

        /// Capture state of the microphone device. Whenever the user grants a media-request sent by the web
        /// page, requesting audio capture capabilities (`navigator.mediaDevices.getUserMedia({audio:
        /// true})`) this property will be set to `WEBKIT_MEDIA_CAPTURE_STATE_ACTIVE`.
        ///
        /// The application can monitor this property and provide a visual indicator allowing to
        /// optionally deactivate or mute the capture device by setting this property respectively to
        /// `WEBKIT_MEDIA_CAPTURE_STATE_NONE` or `WEBKIT_MEDIA_CAPTURE_STATE_MUTED`.
        ///
        /// If the capture state of the device is set to `WEBKIT_MEDIA_CAPTURE_STATE_NONE` the web-page
        /// can still re-request the permission to the user. Permission desision caching is left to the
        /// application.
        pub const microphone_capture_state = struct {
            pub const name = "microphone-capture-state";

            pub const Type = webkit.MediaCaptureState;
        };

        /// The `webkit.NetworkSession` of the view
        pub const network_session = struct {
            pub const name = "network-session";

            pub const Type = ?*webkit.NetworkSession;
        };

        /// The identifier of the `WebKitWebPage` corresponding to the `webkit.WebView`.
        pub const page_id = struct {
            pub const name = "page-id";

            pub const Type = u64;
        };

        /// The related `webkit.WebView` used when creating the view to share the
        /// same web process and network session. This property is not readable
        /// because the related web view is only valid during the object construction.
        pub const related_view = struct {
            pub const name = "related-view";

            pub const Type = ?*webkit.WebView;
        };

        /// The `webkit.Settings` of the view.
        pub const settings = struct {
            pub const name = "settings";

            pub const Type = ?*webkit.Settings;
        };

        /// The main frame document title of this `webkit.WebView`. If
        /// the title has not been received yet, it will be `NULL`.
        pub const title = struct {
            pub const name = "title";

            pub const Type = ?[*:0]u8;
        };

        /// The current active URI of the `webkit.WebView`.
        /// See `webkit.WebView.getUri` for more details.
        pub const uri = struct {
            pub const name = "uri";

            pub const Type = ?[*:0]u8;
        };

        /// The `webkit.UserContentManager` of the view.
        pub const user_content_manager = struct {
            pub const name = "user-content-manager";

            pub const Type = ?*webkit.UserContentManager;
        };

        /// The `webkit.WebContext` of the view.
        pub const web_context = struct {
            pub const name = "web-context";

            pub const Type = ?*webkit.WebContext;
        };

        /// This configures `web_view` to treat the content as a WebExtension.
        ///
        /// Note that this refers to the web standard [WebExtensions](https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons/WebExtensions)
        /// and not WebKitWebExtensions.
        ///
        /// In practice this limits the Content-Security-Policies that are allowed to be set. Some details can be found in
        /// [Chrome's documentation](https://developer.chrome.com/docs/extensions/mv3/intro/mv3-migration/`content`-security-policy).
        pub const web_extension_mode = struct {
            pub const name = "web-extension-mode";

            pub const Type = webkit.WebExtensionMode;
        };

        /// The `webkit.WebsitePolicies` for the view.
        pub const website_policies = struct {
            pub const name = "website-policies";

            pub const Type = ?*webkit.WebsitePolicies;
        };

        /// The zoom level of the `webkit.WebView` content.
        /// See `webkit.WebView.setZoomLevel` for more details.
        pub const zoom_level = struct {
            pub const name = "zoom-level";

            pub const Type = f64;
        };
    };

    pub const signals = struct {
        /// This signal is emitted when the user is challenged with HTTP
        /// authentication. To let the  application access or supply
        /// the credentials as well as to allow the client application
        /// to either cancel the request or perform the authentication,
        /// the signal will pass an instance of the
        /// `webkit.AuthenticationRequest` in the `request` argument.
        /// To handle this signal asynchronously you should keep a ref
        /// of the request and return `TRUE`. To disable HTTP authentication
        /// entirely, connect to this signal and simply return `TRUE`.
        ///
        /// The default signal handler will run a default authentication
        /// dialog asynchronously for the user to interact with.
        pub const authenticate = struct {
            pub const name = "authenticate";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_request: *webkit.AuthenticationRequest, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("authenticate", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when closing a `webkit.WebView` is requested. This occurs when a
        /// call is made from JavaScript's <function>window.close</function> function or
        /// after trying to close the `web_view` with `webkit.WebView.tryClose`.
        /// It is the owner's responsibility to handle this signal to hide or
        /// destroy the `webkit.WebView`, if necessary.
        pub const close = struct {
            pub const name = "close";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("close", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a context menu is about to be displayed to give the application
        /// a chance to customize the proposed menu, prevent the menu from being displayed,
        /// or build its own context menu.
        /// <itemizedlist>
        /// <listitem><para>
        ///  To customize the proposed menu you can use `webkit.ContextMenu.prepend`,
        ///  `webkit.ContextMenu.append` or `webkit.ContextMenu.insert` to add new
        ///  `webkit.ContextMenuItem`<!-- -->s to `context_menu`, `webkit.ContextMenu.moveItem`
        ///  to reorder existing items, or `webkit.ContextMenu.remove` to remove an
        ///  existing item. The signal handler should return `FALSE`, and the menu represented
        ///  by `context_menu` will be shown.
        /// </para></listitem>
        /// <listitem><para>
        ///  To prevent the menu from being displayed you can just connect to this signal
        ///  and return `TRUE` so that the proposed menu will not be shown.
        /// </para></listitem>
        /// <listitem><para>
        ///  To build your own menu, you can remove all items from the proposed menu with
        ///  `webkit.ContextMenu.removeAll`, add your own items and return `FALSE` so
        ///  that the menu will be shown. You can also ignore the proposed `webkit.ContextMenu`,
        ///  build your own `GtkMenu` and return `TRUE` to prevent the proposed menu from being shown.
        /// </para></listitem>
        /// <listitem><para>
        ///  If you just want the default menu to be shown always, simply don't connect to this
        ///  signal because showing the proposed context menu is the default behaviour.
        /// </para></listitem>
        /// </itemizedlist>
        ///
        /// If the signal handler returns `FALSE` the context menu represented by `context_menu`
        /// will be shown, if it return `TRUE` the context menu will not be shown.
        ///
        /// The proposed `webkit.ContextMenu` passed in `context_menu` argument is only valid
        /// during the signal emission.
        pub const context_menu = struct {
            pub const name = "context-menu";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_context_menu: *webkit.ContextMenu, p_hit_test_result: *webkit.HitTestResult, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("context-menu", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted after `webkit.WebView.signals.context`-menu signal, if the context menu is shown,
        /// to notify that the context menu is dismissed.
        pub const context_menu_dismissed = struct {
            pub const name = "context-menu-dismissed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("context-menu-dismissed", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the creation of a new `webkit.WebView` is requested.
        /// If this signal is handled the signal handler should return the
        /// newly created `webkit.WebView`.
        ///
        /// The `webkit.NavigationAction` parameter contains information about the
        /// navigation action that triggered this signal.
        ///
        /// The new `webkit.WebView` must be related to `web_view`, see
        /// `webkit.WebView.properties.related`-view for more details.
        ///
        /// The new `webkit.WebView` should not be displayed to the user
        /// until the `webkit.WebView.signals.ready`-to-show signal is emitted.
        pub const create = struct {
            pub const name = "create";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_navigation_action: *webkit.NavigationAction, P_Data) callconv(.C) *gtk.Widget, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("create", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when WebKit is requesting the client to decide a policy
        /// decision, such as whether to navigate to a page, open a new window or whether or
        /// not to download a resource. The `webkit.NavigationPolicyDecision` passed in the
        /// `decision` argument is a generic type, but should be casted to a more
        /// specific type when making the decision. For example:
        ///
        /// ```c
        /// static gboolean
        /// decide_policy_cb (WebKitWebView *web_view,
        ///                   WebKitPolicyDecision *decision,
        ///                   WebKitPolicyDecisionType type)
        /// {
        ///     switch (type) {
        ///     case WEBKIT_POLICY_DECISION_TYPE_NAVIGATION_ACTION: {
        ///         WebKitNavigationPolicyDecision *navigation_decision = WEBKIT_NAVIGATION_POLICY_DECISION (decision);
        ///         // Make a policy decision here
        ///         break;
        ///     }
        ///     case WEBKIT_POLICY_DECISION_TYPE_NEW_WINDOW_ACTION: {
        ///         WebKitNavigationPolicyDecision *navigation_decision = WEBKIT_NAVIGATION_POLICY_DECISION (decision);
        ///         // Make a policy decision here
        ///         break;
        ///     }
        ///     case WEBKIT_POLICY_DECISION_TYPE_RESPONSE:
        ///         WebKitResponsePolicyDecision *response = WEBKIT_RESPONSE_POLICY_DECISION (decision);
        ///         // Make a policy decision here
        ///         break;
        ///     default:
        ///         // Making no decision results in `webkit.PolicyDecision.use`
        ///         return FALSE;
        ///     }
        ///     return TRUE;
        /// }
        /// ```
        ///
        /// It is possible to make policy decision asynchronously, by simply calling `gobject.Object.ref`
        /// on the `decision` argument and returning `TRUE` to block the default signal handler.
        /// If the last reference is removed on a `webkit.PolicyDecision` and no decision has been
        /// made explicitly, `webkit.PolicyDecision.use` will be the default policy decision. The
        /// default signal handler will simply call `webkit.PolicyDecision.use`. Only the first
        /// policy decision chosen for a given `webkit.PolicyDecision` will have any affect.
        pub const decide_policy = struct {
            pub const name = "decide-policy";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_decision: *webkit.PolicyDecision, p_decision_type: webkit.PolicyDecisionType, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("decide-policy", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when JavaScript code calls
        /// <function>element.webkitRequestFullScreen</function>. If the
        /// signal is not handled the `webkit.WebView` will proceed to full screen
        /// its top level window. This signal can be used by client code to
        /// request permission to the user prior doing the full screen
        /// transition and eventually prepare the top-level window
        /// (e.g. hide some widgets that would otherwise be part of the
        /// full screen window).
        pub const enter_fullscreen = struct {
            pub const name = "enter-fullscreen";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("enter-fullscreen", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Prior to 2.46, this signal was emitted when insecure content was
        /// loaded in a secure content. Since 2.46, this signal is generally
        /// no longer emitted.
        pub const insecure_content_detected = struct {
            pub const name = "insecure-content-detected";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_event: webkit.InsecureContentEvent, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("insecure-content-detected", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when the `webkit.WebView` is about to restore its top level
        /// window out of its full screen state. This signal can be used by
        /// client code to restore widgets hidden during the
        /// `webkit.WebView.signals.enter`-fullscreen stage for instance.
        pub const leave_fullscreen = struct {
            pub const name = "leave-fullscreen";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("leave-fullscreen", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a load operation in `web_view` changes.
        /// The signal is always emitted with `WEBKIT_LOAD_STARTED` when a
        /// new load request is made and `WEBKIT_LOAD_FINISHED` when the load
        /// finishes successfully or due to an error. When the ongoing load
        /// operation fails `webkit.WebView.signals.load`-failed signal is emitted
        /// before `webkit.WebView.signals.load`-changed is emitted with
        /// `WEBKIT_LOAD_FINISHED`.
        /// If a redirection is received from the server, this signal is emitted
        /// with `WEBKIT_LOAD_REDIRECTED` after the initial emission with
        /// `WEBKIT_LOAD_STARTED` and before `WEBKIT_LOAD_COMMITTED`.
        /// When the page content starts arriving the signal is emitted with
        /// `WEBKIT_LOAD_COMMITTED` event.
        ///
        /// You can handle this signal and use a switch to track any ongoing
        /// load operation.
        ///
        /// ```c
        /// static void web_view_load_changed (WebKitWebView  *web_view,
        ///                                    WebKitLoadEvent load_event,
        ///                                    gpointer        user_data)
        /// {
        ///     switch (load_event) {
        ///     case WEBKIT_LOAD_STARTED:
        ///         // New load, we have now a provisional URI
        ///         provisional_uri = webkit_web_view_get_uri (web_view);
        ///         // Here we could start a spinner or update the
        ///         // location bar with the provisional URI
        ///         break;
        ///     case WEBKIT_LOAD_REDIRECTED:
        ///         redirected_uri = webkit_web_view_get_uri (web_view);
        ///         break;
        ///     case WEBKIT_LOAD_COMMITTED:
        ///         // The load is being performed. Current URI is
        ///         // the final one and it won't change unless a new
        ///         // load is requested or a navigation within the
        ///         // same page is performed
        ///         uri = webkit_web_view_get_uri (web_view);
        ///         break;
        ///     case WEBKIT_LOAD_FINISHED:
        ///         // Load finished, we can now stop the spinner
        ///         break;
        ///     }
        /// }
        /// ```
        pub const load_changed = struct {
            pub const name = "load-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_load_event: webkit.LoadEvent, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("load-changed", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when an error occurs during a load operation.
        /// If the error happened when starting to load data for a page
        /// `load_event` will be `WEBKIT_LOAD_STARTED`. If it happened while
        /// loading a committed data source `load_event` will be `WEBKIT_LOAD_COMMITTED`.
        /// Since a load error causes the load operation to finish, the signal
        /// WebKitWebView::load-changed will always be emitted with
        /// `WEBKIT_LOAD_FINISHED` event right after this one.
        ///
        /// By default, if the signal is not handled, a stock error page will be displayed.
        /// You need to handle the signal if you want to provide your own error page.
        pub const load_failed = struct {
            pub const name = "load-failed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_load_event: webkit.LoadEvent, p_failing_uri: [*:0]u8, p_error: *glib.Error, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("load-failed", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a TLS error occurs during a load operation.
        /// To allow an exception for this `certificate`
        /// and the host of `failing_uri` use `webkit_web_context_allow_tls_certificate_for_host`.
        ///
        /// To handle this signal asynchronously you should call `gobject.Object.ref` on `certificate`
        /// and return `TRUE`.
        ///
        /// If `FALSE` is returned, `webkit.WebView.signals.load`-failed will be emitted. The load
        /// will finish regardless of the returned value.
        pub const load_failed_with_tls_errors = struct {
            pub const name = "load-failed-with-tls-errors";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_failing_uri: [*:0]u8, p_certificate: *gio.TlsCertificate, p_errors: gio.TlsCertificateFlags, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("load-failed-with-tls-errors", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when the mouse cursor moves over an
        /// element such as a link, image or a media element. To determine
        /// what type of element the mouse cursor is over, a Hit Test is performed
        /// on the current mouse coordinates and the result is passed in the
        /// `hit_test_result` argument. The `modifiers` argument is a bitmask of
        /// `gdk.ModifierType` flags indicating the state of modifier keys.
        /// The signal is emitted again when the mouse is moved out of the
        /// current element with a new `hit_test_result`.
        pub const mouse_target_changed = struct {
            pub const name = "mouse-target-changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_hit_test_result: *webkit.HitTestResult, p_modifiers: c_uint, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("mouse-target-changed", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when WebKit is requesting the client to
        /// decide about a permission request, such as allowing the browser
        /// to switch to fullscreen mode, sharing its location or similar
        /// operations.
        ///
        /// A possible way to use this signal could be through a dialog
        /// allowing the user decide what to do with the request:
        ///
        /// ```c
        /// static gboolean permission_request_cb (WebKitWebView *web_view,
        ///                                        WebKitPermissionRequest *request,
        ///                                        GtkWindow *parent_window)
        /// {
        ///     GtkWidget *dialog = gtk_message_dialog_new (parent_window,
        ///                                                 GTK_DIALOG_MODAL,
        ///                                                 GTK_MESSAGE_QUESTION,
        ///                                                 GTK_BUTTONS_YES_NO,
        ///                                                 "Allow Permission Request?");
        ///     gtk_widget_show (dialog);
        ///     gint result = gtk_dialog_run (GTK_DIALOG (dialog));
        ///
        ///     switch (result) {
        ///     case GTK_RESPONSE_YES:
        ///         webkit_permission_request_allow (request);
        ///         break;
        ///     default:
        ///         webkit_permission_request_deny (request);
        ///         break;
        ///     }
        ///     gtk_widget_destroy (dialog);
        ///
        ///     return TRUE;
        /// }
        /// ```
        ///
        /// It is possible to handle permission requests asynchronously, by
        /// simply calling `gobject.Object.ref` on the `request` argument and
        /// returning `TRUE` to block the default signal handler.  If the
        /// last reference is removed on a `webkit.PermissionRequest` and the
        /// request has not been handled, `webkit.PermissionRequest.deny`
        /// will be the default action.
        ///
        /// If the signal is not handled, the `request` will be completed automatically
        /// by the specific `webkit.PermissionRequest` that could allow or deny it. Check the
        /// documentation of classes implementing `webkit.PermissionRequest` interface to know
        /// their default action.
        pub const permission_request = struct {
            pub const name = "permission-request";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_request: *webkit.PermissionRequest, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("permission-request", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when printing is requested on `web_view`, usually by a JavaScript call,
        /// before the print dialog is shown. This signal can be used to set the initial
        /// print settings and page setup of `print_operation` to be used as default values in
        /// the print dialog. You can call `webkit.PrintOperation.setPrintSettings` and
        /// `webkit.PrintOperation.setPageSetup` and then return `FALSE` to propagate the
        /// event so that the print dialog is shown.
        ///
        /// You can connect to this signal and return `TRUE` to cancel the print operation
        /// or implement your own print dialog.
        pub const print = struct {
            pub const name = "print";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_print_operation: *webkit.PrintOperation, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("print", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal allows the User-Agent to respond to permission requests for powerful features, as
        /// specified by the [Permissions W3C Specification](https://w3c.github.io/permissions/).
        /// You can reply to the query using `webkit.PermissionStateQuery.finish`.
        ///
        /// You can handle the query asynchronously by calling `webkit.PermissionStateQuery.ref` on
        /// `query` and returning `TRUE`. If the last reference of `query` is removed and the query has not
        /// been handled, the query result will be set to `WEBKIT_QUERY_PERMISSION_PROMPT`.
        pub const query_permission_state = struct {
            pub const name = "query-permission-state";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_query: *webkit.PermissionStateQuery, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("query-permission-state", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted after `webkit.WebView.signals.create` on the newly created `webkit.WebView`
        /// when it should be displayed to the user. When this signal is emitted
        /// all the information about how the window should look, including
        /// size, position, whether the location, status and scrollbars
        /// should be displayed, is already set on the `webkit.WindowProperties`
        /// of `web_view`. See also `webkit.WebView.getWindowProperties`.
        pub const ready_to_show = struct {
            pub const name = "ready-to-show";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("ready-to-show", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when a new resource is going to be loaded. The `request` parameter
        /// contains the `webkit.URIRequest` that will be sent to the server.
        /// You can monitor the load operation by connecting to the different signals
        /// of `resource`.
        pub const resource_load_started = struct {
            pub const name = "resource-load-started";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_resource: *webkit.WebResource, p_request: *webkit.URIRequest, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("resource-load-started", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted after `webkit.WebView.signals.ready`-to-show on the newly
        /// created `webkit.WebView` when JavaScript code calls
        /// <function>window.showModalDialog</function>. The purpose of
        /// this signal is to allow the client application to prepare the
        /// new view to behave as modal. Once the signal is emitted a new
        /// main loop will be run to block user interaction in the parent
        /// `webkit.WebView` until the new dialog is closed.
        pub const run_as_modal = struct {
            pub const name = "run-as-modal";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("run-as-modal", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when the user interacts with a <input
        /// type='color' /> HTML element, requesting from WebKit to show
        /// a dialog to select a color. To let the application know the details of
        /// the color chooser, as well as to allow the client application to either
        /// cancel the request or perform an actual color selection, the signal will
        /// pass an instance of the `webkit.ColorChooserRequest` in the `request`
        /// argument.
        ///
        /// It is possible to handle this request asynchronously by increasing the
        /// reference count of the request.
        ///
        /// The default signal handler will asynchronously run a regular
        /// `gtk.ColorChooser` for the user to interact with.
        pub const run_color_chooser = struct {
            pub const name = "run-color-chooser";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_request: *webkit.ColorChooserRequest, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("run-color-chooser", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when the user interacts with a <input
        /// type='file' /> HTML element, requesting from WebKit to show
        /// a dialog to select one or more files to be uploaded. To let the
        /// application know the details of the file chooser, as well as to
        /// allow the client application to either cancel the request or
        /// perform an actual selection of files, the signal will pass an
        /// instance of the `webkit.FileChooserRequest` in the `request`
        /// argument.
        ///
        /// The default signal handler will asynchronously run a regular
        /// `gtk.FileChooserDialog` for the user to interact with.
        pub const run_file_chooser = struct {
            pub const name = "run-file-chooser";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_request: *webkit.FileChooserRequest, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("run-file-chooser", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Emitted when JavaScript code calls <function>window.alert</function>,
        /// <function>window.confirm</function> or <function>window.prompt</function>,
        /// or when <function>onbeforeunload</function> event is fired.
        /// The `dialog` parameter should be used to build the dialog.
        /// If the signal is not handled a different dialog will be built and shown depending
        /// on the dialog type:
        /// <itemizedlist>
        /// <listitem><para>
        ///  `WEBKIT_SCRIPT_DIALOG_ALERT`: message dialog with a single Close button.
        /// </para></listitem>
        /// <listitem><para>
        ///  `WEBKIT_SCRIPT_DIALOG_CONFIRM`: message dialog with OK and Cancel buttons.
        /// </para></listitem>
        /// <listitem><para>
        ///  `WEBKIT_SCRIPT_DIALOG_PROMPT`: message dialog with OK and Cancel buttons and
        ///  a text entry with the default text.
        /// </para></listitem>
        /// <listitem><para>
        ///  `WEBKIT_SCRIPT_DIALOG_BEFORE_UNLOAD_CONFIRM`: message dialog with Stay and Leave buttons.
        /// </para></listitem>
        /// </itemizedlist>
        ///
        /// It is possible to handle the script dialog request asynchronously, by simply
        /// caling `webkit.ScriptDialog.ref` on the `dialog` argument and calling
        /// `webkit.ScriptDialog.close` when done.
        /// If the last reference is removed on a `webkit.ScriptDialog` and the dialog has not been
        /// closed, `webkit.ScriptDialog.close` will be called.
        pub const script_dialog = struct {
            pub const name = "script-dialog";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_dialog: *webkit.ScriptDialog, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("script-dialog", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a notification should be presented to the
        /// user. The `notification` is kept alive until either: 1) the web page cancels it
        /// or 2) a navigation happens.
        ///
        /// The default handler will emit a notification using libnotify, if built with
        /// support for it.
        pub const show_notification = struct {
            pub const name = "show-notification";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_notification: *webkit.Notification, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("show-notification", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a select element in `web_view` needs to display a
        /// dropdown menu. This signal can be used to show a custom menu, using `menu` to get
        /// the details of all items that should be displayed. The area of the element in the
        /// `webkit.WebView` is given as `rectangle` parameter, it can be used to position the
        /// menu.
        /// To handle this signal asynchronously you should keep a ref of the `menu`.
        ///
        /// The default signal handler will pop up a `GtkMenu`.
        pub const show_option_menu = struct {
            pub const name = "show-option-menu";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_menu: *webkit.OptionMenu, p_rectangle: *gdk.Rectangle, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("show-option-menu", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a form is about to be submitted. The `request`
        /// argument passed contains information about the text fields of the form. This
        /// is typically used to store login information that can be used later to
        /// pre-fill the form.
        /// The form will not be submitted until `webkit.FormSubmissionRequest.submit` is called.
        ///
        /// It is possible to handle the form submission request asynchronously, by
        /// simply calling `gobject.Object.ref` on the `request` argument and calling
        /// `webkit.FormSubmissionRequest.submit` when done to continue with the form submission.
        /// If the last reference is removed on a `webkit.FormSubmissionRequest` and the
        /// form has not been submitted, `webkit.FormSubmissionRequest.submit` will be called.
        pub const submit_form = struct {
            pub const name = "submit-form";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_request: *webkit.FormSubmissionRequest, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("submit-form", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when a `webkit.UserMessage` is received from the
        /// `WebKitWebPage` corresponding to `web_view`. You can reply to the message
        /// using `webkit.UserMessage.sendReply`.
        ///
        /// You can handle the user message asynchronously by calling `gobject.Object.ref` on
        /// `message` and returning `TRUE`. If the last reference of `message` is removed
        /// and the message has not been replied to, the operation in the `WebKitWebPage` will
        /// finish with error `WEBKIT_USER_MESSAGE_UNHANDLED_MESSAGE`.
        pub const user_message_received = struct {
            pub const name = "user-message-received";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_message: *webkit.UserMessage, P_Data) callconv(.C) c_int, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("user-message-received", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted when the web process terminates abnormally due
        /// to `reason`.
        pub const web_process_terminated = struct {
            pub const name = "web-process-terminated";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_reason: webkit.WebProcessTerminationReason, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(WebView, p_instance))),
                    gobject.signalLookup("web-process-terminated", WebView.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `webkit.WebView` with the default `webkit.WebContext`.
    ///
    /// Creates a new `webkit.WebView` with the default `webkit.WebContext` and
    /// no `webkit.UserContentManager` associated with it.
    /// See also `webkit_web_view_new_with_context`,
    /// `webkit_web_view_new_with_user_content_manager`, and
    /// `webkit_web_view_new_with_settings`.
    extern fn webkit_web_view_new() *webkit.WebView;
    pub const new = webkit_web_view_new;

    /// Asynchronously call `body` with `arguments` in the script world with name `world_name` of the main frame current context in `web_view`.
    /// The `arguments` values must be one of the following types, or contain only the following GVariant types: number, string and dictionary.
    /// The result of the operation can be a Promise that will be properly passed to the callback.
    /// If `world_name` is `NULL`, the default world is used. Any value that is not `NULL` is a distin ct world.
    /// The `source_uri` will be shown in exceptions and doesn't affect the behavior of the script.
    /// When not provided, the document URL is used.
    ///
    /// Note that if `webkit.Settings.properties.enable`-javascript is `FALSE`, this method will do nothing.
    /// If you want to use this method but still prevent web content from executing its own
    /// JavaScript, then use `webkit.Settings.properties.enable`-javascript-markup.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.WebView.callAsyncJavascriptFunctionFinish` to get the result of the operation.
    ///
    /// This is an example that shows how to pass arguments to a JS function that returns a Promise
    /// that resolves with the passed argument:
    ///
    /// ```c
    /// static void
    /// web_view_javascript_finished (GObject      *object,
    ///                               GAsyncResult *result,
    ///                               gpointer      user_data)
    /// {
    ///     JSCValue               *value;
    ///     GError                 *error = NULL;
    ///
    ///     value = webkit_web_view_call_async_javascript_function_finish (WEBKIT_WEB_VIEW (object), result, &error);
    ///     if (!value) {
    ///         g_warning ("Error running javascript: `s`", error->message);
    ///         g_error_free (error);
    ///         return;
    ///     }
    ///
    ///     if (jsc_value_is_number (value)) {
    ///         gint32        int_value = jsc_value_to_string (value);
    ///         JSCException *exception = jsc_context_get_exception (jsc_value_get_context (value));
    ///         if (exception)
    ///             g_warning ("Error running javascript: `s`", jsc_exception_get_message (exception));
    ///         else
    ///             g_print ("Script result: `d`\n", int_value);
    ///         g_free (str_value);
    ///     } else {
    ///         g_warning ("Error running javascript: unexpected return value");
    ///     }
    ///     g_object_unref (value);
    /// }
    ///
    /// static void
    /// web_view_evaluate_promise (WebKitWebView *web_view)
    /// {
    ///     GVariantDict dict;
    ///     g_variant_dict_init (&dict, NULL);
    ///     g_variant_dict_insert (&dict, "count", "u", 42);
    ///     GVariant *args = g_variant_dict_end (&dict);
    ///     const gchar *body = "return new Promise((resolve) => { resolve(count); });";
    ///     webkit_web_view_call_async_javascript_function (web_view, body, -1, arguments, NULL, NULL, NULL, web_view_javascript_finished, NULL);
    /// }
    /// ```
    extern fn webkit_web_view_call_async_javascript_function(p_web_view: *WebView, p_body: [*:0]const u8, p_length: isize, p_arguments: ?*glib.Variant, p_world_name: ?[*:0]const u8, p_source_uri: ?[*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const callAsyncJavascriptFunction = webkit_web_view_call_async_javascript_function;

    /// Finish an asynchronous operation started with `webkit.WebView.callAsyncJavascriptFunction`.
    extern fn webkit_web_view_call_async_javascript_function_finish(p_web_view: *WebView, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*javascriptcore.Value;
    pub const callAsyncJavascriptFunctionFinish = webkit_web_view_call_async_javascript_function_finish;

    /// Asynchronously check if it is possible to execute the given editing command.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.WebView.canExecuteEditingCommandFinish` to get the result of the operation.
    extern fn webkit_web_view_can_execute_editing_command(p_web_view: *WebView, p_command: [*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const canExecuteEditingCommand = webkit_web_view_can_execute_editing_command;

    /// Finish an asynchronous operation started with `webkit.WebView.canExecuteEditingCommand`.
    extern fn webkit_web_view_can_execute_editing_command_finish(p_web_view: *WebView, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const canExecuteEditingCommandFinish = webkit_web_view_can_execute_editing_command_finish;

    /// Determines whether `web_view` has a previous history item.
    extern fn webkit_web_view_can_go_back(p_web_view: *WebView) c_int;
    pub const canGoBack = webkit_web_view_can_go_back;

    /// Determines whether `web_view` has a next history item.
    extern fn webkit_web_view_can_go_forward(p_web_view: *WebView) c_int;
    pub const canGoForward = webkit_web_view_can_go_forward;

    /// Whether or not a MIME type can be displayed in `web_view`.
    extern fn webkit_web_view_can_show_mime_type(p_web_view: *WebView, p_mime_type: [*:0]const u8) c_int;
    pub const canShowMimeType = webkit_web_view_can_show_mime_type;

    /// Requests downloading of the specified URI string for `web_view`.
    extern fn webkit_web_view_download_uri(p_web_view: *WebView, p_uri: [*:0]const u8) *webkit.Download;
    pub const downloadUri = webkit_web_view_download_uri;

    /// Asynchronously evaluate `script` in the script world with name `world_name` of the main frame current context in `web_view`.
    /// If `world_name` is `NULL`, the default world is used. Any value that is not `NULL` is a distinct world.
    /// The `source_uri` will be shown in exceptions and doesn't affect the behavior of the script.
    /// When not provided, the document URL is used.
    ///
    /// Note that if `webkit.Settings.properties.enable`-javascript is `FALSE`, this method will do nothing.
    /// If you want to use this method but still prevent web content from executing its own
    /// JavaScript, then use `webkit.Settings.properties.enable`-javascript-markup.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.WebView.evaluateJavascriptFinish` to get the result of the operation.
    ///
    /// This is an example of using `webkit.WebView.evaluateJavascript` with a script returning
    /// a string:
    ///
    /// ```c
    /// static void
    /// web_view_javascript_finished (GObject      *object,
    ///                               GAsyncResult *result,
    ///                               gpointer      user_data)
    /// {
    ///     JSCValue               *value;
    ///     GError                 *error = NULL;
    ///
    ///     value = webkit_web_view_evaluate_javascript_finish (WEBKIT_WEB_VIEW (object), result, &error);
    ///     if (!value) {
    ///         g_warning ("Error running javascript: `s`", error->message);
    ///         g_error_free (error);
    ///         return;
    ///     }
    ///
    ///     if (jsc_value_is_string (value)) {
    ///         gchar        *str_value = jsc_value_to_string (value);
    ///         JSCException *exception = jsc_context_get_exception (jsc_value_get_context (value));
    ///         if (exception)
    ///             g_warning ("Error running javascript: `s`", jsc_exception_get_message (exception));
    ///         else
    ///             g_print ("Script result: `s`\n", str_value);
    ///         g_free (str_value);
    ///     } else {
    ///         g_warning ("Error running javascript: unexpected return value");
    ///     }
    ///     g_object_unref (value);
    /// }
    ///
    /// static void
    /// web_view_get_link_url (WebKitWebView *web_view,
    ///                        const gchar   *link_id)
    /// {
    ///     gchar *script = g_strdup_printf ("window.document.getElementById('`s`').href;", link_id);
    ///     webkit_web_view_evaluate_javascript (web_view, script, -1, NULL, NULL, NULL, web_view_javascript_finished, NULL);
    ///     g_free (script);
    /// }
    /// ```
    extern fn webkit_web_view_evaluate_javascript(p_web_view: *WebView, p_script: [*:0]const u8, p_length: isize, p_world_name: ?[*:0]const u8, p_source_uri: ?[*:0]const u8, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const evaluateJavascript = webkit_web_view_evaluate_javascript;

    /// Finish an asynchronous operation started with `webkit.WebView.evaluateJavascript`.
    extern fn webkit_web_view_evaluate_javascript_finish(p_web_view: *WebView, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*javascriptcore.Value;
    pub const evaluateJavascriptFinish = webkit_web_view_evaluate_javascript_finish;

    /// Request to execute the given `command` for `web_view`.
    ///
    /// You can use `webkit.WebView.canExecuteEditingCommand` to check whether
    /// it's possible to execute the command.
    extern fn webkit_web_view_execute_editing_command(p_web_view: *WebView, p_command: [*:0]const u8) void;
    pub const executeEditingCommand = webkit_web_view_execute_editing_command;

    /// Request to execute the given `command` with `argument` for `web_view`.
    ///
    /// You can use
    /// `webkit.WebView.canExecuteEditingCommand` to check whether
    /// it's possible to execute the command.
    extern fn webkit_web_view_execute_editing_command_with_argument(p_web_view: *WebView, p_command: [*:0]const u8, p_argument: [*:0]const u8) void;
    pub const executeEditingCommandWithArgument = webkit_web_view_execute_editing_command_with_argument;

    /// Get the presentation type of `webkit.WebView` when created for automation.
    extern fn webkit_web_view_get_automation_presentation_type(p_web_view: *WebView) webkit.AutomationBrowsingContextPresentation;
    pub const getAutomationPresentationType = webkit_web_view_get_automation_presentation_type;

    /// Obtains the `webkit.BackForwardList` associated with the given `webkit.WebView`.
    ///
    /// The `webkit.BackForwardList` is owned by the `webkit.WebView`.
    extern fn webkit_web_view_get_back_forward_list(p_web_view: *WebView) *webkit.BackForwardList;
    pub const getBackForwardList = webkit_web_view_get_back_forward_list;

    /// Gets the color that is used to draw the `web_view` background.
    ///
    /// Gets the color that is used to draw the `web_view` background before
    /// the actual contents are rendered.
    /// For more information see also `webkit.WebView.setBackgroundColor`
    extern fn webkit_web_view_get_background_color(p_web_view: *WebView, p_rgba: *gdk.RGBA) void;
    pub const getBackgroundColor = webkit_web_view_get_background_color;

    /// Get the camera capture state of a `webkit.WebView`.
    extern fn webkit_web_view_get_camera_capture_state(p_web_view: *WebView) webkit.MediaCaptureState;
    pub const getCameraCaptureState = webkit_web_view_get_camera_capture_state;

    /// Gets the web context of `web_view`.
    extern fn webkit_web_view_get_context(p_web_view: *WebView) *webkit.WebContext;
    pub const getContext = webkit_web_view_get_context;

    /// Returns the current custom character encoding name of `web_view`.
    extern fn webkit_web_view_get_custom_charset(p_web_view: *WebView) [*:0]const u8;
    pub const getCustomCharset = webkit_web_view_get_custom_charset;

    /// Gets the configured default Content-Security-Policy.
    extern fn webkit_web_view_get_default_content_security_policy(p_web_view: *WebView) ?[*:0]const u8;
    pub const getDefaultContentSecurityPolicy = webkit_web_view_get_default_content_security_policy;

    /// Get the display capture state of a `webkit.WebView`.
    extern fn webkit_web_view_get_display_capture_state(p_web_view: *WebView) webkit.MediaCaptureState;
    pub const getDisplayCaptureState = webkit_web_view_get_display_capture_state;

    /// Gets the web editor state of `web_view`.
    extern fn webkit_web_view_get_editor_state(p_web_view: *WebView) *webkit.EditorState;
    pub const getEditorState = webkit_web_view_get_editor_state;

    /// Gets the value of the `webkit.WebView.properties.estimated`-load-progress property.
    ///
    /// You can monitor the estimated progress of a load operation by
    /// connecting to the notify::estimated-load-progress signal of `web_view`.
    extern fn webkit_web_view_get_estimated_load_progress(p_web_view: *WebView) f64;
    pub const getEstimatedLoadProgress = webkit_web_view_get_estimated_load_progress;

    /// Returns favicon currently associated to `web_view`.
    ///
    /// Returns favicon currently associated to `web_view`, if any. You can
    /// connect to notify::favicon signal of `web_view` to be notified when
    /// the favicon is available.
    extern fn webkit_web_view_get_favicon(p_web_view: *WebView) *gdk.Texture;
    pub const getFavicon = webkit_web_view_get_favicon;

    /// Gets the `webkit.FindController`.
    ///
    /// Gets the `webkit.FindController` that will allow the caller to query
    /// the `webkit.WebView` for the text to look for.
    extern fn webkit_web_view_get_find_controller(p_web_view: *WebView) *webkit.FindController;
    pub const getFindController = webkit_web_view_get_find_controller;

    /// Get the `webkit.InputMethodContext` currently in use by `web_view`.
    ///
    /// Get the `webkit.InputMethodContext` currently in use by `web_view`, or `NULL` if no input method is being used.
    extern fn webkit_web_view_get_input_method_context(p_web_view: *WebView) ?*webkit.InputMethodContext;
    pub const getInputMethodContext = webkit_web_view_get_input_method_context;

    /// Get the `webkit.WebInspector` associated to `web_view`
    extern fn webkit_web_view_get_inspector(p_web_view: *WebView) *webkit.WebInspector;
    pub const getInspector = webkit_web_view_get_inspector;

    /// Gets the mute state of `web_view`.
    extern fn webkit_web_view_get_is_muted(p_web_view: *WebView) c_int;
    pub const getIsMuted = webkit_web_view_get_is_muted;

    /// Get whether the current web process of a `webkit.WebView` is responsive.
    extern fn webkit_web_view_get_is_web_process_responsive(p_web_view: *WebView) c_int;
    pub const getIsWebProcessResponsive = webkit_web_view_get_is_web_process_responsive;

    /// Return the main resource of `web_view`.
    extern fn webkit_web_view_get_main_resource(p_web_view: *WebView) *webkit.WebResource;
    pub const getMainResource = webkit_web_view_get_main_resource;

    /// Get the microphone capture state of a `webkit.WebView`.
    extern fn webkit_web_view_get_microphone_capture_state(p_web_view: *WebView) webkit.MediaCaptureState;
    pub const getMicrophoneCaptureState = webkit_web_view_get_microphone_capture_state;

    /// Get the `webkit.NetworkSession` associated to `web_view`.
    extern fn webkit_web_view_get_network_session(p_web_view: *WebView) *webkit.NetworkSession;
    pub const getNetworkSession = webkit_web_view_get_network_session;

    /// Get the identifier of the `WebKitWebPage` corresponding to
    /// the `webkit.WebView`
    extern fn webkit_web_view_get_page_id(p_web_view: *WebView) u64;
    pub const getPageId = webkit_web_view_get_page_id;

    /// Gets the current session state of `web_view`
    extern fn webkit_web_view_get_session_state(p_web_view: *WebView) *webkit.WebViewSessionState;
    pub const getSessionState = webkit_web_view_get_session_state;

    /// Gets the `webkit.Settings` currently applied to `web_view`.
    ///
    /// If no other `webkit.Settings` have been explicitly applied to
    /// `web_view` with `webkit.WebView.setSettings`, the default
    /// `webkit.Settings` will be returned. This method always returns
    /// a valid `webkit.Settings` object.
    /// To modify any of the `web_view` settings, you can either create
    /// a new `webkit.Settings` object with `webkit.Settings.new`, setting
    /// the desired preferences, and then replace the existing `web_view`
    /// settings with `webkit.WebView.setSettings` or get the existing
    /// `web_view` settings and update it directly. `webkit.Settings` objects
    /// can be shared by multiple `webkit.WebView`<!-- -->s, so modifying
    /// the settings of a `webkit.WebView` would affect other
    /// `webkit.WebView`<!-- -->s using the same `webkit.Settings`.
    extern fn webkit_web_view_get_settings(p_web_view: *WebView) *webkit.Settings;
    pub const getSettings = webkit_web_view_get_settings;

    /// Asynchronously retrieves a snapshot of `web_view` for `region`.
    ///
    /// `options` specifies how the snapshot should be rendered.
    ///
    /// When the operation is finished, `callback` will be called. You must
    /// call `webkit.WebView.getSnapshotFinish` to get the result of the
    /// operation.
    extern fn webkit_web_view_get_snapshot(p_web_view: *WebView, p_region: webkit.SnapshotRegion, p_options: webkit.SnapshotOptions, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const getSnapshot = webkit_web_view_get_snapshot;

    /// Finishes an asynchronous operation started with `webkit.WebView.getSnapshot`.
    extern fn webkit_web_view_get_snapshot_finish(p_web_view: *WebView, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*gdk.Texture;
    pub const getSnapshotFinish = webkit_web_view_get_snapshot_finish;

    /// Gets the value of the `webkit.WebView.properties.title` property.
    ///
    /// You can connect to notify::title signal of `web_view` to
    /// be notified when the title has been received.
    extern fn webkit_web_view_get_title(p_web_view: *WebView) [*:0]const u8;
    pub const getTitle = webkit_web_view_get_title;

    /// Retrieves the `gio.TlsCertificate` associated with the main resource of `web_view`.
    ///
    /// Retrieves the `gio.TlsCertificate` associated with the main resource of `web_view`,
    /// and the `gio.TlsCertificateFlags` showing what problems, if any, have been found
    /// with that certificate.
    /// If the connection is not HTTPS, this function returns `FALSE`.
    /// This function should be called after a response has been received from the
    /// server, so you can connect to `webkit.WebView.signals.load`-changed and call this function
    /// when it's emitted with `WEBKIT_LOAD_COMMITTED` event.
    ///
    /// Note that this function provides no information about the security of the web
    /// page if the current `webkit.TLSErrorsPolicy` is `WEBKIT_TLS_ERRORS_POLICY_IGNORE`,
    /// as subresources of the page may be controlled by an attacker. This function
    /// may safely be used to determine the security status of the current page only
    /// if the current `webkit.TLSErrorsPolicy` is `WEBKIT_TLS_ERRORS_POLICY_FAIL`, in
    /// which case subresources that fail certificate verification will be blocked.
    extern fn webkit_web_view_get_tls_info(p_web_view: *WebView, p_certificate: **gio.TlsCertificate, p_errors: *gio.TlsCertificateFlags) c_int;
    pub const getTlsInfo = webkit_web_view_get_tls_info;

    /// Returns the current active URI of `web_view`.
    ///
    /// The active URI might change during
    /// a load operation:
    ///
    /// <orderedlist>
    /// <listitem><para>
    ///   When nothing has been loaded yet on `web_view` the active URI is `NULL`.
    /// </para></listitem>
    /// <listitem><para>
    ///   When a new load operation starts the active URI is the requested URI:
    ///   <itemizedlist>
    ///   <listitem><para>
    ///     If the load operation was started by `webkit.WebView.loadUri`,
    ///     the requested URI is the given one.
    ///   </para></listitem>
    ///   <listitem><para>
    ///     If the load operation was started by `webkit.WebView.loadHtml`,
    ///     the requested URI is "about:blank".
    ///   </para></listitem>
    ///   <listitem><para>
    ///     If the load operation was started by `webkit.WebView.loadAlternateHtml`,
    ///     the requested URI is content URI provided.
    ///   </para></listitem>
    ///   <listitem><para>
    ///     If the load operation was started by `webkit.WebView.goBack` or
    ///     `webkit.WebView.goForward`, the requested URI is the original URI
    ///     of the previous/next item in the `webkit.BackForwardList` of `web_view`.
    ///   </para></listitem>
    ///   <listitem><para>
    ///     If the load operation was started by
    ///     `webkit.WebView.goToBackForwardListItem`, the requested URI
    ///     is the opriginal URI of the given `webkit.BackForwardListItem`.
    ///   </para></listitem>
    ///   </itemizedlist>
    /// </para></listitem>
    /// <listitem><para>
    ///   If there is a server redirection during the load operation,
    ///   the active URI is the redirected URI. When the signal
    ///   `webkit.WebView.signals.load`-changed is emitted with `WEBKIT_LOAD_REDIRECTED`
    ///   event, the active URI is already updated to the redirected URI.
    /// </para></listitem>
    /// <listitem><para>
    ///   When the signal `webkit.WebView.signals.load`-changed is emitted
    ///   with `WEBKIT_LOAD_COMMITTED` event, the active URI is the final
    ///   one and it will not change unless a new load operation is started
    ///   or a navigation action within the same page is performed.
    /// </para></listitem>
    /// </orderedlist>
    ///
    /// You can monitor the active URI by connecting to the notify::uri
    /// signal of `web_view`.
    extern fn webkit_web_view_get_uri(p_web_view: *WebView) [*:0]const u8;
    pub const getUri = webkit_web_view_get_uri;

    /// Gets the user content manager associated to `web_view`.
    extern fn webkit_web_view_get_user_content_manager(p_web_view: *WebView) *webkit.UserContentManager;
    pub const getUserContentManager = webkit_web_view_get_user_content_manager;

    /// Get the view's `webkit.WebExtensionMode`.
    extern fn webkit_web_view_get_web_extension_mode(p_web_view: *WebView) webkit.WebExtensionMode;
    pub const getWebExtensionMode = webkit_web_view_get_web_extension_mode;

    /// Gets the default website policies.
    ///
    /// Gets the default website policies set on construction in the
    /// `web_view`. These can be overridden on a per-origin basis via the
    /// `webkit.WebView.signals.decide`-policy signal handler.
    ///
    /// See also `webkit.PolicyDecision.useWithPolicies`.
    extern fn webkit_web_view_get_website_policies(p_web_view: *WebView) *webkit.WebsitePolicies;
    pub const getWebsitePolicies = webkit_web_view_get_website_policies;

    /// Get the `webkit.WindowProperties` object.
    ///
    /// Get the `webkit.WindowProperties` object containing the properties
    /// that the window containing `web_view` should have.
    extern fn webkit_web_view_get_window_properties(p_web_view: *WebView) *webkit.WindowProperties;
    pub const getWindowProperties = webkit_web_view_get_window_properties;

    /// Set the zoom level of `web_view`.
    ///
    /// Get the zoom level of `web_view`, i.e. the factor by which the
    /// view contents are scaled with respect to their original size.
    extern fn webkit_web_view_get_zoom_level(p_web_view: *WebView) f64;
    pub const getZoomLevel = webkit_web_view_get_zoom_level;

    /// Loads the previous history item.
    ///
    /// You can monitor the load operation by connecting to
    /// `webkit.WebView.signals.load`-changed signal.
    extern fn webkit_web_view_go_back(p_web_view: *WebView) void;
    pub const goBack = webkit_web_view_go_back;

    /// Loads the next history item.
    ///
    /// You can monitor the load operation by connecting to
    /// `webkit.WebView.signals.load`-changed signal.
    extern fn webkit_web_view_go_forward(p_web_view: *WebView) void;
    pub const goForward = webkit_web_view_go_forward;

    /// Loads the specific history item `list_item`.
    ///
    /// You can monitor the load operation by connecting to
    /// `webkit.WebView.signals.load`-changed signal.
    extern fn webkit_web_view_go_to_back_forward_list_item(p_web_view: *WebView, p_list_item: *webkit.BackForwardListItem) void;
    pub const goToBackForwardListItem = webkit_web_view_go_to_back_forward_list_item;

    /// Get whether a `webkit.WebView` was created with `webkit.WebView.properties.is`-controlled-by-automation
    /// property enabled.
    ///
    /// Only `webkit.WebView`<!-- -->s controlled by automation can be used in an
    /// automation session.
    extern fn webkit_web_view_is_controlled_by_automation(p_web_view: *WebView) c_int;
    pub const isControlledByAutomation = webkit_web_view_is_controlled_by_automation;

    /// Gets whether the user is allowed to edit the HTML document.
    ///
    /// When `web_view` is not editable an element in the HTML document can only be edited if the
    /// CONTENTEDITABLE attribute has been set on the element or one of its parent
    /// elements. By default a `webkit.WebView` is not editable.
    extern fn webkit_web_view_is_editable(p_web_view: *WebView) c_int;
    pub const isEditable = webkit_web_view_is_editable;

    /// Gets the value of the `webkit.WebView.properties.is`-loading property.
    ///
    /// You can monitor when a `webkit.WebView` is loading a page by connecting to
    /// notify::is-loading signal of `web_view`. This is useful when you are
    /// interesting in knowing when the view is loading something but not in the
    /// details about the status of the load operation, for example to start a spinner
    /// when the view is loading a page and stop it when it finishes.
    extern fn webkit_web_view_is_loading(p_web_view: *WebView) c_int;
    pub const isLoading = webkit_web_view_is_loading;

    /// Gets the value of the `webkit.WebView.properties.is`-playing-audio property.
    ///
    /// You can monitor when a page in a `webkit.WebView` is playing audio by
    /// connecting to the notify::is-playing-audio signal of `web_view`. This
    /// is useful when the application wants to provide visual feedback when a
    /// page is producing sound.
    extern fn webkit_web_view_is_playing_audio(p_web_view: *WebView) c_int;
    pub const isPlayingAudio = webkit_web_view_is_playing_audio;

    /// Load the given `content` string for the URI `content_uri`.
    ///
    /// This allows clients to display page-loading errors in the `webkit.WebView` itself.
    /// When this method is called from `webkit.WebView.signals.load`-failed signal to show an
    /// error page, then the back-forward list is maintained appropriately.
    /// For everything else this method works the same way as `webkit.WebView.loadHtml`.
    extern fn webkit_web_view_load_alternate_html(p_web_view: *WebView, p_content: [*:0]const u8, p_content_uri: [*:0]const u8, p_base_uri: ?[*:0]const u8) void;
    pub const loadAlternateHtml = webkit_web_view_load_alternate_html;

    /// Load the specified `bytes` into `web_view` using the given `mime_type` and `encoding`.
    ///
    /// When `mime_type` is `NULL`, it defaults to "text/html".
    /// When `encoding` is `NULL`, it defaults to "UTF-8".
    /// When `base_uri` is `NULL`, it defaults to "about:blank".
    /// You can monitor the load operation by connecting to `webkit.WebView.signals.load`-changed signal.
    extern fn webkit_web_view_load_bytes(p_web_view: *WebView, p_bytes: *glib.Bytes, p_mime_type: ?[*:0]const u8, p_encoding: ?[*:0]const u8, p_base_uri: ?[*:0]const u8) void;
    pub const loadBytes = webkit_web_view_load_bytes;

    /// Load the given `content` string with the specified `base_uri`.
    ///
    /// If `base_uri` is not `NULL`, relative URLs in the `content` will be
    /// resolved against `base_uri` and absolute local paths must be children of the `base_uri`.
    /// For security reasons absolute local paths that are not children of `base_uri`
    /// will cause the web process to terminate.
    /// If you need to include URLs in `content` that are local paths in a different
    /// directory than `base_uri` you can build a data URI for them. When `base_uri` is `NULL`,
    /// it defaults to "about:blank". The mime type of the document will be "text/html".
    /// You can monitor the load operation by connecting to `webkit.WebView.signals.load`-changed signal.
    extern fn webkit_web_view_load_html(p_web_view: *WebView, p_content: [*:0]const u8, p_base_uri: ?[*:0]const u8) void;
    pub const loadHtml = webkit_web_view_load_html;

    /// Load the specified `plain_text` string into `web_view`.
    ///
    /// The mime type of document will be "text/plain". You can monitor the load
    /// operation by connecting to `webkit.WebView.signals.load`-changed signal.
    extern fn webkit_web_view_load_plain_text(p_web_view: *WebView, p_plain_text: [*:0]const u8) void;
    pub const loadPlainText = webkit_web_view_load_plain_text;

    /// Requests loading of the specified `webkit.URIRequest`.
    ///
    /// You can monitor the load operation by connecting to
    /// `webkit.WebView.signals.load`-changed signal.
    extern fn webkit_web_view_load_request(p_web_view: *WebView, p_request: *webkit.URIRequest) void;
    pub const loadRequest = webkit_web_view_load_request;

    /// Requests loading of the specified URI string.
    ///
    /// You can monitor the load operation by connecting to
    /// `webkit.WebView.signals.load`-changed signal.
    extern fn webkit_web_view_load_uri(p_web_view: *WebView, p_uri: [*:0]const u8) void;
    pub const loadUri = webkit_web_view_load_uri;

    /// Reloads the current contents of `web_view`.
    ///
    /// See also `webkit.WebView.reloadBypassCache`.
    extern fn webkit_web_view_reload(p_web_view: *WebView) void;
    pub const reload = webkit_web_view_reload;

    /// Reloads the current contents of `web_view` without
    /// using any cached data.
    extern fn webkit_web_view_reload_bypass_cache(p_web_view: *WebView) void;
    pub const reloadBypassCache = webkit_web_view_reload_bypass_cache;

    /// Restore the `web_view` session state from `state`
    extern fn webkit_web_view_restore_session_state(p_web_view: *WebView, p_state: *webkit.WebViewSessionState) void;
    pub const restoreSessionState = webkit_web_view_restore_session_state;

    /// Asynchronously save the current web page.
    ///
    /// Asynchronously save the current web page associated to the
    /// `webkit.WebView` into a self-contained format using the mode
    /// specified in `save_mode`.
    ///
    /// When the operation is finished, `callback` will be called. You can
    /// then call `webkit.WebView.saveFinish` to get the result of the
    /// operation.
    extern fn webkit_web_view_save(p_web_view: *WebView, p_save_mode: webkit.SaveMode, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const save = webkit_web_view_save;

    /// Finish an asynchronous operation started with `webkit.WebView.save`.
    extern fn webkit_web_view_save_finish(p_web_view: *WebView, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*gio.InputStream;
    pub const saveFinish = webkit_web_view_save_finish;

    /// Asynchronously save the current web page.
    ///
    /// Asynchronously save the current web page associated to the
    /// `webkit.WebView` into a self-contained format using the mode
    /// specified in `save_mode` and writing it to `file`.
    ///
    /// When the operation is finished, `callback` will be called. You can
    /// then call `webkit.WebView.saveToFileFinish` to get the result of the
    /// operation.
    extern fn webkit_web_view_save_to_file(p_web_view: *WebView, p_file: *gio.File, p_save_mode: webkit.SaveMode, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const saveToFile = webkit_web_view_save_to_file;

    /// Finish an asynchronous operation started with `webkit.WebView.saveToFile`.
    extern fn webkit_web_view_save_to_file_finish(p_web_view: *WebView, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const saveToFileFinish = webkit_web_view_save_to_file_finish;

    /// Send `message` to the `WebKitWebPage` corresponding to `web_view`.
    ///
    /// If `message` is floating, it's consumed.
    /// If you don't expect any reply, or you simply want to ignore it, you can pass `NULL` as `callback`.
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.WebView.sendMessageToPageFinish` to get the message reply.
    extern fn webkit_web_view_send_message_to_page(p_web_view: *WebView, p_message: *webkit.UserMessage, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const sendMessageToPage = webkit_web_view_send_message_to_page;

    /// Finish an asynchronous operation started with `webkit.WebView.sendMessageToPage`.
    extern fn webkit_web_view_send_message_to_page_finish(p_web_view: *WebView, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*webkit.UserMessage;
    pub const sendMessageToPageFinish = webkit_web_view_send_message_to_page_finish;

    /// Sets the color that will be used to draw the `web_view` background.
    ///
    /// Sets the color that will be used to draw the `web_view` background before
    /// the actual contents are rendered. Note that if the web page loaded in `web_view`
    /// specifies a background color, it will take precedence over the `rgba` color.
    /// By default the `web_view` background color is opaque white.
    extern fn webkit_web_view_set_background_color(p_web_view: *WebView, p_rgba: *const gdk.RGBA) void;
    pub const setBackgroundColor = webkit_web_view_set_background_color;

    /// Set the camera capture state of a `webkit.WebView`.
    ///
    /// If `webkit.Settings.properties.enable`-mediastream is `FALSE`, this method will have no visible effect. Once the
    /// state of the device has been set to `WEBKIT_MEDIA_CAPTURE_STATE_NONE` it cannot be changed
    /// anymore. The page can however request capture again using the mediaDevices API.
    extern fn webkit_web_view_set_camera_capture_state(p_web_view: *WebView, p_state: webkit.MediaCaptureState) void;
    pub const setCameraCaptureState = webkit_web_view_set_camera_capture_state;

    /// Sets the `allowlist` for CORS.
    ///
    /// Sets the `allowlist` for which
    /// [Cross-Origin Resource Sharing](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)
    /// checks are disabled in `web_view`. URI patterns must be of the form
    /// `[protocol]://[host]/[path]`, each component may contain the wildcard
    /// character (`*`) to represent zero or more other characters. All three
    /// components are required and must not be omitted from the URI
    /// patterns.
    ///
    /// Disabling CORS checks permits resources from other origins to load
    /// allowlisted resources. It does not permit the allowlisted resources
    /// to load resources from other origins.
    ///
    /// If this function is called multiple times, only the allowlist set by
    /// the most recent call will be effective.
    extern fn webkit_web_view_set_cors_allowlist(p_web_view: *WebView, p_allowlist: ?[*]const [*:0]const u8) void;
    pub const setCorsAllowlist = webkit_web_view_set_cors_allowlist;

    /// Sets the current custom character encoding override of `web_view`.
    ///
    /// The custom character encoding will override any text encoding detected via HTTP headers or
    /// META tags. Calling this method will stop any current load operation and reload the
    /// current page. Setting the custom character encoding to `NULL` removes the character
    /// encoding override.
    extern fn webkit_web_view_set_custom_charset(p_web_view: *WebView, p_charset: ?[*:0]const u8) void;
    pub const setCustomCharset = webkit_web_view_set_custom_charset;

    /// Set the display capture state of a `webkit.WebView`.
    ///
    /// If `webkit.Settings.properties.enable`-mediastream is `FALSE`, this method will have no visible effect. Once the
    /// state of the device has been set to `WEBKIT_MEDIA_CAPTURE_STATE_NONE` it cannot be changed
    /// anymore. The page can however request capture again using the mediaDevices API.
    extern fn webkit_web_view_set_display_capture_state(p_web_view: *WebView, p_state: webkit.MediaCaptureState) void;
    pub const setDisplayCaptureState = webkit_web_view_set_display_capture_state;

    /// Sets whether the user is allowed to edit the HTML document.
    ///
    /// If `editable` is `TRUE`, `web_view` allows the user to edit the HTML document. If
    /// `editable` is `FALSE`, an element in `web_view`'s document can only be edited if the
    /// CONTENTEDITABLE attribute has been set on the element or one of its parent
    /// elements. By default a `webkit.WebView` is not editable.
    ///
    /// Normally, a HTML document is not editable unless the elements within the
    /// document are editable. This function provides a way to make the contents
    /// of a `webkit.WebView` editable without altering the document or DOM structure.
    extern fn webkit_web_view_set_editable(p_web_view: *WebView, p_editable: c_int) void;
    pub const setEditable = webkit_web_view_set_editable;

    /// Set the `webkit.InputMethodContext` to be used by `web_view`.
    ///
    /// Set the `webkit.InputMethodContext` to be used by `web_view`, or `NULL` to not use any input method.
    /// Note that the same `webkit.InputMethodContext` can't be set on more than one `webkit.WebView` at the same time.
    extern fn webkit_web_view_set_input_method_context(p_web_view: *WebView, p_context: ?*webkit.InputMethodContext) void;
    pub const setInputMethodContext = webkit_web_view_set_input_method_context;

    /// Sets the mute state of `web_view`.
    extern fn webkit_web_view_set_is_muted(p_web_view: *WebView, p_muted: c_int) void;
    pub const setIsMuted = webkit_web_view_set_is_muted;

    /// Set the microphone capture state of a `webkit.WebView`.
    ///
    /// If `webkit.Settings.properties.enable`-mediastream is `FALSE`, this method will have no visible effect. Once the
    /// state of the device has been set to `WEBKIT_MEDIA_CAPTURE_STATE_NONE` it cannot be changed
    /// anymore. The page can however request capture again using the mediaDevices API.
    extern fn webkit_web_view_set_microphone_capture_state(p_web_view: *WebView, p_state: webkit.MediaCaptureState) void;
    pub const setMicrophoneCaptureState = webkit_web_view_set_microphone_capture_state;

    /// Sets the `webkit.Settings` to be applied to `web_view`.
    ///
    /// The
    /// existing `webkit.Settings` of `web_view` will be replaced by
    /// `settings`. New settings are applied immediately on `web_view`.
    /// The same `webkit.Settings` object can be shared
    /// by multiple `webkit.WebView`<!-- -->s.
    extern fn webkit_web_view_set_settings(p_web_view: *WebView, p_settings: *webkit.Settings) void;
    pub const setSettings = webkit_web_view_set_settings;

    /// Set the zoom level of `web_view`.
    ///
    /// Set the zoom level of `web_view`, i.e. the factor by which the
    /// view contents are scaled with respect to their original size.
    extern fn webkit_web_view_set_zoom_level(p_web_view: *WebView, p_zoom_level: f64) void;
    pub const setZoomLevel = webkit_web_view_set_zoom_level;

    /// Stops any ongoing loading operation in `web_view`.
    ///
    /// This method does nothing if no content is being loaded.
    /// If there is a loading operation in progress, it will be cancelled and
    /// `webkit.WebView.signals.load`-failed signal will be emitted with
    /// `WEBKIT_NETWORK_ERROR_CANCELLED` error.
    extern fn webkit_web_view_stop_loading(p_web_view: *WebView) void;
    pub const stopLoading = webkit_web_view_stop_loading;

    /// Terminates the web process associated to `web_view`.
    ///
    /// When the web process gets terminated
    /// using this method, the `webkit.WebView.signals.web`-process-terminated signal is emitted with
    /// `WEBKIT_WEB_PROCESS_TERMINATED_BY_API` as the reason for termination.
    extern fn webkit_web_view_terminate_web_process(p_web_view: *WebView) void;
    pub const terminateWebProcess = webkit_web_view_terminate_web_process;

    /// Tries to close the `web_view`.
    ///
    /// This will fire the onbeforeunload event
    /// to ask the user for confirmation to close the page. If there isn't an
    /// onbeforeunload event handler or the user confirms to close the page,
    /// the `webkit.WebView.signals.close` signal is emitted, otherwise nothing happens.
    extern fn webkit_web_view_try_close(p_web_view: *WebView) void;
    pub const tryClose = webkit_web_view_try_close;

    extern fn webkit_web_view_get_type() usize;
    pub const getGObjectType = webkit_web_view_get_type;

    extern fn g_object_ref(p_self: *webkit.WebView) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.WebView) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebView, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebViewBase = extern struct {
    pub const Parent = gtk.Widget;
    pub const Implements = [_]type{ gtk.Accessible, gtk.Buildable, gtk.ConstraintTarget };
    pub const Class = webkit.WebViewBaseClass;
    f_parent_instance: gtk.Widget,
    f_priv: ?*webkit.WebViewBasePrivate,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn webkit_web_view_base_get_type() usize;
    pub const getGObjectType = webkit_web_view_base_get_type;

    extern fn g_object_ref(p_self: *webkit.WebViewBase) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.WebViewBase) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebViewBase, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A permission request for accessing website data from third-party domains.
///
/// WebKitWebsiteDataAccessPermissionRequest represents a request for
/// permission to allow a third-party domain access its cookies.
///
/// When a WebKitWebsiteDataAccessPermissionRequest is not handled by the user,
/// it is denied by default.
pub const WebsiteDataAccessPermissionRequest = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{webkit.PermissionRequest};
    pub const Class = webkit.WebsiteDataAccessPermissionRequestClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Get the current domain being browsed.
    extern fn webkit_website_data_access_permission_request_get_current_domain(p_request: *WebsiteDataAccessPermissionRequest) [*:0]const u8;
    pub const getCurrentDomain = webkit_website_data_access_permission_request_get_current_domain;

    /// Get the domain requesting permission to access its cookies while browsing the current domain.
    extern fn webkit_website_data_access_permission_request_get_requesting_domain(p_request: *WebsiteDataAccessPermissionRequest) [*:0]const u8;
    pub const getRequestingDomain = webkit_website_data_access_permission_request_get_requesting_domain;

    extern fn webkit_website_data_access_permission_request_get_type() usize;
    pub const getGObjectType = webkit_website_data_access_permission_request_get_type;

    extern fn g_object_ref(p_self: *webkit.WebsiteDataAccessPermissionRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.WebsiteDataAccessPermissionRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebsiteDataAccessPermissionRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Manages data stored locally by web sites.
///
/// You can use WebKitWebsiteDataManager to configure the local directories
/// where website data will be stored. Use `webkit.WebsiteDataManager.properties.base`-data-directory
/// and `webkit.WebsiteDataManager.properties.base`-cache-directory set a common base directory for all
/// website data and caches.
///
/// A WebKitWebsiteDataManager can be ephemeral, in which case all the directory configuration
/// is not needed because website data will never persist. You can create an ephemeral WebKitWebsiteDataManager
/// with `webkit_website_data_manager_new_ephemeral`.
///
/// WebKitWebsiteDataManager can also be used to fetch website data, remove data
/// stored by particular websites, or clear data for all websites modified since a given
/// period of time.
pub const WebsiteDataManager = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.WebsiteDataManagerClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The base directory for caches. If `NULL`, a default location will be used.
        pub const base_cache_directory = struct {
            pub const name = "base-cache-directory";

            pub const Type = ?[*:0]u8;
        };

        /// The base directory for website data. If `NULL`, a default location will be used.
        pub const base_data_directory = struct {
            pub const name = "base-data-directory";

            pub const Type = ?[*:0]u8;
        };

        /// Whether the `webkit.WebsiteDataManager` is ephemeral. An ephemeral `webkit.WebsiteDataManager`
        /// handles all websites data as non-persistent, and nothing will be written to the client
        /// storage. Note that if you create an ephemeral `webkit.WebsiteDataManager` all other construction
        /// parameters to configure data directories will be ignored.
        pub const is_ephemeral = struct {
            pub const name = "is-ephemeral";

            pub const Type = c_int;
        };

        /// The percentage of volume space that can be used for data storage for every domain.
        /// If the maximum storage is reached the storage request will fail with a QuotaExceededError exception.
        /// A value of 0.0 means that data storage is not allowed. A value of -1.0, which is the default,
        /// means WebKit will use the default quota (1 GiB).
        pub const origin_storage_ratio = struct {
            pub const name = "origin-storage-ratio";

            pub const Type = f64;
        };

        /// The percentage of volume space that can be used for data storage for all domains.
        /// If the maximum storage is reached the eviction will happen.
        /// A value of 0.0 means that data storage is not allowed. A value of -1.0, which is the default,
        /// means there's no limit for the total storage.
        pub const total_storage_ratio = struct {
            pub const name = "total-storage-ratio";

            pub const Type = f64;
        };
    };

    pub const signals = struct {};

    /// Asynchronously clear the website data of the given `types` modified in the past `timespan`.
    ///
    /// If `timespan` is 0, all website data will be removed.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.WebsiteDataManager.clearFinish` to get the result of the operation.
    ///
    /// Due to implementation limitations, this function does not currently delete
    /// any stored cookies if `timespan` is nonzero. This behavior may change in the
    /// future.
    extern fn webkit_website_data_manager_clear(p_manager: *WebsiteDataManager, p_types: webkit.WebsiteDataTypes, p_timespan: glib.TimeSpan, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const clear = webkit_website_data_manager_clear;

    /// Finish an asynchronous operation started with `webkit.WebsiteDataManager.clear`
    extern fn webkit_website_data_manager_clear_finish(p_manager: *WebsiteDataManager, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const clearFinish = webkit_website_data_manager_clear_finish;

    /// Asynchronously get the list of `webkit.WebsiteData` for the given `types`.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.WebsiteDataManager.fetchFinish` to get the result of the operation.
    extern fn webkit_website_data_manager_fetch(p_manager: *WebsiteDataManager, p_types: webkit.WebsiteDataTypes, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const fetch = webkit_website_data_manager_fetch;

    /// Finish an asynchronous operation started with `webkit.WebsiteDataManager.fetch`.
    extern fn webkit_website_data_manager_fetch_finish(p_manager: *WebsiteDataManager, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*glib.List;
    pub const fetchFinish = webkit_website_data_manager_fetch_finish;

    /// Get the `webkit.WebsiteDataManager.properties.base`-cache-directory property.
    extern fn webkit_website_data_manager_get_base_cache_directory(p_manager: *WebsiteDataManager) ?[*:0]const u8;
    pub const getBaseCacheDirectory = webkit_website_data_manager_get_base_cache_directory;

    /// Get the `webkit.WebsiteDataManager.properties.base`-data-directory property.
    extern fn webkit_website_data_manager_get_base_data_directory(p_manager: *WebsiteDataManager) ?[*:0]const u8;
    pub const getBaseDataDirectory = webkit_website_data_manager_get_base_data_directory;

    /// Get the `webkit.FaviconDatabase` of `manager`.
    extern fn webkit_website_data_manager_get_favicon_database(p_manager: *WebsiteDataManager) ?*webkit.FaviconDatabase;
    pub const getFaviconDatabase = webkit_website_data_manager_get_favicon_database;

    /// Get whether website icons are enabled.
    extern fn webkit_website_data_manager_get_favicons_enabled(p_manager: *WebsiteDataManager) c_int;
    pub const getFaviconsEnabled = webkit_website_data_manager_get_favicons_enabled;

    /// Asynchronously get the list of `webkit.ITPThirdParty` seen for `manager`.
    ///
    /// Every `webkit.ITPThirdParty`
    /// contains the list of `webkit.ITPFirstParty` under which it has been seen.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.WebsiteDataManager.getItpSummaryFinish` to get the result of the operation.
    extern fn webkit_website_data_manager_get_itp_summary(p_manager: *WebsiteDataManager, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const getItpSummary = webkit_website_data_manager_get_itp_summary;

    /// Finish an asynchronous operation started with `webkit.WebsiteDataManager.getItpSummary`.
    extern fn webkit_website_data_manager_get_itp_summary_finish(p_manager: *WebsiteDataManager, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) ?*glib.List;
    pub const getItpSummaryFinish = webkit_website_data_manager_get_itp_summary_finish;

    /// Get whether a `webkit.WebsiteDataManager` is ephemeral.
    ///
    /// See `webkit.WebsiteDataManager.properties.is`-ephemeral for more details.
    extern fn webkit_website_data_manager_is_ephemeral(p_manager: *WebsiteDataManager) c_int;
    pub const isEphemeral = webkit_website_data_manager_is_ephemeral;

    /// Asynchronously removes the website data in the given `website_data` list.
    ///
    /// Asynchronously removes the website data of the given `types` for websites in the given `website_data` list.
    /// Use `webkit.WebsiteDataManager.clear` if you want to remove the website data for all sites.
    ///
    /// When the operation is finished, `callback` will be called. You can then call
    /// `webkit.WebsiteDataManager.removeFinish` to get the result of the operation.
    extern fn webkit_website_data_manager_remove(p_manager: *WebsiteDataManager, p_types: webkit.WebsiteDataTypes, p_website_data: *glib.List, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const remove = webkit_website_data_manager_remove;

    /// Finish an asynchronous operation started with `webkit.WebsiteDataManager.remove`.
    extern fn webkit_website_data_manager_remove_finish(p_manager: *WebsiteDataManager, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const removeFinish = webkit_website_data_manager_remove_finish;

    /// Set whether website icons are enabled. Website icons are disabled by default.
    /// When website icons are disabled, the `webkit.FaviconDatabase` of `manager` is closed and
    /// its reference removed, so `webkit.WebsiteDataManager.getFaviconDatabase` will
    /// return `NULL`. If website icons are enabled again, a new `webkit.FaviconDatabase` will
    /// be created.
    extern fn webkit_website_data_manager_set_favicons_enabled(p_manager: *WebsiteDataManager, p_enabled: c_int) void;
    pub const setFaviconsEnabled = webkit_website_data_manager_set_favicons_enabled;

    extern fn webkit_website_data_manager_get_type() usize;
    pub const getGObjectType = webkit_website_data_manager_get_type;

    extern fn g_object_ref(p_self: *webkit.WebsiteDataManager) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.WebsiteDataManager) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebsiteDataManager, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// View specific website policies.
///
/// WebKitWebsitePolicies allows you to configure per-page policies,
/// currently only autoplay policies are supported.
pub const WebsitePolicies = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.WebsitePoliciesClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// The `webkit.AutoplayPolicy` of `webkit.WebsitePolicies`.
        pub const autoplay = struct {
            pub const name = "autoplay";

            pub const Type = webkit.AutoplayPolicy;
        };
    };

    pub const signals = struct {};

    /// Create a new `webkit.WebsitePolicies`.
    extern fn webkit_website_policies_new() *webkit.WebsitePolicies;
    pub const new = webkit_website_policies_new;

    /// Create a new `webkit.WebsitePolicies` with given policies.
    ///
    /// Create a new `webkit.WebsitePolicies` with policies given as variadic
    /// arguments.
    extern fn webkit_website_policies_new_with_policies(p_first_policy_name: [*:0]const u8, ...) *webkit.WebsitePolicies;
    pub const newWithPolicies = webkit_website_policies_new_with_policies;

    /// Get the `webkit.WebsitePolicies.properties.autoplay` property.
    extern fn webkit_website_policies_get_autoplay_policy(p_policies: *WebsitePolicies) webkit.AutoplayPolicy;
    pub const getAutoplayPolicy = webkit_website_policies_get_autoplay_policy;

    extern fn webkit_website_policies_get_type() usize;
    pub const getGObjectType = webkit_website_policies_get_type;

    extern fn g_object_ref(p_self: *webkit.WebsitePolicies) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.WebsitePolicies) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WebsitePolicies, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Window properties of a `webkit.WebView`.
///
/// The content of a `webkit.WebView` can request to change certain
/// properties of the window containing the view. This can include the x, y position
/// of the window, the width and height but also if a toolbar,
/// scrollbar, statusbar, locationbar should be visible to the user,
/// and the request to show the `webkit.WebView` fullscreen.
///
/// The `webkit.WebView.signals.ready`-to-show signal handler is the proper place
/// to apply the initial window properties. Then you can monitor the
/// `webkit.WindowProperties` by connecting to ::notify signal.
///
/// ```c
/// static void ready_to_show_cb (WebKitWebView *web_view, gpointer user_data)
/// {
///     GtkWidget *window;
///     WebKitWindowProperties *window_properties;
///     gboolean visible;
///
///     // Create the window to contain the WebKitWebView.
///     window = browser_window_new ();
///     gtk_container_add (GTK_CONTAINER (window), GTK_WIDGET (web_view));
///     gtk_widget_show (GTK_WIDGET (web_view));
///
///     // Get the WebKitWindowProperties of the web view and monitor it.
///     window_properties = webkit_web_view_get_window_properties (web_view);
///     g_signal_connect (window_properties, "notify::geometry",
///                       G_CALLBACK (window_geometry_changed), window);
///     g_signal_connect (window_properties, "notify::toolbar-visible",
///                       G_CALLBACK (window_toolbar_visibility_changed), window);
///     g_signal_connect (window_properties, "notify::menubar-visible",
///                       G_CALLBACK (window_menubar_visibility_changed), window);
///
///     // Apply the window properties before showing the window.
///     visible = webkit_window_properties_get_toolbar_visible (window_properties);
///     browser_window_set_toolbar_visible (BROWSER_WINDOW (window), visible);
///     visible = webkit_window_properties_get_menubar_visible (window_properties);
///     browser_window_set_menubar_visible (BROWSER_WINDOW (window), visible);
///
///     if (webkit_window_properties_get_fullscreen (window_properties)) {
///         gtk_window_fullscreen (GTK_WINDOW (window));
///     } else {
///         GdkRectangle geometry;
///
///         gtk_window_set_resizable (GTK_WINDOW (window),
///                                   webkit_window_properties_get_resizable (window_properties));
///         webkit_window_properties_get_geometry (window_properties, &geometry);
///         gtk_window_move (GTK_WINDOW (window), geometry.x, geometry.y);
///         gtk_window_resize (GTK_WINDOW (window), geometry.width, geometry.height);
///     }
///
///     gtk_widget_show (window);
/// }
/// ```
pub const WindowProperties = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = webkit.WindowPropertiesClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// Whether window will be displayed fullscreen.
        pub const fullscreen = struct {
            pub const name = "fullscreen";

            pub const Type = c_int;
        };

        /// The size and position of the window on the screen.
        pub const geometry = struct {
            pub const name = "geometry";

            pub const Type = ?*gdk.Rectangle;
        };

        /// Whether the locationbar should be visible for the window.
        pub const locationbar_visible = struct {
            pub const name = "locationbar-visible";

            pub const Type = c_int;
        };

        /// Whether the menubar should be visible for the window.
        pub const menubar_visible = struct {
            pub const name = "menubar-visible";

            pub const Type = c_int;
        };

        /// Whether the window can be resized.
        pub const resizable = struct {
            pub const name = "resizable";

            pub const Type = c_int;
        };

        /// Whether the scrollbars should be visible for the window.
        pub const scrollbars_visible = struct {
            pub const name = "scrollbars-visible";

            pub const Type = c_int;
        };

        /// Whether the statusbar should be visible for the window.
        pub const statusbar_visible = struct {
            pub const name = "statusbar-visible";

            pub const Type = c_int;
        };

        /// Whether the toolbar should be visible for the window.
        pub const toolbar_visible = struct {
            pub const name = "toolbar-visible";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Get whether the window should be shown in fullscreen state or not.
    extern fn webkit_window_properties_get_fullscreen(p_window_properties: *WindowProperties) c_int;
    pub const getFullscreen = webkit_window_properties_get_fullscreen;

    /// Get the geometry the window should have on the screen when shown.
    extern fn webkit_window_properties_get_geometry(p_window_properties: *WindowProperties, p_geometry: *gdk.Rectangle) void;
    pub const getGeometry = webkit_window_properties_get_geometry;

    /// Get whether the window should have the locationbar visible or not.
    extern fn webkit_window_properties_get_locationbar_visible(p_window_properties: *WindowProperties) c_int;
    pub const getLocationbarVisible = webkit_window_properties_get_locationbar_visible;

    /// Get whether the window should have the menubar visible or not.
    extern fn webkit_window_properties_get_menubar_visible(p_window_properties: *WindowProperties) c_int;
    pub const getMenubarVisible = webkit_window_properties_get_menubar_visible;

    /// Get whether the window should be resizable by the user or not.
    extern fn webkit_window_properties_get_resizable(p_window_properties: *WindowProperties) c_int;
    pub const getResizable = webkit_window_properties_get_resizable;

    /// Get whether the window should have the scrollbars visible or not.
    extern fn webkit_window_properties_get_scrollbars_visible(p_window_properties: *WindowProperties) c_int;
    pub const getScrollbarsVisible = webkit_window_properties_get_scrollbars_visible;

    /// Get whether the window should have the statusbar visible or not.
    extern fn webkit_window_properties_get_statusbar_visible(p_window_properties: *WindowProperties) c_int;
    pub const getStatusbarVisible = webkit_window_properties_get_statusbar_visible;

    /// Get whether the window should have the toolbar visible or not.
    extern fn webkit_window_properties_get_toolbar_visible(p_window_properties: *WindowProperties) c_int;
    pub const getToolbarVisible = webkit_window_properties_get_toolbar_visible;

    extern fn webkit_window_properties_get_type() usize;
    pub const getGObjectType = webkit_window_properties_get_type;

    extern fn g_object_ref(p_self: *webkit.WindowProperties) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.WindowProperties) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *WindowProperties, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A permission request.
///
/// There are situations where an embedder would need to ask the user
/// for permission to do certain types of operations, such as switching
/// to fullscreen mode or reporting the user's location through the
/// standard Geolocation API. In those cases, WebKit will emit a
/// `webkit.WebView.signals.permission`-request signal with a
/// `webkit.PermissionRequest` object attached to it.
pub const PermissionRequest = opaque {
    pub const Prerequisites = [_]type{gobject.Object};
    pub const Iface = webkit.PermissionRequestInterface;
    pub const virtual_methods = struct {
        /// Allow the action which triggered this request.
        pub const allow = struct {
            pub fn call(p_class: anytype, p_request: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(PermissionRequest.Iface, p_class).f_allow.?(gobject.ext.as(PermissionRequest, p_request));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_request: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(PermissionRequest.Iface, p_class).f_allow = @ptrCast(p_implementation);
            }
        };

        /// Deny the action which triggered this request.
        pub const deny = struct {
            pub fn call(p_class: anytype, p_request: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(PermissionRequest.Iface, p_class).f_deny.?(gobject.ext.as(PermissionRequest, p_request));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_request: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(PermissionRequest.Iface, p_class).f_deny = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {};

    pub const signals = struct {};

    /// Allow the action which triggered this request.
    extern fn webkit_permission_request_allow(p_request: *PermissionRequest) void;
    pub const allow = webkit_permission_request_allow;

    /// Deny the action which triggered this request.
    extern fn webkit_permission_request_deny(p_request: *PermissionRequest) void;
    pub const deny = webkit_permission_request_deny;

    extern fn webkit_permission_request_get_type() usize;
    pub const getGObjectType = webkit_permission_request_get_type;

    extern fn g_object_ref(p_self: *webkit.PermissionRequest) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *webkit.PermissionRequest) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *PermissionRequest, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Information about an application running in automation mode.
pub const ApplicationInfo = opaque {
    /// Creates a new `webkit.ApplicationInfo`
    extern fn webkit_application_info_new() *webkit.ApplicationInfo;
    pub const new = webkit_application_info_new;

    /// Get the name of the application.
    ///
    /// If `webkit.ApplicationInfo.setName` hasn't been
    /// called with a valid name, this returns `glib.getPrgname`.
    extern fn webkit_application_info_get_name(p_info: *ApplicationInfo) [*:0]const u8;
    pub const getName = webkit_application_info_get_name;

    /// Get the application version previously set with `webkit.ApplicationInfo.setVersion`.
    extern fn webkit_application_info_get_version(p_info: *ApplicationInfo, p_major: *u64, p_minor: ?*u64, p_micro: ?*u64) void;
    pub const getVersion = webkit_application_info_get_version;

    /// Atomically increments the reference count of `info` by one.
    ///
    /// This
    /// function is MT-safe and may be called from any thread.
    extern fn webkit_application_info_ref(p_info: *ApplicationInfo) *webkit.ApplicationInfo;
    pub const ref = webkit_application_info_ref;

    /// Set the name of the application.
    ///
    /// If not provided, or `NULL` is passed,
    /// `glib.getPrgname` will be used.
    extern fn webkit_application_info_set_name(p_info: *ApplicationInfo, p_name: [*:0]const u8) void;
    pub const setName = webkit_application_info_set_name;

    /// Set the application version.
    ///
    /// If the application doesn't use the format
    /// major.minor.micro you can pass 0 as the micro to use major.minor, or pass
    /// 0 as both micro and minor to use only major number. Any other format must
    /// be converted to major.minor.micro so that it can be used in version comparisons.
    extern fn webkit_application_info_set_version(p_info: *ApplicationInfo, p_major: u64, p_minor: u64, p_micro: u64) void;
    pub const setVersion = webkit_application_info_set_version;

    /// Atomically decrements the reference count of `info` by one.
    ///
    /// If the
    /// reference count drops to 0, all memory allocated by the `webkit.ApplicationInfo` is
    /// released. This function is MT-safe and may be called from any
    /// thread.
    extern fn webkit_application_info_unref(p_info: *ApplicationInfo) void;
    pub const unref = webkit_application_info_unref;

    extern fn webkit_application_info_get_type() usize;
    pub const getGObjectType = webkit_application_info_get_type;
};

pub const AuthenticationRequestClass = extern struct {
    pub const Instance = webkit.AuthenticationRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *AuthenticationRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const AutomationSessionClass = extern struct {
    pub const Instance = webkit.AutomationSession;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *AutomationSessionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const BackForwardListClass = extern struct {
    pub const Instance = webkit.BackForwardList;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *BackForwardListClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const BackForwardListItemClass = extern struct {
    pub const Instance = webkit.BackForwardListItem;

    f_parent_class: gobject.InitiallyUnownedClass,

    pub fn as(p_instance: *BackForwardListItemClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ClipboardPermissionRequestClass = extern struct {
    pub const Instance = webkit.ClipboardPermissionRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *ClipboardPermissionRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ColorChooserRequestClass = extern struct {
    pub const Instance = webkit.ColorChooserRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *ColorChooserRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ContextMenuClass = extern struct {
    pub const Instance = webkit.ContextMenu;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *ContextMenuClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ContextMenuItemClass = extern struct {
    pub const Instance = webkit.ContextMenuItem;

    f_parent_class: gobject.InitiallyUnownedClass,

    pub fn as(p_instance: *ContextMenuItemClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const CookieManagerClass = extern struct {
    pub const Instance = webkit.CookieManager;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *CookieManagerClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Groups information used for user authentication.
pub const Credential = opaque {
    /// Create a new credential from the provided username, password and persistence mode.
    extern fn webkit_credential_new(p_username: [*:0]const u8, p_password: [*:0]const u8, p_persistence: webkit.CredentialPersistence) *webkit.Credential;
    pub const new = webkit_credential_new;

    /// Create a new credential from the `certificate` and persistence mode.
    ///
    /// Note that `WEBKIT_CREDENTIAL_PERSISTENCE_PERMANENT` is not supported for certificate credentials.
    extern fn webkit_credential_new_for_certificate(p_certificate: ?*gio.TlsCertificate, p_persistence: webkit.CredentialPersistence) *webkit.Credential;
    pub const newForCertificate = webkit_credential_new_for_certificate;

    /// Create a new credential from the provided PIN and persistence mode.
    ///
    /// Note that `WEBKIT_CREDENTIAL_PERSISTENCE_PERMANENT` is not supported for certificate pin credentials.
    extern fn webkit_credential_new_for_certificate_pin(p_pin: [*:0]const u8, p_persistence: webkit.CredentialPersistence) *webkit.Credential;
    pub const newForCertificatePin = webkit_credential_new_for_certificate_pin;

    /// Make a copy of the `webkit.Credential`.
    extern fn webkit_credential_copy(p_credential: *Credential) *webkit.Credential;
    pub const copy = webkit_credential_copy;

    /// Free the `webkit.Credential`.
    extern fn webkit_credential_free(p_credential: *Credential) void;
    pub const free = webkit_credential_free;

    /// Get the certificate currently held by this `webkit.Credential`.
    extern fn webkit_credential_get_certificate(p_credential: *Credential) *gio.TlsCertificate;
    pub const getCertificate = webkit_credential_get_certificate;

    /// Get the password currently held by this `webkit.Credential`.
    extern fn webkit_credential_get_password(p_credential: *Credential) [*:0]const u8;
    pub const getPassword = webkit_credential_get_password;

    /// Get the persistence mode currently held by this `webkit.Credential`.
    extern fn webkit_credential_get_persistence(p_credential: *Credential) webkit.CredentialPersistence;
    pub const getPersistence = webkit_credential_get_persistence;

    /// Get the username currently held by this `webkit.Credential`.
    extern fn webkit_credential_get_username(p_credential: *Credential) [*:0]const u8;
    pub const getUsername = webkit_credential_get_username;

    /// Determine whether this credential has a password stored.
    extern fn webkit_credential_has_password(p_credential: *Credential) c_int;
    pub const hasPassword = webkit_credential_has_password;

    extern fn webkit_credential_get_type() usize;
    pub const getGObjectType = webkit_credential_get_type;
};

pub const DeviceInfoPermissionRequestClass = extern struct {
    pub const Instance = webkit.DeviceInfoPermissionRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *DeviceInfoPermissionRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DownloadClass = extern struct {
    pub const Instance = webkit.Download;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *DownloadClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const EditorStateClass = extern struct {
    pub const Instance = webkit.EditorState;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *EditorStateClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const FaviconDatabaseClass = extern struct {
    pub const Instance = webkit.FaviconDatabase;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *FaviconDatabaseClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Describes a web engine feature that may be toggled at runtime.
///
/// The WebKit web engine includes a set of features which may be toggled
/// programmatically, each one represented by a `webkit.Feature` that provides
/// information about it:
///
/// - A unique “identifier”: `Feature.getIdentifier`.
/// - A “default value”, which indicates whether the option is enabled
///   automatically: `Feature.getDefaultValue`.
/// - Its “status”, which determines whether it should be considered
///   user-settable and its development stage (see `FeatureStatus`
///   for details): `Feature.getStatus`.
/// - A category, which may be used to group features together:
///   `Feature.getCategory`.
/// - An optional short “name” which can be presented to an user:
///   `Feature.getName`.
/// - An optional longer “detailed” description:
///   `Feature.getDetails`.
///
/// The lists of available features can be obtained with
/// `Settings.getAllFeatures`, `Settings.getExperimentalFeatures`,
/// and `Settings.getDevelopmentFeatures`). As a rule of thumb,
/// applications which may want to allow users (i.e. web developers) to test
/// WebKit features should use the list of experimental features. Additionally,
/// applications might want to expose development features *when targeting
/// technically inclined users* for early testing of in-development features
/// (i.e. in “technology preview” or “canary” builds).
///
/// Applications **must not** expose the list of all features to end users
/// because they often lack descriptions and control parts of the web engine
/// which are either intended to be used during development of WebKit itself,
/// or in specific scenarios to tweak how WebKit integrates with the
/// application.
pub const Feature = opaque {
    /// Gets the category of the feature.
    ///
    /// Applications which include user interface to toggle features may want
    /// to use the category to group related features together.
    extern fn webkit_feature_get_category(p_feature: *Feature) [*:0]const u8;
    pub const getCategory = webkit_feature_get_category;

    /// Gets whether the feature is enabled by default.
    ///
    /// The default value may be used by applications which include user interface
    /// to toggle features to restore its settings to their defaults. Note that
    /// whether a feature is actually enabled must be checked with
    /// `Settings.getFeatureEnabled`.
    extern fn webkit_feature_get_default_value(p_feature: *Feature) c_int;
    pub const getDefaultValue = webkit_feature_get_default_value;

    /// Gets a description for the `feature`.
    ///
    /// The detailed description should be considered an additional clarification
    /// on the purpose of the feature, to be used as complementary aid to be
    /// displayed along the feature name returned by `Feature.getName`.
    /// The returned string is suitable to be displayed to end users, but it
    /// should not be relied upon being localized.
    ///
    /// Note that some *features may not* have a detailed description, and `NULL`
    /// is returned in this case.
    extern fn webkit_feature_get_details(p_feature: *Feature) ?[*:0]const u8;
    pub const getDetails = webkit_feature_get_details;

    /// Gets a string that uniquely identifies the `feature`.
    extern fn webkit_feature_get_identifier(p_feature: *Feature) [*:0]const u8;
    pub const getIdentifier = webkit_feature_get_identifier;

    /// Gets a short name for the `feature`.
    ///
    /// The returned string is suitable to be displayed to end users, but it
    /// should not be relied upon being localized.
    ///
    /// Note that some *features may not* have a short name, and `NULL`
    /// is returned in this case.
    extern fn webkit_feature_get_name(p_feature: *Feature) ?[*:0]const u8;
    pub const getName = webkit_feature_get_name;

    /// Gets the status of the feature.
    extern fn webkit_feature_get_status(p_feature: *Feature) webkit.FeatureStatus;
    pub const getStatus = webkit_feature_get_status;

    /// Atomically acquires a reference on the given `feature`.
    ///
    /// This function is MT-safe and may be called from any thread.
    extern fn webkit_feature_ref(p_feature: *Feature) *webkit.Feature;
    pub const ref = webkit_feature_ref;

    /// Atomically releases a reference on the given `feature`.
    ///
    /// If the reference was the last, the resources associated to the
    /// `feature` are freed. This function is MT-safe and may be called from
    /// any thread.
    extern fn webkit_feature_unref(p_feature: *Feature) void;
    pub const unref = webkit_feature_unref;

    extern fn webkit_feature_get_type() usize;
    pub const getGObjectType = webkit_feature_get_type;
};

/// Contains a set of toggle-able web engine features.
///
/// The list supports passing around a set of `Feature` objects and
/// iterating over them:
///
/// ```c
/// g_autoptr(WebKitFeatureList) list = `webkit.Settings.getExperimentalFeatures`;
/// for (gsize i = 0; i < webkit_feature_list_get_length(list): i++) {
///     WebKitFeature *feature = webkit_feature_list_get(list, i);
///     // Do something with "feature".
/// }
/// ```
///
/// Lists of features can be obtained with
/// `Settings.getExperimentalFeatures`,
/// `Settings.getDevelopmentFeatures`, and
/// `Settings.getAllFeatures`.
pub const FeatureList = opaque {
    /// Gets a feature given its index.
    extern fn webkit_feature_list_get(p_feature_list: *FeatureList, p_index: usize) *webkit.Feature;
    pub const get = webkit_feature_list_get;

    /// Gets the number of elements in the feature list.
    extern fn webkit_feature_list_get_length(p_feature_list: *FeatureList) usize;
    pub const getLength = webkit_feature_list_get_length;

    /// Atomically acquires a reference on the given `feature_list`.
    ///
    /// This function is MT-safe and may be called from any thread.
    extern fn webkit_feature_list_ref(p_feature_list: *FeatureList) *webkit.FeatureList;
    pub const ref = webkit_feature_list_ref;

    /// Atomically releases a reference on the given `feature_list`.
    ///
    /// If the reference was the last, the resources associated to the
    /// `feature_list` are freed. This function is MT-safe and may be called
    /// from any thread.
    extern fn webkit_feature_list_unref(p_feature_list: *FeatureList) void;
    pub const unref = webkit_feature_list_unref;

    extern fn webkit_feature_list_get_type() usize;
    pub const getGObjectType = webkit_feature_list_get_type;
};

pub const FileChooserRequestClass = extern struct {
    pub const Instance = webkit.FileChooserRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *FileChooserRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const FindControllerClass = extern struct {
    pub const Instance = webkit.FindController;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *FindControllerClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const FormSubmissionRequestClass = extern struct {
    pub const Instance = webkit.FormSubmissionRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *FormSubmissionRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const GeolocationManagerClass = extern struct {
    pub const Instance = webkit.GeolocationManager;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *GeolocationManagerClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const GeolocationPermissionRequestClass = extern struct {
    pub const Instance = webkit.GeolocationPermissionRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *GeolocationPermissionRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// An opaque struct to provide position updates to a `webkit.GeolocationManager`.
///
/// WebKitGeolocationPosition is an opaque struct used to provide position updates to a
/// `webkit.GeolocationManager` using `webkit.GeolocationManager.updatePosition`.
pub const GeolocationPosition = opaque {
    /// Create a new `webkit.GeolocationPosition`.
    extern fn webkit_geolocation_position_new(p_latitude: f64, p_longitude: f64, p_accuracy: f64) *webkit.GeolocationPosition;
    pub const new = webkit_geolocation_position_new;

    /// Make a copy of the `webkit.GeolocationPosition`.
    extern fn webkit_geolocation_position_copy(p_position: *GeolocationPosition) *webkit.GeolocationPosition;
    pub const copy = webkit_geolocation_position_copy;

    /// Free the `webkit.GeolocationPosition`
    extern fn webkit_geolocation_position_free(p_position: *GeolocationPosition) void;
    pub const free = webkit_geolocation_position_free;

    /// Set the `position` altitude.
    extern fn webkit_geolocation_position_set_altitude(p_position: *GeolocationPosition, p_altitude: f64) void;
    pub const setAltitude = webkit_geolocation_position_set_altitude;

    /// Set the accuracy of `position` altitude.
    extern fn webkit_geolocation_position_set_altitude_accuracy(p_position: *GeolocationPosition, p_altitude_accuracy: f64) void;
    pub const setAltitudeAccuracy = webkit_geolocation_position_set_altitude_accuracy;

    /// Set the `position` heading.
    ///
    /// Set the `position` heading, as a positive angle between the direction of movement and the North
    /// direction, in clockwise direction.
    extern fn webkit_geolocation_position_set_heading(p_position: *GeolocationPosition, p_heading: f64) void;
    pub const setHeading = webkit_geolocation_position_set_heading;

    /// Set the `position` speed.
    extern fn webkit_geolocation_position_set_speed(p_position: *GeolocationPosition, p_speed: f64) void;
    pub const setSpeed = webkit_geolocation_position_set_speed;

    /// Set the `position` timestamp.
    ///
    /// By default it's the time when the `position` was created.
    extern fn webkit_geolocation_position_set_timestamp(p_position: *GeolocationPosition, p_timestamp: u64) void;
    pub const setTimestamp = webkit_geolocation_position_set_timestamp;

    extern fn webkit_geolocation_position_get_type() usize;
    pub const getGObjectType = webkit_geolocation_position_get_type;
};

pub const HitTestResultClass = extern struct {
    pub const Instance = webkit.HitTestResult;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *HitTestResultClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Describes a first party origin.
pub const ITPFirstParty = opaque {
    /// Get the domain name of `itp_first_party`.
    extern fn webkit_itp_first_party_get_domain(p_itp_first_party: *ITPFirstParty) [*:0]const u8;
    pub const getDomain = webkit_itp_first_party_get_domain;

    /// Get the last time a `webkit.ITPThirdParty` has been seen under `itp_first_party`.
    ///
    /// Each `WebKitITPFirstParty` is created by `webkit.ITPThirdParty.getFirstParties` and
    /// therefore corresponds to exactly one `webkit.ITPThirdParty`.
    extern fn webkit_itp_first_party_get_last_update_time(p_itp_first_party: *ITPFirstParty) *glib.DateTime;
    pub const getLastUpdateTime = webkit_itp_first_party_get_last_update_time;

    /// Get whether `itp_first_party` has granted website data access to its `webkit.ITPThirdParty`.
    ///
    /// Each `WebKitITPFirstParty` is created by `webkit.ITPThirdParty.getFirstParties` and
    /// therefore corresponds to exactly one `webkit.ITPThirdParty`.
    extern fn webkit_itp_first_party_get_website_data_access_allowed(p_itp_first_party: *ITPFirstParty) c_int;
    pub const getWebsiteDataAccessAllowed = webkit_itp_first_party_get_website_data_access_allowed;

    /// Atomically increments the reference count of `itp_first_party` by one.
    ///
    /// This function is MT-safe and may be called from any thread.
    extern fn webkit_itp_first_party_ref(p_itp_first_party: *ITPFirstParty) *webkit.ITPFirstParty;
    pub const ref = webkit_itp_first_party_ref;

    /// Atomically decrements the reference count of `itp_first_party` by one.
    ///
    /// If the reference count drops to 0, all memory allocated by
    /// `webkit.ITPFirstParty` is released. This function is MT-safe and may be
    /// called from any thread.
    extern fn webkit_itp_first_party_unref(p_itp_first_party: *ITPFirstParty) void;
    pub const unref = webkit_itp_first_party_unref;

    extern fn webkit_itp_first_party_get_type() usize;
    pub const getGObjectType = webkit_itp_first_party_get_type;
};

/// Describes a third party origin.
pub const ITPThirdParty = opaque {
    /// Get the domain name of `itp_third_party`.
    extern fn webkit_itp_third_party_get_domain(p_itp_third_party: *ITPThirdParty) [*:0]const u8;
    pub const getDomain = webkit_itp_third_party_get_domain;

    /// Get the list of `webkit.ITPFirstParty` under which `itp_third_party` has been seen.
    extern fn webkit_itp_third_party_get_first_parties(p_itp_third_party: *ITPThirdParty) *glib.List;
    pub const getFirstParties = webkit_itp_third_party_get_first_parties;

    /// Atomically increments the reference count of `itp_third_party` by one.
    ///
    /// This function is MT-safe and may be called from any thread.
    extern fn webkit_itp_third_party_ref(p_itp_third_party: *ITPThirdParty) *webkit.ITPThirdParty;
    pub const ref = webkit_itp_third_party_ref;

    /// Atomically decrements the reference count of `itp_third_party` by one.
    ///
    /// If the reference count drops to 0, all memory allocated by
    /// `webkit.ITPThirdParty` is released. This function is MT-safe and may be
    /// called from any thread.
    extern fn webkit_itp_third_party_unref(p_itp_third_party: *ITPThirdParty) void;
    pub const unref = webkit_itp_third_party_unref;

    extern fn webkit_itp_third_party_get_type() usize;
    pub const getGObjectType = webkit_itp_third_party_get_type;
};

pub const InputMethodContextClass = extern struct {
    pub const Instance = webkit.InputMethodContext;

    f_parent_class: gobject.ObjectClass,
    f_preedit_started: ?*const fn (p_context: *webkit.InputMethodContext) callconv(.C) void,
    f_preedit_changed: ?*const fn (p_context: *webkit.InputMethodContext) callconv(.C) void,
    f_preedit_finished: ?*const fn (p_context: *webkit.InputMethodContext) callconv(.C) void,
    f_committed: ?*const fn (p_context: *webkit.InputMethodContext, p_text: [*:0]const u8) callconv(.C) void,
    f_delete_surrounding: ?*const fn (p_context: *webkit.InputMethodContext, p_offset: c_int, p_n_chars: c_uint) callconv(.C) void,
    /// Called via `webkit.InputMethodContext.setEnablePreedit` to
    ///   control the use of the preedit string.
    f_set_enable_preedit: ?*const fn (p_context: *webkit.InputMethodContext, p_enabled: c_int) callconv(.C) void,
    /// Called via `webkit.InputMethodContext.getPreedit` to
    ///   retrieve the text currently being preedited for display at the cursor
    ///   position. Any input method which composes complex characters or any
    ///   other compositions from multiple sequential key presses should override
    ///   this method to provide feedback.
    f_get_preedit: ?*const fn (p_context: *webkit.InputMethodContext, p_text: ?*[*:0]u8, p_underlines: ?**glib.List, p_cursor_offset: ?*c_uint) callconv(.C) void,
    /// Called via `webkit.InputMethodContext.filterKeyEvent` on every
    ///   key press or release event. Every non-trivial input method needs to
    ///   override this in order to implement the mapping from key events to text.
    ///   A return value of `TRUE` indicates to the caller that the event was
    ///   consumed by the input method. In that case, the `webkit.InputMethodContext.signals.committed`
    ///   signal should be emitted upon completion of a key sequence to pass the
    ///   resulting text back to the editable element. Alternatively, `FALSE` may be
    ///   returned to indicate that the event wasn’t handled by the input method.
    f_filter_key_event: ?*const fn (p_context: *webkit.InputMethodContext, p_key_event: *gdk.Event) callconv(.C) c_int,
    /// Called via `webkit.InputMethodContext.notifyFocusIn` when
    ///   an editable element of the `webkit.WebView` has gained focus.
    f_notify_focus_in: ?*const fn (p_context: *webkit.InputMethodContext) callconv(.C) void,
    /// Called via `webkit.InputMethodContext.notifyFocusOut` when
    ///   an editable element of the `webkit.WebView` has lost focus.
    f_notify_focus_out: ?*const fn (p_context: *webkit.InputMethodContext) callconv(.C) void,
    /// Called via `webkit.InputMethodContext.notifyCursorArea`
    ///   to inform the input method of the current cursor location relative to
    ///   the client window.
    f_notify_cursor_area: ?*const fn (p_context: *webkit.InputMethodContext, p_x: c_int, p_y: c_int, p_width: c_int, p_height: c_int) callconv(.C) void,
    /// Called via `webkit.InputMethodContext.notifySurrounding` to
    ///   update the context surrounding the cursor. The provided text should not include
    ///   the preedit string.
    f_notify_surrounding: ?*const fn (p_context: *webkit.InputMethodContext, p_text: [*:0]const u8, p_length: c_uint, p_cursor_index: c_uint, p_selection_index: c_uint) callconv(.C) void,
    /// Called via `webkit.InputMethodContext.reset` to signal a change that
    ///   requires a reset. An input method that implements preediting
    ///   should override this method to clear the preedit state on reset.
    f_reset: ?*const fn (p_context: *webkit.InputMethodContext) callconv(.C) void,
    f__webkit_reserved0: ?*const fn () callconv(.C) void,
    f__webkit_reserved1: ?*const fn () callconv(.C) void,
    f__webkit_reserved2: ?*const fn () callconv(.C) void,
    f__webkit_reserved3: ?*const fn () callconv(.C) void,
    f__webkit_reserved4: ?*const fn () callconv(.C) void,
    f__webkit_reserved5: ?*const fn () callconv(.C) void,
    f__webkit_reserved6: ?*const fn () callconv(.C) void,
    f__webkit_reserved7: ?*const fn () callconv(.C) void,
    f__webkit_reserved8: ?*const fn () callconv(.C) void,
    f__webkit_reserved9: ?*const fn () callconv(.C) void,
    f__webkit_reserved10: ?*const fn () callconv(.C) void,
    f__webkit_reserved11: ?*const fn () callconv(.C) void,
    f__webkit_reserved12: ?*const fn () callconv(.C) void,
    f__webkit_reserved13: ?*const fn () callconv(.C) void,
    f__webkit_reserved14: ?*const fn () callconv(.C) void,
    f__webkit_reserved15: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *InputMethodContextClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const InputMethodContextPrivate = opaque {};

/// Range of text in an preedit string to be shown underlined.
pub const InputMethodUnderline = opaque {
    /// Create a new `webkit.InputMethodUnderline` for the given range in preedit string
    extern fn webkit_input_method_underline_new(p_start_offset: c_uint, p_end_offset: c_uint) *webkit.InputMethodUnderline;
    pub const new = webkit_input_method_underline_new;

    /// Make a copy of the `webkit.InputMethodUnderline`.
    extern fn webkit_input_method_underline_copy(p_underline: *InputMethodUnderline) *webkit.InputMethodUnderline;
    pub const copy = webkit_input_method_underline_copy;

    /// Free the `webkit.InputMethodUnderline`.
    extern fn webkit_input_method_underline_free(p_underline: *InputMethodUnderline) void;
    pub const free = webkit_input_method_underline_free;

    /// Set the color of the underline.
    ///
    /// If `rgba` is `NULL` the foreground text color will be used
    /// for the underline too.
    extern fn webkit_input_method_underline_set_color(p_underline: *InputMethodUnderline, p_rgba: ?*const gdk.RGBA) void;
    pub const setColor = webkit_input_method_underline_set_color;

    extern fn webkit_input_method_underline_get_type() usize;
    pub const getGObjectType = webkit_input_method_underline_get_type;
};

pub const MediaKeySystemPermissionRequestClass = extern struct {
    pub const Instance = webkit.MediaKeySystemPermissionRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *MediaKeySystemPermissionRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A boxed type representing the settings for the memory pressure handler
///
/// `webkit.MemoryPressureSettings` is a boxed type that can be used to provide some custom settings
/// to control how the memory pressure situations are handled by the different processes.
///
/// The memory pressure system implemented inside the different process will try to keep the memory usage
/// under the defined memory limit. In order to do that, it will check the used memory with a user defined
/// frequency and decide whether it should try to release memory. The thresholds passed will define how urgent
/// is to release that memory.
///
/// Take into account that badly defined parameters can greatly reduce the performance of the engine. For
/// example, setting memory limit too low with a fast poll interval can cause the process to constantly
/// be trying to release memory.
///
/// A `webkit.MemoryPressureSettings` can be passed to a `webkit.WebContext` constructor, and the settings will
/// be applied to all the web processes created by that context.
///
/// A `webkit.MemoryPressureSettings` can be passed to `webkit_website_data_manager_set_memory_pressure_settings`,
/// and the settings will be applied to all the network processes created after that call by any instance of
/// `webkit.WebsiteDataManager`.
pub const MemoryPressureSettings = opaque {
    /// Create a new `webkit.MemoryPressureSettings` with the default values.
    extern fn webkit_memory_pressure_settings_new() *webkit.MemoryPressureSettings;
    pub const new = webkit_memory_pressure_settings_new;

    /// Make a copy of `settings`.
    extern fn webkit_memory_pressure_settings_copy(p_settings: *MemoryPressureSettings) *webkit.MemoryPressureSettings;
    pub const copy = webkit_memory_pressure_settings_copy;

    /// Free the `webkit.MemoryPressureSettings`.
    extern fn webkit_memory_pressure_settings_free(p_settings: *MemoryPressureSettings) void;
    pub const free = webkit_memory_pressure_settings_free;

    /// Gets the conservative memory usage threshold.
    extern fn webkit_memory_pressure_settings_get_conservative_threshold(p_settings: *MemoryPressureSettings) f64;
    pub const getConservativeThreshold = webkit_memory_pressure_settings_get_conservative_threshold;

    /// Gets the kill memory usage threshold.
    extern fn webkit_memory_pressure_settings_get_kill_threshold(p_settings: *MemoryPressureSettings) f64;
    pub const getKillThreshold = webkit_memory_pressure_settings_get_kill_threshold;

    /// Gets the memory usage limit.
    extern fn webkit_memory_pressure_settings_get_memory_limit(p_settings: *MemoryPressureSettings) c_uint;
    pub const getMemoryLimit = webkit_memory_pressure_settings_get_memory_limit;

    /// Gets the interval at which memory usage is checked.
    extern fn webkit_memory_pressure_settings_get_poll_interval(p_settings: *MemoryPressureSettings) f64;
    pub const getPollInterval = webkit_memory_pressure_settings_get_poll_interval;

    /// Gets the strict memory usage threshold.
    extern fn webkit_memory_pressure_settings_get_strict_threshold(p_settings: *MemoryPressureSettings) f64;
    pub const getStrictThreshold = webkit_memory_pressure_settings_get_strict_threshold;

    /// Sets the memory limit for the conservative policy to start working.
    ///
    /// Sets `value` as the fraction of the defined memory limit where the conservative
    /// policy starts working. This policy will try to reduce the memory footprint by
    /// releasing non critical memory.
    ///
    /// The threshold must be bigger than 0 and smaller than 1, and it must be smaller
    /// than the strict threshold defined in `settings`. The default value is 0.33.
    extern fn webkit_memory_pressure_settings_set_conservative_threshold(p_settings: *MemoryPressureSettings, p_value: f64) void;
    pub const setConservativeThreshold = webkit_memory_pressure_settings_set_conservative_threshold;

    /// Sets `value` as the fraction of the defined memory limit where the process will be
    /// killed.
    ///
    /// The threshold must be a value bigger or equal to 0. A value of 0 means that the process
    /// is never killed. If the threshold is not 0, then it must be bigger than the strict threshold
    /// defined in `settings`. The threshold can also have values bigger than 1. The default value is 0.
    extern fn webkit_memory_pressure_settings_set_kill_threshold(p_settings: *MemoryPressureSettings, p_value: f64) void;
    pub const setKillThreshold = webkit_memory_pressure_settings_set_kill_threshold;

    /// Sets `memory_limit` the memory limit value to `settings`.
    ///
    /// The default value is the system's RAM size with a maximum of 3GB.
    extern fn webkit_memory_pressure_settings_set_memory_limit(p_settings: *MemoryPressureSettings, p_memory_limit: c_uint) void;
    pub const setMemoryLimit = webkit_memory_pressure_settings_set_memory_limit;

    /// Sets `value` as the poll interval used by `settings`.
    ///
    /// The poll interval value must be bigger than 0. The default value is 30 seconds.
    extern fn webkit_memory_pressure_settings_set_poll_interval(p_settings: *MemoryPressureSettings, p_value: f64) void;
    pub const setPollInterval = webkit_memory_pressure_settings_set_poll_interval;

    /// Sets the memory limit for the strict policy to start working.
    ///
    /// Sets `value` as the fraction of the defined memory limit where the strict
    /// policy starts working. This policy will try to reduce the memory footprint by
    /// releasing critical memory.
    ///
    /// The threshold must be bigger than 0 and smaller than 1. Also, it must be bigger
    /// than the conservative threshold defined in `settings`, and smaller than the kill
    /// threshold if the latter is not 0. The default value is 0.5.
    extern fn webkit_memory_pressure_settings_set_strict_threshold(p_settings: *MemoryPressureSettings, p_value: f64) void;
    pub const setStrictThreshold = webkit_memory_pressure_settings_set_strict_threshold;

    extern fn webkit_memory_pressure_settings_get_type() usize;
    pub const getGObjectType = webkit_memory_pressure_settings_get_type;
};

/// Provides details about interaction resulting in a resource load.
pub const NavigationAction = opaque {
    /// Make a copy of `navigation`.
    extern fn webkit_navigation_action_copy(p_navigation: *NavigationAction) *webkit.NavigationAction;
    pub const copy = webkit_navigation_action_copy;

    /// Free the `webkit.NavigationAction`
    extern fn webkit_navigation_action_free(p_navigation: *NavigationAction) void;
    pub const free = webkit_navigation_action_free;

    /// Gets the `navigation` target frame name. For example if navigation was triggered by clicking a
    /// link with a target attribute equal to "_blank", this will return the value of that attribute.
    /// In all other cases this function will return `NULL`.
    extern fn webkit_navigation_action_get_frame_name(p_navigation: *NavigationAction) ?[*:0]const u8;
    pub const getFrameName = webkit_navigation_action_get_frame_name;

    /// Return the modifier keys.
    ///
    /// Return a bitmask of `gdk.ModifierType` values describing the modifier keys that were in effect
    /// when the navigation was requested
    extern fn webkit_navigation_action_get_modifiers(p_navigation: *NavigationAction) c_uint;
    pub const getModifiers = webkit_navigation_action_get_modifiers;

    /// Return the number of the mouse button that triggered the navigation.
    ///
    /// Return the number of the mouse button that triggered the navigation, or 0 if
    /// the navigation was not started by a mouse event.
    extern fn webkit_navigation_action_get_mouse_button(p_navigation: *NavigationAction) c_uint;
    pub const getMouseButton = webkit_navigation_action_get_mouse_button;

    /// Return the type of action that triggered the navigation.
    extern fn webkit_navigation_action_get_navigation_type(p_navigation: *NavigationAction) webkit.NavigationType;
    pub const getNavigationType = webkit_navigation_action_get_navigation_type;

    /// Return the `webkit.URIRequest` associated with the navigation action.
    ///
    /// Modifications to the returned object are <emphasis>not</emphasis> taken
    /// into account when the request is sent over the network, and is intended
    /// only to aid in evaluating whether a navigation action should be taken or
    /// not. To modify requests before they are sent over the network the
    /// `WebKitPage.signals.send`-request signal can be used instead.
    extern fn webkit_navigation_action_get_request(p_navigation: *NavigationAction) *webkit.URIRequest;
    pub const getRequest = webkit_navigation_action_get_request;

    /// Returns whether the `navigation` was redirected.
    extern fn webkit_navigation_action_is_redirect(p_navigation: *NavigationAction) c_int;
    pub const isRedirect = webkit_navigation_action_is_redirect;

    /// Return whether the navigation was triggered by a user gesture like a mouse click.
    extern fn webkit_navigation_action_is_user_gesture(p_navigation: *NavigationAction) c_int;
    pub const isUserGesture = webkit_navigation_action_is_user_gesture;

    extern fn webkit_navigation_action_get_type() usize;
    pub const getGObjectType = webkit_navigation_action_get_type;
};

pub const NavigationPolicyDecisionClass = extern struct {
    pub const Instance = webkit.NavigationPolicyDecision;

    f_parent_class: webkit.PolicyDecisionClass,

    pub fn as(p_instance: *NavigationPolicyDecisionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Configures network proxies.
///
/// WebKitNetworkProxySettings can be used to provide a custom proxy configuration
/// to a `webkit.WebContext`. You need to call `webkit_web_context_set_network_proxy_settings`
/// with `WEBKIT_NETWORK_PROXY_MODE_CUSTOM` and a WebKitNetworkProxySettings.
pub const NetworkProxySettings = opaque {
    /// Create a new `webkit.NetworkProxySettings` with the given `default_proxy_uri` and `ignore_hosts`.
    ///
    /// The default proxy URI will be used for any URI that doesn't match `ignore_hosts`, and doesn't match any
    /// of the schemes added with `webkit.NetworkProxySettings.addProxyForScheme`.
    /// If `default_proxy_uri` starts with "socks://", it will be treated as referring to all three of the
    /// socks5, socks4a, and socks4 proxy types.
    ///
    /// `ignore_hosts` is a list of hostnames and IP addresses that the resolver should allow direct connections to.
    /// Entries can be in one of 4 formats:
    /// <itemizedlist>
    /// <listitem><para>
    /// A hostname, such as "example.com", ".example.com", or "*.example.com", any of which match "example.com" or
    /// any subdomain of it.
    /// </para></listitem>
    /// <listitem><para>
    /// An IPv4 or IPv6 address, such as "192.168.1.1", which matches only that address.
    /// </para></listitem>
    /// <listitem><para>
    /// A hostname or IP address followed by a port, such as "example.com:80", which matches whatever the hostname or IP
    /// address would match, but only for URLs with the (explicitly) indicated port. In the case of an IPv6 address, the address
    /// part must appear in brackets: "[::1]:443"
    /// </para></listitem>
    /// <listitem><para>
    /// An IP address range, given by a base address and prefix length, such as "fe80::/10", which matches any address in that range.
    /// </para></listitem>
    /// </itemizedlist>
    ///
    /// Note that when dealing with Unicode hostnames, the matching is done against the ASCII form of the name.
    /// Also note that hostname exclusions apply only to connections made to hosts identified by name, and IP address exclusions apply only
    /// to connections made to hosts identified by address. That is, if example.com has an address of 192.168.1.1, and `ignore_hosts`
    /// contains only "192.168.1.1", then a connection to "example.com" will use the proxy, and a connection to 192.168.1.1" will not.
    extern fn webkit_network_proxy_settings_new(p_default_proxy_uri: ?[*:0]const u8, p_ignore_hosts: ?[*]const [*:0]const u8) *webkit.NetworkProxySettings;
    pub const new = webkit_network_proxy_settings_new;

    /// Adds a URI-scheme-specific proxy.
    ///
    /// URIs whose scheme matches `uri_scheme` will be proxied via `proxy_uri`.
    /// As with the default proxy URI, if `proxy_uri` starts with "socks://", it will be treated as referring to
    /// all three of the socks5, socks4a, and socks4 proxy types.
    extern fn webkit_network_proxy_settings_add_proxy_for_scheme(p_proxy_settings: *NetworkProxySettings, p_scheme: [*:0]const u8, p_proxy_uri: [*:0]const u8) void;
    pub const addProxyForScheme = webkit_network_proxy_settings_add_proxy_for_scheme;

    /// Make a copy of the `webkit.NetworkProxySettings`.
    extern fn webkit_network_proxy_settings_copy(p_proxy_settings: *NetworkProxySettings) *webkit.NetworkProxySettings;
    pub const copy = webkit_network_proxy_settings_copy;

    /// Free the `webkit.NetworkProxySettings`.
    extern fn webkit_network_proxy_settings_free(p_proxy_settings: *NetworkProxySettings) void;
    pub const free = webkit_network_proxy_settings_free;

    extern fn webkit_network_proxy_settings_get_type() usize;
    pub const getGObjectType = webkit_network_proxy_settings_get_type;
};

pub const NetworkSessionClass = extern struct {
    pub const Instance = webkit.NetworkSession;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *NetworkSessionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const NotificationClass = extern struct {
    pub const Instance = webkit.Notification;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *NotificationClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const NotificationPermissionRequestClass = extern struct {
    pub const Instance = webkit.NotificationPermissionRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *NotificationPermissionRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const OptionMenuClass = extern struct {
    pub const Instance = webkit.OptionMenu;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *OptionMenuClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// One item of a `webkit.OptionMenu`.
///
/// The `webkit.OptionMenu` is composed of WebKitOptionMenuItem<!-- -->s.
/// A WebKitOptionMenuItem always has a label and can contain a tooltip text.
/// You can use the WebKitOptionMenuItem of a `webkit.OptionMenu` to build your
/// own menus.
pub const OptionMenuItem = opaque {
    /// Make a copy of the `webkit.OptionMenuItem`.
    extern fn webkit_option_menu_item_copy(p_item: *OptionMenuItem) *webkit.OptionMenuItem;
    pub const copy = webkit_option_menu_item_copy;

    /// Free the `webkit.OptionMenuItem`.
    extern fn webkit_option_menu_item_free(p_item: *OptionMenuItem) void;
    pub const free = webkit_option_menu_item_free;

    /// Get the label of a `webkit.OptionMenuItem`.
    extern fn webkit_option_menu_item_get_label(p_item: *OptionMenuItem) [*:0]const u8;
    pub const getLabel = webkit_option_menu_item_get_label;

    /// Get the tooltip of a `webkit.OptionMenuItem`.
    extern fn webkit_option_menu_item_get_tooltip(p_item: *OptionMenuItem) [*:0]const u8;
    pub const getTooltip = webkit_option_menu_item_get_tooltip;

    /// Whether a `webkit.OptionMenuItem` is enabled.
    extern fn webkit_option_menu_item_is_enabled(p_item: *OptionMenuItem) c_int;
    pub const isEnabled = webkit_option_menu_item_is_enabled;

    /// Whether a `webkit.OptionMenuItem` is a group child.
    extern fn webkit_option_menu_item_is_group_child(p_item: *OptionMenuItem) c_int;
    pub const isGroupChild = webkit_option_menu_item_is_group_child;

    /// Whether a `webkit.OptionMenuItem` is a group label.
    extern fn webkit_option_menu_item_is_group_label(p_item: *OptionMenuItem) c_int;
    pub const isGroupLabel = webkit_option_menu_item_is_group_label;

    /// Whether a `webkit.OptionMenuItem` is the currently selected one.
    extern fn webkit_option_menu_item_is_selected(p_item: *OptionMenuItem) c_int;
    pub const isSelected = webkit_option_menu_item_is_selected;

    extern fn webkit_option_menu_item_get_type() usize;
    pub const getGObjectType = webkit_option_menu_item_get_type;
};

pub const PermissionRequestInterface = extern struct {
    pub const Instance = webkit.PermissionRequest;

    f_parent_interface: gobject.TypeInterface,
    f_allow: ?*const fn (p_request: *webkit.PermissionRequest) callconv(.C) void,
    f_deny: ?*const fn (p_request: *webkit.PermissionRequest) callconv(.C) void,

    pub fn as(p_instance: *PermissionRequestInterface, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// This query represents a user's choice to allow or deny access to "powerful features" of the
/// platform, as specified in the [Permissions W3C
/// Specification](https://w3c.github.io/permissions/).
///
/// When signalled by the `webkit.WebView` through the `query-permission-state` signal, the application
/// has to eventually respond, via ``webkit.PermissionStateQuery.finish``, whether it grants,
/// denies or requests a dedicated permission prompt for the given query.
///
/// When a `webkit.PermissionStateQuery` is not handled by the user, the user-agent is instructed to
/// `prompt` the user for the given permission.
pub const PermissionStateQuery = opaque {
    /// Notify the web-engine of the selected permission state for the given query. This function should
    /// only be called as a response to the `WebKitWebView::query-permission-state` signal.
    extern fn webkit_permission_state_query_finish(p_query: *PermissionStateQuery, p_state: webkit.PermissionState) void;
    pub const finish = webkit_permission_state_query_finish;

    /// Get the permission name for which access is being queried.
    extern fn webkit_permission_state_query_get_name(p_query: *PermissionStateQuery) [*:0]const u8;
    pub const getName = webkit_permission_state_query_get_name;

    /// Get the permission origin for which access is being queried.
    extern fn webkit_permission_state_query_get_security_origin(p_query: *PermissionStateQuery) *webkit.SecurityOrigin;
    pub const getSecurityOrigin = webkit_permission_state_query_get_security_origin;

    /// Atomically increments the reference count of `query` by one.
    ///
    /// This function is MT-safe and may be called from any thread.
    extern fn webkit_permission_state_query_ref(p_query: *PermissionStateQuery) *webkit.PermissionStateQuery;
    pub const ref = webkit_permission_state_query_ref;

    /// Atomically decrements the reference count of `query` by one.
    ///
    /// If the reference count drops to 0, all memory allocated by `webkit.PermissionStateQuery` is
    /// released. This function is MT-safe and may be called from any thread.
    extern fn webkit_permission_state_query_unref(p_query: *PermissionStateQuery) void;
    pub const unref = webkit_permission_state_query_unref;

    extern fn webkit_permission_state_query_get_type() usize;
    pub const getGObjectType = webkit_permission_state_query_get_type;
};

pub const PointerLockPermissionRequestClass = extern struct {
    pub const Instance = webkit.PointerLockPermissionRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *PointerLockPermissionRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const PolicyDecisionClass = extern struct {
    pub const Instance = webkit.PolicyDecision;

    f_parent_class: gobject.ObjectClass,
    f__webkit_reserved0: ?*const fn () callconv(.C) void,
    f__webkit_reserved1: ?*const fn () callconv(.C) void,
    f__webkit_reserved2: ?*const fn () callconv(.C) void,
    f__webkit_reserved3: ?*const fn () callconv(.C) void,
    f__webkit_reserved4: ?*const fn () callconv(.C) void,
    f__webkit_reserved5: ?*const fn () callconv(.C) void,
    f__webkit_reserved6: ?*const fn () callconv(.C) void,
    f__webkit_reserved7: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *PolicyDecisionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const PolicyDecisionPrivate = opaque {};

pub const PrintOperationClass = extern struct {
    pub const Instance = webkit.PrintOperation;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *PrintOperationClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ResponsePolicyDecisionClass = extern struct {
    pub const Instance = webkit.ResponsePolicyDecision;

    f_parent_class: webkit.PolicyDecisionClass,

    pub fn as(p_instance: *ResponsePolicyDecisionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Carries details to be shown in user-facing dialogs.
pub const ScriptDialog = opaque {
    /// Close `dialog`.
    ///
    /// When handling a `webkit.ScriptDialog` asynchronously (`webkit.ScriptDialog.ref`
    /// was called in `webkit.WebView.signals.script`-dialog callback), this function needs to be called to notify
    /// that we are done with the script dialog. The dialog will be closed on destruction if this function
    /// hasn't been called before.
    extern fn webkit_script_dialog_close(p_dialog: *ScriptDialog) void;
    pub const close = webkit_script_dialog_close;

    /// Set whether the user confirmed the dialog.
    ///
    /// This method is used for `WEBKIT_SCRIPT_DIALOG_CONFIRM` and `WEBKIT_SCRIPT_DIALOG_BEFORE_UNLOAD_CONFIRM` dialogs when
    /// `webkit.WebView.signals.script`-dialog signal is emitted to set whether the user
    /// confirmed the dialog or not. The default implementation of `webkit.WebView.signals.script`-dialog
    /// signal sets `TRUE` when the OK or Stay buttons are clicked and `FALSE` otherwise.
    /// It's an error to use this method with a `webkit.ScriptDialog` that is not of type
    /// `WEBKIT_SCRIPT_DIALOG_CONFIRM` or `WEBKIT_SCRIPT_DIALOG_BEFORE_UNLOAD_CONFIRM`
    extern fn webkit_script_dialog_confirm_set_confirmed(p_dialog: *ScriptDialog, p_confirmed: c_int) void;
    pub const confirmSetConfirmed = webkit_script_dialog_confirm_set_confirmed;

    /// Get the dialog type of a `webkit.ScriptDialog`.
    extern fn webkit_script_dialog_get_dialog_type(p_dialog: *ScriptDialog) webkit.ScriptDialogType;
    pub const getDialogType = webkit_script_dialog_get_dialog_type;

    /// Get the message of a `webkit.ScriptDialog`.
    extern fn webkit_script_dialog_get_message(p_dialog: *ScriptDialog) [*:0]const u8;
    pub const getMessage = webkit_script_dialog_get_message;

    /// Get the default text of a `webkit.ScriptDialog` of type `WEBKIT_SCRIPT_DIALOG_PROMPT`.
    ///
    /// It's an error to use this method with a `webkit.ScriptDialog` that is not of type
    /// `WEBKIT_SCRIPT_DIALOG_PROMPT`.
    extern fn webkit_script_dialog_prompt_get_default_text(p_dialog: *ScriptDialog) [*:0]const u8;
    pub const promptGetDefaultText = webkit_script_dialog_prompt_get_default_text;

    /// Set the text entered by the user in the dialog.
    ///
    /// This method is used for `WEBKIT_SCRIPT_DIALOG_PROMPT` dialogs when
    /// `webkit.WebView.signals.script`-dialog signal is emitted to set the text
    /// entered by the user. The default implementation of `webkit.WebView.signals.script`-dialog
    /// signal sets the text of the entry form when OK button is clicked, otherwise `NULL` is set.
    /// It's an error to use this method with a `webkit.ScriptDialog` that is not of type
    /// `WEBKIT_SCRIPT_DIALOG_PROMPT`.
    extern fn webkit_script_dialog_prompt_set_text(p_dialog: *ScriptDialog, p_text: [*:0]const u8) void;
    pub const promptSetText = webkit_script_dialog_prompt_set_text;

    /// Atomically increments the reference count of `dialog` by one.
    ///
    /// This
    /// function is MT-safe and may be called from any thread.
    extern fn webkit_script_dialog_ref(p_dialog: *ScriptDialog) *webkit.ScriptDialog;
    pub const ref = webkit_script_dialog_ref;

    /// Atomically decrements the reference count of `dialog` by one.
    ///
    /// If the
    /// reference count drops to 0, all memory allocated by the `WebKitScriptdialog` is
    /// released. This function is MT-safe and may be called from any
    /// thread.
    extern fn webkit_script_dialog_unref(p_dialog: *ScriptDialog) void;
    pub const unref = webkit_script_dialog_unref;

    extern fn webkit_script_dialog_get_type() usize;
    pub const getGObjectType = webkit_script_dialog_get_type;
};

/// A reply for a script message received.
/// If no reply has been sent by the user, an automatically generated reply with
/// undefined value with be sent.
pub const ScriptMessageReply = opaque {
    /// Atomically increments the reference count of `script_message_reply` by one.
    extern fn webkit_script_message_reply_ref(p_script_message_reply: *ScriptMessageReply) *webkit.ScriptMessageReply;
    pub const ref = webkit_script_message_reply_ref;

    /// Reply to a script message with an error message.
    extern fn webkit_script_message_reply_return_error_message(p_script_message_reply: *ScriptMessageReply, p_error_message: [*:0]const u8) void;
    pub const returnErrorMessage = webkit_script_message_reply_return_error_message;

    /// Reply to a script message with a value.
    ///
    /// This function can be called twice for passing the reply value in.
    extern fn webkit_script_message_reply_return_value(p_script_message_reply: *ScriptMessageReply, p_reply_value: *javascriptcore.Value) void;
    pub const returnValue = webkit_script_message_reply_return_value;

    /// Atomically decrements the reference count of `script_message_reply` by one.
    ///
    /// If the reference count drops to 0, all the memory allocated by the
    /// `webkit.ScriptMessageReply` is released. This function is MT-safe and may
    /// be called from any thread.
    extern fn webkit_script_message_reply_unref(p_script_message_reply: *ScriptMessageReply) void;
    pub const unref = webkit_script_message_reply_unref;

    extern fn webkit_script_message_reply_get_type() usize;
    pub const getGObjectType = webkit_script_message_reply_get_type;
};

pub const SecurityManagerClass = extern struct {
    pub const Instance = webkit.SecurityManager;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *SecurityManagerClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A security boundary for websites.
///
/// `webkit.SecurityOrigin` is a representation of a security domain
/// defined by websites. A security origin consists of a protocol, a
/// hostname, and an optional port number.
///
/// Resources with the same security origin can generally access each
/// other for client-side scripting or database access. When comparing
/// origins, beware that if both protocol and host are `NULL`, the origins
/// should not be treated as equal.
pub const SecurityOrigin = opaque {
    /// Create a new security origin from the provided protocol, host and
    /// port.
    extern fn webkit_security_origin_new(p_protocol: [*:0]const u8, p_host: [*:0]const u8, p_port: u16) *webkit.SecurityOrigin;
    pub const new = webkit_security_origin_new;

    /// Create a new security origin from the provided.
    ///
    /// Create a new security origin from the provided URI. Components of
    /// `uri` other than protocol, host, and port do not affect the created
    /// `webkit.SecurityOrigin`.
    extern fn webkit_security_origin_new_for_uri(p_uri: [*:0]const u8) *webkit.SecurityOrigin;
    pub const newForUri = webkit_security_origin_new_for_uri;

    /// Gets the hostname of `origin`.
    ///
    /// It is reasonable for this to be `NULL`
    /// if its protocol does not require a host component.
    extern fn webkit_security_origin_get_host(p_origin: *SecurityOrigin) ?[*:0]const u8;
    pub const getHost = webkit_security_origin_get_host;

    /// Gets the port of `origin`.
    ///
    /// This function will always return 0 if the
    /// port is the default port for the given protocol. For example,
    /// http://example.com has the same security origin as
    /// http://example.com:80, and this function will return 0 for a
    /// `webkit.SecurityOrigin` constructed from either URI.
    extern fn webkit_security_origin_get_port(p_origin: *SecurityOrigin) u16;
    pub const getPort = webkit_security_origin_get_port;

    /// Gets the protocol of `origin`.
    extern fn webkit_security_origin_get_protocol(p_origin: *SecurityOrigin) ?[*:0]const u8;
    pub const getProtocol = webkit_security_origin_get_protocol;

    /// Atomically increments the reference count of `origin` by one.
    ///
    /// This function is MT-safe and may be called from any thread.
    extern fn webkit_security_origin_ref(p_origin: *SecurityOrigin) *webkit.SecurityOrigin;
    pub const ref = webkit_security_origin_ref;

    /// Gets a string representation of `origin`.
    ///
    /// The string representation
    /// is a valid URI with only protocol, host, and port components, or
    /// `NULL`.
    extern fn webkit_security_origin_to_string(p_origin: *SecurityOrigin) ?[*:0]u8;
    pub const toString = webkit_security_origin_to_string;

    /// Atomically decrements the reference count of `origin` by one.
    ///
    /// If the reference count drops to 0, all memory allocated by
    /// `webkit.SecurityOrigin` is released. This function is MT-safe and may be
    /// called from any thread.
    extern fn webkit_security_origin_unref(p_origin: *SecurityOrigin) void;
    pub const unref = webkit_security_origin_unref;

    extern fn webkit_security_origin_get_type() usize;
    pub const getGObjectType = webkit_security_origin_get_type;
};

pub const SettingsClass = extern struct {
    pub const Instance = webkit.Settings;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *SettingsClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const URIRequestClass = extern struct {
    pub const Instance = webkit.URIRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *URIRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const URIResponseClass = extern struct {
    pub const Instance = webkit.URIResponse;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *URIResponseClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const URISchemeRequestClass = extern struct {
    pub const Instance = webkit.URISchemeRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *URISchemeRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const URISchemeResponseClass = extern struct {
    pub const Instance = webkit.URISchemeResponse;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *URISchemeResponseClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A compiled set of rules which applied to resource loads.
pub const UserContentFilter = opaque {
    /// Obtain the identifier previously used to save the `user_content_filter`.
    ///
    /// Obtain the identifier previously used to save the `user_content_filter` in the
    /// `webkit.UserContentFilterStore`.
    extern fn webkit_user_content_filter_get_identifier(p_user_content_filter: *UserContentFilter) [*:0]const u8;
    pub const getIdentifier = webkit_user_content_filter_get_identifier;

    /// Atomically increments the reference count of `user_content_filter` by one.
    ///
    /// This function is MT-safe and may be called from any thread.
    extern fn webkit_user_content_filter_ref(p_user_content_filter: *UserContentFilter) *webkit.UserContentFilter;
    pub const ref = webkit_user_content_filter_ref;

    /// Atomically decrements the reference count of `user_content_filter` by one.
    ///
    /// If the reference count drops to 0, all the memory allocated by the
    /// `webkit.UserContentFilter` is released. This function is MT-safe and may
    /// be called from any thread.
    extern fn webkit_user_content_filter_unref(p_user_content_filter: *UserContentFilter) void;
    pub const unref = webkit_user_content_filter_unref;

    extern fn webkit_user_content_filter_get_type() usize;
    pub const getGObjectType = webkit_user_content_filter_get_type;
};

pub const UserContentFilterStoreClass = extern struct {
    pub const Instance = webkit.UserContentFilterStore;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *UserContentFilterStoreClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const UserContentManagerClass = extern struct {
    pub const Instance = webkit.UserContentManager;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *UserContentManagerClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const UserMediaPermissionRequestClass = extern struct {
    pub const Instance = webkit.UserMediaPermissionRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *UserMediaPermissionRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const UserMessageClass = extern struct {
    pub const Instance = webkit.UserMessage;

    f_parent_class: gobject.InitiallyUnownedClass,

    pub fn as(p_instance: *UserMessageClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A JavaScript snippet which can be injected in loaded pages.
pub const UserScript = opaque {
    /// Creates a new user script.
    ///
    /// Scripts can be applied to some URIs
    /// only by passing non-null values for `allow_list` or `block_list`. Passing a
    /// `NULL` allow_list implies that all URIs are on the allow_list. The script
    /// is applied if an URI matches the allow_list and not the block_list.
    /// URI patterns must be of the form `[protocol]://[host]/[path]`, where the
    /// *host* and *path* components can contain the wildcard character (`*`) to
    /// represent zero or more other characters.
    extern fn webkit_user_script_new(p_source: [*:0]const u8, p_injected_frames: webkit.UserContentInjectedFrames, p_injection_time: webkit.UserScriptInjectionTime, p_allow_list: ?[*]const [*:0]const u8, p_block_list: ?[*]const [*:0]const u8) *webkit.UserScript;
    pub const new = webkit_user_script_new;

    /// Creates a new user script for script world with name `world_name`.
    ///
    /// See `webkit.UserScript.new` for a full description.
    extern fn webkit_user_script_new_for_world(p_source: [*:0]const u8, p_injected_frames: webkit.UserContentInjectedFrames, p_injection_time: webkit.UserScriptInjectionTime, p_world_name: [*:0]const u8, p_allow_list: ?[*]const [*:0]const u8, p_block_list: ?[*]const [*:0]const u8) *webkit.UserScript;
    pub const newForWorld = webkit_user_script_new_for_world;

    /// Atomically increments the reference count of `user_script` by one.
    ///
    /// This function is MT-safe and may be called from any thread.
    extern fn webkit_user_script_ref(p_user_script: *UserScript) *webkit.UserScript;
    pub const ref = webkit_user_script_ref;

    /// Atomically decrements the reference count of `user_script` by one.
    ///
    /// If the reference count drops to 0, all memory allocated by
    /// `webkit.UserScript` is released. This function is MT-safe and may be called
    /// from any thread.
    extern fn webkit_user_script_unref(p_user_script: *UserScript) void;
    pub const unref = webkit_user_script_unref;

    extern fn webkit_user_script_get_type() usize;
    pub const getGObjectType = webkit_user_script_get_type;
};

/// A CSS style sheet which can be injected in loaded pages.
pub const UserStyleSheet = opaque {
    /// Creates a new user style sheet.
    ///
    /// Style sheets can be applied to some URIs
    /// only by passing non-null values for `allow_list` or `block_list`. Passing a
    /// `NULL` allow_list implies that all URIs are on the allow_list. The style
    /// sheet is applied if an URI matches the allow_list and not the block_list.
    /// URI patterns must be of the form `[protocol]://[host]/[path]`, where the
    /// *host* and *path* components can contain the wildcard character (`*`) to
    /// represent zero or more other characters.
    extern fn webkit_user_style_sheet_new(p_source: [*:0]const u8, p_injected_frames: webkit.UserContentInjectedFrames, p_level: webkit.UserStyleLevel, p_allow_list: ?[*]const [*:0]const u8, p_block_list: ?[*]const [*:0]const u8) *webkit.UserStyleSheet;
    pub const new = webkit_user_style_sheet_new;

    /// Creates a new user style sheet for script world.
    ///
    /// Creates a new user style sheet for script world with name `world_name`.
    /// See `webkit.UserStyleSheet.new` for a full description.
    extern fn webkit_user_style_sheet_new_for_world(p_source: [*:0]const u8, p_injected_frames: webkit.UserContentInjectedFrames, p_level: webkit.UserStyleLevel, p_world_name: [*:0]const u8, p_allow_list: ?[*]const [*:0]const u8, p_block_list: ?[*]const [*:0]const u8) *webkit.UserStyleSheet;
    pub const newForWorld = webkit_user_style_sheet_new_for_world;

    /// Atomically increments the reference count of `user_style_sheet` by one.
    ///
    /// This function is MT-safe and may be called from any thread.
    extern fn webkit_user_style_sheet_ref(p_user_style_sheet: *UserStyleSheet) *webkit.UserStyleSheet;
    pub const ref = webkit_user_style_sheet_ref;

    /// Atomically decrements the reference count of `user_style_sheet` by one.
    ///
    /// If the reference count drops to 0, all memory allocated by
    /// `webkit.UserStyleSheet` is released. This function is MT-safe and may be
    /// called from any thread.
    extern fn webkit_user_style_sheet_unref(p_user_style_sheet: *UserStyleSheet) void;
    pub const unref = webkit_user_style_sheet_unref;

    extern fn webkit_user_style_sheet_get_type() usize;
    pub const getGObjectType = webkit_user_style_sheet_get_type;
};

pub const WebContextClass = extern struct {
    pub const Instance = webkit.WebContext;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebContextClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebInspectorClass = extern struct {
    pub const Instance = webkit.WebInspector;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebInspectorClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebResourceClass = extern struct {
    pub const Instance = webkit.WebResource;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebResourceClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebViewBaseClass = extern struct {
    pub const Instance = webkit.WebViewBase;

    f_parentClass: gtk.WidgetClass,
    f__webkit_reserved0: ?*const fn () callconv(.C) void,
    f__webkit_reserved1: ?*const fn () callconv(.C) void,
    f__webkit_reserved2: ?*const fn () callconv(.C) void,
    f__webkit_reserved3: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *WebViewBaseClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebViewBasePrivate = opaque {};

pub const WebViewClass = extern struct {
    pub const Instance = webkit.WebView;

    f_parent: webkit.WebViewBaseClass,
    f_load_changed: ?*const fn (p_web_view: *webkit.WebView, p_load_event: webkit.LoadEvent) callconv(.C) void,
    f_load_failed: ?*const fn (p_web_view: *webkit.WebView, p_load_event: webkit.LoadEvent, p_failing_uri: [*:0]const u8, p_error: *glib.Error) callconv(.C) c_int,
    f_create: ?*const fn (p_web_view: *webkit.WebView, p_navigation_action: *webkit.NavigationAction) callconv(.C) *gtk.Widget,
    f_ready_to_show: ?*const fn (p_web_view: *webkit.WebView) callconv(.C) void,
    f_run_as_modal: ?*const fn (p_web_view: *webkit.WebView) callconv(.C) void,
    f_close: ?*const fn (p_web_view: *webkit.WebView) callconv(.C) void,
    f_script_dialog: ?*const fn (p_web_view: *webkit.WebView, p_dialog: *webkit.ScriptDialog) callconv(.C) c_int,
    f_decide_policy: ?*const fn (p_web_view: *webkit.WebView, p_decision: *webkit.PolicyDecision, p_type: webkit.PolicyDecisionType) callconv(.C) c_int,
    f_permission_request: ?*const fn (p_web_view: *webkit.WebView, p_permission_request: *webkit.PermissionRequest) callconv(.C) c_int,
    f_mouse_target_changed: ?*const fn (p_web_view: *webkit.WebView, p_hit_test_result: *webkit.HitTestResult, p_modifiers: c_uint) callconv(.C) void,
    f_print: ?*const fn (p_web_view: *webkit.WebView, p_print_operation: *webkit.PrintOperation) callconv(.C) c_int,
    f_resource_load_started: ?*const fn (p_web_view: *webkit.WebView, p_resource: *webkit.WebResource, p_request: *webkit.URIRequest) callconv(.C) void,
    f_enter_fullscreen: ?*const fn (p_web_view: *webkit.WebView) callconv(.C) c_int,
    f_leave_fullscreen: ?*const fn (p_web_view: *webkit.WebView) callconv(.C) c_int,
    f_run_file_chooser: ?*const fn (p_web_view: *webkit.WebView, p_request: *webkit.FileChooserRequest) callconv(.C) c_int,
    f_context_menu: ?*const fn (p_web_view: *webkit.WebView, p_context_menu: *webkit.ContextMenu, p_hit_test_result: *webkit.HitTestResult) callconv(.C) c_int,
    f_context_menu_dismissed: ?*const fn (p_web_view: *webkit.WebView) callconv(.C) void,
    f_submit_form: ?*const fn (p_web_view: *webkit.WebView, p_request: *webkit.FormSubmissionRequest) callconv(.C) void,
    f_insecure_content_detected: ?*const fn (p_web_view: *webkit.WebView, p_event: webkit.InsecureContentEvent) callconv(.C) void,
    f_web_process_crashed: ?*const fn (p_web_view: *webkit.WebView) callconv(.C) c_int,
    f_authenticate: ?*const fn (p_web_view: *webkit.WebView, p_request: *webkit.AuthenticationRequest) callconv(.C) c_int,
    f_load_failed_with_tls_errors: ?*const fn (p_web_view: *webkit.WebView, p_failing_uri: [*:0]const u8, p_certificate: *gio.TlsCertificate, p_errors: gio.TlsCertificateFlags) callconv(.C) c_int,
    f_show_notification: ?*const fn (p_web_view: *webkit.WebView, p_notification: *webkit.Notification) callconv(.C) c_int,
    f_run_color_chooser: ?*const fn (p_web_view: *webkit.WebView, p_request: *webkit.ColorChooserRequest) callconv(.C) c_int,
    f_show_option_menu: ?*const fn (p_web_view: *webkit.WebView, p_menu: *webkit.OptionMenu, p_rectangle: *gdk.Rectangle) callconv(.C) c_int,
    f_web_process_terminated: ?*const fn (p_web_view: *webkit.WebView, p_reason: webkit.WebProcessTerminationReason) callconv(.C) void,
    f_user_message_received: ?*const fn (p_web_view: *webkit.WebView, p_message: *webkit.UserMessage) callconv(.C) c_int,
    f_query_permission_state: ?*const fn (p_web_view: *webkit.WebView, p_query: *webkit.PermissionStateQuery) callconv(.C) c_int,
    f__webkit_reserved0: ?*const fn () callconv(.C) void,
    f__webkit_reserved1: ?*const fn () callconv(.C) void,
    f__webkit_reserved2: ?*const fn () callconv(.C) void,
    f__webkit_reserved3: ?*const fn () callconv(.C) void,
    f__webkit_reserved4: ?*const fn () callconv(.C) void,
    f__webkit_reserved5: ?*const fn () callconv(.C) void,
    f__webkit_reserved6: ?*const fn () callconv(.C) void,
    f__webkit_reserved7: ?*const fn () callconv(.C) void,
    f__webkit_reserved8: ?*const fn () callconv(.C) void,
    f__webkit_reserved9: ?*const fn () callconv(.C) void,
    f__webkit_reserved10: ?*const fn () callconv(.C) void,
    f__webkit_reserved11: ?*const fn () callconv(.C) void,
    f__webkit_reserved12: ?*const fn () callconv(.C) void,
    f__webkit_reserved13: ?*const fn () callconv(.C) void,
    f__webkit_reserved14: ?*const fn () callconv(.C) void,
    f__webkit_reserved15: ?*const fn () callconv(.C) void,
    f__webkit_reserved16: ?*const fn () callconv(.C) void,
    f__webkit_reserved17: ?*const fn () callconv(.C) void,
    f__webkit_reserved18: ?*const fn () callconv(.C) void,
    f__webkit_reserved19: ?*const fn () callconv(.C) void,
    f__webkit_reserved20: ?*const fn () callconv(.C) void,
    f__webkit_reserved21: ?*const fn () callconv(.C) void,
    f__webkit_reserved22: ?*const fn () callconv(.C) void,
    f__webkit_reserved23: ?*const fn () callconv(.C) void,
    f__webkit_reserved24: ?*const fn () callconv(.C) void,
    f__webkit_reserved25: ?*const fn () callconv(.C) void,
    f__webkit_reserved26: ?*const fn () callconv(.C) void,
    f__webkit_reserved27: ?*const fn () callconv(.C) void,
    f__webkit_reserved28: ?*const fn () callconv(.C) void,
    f__webkit_reserved29: ?*const fn () callconv(.C) void,
    f__webkit_reserved30: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *WebViewClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebViewPrivate = opaque {};

/// Handles serialization of a web view's browsing state.
pub const WebViewSessionState = opaque {
    /// Creates a new `webkit.WebViewSessionState` from serialized data.
    extern fn webkit_web_view_session_state_new(p_data: *glib.Bytes) *webkit.WebViewSessionState;
    pub const new = webkit_web_view_session_state_new;

    /// Atomically increments the reference count of `state` by one.
    ///
    /// This
    /// function is MT-safe and may be called from any thread.
    extern fn webkit_web_view_session_state_ref(p_state: *WebViewSessionState) *webkit.WebViewSessionState;
    pub const ref = webkit_web_view_session_state_ref;

    /// Serializes a `webkit.WebViewSessionState`.
    extern fn webkit_web_view_session_state_serialize(p_state: *WebViewSessionState) *glib.Bytes;
    pub const serialize = webkit_web_view_session_state_serialize;

    /// Atomically decrements the reference count of `state` by one.
    ///
    /// If the
    /// reference count drops to 0, all memory allocated by the `webkit.WebViewSessionState` is
    /// released. This function is MT-safe and may be called from any thread.
    extern fn webkit_web_view_session_state_unref(p_state: *WebViewSessionState) void;
    pub const unref = webkit_web_view_session_state_unref;

    extern fn webkit_web_view_session_state_get_type() usize;
    pub const getGObjectType = webkit_web_view_session_state_get_type;
};

/// Data stored locally by a web site.
///
/// WebKitWebsiteData represents data stored in the client by a particular website.
/// A website is normally a set of URLs grouped by domain name. You can get the website name,
/// which is usually the domain, with `webkit.WebsiteData.getName`.
/// Documents loaded from the file system, like file:// URIs, are all grouped in the same WebKitWebsiteData
/// with the name "Local files".
///
/// A website can store different types of data in the client side. `webkit.WebsiteDataTypes` is an enum containing
/// all the possible data types; use `webkit.WebsiteData.getTypes` to get the bitmask of data types.
/// It's also possible to know the size of the data stored for some of the `webkit.WebsiteDataTypes` by using
/// `webkit.WebsiteData.getSize`.
///
/// A list of WebKitWebsiteData can be retrieved with `webkit.WebsiteDataManager.fetch`. See `webkit.WebsiteDataManager`
/// for more information.
pub const WebsiteData = opaque {
    /// Gets the name of `webkit.WebsiteData`.
    ///
    /// This is the website name, normally represented by
    /// a domain or host name. All local documents are grouped in the same `webkit.WebsiteData` using
    /// the name "Local files".
    extern fn webkit_website_data_get_name(p_website_data: *WebsiteData) [*:0]const u8;
    pub const getName = webkit_website_data_get_name;

    /// Gets the size of the data of types `types` in a `webkit.WebsiteData`.
    ///
    /// Note that currently the data size is only known for `WEBKIT_WEBSITE_DATA_DISK_CACHE` data type
    /// so for all other types 0 will be returned.
    extern fn webkit_website_data_get_size(p_website_data: *WebsiteData, p_types: webkit.WebsiteDataTypes) u64;
    pub const getSize = webkit_website_data_get_size;

    /// Gets the types of data stored in the client for a `webkit.WebsiteData`.
    ///
    /// These are the
    /// types actually present, not the types queried with `webkit.WebsiteDataManager.fetch`.
    extern fn webkit_website_data_get_types(p_website_data: *WebsiteData) webkit.WebsiteDataTypes;
    pub const getTypes = webkit_website_data_get_types;

    /// Atomically increments the reference count of `website_data` by one.
    ///
    /// This function is MT-safe and may be called from any thread.
    extern fn webkit_website_data_ref(p_website_data: *WebsiteData) *webkit.WebsiteData;
    pub const ref = webkit_website_data_ref;

    /// Atomically decrements the reference count of `website_data` by one.
    ///
    /// If the reference count drops to 0, all memory allocated by
    /// `webkit.WebsiteData` is released. This function is MT-safe and may be
    /// called from any thread.
    extern fn webkit_website_data_unref(p_website_data: *WebsiteData) void;
    pub const unref = webkit_website_data_unref;

    extern fn webkit_website_data_get_type() usize;
    pub const getGObjectType = webkit_website_data_get_type;
};

pub const WebsiteDataAccessPermissionRequestClass = extern struct {
    pub const Instance = webkit.WebsiteDataAccessPermissionRequest;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebsiteDataAccessPermissionRequestClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebsiteDataManagerClass = extern struct {
    pub const Instance = webkit.WebsiteDataManager;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebsiteDataManagerClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WebsitePoliciesClass = extern struct {
    pub const Instance = webkit.WebsitePolicies;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WebsitePoliciesClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const WindowPropertiesClass = extern struct {
    pub const Instance = webkit.WindowProperties;

    f_parent_class: gobject.ObjectClass,

    pub fn as(p_instance: *WindowPropertiesClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Enum values representing the authentication scheme.
pub const AuthenticationScheme = enum(c_int) {
    default = 1,
    http_basic = 2,
    http_digest = 3,
    html_form = 4,
    ntlm = 5,
    negotiate = 6,
    client_certificate_requested = 7,
    server_trust_evaluation_requested = 8,
    client_certificate_pin_requested = 9,
    unknown = 100,
    _,

    extern fn webkit_authentication_scheme_get_type() usize;
    pub const getGObjectType = webkit_authentication_scheme_get_type;
};

/// Enum values used for determining the automation browsing context presentation.
pub const AutomationBrowsingContextPresentation = enum(c_int) {
    window = 0,
    tab = 1,
    _,

    extern fn webkit_automation_browsing_context_presentation_get_type() usize;
    pub const getGObjectType = webkit_automation_browsing_context_presentation_get_type;
};

/// Enum values used to specify autoplay policies.
pub const AutoplayPolicy = enum(c_int) {
    allow = 0,
    allow_without_sound = 1,
    deny = 2,
    _,

    extern fn webkit_autoplay_policy_get_type() usize;
    pub const getGObjectType = webkit_autoplay_policy_get_type;
};

/// Enum values used for determining the `webkit.WebContext` cache model.
pub const CacheModel = enum(c_int) {
    document_viewer = 0,
    web_browser = 1,
    document_browser = 2,
    _,

    extern fn webkit_cache_model_get_type() usize;
    pub const getGObjectType = webkit_cache_model_get_type;
};

/// Enum values used to denote the stock actions for
/// `webkit.ContextMenuItem`<!-- -->s
pub const ContextMenuAction = enum(c_int) {
    no_action = 0,
    open_link = 1,
    open_link_in_new_window = 2,
    download_link_to_disk = 3,
    copy_link_to_clipboard = 4,
    open_image_in_new_window = 5,
    download_image_to_disk = 6,
    copy_image_to_clipboard = 7,
    copy_image_url_to_clipboard = 8,
    open_frame_in_new_window = 9,
    go_back = 10,
    go_forward = 11,
    stop = 12,
    reload = 13,
    copy = 14,
    cut = 15,
    paste = 16,
    delete = 17,
    select_all = 18,
    input_methods = 19,
    unicode = 20,
    spelling_guess = 21,
    no_guesses_found = 22,
    ignore_spelling = 23,
    learn_spelling = 24,
    ignore_grammar = 25,
    font_menu = 26,
    bold = 27,
    italic = 28,
    underline = 29,
    outline = 30,
    inspect_element = 31,
    open_video_in_new_window = 32,
    open_audio_in_new_window = 33,
    copy_video_link_to_clipboard = 34,
    copy_audio_link_to_clipboard = 35,
    toggle_media_controls = 36,
    toggle_media_loop = 37,
    enter_video_fullscreen = 38,
    media_play = 39,
    media_pause = 40,
    media_mute = 41,
    download_video_to_disk = 42,
    download_audio_to_disk = 43,
    insert_emoji = 44,
    paste_as_plain_text = 45,
    custom = 10000,
    _,

    extern fn webkit_context_menu_action_get_type() usize;
    pub const getGObjectType = webkit_context_menu_action_get_type;
};

/// Enum values used to denote the cookie acceptance policies.
pub const CookieAcceptPolicy = enum(c_int) {
    always = 0,
    never = 1,
    no_third_party = 2,
    _,

    extern fn webkit_cookie_accept_policy_get_type() usize;
    pub const getGObjectType = webkit_cookie_accept_policy_get_type;
};

/// Enum values used to denote the cookie persistent storage types.
pub const CookiePersistentStorage = enum(c_int) {
    text = 0,
    sqlite = 1,
    _,

    extern fn webkit_cookie_persistent_storage_get_type() usize;
    pub const getGObjectType = webkit_cookie_persistent_storage_get_type;
};

/// Enum values representing the duration for which a credential persists.
pub const CredentialPersistence = enum(c_int) {
    none = 0,
    for_session = 1,
    permanent = 2,
    _,

    extern fn webkit_credential_persistence_get_type() usize;
    pub const getGObjectType = webkit_credential_persistence_get_type;
};

/// Enum values used to denote the various download errors.
pub const DownloadError = enum(c_int) {
    network = 499,
    cancelled_by_user = 400,
    destination = 401,
    _,

    /// Gets the quark for the domain of download errors.
    extern fn webkit_download_error_quark() glib.Quark;
    pub const quark = webkit_download_error_quark;

    extern fn webkit_download_error_get_type() usize;
    pub const getGObjectType = webkit_download_error_get_type;
};

/// Enum values used to denote the various errors related to the `webkit.FaviconDatabase`.
pub const FaviconDatabaseError = enum(c_int) {
    not_initialized = 0,
    favicon_not_found = 1,
    favicon_unknown = 2,
    _,

    /// Gets the quark for the domain of favicon database errors.
    extern fn webkit_favicon_database_error_quark() glib.Quark;
    pub const quark = webkit_favicon_database_error_quark;

    extern fn webkit_favicon_database_error_get_type() usize;
    pub const getGObjectType = webkit_favicon_database_error_get_type;
};

/// Describes the status of a `WebKitFeature`.
///
/// The status for a given feature can be obtained with
/// `webkit.Feature.getStatus`.
pub const FeatureStatus = enum(c_int) {
    embedder = 0,
    unstable = 1,
    internal = 2,
    developer = 3,
    testable = 4,
    preview = 5,
    stable = 6,
    mature = 7,
    _,

    extern fn webkit_feature_status_get_type() usize;
    pub const getGObjectType = webkit_feature_status_get_type;
};

/// Enum values used for determining the hardware acceleration policy.
pub const HardwareAccelerationPolicy = enum(c_int) {
    always = 0,
    never = 1,
    _,

    extern fn webkit_hardware_acceleration_policy_get_type() usize;
    pub const getGObjectType = webkit_hardware_acceleration_policy_get_type;
};

/// Enum values used to describe the primary purpose of the active editable element.
pub const InputPurpose = enum(c_int) {
    free_form = 0,
    digits = 1,
    number = 2,
    phone = 3,
    url = 4,
    email = 5,
    password = 6,
    _,

    extern fn webkit_input_purpose_get_type() usize;
    pub const getGObjectType = webkit_input_purpose_get_type;
};

/// Enum values previously used to denote the different events which can trigger
/// the detection of insecure content. Since 2.46, WebKit generally no longer
/// loads insecure content in secure contexts.
pub const InsecureContentEvent = enum(c_int) {
    run = 0,
    displayed = 1,
    _,

    extern fn webkit_insecure_content_event_get_type() usize;
    pub const getGObjectType = webkit_insecure_content_event_get_type;
};

/// Enum values used to denote errors happening when executing JavaScript
pub const JavascriptError = enum(c_int) {
    script_failed = 699,
    invalid_parameter = 600,
    invalid_result = 601,
    _,

    /// Gets the quark for the domain of JavaScript errors.
    extern fn webkit_javascript_error_quark() glib.Quark;
    pub const quark = webkit_javascript_error_quark;

    extern fn webkit_javascript_error_get_type() usize;
    pub const getGObjectType = webkit_javascript_error_get_type;
};

/// Enum values used to denote the different events that happen during a
/// `webkit.WebView` load operation.
pub const LoadEvent = enum(c_int) {
    started = 0,
    redirected = 1,
    committed = 2,
    finished = 3,
    _,

    extern fn webkit_load_event_get_type() usize;
    pub const getGObjectType = webkit_load_event_get_type;
};

/// Enum values used to specify the capture state of a media device.
pub const MediaCaptureState = enum(c_int) {
    none = 0,
    active = 1,
    muted = 2,
    _,

    extern fn webkit_media_capture_state_get_type() usize;
    pub const getGObjectType = webkit_media_capture_state_get_type;
};

/// Enum values used to denote the various media errors.
pub const MediaError = enum(c_int) {
    load = 204,
    _,

    /// Gets the quark for the domain of media errors.
    extern fn webkit_media_error_quark() glib.Quark;
    pub const quark = webkit_media_error_quark;

    extern fn webkit_media_error_get_type() usize;
    pub const getGObjectType = webkit_media_error_get_type;
};

/// Enum values used to denote the various navigation types.
pub const NavigationType = enum(c_int) {
    link_clicked = 0,
    form_submitted = 1,
    back_forward = 2,
    reload = 3,
    form_resubmitted = 4,
    other = 5,
    _,

    extern fn webkit_navigation_type_get_type() usize;
    pub const getGObjectType = webkit_navigation_type_get_type;
};

/// Enum values used to denote the various network errors.
pub const NetworkError = enum(c_int) {
    failed = 399,
    transport = 300,
    unknown_protocol = 301,
    cancelled = 302,
    file_does_not_exist = 303,
    _,

    /// Gets the quark for the domain of networking errors.
    extern fn webkit_network_error_quark() glib.Quark;
    pub const quark = webkit_network_error_quark;

    extern fn webkit_network_error_get_type() usize;
    pub const getGObjectType = webkit_network_error_get_type;
};

/// Enum values used to set the network proxy mode.
pub const NetworkProxyMode = enum(c_int) {
    default = 0,
    no_proxy = 1,
    custom = 2,
    _,

    extern fn webkit_network_proxy_mode_get_type() usize;
    pub const getGObjectType = webkit_network_proxy_mode_get_type;
};

/// Enum values representing query permission results.
pub const PermissionState = enum(c_int) {
    granted = 0,
    denied = 1,
    prompt = 2,
    _,

    extern fn webkit_permission_state_get_type() usize;
    pub const getGObjectType = webkit_permission_state_get_type;
};

/// Enum values used for determining the type of a policy decision during
/// `webkit.WebView.signals.decide`-policy.
pub const PolicyDecisionType = enum(c_int) {
    navigation_action = 0,
    new_window_action = 1,
    response = 2,
    _,

    extern fn webkit_policy_decision_type_get_type() usize;
    pub const getGObjectType = webkit_policy_decision_type_get_type;
};

/// Enum values used to denote the various policy errors.
pub const PolicyError = enum(c_int) {
    failed = 199,
    cannot_show_mime_type = 100,
    cannot_show_uri = 101,
    frame_load_interrupted_by_policy_change = 102,
    cannot_use_restricted_port = 103,
    _,

    /// Gets the quark for the domain of policy errors.
    extern fn webkit_policy_error_quark() glib.Quark;
    pub const quark = webkit_policy_error_quark;

    extern fn webkit_policy_error_get_type() usize;
    pub const getGObjectType = webkit_policy_error_get_type;
};

/// Enum values used to denote the various print errors.
pub const PrintError = enum(c_int) {
    general = 599,
    printer_not_found = 500,
    invalid_page_range = 501,
    _,

    /// Gets the quark for the domain of printing errors.
    extern fn webkit_print_error_quark() glib.Quark;
    pub const quark = webkit_print_error_quark;

    extern fn webkit_print_error_get_type() usize;
    pub const getGObjectType = webkit_print_error_get_type;
};

/// Enum values representing the response of the print dialog shown with
/// `webkit.PrintOperation.runDialog`.
pub const PrintOperationResponse = enum(c_int) {
    print = 0,
    cancel = 1,
    _,

    extern fn webkit_print_operation_response_get_type() usize;
    pub const getGObjectType = webkit_print_operation_response_get_type;
};

/// Enum values to specify the different ways in which a `webkit.WebView`
/// can save its current web page into a self-contained file.
pub const SaveMode = enum(c_int) {
    mhtml = 0,
    _,

    extern fn webkit_save_mode_get_type() usize;
    pub const getGObjectType = webkit_save_mode_get_type;
};

/// Enum values used for determining the type of `webkit.ScriptDialog`
pub const ScriptDialogType = enum(c_int) {
    alert = 0,
    confirm = 1,
    prompt = 2,
    before_unload_confirm = 3,
    _,

    extern fn webkit_script_dialog_type_get_type() usize;
    pub const getGObjectType = webkit_script_dialog_type_get_type;
};

/// Enum values used to denote errors happening when creating snapshots of `webkit.WebView`
pub const SnapshotError = enum(c_int) {
    create = 799,
    _,

    /// Gets the quark for the domain of page snapshot errors.
    extern fn webkit_snapshot_error_quark() glib.Quark;
    pub const quark = webkit_snapshot_error_quark;

    extern fn webkit_snapshot_error_get_type() usize;
    pub const getGObjectType = webkit_snapshot_error_get_type;
};

/// Enum values used to specify the region from which to get a `webkit.WebView`
/// snapshot
pub const SnapshotRegion = enum(c_int) {
    visible = 0,
    full_document = 1,
    _,

    extern fn webkit_snapshot_region_get_type() usize;
    pub const getGObjectType = webkit_snapshot_region_get_type;
};

/// Enum values used to denote the TLS errors policy.
pub const TLSErrorsPolicy = enum(c_int) {
    ignore = 0,
    fail = 1,
    _,

    extern fn webkit_tls_errors_policy_get_type() usize;
    pub const getGObjectType = webkit_tls_errors_policy_get_type;
};

/// Errors that can occur while compiling content filters.
pub const UserContentFilterError = enum(c_int) {
    invalid_source = 0,
    not_found = 1,
    _,

    /// Gets the quark for the domain of user content filter errors.
    extern fn webkit_user_content_filter_error_quark() glib.Quark;
    pub const quark = webkit_user_content_filter_error_quark;

    extern fn webkit_user_content_filter_error_get_type() usize;
    pub const getGObjectType = webkit_user_content_filter_error_get_type;
};

/// Specifies in which frames user style sheets are to be inserted in.
pub const UserContentInjectedFrames = enum(c_int) {
    all_frames = 0,
    top_frame = 1,
    _,

    extern fn webkit_user_content_injected_frames_get_type() usize;
    pub const getGObjectType = webkit_user_content_injected_frames_get_type;
};

/// Enum values used to denote errors happening when sending user messages.
pub const UserMessageError = enum(c_int) {
    message = 0,
    _,

    /// Gets the quark for the domain of user message errors.
    extern fn webkit_user_message_error_quark() glib.Quark;
    pub const quark = webkit_user_message_error_quark;

    extern fn webkit_user_message_error_get_type() usize;
    pub const getGObjectType = webkit_user_message_error_get_type;
};

/// Specifies at which place of documents an user script will be inserted.
pub const UserScriptInjectionTime = enum(c_int) {
    start = 0,
    end = 1,
    _,

    extern fn webkit_user_script_injection_time_get_type() usize;
    pub const getGObjectType = webkit_user_script_injection_time_get_type;
};

/// Specifies how to treat an user style sheet.
pub const UserStyleLevel = enum(c_int) {
    user = 0,
    author = 1,
    _,

    extern fn webkit_user_style_level_get_type() usize;
    pub const getGObjectType = webkit_user_style_level_get_type;
};

/// Enum values used for setting if a `webkit.WebView` is intended for
/// WebExtensions.
pub const WebExtensionMode = enum(c_int) {
    none = 0,
    manifestv2 = 1,
    manifestv3 = 2,
    _,

    extern fn webkit_web_extension_mode_get_type() usize;
    pub const getGObjectType = webkit_web_extension_mode_get_type;
};

/// Enum values used to specify the reason why the web process terminated abnormally.
pub const WebProcessTerminationReason = enum(c_int) {
    crashed = 0,
    exceeded_memory_limit = 1,
    terminated_by_api = 2,
    _,

    extern fn webkit_web_process_termination_reason_get_type() usize;
    pub const getGObjectType = webkit_web_process_termination_reason_get_type;
};

/// Enum values with flags representing typing attributes.
pub const EditorTypingAttributes = packed struct(c_uint) {
    _padding0: bool = false,
    none: bool = false,
    bold: bool = false,
    italic: bool = false,
    underline: bool = false,
    strikethrough: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: EditorTypingAttributes = @bitCast(@as(c_uint, 2));
    const flags_bold: EditorTypingAttributes = @bitCast(@as(c_uint, 4));
    const flags_italic: EditorTypingAttributes = @bitCast(@as(c_uint, 8));
    const flags_underline: EditorTypingAttributes = @bitCast(@as(c_uint, 16));
    const flags_strikethrough: EditorTypingAttributes = @bitCast(@as(c_uint, 32));
    extern fn webkit_editor_typing_attributes_get_type() usize;
    pub const getGObjectType = webkit_editor_typing_attributes_get_type;
};

/// Enum values used to specify search options.
pub const FindOptions = packed struct(c_uint) {
    case_insensitive: bool = false,
    at_word_starts: bool = false,
    treat_medial_capital_as_word_start: bool = false,
    backwards: bool = false,
    wrap_around: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: FindOptions = @bitCast(@as(c_uint, 0));
    const flags_case_insensitive: FindOptions = @bitCast(@as(c_uint, 1));
    const flags_at_word_starts: FindOptions = @bitCast(@as(c_uint, 2));
    const flags_treat_medial_capital_as_word_start: FindOptions = @bitCast(@as(c_uint, 4));
    const flags_backwards: FindOptions = @bitCast(@as(c_uint, 8));
    const flags_wrap_around: FindOptions = @bitCast(@as(c_uint, 16));
    extern fn webkit_find_options_get_type() usize;
    pub const getGObjectType = webkit_find_options_get_type;
};

/// Enum values with flags representing the context of a `webkit.HitTestResult`.
pub const HitTestResultContext = packed struct(c_uint) {
    _padding0: bool = false,
    document: bool = false,
    link: bool = false,
    image: bool = false,
    media: bool = false,
    editable: bool = false,
    scrollbar: bool = false,
    selection: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_document: HitTestResultContext = @bitCast(@as(c_uint, 2));
    const flags_link: HitTestResultContext = @bitCast(@as(c_uint, 4));
    const flags_image: HitTestResultContext = @bitCast(@as(c_uint, 8));
    const flags_media: HitTestResultContext = @bitCast(@as(c_uint, 16));
    const flags_editable: HitTestResultContext = @bitCast(@as(c_uint, 32));
    const flags_scrollbar: HitTestResultContext = @bitCast(@as(c_uint, 64));
    const flags_selection: HitTestResultContext = @bitCast(@as(c_uint, 128));
    extern fn webkit_hit_test_result_context_get_type() usize;
    pub const getGObjectType = webkit_hit_test_result_context_get_type;
};

/// Enum values used to describe hints that might be taken into account by input methods.
pub const InputHints = packed struct(c_uint) {
    spellcheck: bool = false,
    lowercase: bool = false,
    uppercase_chars: bool = false,
    uppercase_words: bool = false,
    uppercase_sentences: bool = false,
    inhibit_osk: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: InputHints = @bitCast(@as(c_uint, 0));
    const flags_spellcheck: InputHints = @bitCast(@as(c_uint, 1));
    const flags_lowercase: InputHints = @bitCast(@as(c_uint, 2));
    const flags_uppercase_chars: InputHints = @bitCast(@as(c_uint, 4));
    const flags_uppercase_words: InputHints = @bitCast(@as(c_uint, 8));
    const flags_uppercase_sentences: InputHints = @bitCast(@as(c_uint, 16));
    const flags_inhibit_osk: InputHints = @bitCast(@as(c_uint, 32));
    extern fn webkit_input_hints_get_type() usize;
    pub const getGObjectType = webkit_input_hints_get_type;
};

/// Enum values used to specify options when taking a snapshot
/// from a `webkit.WebView`.
pub const SnapshotOptions = packed struct(c_uint) {
    include_selection_highlighting: bool = false,
    transparent_background: bool = false,
    _padding2: bool = false,
    _padding3: bool = false,
    _padding4: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: SnapshotOptions = @bitCast(@as(c_uint, 0));
    const flags_include_selection_highlighting: SnapshotOptions = @bitCast(@as(c_uint, 1));
    const flags_transparent_background: SnapshotOptions = @bitCast(@as(c_uint, 2));
    extern fn webkit_snapshot_options_get_type() usize;
    pub const getGObjectType = webkit_snapshot_options_get_type;
};

/// Enum values with flags representing types of Website data.
pub const WebsiteDataTypes = packed struct(c_uint) {
    memory_cache: bool = false,
    disk_cache: bool = false,
    offline_application_cache: bool = false,
    session_storage: bool = false,
    local_storage: bool = false,
    indexeddb_databases: bool = false,
    cookies: bool = false,
    device_id_hash_salt: bool = false,
    hsts_cache: bool = false,
    itp: bool = false,
    service_worker_registrations: bool = false,
    dom_cache: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_memory_cache: WebsiteDataTypes = @bitCast(@as(c_uint, 1));
    const flags_disk_cache: WebsiteDataTypes = @bitCast(@as(c_uint, 2));
    const flags_offline_application_cache: WebsiteDataTypes = @bitCast(@as(c_uint, 4));
    const flags_session_storage: WebsiteDataTypes = @bitCast(@as(c_uint, 8));
    const flags_local_storage: WebsiteDataTypes = @bitCast(@as(c_uint, 16));
    const flags_indexeddb_databases: WebsiteDataTypes = @bitCast(@as(c_uint, 32));
    const flags_cookies: WebsiteDataTypes = @bitCast(@as(c_uint, 64));
    const flags_device_id_hash_salt: WebsiteDataTypes = @bitCast(@as(c_uint, 128));
    const flags_hsts_cache: WebsiteDataTypes = @bitCast(@as(c_uint, 256));
    const flags_itp: WebsiteDataTypes = @bitCast(@as(c_uint, 512));
    const flags_service_worker_registrations: WebsiteDataTypes = @bitCast(@as(c_uint, 1024));
    const flags_dom_cache: WebsiteDataTypes = @bitCast(@as(c_uint, 2048));
    const flags_all: WebsiteDataTypes = @bitCast(@as(c_uint, 4095));
    extern fn webkit_website_data_types_get_type() usize;
    pub const getGObjectType = webkit_website_data_types_get_type;
};

/// Returns the major version number of the WebKit library.
///
/// (e.g. in WebKit version 1.8.3 this is 1.)
///
/// This function is in the library, so it represents the WebKit library
/// your code is running against. Contrast with the `WEBKIT_MAJOR_VERSION`
/// macro, which represents the major version of the WebKit headers you
/// have included when compiling your code.
extern fn webkit_get_major_version() c_uint;
pub const getMajorVersion = webkit_get_major_version;

/// Returns the micro version number of the WebKit library.
///
/// (e.g. in WebKit version 1.8.3 this is 3.)
///
/// This function is in the library, so it represents the WebKit library
/// your code is running against. Contrast with the `WEBKIT_MICRO_VERSION`
/// macro, which represents the micro version of the WebKit headers you
/// have included when compiling your code.
extern fn webkit_get_micro_version() c_uint;
pub const getMicroVersion = webkit_get_micro_version;

/// Returns the minor version number of the WebKit library.
///
/// (e.g. in WebKit version 1.8.3 this is 8.)
///
/// This function is in the library, so it represents the WebKit library
/// your code is running against. Contrast with the `WEBKIT_MINOR_VERSION`
/// macro, which represents the minor version of the WebKit headers you
/// have included when compiling your code.
extern fn webkit_get_minor_version() c_uint;
pub const getMinorVersion = webkit_get_minor_version;

/// Get the key system for which access permission is being requested.
extern fn webkit_media_key_system_permission_get_name(p_request: *webkit.MediaKeySystemPermissionRequest) [*:0]const u8;
pub const mediaKeySystemPermissionGetName = webkit_media_key_system_permission_get_name;

/// Use this function to format a URI for display.
///
/// The URIs used internally by
/// WebKit may contain percent-encoded characters or Punycode, which are not
/// generally suitable to display to users. This function provides protection
/// against IDN homograph attacks, so in some cases the host part of the returned
/// URI may be in Punycode if the safety check fails.
extern fn webkit_uri_for_display(p_uri: [*:0]const u8) ?[*:0]u8;
pub const uriForDisplay = webkit_uri_for_display;

/// Check whether the permission request is for an audio device.
extern fn webkit_user_media_permission_is_for_audio_device(p_request: *webkit.UserMediaPermissionRequest) c_int;
pub const userMediaPermissionIsForAudioDevice = webkit_user_media_permission_is_for_audio_device;

/// Check whether the permission request is for a display device.
extern fn webkit_user_media_permission_is_for_display_device(p_request: *webkit.UserMediaPermissionRequest) c_int;
pub const userMediaPermissionIsForDisplayDevice = webkit_user_media_permission_is_for_display_device;

/// Check whether the permission request is for a video device.
extern fn webkit_user_media_permission_is_for_video_device(p_request: *webkit.UserMediaPermissionRequest) c_int;
pub const userMediaPermissionIsForVideoDevice = webkit_user_media_permission_is_for_video_device;

/// Type definition for a function that will be called back when an URI request is
/// made for a user registered URI scheme.
pub const URISchemeRequestCallback = *const fn (p_request: *webkit.URISchemeRequest, p_user_data: ?*anyopaque) callconv(.C) void;

/// The copy clipboard command. Copies the current selection inside
/// a `webkit.WebView` to the clipboard.
/// You can check whether it's possible to execute the command with
/// `webkit.WebView.canExecuteEditingCommand`. In general it's
/// possible to copy to the clipboard when there is an active selection
/// inside the `webkit.WebView`.
pub const EDITING_COMMAND_COPY = "Copy";
/// The create link command. Creates a link element that is inserted at
/// the current cursor position. If there's a selection, the selected text
/// will be used as the link text, otherwise the URL itself will be used.
/// It receives the link URL as argument. This command should be executed
/// with `webkit.WebView.executeEditingCommandWithArgument`
pub const EDITING_COMMAND_CREATE_LINK = "CreateLink";
/// The cut clipboard command. Copies the current selection inside
/// a `webkit.WebView` to the clipboard and deletes the selected content.
/// You can check whether it's possible to execute the command with
/// `webkit.WebView.canExecuteEditingCommand`. In general it's
/// possible to cut to the clipboard when the `webkit.WebView` content is
/// editable and there is an active selection.
pub const EDITING_COMMAND_CUT = "Cut";
/// The insert image command. Creates an image element that is inserted at
/// the current cursor position. It receives an URI as argument,
/// that is used as the image source. This command should be executed with
/// `webkit.WebView.executeEditingCommandWithArgument`.
pub const EDITING_COMMAND_INSERT_IMAGE = "InsertImage";
/// The paste clipboard command. Pastes the contents of the clipboard to
/// a `webkit.WebView`.
/// You can check whether it's possible to execute the command with
/// `webkit.WebView.canExecuteEditingCommand`. In general it's possible
/// to paste from the clipboard when the `webkit.WebView` content is editable
/// and clipboard is not empty.
pub const EDITING_COMMAND_PASTE = "Paste";
/// The paste as plaintext clipboard command. Pastes the contents of the
/// clipboard to a `webkit.WebView`, with formatting removed.
/// You can check whether it's possible to execute the command with
/// `webkit.WebView.canExecuteEditingCommand`. In general it's possible
/// to paste from the clipboard when the `webkit.WebView` content is editable
/// and clipboard is not empty.
pub const EDITING_COMMAND_PASTE_AS_PLAIN_TEXT = "PasteAsPlainText";
/// The redo command. Redoes a previously undone editing command in
/// a `webkit.WebView`.
/// You can check whether it's possible to execute the command with
/// `webkit.WebView.canExecuteEditingCommand`. It's only possible
/// to redo a command when it has been previously undone.
pub const EDITING_COMMAND_REDO = "Redo";
/// The select all command. Selects all the content of the current text field in
/// a `webkit.WebView`.
/// It is always possible to select all text, no matter whether the
/// `webkit.WebView` content is editable or not. You can still check it
/// with `webkit.WebView.canExecuteEditingCommand`.
pub const EDITING_COMMAND_SELECT_ALL = "SelectAll";
/// The undo command. Undoes the last editing command in a `webkit.WebView`.
/// You can check whether it's possible to execute the command with
/// `webkit.WebView.canExecuteEditingCommand`. It's only possible
/// to undo a command after a previously executed editing operation.
pub const EDITING_COMMAND_UNDO = "Undo";
/// Like `webkit.getMajorVersion`, but from the headers used at
/// application compile time, rather than from the library linked
/// against at application run time.
pub const MAJOR_VERSION = 2;
/// Like `webkit.getMicroVersion`, but from the headers used at
/// application compile time, rather than from the library linked
/// against at application run time.
pub const MICRO_VERSION = 1;
/// Like `webkit.getMinorVersion`, but from the headers used at
/// application compile time, rather than from the library linked
/// against at application run time.
pub const MINOR_VERSION = 46;
