pub const ext = @import("ext.zig");
const gstanalytics = @This();

const std = @import("std");
const compat = @import("compat");
const gstbase = @import("gstbase1");
const gst = @import("gst1");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
/// Type of analytics meta data
pub const MtdType = usize;

/// Handle containing data required to use gst_analytics_cls_mtd APIs. This type
/// is generally expected to be allocated on the stack.
pub const ClsMtd = extern struct {
    /// Instance identifier.
    f_id: c_uint,
    /// Instance of `gstanalytics.RelationMeta` where the analysis-metadata
    /// identified by `id` is stored.
    f_meta: ?*gstanalytics.RelationMeta,

    /// Get an id identifying `gstanalytics.Mtd` type.
    extern fn gst_analytics_cls_mtd_get_mtd_type() gstanalytics.MtdType;
    pub const getMtdType = gst_analytics_cls_mtd_get_mtd_type;

    extern fn gst_analytics_cls_mtd_get_index_by_quark(p_handle: *ClsMtd, p_quark: glib.Quark) c_int;
    pub const getIndexByQuark = gst_analytics_cls_mtd_get_index_by_quark;

    extern fn gst_analytics_cls_mtd_get_length(p_handle: *ClsMtd) usize;
    pub const getLength = gst_analytics_cls_mtd_get_length;

    /// Get confidence level for class at `index`
    extern fn gst_analytics_cls_mtd_get_level(p_handle: *ClsMtd, p_index: usize) f32;
    pub const getLevel = gst_analytics_cls_mtd_get_level;

    extern fn gst_analytics_cls_mtd_get_quark(p_handle: *ClsMtd, p_index: usize) glib.Quark;
    pub const getQuark = gst_analytics_cls_mtd_get_quark;
};

/// Handle containing data required to use gst_analytics_mtd API. This type
/// is generally expected to be allocated on the stack.
pub const Mtd = extern struct {
    /// Instance identifier.
    f_id: c_uint,
    /// Instance of `gstanalytics.RelationMeta` where the analysis-metadata
    /// identified by `id` is stored.
    f_meta: ?*gstanalytics.RelationMeta,

    /// Gets the string version of the name of this type of analytics data
    extern fn gst_analytics_mtd_type_get_name(p_type: gstanalytics.MtdType) [*:0]const u8;
    pub const typeGetName = gst_analytics_mtd_type_get_name;

    /// Get instance id
    extern fn gst_analytics_mtd_get_id(p_instance: *Mtd) c_uint;
    pub const getId = gst_analytics_mtd_get_id;

    extern fn gst_analytics_mtd_get_mtd_type(p_instance: *Mtd) gstanalytics.MtdType;
    pub const getMtdType = gst_analytics_mtd_get_mtd_type;

    /// Get instance size
    extern fn gst_analytics_mtd_get_size(p_instance: *Mtd) usize;
    pub const getSize = gst_analytics_mtd_get_size;
};

/// This structure must be provided when registering a new type of Mtd. It must
/// have a static lifetime (never be freed).
pub const MtdImpl = extern struct {
    /// The name of the metadata type
    f_name: ?[*:0]const u8,
    /// A pointer to a function that will be called
    /// when the containing meta is transform to potentially copy the data
    /// into a new Mtd into the new meta.
    f_mtd_meta_transform: ?*const fn (p_transbuf: *gst.Buffer, p_transmtd: *gstanalytics.Mtd, p_buffer: *gst.Buffer, p_type: glib.Quark, p_data: *anyopaque) callconv(.C) c_int,
    f__reserved: [20]*anyopaque,
};

/// Handle containing data required to use gst_analytics_od_mtd APIs. This type
/// is generally expected to be allocated on the stack.
pub const ODMtd = extern struct {
    /// Instance identifier.
    f_id: c_uint,
    /// Instance of `gstanalytics.RelationMeta` where the analysis-metadata
    /// identified by `id` is stored.
    f_meta: ?*gstanalytics.RelationMeta,

    /// Get an id that represent object-detection metadata type
    extern fn gst_analytics_od_mtd_get_mtd_type() gstanalytics.MtdType;
    pub const getMtdType = gst_analytics_od_mtd_get_mtd_type;

    /// Retrieve location confidence level.
    extern fn gst_analytics_od_mtd_get_confidence_lvl(p_instance: *ODMtd, p_loc_conf_lvl: *f32) c_int;
    pub const getConfidenceLvl = gst_analytics_od_mtd_get_confidence_lvl;

    /// Retrieve location and location confidence level.
    extern fn gst_analytics_od_mtd_get_location(p_instance: *ODMtd, p_x: *c_int, p_y: *c_int, p_w: *c_int, p_h: *c_int, p_loc_conf_lvl: ?*f32) c_int;
    pub const getLocation = gst_analytics_od_mtd_get_location;

    /// Quark of the class of object associated with this location.
    extern fn gst_analytics_od_mtd_get_obj_type(p_handle: *ODMtd) glib.Quark;
    pub const getObjType = gst_analytics_od_mtd_get_obj_type;
};

/// An opaque `gst.Meta` that can be used to hold various types of results
/// from analysis processes.
///
/// The content should be accessed through the API.
pub const RelationMeta = opaque {
    /// Get the meta info
    extern fn gst_analytics_relation_meta_get_info() *const gst.MetaInfo;
    pub const getInfo = gst_analytics_relation_meta_get_info;

    /// Add analytic classification metadata to `instance`.
    extern fn gst_analytics_relation_meta_add_cls_mtd(p_instance: *RelationMeta, p_length: usize, p_confidence_levels: [*]f32, p_class_quarks: [*]glib.Quark, p_cls_mtd: *gstanalytics.ClsMtd) c_int;
    pub const addClsMtd = gst_analytics_relation_meta_add_cls_mtd;

    /// Add a relatable metadata to `meta`. This method is meant to be used by
    /// new struct sub-classing GstAnalyticsRelatableMtd.
    extern fn gst_analytics_relation_meta_add_mtd(p_meta: *RelationMeta, p_impl: *const gstanalytics.MtdImpl, p_size: usize, p_rlt_mtd: *gstanalytics.Mtd) ?*anyopaque;
    pub const addMtd = gst_analytics_relation_meta_add_mtd;

    extern fn gst_analytics_relation_meta_add_od_mtd(p_instance: *RelationMeta, p_type: glib.Quark, p_x: c_int, p_y: c_int, p_w: c_int, p_h: c_int, p_loc_conf_lvl: f32, p_od_mtd: ?*gstanalytics.ODMtd) c_int;
    pub const addOdMtd = gst_analytics_relation_meta_add_od_mtd;

    /// Add analytic classification metadata to `instance`.
    extern fn gst_analytics_relation_meta_add_one_cls_mtd(p_instance: *RelationMeta, p_confidence_level: f32, p_class_quark: glib.Quark, p_cls_mtd: *gstanalytics.ClsMtd) c_int;
    pub const addOneClsMtd = gst_analytics_relation_meta_add_one_cls_mtd;

    extern fn gst_analytics_relation_meta_add_tracking_mtd(p_instance: *RelationMeta, p_tracking_id: u64, p_tracking_first_seen: gst.ClockTime, p_trk_mtd: *gstanalytics.TrackingMtd) c_int;
    pub const addTrackingMtd = gst_analytics_relation_meta_add_tracking_mtd;

    /// Verify existence of relation(s) between `an_meta_first_d` and
    /// `an_meta_second_id` according to relation condition `cond_types`. It optionally
    /// also return a shortest path of relations ( compliant with `cond_types`)
    /// between `an_meta_first_id` and `an_meta_second_id`.
    extern fn gst_analytics_relation_meta_exist(p_rmeta: *RelationMeta, p_an_meta_first_id: c_uint, p_an_meta_second_id: c_uint, p_max_relation_span: c_int, p_cond_types: gstanalytics.RelTypes, p_relations_path: ?**glib.Array) c_int;
    pub const exist = gst_analytics_relation_meta_exist;

    /// Fill `rlt` if a analytics-meta with id == `an_meta_id` exist in `meta` instance,
    /// otherwise this method return FALSE and `rlt` is invalid.
    extern fn gst_analytics_relation_meta_get_cls_mtd(p_meta: *RelationMeta, p_an_meta_id: c_uint, p_rlt: *gstanalytics.ClsMtd) c_int;
    pub const getClsMtd = gst_analytics_relation_meta_get_cls_mtd;

    extern fn gst_analytics_relation_meta_get_direct_related(p_meta: *RelationMeta, p_an_meta_id: c_uint, p_relation_type: gstanalytics.RelTypes, p_type: gstanalytics.MtdType, p_state: *anyopaque, p_rlt_mtd: *gstanalytics.Mtd) c_int;
    pub const getDirectRelated = gst_analytics_relation_meta_get_direct_related;

    /// Fill `rlt` if a analytics-meta with id == `an_meta_id` exist in `meta` instance,
    /// otherwise this method return FALSE and `rlt` is invalid.
    extern fn gst_analytics_relation_meta_get_mtd(p_meta: *RelationMeta, p_an_meta_id: c_uint, p_type: gstanalytics.MtdType, p_rlt: *gstanalytics.Mtd) c_int;
    pub const getMtd = gst_analytics_relation_meta_get_mtd;

    extern fn gst_analytics_relation_meta_get_mtd_data(p_meta: *RelationMeta, p_an_meta_id: c_uint) ?*anyopaque;
    pub const getMtdData = gst_analytics_relation_meta_get_mtd_data;

    /// Fill `rlt` if a analytics-meta with id == `an_meta_id` exist in `meta` instance,
    /// otherwise this method return FALSE and `rlt` is invalid.
    extern fn gst_analytics_relation_meta_get_od_mtd(p_meta: *RelationMeta, p_an_meta_id: c_uint, p_rlt: *gstanalytics.ODMtd) c_int;
    pub const getOdMtd = gst_analytics_relation_meta_get_od_mtd;

    /// Get relations between first and second analysis-meta.
    /// Ids (`an_meta_first_id` and `an_meta_second_id`) must be from a call to
    /// `gst_analytics_mtd_get_id` (handle).
    extern fn gst_analytics_relation_meta_get_relation(p_meta: *RelationMeta, p_an_meta_first_id: c_uint, p_an_meta_second_id: c_uint) gstanalytics.RelTypes;
    pub const getRelation = gst_analytics_relation_meta_get_relation;

    /// Fill `rlt` if a analytics-meta with id == `an_meta_id` exist in `meta` instance,
    /// otherwise this method return FALSE and `rlt` is invalid.
    extern fn gst_analytics_relation_meta_get_tracking_mtd(p_meta: *RelationMeta, p_an_meta_id: c_uint, p_rlt: *gstanalytics.TrackingMtd) c_int;
    pub const getTrackingMtd = gst_analytics_relation_meta_get_tracking_mtd;

    extern fn gst_analytics_relation_meta_iterate(p_meta: *RelationMeta, p_state: ?*anyopaque, p_type: gstanalytics.MtdType, p_rlt_mtd: *gstanalytics.Mtd) c_int;
    pub const iterate = gst_analytics_relation_meta_iterate;

    /// Sets the relation (`gstanalytics.RelTypes`) between `an_meta_first` and
    ///    `an_meta_second`.
    /// Ids must have been obtained a call to
    ///    `gst_analytics_mtd_get_id`(handle).
    extern fn gst_analytics_relation_meta_set_relation(p_meta: *RelationMeta, p_type: gstanalytics.RelTypes, p_an_meta_first_id: c_uint, p_an_meta_second_id: c_uint) c_int;
    pub const setRelation = gst_analytics_relation_meta_set_relation;
};

/// GstAnalyticsRelationMeta initialization parameters.
pub const RelationMetaInitParams = extern struct {
    /// Initial relations order.
    f_initial_relation_order: usize,
    /// Buffer size in bytes to store relatable metadata
    f_initial_buf_size: usize,
};

/// Store information on results of object tracking
pub const TrackingMtd = extern struct {
    /// Instance identifier.
    f_id: c_uint,
    /// Instance of `gstanalytics.RelationMeta` where the analysis-metadata
    /// identified by `id` is stored.
    f_meta: ?*gstanalytics.RelationMeta,

    extern fn gst_analytics_tracking_mtd_get_mtd_type() gstanalytics.MtdType;
    pub const getMtdType = gst_analytics_tracking_mtd_get_mtd_type;

    /// Retrieve tracking information.
    extern fn gst_analytics_tracking_mtd_get_info(p_instance: *TrackingMtd, p_tracking_id: *u64, p_tracking_first_seen: *gst.ClockTime, p_tracking_last_seen: *gst.ClockTime, p_tracking_lost: *c_int) c_int;
    pub const getInfo = gst_analytics_tracking_mtd_get_info;

    extern fn gst_analytics_tracking_mtd_set_lost(p_instance: *TrackingMtd) c_int;
    pub const setLost = gst_analytics_tracking_mtd_set_lost;

    extern fn gst_analytics_tracking_mtd_update_last_seen(p_instance: *TrackingMtd, p_last_seen: gst.ClockTime) c_int;
    pub const updateLastSeen = gst_analytics_tracking_mtd_update_last_seen;
};

pub const RelTypes = packed struct(c_uint) {
    _padding0: bool = false,
    is_part_of: bool = false,
    contain: bool = false,
    relate_to: bool = false,
    last: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: RelTypes = @bitCast(@as(c_uint, 0));
    const flags_is_part_of: RelTypes = @bitCast(@as(c_uint, 2));
    const flags_contain: RelTypes = @bitCast(@as(c_uint, 4));
    const flags_relate_to: RelTypes = @bitCast(@as(c_uint, 8));
    const flags_last: RelTypes = @bitCast(@as(c_uint, 16));
    const flags_any: RelTypes = @bitCast(@as(c_uint, 2147483647));
};

/// Attach a analysis-results-meta-relation  meta (`gstanalytics.RelationMeta`)to `buffer`.
///
/// A `gstanalytics.RelationMeta` is a metadata describing relation between other
/// analysis meta. It's more efficient to use `gstanalytics.bufferAddAnalyticsRelationMetaFull`
/// and providing the maximum number of analysis meta that will attached to a buffer.
extern fn gst_buffer_add_analytics_relation_meta(p_buffer: *gst.Buffer) ?*gstanalytics.RelationMeta;
pub const bufferAddAnalyticsRelationMeta = gst_buffer_add_analytics_relation_meta;

/// Attache a analysis-results relation-meta (`gstanalytics.RelationMeta`) to `buffer`.
///
/// A `gstanalytics.RelationMeta` is a metadata describing relation between other
/// analysis meta.
extern fn gst_buffer_add_analytics_relation_meta_full(p_buffer: *gst.Buffer, p_init_params: *gstanalytics.RelationMetaInitParams) ?*gstanalytics.RelationMeta;
pub const bufferAddAnalyticsRelationMetaFull = gst_buffer_add_analytics_relation_meta_full;

/// Retrives the meta or `NULL` if it doesn't exist
extern fn gst_buffer_get_analytics_relation_meta(p_buffer: *gst.Buffer) ?*gstanalytics.RelationMeta;
pub const bufferGetAnalyticsRelationMeta = gst_buffer_get_analytics_relation_meta;

/// Get number of relatable meta attached to instance
extern fn gst_analytics_relation_get_length(p_instance: *gstanalytics.RelationMeta) usize;
pub const relationGetLength = gst_analytics_relation_get_length;

extern fn gst_analytics_relation_meta_api_get_type() usize;
pub const relationMetaApiGetType = gst_analytics_relation_meta_api_get_type;

/// Passes to functions asking for a relation span when the span is
/// infinite.
pub const INF_RELATION_SPAN = -1;
/// A wildcard matching any type of analysis
pub const MTD_TYPE_ANY = 0;
