const std = @import("std");

pub fn build(b: *std.Build) void {
    const target = b.standardTargetOptions(.{});
    const optimize = b.standardOptimizeOption(.{});
    const compat = b.createModule(.{
        .root_source_file = b.path("src/compat/compat.zig"),
        .target = target,
        .optimize = optimize,
    });
    const xrandr1 = b.addModule("xrandr1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "xrandr1", "xrandr1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    xrandr1.link_libc = true;
    xrandr1.addImport("compat", compat);
    const xmlb2 = b.addModule("xmlb2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "xmlb2", "xmlb2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    xmlb2.link_libc = true;
    xmlb2.linkSystemLibrary("xmlb", .{});
    xmlb2.addImport("compat", compat);
    const gio2 = b.addModule("gio2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gio2", "gio2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gio2.link_libc = true;
    gio2.linkSystemLibrary("gio-2.0", .{});
    gio2.linkSystemLibrary("gio-unix-2.0", .{});
    gio2.addImport("compat", compat);
    const gobject2 = b.addModule("gobject2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gobject2", "gobject2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gobject2.link_libc = true;
    gobject2.linkSystemLibrary("gobject-2.0", .{});
    gobject2.addImport("compat", compat);
    const glib2 = b.addModule("glib2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "glib2", "glib2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    glib2.link_libc = true;
    glib2.linkSystemLibrary("glib-2.0", .{});
    glib2.addImport("compat", compat);
    const gmodule2 = b.addModule("gmodule2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gmodule2", "gmodule2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gmodule2.link_libc = true;
    gmodule2.linkSystemLibrary("gmodule-2.0", .{});
    gmodule2.addImport("compat", compat);
    const xlib2 = b.addModule("xlib2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "xlib2", "xlib2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    xlib2.link_libc = true;
    xlib2.addImport("compat", compat);
    const xft2 = b.addModule("xft2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "xft2", "xft2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    xft2.link_libc = true;
    xft2.addImport("compat", compat);
    const xfixes4 = b.addModule("xfixes4", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "xfixes4", "xfixes4" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    xfixes4.link_libc = true;
    xfixes4.addImport("compat", compat);
    const win321 = b.addModule("win321", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "win321", "win321" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    win321.link_libc = true;
    win321.addImport("compat", compat);
    const webkitwebprocessextension6 = b.addModule("webkitwebprocessextension6", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "webkitwebprocessextension6", "webkitwebprocessextension6" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    webkitwebprocessextension6.link_libc = true;
    webkitwebprocessextension6.linkSystemLibrary("webkitgtk-web-process-extension-6.0", .{});
    webkitwebprocessextension6.addImport("compat", compat);
    const soup3 = b.addModule("soup3", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "soup3", "soup3" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    soup3.link_libc = true;
    soup3.linkSystemLibrary("libsoup-3.0", .{});
    soup3.addImport("compat", compat);
    const javascriptcore6 = b.addModule("javascriptcore6", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "javascriptcore6", "javascriptcore6" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    javascriptcore6.link_libc = true;
    javascriptcore6.linkSystemLibrary("javascriptcoregtk-6.0", .{});
    javascriptcore6.addImport("compat", compat);
    const gtk4 = b.addModule("gtk4", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gtk4", "gtk4" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gtk4.link_libc = true;
    gtk4.linkSystemLibrary("gtk4", .{});
    gtk4.addImport("compat", compat);
    const gsk4 = b.addModule("gsk4", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gsk4", "gsk4" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gsk4.link_libc = true;
    gsk4.linkSystemLibrary("gtk4", .{});
    gsk4.addImport("compat", compat);
    const graphene1 = b.addModule("graphene1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "graphene1", "graphene1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    graphene1.link_libc = true;
    graphene1.linkSystemLibrary("graphene-gobject-1.0", .{});
    graphene1.addImport("compat", compat);
    const gdk4 = b.addModule("gdk4", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gdk4", "gdk4" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gdk4.link_libc = true;
    gdk4.linkSystemLibrary("gtk4", .{});
    gdk4.addImport("compat", compat);
    const cairo1 = b.addModule("cairo1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "cairo1", "cairo1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    cairo1.link_libc = true;
    cairo1.linkSystemLibrary("cairo-gobject", .{});
    cairo1.addImport("compat", compat);
    const pangocairo1 = b.addModule("pangocairo1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "pangocairo1", "pangocairo1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    pangocairo1.link_libc = true;
    pangocairo1.linkSystemLibrary("pangocairo", .{});
    pangocairo1.addImport("compat", compat);
    const pango1 = b.addModule("pango1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "pango1", "pango1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    pango1.link_libc = true;
    pango1.linkSystemLibrary("pango", .{});
    pango1.addImport("compat", compat);
    const harfbuzz0 = b.addModule("harfbuzz0", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "harfbuzz0", "harfbuzz0" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    harfbuzz0.link_libc = true;
    harfbuzz0.linkSystemLibrary("harfbuzz", .{});
    harfbuzz0.linkSystemLibrary("harfbuzz-gobject", .{});
    harfbuzz0.addImport("compat", compat);
    const freetype22 = b.addModule("freetype22", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "freetype22", "freetype22" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    freetype22.link_libc = true;
    freetype22.addImport("compat", compat);
    const gdkpixbuf2 = b.addModule("gdkpixbuf2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gdkpixbuf2", "gdkpixbuf2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gdkpixbuf2.link_libc = true;
    gdkpixbuf2.linkSystemLibrary("gdk-pixbuf-2.0", .{});
    gdkpixbuf2.addImport("compat", compat);
    const webkit6 = b.addModule("webkit6", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "webkit6", "webkit6" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    webkit6.link_libc = true;
    webkit6.linkSystemLibrary("webkitgtk-6.0", .{});
    webkit6.addImport("compat", compat);
    const webkit2webextension4 = b.addModule("webkit2webextension4", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "webkit2webextension4", "webkit2webextension4" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    webkit2webextension4.link_libc = true;
    webkit2webextension4.linkSystemLibrary("webkit2gtk-web-extension-4.1", .{});
    webkit2webextension4.addImport("compat", compat);
    const javascriptcore4 = b.addModule("javascriptcore4", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "javascriptcore4", "javascriptcore4" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    javascriptcore4.link_libc = true;
    javascriptcore4.linkSystemLibrary("javascriptcoregtk-4.1", .{});
    javascriptcore4.addImport("compat", compat);
    const gtk3 = b.addModule("gtk3", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gtk3", "gtk3" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gtk3.link_libc = true;
    gtk3.linkSystemLibrary("gtk+-3.0", .{});
    gtk3.addImport("compat", compat);
    const gdk3 = b.addModule("gdk3", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gdk3", "gdk3" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gdk3.link_libc = true;
    gdk3.linkSystemLibrary("gdk-3.0", .{});
    gdk3.addImport("compat", compat);
    const atk1 = b.addModule("atk1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "atk1", "atk1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    atk1.link_libc = true;
    atk1.linkSystemLibrary("atk", .{});
    atk1.addImport("compat", compat);
    const webkit24 = b.addModule("webkit24", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "webkit24", "webkit24" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    webkit24.link_libc = true;
    webkit24.linkSystemLibrary("webkit2gtk-4.1", .{});
    webkit24.addImport("compat", compat);
    const vulkan1 = b.addModule("vulkan1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "vulkan1", "vulkan1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    vulkan1.link_libc = true;
    vulkan1.addImport("compat", compat);
    const tsparql3 = b.addModule("tsparql3", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "tsparql3", "tsparql3" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    tsparql3.link_libc = true;
    tsparql3.linkSystemLibrary("tinysparql-3.0", .{});
    tsparql3.addImport("compat", compat);
    const tracker3 = b.addModule("tracker3", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "tracker3", "tracker3" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    tracker3.link_libc = true;
    tracker3.linkSystemLibrary("tracker-sparql-3.0", .{});
    tracker3.addImport("compat", compat);
    const secret1 = b.addModule("secret1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "secret1", "secret1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    secret1.link_libc = true;
    secret1.linkSystemLibrary("libsecret-1", .{});
    secret1.addImport("compat", compat);
    const rsvg2 = b.addModule("rsvg2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "rsvg2", "rsvg2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    rsvg2.link_libc = true;
    rsvg2.linkSystemLibrary("librsvg-2.0", .{});
    rsvg2.addImport("compat", compat);
    const polkit1 = b.addModule("polkit1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "polkit1", "polkit1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    polkit1.link_libc = true;
    polkit1.linkSystemLibrary("polkit-gobject-1", .{});
    polkit1.addImport("compat", compat);
    const pangoot1 = b.addModule("pangoot1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "pangoot1", "pangoot1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    pangoot1.link_libc = true;
    pangoot1.linkSystemLibrary("pangoot", .{});
    pangoot1.addImport("compat", compat);
    const pangofc1 = b.addModule("pangofc1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "pangofc1", "pangofc1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    pangofc1.link_libc = true;
    pangofc1.linkSystemLibrary("pangofc", .{});
    pangofc1.addImport("compat", compat);
    const fontconfig2 = b.addModule("fontconfig2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "fontconfig2", "fontconfig2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    fontconfig2.link_libc = true;
    fontconfig2.addImport("compat", compat);
    const pangoft21 = b.addModule("pangoft21", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "pangoft21", "pangoft21" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    pangoft21.link_libc = true;
    pangoft21.linkSystemLibrary("pangoft2", .{});
    pangoft21.addImport("compat", compat);
    const notify0 = b.addModule("notify0", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "notify0", "notify0" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    notify0.link_libc = true;
    notify0.linkSystemLibrary("libnotify", .{});
    notify0.addImport("compat", compat);
    const nice0 = b.addModule("nice0", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "nice0", "nice0" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    nice0.link_libc = true;
    nice0.linkSystemLibrary("nice", .{});
    nice0.addImport("compat", compat);
    const manette0 = b.addModule("manette0", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "manette0", "manette0" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    manette0.link_libc = true;
    manette0.linkSystemLibrary("manette-0.2", .{});
    manette0.addImport("compat", compat);
    const gudev1 = b.addModule("gudev1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gudev1", "gudev1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gudev1.link_libc = true;
    gudev1.linkSystemLibrary("gudev-1.0", .{});
    gudev1.addImport("compat", compat);
    const libxml22 = b.addModule("libxml22", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "libxml22", "libxml22" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    libxml22.link_libc = true;
    libxml22.linkSystemLibrary("libxml-2.0", .{});
    libxml22.addImport("compat", compat);
    const libproxy1 = b.addModule("libproxy1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "libproxy1", "libproxy1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    libproxy1.link_libc = true;
    libproxy1.linkSystemLibrary("libproxy-1.0", .{});
    libproxy1.addImport("compat", compat);
    const json1 = b.addModule("json1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "json1", "json1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    json1.link_libc = true;
    json1.linkSystemLibrary("json-glib-1.0", .{});
    json1.addImport("compat", compat);
    const ibus1 = b.addModule("ibus1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "ibus1", "ibus1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    ibus1.link_libc = true;
    ibus1.linkSystemLibrary("ibus-1.0", .{});
    ibus1.addImport("compat", compat);
    const handy1 = b.addModule("handy1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "handy1", "handy1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    handy1.link_libc = true;
    handy1.linkSystemLibrary("libhandy-1", .{});
    handy1.addImport("compat", compat);
    const gtksource5 = b.addModule("gtksource5", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gtksource5", "gtksource5" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gtksource5.link_libc = true;
    gtksource5.linkSystemLibrary("gtksourceview-5", .{});
    gtksource5.addImport("compat", compat);
    const gstwebrtc1 = b.addModule("gstwebrtc1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstwebrtc1", "gstwebrtc1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstwebrtc1.link_libc = true;
    gstwebrtc1.linkSystemLibrary("gstreamer-webrtc-1.0", .{});
    gstwebrtc1.addImport("compat", compat);
    const gstsdp1 = b.addModule("gstsdp1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstsdp1", "gstsdp1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstsdp1.link_libc = true;
    gstsdp1.linkSystemLibrary("gstreamer-sdp-1.0", .{});
    gstsdp1.addImport("compat", compat);
    const gst1 = b.addModule("gst1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gst1", "gst1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gst1.link_libc = true;
    gst1.linkSystemLibrary("gstreamer-1.0", .{});
    gst1.addImport("compat", compat);
    const gstvulkanxcb1 = b.addModule("gstvulkanxcb1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstvulkanxcb1", "gstvulkanxcb1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstvulkanxcb1.link_libc = true;
    gstvulkanxcb1.linkSystemLibrary("gstreamer-vulkan-xcb-1.0", .{});
    gstvulkanxcb1.addImport("compat", compat);
    const gstvulkan1 = b.addModule("gstvulkan1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstvulkan1", "gstvulkan1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstvulkan1.link_libc = true;
    gstvulkan1.linkSystemLibrary("gstreamer-vulkan-1.0", .{});
    gstvulkan1.addImport("compat", compat);
    const gstvideo1 = b.addModule("gstvideo1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstvideo1", "gstvideo1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstvideo1.link_libc = true;
    gstvideo1.linkSystemLibrary("gstreamer-video-1.0", .{});
    gstvideo1.addImport("compat", compat);
    const gstbase1 = b.addModule("gstbase1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstbase1", "gstbase1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstbase1.link_libc = true;
    gstbase1.linkSystemLibrary("gstreamer-base-1.0", .{});
    gstbase1.addImport("compat", compat);
    const gstvulkanwayland1 = b.addModule("gstvulkanwayland1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstvulkanwayland1", "gstvulkanwayland1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstvulkanwayland1.link_libc = true;
    gstvulkanwayland1.linkSystemLibrary("gstreamer-vulkan-wayland-1.0", .{});
    gstvulkanwayland1.addImport("compat", compat);
    const gstva1 = b.addModule("gstva1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstva1", "gstva1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstva1.link_libc = true;
    gstva1.linkSystemLibrary("gstreamer-va-1.0", .{});
    gstva1.addImport("compat", compat);
    const gsttranscoder1 = b.addModule("gsttranscoder1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gsttranscoder1", "gsttranscoder1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gsttranscoder1.link_libc = true;
    gsttranscoder1.linkSystemLibrary("gstreamer-transcoder-1.0", .{});
    gsttranscoder1.addImport("compat", compat);
    const gstpbutils1 = b.addModule("gstpbutils1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstpbutils1", "gstpbutils1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstpbutils1.link_libc = true;
    gstpbutils1.linkSystemLibrary("gstreamer-pbutils-1.0", .{});
    gstpbutils1.addImport("compat", compat);
    const gstaudio1 = b.addModule("gstaudio1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstaudio1", "gstaudio1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstaudio1.link_libc = true;
    gstaudio1.linkSystemLibrary("gstreamer-audio-1.0", .{});
    gstaudio1.addImport("compat", compat);
    const gsttag1 = b.addModule("gsttag1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gsttag1", "gsttag1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gsttag1.link_libc = true;
    gsttag1.linkSystemLibrary("gstreamer-tag-1.0", .{});
    gsttag1.addImport("compat", compat);
    const gstrtsp1 = b.addModule("gstrtsp1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstrtsp1", "gstrtsp1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstrtsp1.link_libc = true;
    gstrtsp1.linkSystemLibrary("gstreamer-rtsp-1.0", .{});
    gstrtsp1.addImport("compat", compat);
    const gstrtp1 = b.addModule("gstrtp1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstrtp1", "gstrtp1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstrtp1.link_libc = true;
    gstrtp1.linkSystemLibrary("gstreamer-rtp-1.0", .{});
    gstrtp1.addImport("compat", compat);
    const gstplayer1 = b.addModule("gstplayer1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstplayer1", "gstplayer1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstplayer1.link_libc = true;
    gstplayer1.linkSystemLibrary("gstreamer-player-1.0", .{});
    gstplayer1.addImport("compat", compat);
    const gstplay1 = b.addModule("gstplay1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstplay1", "gstplay1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstplay1.link_libc = true;
    gstplay1.linkSystemLibrary("gstreamer-play-1.0", .{});
    gstplay1.addImport("compat", compat);
    const gstnet1 = b.addModule("gstnet1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstnet1", "gstnet1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstnet1.link_libc = true;
    gstnet1.linkSystemLibrary("gstreamer-net-1.0", .{});
    gstnet1.addImport("compat", compat);
    const gstmse1 = b.addModule("gstmse1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstmse1", "gstmse1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstmse1.link_libc = true;
    gstmse1.linkSystemLibrary("gstreamer-mse-1.0", .{});
    gstmse1.addImport("compat", compat);
    const gstmpegts1 = b.addModule("gstmpegts1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstmpegts1", "gstmpegts1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstmpegts1.link_libc = true;
    gstmpegts1.linkSystemLibrary("gstreamer-mpegts-1.0", .{});
    gstmpegts1.addImport("compat", compat);
    const gstinsertbin1 = b.addModule("gstinsertbin1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstinsertbin1", "gstinsertbin1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstinsertbin1.link_libc = true;
    gstinsertbin1.linkSystemLibrary("gstreamer-insertbin-1.0", .{});
    gstinsertbin1.addImport("compat", compat);
    const gstglx111 = b.addModule("gstglx111", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstglx111", "gstglx111" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstglx111.link_libc = true;
    gstglx111.linkSystemLibrary("gstreamer-gl-x11-1.0", .{});
    gstglx111.addImport("compat", compat);
    const gstgl1 = b.addModule("gstgl1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstgl1", "gstgl1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstgl1.link_libc = true;
    gstgl1.linkSystemLibrary("gstreamer-gl-1.0", .{});
    gstgl1.addImport("compat", compat);
    const gstglwayland1 = b.addModule("gstglwayland1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstglwayland1", "gstglwayland1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstglwayland1.link_libc = true;
    gstglwayland1.linkSystemLibrary("gstreamer-gl-wayland-1.0", .{});
    gstglwayland1.addImport("compat", compat);
    const gstglegl1 = b.addModule("gstglegl1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstglegl1", "gstglegl1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstglegl1.link_libc = true;
    gstglegl1.linkSystemLibrary("gstreamer-gl-egl-1.0", .{});
    gstglegl1.addImport("compat", compat);
    const gstcuda1 = b.addModule("gstcuda1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstcuda1", "gstcuda1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstcuda1.link_libc = true;
    gstcuda1.linkSystemLibrary("gstreamer-cuda-1.0", .{});
    gstcuda1.addImport("compat", compat);
    const cudagst1 = b.addModule("cudagst1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "cudagst1", "cudagst1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    cudagst1.link_libc = true;
    cudagst1.addImport("compat", compat);
    const gstcontroller1 = b.addModule("gstcontroller1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstcontroller1", "gstcontroller1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstcontroller1.link_libc = true;
    gstcontroller1.linkSystemLibrary("gstreamer-controller-1.0", .{});
    gstcontroller1.addImport("compat", compat);
    const gstcheck1 = b.addModule("gstcheck1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstcheck1", "gstcheck1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstcheck1.link_libc = true;
    gstcheck1.linkSystemLibrary("gstreamer-check-1.0", .{});
    gstcheck1.addImport("compat", compat);
    const gstbadaudio1 = b.addModule("gstbadaudio1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstbadaudio1", "gstbadaudio1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstbadaudio1.link_libc = true;
    gstbadaudio1.linkSystemLibrary("gstreamer-bad-audio-1.0", .{});
    gstbadaudio1.addImport("compat", compat);
    const gstapp1 = b.addModule("gstapp1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstapp1", "gstapp1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstapp1.link_libc = true;
    gstapp1.linkSystemLibrary("gstreamer-app-1.0", .{});
    gstapp1.addImport("compat", compat);
    const gstanalytics1 = b.addModule("gstanalytics1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstanalytics1", "gstanalytics1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstanalytics1.link_libc = true;
    gstanalytics1.linkSystemLibrary("gstreamer-analytics-1.0", .{});
    gstanalytics1.addImport("compat", compat);
    const gstallocators1 = b.addModule("gstallocators1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gstallocators1", "gstallocators1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gstallocators1.link_libc = true;
    gstallocators1.linkSystemLibrary("gstreamer-allocators-1.0", .{});
    gstallocators1.addImport("compat", compat);
    const glibunix2 = b.addModule("glibunix2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "glibunix2", "glibunix2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    glibunix2.link_libc = true;
    glibunix2.linkSystemLibrary("glib-2.0", .{});
    glibunix2.addImport("compat", compat);
    const gl1 = b.addModule("gl1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gl1", "gl1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gl1.link_libc = true;
    gl1.addImport("compat", compat);
    const girepository3 = b.addModule("girepository3", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "girepository3", "girepository3" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    girepository3.link_libc = true;
    girepository3.linkSystemLibrary("girepository-2.0", .{});
    girepository3.addImport("compat", compat);
    const girepository2 = b.addModule("girepository2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "girepository2", "girepository2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    girepository2.link_libc = true;
    girepository2.linkSystemLibrary("gobject-introspection-1.0", .{});
    girepository2.addImport("compat", compat);
    const giounix2 = b.addModule("giounix2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "giounix2", "giounix2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    giounix2.link_libc = true;
    giounix2.linkSystemLibrary("gio-unix-2.0", .{});
    giounix2.addImport("compat", compat);
    const geoclue2 = b.addModule("geoclue2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "geoclue2", "geoclue2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    geoclue2.link_libc = true;
    geoclue2.linkSystemLibrary("libgeoclue-2.0", .{});
    geoclue2.addImport("compat", compat);
    const gee0 = b.addModule("gee0", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gee0", "gee0" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gee0.link_libc = true;
    gee0.linkSystemLibrary("gee-0.8", .{});
    gee0.addImport("compat", compat);
    const gdkx114 = b.addModule("gdkx114", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gdkx114", "gdkx114" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gdkx114.link_libc = true;
    gdkx114.linkSystemLibrary("gtk4-x11", .{});
    gdkx114.addImport("compat", compat);
    const gdkx113 = b.addModule("gdkx113", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gdkx113", "gdkx113" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gdkx113.link_libc = true;
    gdkx113.linkSystemLibrary("gdk-x11-3.0", .{});
    gdkx113.addImport("compat", compat);
    const gdkwayland4 = b.addModule("gdkwayland4", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gdkwayland4", "gdkwayland4" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gdkwayland4.link_libc = true;
    gdkwayland4.linkSystemLibrary("gtk4-wayland", .{});
    gdkwayland4.addImport("compat", compat);
    const gdkpixdata2 = b.addModule("gdkpixdata2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gdkpixdata2", "gdkpixdata2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gdkpixdata2.link_libc = true;
    gdkpixdata2.linkSystemLibrary("gdk-pixbuf-2.0", .{});
    gdkpixdata2.addImport("compat", compat);
    const gdesktopenums3 = b.addModule("gdesktopenums3", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gdesktopenums3", "gdesktopenums3" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gdesktopenums3.link_libc = true;
    gdesktopenums3.addImport("compat", compat);
    const gcrui3 = b.addModule("gcrui3", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gcrui3", "gcrui3" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gcrui3.link_libc = true;
    gcrui3.linkSystemLibrary("gcr-ui-3", .{});
    gcrui3.addImport("compat", compat);
    const gcr3 = b.addModule("gcr3", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gcr3", "gcr3" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gcr3.link_libc = true;
    gcr3.linkSystemLibrary("gcr-base-3", .{});
    gcr3.addImport("compat", compat);
    const gck1 = b.addModule("gck1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gck1", "gck1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gck1.link_libc = true;
    gck1.linkSystemLibrary("gck-1", .{});
    gck1.addImport("compat", compat);
    const gcr4 = b.addModule("gcr4", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gcr4", "gcr4" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gcr4.link_libc = true;
    gcr4.linkSystemLibrary("gcr-4", .{});
    gcr4.addImport("compat", compat);
    const gck2 = b.addModule("gck2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gck2", "gck2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gck2.link_libc = true;
    gck2.linkSystemLibrary("gck-2", .{});
    gck2.addImport("compat", compat);
    const gcab1 = b.addModule("gcab1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "gcab1", "gcab1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    gcab1.link_libc = true;
    gcab1.linkSystemLibrary("libgcab-1.0", .{});
    gcab1.addImport("compat", compat);
    const dex1 = b.addModule("dex1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "dex1", "dex1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    dex1.link_libc = true;
    dex1.linkSystemLibrary("libdex-1", .{});
    dex1.addImport("compat", compat);
    const dbus1 = b.addModule("dbus1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "dbus1", "dbus1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    dbus1.link_libc = true;
    dbus1.linkSystemLibrary("dbus-1", .{});
    dbus1.addImport("compat", compat);
    const atspi2 = b.addModule("atspi2", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "atspi2", "atspi2" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    atspi2.link_libc = true;
    atspi2.linkSystemLibrary("atspi-2", .{});
    atspi2.addImport("compat", compat);
    const appstreamcompose1 = b.addModule("appstreamcompose1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "appstreamcompose1", "appstreamcompose1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    appstreamcompose1.link_libc = true;
    appstreamcompose1.linkSystemLibrary("appstream-compose", .{});
    appstreamcompose1.addImport("compat", compat);
    const appstream1 = b.addModule("appstream1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "appstream1", "appstream1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    appstream1.link_libc = true;
    appstream1.linkSystemLibrary("appstream", .{});
    appstream1.addImport("compat", compat);
    const adw1 = b.addModule("adw1", .{
        .root_source_file = b.path(b.pathJoin(&.{ "src", "adw1", "adw1" ++ ".zig" })),
        .target = target,
        .optimize = optimize,
    });
    adw1.link_libc = true;
    adw1.linkSystemLibrary("libadwaita-1", .{});
    adw1.addImport("compat", compat);
    xrandr1.addImport("xrandr1", xrandr1);

    xmlb2.addImport("gio2", gio2);
    xmlb2.addImport("gobject2", gobject2);
    xmlb2.addImport("glib2", glib2);
    xmlb2.addImport("gmodule2", gmodule2);
    xmlb2.addImport("xmlb2", xmlb2);

    gio2.addImport("gobject2", gobject2);
    gio2.addImport("glib2", glib2);
    gio2.addImport("gmodule2", gmodule2);
    gio2.addImport("gio2", gio2);

    gobject2.addImport("glib2", glib2);
    gobject2.addImport("gobject2", gobject2);

    glib2.addImport("glib2", glib2);

    gmodule2.addImport("glib2", glib2);
    gmodule2.addImport("gmodule2", gmodule2);

    xlib2.addImport("xlib2", xlib2);

    xft2.addImport("xlib2", xlib2);
    xft2.addImport("xft2", xft2);

    xfixes4.addImport("xfixes4", xfixes4);

    win321.addImport("win321", win321);

    webkitwebprocessextension6.addImport("soup3", soup3);
    webkitwebprocessextension6.addImport("gio2", gio2);
    webkitwebprocessextension6.addImport("gobject2", gobject2);
    webkitwebprocessextension6.addImport("glib2", glib2);
    webkitwebprocessextension6.addImport("gmodule2", gmodule2);
    webkitwebprocessextension6.addImport("javascriptcore6", javascriptcore6);
    webkitwebprocessextension6.addImport("gtk4", gtk4);
    webkitwebprocessextension6.addImport("gsk4", gsk4);
    webkitwebprocessextension6.addImport("graphene1", graphene1);
    webkitwebprocessextension6.addImport("gdk4", gdk4);
    webkitwebprocessextension6.addImport("cairo1", cairo1);
    webkitwebprocessextension6.addImport("pangocairo1", pangocairo1);
    webkitwebprocessextension6.addImport("pango1", pango1);
    webkitwebprocessextension6.addImport("harfbuzz0", harfbuzz0);
    webkitwebprocessextension6.addImport("freetype22", freetype22);
    webkitwebprocessextension6.addImport("gdkpixbuf2", gdkpixbuf2);
    webkitwebprocessextension6.addImport("webkitwebprocessextension6", webkitwebprocessextension6);

    soup3.addImport("gio2", gio2);
    soup3.addImport("gobject2", gobject2);
    soup3.addImport("glib2", glib2);
    soup3.addImport("gmodule2", gmodule2);
    soup3.addImport("soup3", soup3);

    javascriptcore6.addImport("gobject2", gobject2);
    javascriptcore6.addImport("glib2", glib2);
    javascriptcore6.addImport("javascriptcore6", javascriptcore6);

    gtk4.addImport("gsk4", gsk4);
    gtk4.addImport("graphene1", graphene1);
    gtk4.addImport("gobject2", gobject2);
    gtk4.addImport("glib2", glib2);
    gtk4.addImport("gdk4", gdk4);
    gtk4.addImport("cairo1", cairo1);
    gtk4.addImport("pangocairo1", pangocairo1);
    gtk4.addImport("pango1", pango1);
    gtk4.addImport("harfbuzz0", harfbuzz0);
    gtk4.addImport("freetype22", freetype22);
    gtk4.addImport("gio2", gio2);
    gtk4.addImport("gmodule2", gmodule2);
    gtk4.addImport("gdkpixbuf2", gdkpixbuf2);
    gtk4.addImport("gtk4", gtk4);

    gsk4.addImport("graphene1", graphene1);
    gsk4.addImport("gobject2", gobject2);
    gsk4.addImport("glib2", glib2);
    gsk4.addImport("gdk4", gdk4);
    gsk4.addImport("cairo1", cairo1);
    gsk4.addImport("pangocairo1", pangocairo1);
    gsk4.addImport("pango1", pango1);
    gsk4.addImport("harfbuzz0", harfbuzz0);
    gsk4.addImport("freetype22", freetype22);
    gsk4.addImport("gio2", gio2);
    gsk4.addImport("gmodule2", gmodule2);
    gsk4.addImport("gdkpixbuf2", gdkpixbuf2);
    gsk4.addImport("gsk4", gsk4);

    graphene1.addImport("gobject2", gobject2);
    graphene1.addImport("glib2", glib2);
    graphene1.addImport("graphene1", graphene1);

    gdk4.addImport("cairo1", cairo1);
    gdk4.addImport("gobject2", gobject2);
    gdk4.addImport("glib2", glib2);
    gdk4.addImport("pangocairo1", pangocairo1);
    gdk4.addImport("pango1", pango1);
    gdk4.addImport("harfbuzz0", harfbuzz0);
    gdk4.addImport("freetype22", freetype22);
    gdk4.addImport("gio2", gio2);
    gdk4.addImport("gmodule2", gmodule2);
    gdk4.addImport("gdkpixbuf2", gdkpixbuf2);
    gdk4.addImport("gdk4", gdk4);

    cairo1.addImport("gobject2", gobject2);
    cairo1.addImport("glib2", glib2);
    cairo1.addImport("cairo1", cairo1);

    pangocairo1.addImport("cairo1", cairo1);
    pangocairo1.addImport("gobject2", gobject2);
    pangocairo1.addImport("glib2", glib2);
    pangocairo1.addImport("pango1", pango1);
    pangocairo1.addImport("harfbuzz0", harfbuzz0);
    pangocairo1.addImport("freetype22", freetype22);
    pangocairo1.addImport("gio2", gio2);
    pangocairo1.addImport("gmodule2", gmodule2);
    pangocairo1.addImport("pangocairo1", pangocairo1);

    pango1.addImport("cairo1", cairo1);
    pango1.addImport("gobject2", gobject2);
    pango1.addImport("glib2", glib2);
    pango1.addImport("harfbuzz0", harfbuzz0);
    pango1.addImport("freetype22", freetype22);
    pango1.addImport("gio2", gio2);
    pango1.addImport("gmodule2", gmodule2);
    pango1.addImport("pango1", pango1);

    harfbuzz0.addImport("freetype22", freetype22);
    harfbuzz0.addImport("gobject2", gobject2);
    harfbuzz0.addImport("glib2", glib2);
    harfbuzz0.addImport("harfbuzz0", harfbuzz0);

    freetype22.addImport("freetype22", freetype22);

    gdkpixbuf2.addImport("gio2", gio2);
    gdkpixbuf2.addImport("gobject2", gobject2);
    gdkpixbuf2.addImport("glib2", glib2);
    gdkpixbuf2.addImport("gmodule2", gmodule2);
    gdkpixbuf2.addImport("gdkpixbuf2", gdkpixbuf2);

    webkit6.addImport("soup3", soup3);
    webkit6.addImport("gio2", gio2);
    webkit6.addImport("gobject2", gobject2);
    webkit6.addImport("glib2", glib2);
    webkit6.addImport("gmodule2", gmodule2);
    webkit6.addImport("javascriptcore6", javascriptcore6);
    webkit6.addImport("gtk4", gtk4);
    webkit6.addImport("gsk4", gsk4);
    webkit6.addImport("graphene1", graphene1);
    webkit6.addImport("gdk4", gdk4);
    webkit6.addImport("cairo1", cairo1);
    webkit6.addImport("pangocairo1", pangocairo1);
    webkit6.addImport("pango1", pango1);
    webkit6.addImport("harfbuzz0", harfbuzz0);
    webkit6.addImport("freetype22", freetype22);
    webkit6.addImport("gdkpixbuf2", gdkpixbuf2);
    webkit6.addImport("webkit6", webkit6);

    webkit2webextension4.addImport("soup3", soup3);
    webkit2webextension4.addImport("gio2", gio2);
    webkit2webextension4.addImport("gobject2", gobject2);
    webkit2webextension4.addImport("glib2", glib2);
    webkit2webextension4.addImport("gmodule2", gmodule2);
    webkit2webextension4.addImport("javascriptcore4", javascriptcore4);
    webkit2webextension4.addImport("gtk3", gtk3);
    webkit2webextension4.addImport("xlib2", xlib2);
    webkit2webextension4.addImport("gdk3", gdk3);
    webkit2webextension4.addImport("cairo1", cairo1);
    webkit2webextension4.addImport("pango1", pango1);
    webkit2webextension4.addImport("harfbuzz0", harfbuzz0);
    webkit2webextension4.addImport("freetype22", freetype22);
    webkit2webextension4.addImport("gdkpixbuf2", gdkpixbuf2);
    webkit2webextension4.addImport("atk1", atk1);
    webkit2webextension4.addImport("webkit2webextension4", webkit2webextension4);

    javascriptcore4.addImport("gobject2", gobject2);
    javascriptcore4.addImport("glib2", glib2);
    javascriptcore4.addImport("javascriptcore4", javascriptcore4);

    gtk3.addImport("xlib2", xlib2);
    gtk3.addImport("gdk3", gdk3);
    gtk3.addImport("cairo1", cairo1);
    gtk3.addImport("gobject2", gobject2);
    gtk3.addImport("glib2", glib2);
    gtk3.addImport("pango1", pango1);
    gtk3.addImport("harfbuzz0", harfbuzz0);
    gtk3.addImport("freetype22", freetype22);
    gtk3.addImport("gio2", gio2);
    gtk3.addImport("gmodule2", gmodule2);
    gtk3.addImport("gdkpixbuf2", gdkpixbuf2);
    gtk3.addImport("atk1", atk1);
    gtk3.addImport("gtk3", gtk3);

    gdk3.addImport("cairo1", cairo1);
    gdk3.addImport("gobject2", gobject2);
    gdk3.addImport("glib2", glib2);
    gdk3.addImport("pango1", pango1);
    gdk3.addImport("harfbuzz0", harfbuzz0);
    gdk3.addImport("freetype22", freetype22);
    gdk3.addImport("gio2", gio2);
    gdk3.addImport("gmodule2", gmodule2);
    gdk3.addImport("gdkpixbuf2", gdkpixbuf2);
    gdk3.addImport("gdk3", gdk3);

    atk1.addImport("gobject2", gobject2);
    atk1.addImport("glib2", glib2);
    atk1.addImport("atk1", atk1);

    webkit24.addImport("soup3", soup3);
    webkit24.addImport("gio2", gio2);
    webkit24.addImport("gobject2", gobject2);
    webkit24.addImport("glib2", glib2);
    webkit24.addImport("gmodule2", gmodule2);
    webkit24.addImport("javascriptcore4", javascriptcore4);
    webkit24.addImport("gtk3", gtk3);
    webkit24.addImport("xlib2", xlib2);
    webkit24.addImport("gdk3", gdk3);
    webkit24.addImport("cairo1", cairo1);
    webkit24.addImport("pango1", pango1);
    webkit24.addImport("harfbuzz0", harfbuzz0);
    webkit24.addImport("freetype22", freetype22);
    webkit24.addImport("gdkpixbuf2", gdkpixbuf2);
    webkit24.addImport("atk1", atk1);
    webkit24.addImport("webkit24", webkit24);

    vulkan1.addImport("vulkan1", vulkan1);

    tsparql3.addImport("gio2", gio2);
    tsparql3.addImport("gobject2", gobject2);
    tsparql3.addImport("glib2", glib2);
    tsparql3.addImport("gmodule2", gmodule2);
    tsparql3.addImport("tsparql3", tsparql3);

    tracker3.addImport("gio2", gio2);
    tracker3.addImport("gobject2", gobject2);
    tracker3.addImport("glib2", glib2);
    tracker3.addImport("gmodule2", gmodule2);
    tracker3.addImport("tracker3", tracker3);

    secret1.addImport("gio2", gio2);
    secret1.addImport("gobject2", gobject2);
    secret1.addImport("glib2", glib2);
    secret1.addImport("gmodule2", gmodule2);
    secret1.addImport("secret1", secret1);

    rsvg2.addImport("cairo1", cairo1);
    rsvg2.addImport("gobject2", gobject2);
    rsvg2.addImport("glib2", glib2);
    rsvg2.addImport("gio2", gio2);
    rsvg2.addImport("gmodule2", gmodule2);
    rsvg2.addImport("gdkpixbuf2", gdkpixbuf2);
    rsvg2.addImport("rsvg2", rsvg2);

    polkit1.addImport("gio2", gio2);
    polkit1.addImport("gobject2", gobject2);
    polkit1.addImport("glib2", glib2);
    polkit1.addImport("gmodule2", gmodule2);
    polkit1.addImport("polkit1", polkit1);

    pangoot1.addImport("freetype22", freetype22);
    pangoot1.addImport("pangofc1", pangofc1);
    pangoot1.addImport("fontconfig2", fontconfig2);
    pangoot1.addImport("pango1", pango1);
    pangoot1.addImport("cairo1", cairo1);
    pangoot1.addImport("gobject2", gobject2);
    pangoot1.addImport("glib2", glib2);
    pangoot1.addImport("harfbuzz0", harfbuzz0);
    pangoot1.addImport("gio2", gio2);
    pangoot1.addImport("gmodule2", gmodule2);
    pangoot1.addImport("pangoot1", pangoot1);

    pangofc1.addImport("fontconfig2", fontconfig2);
    pangofc1.addImport("pango1", pango1);
    pangofc1.addImport("cairo1", cairo1);
    pangofc1.addImport("gobject2", gobject2);
    pangofc1.addImport("glib2", glib2);
    pangofc1.addImport("harfbuzz0", harfbuzz0);
    pangofc1.addImport("freetype22", freetype22);
    pangofc1.addImport("gio2", gio2);
    pangofc1.addImport("gmodule2", gmodule2);
    pangofc1.addImport("pangofc1", pangofc1);

    fontconfig2.addImport("fontconfig2", fontconfig2);

    pangoft21.addImport("freetype22", freetype22);
    pangoft21.addImport("pangofc1", pangofc1);
    pangoft21.addImport("fontconfig2", fontconfig2);
    pangoft21.addImport("pango1", pango1);
    pangoft21.addImport("cairo1", cairo1);
    pangoft21.addImport("gobject2", gobject2);
    pangoft21.addImport("glib2", glib2);
    pangoft21.addImport("harfbuzz0", harfbuzz0);
    pangoft21.addImport("gio2", gio2);
    pangoft21.addImport("gmodule2", gmodule2);
    pangoft21.addImport("pangoft21", pangoft21);

    notify0.addImport("gdkpixbuf2", gdkpixbuf2);
    notify0.addImport("gio2", gio2);
    notify0.addImport("gobject2", gobject2);
    notify0.addImport("glib2", glib2);
    notify0.addImport("gmodule2", gmodule2);
    notify0.addImport("notify0", notify0);

    nice0.addImport("gio2", gio2);
    nice0.addImport("gobject2", gobject2);
    nice0.addImport("glib2", glib2);
    nice0.addImport("gmodule2", gmodule2);
    nice0.addImport("nice0", nice0);

    manette0.addImport("gio2", gio2);
    manette0.addImport("gobject2", gobject2);
    manette0.addImport("glib2", glib2);
    manette0.addImport("gmodule2", gmodule2);
    manette0.addImport("gudev1", gudev1);
    manette0.addImport("manette0", manette0);

    gudev1.addImport("gobject2", gobject2);
    gudev1.addImport("glib2", glib2);
    gudev1.addImport("gudev1", gudev1);

    libxml22.addImport("libxml22", libxml22);

    libproxy1.addImport("gio2", gio2);
    libproxy1.addImport("gobject2", gobject2);
    libproxy1.addImport("glib2", glib2);
    libproxy1.addImport("gmodule2", gmodule2);
    libproxy1.addImport("libproxy1", libproxy1);

    json1.addImport("gio2", gio2);
    json1.addImport("gobject2", gobject2);
    json1.addImport("glib2", glib2);
    json1.addImport("gmodule2", gmodule2);
    json1.addImport("json1", json1);

    ibus1.addImport("gio2", gio2);
    ibus1.addImport("gobject2", gobject2);
    ibus1.addImport("glib2", glib2);
    ibus1.addImport("gmodule2", gmodule2);
    ibus1.addImport("ibus1", ibus1);

    handy1.addImport("gtk3", gtk3);
    handy1.addImport("xlib2", xlib2);
    handy1.addImport("gdk3", gdk3);
    handy1.addImport("cairo1", cairo1);
    handy1.addImport("gobject2", gobject2);
    handy1.addImport("glib2", glib2);
    handy1.addImport("pango1", pango1);
    handy1.addImport("harfbuzz0", harfbuzz0);
    handy1.addImport("freetype22", freetype22);
    handy1.addImport("gio2", gio2);
    handy1.addImport("gmodule2", gmodule2);
    handy1.addImport("gdkpixbuf2", gdkpixbuf2);
    handy1.addImport("atk1", atk1);
    handy1.addImport("handy1", handy1);

    gtksource5.addImport("gtk4", gtk4);
    gtksource5.addImport("gsk4", gsk4);
    gtksource5.addImport("graphene1", graphene1);
    gtksource5.addImport("gobject2", gobject2);
    gtksource5.addImport("glib2", glib2);
    gtksource5.addImport("gdk4", gdk4);
    gtksource5.addImport("cairo1", cairo1);
    gtksource5.addImport("pangocairo1", pangocairo1);
    gtksource5.addImport("pango1", pango1);
    gtksource5.addImport("harfbuzz0", harfbuzz0);
    gtksource5.addImport("freetype22", freetype22);
    gtksource5.addImport("gio2", gio2);
    gtksource5.addImport("gmodule2", gmodule2);
    gtksource5.addImport("gdkpixbuf2", gdkpixbuf2);
    gtksource5.addImport("gtksource5", gtksource5);

    gstwebrtc1.addImport("gstsdp1", gstsdp1);
    gstwebrtc1.addImport("gst1", gst1);
    gstwebrtc1.addImport("gobject2", gobject2);
    gstwebrtc1.addImport("glib2", glib2);
    gstwebrtc1.addImport("gmodule2", gmodule2);
    gstwebrtc1.addImport("gstwebrtc1", gstwebrtc1);

    gstsdp1.addImport("gst1", gst1);
    gstsdp1.addImport("gobject2", gobject2);
    gstsdp1.addImport("glib2", glib2);
    gstsdp1.addImport("gmodule2", gmodule2);
    gstsdp1.addImport("gstsdp1", gstsdp1);

    gst1.addImport("gobject2", gobject2);
    gst1.addImport("glib2", glib2);
    gst1.addImport("gmodule2", gmodule2);
    gst1.addImport("gst1", gst1);

    gstvulkanxcb1.addImport("vulkan1", vulkan1);
    gstvulkanxcb1.addImport("gstvulkan1", gstvulkan1);
    gstvulkanxcb1.addImport("gstvideo1", gstvideo1);
    gstvulkanxcb1.addImport("gstbase1", gstbase1);
    gstvulkanxcb1.addImport("gst1", gst1);
    gstvulkanxcb1.addImport("gobject2", gobject2);
    gstvulkanxcb1.addImport("glib2", glib2);
    gstvulkanxcb1.addImport("gmodule2", gmodule2);
    gstvulkanxcb1.addImport("gstvulkanxcb1", gstvulkanxcb1);

    gstvulkan1.addImport("vulkan1", vulkan1);
    gstvulkan1.addImport("gstvideo1", gstvideo1);
    gstvulkan1.addImport("gstbase1", gstbase1);
    gstvulkan1.addImport("gst1", gst1);
    gstvulkan1.addImport("gobject2", gobject2);
    gstvulkan1.addImport("glib2", glib2);
    gstvulkan1.addImport("gmodule2", gmodule2);
    gstvulkan1.addImport("gstvulkan1", gstvulkan1);

    gstvideo1.addImport("gstbase1", gstbase1);
    gstvideo1.addImport("gst1", gst1);
    gstvideo1.addImport("gobject2", gobject2);
    gstvideo1.addImport("glib2", glib2);
    gstvideo1.addImport("gmodule2", gmodule2);
    gstvideo1.addImport("gstvideo1", gstvideo1);

    gstbase1.addImport("gst1", gst1);
    gstbase1.addImport("gobject2", gobject2);
    gstbase1.addImport("glib2", glib2);
    gstbase1.addImport("gmodule2", gmodule2);
    gstbase1.addImport("gstbase1", gstbase1);

    gstvulkanwayland1.addImport("vulkan1", vulkan1);
    gstvulkanwayland1.addImport("gstvulkan1", gstvulkan1);
    gstvulkanwayland1.addImport("gstvideo1", gstvideo1);
    gstvulkanwayland1.addImport("gstbase1", gstbase1);
    gstvulkanwayland1.addImport("gst1", gst1);
    gstvulkanwayland1.addImport("gobject2", gobject2);
    gstvulkanwayland1.addImport("glib2", glib2);
    gstvulkanwayland1.addImport("gmodule2", gmodule2);
    gstvulkanwayland1.addImport("gstvulkanwayland1", gstvulkanwayland1);

    gstva1.addImport("gstvideo1", gstvideo1);
    gstva1.addImport("gstbase1", gstbase1);
    gstva1.addImport("gst1", gst1);
    gstva1.addImport("gobject2", gobject2);
    gstva1.addImport("glib2", glib2);
    gstva1.addImport("gmodule2", gmodule2);
    gstva1.addImport("gstva1", gstva1);

    gsttranscoder1.addImport("gstpbutils1", gstpbutils1);
    gsttranscoder1.addImport("gstvideo1", gstvideo1);
    gsttranscoder1.addImport("gstbase1", gstbase1);
    gsttranscoder1.addImport("gst1", gst1);
    gsttranscoder1.addImport("gobject2", gobject2);
    gsttranscoder1.addImport("glib2", glib2);
    gsttranscoder1.addImport("gmodule2", gmodule2);
    gsttranscoder1.addImport("gstaudio1", gstaudio1);
    gsttranscoder1.addImport("gsttranscoder1", gsttranscoder1);

    gstpbutils1.addImport("gstvideo1", gstvideo1);
    gstpbutils1.addImport("gstbase1", gstbase1);
    gstpbutils1.addImport("gst1", gst1);
    gstpbutils1.addImport("gobject2", gobject2);
    gstpbutils1.addImport("glib2", glib2);
    gstpbutils1.addImport("gmodule2", gmodule2);
    gstpbutils1.addImport("gstaudio1", gstaudio1);
    gstpbutils1.addImport("gstpbutils1", gstpbutils1);

    gstaudio1.addImport("gstbase1", gstbase1);
    gstaudio1.addImport("gst1", gst1);
    gstaudio1.addImport("gobject2", gobject2);
    gstaudio1.addImport("glib2", glib2);
    gstaudio1.addImport("gmodule2", gmodule2);
    gstaudio1.addImport("gstaudio1", gstaudio1);

    gsttag1.addImport("gstbase1", gstbase1);
    gsttag1.addImport("gst1", gst1);
    gsttag1.addImport("gobject2", gobject2);
    gsttag1.addImport("glib2", glib2);
    gsttag1.addImport("gmodule2", gmodule2);
    gsttag1.addImport("gsttag1", gsttag1);

    gstrtsp1.addImport("gstsdp1", gstsdp1);
    gstrtsp1.addImport("gst1", gst1);
    gstrtsp1.addImport("gobject2", gobject2);
    gstrtsp1.addImport("glib2", glib2);
    gstrtsp1.addImport("gmodule2", gmodule2);
    gstrtsp1.addImport("gstbase1", gstbase1);
    gstrtsp1.addImport("gio2", gio2);
    gstrtsp1.addImport("gstrtsp1", gstrtsp1);

    gstrtp1.addImport("gstbase1", gstbase1);
    gstrtp1.addImport("gst1", gst1);
    gstrtp1.addImport("gobject2", gobject2);
    gstrtp1.addImport("glib2", glib2);
    gstrtp1.addImport("gmodule2", gmodule2);
    gstrtp1.addImport("gstrtp1", gstrtp1);

    gstplayer1.addImport("gstvideo1", gstvideo1);
    gstplayer1.addImport("gstbase1", gstbase1);
    gstplayer1.addImport("gst1", gst1);
    gstplayer1.addImport("gobject2", gobject2);
    gstplayer1.addImport("glib2", glib2);
    gstplayer1.addImport("gmodule2", gmodule2);
    gstplayer1.addImport("gsttag1", gsttag1);
    gstplayer1.addImport("gstpbutils1", gstpbutils1);
    gstplayer1.addImport("gstaudio1", gstaudio1);
    gstplayer1.addImport("gstplayer1", gstplayer1);

    gstplay1.addImport("gstvideo1", gstvideo1);
    gstplay1.addImport("gstbase1", gstbase1);
    gstplay1.addImport("gst1", gst1);
    gstplay1.addImport("gobject2", gobject2);
    gstplay1.addImport("glib2", glib2);
    gstplay1.addImport("gmodule2", gmodule2);
    gstplay1.addImport("gsttag1", gsttag1);
    gstplay1.addImport("gstpbutils1", gstpbutils1);
    gstplay1.addImport("gstaudio1", gstaudio1);
    gstplay1.addImport("gstplay1", gstplay1);

    gstnet1.addImport("gst1", gst1);
    gstnet1.addImport("gobject2", gobject2);
    gstnet1.addImport("glib2", glib2);
    gstnet1.addImport("gmodule2", gmodule2);
    gstnet1.addImport("gio2", gio2);
    gstnet1.addImport("gstnet1", gstnet1);

    gstmse1.addImport("gst1", gst1);
    gstmse1.addImport("gobject2", gobject2);
    gstmse1.addImport("glib2", glib2);
    gstmse1.addImport("gmodule2", gmodule2);
    gstmse1.addImport("gstmse1", gstmse1);

    gstmpegts1.addImport("gst1", gst1);
    gstmpegts1.addImport("gobject2", gobject2);
    gstmpegts1.addImport("glib2", glib2);
    gstmpegts1.addImport("gmodule2", gmodule2);
    gstmpegts1.addImport("gstmpegts1", gstmpegts1);

    gstinsertbin1.addImport("gst1", gst1);
    gstinsertbin1.addImport("gobject2", gobject2);
    gstinsertbin1.addImport("glib2", glib2);
    gstinsertbin1.addImport("gmodule2", gmodule2);
    gstinsertbin1.addImport("gstinsertbin1", gstinsertbin1);

    gstglx111.addImport("gstvideo1", gstvideo1);
    gstglx111.addImport("gstbase1", gstbase1);
    gstglx111.addImport("gst1", gst1);
    gstglx111.addImport("gobject2", gobject2);
    gstglx111.addImport("glib2", glib2);
    gstglx111.addImport("gmodule2", gmodule2);
    gstglx111.addImport("gstgl1", gstgl1);
    gstglx111.addImport("gstglx111", gstglx111);

    gstgl1.addImport("gstvideo1", gstvideo1);
    gstgl1.addImport("gstbase1", gstbase1);
    gstgl1.addImport("gst1", gst1);
    gstgl1.addImport("gobject2", gobject2);
    gstgl1.addImport("glib2", glib2);
    gstgl1.addImport("gmodule2", gmodule2);
    gstgl1.addImport("gstgl1", gstgl1);

    gstglwayland1.addImport("gstvideo1", gstvideo1);
    gstglwayland1.addImport("gstbase1", gstbase1);
    gstglwayland1.addImport("gst1", gst1);
    gstglwayland1.addImport("gobject2", gobject2);
    gstglwayland1.addImport("glib2", glib2);
    gstglwayland1.addImport("gmodule2", gmodule2);
    gstglwayland1.addImport("gstgl1", gstgl1);
    gstglwayland1.addImport("gstglwayland1", gstglwayland1);

    gstglegl1.addImport("gstvideo1", gstvideo1);
    gstglegl1.addImport("gstbase1", gstbase1);
    gstglegl1.addImport("gst1", gst1);
    gstglegl1.addImport("gobject2", gobject2);
    gstglegl1.addImport("glib2", glib2);
    gstglegl1.addImport("gmodule2", gmodule2);
    gstglegl1.addImport("gstgl1", gstgl1);
    gstglegl1.addImport("gstglegl1", gstglegl1);

    gstcuda1.addImport("gstvideo1", gstvideo1);
    gstcuda1.addImport("gstbase1", gstbase1);
    gstcuda1.addImport("gst1", gst1);
    gstcuda1.addImport("gobject2", gobject2);
    gstcuda1.addImport("glib2", glib2);
    gstcuda1.addImport("gmodule2", gmodule2);
    gstcuda1.addImport("gstgl1", gstgl1);
    gstcuda1.addImport("cudagst1", cudagst1);
    gstcuda1.addImport("gstcuda1", gstcuda1);

    cudagst1.addImport("cudagst1", cudagst1);

    gstcontroller1.addImport("gst1", gst1);
    gstcontroller1.addImport("gobject2", gobject2);
    gstcontroller1.addImport("glib2", glib2);
    gstcontroller1.addImport("gmodule2", gmodule2);
    gstcontroller1.addImport("gstcontroller1", gstcontroller1);

    gstcheck1.addImport("gst1", gst1);
    gstcheck1.addImport("gobject2", gobject2);
    gstcheck1.addImport("glib2", glib2);
    gstcheck1.addImport("gmodule2", gmodule2);
    gstcheck1.addImport("gstcheck1", gstcheck1);

    gstbadaudio1.addImport("gstbase1", gstbase1);
    gstbadaudio1.addImport("gst1", gst1);
    gstbadaudio1.addImport("gobject2", gobject2);
    gstbadaudio1.addImport("glib2", glib2);
    gstbadaudio1.addImport("gmodule2", gmodule2);
    gstbadaudio1.addImport("gstaudio1", gstaudio1);
    gstbadaudio1.addImport("gstbadaudio1", gstbadaudio1);

    gstapp1.addImport("gstbase1", gstbase1);
    gstapp1.addImport("gst1", gst1);
    gstapp1.addImport("gobject2", gobject2);
    gstapp1.addImport("glib2", glib2);
    gstapp1.addImport("gmodule2", gmodule2);
    gstapp1.addImport("gstapp1", gstapp1);

    gstanalytics1.addImport("gstbase1", gstbase1);
    gstanalytics1.addImport("gst1", gst1);
    gstanalytics1.addImport("gobject2", gobject2);
    gstanalytics1.addImport("glib2", glib2);
    gstanalytics1.addImport("gmodule2", gmodule2);
    gstanalytics1.addImport("gstanalytics1", gstanalytics1);

    gstallocators1.addImport("gst1", gst1);
    gstallocators1.addImport("gobject2", gobject2);
    gstallocators1.addImport("glib2", glib2);
    gstallocators1.addImport("gmodule2", gmodule2);
    gstallocators1.addImport("gstallocators1", gstallocators1);

    glibunix2.addImport("glib2", glib2);
    glibunix2.addImport("glibunix2", glibunix2);

    gl1.addImport("gl1", gl1);

    girepository3.addImport("gio2", gio2);
    girepository3.addImport("gobject2", gobject2);
    girepository3.addImport("glib2", glib2);
    girepository3.addImport("gmodule2", gmodule2);
    girepository3.addImport("girepository3", girepository3);

    girepository2.addImport("gobject2", gobject2);
    girepository2.addImport("glib2", glib2);
    girepository2.addImport("girepository2", girepository2);

    giounix2.addImport("gio2", gio2);
    giounix2.addImport("gobject2", gobject2);
    giounix2.addImport("glib2", glib2);
    giounix2.addImport("gmodule2", gmodule2);
    giounix2.addImport("giounix2", giounix2);

    geoclue2.addImport("gio2", gio2);
    geoclue2.addImport("gobject2", gobject2);
    geoclue2.addImport("glib2", glib2);
    geoclue2.addImport("gmodule2", gmodule2);
    geoclue2.addImport("geoclue2", geoclue2);

    gee0.addImport("gio2", gio2);
    gee0.addImport("gobject2", gobject2);
    gee0.addImport("glib2", glib2);
    gee0.addImport("gmodule2", gmodule2);
    gee0.addImport("gee0", gee0);

    gdkx114.addImport("xlib2", xlib2);
    gdkx114.addImport("gdk4", gdk4);
    gdkx114.addImport("cairo1", cairo1);
    gdkx114.addImport("gobject2", gobject2);
    gdkx114.addImport("glib2", glib2);
    gdkx114.addImport("pangocairo1", pangocairo1);
    gdkx114.addImport("pango1", pango1);
    gdkx114.addImport("harfbuzz0", harfbuzz0);
    gdkx114.addImport("freetype22", freetype22);
    gdkx114.addImport("gio2", gio2);
    gdkx114.addImport("gmodule2", gmodule2);
    gdkx114.addImport("gdkpixbuf2", gdkpixbuf2);
    gdkx114.addImport("gdkx114", gdkx114);

    gdkx113.addImport("xlib2", xlib2);
    gdkx113.addImport("cairo1", cairo1);
    gdkx113.addImport("gobject2", gobject2);
    gdkx113.addImport("glib2", glib2);
    gdkx113.addImport("pango1", pango1);
    gdkx113.addImport("harfbuzz0", harfbuzz0);
    gdkx113.addImport("freetype22", freetype22);
    gdkx113.addImport("gio2", gio2);
    gdkx113.addImport("gmodule2", gmodule2);
    gdkx113.addImport("gdkpixbuf2", gdkpixbuf2);
    gdkx113.addImport("gdk3", gdk3);
    gdkx113.addImport("gdkx113", gdkx113);

    gdkwayland4.addImport("gdk4", gdk4);
    gdkwayland4.addImport("cairo1", cairo1);
    gdkwayland4.addImport("gobject2", gobject2);
    gdkwayland4.addImport("glib2", glib2);
    gdkwayland4.addImport("pangocairo1", pangocairo1);
    gdkwayland4.addImport("pango1", pango1);
    gdkwayland4.addImport("harfbuzz0", harfbuzz0);
    gdkwayland4.addImport("freetype22", freetype22);
    gdkwayland4.addImport("gio2", gio2);
    gdkwayland4.addImport("gmodule2", gmodule2);
    gdkwayland4.addImport("gdkpixbuf2", gdkpixbuf2);
    gdkwayland4.addImport("gdkwayland4", gdkwayland4);

    gdkpixdata2.addImport("gdkpixbuf2", gdkpixbuf2);
    gdkpixdata2.addImport("gio2", gio2);
    gdkpixdata2.addImport("gobject2", gobject2);
    gdkpixdata2.addImport("glib2", glib2);
    gdkpixdata2.addImport("gmodule2", gmodule2);
    gdkpixdata2.addImport("gdkpixdata2", gdkpixdata2);

    gdesktopenums3.addImport("gdesktopenums3", gdesktopenums3);

    gcrui3.addImport("gtk3", gtk3);
    gcrui3.addImport("xlib2", xlib2);
    gcrui3.addImport("gdk3", gdk3);
    gcrui3.addImport("cairo1", cairo1);
    gcrui3.addImport("gobject2", gobject2);
    gcrui3.addImport("glib2", glib2);
    gcrui3.addImport("pango1", pango1);
    gcrui3.addImport("harfbuzz0", harfbuzz0);
    gcrui3.addImport("freetype22", freetype22);
    gcrui3.addImport("gio2", gio2);
    gcrui3.addImport("gmodule2", gmodule2);
    gcrui3.addImport("gdkpixbuf2", gdkpixbuf2);
    gcrui3.addImport("atk1", atk1);
    gcrui3.addImport("gcr3", gcr3);
    gcrui3.addImport("gck1", gck1);
    gcrui3.addImport("gcrui3", gcrui3);

    gcr3.addImport("gio2", gio2);
    gcr3.addImport("gobject2", gobject2);
    gcr3.addImport("glib2", glib2);
    gcr3.addImport("gmodule2", gmodule2);
    gcr3.addImport("gck1", gck1);
    gcr3.addImport("gcr3", gcr3);

    gck1.addImport("gio2", gio2);
    gck1.addImport("gobject2", gobject2);
    gck1.addImport("glib2", glib2);
    gck1.addImport("gmodule2", gmodule2);
    gck1.addImport("gck1", gck1);

    gcr4.addImport("gio2", gio2);
    gcr4.addImport("gobject2", gobject2);
    gcr4.addImport("glib2", glib2);
    gcr4.addImport("gmodule2", gmodule2);
    gcr4.addImport("gck2", gck2);
    gcr4.addImport("gcr4", gcr4);

    gck2.addImport("gio2", gio2);
    gck2.addImport("gobject2", gobject2);
    gck2.addImport("glib2", glib2);
    gck2.addImport("gmodule2", gmodule2);
    gck2.addImport("gck2", gck2);

    gcab1.addImport("gio2", gio2);
    gcab1.addImport("gobject2", gobject2);
    gcab1.addImport("glib2", glib2);
    gcab1.addImport("gmodule2", gmodule2);
    gcab1.addImport("gcab1", gcab1);

    dex1.addImport("gio2", gio2);
    dex1.addImport("gobject2", gobject2);
    dex1.addImport("glib2", glib2);
    dex1.addImport("gmodule2", gmodule2);
    dex1.addImport("dex1", dex1);

    dbus1.addImport("dbus1", dbus1);

    atspi2.addImport("gobject2", gobject2);
    atspi2.addImport("glib2", glib2);
    atspi2.addImport("dbus1", dbus1);
    atspi2.addImport("atspi2", atspi2);

    appstreamcompose1.addImport("gio2", gio2);
    appstreamcompose1.addImport("gobject2", gobject2);
    appstreamcompose1.addImport("glib2", glib2);
    appstreamcompose1.addImport("gmodule2", gmodule2);
    appstreamcompose1.addImport("gdkpixbuf2", gdkpixbuf2);
    appstreamcompose1.addImport("appstream1", appstream1);
    appstreamcompose1.addImport("appstreamcompose1", appstreamcompose1);

    appstream1.addImport("gio2", gio2);
    appstream1.addImport("gobject2", gobject2);
    appstream1.addImport("glib2", glib2);
    appstream1.addImport("gmodule2", gmodule2);
    appstream1.addImport("appstream1", appstream1);

    adw1.addImport("gtk4", gtk4);
    adw1.addImport("gsk4", gsk4);
    adw1.addImport("graphene1", graphene1);
    adw1.addImport("gobject2", gobject2);
    adw1.addImport("glib2", glib2);
    adw1.addImport("gdk4", gdk4);
    adw1.addImport("cairo1", cairo1);
    adw1.addImport("pangocairo1", pangocairo1);
    adw1.addImport("pango1", pango1);
    adw1.addImport("harfbuzz0", harfbuzz0);
    adw1.addImport("freetype22", freetype22);
    adw1.addImport("gio2", gio2);
    adw1.addImport("gmodule2", gmodule2);
    adw1.addImport("gdkpixbuf2", gdkpixbuf2);
    adw1.addImport("adw1", adw1);

    const docs_obj = b.addObject(.{
        .name = "docs",
        .root_source_file = b.path("src/root/root.zig"),
        .target = target,
        .optimize = .Debug,
    });
    const install_docs = b.addInstallDirectory(.{
        .source_dir = docs_obj.getEmittedDocs(),
        .install_dir = .prefix,
        .install_subdir = "docs",
    });
    b.step("docs", "Generate documentation").dependOn(&install_docs.step);
    docs_obj.root_module.addImport("xrandr1", xrandr1);
    docs_obj.root_module.addImport("xmlb2", xmlb2);
    docs_obj.root_module.addImport("gio2", gio2);
    docs_obj.root_module.addImport("gobject2", gobject2);
    docs_obj.root_module.addImport("glib2", glib2);
    docs_obj.root_module.addImport("gmodule2", gmodule2);
    docs_obj.root_module.addImport("xlib2", xlib2);
    docs_obj.root_module.addImport("xft2", xft2);
    docs_obj.root_module.addImport("xfixes4", xfixes4);
    docs_obj.root_module.addImport("win321", win321);
    docs_obj.root_module.addImport("webkitwebprocessextension6", webkitwebprocessextension6);
    docs_obj.root_module.addImport("soup3", soup3);
    docs_obj.root_module.addImport("javascriptcore6", javascriptcore6);
    docs_obj.root_module.addImport("gtk4", gtk4);
    docs_obj.root_module.addImport("gsk4", gsk4);
    docs_obj.root_module.addImport("graphene1", graphene1);
    docs_obj.root_module.addImport("gdk4", gdk4);
    docs_obj.root_module.addImport("cairo1", cairo1);
    docs_obj.root_module.addImport("pangocairo1", pangocairo1);
    docs_obj.root_module.addImport("pango1", pango1);
    docs_obj.root_module.addImport("harfbuzz0", harfbuzz0);
    docs_obj.root_module.addImport("freetype22", freetype22);
    docs_obj.root_module.addImport("gdkpixbuf2", gdkpixbuf2);
    docs_obj.root_module.addImport("webkit6", webkit6);
    docs_obj.root_module.addImport("webkit2webextension4", webkit2webextension4);
    docs_obj.root_module.addImport("javascriptcore4", javascriptcore4);
    docs_obj.root_module.addImport("gtk3", gtk3);
    docs_obj.root_module.addImport("gdk3", gdk3);
    docs_obj.root_module.addImport("atk1", atk1);
    docs_obj.root_module.addImport("webkit24", webkit24);
    docs_obj.root_module.addImport("vulkan1", vulkan1);
    docs_obj.root_module.addImport("tsparql3", tsparql3);
    docs_obj.root_module.addImport("tracker3", tracker3);
    docs_obj.root_module.addImport("secret1", secret1);
    docs_obj.root_module.addImport("rsvg2", rsvg2);
    docs_obj.root_module.addImport("polkit1", polkit1);
    docs_obj.root_module.addImport("pangoot1", pangoot1);
    docs_obj.root_module.addImport("pangofc1", pangofc1);
    docs_obj.root_module.addImport("fontconfig2", fontconfig2);
    docs_obj.root_module.addImport("pangoft21", pangoft21);
    docs_obj.root_module.addImport("notify0", notify0);
    docs_obj.root_module.addImport("nice0", nice0);
    docs_obj.root_module.addImport("manette0", manette0);
    docs_obj.root_module.addImport("gudev1", gudev1);
    docs_obj.root_module.addImport("libxml22", libxml22);
    docs_obj.root_module.addImport("libproxy1", libproxy1);
    docs_obj.root_module.addImport("json1", json1);
    docs_obj.root_module.addImport("ibus1", ibus1);
    docs_obj.root_module.addImport("handy1", handy1);
    docs_obj.root_module.addImport("gtksource5", gtksource5);
    docs_obj.root_module.addImport("gstwebrtc1", gstwebrtc1);
    docs_obj.root_module.addImport("gstsdp1", gstsdp1);
    docs_obj.root_module.addImport("gst1", gst1);
    docs_obj.root_module.addImport("gstvulkanxcb1", gstvulkanxcb1);
    docs_obj.root_module.addImport("gstvulkan1", gstvulkan1);
    docs_obj.root_module.addImport("gstvideo1", gstvideo1);
    docs_obj.root_module.addImport("gstbase1", gstbase1);
    docs_obj.root_module.addImport("gstvulkanwayland1", gstvulkanwayland1);
    docs_obj.root_module.addImport("gstva1", gstva1);
    docs_obj.root_module.addImport("gsttranscoder1", gsttranscoder1);
    docs_obj.root_module.addImport("gstpbutils1", gstpbutils1);
    docs_obj.root_module.addImport("gstaudio1", gstaudio1);
    docs_obj.root_module.addImport("gsttag1", gsttag1);
    docs_obj.root_module.addImport("gstrtsp1", gstrtsp1);
    docs_obj.root_module.addImport("gstrtp1", gstrtp1);
    docs_obj.root_module.addImport("gstplayer1", gstplayer1);
    docs_obj.root_module.addImport("gstplay1", gstplay1);
    docs_obj.root_module.addImport("gstnet1", gstnet1);
    docs_obj.root_module.addImport("gstmse1", gstmse1);
    docs_obj.root_module.addImport("gstmpegts1", gstmpegts1);
    docs_obj.root_module.addImport("gstinsertbin1", gstinsertbin1);
    docs_obj.root_module.addImport("gstglx111", gstglx111);
    docs_obj.root_module.addImport("gstgl1", gstgl1);
    docs_obj.root_module.addImport("gstglwayland1", gstglwayland1);
    docs_obj.root_module.addImport("gstglegl1", gstglegl1);
    docs_obj.root_module.addImport("gstcuda1", gstcuda1);
    docs_obj.root_module.addImport("cudagst1", cudagst1);
    docs_obj.root_module.addImport("gstcontroller1", gstcontroller1);
    docs_obj.root_module.addImport("gstcheck1", gstcheck1);
    docs_obj.root_module.addImport("gstbadaudio1", gstbadaudio1);
    docs_obj.root_module.addImport("gstapp1", gstapp1);
    docs_obj.root_module.addImport("gstanalytics1", gstanalytics1);
    docs_obj.root_module.addImport("gstallocators1", gstallocators1);
    docs_obj.root_module.addImport("glibunix2", glibunix2);
    docs_obj.root_module.addImport("gl1", gl1);
    docs_obj.root_module.addImport("girepository3", girepository3);
    docs_obj.root_module.addImport("girepository2", girepository2);
    docs_obj.root_module.addImport("giounix2", giounix2);
    docs_obj.root_module.addImport("geoclue2", geoclue2);
    docs_obj.root_module.addImport("gee0", gee0);
    docs_obj.root_module.addImport("gdkx114", gdkx114);
    docs_obj.root_module.addImport("gdkx113", gdkx113);
    docs_obj.root_module.addImport("gdkwayland4", gdkwayland4);
    docs_obj.root_module.addImport("gdkpixdata2", gdkpixdata2);
    docs_obj.root_module.addImport("gdesktopenums3", gdesktopenums3);
    docs_obj.root_module.addImport("gcrui3", gcrui3);
    docs_obj.root_module.addImport("gcr3", gcr3);
    docs_obj.root_module.addImport("gck1", gck1);
    docs_obj.root_module.addImport("gcr4", gcr4);
    docs_obj.root_module.addImport("gck2", gck2);
    docs_obj.root_module.addImport("gcab1", gcab1);
    docs_obj.root_module.addImport("dex1", dex1);
    docs_obj.root_module.addImport("dbus1", dbus1);
    docs_obj.root_module.addImport("atspi2", atspi2);
    docs_obj.root_module.addImport("appstreamcompose1", appstreamcompose1);
    docs_obj.root_module.addImport("appstream1", appstream1);
    docs_obj.root_module.addImport("adw1", adw1);
}

/// A library accessible through the generated bindings.
///
/// While the generated bindings are typically used through modules
/// (e.g. `gobject.module("glib-2.0")`), there are cases where it is
/// useful to have additional information about the libraries exposed
/// to the build script. For example, if any files in the root module
/// of the application want to import a library's C headers directly,
/// it will be necessary to link the library directly to the root module
/// using `Library.linkTo` so the include paths will be available.
pub const Library = struct {
    /// System libraries to be linked using pkg-config.
    system_libraries: []const []const u8,

    /// Links `lib` to `module`.
    pub fn linkTo(lib: Library, module: *std.Build.Module) void {
        module.link_libc = true;
        for (lib.system_libraries) |system_lib| {
            module.linkSystemLibrary(system_lib, .{});
        }
    }
};

pub const libraries = struct {
    pub const xrandr1: Library = .{
        .system_libraries = &.{},
    };

    pub const xmlb2: Library = .{
        .system_libraries = &.{"xmlb"},
    };

    pub const gio2: Library = .{
        .system_libraries = &.{ "gio-2.0", "gio-unix-2.0" },
    };

    pub const gobject2: Library = .{
        .system_libraries = &.{"gobject-2.0"},
    };

    pub const glib2: Library = .{
        .system_libraries = &.{"glib-2.0"},
    };

    pub const gmodule2: Library = .{
        .system_libraries = &.{"gmodule-2.0"},
    };

    pub const xlib2: Library = .{
        .system_libraries = &.{},
    };

    pub const xft2: Library = .{
        .system_libraries = &.{},
    };

    pub const xfixes4: Library = .{
        .system_libraries = &.{},
    };

    pub const win321: Library = .{
        .system_libraries = &.{},
    };

    pub const webkitwebprocessextension6: Library = .{
        .system_libraries = &.{"webkitgtk-web-process-extension-6.0"},
    };

    pub const soup3: Library = .{
        .system_libraries = &.{"libsoup-3.0"},
    };

    pub const javascriptcore6: Library = .{
        .system_libraries = &.{"javascriptcoregtk-6.0"},
    };

    pub const gtk4: Library = .{
        .system_libraries = &.{"gtk4"},
    };

    pub const gsk4: Library = .{
        .system_libraries = &.{"gtk4"},
    };

    pub const graphene1: Library = .{
        .system_libraries = &.{"graphene-gobject-1.0"},
    };

    pub const gdk4: Library = .{
        .system_libraries = &.{"gtk4"},
    };

    pub const cairo1: Library = .{
        .system_libraries = &.{"cairo-gobject"},
    };

    pub const pangocairo1: Library = .{
        .system_libraries = &.{"pangocairo"},
    };

    pub const pango1: Library = .{
        .system_libraries = &.{"pango"},
    };

    pub const harfbuzz0: Library = .{
        .system_libraries = &.{ "harfbuzz", "harfbuzz-gobject" },
    };

    pub const freetype22: Library = .{
        .system_libraries = &.{},
    };

    pub const gdkpixbuf2: Library = .{
        .system_libraries = &.{"gdk-pixbuf-2.0"},
    };

    pub const webkit6: Library = .{
        .system_libraries = &.{"webkitgtk-6.0"},
    };

    pub const webkit2webextension4: Library = .{
        .system_libraries = &.{"webkit2gtk-web-extension-4.1"},
    };

    pub const javascriptcore4: Library = .{
        .system_libraries = &.{"javascriptcoregtk-4.1"},
    };

    pub const gtk3: Library = .{
        .system_libraries = &.{"gtk+-3.0"},
    };

    pub const gdk3: Library = .{
        .system_libraries = &.{"gdk-3.0"},
    };

    pub const atk1: Library = .{
        .system_libraries = &.{"atk"},
    };

    pub const webkit24: Library = .{
        .system_libraries = &.{"webkit2gtk-4.1"},
    };

    pub const vulkan1: Library = .{
        .system_libraries = &.{},
    };

    pub const tsparql3: Library = .{
        .system_libraries = &.{"tinysparql-3.0"},
    };

    pub const tracker3: Library = .{
        .system_libraries = &.{"tracker-sparql-3.0"},
    };

    pub const secret1: Library = .{
        .system_libraries = &.{"libsecret-1"},
    };

    pub const rsvg2: Library = .{
        .system_libraries = &.{"librsvg-2.0"},
    };

    pub const polkit1: Library = .{
        .system_libraries = &.{"polkit-gobject-1"},
    };

    pub const pangoot1: Library = .{
        .system_libraries = &.{"pangoot"},
    };

    pub const pangofc1: Library = .{
        .system_libraries = &.{"pangofc"},
    };

    pub const fontconfig2: Library = .{
        .system_libraries = &.{},
    };

    pub const pangoft21: Library = .{
        .system_libraries = &.{"pangoft2"},
    };

    pub const notify0: Library = .{
        .system_libraries = &.{"libnotify"},
    };

    pub const nice0: Library = .{
        .system_libraries = &.{"nice"},
    };

    pub const manette0: Library = .{
        .system_libraries = &.{"manette-0.2"},
    };

    pub const gudev1: Library = .{
        .system_libraries = &.{"gudev-1.0"},
    };

    pub const libxml22: Library = .{
        .system_libraries = &.{"libxml-2.0"},
    };

    pub const libproxy1: Library = .{
        .system_libraries = &.{"libproxy-1.0"},
    };

    pub const json1: Library = .{
        .system_libraries = &.{"json-glib-1.0"},
    };

    pub const ibus1: Library = .{
        .system_libraries = &.{"ibus-1.0"},
    };

    pub const handy1: Library = .{
        .system_libraries = &.{"libhandy-1"},
    };

    pub const gtksource5: Library = .{
        .system_libraries = &.{"gtksourceview-5"},
    };

    pub const gstwebrtc1: Library = .{
        .system_libraries = &.{"gstreamer-webrtc-1.0"},
    };

    pub const gstsdp1: Library = .{
        .system_libraries = &.{"gstreamer-sdp-1.0"},
    };

    pub const gst1: Library = .{
        .system_libraries = &.{"gstreamer-1.0"},
    };

    pub const gstvulkanxcb1: Library = .{
        .system_libraries = &.{"gstreamer-vulkan-xcb-1.0"},
    };

    pub const gstvulkan1: Library = .{
        .system_libraries = &.{"gstreamer-vulkan-1.0"},
    };

    pub const gstvideo1: Library = .{
        .system_libraries = &.{"gstreamer-video-1.0"},
    };

    pub const gstbase1: Library = .{
        .system_libraries = &.{"gstreamer-base-1.0"},
    };

    pub const gstvulkanwayland1: Library = .{
        .system_libraries = &.{"gstreamer-vulkan-wayland-1.0"},
    };

    pub const gstva1: Library = .{
        .system_libraries = &.{"gstreamer-va-1.0"},
    };

    pub const gsttranscoder1: Library = .{
        .system_libraries = &.{"gstreamer-transcoder-1.0"},
    };

    pub const gstpbutils1: Library = .{
        .system_libraries = &.{"gstreamer-pbutils-1.0"},
    };

    pub const gstaudio1: Library = .{
        .system_libraries = &.{"gstreamer-audio-1.0"},
    };

    pub const gsttag1: Library = .{
        .system_libraries = &.{"gstreamer-tag-1.0"},
    };

    pub const gstrtsp1: Library = .{
        .system_libraries = &.{"gstreamer-rtsp-1.0"},
    };

    pub const gstrtp1: Library = .{
        .system_libraries = &.{"gstreamer-rtp-1.0"},
    };

    pub const gstplayer1: Library = .{
        .system_libraries = &.{"gstreamer-player-1.0"},
    };

    pub const gstplay1: Library = .{
        .system_libraries = &.{"gstreamer-play-1.0"},
    };

    pub const gstnet1: Library = .{
        .system_libraries = &.{"gstreamer-net-1.0"},
    };

    pub const gstmse1: Library = .{
        .system_libraries = &.{"gstreamer-mse-1.0"},
    };

    pub const gstmpegts1: Library = .{
        .system_libraries = &.{"gstreamer-mpegts-1.0"},
    };

    pub const gstinsertbin1: Library = .{
        .system_libraries = &.{"gstreamer-insertbin-1.0"},
    };

    pub const gstglx111: Library = .{
        .system_libraries = &.{"gstreamer-gl-x11-1.0"},
    };

    pub const gstgl1: Library = .{
        .system_libraries = &.{"gstreamer-gl-1.0"},
    };

    pub const gstglwayland1: Library = .{
        .system_libraries = &.{"gstreamer-gl-wayland-1.0"},
    };

    pub const gstglegl1: Library = .{
        .system_libraries = &.{"gstreamer-gl-egl-1.0"},
    };

    pub const gstcuda1: Library = .{
        .system_libraries = &.{"gstreamer-cuda-1.0"},
    };

    pub const cudagst1: Library = .{
        .system_libraries = &.{},
    };

    pub const gstcontroller1: Library = .{
        .system_libraries = &.{"gstreamer-controller-1.0"},
    };

    pub const gstcheck1: Library = .{
        .system_libraries = &.{"gstreamer-check-1.0"},
    };

    pub const gstbadaudio1: Library = .{
        .system_libraries = &.{"gstreamer-bad-audio-1.0"},
    };

    pub const gstapp1: Library = .{
        .system_libraries = &.{"gstreamer-app-1.0"},
    };

    pub const gstanalytics1: Library = .{
        .system_libraries = &.{"gstreamer-analytics-1.0"},
    };

    pub const gstallocators1: Library = .{
        .system_libraries = &.{"gstreamer-allocators-1.0"},
    };

    pub const glibunix2: Library = .{
        .system_libraries = &.{"glib-2.0"},
    };

    pub const gl1: Library = .{
        .system_libraries = &.{},
    };

    pub const girepository3: Library = .{
        .system_libraries = &.{"girepository-2.0"},
    };

    pub const girepository2: Library = .{
        .system_libraries = &.{"gobject-introspection-1.0"},
    };

    pub const giounix2: Library = .{
        .system_libraries = &.{"gio-unix-2.0"},
    };

    pub const geoclue2: Library = .{
        .system_libraries = &.{"libgeoclue-2.0"},
    };

    pub const gee0: Library = .{
        .system_libraries = &.{"gee-0.8"},
    };

    pub const gdkx114: Library = .{
        .system_libraries = &.{"gtk4-x11"},
    };

    pub const gdkx113: Library = .{
        .system_libraries = &.{"gdk-x11-3.0"},
    };

    pub const gdkwayland4: Library = .{
        .system_libraries = &.{"gtk4-wayland"},
    };

    pub const gdkpixdata2: Library = .{
        .system_libraries = &.{"gdk-pixbuf-2.0"},
    };

    pub const gdesktopenums3: Library = .{
        .system_libraries = &.{},
    };

    pub const gcrui3: Library = .{
        .system_libraries = &.{"gcr-ui-3"},
    };

    pub const gcr3: Library = .{
        .system_libraries = &.{"gcr-base-3"},
    };

    pub const gck1: Library = .{
        .system_libraries = &.{"gck-1"},
    };

    pub const gcr4: Library = .{
        .system_libraries = &.{"gcr-4"},
    };

    pub const gck2: Library = .{
        .system_libraries = &.{"gck-2"},
    };

    pub const gcab1: Library = .{
        .system_libraries = &.{"libgcab-1.0"},
    };

    pub const dex1: Library = .{
        .system_libraries = &.{"libdex-1"},
    };

    pub const dbus1: Library = .{
        .system_libraries = &.{"dbus-1"},
    };

    pub const atspi2: Library = .{
        .system_libraries = &.{"atspi-2"},
    };

    pub const appstreamcompose1: Library = .{
        .system_libraries = &.{"appstream-compose"},
    };

    pub const appstream1: Library = .{
        .system_libraries = &.{"appstream"},
    };

    pub const adw1: Library = .{
        .system_libraries = &.{"libadwaita-1"},
    };
};

/// Returns a `std.Build.Module` created by compiling the GResources file at `path`.
///
/// This requires the `glib-compile-resources` system command to be available.
pub fn addCompileResources(
    b: *std.Build,
    target: std.Build.ResolvedTarget,
    path: std.Build.LazyPath,
) *std.Build.Module {
    const compile_resources = b.addSystemCommand(&.{ "glib-compile-resources", "--generate-source" });
    compile_resources.addArg("--target");
    const gresources_c = compile_resources.addOutputFileArg("gresources.c");
    compile_resources.addArg("--sourcedir");
    compile_resources.addDirectoryArg(path.dirname());
    compile_resources.addArg("--dependency-file");
    _ = compile_resources.addDepFileOutputArg("gresources-deps");
    compile_resources.addFileArg(path);

    const module = b.createModule(.{ .target = target });
    module.addCSourceFile(.{ .file = gresources_c });
    libraries.gio2.linkTo(module);
    return module;
}
