/*
*  qm_player.h
*  QUIMUP main player window
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_PLAYER_H
#define QM_PLAYER_H

#include <QtWidgets>
#include <QApplication>
#include <QMainWindow>
#include <QCloseEvent>
#include <QHideEvent>
#include <QShowEvent>
#include <QFrame>
#include <QLabel>
#include <QPushButton>
#include <QSlider>
#include <QImage>
#include <QPixmap>
#include <QSettings>
#include <QTimer>
#include <QSignalMapper>
#include <QPalette>
#include <QObject>
#include <QDir>
#include <QProcess>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QSpacerItem>
#include <QMenu>
#include <QWidgetAction>
#include <stdlib.h>
#include "qm_clicklabel.h"
#include "qm_clickprogressbar.h"
#include "qm_config.h"
#include "qm_mpdcom.h"
#include "qm_trayicon.h"
#include "qm_scroller.h"
#include "qm_settings.h"
#include "qm_browser.h"
#include "qm_songinfo.h"

typedef struct qm_fonts
{
    int  title_size = 0;
    bool title_italic = false;
    bool title_bold = false;
    int  codecinfo_size = 0;
    bool codecinfo_bold = false;
    int  time_size = 0;
    bool time_bold = false;
    int  album_size = 0;
    bool album_bold = false;
    int  year_size = 0;
    bool year_bold = false;
    int  browser_size = 0;
    int  comment_size = 0;
    bool comment_italic = false;
}
qm_fonts;

class qm_Player : public QMainWindow
{
    Q_OBJECT

public:
    qm_Player(qm_Config *);
    virtual ~qm_Player();

    qm_Browser *browser_window;

protected:
    void keyPressEvent(QKeyEvent *);

public slots:
    void on_shutdown();
    void wakeup_call(bool);

private slots:
    void on_contextmenu();
    void on_mpdconnect_sgnl(bool, bool);
    void set_status(int, QString s = "");
    void on_signal(int);
    void on_new_song();
    void on_new_status(mpd_status *);
    void on_tray_clicked();
    void lock_progress(QMouseEvent *);
    void unlock_progress();
    void maximice();
    void minimice();
    void show_saved_albumart();
    void open_albumart_dir();
    void open_directory();
    void edit_tags();
    void rescan_tags();
    void set_colors();
    void set_fonts();
    void on_new_custom_art();
    void set_volume(int);
    void on_browser_keypress(QKeyEvent *);
    void config_actions();
    void run_user_action1();
    void run_user_action2();

private:
    QWidget *main_widget;
    QVBoxLayout *vbox_all;

    QLabel *main_display;
    QVBoxLayout *vbox_in_main_display;
    qm_Scroller *info_scroller;
    QHBoxLayout *hbox_info;
    QLabel
        *lb_extension,
        *lb_kbps,
        *lb_kHz;
    QSpacerItem *spacer_info;
    qm_clickLabel *lb_time;
    qm_clickProgressbar *pb_progress;
    QSpacerItem *spacer_main;

    QLabel *center_widget;
    QHBoxLayout *hbox_center;
    QLabel *lb_albumart;

    QWidget *wg_album_info;
    QVBoxLayout *vbox_album_info;
    QLabel *lb_album;
    QLabel *lb_year;
    QScrollArea *sa_comment;
    QLabel *lb_comment;

    QHBoxLayout *hbox_bottom;
    QPushButton
        *bt_prev,
        *bt_stop,
        *bt_playpause,
        *bt_next,
        *bt_browser,
        *bt_minmax,
        *bt_settings;
    QSlider *vol_slider;


    qm_Settings *settings_window;
    QSignalMapper *button_mapper;
    qm_trayIcon *the_trayicon;
    QTimer
        *maximizer,
        *minimizer;
    qm_Config *config;
    qm_mpdCommand *mpd_cmd;
    qm_songInfo *current_songinfo;
    qm_fonts *current_fonts;

    QString
        pb_stylesheet,
        current_mpd_dir,
        current_file_name,
        current_art_path;  // used in set_colors() and on_new_custom_art()
    int
        current_type,
        current_status,
        current_volume,
        current_song_pos,
        kbps_count_down,
        alphacycler,
        art_label_H,
        art_label_W,
        art_image_W,
        art_image_H,
        song_total_time,
        song_previous_time,
        cR, cG, cB,
        window_H,
        window_H_max,
        window_H_min,
        window_W_max,
        widget_W_setup,
        alpha_step,
        size_step,
        size_changed,
        vbox_all_margin,
        vboxall_space;

    bool
        b_repeat,
        b_random,
        b_single,
        b_consume,
        b_xfading,
        b_minmax_busy,
        b_mpd_sets_volume,
        b_stream,
        b_mpd_connected,
        b_settings_hidden,
        b_browser_hidden,
        b_nosong,
        b_lock_progress,
        b_really_close,
        b_use_trayicon,
        b_need_new_song,
        b_reshow_browser,
        b_reshow_settings,
        b_skip_khz,
        b_wayland,
        b_remote_server;

    QPixmap
        px_album_art,
        px_mm_fading; // mini-maximize

    QImage
        im_nopic,
        im_stream,
        im_albumart;

    QIcon
        ic_a_user,
        ic_bt_prev,
        ic_bt_stop,
        ic_bt_next,
        ic_bt_browser,
        ic_bt_minmax,
        ic_bt_settings,
        ic_bt_pp_pause,
        ic_bt_pp_play,
        ic_a_tagedit,
        ic_a_fileman,
        ic_a_viewer,
        ic_a_tagscan;

    QMenu
        *context_menu;
    QAction
        *a_user1,
        *a_user2,
        *a_viewer,
        *a_tagedit,
        *a_tagscan,
        *a_fileman;

    void setup_widgets();
    void set_themed_icons(bool);
    void retranslate();
    void init_vars();
    QString into_time(int);
    void get_and_set_albumart(int, QString);
    bool get_art_from_local_file(int, QString);
    void set_comment_text(QString);
    void set_album_text(QString);
    void set_year_text(QString);
    bool is_app_installed(QString);
    void disenable_menu_items();

protected:
    void closeEvent(QCloseEvent *);
    void hideEvent(QHideEvent *);
    void showEvent(QShowEvent *);
    void dragLeaveEvent(QDragLeaveEvent *);
    void dragEnterEvent(QDragEnterEvent *);
    void dragMoveEvent(QDragMoveEvent *);
    void dropEvent(QDropEvent *);
    // void moveEvent(QMoveEvent *); // never happens on wayland
};

#endif // QM_PLAYER_H
