// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/webrisk/v1/webrisk.proto

#include "google/cloud/webrisk/v1/internal/web_risk_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/webrisk/v1/webrisk.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace webrisk_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

WebRiskServiceMetadata::WebRiskServiceMetadata(
    std::shared_ptr<WebRiskServiceStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::webrisk::v1::ComputeThreatListDiffResponse>
WebRiskServiceMetadata::ComputeThreatListDiff(
    grpc::ClientContext& context, Options const& options,
    google::cloud::webrisk::v1::ComputeThreatListDiffRequest const& request) {
  SetMetadata(context, options);
  return child_->ComputeThreatListDiff(context, options, request);
}

StatusOr<google::cloud::webrisk::v1::SearchUrisResponse>
WebRiskServiceMetadata::SearchUris(
    grpc::ClientContext& context, Options const& options,
    google::cloud::webrisk::v1::SearchUrisRequest const& request) {
  SetMetadata(context, options);
  return child_->SearchUris(context, options, request);
}

StatusOr<google::cloud::webrisk::v1::SearchHashesResponse>
WebRiskServiceMetadata::SearchHashes(
    grpc::ClientContext& context, Options const& options,
    google::cloud::webrisk::v1::SearchHashesRequest const& request) {
  SetMetadata(context, options);
  return child_->SearchHashes(context, options, request);
}

StatusOr<google::cloud::webrisk::v1::Submission>
WebRiskServiceMetadata::CreateSubmission(
    grpc::ClientContext& context, Options const& options,
    google::cloud::webrisk::v1::CreateSubmissionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateSubmission(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
WebRiskServiceMetadata::AsyncSubmitUri(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::webrisk::v1::SubmitUriRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncSubmitUri(cq, std::move(context), std::move(options),
                                request);
}

StatusOr<google::longrunning::Operation> WebRiskServiceMetadata::SubmitUri(
    grpc::ClientContext& context, Options options,
    google::cloud::webrisk::v1::SubmitUriRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->SubmitUri(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
WebRiskServiceMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> WebRiskServiceMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void WebRiskServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                         Options const& options,
                                         std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void WebRiskServiceMetadata::SetMetadata(grpc::ClientContext& context,
                                         Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace webrisk_v1_internal
}  // namespace cloud
}  // namespace google
