// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto

#include "google/cloud/privilegedaccessmanager/v1/internal/privileged_access_manager_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace privilegedaccessmanager_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PrivilegedAccessManagerStub::~PrivilegedAccessManagerStub() = default;

StatusOr<
    google::cloud::privilegedaccessmanager::v1::CheckOnboardingStatusResponse>
DefaultPrivilegedAccessManagerStub::CheckOnboardingStatus(
    grpc::ClientContext& context, Options const&,
    google::cloud::privilegedaccessmanager::v1::
        CheckOnboardingStatusRequest const& request) {
  google::cloud::privilegedaccessmanager::v1::CheckOnboardingStatusResponse
      response;
  auto status = grpc_stub_->CheckOnboardingStatus(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::privilegedaccessmanager::v1::ListEntitlementsResponse>
DefaultPrivilegedAccessManagerStub::ListEntitlements(
    grpc::ClientContext& context, Options const&,
    google::cloud::privilegedaccessmanager::v1::ListEntitlementsRequest const&
        request) {
  google::cloud::privilegedaccessmanager::v1::ListEntitlementsResponse response;
  auto status = grpc_stub_->ListEntitlements(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::privilegedaccessmanager::v1::SearchEntitlementsResponse>
DefaultPrivilegedAccessManagerStub::SearchEntitlements(
    grpc::ClientContext& context, Options const&,
    google::cloud::privilegedaccessmanager::v1::SearchEntitlementsRequest const&
        request) {
  google::cloud::privilegedaccessmanager::v1::SearchEntitlementsResponse
      response;
  auto status = grpc_stub_->SearchEntitlements(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Entitlement>
DefaultPrivilegedAccessManagerStub::GetEntitlement(
    grpc::ClientContext& context, Options const&,
    google::cloud::privilegedaccessmanager::v1::GetEntitlementRequest const&
        request) {
  google::cloud::privilegedaccessmanager::v1::Entitlement response;
  auto status = grpc_stub_->GetEntitlement(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultPrivilegedAccessManagerStub::AsyncCreateEntitlement(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::privilegedaccessmanager::v1::
                 CreateEntitlementRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateEntitlement(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultPrivilegedAccessManagerStub::CreateEntitlement(
    grpc::ClientContext& context, Options,
    google::cloud::privilegedaccessmanager::v1::CreateEntitlementRequest const&
        request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateEntitlement(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultPrivilegedAccessManagerStub::AsyncDeleteEntitlement(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::privilegedaccessmanager::v1::
                 DeleteEntitlementRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteEntitlement(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultPrivilegedAccessManagerStub::DeleteEntitlement(
    grpc::ClientContext& context, Options,
    google::cloud::privilegedaccessmanager::v1::DeleteEntitlementRequest const&
        request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteEntitlement(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultPrivilegedAccessManagerStub::AsyncUpdateEntitlement(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::privilegedaccessmanager::v1::
                 UpdateEntitlementRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateEntitlement(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultPrivilegedAccessManagerStub::UpdateEntitlement(
    grpc::ClientContext& context, Options,
    google::cloud::privilegedaccessmanager::v1::UpdateEntitlementRequest const&
        request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->UpdateEntitlement(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::privilegedaccessmanager::v1::ListGrantsResponse>
DefaultPrivilegedAccessManagerStub::ListGrants(
    grpc::ClientContext& context, Options const&,
    google::cloud::privilegedaccessmanager::v1::ListGrantsRequest const&
        request) {
  google::cloud::privilegedaccessmanager::v1::ListGrantsResponse response;
  auto status = grpc_stub_->ListGrants(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::privilegedaccessmanager::v1::SearchGrantsResponse>
DefaultPrivilegedAccessManagerStub::SearchGrants(
    grpc::ClientContext& context, Options const&,
    google::cloud::privilegedaccessmanager::v1::SearchGrantsRequest const&
        request) {
  google::cloud::privilegedaccessmanager::v1::SearchGrantsResponse response;
  auto status = grpc_stub_->SearchGrants(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
DefaultPrivilegedAccessManagerStub::GetGrant(
    grpc::ClientContext& context, Options const&,
    google::cloud::privilegedaccessmanager::v1::GetGrantRequest const&
        request) {
  google::cloud::privilegedaccessmanager::v1::Grant response;
  auto status = grpc_stub_->GetGrant(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
DefaultPrivilegedAccessManagerStub::CreateGrant(
    grpc::ClientContext& context, Options const&,
    google::cloud::privilegedaccessmanager::v1::CreateGrantRequest const&
        request) {
  google::cloud::privilegedaccessmanager::v1::Grant response;
  auto status = grpc_stub_->CreateGrant(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
DefaultPrivilegedAccessManagerStub::ApproveGrant(
    grpc::ClientContext& context, Options const&,
    google::cloud::privilegedaccessmanager::v1::ApproveGrantRequest const&
        request) {
  google::cloud::privilegedaccessmanager::v1::Grant response;
  auto status = grpc_stub_->ApproveGrant(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::privilegedaccessmanager::v1::Grant>
DefaultPrivilegedAccessManagerStub::DenyGrant(
    grpc::ClientContext& context, Options const&,
    google::cloud::privilegedaccessmanager::v1::DenyGrantRequest const&
        request) {
  google::cloud::privilegedaccessmanager::v1::Grant response;
  auto status = grpc_stub_->DenyGrant(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultPrivilegedAccessManagerStub::AsyncRevokeGrant(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
              request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncRevokeGrant(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultPrivilegedAccessManagerStub::RevokeGrant(
    grpc::ClientContext& context, Options,
    google::cloud::privilegedaccessmanager::v1::RevokeGrantRequest const&
        request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->RevokeGrant(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultPrivilegedAccessManagerStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::GetOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::GetOperationRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultPrivilegedAccessManagerStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::CancelOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::CancelOperationRequest,
                                    google::protobuf::Empty>(
             cq,
             [this](grpc::ClientContext* context,
                    google::longrunning::CancelOperationRequest const& request,
                    grpc::CompletionQueue* cq) {
               return operations_->AsyncCancelOperation(context, request, cq);
             },
             request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privilegedaccessmanager_v1_internal
}  // namespace cloud
}  // namespace google
