// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/entity_type.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_ENTITY_TYPES_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_ENTITY_TYPES_CLIENT_H

#include "google/cloud/dialogflow_es/entity_types_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for managing [EntityTypes][google.cloud.dialogflow.v2.EntityType].
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
/// [google.cloud.dialogflow.v2.EntityType]:
/// @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
///
class EntityTypesClient {
 public:
  explicit EntityTypesClient(std::shared_ptr<EntityTypesConnection> connection,
                             Options opts = {});
  ~EntityTypesClient();

  ///@{
  /// @name Copy and move support
  EntityTypesClient(EntityTypesClient const&) = default;
  EntityTypesClient& operator=(EntityTypesClient const&) = default;
  EntityTypesClient(EntityTypesClient&&) = default;
  EntityTypesClient& operator=(EntityTypesClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(EntityTypesClient const& a,
                         EntityTypesClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(EntityTypesClient const& a,
                         EntityTypesClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Returns the list of all entity types in the specified agent.
  ///
  /// @param parent  Required. The agent to list all entity types from.
  ///  Format: `projects/<Project ID>/agent`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.v2.EntityType], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.EntityType]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
  /// [google.cloud.dialogflow.v2.ListEntityTypesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L386}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::v2::EntityType> ListEntityTypes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Returns the list of all entity types in the specified agent.
  ///
  /// @param parent  Required. The agent to list all entity types from.
  ///  Format: `projects/<Project ID>/agent`.
  /// @param language_code  Optional. The language used to access language-specific data.
  ///  If not specified, the agent's default language is used.
  ///  For more information, see
  ///  [Multilingual intent and entity
  ///  data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.v2.EntityType], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.EntityType]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
  /// [google.cloud.dialogflow.v2.ListEntityTypesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L386}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::v2::EntityType> ListEntityTypes(
      std::string const& parent, std::string const& language_code,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the list of all entity types in the specified agent.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.ListEntityTypesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dialogflow.v2.EntityType], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.EntityType]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
  /// [google.cloud.dialogflow.v2.ListEntityTypesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L386}
  ///
  // clang-format on
  StreamRange<google::cloud::dialogflow::v2::EntityType> ListEntityTypes(
      google::cloud::dialogflow::v2::ListEntityTypesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves the specified entity type.
  ///
  /// @param name  Required. The name of the entity type.
  ///  Format: `projects/<Project ID>/agent/entityTypes/<EntityType ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.v2.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.EntityType]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
  /// [google.cloud.dialogflow.v2.GetEntityTypeRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L425}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::v2::EntityType> GetEntityType(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves the specified entity type.
  ///
  /// @param name  Required. The name of the entity type.
  ///  Format: `projects/<Project ID>/agent/entityTypes/<EntityType ID>`.
  /// @param language_code  Optional. The language used to access language-specific data.
  ///  If not specified, the agent's default language is used.
  ///  For more information, see
  ///  [Multilingual intent and entity
  ///  data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.v2.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.EntityType]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
  /// [google.cloud.dialogflow.v2.GetEntityTypeRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L425}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::v2::EntityType> GetEntityType(
      std::string const& name, std::string const& language_code,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves the specified entity type.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.GetEntityTypeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.v2.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.EntityType]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
  /// [google.cloud.dialogflow.v2.GetEntityTypeRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L425}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::v2::EntityType> GetEntityType(
      google::cloud::dialogflow::v2::GetEntityTypeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an entity type in the specified agent.
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param parent  Required. The agent to create a entity type for.
  ///  Format: `projects/<Project ID>/agent`.
  /// @param entity_type  Required. The entity type to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.v2.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.CreateEntityTypeRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L445}
  /// [google.cloud.dialogflow.v2.EntityType]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::v2::EntityType> CreateEntityType(
      std::string const& parent,
      google::cloud::dialogflow::v2::EntityType const& entity_type,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an entity type in the specified agent.
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param parent  Required. The agent to create a entity type for.
  ///  Format: `projects/<Project ID>/agent`.
  /// @param entity_type  Required. The entity type to create.
  /// @param language_code  Optional. The language used to access language-specific data.
  ///  If not specified, the agent's default language is used.
  ///  For more information, see
  ///  [Multilingual intent and entity
  ///  data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.v2.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.CreateEntityTypeRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L445}
  /// [google.cloud.dialogflow.v2.EntityType]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::v2::EntityType> CreateEntityType(
      std::string const& parent,
      google::cloud::dialogflow::v2::EntityType const& entity_type,
      std::string const& language_code, Options opts = {});

  // clang-format off
  ///
  /// Creates an entity type in the specified agent.
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.CreateEntityTypeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.v2.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.CreateEntityTypeRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L445}
  /// [google.cloud.dialogflow.v2.EntityType]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::v2::EntityType> CreateEntityType(
      google::cloud::dialogflow::v2::CreateEntityTypeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the specified entity type.
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param entity_type  Required. The entity type to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.v2.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.EntityType]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
  /// [google.cloud.dialogflow.v2.UpdateEntityTypeRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L468}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::v2::EntityType> UpdateEntityType(
      google::cloud::dialogflow::v2::EntityType const& entity_type,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the specified entity type.
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param entity_type  Required. The entity type to update.
  /// @param language_code  Optional. The language used to access language-specific data.
  ///  If not specified, the agent's default language is used.
  ///  For more information, see
  ///  [Multilingual intent and entity
  ///  data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.v2.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.EntityType]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
  /// [google.cloud.dialogflow.v2.UpdateEntityTypeRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L468}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::v2::EntityType> UpdateEntityType(
      google::cloud::dialogflow::v2::EntityType const& entity_type,
      std::string const& language_code, Options opts = {});

  // clang-format off
  ///
  /// Updates the specified entity type.
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.UpdateEntityTypeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dialogflow.v2.EntityType])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.EntityType]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L293}
  /// [google.cloud.dialogflow.v2.UpdateEntityTypeRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L468}
  ///
  // clang-format on
  StatusOr<google::cloud::dialogflow::v2::EntityType> UpdateEntityType(
      google::cloud::dialogflow::v2::UpdateEntityTypeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified entity type.
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param name  Required. The name of the entity type to delete.
  ///  Format: `projects/<Project ID>/agent/entityTypes/<EntityType ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.DeleteEntityTypeRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L486}
  ///
  // clang-format on
  Status DeleteEntityType(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified entity type.
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.DeleteEntityTypeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.DeleteEntityTypeRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L486}
  ///
  // clang-format on
  Status DeleteEntityType(
      google::cloud::dialogflow::v2::DeleteEntityTypeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates/Creates multiple entity types in the specified agent.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`:
  /// [BatchUpdateEntityTypesResponse][google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse]
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.BatchUpdateEntityTypesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.BatchUpdateEntityTypesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L499}
  /// [google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L540}
  ///
  // clang-format on
  future<
      StatusOr<google::cloud::dialogflow::v2::BatchUpdateEntityTypesResponse>>
  BatchUpdateEntityTypes(
      google::cloud::dialogflow::v2::BatchUpdateEntityTypesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchUpdateEntityTypes
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchUpdateEntityTypes(
      NoAwaitTag,
      google::cloud::dialogflow::v2::BatchUpdateEntityTypesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchUpdateEntityTypes
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<
      StatusOr<google::cloud::dialogflow::v2::BatchUpdateEntityTypesResponse>>
  BatchUpdateEntityTypes(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Deletes entity types in the specified agent.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param parent  Required. The name of the agent to delete all entities types for. Format:
  ///  `projects/<Project ID>/agent`.
  /// @param entity_type_names  Required. The names entity types to delete. All names must point to the
  ///  same agent as `parent`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.protobuf.Struct] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L547}
  /// [google.protobuf.Struct]: @googleapis_reference_link{google/protobuf/struct.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchDeleteEntityTypes(
      std::string const& parent,
      std::vector<std::string> const& entity_type_names, Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchDeleteEntityTypes
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchDeleteEntityTypes(
      NoAwaitTag, std::string const& parent,
      std::vector<std::string> const& entity_type_names, Options opts = {});

  // clang-format off
  ///
  /// Deletes entity types in the specified agent.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.protobuf.Struct] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.BatchDeleteEntityTypesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L547}
  /// [google.protobuf.Struct]: @googleapis_reference_link{google/protobuf/struct.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchDeleteEntityTypes(
      google::cloud::dialogflow::v2::BatchDeleteEntityTypesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchDeleteEntityTypes
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchDeleteEntityTypes(
      NoAwaitTag,
      google::cloud::dialogflow::v2::BatchDeleteEntityTypesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchDeleteEntityTypes
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchDeleteEntityTypes(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Creates multiple new entities in the specified entity type.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param parent  Required. The name of the entity type to create entities in. Format:
  ///  `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
  /// @param entities  Required. The entities to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.protobuf.Struct] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.BatchCreateEntitiesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L565}
  /// [google.protobuf.Struct]: @googleapis_reference_link{google/protobuf/struct.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchCreateEntities(
      std::string const& parent,
      std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
          entities,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchCreateEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchCreateEntities(
      NoAwaitTag, std::string const& parent,
      std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
          entities,
      Options opts = {});

  // clang-format off
  ///
  /// Creates multiple new entities in the specified entity type.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param parent  Required. The name of the entity type to create entities in. Format:
  ///  `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
  /// @param entities  Required. The entities to create.
  /// @param language_code  Optional. The language used to access language-specific data.
  ///  If not specified, the agent's default language is used.
  ///  For more information, see
  ///  [Multilingual intent and entity
  ///  data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.protobuf.Struct] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.BatchCreateEntitiesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L565}
  /// [google.protobuf.Struct]: @googleapis_reference_link{google/protobuf/struct.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchCreateEntities(
      std::string const& parent,
      std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
          entities,
      std::string const& language_code, Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchCreateEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchCreateEntities(
      NoAwaitTag, std::string const& parent,
      std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
          entities,
      std::string const& language_code, Options opts = {});

  // clang-format off
  ///
  /// Creates multiple new entities in the specified entity type.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.BatchCreateEntitiesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.protobuf.Struct] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.BatchCreateEntitiesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L565}
  /// [google.protobuf.Struct]: @googleapis_reference_link{google/protobuf/struct.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchCreateEntities(
      google::cloud::dialogflow::v2::BatchCreateEntitiesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchCreateEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchCreateEntities(
      NoAwaitTag,
      google::cloud::dialogflow::v2::BatchCreateEntitiesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchCreateEntities
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchCreateEntities(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates or creates multiple entities in the specified entity type. This
  /// method does not affect entities in the entity type that aren't explicitly
  /// specified in the request.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  ///
  /// @param parent  Required. The name of the entity type to update or create entities in.
  ///  Format: `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
  /// @param entities  Required. The entities to update or create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.protobuf.Struct] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L589}
  /// [google.protobuf.Struct]: @googleapis_reference_link{google/protobuf/struct.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchUpdateEntities(
      std::string const& parent,
      std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
          entities,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchUpdateEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchUpdateEntities(
      NoAwaitTag, std::string const& parent,
      std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
          entities,
      Options opts = {});

  // clang-format off
  ///
  /// Updates or creates multiple entities in the specified entity type. This
  /// method does not affect entities in the entity type that aren't explicitly
  /// specified in the request.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  ///
  /// @param parent  Required. The name of the entity type to update or create entities in.
  ///  Format: `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
  /// @param entities  Required. The entities to update or create.
  /// @param language_code  Optional. The language used to access language-specific data.
  ///  If not specified, the agent's default language is used.
  ///  For more information, see
  ///  [Multilingual intent and entity
  ///  data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.protobuf.Struct] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L589}
  /// [google.protobuf.Struct]: @googleapis_reference_link{google/protobuf/struct.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchUpdateEntities(
      std::string const& parent,
      std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
          entities,
      std::string const& language_code, Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchUpdateEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchUpdateEntities(
      NoAwaitTag, std::string const& parent,
      std::vector<google::cloud::dialogflow::v2::EntityType::Entity> const&
          entities,
      std::string const& language_code, Options opts = {});

  // clang-format off
  ///
  /// Updates or creates multiple entities in the specified entity type. This
  /// method does not affect entities in the entity type that aren't explicitly
  /// specified in the request.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.protobuf.Struct] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.BatchUpdateEntitiesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L589}
  /// [google.protobuf.Struct]: @googleapis_reference_link{google/protobuf/struct.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchUpdateEntities(
      google::cloud::dialogflow::v2::BatchUpdateEntitiesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchUpdateEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchUpdateEntities(
      NoAwaitTag,
      google::cloud::dialogflow::v2::BatchUpdateEntitiesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchUpdateEntities
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchUpdateEntities(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes entities in the specified entity type.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param parent  Required. The name of the entity type to delete entries for. Format:
  ///  `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
  /// @param entity_values  Required. The reference `values` of the entities to delete. Note that
  ///  these are not fully-qualified names, i.e. they don't start with
  ///  `projects/<Project ID>`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.protobuf.Struct] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L617}
  /// [google.protobuf.Struct]: @googleapis_reference_link{google/protobuf/struct.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchDeleteEntities(
      std::string const& parent, std::vector<std::string> const& entity_values,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchDeleteEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchDeleteEntities(
      NoAwaitTag, std::string const& parent,
      std::vector<std::string> const& entity_values, Options opts = {});

  // clang-format off
  ///
  /// Deletes entities in the specified entity type.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param parent  Required. The name of the entity type to delete entries for. Format:
  ///  `projects/<Project ID>/agent/entityTypes/<Entity Type ID>`.
  /// @param entity_values  Required. The reference `values` of the entities to delete. Note that
  ///  these are not fully-qualified names, i.e. they don't start with
  ///  `projects/<Project ID>`.
  /// @param language_code  Optional. The language used to access language-specific data.
  ///  If not specified, the agent's default language is used.
  ///  For more information, see
  ///  [Multilingual intent and entity
  ///  data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.protobuf.Struct] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L617}
  /// [google.protobuf.Struct]: @googleapis_reference_link{google/protobuf/struct.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchDeleteEntities(
      std::string const& parent, std::vector<std::string> const& entity_values,
      std::string const& language_code, Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchDeleteEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchDeleteEntities(
      NoAwaitTag, std::string const& parent,
      std::vector<std::string> const& entity_values,
      std::string const& language_code, Options opts = {});

  // clang-format off
  ///
  /// Deletes entities in the specified entity type.
  ///
  /// This method is a [long-running
  /// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
  /// The returned `Operation` type has the following method-specific fields:
  ///
  /// - `metadata`: An empty [Struct
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
  /// - `response`: An [Empty
  ///   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
  ///
  /// Note: You should always train an agent prior to sending it queries. See the
  /// [training
  /// documentation](https://cloud.google.com/dialogflow/es/docs/training).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.protobuf.Struct] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dialogflow.v2.BatchDeleteEntitiesRequest]: @googleapis_reference_link{google/cloud/dialogflow/v2/entity_type.proto#L617}
  /// [google.protobuf.Struct]: @googleapis_reference_link{google/protobuf/struct.proto#L51}
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchDeleteEntities(
      google::cloud::dialogflow::v2::BatchDeleteEntitiesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchDeleteEntities
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> BatchDeleteEntities(
      NoAwaitTag,
      google::cloud::dialogflow::v2::BatchDeleteEntitiesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief BatchDeleteEntities
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::protobuf::Struct>> BatchDeleteEntities(
      google::longrunning::Operation const& operation, Options opts = {});

 private:
  std::shared_ptr<EntityTypesConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DIALOGFLOW_ES_ENTITY_TYPES_CLIENT_H
