// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/config/v1/config.proto

#include "google/cloud/config/v1/internal/config_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace config_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ConfigTracingStub::ConfigTracingStub(std::shared_ptr<ConfigStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::config::v1::ListDeploymentsResponse>
ConfigTracingStub::ListDeployments(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::ListDeploymentsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "ListDeployments");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListDeployments(context, options, request));
}

StatusOr<google::cloud::config::v1::Deployment>
ConfigTracingStub::GetDeployment(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::GetDeploymentRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "GetDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetDeployment(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncCreateDeployment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::config::v1::CreateDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "CreateDeployment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateDeployment(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> ConfigTracingStub::CreateDeployment(
    grpc::ClientContext& context, Options options,
    google::cloud::config::v1::CreateDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "CreateDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateDeployment(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncUpdateDeployment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::config::v1::UpdateDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "UpdateDeployment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateDeployment(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> ConfigTracingStub::UpdateDeployment(
    grpc::ClientContext& context, Options options,
    google::cloud::config::v1::UpdateDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "UpdateDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateDeployment(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncDeleteDeployment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::config::v1::DeleteDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "DeleteDeployment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteDeployment(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> ConfigTracingStub::DeleteDeployment(
    grpc::ClientContext& context, Options options,
    google::cloud::config::v1::DeleteDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "DeleteDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteDeployment(context, options, request));
}

StatusOr<google::cloud::config::v1::ListRevisionsResponse>
ConfigTracingStub::ListRevisions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::ListRevisionsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "ListRevisions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListRevisions(context, options, request));
}

StatusOr<google::cloud::config::v1::Revision> ConfigTracingStub::GetRevision(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::GetRevisionRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "GetRevision");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetRevision(context, options, request));
}

StatusOr<google::cloud::config::v1::Resource> ConfigTracingStub::GetResource(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::GetResourceRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "GetResource");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetResource(context, options, request));
}

StatusOr<google::cloud::config::v1::ListResourcesResponse>
ConfigTracingStub::ListResources(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::ListResourcesRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "ListResources");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListResources(context, options, request));
}

StatusOr<google::cloud::config::v1::Statefile>
ConfigTracingStub::ExportDeploymentStatefile(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::ExportDeploymentStatefileRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "ExportDeploymentStatefile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ExportDeploymentStatefile(context, options, request));
}

StatusOr<google::cloud::config::v1::Statefile>
ConfigTracingStub::ExportRevisionStatefile(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::ExportRevisionStatefileRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "ExportRevisionStatefile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ExportRevisionStatefile(context, options, request));
}

StatusOr<google::cloud::config::v1::Statefile>
ConfigTracingStub::ImportStatefile(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::ImportStatefileRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "ImportStatefile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ImportStatefile(context, options, request));
}

Status ConfigTracingStub::DeleteStatefile(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::DeleteStatefileRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "DeleteStatefile");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteStatefile(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncLockDeployment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::config::v1::LockDeploymentRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "LockDeployment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncLockDeployment(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> ConfigTracingStub::LockDeployment(
    grpc::ClientContext& context, Options options,
    google::cloud::config::v1::LockDeploymentRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "LockDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->LockDeployment(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncUnlockDeployment(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::config::v1::UnlockDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "UnlockDeployment");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUnlockDeployment(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> ConfigTracingStub::UnlockDeployment(
    grpc::ClientContext& context, Options options,
    google::cloud::config::v1::UnlockDeploymentRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "UnlockDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UnlockDeployment(context, options, request));
}

StatusOr<google::cloud::config::v1::LockInfo> ConfigTracingStub::ExportLockInfo(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::ExportLockInfoRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "ExportLockInfo");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ExportLockInfo(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncCreatePreview(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::config::v1::CreatePreviewRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "CreatePreview");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreatePreview(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> ConfigTracingStub::CreatePreview(
    grpc::ClientContext& context, Options options,
    google::cloud::config::v1::CreatePreviewRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "CreatePreview");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreatePreview(context, options, request));
}

StatusOr<google::cloud::config::v1::Preview> ConfigTracingStub::GetPreview(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::GetPreviewRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "GetPreview");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetPreview(context, options, request));
}

StatusOr<google::cloud::config::v1::ListPreviewsResponse>
ConfigTracingStub::ListPreviews(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::ListPreviewsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "ListPreviews");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListPreviews(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncDeletePreview(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::config::v1::DeletePreviewRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "DeletePreview");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeletePreview(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> ConfigTracingStub::DeletePreview(
    grpc::ClientContext& context, Options options,
    google::cloud::config::v1::DeletePreviewRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.config.v1.Config", "DeletePreview");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeletePreview(context, options, request));
}

StatusOr<google::cloud::config::v1::ExportPreviewResultResponse>
ConfigTracingStub::ExportPreviewResult(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::ExportPreviewResultRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "ExportPreviewResult");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ExportPreviewResult(context, options, request));
}

StatusOr<google::cloud::config::v1::ListTerraformVersionsResponse>
ConfigTracingStub::ListTerraformVersions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::ListTerraformVersionsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "ListTerraformVersions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListTerraformVersions(context, options, request));
}

StatusOr<google::cloud::config::v1::TerraformVersion>
ConfigTracingStub::GetTerraformVersion(
    grpc::ClientContext& context, Options const& options,
    google::cloud::config::v1::GetTerraformVersionRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.config.v1.Config",
                                     "GetTerraformVersion");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetTerraformVersion(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
ConfigTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> ConfigTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ConfigStub> MakeConfigTracingStub(
    std::shared_ptr<ConfigStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ConfigTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace config_v1_internal
}  // namespace cloud
}  // namespace google
