// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/instance_group_manager_resize_requests/v1/instance_group_manager_resize_requests.proto

#include "google/cloud/compute/instance_group_manager_resize_requests/v1/instance_group_manager_resize_requests_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_instance_group_manager_resize_requests_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

InstanceGroupManagerResizeRequestsClient::
    InstanceGroupManagerResizeRequestsClient(
        std::shared_ptr<InstanceGroupManagerResizeRequestsConnection>
            connection,
        Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
InstanceGroupManagerResizeRequestsClient::
    ~InstanceGroupManagerResizeRequestsClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsClient::Cancel(
    std::string const& project, std::string const& zone,
    std::string const& instance_group_manager,
    std::string const& resize_request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
      CancelRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance_group_manager(instance_group_manager);
  request.set_resize_request(resize_request);
  return connection_->Cancel(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagerResizeRequestsClient::Cancel(
    NoAwaitTag, std::string const& project, std::string const& zone,
    std::string const& instance_group_manager,
    std::string const& resize_request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
      CancelRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance_group_manager(instance_group_manager);
  request.set_resize_request(resize_request);
  return connection_->Cancel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsClient::Cancel(
    google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
        CancelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Cancel(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagerResizeRequestsClient::Cancel(
    NoAwaitTag,
    google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
        CancelRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Cancel(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsClient::Cancel(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Cancel(operation);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsClient::
    DeleteInstanceGroupManagerResizeRequest(
        std::string const& project, std::string const& zone,
        std::string const& instance_group_manager,
        std::string const& resize_request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
      DeleteInstanceGroupManagerResizeRequestRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance_group_manager(instance_group_manager);
  request.set_resize_request(resize_request);
  return connection_->DeleteInstanceGroupManagerResizeRequest(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagerResizeRequestsClient::
    DeleteInstanceGroupManagerResizeRequest(
        NoAwaitTag, std::string const& project, std::string const& zone,
        std::string const& instance_group_manager,
        std::string const& resize_request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
      DeleteInstanceGroupManagerResizeRequestRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance_group_manager(instance_group_manager);
  request.set_resize_request(resize_request);
  return connection_->DeleteInstanceGroupManagerResizeRequest(NoAwaitTag{},
                                                              request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsClient::
    DeleteInstanceGroupManagerResizeRequest(
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::DeleteInstanceGroupManagerResizeRequestRequest const& request,
        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstanceGroupManagerResizeRequest(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagerResizeRequestsClient::
    DeleteInstanceGroupManagerResizeRequest(
        NoAwaitTag,
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::DeleteInstanceGroupManagerResizeRequestRequest const& request,
        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstanceGroupManagerResizeRequest(NoAwaitTag{},
                                                              request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsClient::
    DeleteInstanceGroupManagerResizeRequest(
        google::cloud::cpp::compute::v1::Operation const& operation,
        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteInstanceGroupManagerResizeRequest(operation);
}

StatusOr<google::cloud::cpp::compute::v1::InstanceGroupManagerResizeRequest>
InstanceGroupManagerResizeRequestsClient::GetInstanceGroupManagerResizeRequest(
    std::string const& project, std::string const& zone,
    std::string const& instance_group_manager,
    std::string const& resize_request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
      GetInstanceGroupManagerResizeRequestRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance_group_manager(instance_group_manager);
  request.set_resize_request(resize_request);
  return connection_->GetInstanceGroupManagerResizeRequest(request);
}

StatusOr<google::cloud::cpp::compute::v1::InstanceGroupManagerResizeRequest>
InstanceGroupManagerResizeRequestsClient::GetInstanceGroupManagerResizeRequest(
    google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
        GetInstanceGroupManagerResizeRequestRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetInstanceGroupManagerResizeRequest(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsClient::
    InsertInstanceGroupManagerResizeRequest(
        std::string const& project, std::string const& zone,
        std::string const& instance_group_manager,
        google::cloud::cpp::compute::v1::
            InstanceGroupManagerResizeRequest const&
                instance_group_manager_resize_request_resource,
        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
      InsertInstanceGroupManagerResizeRequestRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance_group_manager(instance_group_manager);
  *request.mutable_instance_group_manager_resize_request_resource() =
      instance_group_manager_resize_request_resource;
  return connection_->InsertInstanceGroupManagerResizeRequest(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagerResizeRequestsClient::
    InsertInstanceGroupManagerResizeRequest(
        NoAwaitTag, std::string const& project, std::string const& zone,
        std::string const& instance_group_manager,
        google::cloud::cpp::compute::v1::
            InstanceGroupManagerResizeRequest const&
                instance_group_manager_resize_request_resource,
        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
      InsertInstanceGroupManagerResizeRequestRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance_group_manager(instance_group_manager);
  *request.mutable_instance_group_manager_resize_request_resource() =
      instance_group_manager_resize_request_resource;
  return connection_->InsertInstanceGroupManagerResizeRequest(NoAwaitTag{},
                                                              request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsClient::
    InsertInstanceGroupManagerResizeRequest(
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::InsertInstanceGroupManagerResizeRequestRequest const& request,
        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertInstanceGroupManagerResizeRequest(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagerResizeRequestsClient::
    InsertInstanceGroupManagerResizeRequest(
        NoAwaitTag,
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::InsertInstanceGroupManagerResizeRequestRequest const& request,
        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertInstanceGroupManagerResizeRequest(NoAwaitTag{},
                                                              request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsClient::
    InsertInstanceGroupManagerResizeRequest(
        google::cloud::cpp::compute::v1::Operation const& operation,
        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertInstanceGroupManagerResizeRequest(operation);
}

StreamRange<google::cloud::cpp::compute::v1::InstanceGroupManagerResizeRequest>
InstanceGroupManagerResizeRequestsClient::
    ListInstanceGroupManagerResizeRequests(
        std::string const& project, std::string const& zone,
        std::string const& instance_group_manager, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
      ListInstanceGroupManagerResizeRequestsRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_instance_group_manager(instance_group_manager);
  return connection_->ListInstanceGroupManagerResizeRequests(request);
}

StreamRange<google::cloud::cpp::compute::v1::InstanceGroupManagerResizeRequest>
InstanceGroupManagerResizeRequestsClient::
    ListInstanceGroupManagerResizeRequests(
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::ListInstanceGroupManagerResizeRequestsRequest request,
        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListInstanceGroupManagerResizeRequests(
      std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instance_group_manager_resize_requests_v1
}  // namespace cloud
}  // namespace google
