#! /usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Copyright 2022, Nils Hilbricht, Germany ( https://www.hilbricht.net )

This file is part of the Laborejo Software Suite ( https://www.laborejo.org ),

This application is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import logging; logger = logging.getLogger(__name__); logger.info("import")

#System Wide Modules
from PyQt5 import QtCore, QtWidgets, QtGui

#Local Modules
from engine.config import * #imports METADATA
from .designer.usermanual import Ui_TemplateUserManual
from template.start import PATHS


class UserManual(QtWidgets.QWidget):
    """A modal window that is hidden"""

    def __init__(self, mainWindow):
        super().__init__()
        self.mainWindow = mainWindow
        self.ui =  Ui_TemplateUserManual()
        self.ui.setupUi(self)

        self.text = self.ui.textBrowser

        self.text.setSearchPaths([PATHS["doc"]]) #it's a list!
        self.text.setSource(QtCore.QUrl("index.html"))

        self.text.highlighted.connect(self.blockLink)

        self.ui.back.clicked.connect(self.text.backward)
        self.ui.home.clicked.connect(self.text.home)

        self.setWindowTitle(METADATA["name"] + " " +  QtCore.QCoreApplication.translate("TemplateUserManual", "User Manual"))

        self.hide()

    def blockLink(self, qurl):
        """The browser displays binary "text" when following a link to an image.
        prevent that"""
        if qurl.url().endswith(".png") or qurl.url().startswith("http") or qurl.url().startswith("mailto"):
            #About to click an url.
            self.text.setOpenLinks(False)
            return False
        else:
            self.text.setOpenLinks(True)
            return True

    def closeEvent(self, event):
        self.hide()
