#! /usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Copyright 2022, Nils Hilbricht, Germany ( https://www.hilbricht.net )

This file is part of the Laborejo Software Suite ( https://www.laborejo.org ),

This application is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

"""
Outputs to standard output
Uses midi note keys as sample file names.
"""

groupstring = """
<group>
    seq_length=3
    key={}
    <region>seq_position=1 sample={}.wav transpose=0
    <region>seq_position=2 sample={}.wav transpose=-1
    <region>seq_position=3 sample={}.wav transpose=-2
"""

for keynum in range(127+1):
    print (groupstring.format(keynum, keynum, keynum+1, keynum+2))




