#! /usr/bin/env python3
# -*- coding: utf-8 -*-

#Do not change these during runtime!

METADATA={
    #The pretty name of this program. Used for NSM display and Jack client name
    #Can contain everything a linux file/path supports. Never change this or it will break the
    #session, making your file unable to load and destroying saved Jack connections.
    "name" : "Tembro",

    #Set this to the name the user types into a terminal.
    #MUST be the same as the binary name as well as the name in configure.
    #Program reports that as proc title so you can killall it by name.
    #Should not contain spaces or special characters. We use this as save file extension as well
    #to distinguish between compatible program versions. In basic programs this will just be e.g.
    #patroneo. But in complex programs with a bright future it will be "laborejo1" "laborejo2" etc.
    "shortName" : "tembro",

    #A very short description used in various places: Desktop file, overview on the website,
    #release announcements, entries in software directories etc.
    "tagline" : 'All-In-One Instrument',

    "version" : "0.6.0",
    "year" : "2022",
    "author" : "Laborejo Software Suite and Krzysztof Foltman",
    "url" : "https://www.laborejo.org/tembro",

    "supportedLanguages" : {"German":"de.qm"},

    #Show the About Dialog the first time the program starts up. This is the initial state for a
    #new instance in NSM, not the saved state! Decide on how annoying it would be for every new
    #instance to show about. Fluajho does not show it because you add it many times into a session.
    #Patroneo does because its only added once.
    "showAboutDialogFirstStart" : False,

    #If your program handles very small duration with n-tuplets you should increase D4.
    #This will not be visible to the outside jack world
    "quarterNoteInTicks" : 96,

    #How many audio outputs do you want? must be pairs. These are just unconnected jack outputs
    #that need to be connected internally to instrument outputs like fluidsynth
    "cboxOutputs" : 0,

    #Does the program uses a metronome? In this case you need at least two cboxOutputs above
    "metronome" : False,

    #Various strings for the README
    #Extra whitespace will be stripped so we don't need to worry about docstring indentation
    "description" : """
Tembro (which is Esperanto for musical "Timbre") is a virtual software instrument based on
samples. All instruments are permanently built-in, there is no option to load your own files.
New instruments are only added with new releases, old ones are never removed.

That makes Tembro reliable, predictable, portable and compatible.
All projects and all users have the same "instrument" with the same instrument sounds,
numbering system, midi controls… ; a solid basis for communication and collaboration.

""",
}
