/*
  Copyright (C) 2022 Ángel Ruiz Fernández

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation, version 3.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program.  If not, see
  <http://www.gnu.org/licenses/>
*/

#ifndef _PWD_H_
#define _PWD_H_

#include <time.h>

typedef int uid_t;
typedef int gid_t;

struct passwd {
  char *pw_name;    /* user name */
  char *pw_passwd;  /* encrypted password */
  uid_t pw_uid;     /* user uid */
  gid_t pw_gid;     /* user gid */
  time_t pw_change; /* password change time */
  char *pw_class;   /* user access class */
  char *pw_gecos;   /* Honeywell login info */
  char *pw_dir;     /* home directory */
  char *pw_shell;   /* default shell */
  time_t pw_expire; /* account expiration */
};

uid_t getuid();
struct passwd *getpwuid(uid_t uid);

#endif /* _PWD_H_ */