# Makefile.PL for pppusage
#
# Next to the normal ExtUtils::MakeMaker targets, this Makefile.PL
# installs pppusagerc in /etc (on Linux) or /usr/local/etc (on any
# other UNIX) if no such file is found in that directory. To override
# the default behavior, use $SYSCONFDIR. For example, to install
# everything in your home directory, use:
#
#    perl Makefile.PL PREFIX=~ SYSCONFDIR=~/etc
#
# last update: 2003-09-25, Holger Weiss <holger@jhweiss.de>

use strict;
use Config;
use ExtUtils::MakeMaker;

$ExtUtils::MakeMaker::Recognized_Att_Keys{'SYSCONFDIR'}      = 1;
$ExtUtils::MakeMaker::Recognized_Att_Keys{'INST_SYSCONFDIR'} = 1;

if (!$Config{'installman1dir'}) {

	print <<"EOF";

----------------------------------------------------------

NOTE:

The installation directory for section 1 man pages is not
set in your Perl configuration. Therefore the man page
won't be built. Now you have lots of options :-) You can

   - fix your Perl configuration

   - or simply read the pppusage documentation by typing:

        perldoc pppusage

   - or add the follworing line in the WriteMakefile()
     call in Makefile.PL (and rerun perl Makefile.PL):

        'INSTALLMAN1DIR' => '/usr/local/man/man1',

   - or build and install the man page yourself:

        pod2man bin/pppusage.raw > pppusage.1
        cp pppusage.1 /usr/local/man/man1/pppusage.1

----------------------------------------------------------

EOF

}

WriteMakefile (

	'NAME'         => 'pppusage',
	'AUTHOR'       => 'Holger Weiss <holger@jhweiss.de>',
	'ABSTRACT'     => 'Summarizes transfer volume and other data for PPP connections.',
	'VERSION_FROM' => 'lib/PPPUsage/Version.pm',
	'EXE_FILES'    => [ 'bin/pppusage' ],
	'PREREQ_PM'    => { 'Getopt::Std' => '0',
	                    'DB_File'     => '0',
	                    'POSIX'       => '0', },
);

package MY;

sub MY::install {

	my $inherited = shift->SUPER::install(@_);
	$inherited =~ s/^(install :: .*)$/$1 inst_conf/gm;
	$inherited;
}

sub MY::clean {

	my $inherited = shift->SUPER::clean(@_);
	$inherited =~ s/^(clean ::)$/$1 clean_bin/gm;
	$inherited;
}

sub MY::postamble {

	my $self           = shift;
	my $guess          = $^O eq "linux" ? '/etc' : '/usr/local/etc';
	my $sysconfdir     = $self->{SYSCONFDIR}      || $guess;
	my $instsysconfdir = $self->{INST_SYSCONFDIR} || $sysconfdir;

	# Note that for the target bin/pppusage, we're assuming that the
	# contents of $(INST_SCRIPT) will be installed to the directory
	# $(INSTALLSCRIPT), because that's what the docs suggest. See
	# ExtUtils::MakeMaker(3). However, I've seen systems which
	# install the contents of $(INST_SCRIPT) to $(INSTALLSITEBIN).
	# In this case, we're doing the wrong thing, but this affects
	# our docs only. If you have any idea how Makefile.PL could
	# determine whether $(INSTALLSCRIPT) or $(INSTALLSITEBIN) is
	# used, please let me know.

qq#
SYSCONFDIR = $instsysconfdir

# . q#
bin/pppusage: bin/pppusage.raw
	sed \
		-e s:/usr.local.bin:$(INSTALLSCRIPT):g \
		-e s:/usr.local.etc:$(SYSCONFDIR):g \
		bin/pppusage.raw > bin/pppusage

inst_conf: etc/pppusagerc
	test -f $(SYSCONFDIR)/pppusagerc || cp etc/pppusagerc $(SYSCONFDIR)/

clean_bin:
	rm -f bin/pppusage
#;
}
