#! /usr/bin/env python3
# -*- coding: utf-8 -*-

import os
import sys
import logging

logging.basicConfig(level=logging.INFO) #this also sets _cbox2 logging level

#_cbox2.py reads this environment variable and uses the lib directly.
#Without it will look for a vanilla "calfbox" library, but we are *-lss
os.environ["CALFBOXLIBABSPATH"] = os.path.abspath("../build/libcalfbox-lss.so")

#Variant 1
sys.path.append(os.path.abspath("../calfbox/py/"))
import cbox

def cmd_dumper(cmd, fb, args):
    print ("%s(%s)" % (cmd, ",".join(list(map(repr,args)))))

cbox.init_engine("") #empty string for "no config file"
cbox.start_audio(cmd_dumper)
cbox.stop_audio()
cbox.shutdown_engine()

cbox.init_engine("")
cbox.start_audio(cmd_dumper)
cbox.stop_audio()
cbox.shutdown_engine()

cbox.init_engine("")
cbox.start_audio(cmd_dumper)


while True:
    cbox.call_on_idle(cmd_dumper)
