#! /usr/bin/env python3
# -*- coding: utf-8 -*-

import os
import sys
import logging

logging.basicConfig(level=logging.INFO) #this also sets _cbox2 logging level

#_cbox2.py reads this environment variable and uses the lib directly.
#Without it will look for a vanilla "calfbox" library, but we are *-lss
os.environ["CALFBOXLIBABSPATH"] = os.path.abspath("../build/libcalfbox-lss.so")

#The cbox python files can be anywhere in the search path, which includes everything below the current path.
#In a real application the cbox python paths would be available relative to the root module, but
#since we are in the test directory we need to tell python where the files are.

#Variant 1
#sys.path.append(os.path.abspath("../calfbox/py/"))
#import cbox

#Variant 2
#sys.path.append(os.path.abspath("../calfbox/"))
#from py import cbox

#Variant 3
sys.path.append(os.path.abspath("../calfbox/"))
import py.nullbox #hardwires the cbox to a fake nullbox module and provides a "calfbox" parent module
#from calfbox import cbox  #now we can import cbox but it really is the nullbox
from py import cbox  #now we can import cbox but it really is the nullbox

def cmd_dumper(cmd, fb, args):
    print ("%s(%s)" % (cmd, ",".join(list(map(repr,args)))))

cbox.init_engine()
cbox.start_audio(cmd_dumper)

print("Ready!")
while True:
    cbox.call_on_idle(cmd_dumper)
