# libcalfbox-lss

Build system to package https://github.com/kfoltman/calfbox
for the Laborejo Software Suite.

Calfbox is a C library that does the heavy lifting for real time midi sequencing
and loading various sampler formats, like sf2 and sfz. It is the basis
for most LSS programs.

This is just a packaging release. There are no code changes to calfbox itself.
Please do all cbox issues and pull requests upstream.


## Download a release tarball

Most likely you want to run LSS software and need this lib as dependency.
Go to https://laborejo.org/downloads/ and look for the latest release tarball.
There is an archive, a sha256sum and a GPG signature.
Direct links to the current release:

* https://laborejo.org/downloads/libcalfbox-lss-1.1.0.tar.xz
* https://laborejo.org/downloads/libcalfbox-lss-1.1.0.tar.xz.sha256sum
* https://laborejo.org/downloads/libcalfbox-lss-1.1.0.tar.xz.sig

For packagers and news aggregators:

We don't use the gitea release feature, but still tag the releases:

https://git.laborejo.org/lss/libcalfbox-lss/tags

## Compile the library

```
meson build
cd build
meson compile
```

One can also do

* `meson build --buildtype=debug` for a debug build.
* `meson build --prefix=/usr` to change from default /usr/local


## Test without installation

```
cd tests
./01.py
```

## Install

```
cd build
sudo meson install
```

You maybe need to run ldconfig after installing manually.

### Uninstall

```
cd build
sudo ninja uninstall
```

Don't forget to call ldconfig if you do a manual uninstall.
