/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.catalina.Context;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.Extension;
import org.apache.catalina.util.ManifestResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public final class ExtensionValidator {
    private static final Log log = LogFactory.getLog(ExtensionValidator.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.util");
    private static volatile ArrayList<Extension> containerAvailableExtensions = null;
    private static final ArrayList<ManifestResource> containerManifestResources = new ArrayList();

    public static synchronized boolean validateApplication(WebResourceRoot webResourceRoot, Context context) throws IOException {
        WebResource[] webResourceArray;
        String string = context.getName();
        ArrayList<ManifestResource> arrayList = new ArrayList<ManifestResource>();
        WebResource webResource = webResourceRoot.getResource("/META-INF/MANIFEST.MF");
        if (webResource.isFile()) {
            webResourceArray = webResource.getInputStream();
            try {
                Manifest object = new Manifest((InputStream)webResourceArray);
                ManifestResource manifestResource = new ManifestResource(sm.getString("extensionValidator.web-application-manifest"), object, 2);
                arrayList.add(manifestResource);
            }
            finally {
                if (webResourceArray != null) {
                    webResourceArray.close();
                }
            }
        }
        for (WebResource webResource2 : webResourceArray = webResourceRoot.getClassLoaderResources("/META-INF/MANIFEST.MF")) {
            if (!webResource2.isFile()) continue;
            String string2 = webResource2.getURL().toExternalForm();
            Manifest manifest = webResource2.getManifest();
            if (manifest == null) continue;
            ManifestResource manifestResource = new ManifestResource(string2, manifest, 3);
            arrayList.add(manifestResource);
        }
        return ExtensionValidator.validateManifestResources(string, arrayList);
    }

    public static void addSystemResource(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Manifest manifest = ExtensionValidator.getManifest(fileInputStream);
            if (manifest != null) {
                ManifestResource manifestResource = new ManifestResource(file.getAbsolutePath(), manifest, 1);
                containerManifestResources.add(manifestResource);
            }
        }
    }

    private static boolean validateManifestResources(String string, ArrayList<ManifestResource> arrayList) {
        boolean bl = true;
        int n = 0;
        ArrayList<Extension> arrayList2 = null;
        for (ManifestResource manifestResource : arrayList) {
            ArrayList<Extension> arrayList3 = manifestResource.getRequiredExtensions();
            if (arrayList3 == null) continue;
            if (arrayList2 == null) {
                arrayList2 = ExtensionValidator.buildAvailableExtensionsList(arrayList);
            }
            if (containerAvailableExtensions == null) {
                containerAvailableExtensions = ExtensionValidator.buildAvailableExtensionsList(containerManifestResources);
            }
            for (Extension extension : arrayList3) {
                boolean bl2 = false;
                if (arrayList2 != null) {
                    for (Extension extension2 : arrayList2) {
                        if (!extension2.isCompatibleWith(extension)) continue;
                        extension.setFulfilled(true);
                        bl2 = true;
                        break;
                    }
                }
                if (!bl2 && containerAvailableExtensions != null) {
                    for (Extension extension2 : containerAvailableExtensions) {
                        if (!extension2.isCompatibleWith(extension)) continue;
                        extension.setFulfilled(true);
                        bl2 = true;
                        break;
                    }
                }
                if (bl2) continue;
                log.info((Object)sm.getString("extensionValidator.extension-not-found-error", new Object[]{string, manifestResource.getResourceName(), extension.getExtensionName()}));
                bl = false;
                ++n;
            }
        }
        if (!bl) {
            log.info((Object)sm.getString("extensionValidator.extension-validation-error", new Object[]{string, n + ""}));
        }
        return bl;
    }

    private static ArrayList<Extension> buildAvailableExtensionsList(ArrayList<ManifestResource> arrayList) {
        ArrayList<Extension> arrayList2 = null;
        for (ManifestResource manifestResource : arrayList) {
            ArrayList<Extension> arrayList3 = manifestResource.getAvailableExtensions();
            if (arrayList3 == null) continue;
            for (Extension extension : arrayList3) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Extension>();
                    arrayList2.add(extension);
                    continue;
                }
                arrayList2.add(extension);
            }
        }
        return arrayList2;
    }

    private static Manifest getManifest(InputStream inputStream) throws IOException {
        Manifest manifest = null;
        try (JarInputStream jarInputStream = new JarInputStream(inputStream);){
            manifest = jarInputStream.getManifest();
        }
        return manifest;
    }

    private static void addFolderList(String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File[] fileArray;
                File file = new File(stringTokenizer.nextToken());
                if (!file.isDirectory() || (fileArray = file.listFiles()) == null) continue;
                for (File file2 : fileArray) {
                    if (!file2.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || !file2.isFile()) continue;
                    try {
                        ExtensionValidator.addSystemResource(file2);
                    }
                    catch (IOException iOException) {
                        log.error((Object)sm.getString("extensionValidator.failload", new Object[]{file2}), (Throwable)iOException);
                    }
                }
            }
        }
    }

    static {
        String string = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file;
            String string2 = stringTokenizer.nextToken();
            if (!string2.toLowerCase(Locale.ENGLISH).endsWith(".jar") || !(file = new File(string2)).isFile()) continue;
            try {
                ExtensionValidator.addSystemResource(file);
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("extensionValidator.failload", new Object[]{file}), (Throwable)iOException);
            }
        }
        ExtensionValidator.addFolderList("java.ext.dirs");
    }
}

