'''OpenGL extension OES.blend_subtract

This module customises the behaviour of the 
OpenGL.raw.GLES1.OES.blend_subtract to provide a more 
Python-friendly API

Overview (from the spec)
	
	Blending capability is extended by respecifying the entire blend
	equation.  While this document defines only two new equations, the
	BlendEquationOES procedure that it defines will be used by subsequent
	extensions to define additional blending equations.
	
	In addition to the default blending equation, two new blending equations
	are specified.  These equations are similar to the default blending 
	equation, but produce the difference of its left and right hand sides, 
	rather than the sum.  Image differences are useful in many image 
	processing applications.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/blend_subtract.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES1 import _types, _glgets
from OpenGL.raw.GLES1.OES.blend_subtract import *
from OpenGL.raw.GLES1.OES.blend_subtract import _EXTENSION_NAME

def glInitBlendSubtractOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION