/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.utils;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class DebugUtils {
    private static final boolean IS_DEBUG = false;

    public static <T> T debug(T obj, String message) {
        DebugUtils.verifyDebug();
        DebugUtils.print("### %s: %s (at %s)", message, DebugUtils.stringify(obj), DebugUtils.getCalledFrom(1));
        return obj;
    }

    public static <T> T debug(T obj) {
        DebugUtils.verifyDebug();
        DebugUtils.print("### %s (at %s)", DebugUtils.stringify(obj), DebugUtils.getCalledFrom(1));
        return obj;
    }

    private static void verifyDebug() {
        throw new RuntimeException("DebugUtils can be used only for local debugging.");
    }

    private static void print(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    private static String getCalledFrom(int pos) {
        RuntimeException e = new RuntimeException();
        StackTraceElement item = e.getStackTrace()[pos + 1];
        return item.getClassName() + "." + item.getMethodName() + ":" + item.getLineNumber();
    }

    private static String stringify(Collection<?> items) {
        if (items == null) {
            return "null";
        }
        if (items.isEmpty()) {
            return "()";
        }
        String result = items.stream().map(i -> DebugUtils.stringify(i)).collect(Collectors.joining(","));
        return "(" + result + ")";
    }

    private static String stringify(Map<?, ?> map) {
        if (map == null) {
            return "[[null]]";
        }
        if (map.isEmpty()) {
            return "[[EMPTY]]";
        }
        String result = map.entrySet().stream().map(entry -> String.valueOf(entry.getKey()) + ": " + DebugUtils.stringify(entry.getValue())).collect(Collectors.joining(","));
        return "{" + result + "}";
    }

    private static String stringify(Object obj) {
        if (obj instanceof Collection) {
            return DebugUtils.stringify((Collection)obj);
        }
        if (obj instanceof Map) {
            return DebugUtils.stringify((Map)obj);
        }
        return String.valueOf(obj);
    }
}

