/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.physical.node.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.legacy.query.planner.physical.Row;
import org.opensearch.sql.legacy.query.planner.physical.node.join.HashTable;
import shaded.com.google.common.collect.ArrayListMultimap;
import shaded.com.google.common.collect.Multimap;

public class DefaultHashTable<T>
implements HashTable<T> {
    private static final Logger LOG = LogManager.getLogger();
    private final Multimap<Row.RowKey, Row<T>> table = ArrayListMultimap.create();
    private final String[] leftJoinFields;
    private final String[] rightJoinFields;

    public DefaultHashTable(String[] leftJoinFields, String[] rightJoinFields) {
        this.leftJoinFields = leftJoinFields;
        this.rightJoinFields = rightJoinFields;
    }

    @Override
    public void add(Row<T> row) {
        Row.RowKey key = row.key(this.leftJoinFields);
        if (key == Row.RowKey.NULL) {
            LOG.debug("Skip rows with NULL column value during build: row={}, conditions={}", row, (Object)this.leftJoinFields);
        } else {
            this.table.put(key, row);
        }
    }

    @Override
    public Collection<Row<T>> match(Row<T> row) {
        Row.RowKey key = row.key(this.rightJoinFields);
        if (key == Row.RowKey.NULL) {
            LOG.debug("Skip rows with NULL column value during probing: row={}, conditions={}", row, (Object)this.rightJoinFields);
            return Collections.emptyList();
        }
        return this.table.get(key);
    }

    @Override
    public Map<String, Collection<Object>>[] rightFieldWithLeftValues() {
        HashMap<String, Collection> result2 = new HashMap<String, Collection>();
        for (Row.RowKey rowKey : this.table.keySet()) {
            Object[] keys2 = rowKey.keys();
            for (int i = 0; i < keys2.length; ++i) {
                result2.computeIfAbsent(this.rightJoinFields[i], k -> new HashSet()).add(this.lowercaseIfStr(keys2[i]));
            }
        }
        for (Map.Entry entry : result2.entrySet()) {
            entry.setValue(new ArrayList((Collection)entry.getValue()));
        }
        return new Map[]{result2};
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    private Object lowercaseIfStr(Object key) {
        return key instanceof String ? ((String)key).toLowerCase() : key;
    }
}

