/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import lombok.Generated;
import org.opensearch.sql.executor.QueryType;

public class FunctionProperties
implements Serializable {
    private final Instant nowInstant;
    private final ZoneId currentZoneId;
    private final QueryType queryType;
    public static final FunctionProperties None = new FunctionProperties(){

        @Override
        public Clock getSystemClock() {
            throw new UnexpectedCallException();
        }

        @Override
        public Clock getQueryStartClock() {
            throw new UnexpectedCallException();
        }
    };

    public FunctionProperties() {
        this(QueryType.SQL);
    }

    public FunctionProperties(QueryType queryType) {
        this(Instant.now(), ZoneOffset.UTC, queryType);
    }

    public FunctionProperties(Instant nowInstant, ZoneId currentZoneId) {
        this(nowInstant, currentZoneId, QueryType.SQL);
    }

    public FunctionProperties(Instant nowInstant, ZoneId currentZoneId, QueryType queryType) {
        this.nowInstant = nowInstant;
        this.currentZoneId = currentZoneId;
        this.queryType = queryType;
    }

    public Clock getSystemClock() {
        return Clock.system(this.currentZoneId);
    }

    public Clock getQueryStartClock() {
        return Clock.fixed(this.nowInstant, this.currentZoneId);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionProperties)) {
            return false;
        }
        FunctionProperties other = (FunctionProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Instant this$nowInstant = this.nowInstant;
        Instant other$nowInstant = other.nowInstant;
        if (this$nowInstant == null ? other$nowInstant != null : !((Object)this$nowInstant).equals(other$nowInstant)) {
            return false;
        }
        ZoneId this$currentZoneId = this.getCurrentZoneId();
        ZoneId other$currentZoneId = other.getCurrentZoneId();
        if (this$currentZoneId == null ? other$currentZoneId != null : !((Object)this$currentZoneId).equals(other$currentZoneId)) {
            return false;
        }
        QueryType this$queryType = this.getQueryType();
        QueryType other$queryType = other.getQueryType();
        return !(this$queryType == null ? other$queryType != null : !((Object)((Object)this$queryType)).equals((Object)other$queryType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FunctionProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Instant $nowInstant = this.nowInstant;
        result2 = result2 * 59 + ($nowInstant == null ? 43 : ((Object)$nowInstant).hashCode());
        ZoneId $currentZoneId = this.getCurrentZoneId();
        result2 = result2 * 59 + ($currentZoneId == null ? 43 : ((Object)$currentZoneId).hashCode());
        QueryType $queryType = this.getQueryType();
        result2 = result2 * 59 + ($queryType == null ? 43 : ((Object)((Object)$queryType)).hashCode());
        return result2;
    }

    @Generated
    public ZoneId getCurrentZoneId() {
        return this.currentZoneId;
    }

    @Generated
    public QueryType getQueryType() {
        return this.queryType;
    }

    class UnexpectedCallException
    extends RuntimeException {
        public UnexpectedCallException() {
            super("FunctionProperties.None is a null object and not meant to be accessed.");
        }
    }
}

