/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasource.client;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.inject.Inject;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasource.client.DataSourceClient;
import org.opensearch.sql.datasource.client.exceptions.DataSourceClientException;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.prometheus.utils.PrometheusClientUtils;

public class DataSourceClientFactory {
    private static final Logger LOG = LogManager.getLogger();
    private final Settings settings;
    private final DataSourceService dataSourceService;

    @Inject
    public DataSourceClientFactory(DataSourceService dataSourceService, Settings settings) {
        this.settings = settings;
        this.dataSourceService = dataSourceService;
    }

    public <T extends DataSourceClient> T createClient(String dataSourceName) throws DataSourceClientException {
        try {
            if (!this.dataSourceService.dataSourceExists(dataSourceName).booleanValue()) {
                throw new DataSourceClientException("Data source does not exist: " + dataSourceName);
            }
            DataSourceMetadata metadata2 = this.dataSourceService.verifyDataSourceAccessAndGetRawMetadata(dataSourceName, null);
            DataSourceType dataSourceType = metadata2.getConnector();
            return (T)this.createClientForType(dataSourceType.name(), metadata2);
        }
        catch (Exception e) {
            if (e instanceof DataSourceClientException) {
                throw e;
            }
            LOG.error("Failed to create client for data source: " + dataSourceName, (Throwable)e);
            throw new DataSourceClientException("Failed to create client for data source: " + dataSourceName, e);
        }
    }

    public DataSourceType getDataSourceType(String dataSourceName) throws DataSourceClientException {
        if (!this.dataSourceService.dataSourceExists(dataSourceName).booleanValue()) {
            throw new DataSourceClientException("Data source does not exist: " + dataSourceName);
        }
        return this.dataSourceService.getDataSourceMetadata(dataSourceName).getConnector();
    }

    private DataSourceClient createClientForType(String dataSourceType, DataSourceMetadata metadata2) throws DataSourceClientException {
        switch (dataSourceType) {
            case "PROMETHEUS": {
                return PrometheusClientUtils.createPrometheusClient(metadata2, this.settings);
            }
        }
        throw new DataSourceClientException("Unsupported data source type: " + dataSourceType);
    }
}

