/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.Objects;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.AggregatingSelectScope;
import org.apache.calcite.sql.validate.OrderByScope;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Optionality;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlAbstractGroupFunction
extends SqlAggFunction {
    public SqlAbstractGroupFunction(String name, SqlKind kind, SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        super(name, null, kind, returnTypeInference, operandTypeInference, operandTypeChecker, category, false, false, Optionality.FORBIDDEN);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope2, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope2, operandScope);
        SelectScope selectScope = Objects.requireNonNull(SqlValidatorUtil.getEnclosingSelectScope(scope2));
        SqlSelect select = selectScope.getNode();
        if (!validator.isAggregate(select)) {
            throw validator.newValidationError(call, Static.RESOURCE.groupingInAggregate(this.getName()));
        }
        AggregatingSelectScope aggregatingSelectScope = SqlValidatorUtil.getEnclosingAggregateSelectScope(scope2);
        if (aggregatingSelectScope == null) {
            throw validator.newValidationError(call, Static.RESOURCE.groupingInWrongClause(this.getName()));
        }
        for (SqlNode operand : call.getOperandList()) {
            operand = scope2 instanceof OrderByScope ? validator.expandOrderExpr(select, operand) : validator.expand(operand, scope2);
            if (((AggregatingSelectScope.Resolved)aggregatingSelectScope.resolved.get()).isGroupingExpr(operand)) continue;
            throw validator.newValidationError(operand, Static.RESOURCE.groupingArgument(this.getName()));
        }
    }

    @Override
    public boolean isQuantifierAllowed() {
        return false;
    }

    @Override
    public boolean allowsFilter() {
        return false;
    }
}

