/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.kmssdkv2;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.MasterKeyRequest;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.NoSuchMasterKeyException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import com.amazonaws.encryptionsdk.internal.AwsKmsCmkArnInfo;
import com.amazonaws.encryptionsdk.kms.DiscoveryFilter;
import com.amazonaws.encryptionsdk.kms.KmsMethods;
import com.amazonaws.encryptionsdk.kmssdkv2.KmsMasterKey;
import com.amazonaws.encryptionsdk.kmssdkv2.RegionalClientSupplier;
import com.amazonaws.encryptionsdk.kmssdkv2.RequestClientCacher;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;

public class KmsMasterKeyProvider
extends MasterKeyProvider<KmsMasterKey>
implements KmsMethods {
    private static final String PROVIDER_NAME = "aws-kms";
    private final List<String> keyIds_;
    private final List<String> grantTokens_;
    private final boolean isDiscovery_;
    private final DiscoveryFilter discoveryFilter_;
    private final RegionalClientSupplier regionalClientSupplier_;
    private final Region defaultRegion_;

    public static Builder builder() {
        return new Builder();
    }

    KmsMasterKeyProvider(RegionalClientSupplier supplier, Region defaultRegion, List<String> keyIds, List<String> grantTokens, boolean isDiscovery, DiscoveryFilter discoveryFilter) {
        if (!isDiscovery && (keyIds == null || keyIds.isEmpty())) {
            throw new IllegalArgumentException("Strict mode must be configured with a non-empty list of keyIds.");
        }
        if (!isDiscovery && keyIds.contains(null)) {
            throw new IllegalArgumentException("Strict mode cannot be configured with a null key identifier.");
        }
        if (!isDiscovery && discoveryFilter != null) {
            throw new IllegalArgumentException("Strict mode cannot be configured with a discovery filter.");
        }
        if (!isDiscovery && defaultRegion == null) {
            for (String keyId : keyIds) {
                AwsKmsCmkArnInfo arnInfo = AwsKmsCmkArnInfo.parseInfoFromKeyArn(keyId);
                if (arnInfo != null) continue;
                throw new AwsCryptoException("Can't use non-ARN key identifiers or aliases when no default region is set");
            }
        }
        this.regionalClientSupplier_ = supplier;
        this.defaultRegion_ = defaultRegion;
        this.keyIds_ = Collections.unmodifiableList(new ArrayList<String>(keyIds));
        this.isDiscovery_ = isDiscovery;
        this.discoveryFilter_ = discoveryFilter;
        this.grantTokens_ = grantTokens;
    }

    @Override
    public String getDefaultProviderId() {
        return PROVIDER_NAME;
    }

    @Override
    public KmsMasterKey getMasterKey(String provider, String keyId) throws UnsupportedProviderException, NoSuchMasterKeyException {
        if (!this.canProvide(provider)) {
            throw new UnsupportedProviderException();
        }
        if (!this.isDiscovery_ && !this.keyIds_.contains(keyId)) {
            throw new NoSuchMasterKeyException("Key must be in supplied list of keyIds.");
        }
        AwsKmsCmkArnInfo arnInfo = AwsKmsCmkArnInfo.parseInfoFromKeyArn(keyId);
        if (this.isDiscovery_ && this.discoveryFilter_ != null && arnInfo == null) {
            throw new NoSuchMasterKeyException("Cannot use non-ARN key identifiers or aliases if discovery filter is configured.");
        }
        if (this.isDiscovery_ && this.discoveryFilter_ != null && !this.discoveryFilter_.allowsPartitionAndAccount(arnInfo.getPartition(), arnInfo.getAccountId())) {
            throw new NoSuchMasterKeyException("Cannot use key in partition " + arnInfo.getPartition() + " with account id " + arnInfo.getAccountId() + " with configured discovery filter.");
        }
        Region region = this.defaultRegion_;
        if (arnInfo != null) {
            region = Region.of((String)arnInfo.getRegion());
        }
        Region region_ = region;
        Supplier<KmsClient> kmsSupplier = () -> {
            KmsClient client = this.regionalClientSupplier_.getClient(region_);
            if (client == null) {
                throw new AwsCryptoException("Can't use keys from region " + region_.id());
            }
            return client;
        };
        KmsMasterKey result2 = KmsMasterKey.getInstance(kmsSupplier, keyId, this);
        result2.setGrantTokens(this.grantTokens_);
        return result2;
    }

    @Override
    public List<KmsMasterKey> getMasterKeysForEncryption(MasterKeyRequest request) {
        if (this.keyIds_ == null) {
            return Collections.emptyList();
        }
        ArrayList<KmsMasterKey> result2 = new ArrayList<KmsMasterKey>(this.keyIds_.size());
        for (String id : this.keyIds_) {
            result2.add((KmsMasterKey)this.getMasterKey(id));
        }
        return result2;
    }

    @Override
    public DataKey<KmsMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws AwsCryptoException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (EncryptedDataKey encryptedDataKey : encryptedDataKeys) {
            if (!this.canProvide(encryptedDataKey.getProviderId())) continue;
            try {
                String keyArn = new String(encryptedDataKey.getProviderInformation(), StandardCharsets.UTF_8);
                return ((KmsMasterKey)this.getMasterKey(keyArn)).decryptDataKey(algorithm, Collections.singletonList(encryptedDataKey), encryptionContext);
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        throw this.buildCannotDecryptDksException(exceptions);
    }

    @Override
    @Deprecated
    public void setGrantTokens(List<String> grantTokens) {
        try {
            this.grantTokens_.clear();
            this.grantTokens_.addAll(grantTokens);
        }
        catch (UnsupportedOperationException e) {
            throw this.grantTokenError();
        }
    }

    @Override
    public List<String> getGrantTokens() {
        return new ArrayList<String>(this.grantTokens_);
    }

    @Override
    @Deprecated
    public void addGrantToken(String grantToken) {
        try {
            this.grantTokens_.add(grantToken);
        }
        catch (UnsupportedOperationException e) {
            throw this.grantTokenError();
        }
    }

    private RuntimeException grantTokenError() {
        return new IllegalStateException("This master key provider is immutable. Use withGrantTokens instead.");
    }

    public KmsMasterKeyProvider withGrantTokens(List<String> grantTokens) {
        grantTokens = Collections.unmodifiableList(new ArrayList<String>(grantTokens));
        return new KmsMasterKeyProvider(this.regionalClientSupplier_, this.defaultRegion_, this.keyIds_, grantTokens, this.isDiscovery_, this.discoveryFilter_);
    }

    public KmsMasterKeyProvider withGrantTokens(String ... grantTokens) {
        return this.withGrantTokens(Arrays.asList(grantTokens));
    }

    public static class Builder
    implements Cloneable {
        private Region defaultRegion_ = null;
        private Supplier<KmsClientBuilder> builderSupplier_ = null;
        private RegionalClientSupplier regionalClientSupplier_ = null;
        private DiscoveryFilter discoveryFilter_ = null;

        Builder() {
        }

        public Builder clone() {
            try {
                Builder cloned = (Builder)super.clone();
                cloned.builderSupplier_ = this.builderSupplier_;
                return cloned;
            }
            catch (CloneNotSupportedException e) {
                throw new Error("Impossible: CloneNotSupportedException", e);
            }
        }

        public Builder defaultRegion(Region defaultRegion) {
            this.defaultRegion_ = defaultRegion;
            return this;
        }

        public Builder customRegionalClientSupplier(RegionalClientSupplier regionalClientSupplier) {
            if (this.builderSupplier_ != null) {
                throw this.clientSupplierComboException();
            }
            this.regionalClientSupplier_ = regionalClientSupplier;
            return this;
        }

        public Builder builderSupplier(Supplier<KmsClientBuilder> supplier) {
            if (this.regionalClientSupplier_ != null) {
                throw this.clientSupplierComboException();
            }
            this.builderSupplier_ = supplier;
            return this;
        }

        private RuntimeException clientSupplierComboException() {
            return new IllegalStateException("only one of builderSupplier and customRegionalClientSupplier may be used");
        }

        public KmsMasterKeyProvider buildDiscovery() {
            boolean isDiscovery = true;
            RegionalClientSupplier supplier = this.clientFactory();
            return new KmsMasterKeyProvider(supplier, this.defaultRegion_, Collections.emptyList(), Collections.emptyList(), true, this.discoveryFilter_);
        }

        public KmsMasterKeyProvider buildDiscovery(DiscoveryFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException("Discovery filter must not be null if specifying a discovery filter.");
            }
            this.discoveryFilter_ = filter;
            return this.buildDiscovery();
        }

        public KmsMasterKeyProvider buildStrict(List<String> keyIds) {
            if (keyIds == null) {
                throw new IllegalArgumentException("Strict mode must be configured with a non-empty list of keyIds.");
            }
            boolean isDiscovery = false;
            RegionalClientSupplier supplier = this.clientFactory();
            return new KmsMasterKeyProvider(supplier, this.defaultRegion_, new ArrayList<String>(keyIds), Collections.emptyList(), false, null);
        }

        public KmsMasterKeyProvider buildStrict(String ... keyIds) {
            return this.buildStrict(Arrays.asList(keyIds));
        }

        RegionalClientSupplier clientFactory() {
            if (this.regionalClientSupplier_ != null) {
                return this.regionalClientSupplier_;
            }
            ConcurrentHashMap<Region, KmsClient> clientCache = new ConcurrentHashMap<Region, KmsClient>();
            this.snoopClientCache(clientCache);
            return region -> {
                KmsClient client = (KmsClient)clientCache.get(region);
                if (client != null) {
                    return client;
                }
                KmsClientBuilder builder = this.builderSupplier_ != null ? this.builderSupplier_.get() : KmsClient.builder();
                RequestClientCacher cacher = new RequestClientCacher(clientCache, region);
                ClientOverrideConfiguration overrideConfig = (ClientOverrideConfiguration)builder.overrideConfiguration().toBuilder().addExecutionInterceptor((ExecutionInterceptor)cacher).build();
                client = (KmsClient)((KmsClientBuilder)((KmsClientBuilder)builder.region(region)).overrideConfiguration(overrideConfig)).build();
                return cacher.setClient(client);
            };
        }

        protected void snoopClientCache(ConcurrentHashMap<Region, KmsClient> map) {
        }
    }
}

