/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.credential.criteria.impl;

import java.security.Key;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.AbstractTriStatePredicate;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.criteria.KeyLengthCriterion;
import org.opensaml.security.crypto.KeySupport;
import org.slf4j.Logger;

public class EvaluableKeyLengthCredentialCriterion
extends AbstractTriStatePredicate<Credential>
implements EvaluableCredentialCriterion {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EvaluableKeyLengthCredentialCriterion.class);
    private final int keyLength;

    public EvaluableKeyLengthCredentialCriterion(@Nonnull KeyLengthCriterion criteria) {
        this.keyLength = Constraint.isNotNull(criteria, "Criterion instance cannot be null").getKeyLength();
    }

    public EvaluableKeyLengthCredentialCriterion(int newKeyLength) {
        this.keyLength = newKeyLength;
    }

    @Override
    public boolean test(@Nullable Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return this.isNullInputSatisfies();
        }
        Key key = this.getKey(target);
        if (key == null) {
            this.log.info("Could not evaluate criteria, credential contained no key");
            return this.isUnevaluableSatisfies();
        }
        Integer length = KeySupport.getKeyLength(key);
        if (length == null) {
            this.log.info("Could not evaluate criteria, cannot determine length of key");
            return this.isUnevaluableSatisfies();
        }
        return this.keyLength == length;
    }

    @Nullable
    private Key getKey(@Nonnull Credential credential) {
        if (credential.getPublicKey() != null) {
            return credential.getPublicKey();
        }
        if (credential.getSecretKey() != null) {
            return credential.getSecretKey();
        }
        if (credential.getPrivateKey() != null) {
            return credential.getPrivateKey();
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EvaluableKeyLengthCredentialCriterion [keyLength=");
        builder.append(this.keyLength);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return Integer.valueOf(this.keyLength).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EvaluableKeyLengthCredentialCriterion) {
            EvaluableKeyLengthCredentialCriterion other = (EvaluableKeyLengthCredentialCriterion)obj;
            return this.keyLength == other.keyLength;
        }
        return false;
    }
}

