/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

grayscale reconstruction by dilation of an image


Reconstruction by dilation operates on a "marker" image and a
"mask" image, and is defined as the dilation of the marker image
with respect to the mask image iterated until stability.

The marker image must be less than or equal to the mask image (on a
pixel by pixel basis).

Geodesic morphology is described in Chapter 6.2 of Pierre Soille's
book "Morphological Image Analysis: Principles and Applications",
Second Edition, Springer, 2003.

Algorithm implemented in this filter is based on algorithm described by Kevin
Robinson and Paul F. Whelan in "Efficient Morphological
Reconstruction: A Downhill Filter", Pattern Recognition Letters,
Volume 25, Issue 15, November 2004, Pages 1759-1767.

The algorithm, a description of the transform and some applications
can be found in "Morphological Grayscale Reconstruction in Image
Analysis:  Applications and Efficient Algorithms", Luc Vincent, IEEE
Transactions on image processing, Vol. 2, April 1993.


Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.

See:
 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter , ReconstructionByErosionImageFilter , OpeningByReconstructionImageFilter , ClosingByReconstructionImageFilter , ReconstructionImageFilter

 itk::simple::ReconstructionByDilation for the procedural interface

 itk::ReconstructionByDilationImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkReconstructionByDilationImageFilter.h
*/
public class ReconstructionByDilationImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ReconstructionByDilationImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ReconstructionByDilationImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ReconstructionByDilationImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ReconstructionByDilationImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ReconstructionByDilationImageFilter::~ReconstructionByDilationImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ReconstructionByDilationImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ReconstructionByDilationImageFilter::ReconstructionByDilationImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ReconstructionByDilationImageFilter() {
    this(SimpleITKJNI.new_ReconstructionByDilationImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ReconstructionByDilationImageFilter::SetFullyConnected(bool FullyConnected)
*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.ReconstructionByDilationImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::ReconstructionByDilationImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.ReconstructionByDilationImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ReconstructionByDilationImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.ReconstructionByDilationImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::ReconstructionByDilationImageFilter::GetFullyConnected() const
*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.ReconstructionByDilationImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ReconstructionByDilationImageFilter::SetUseInternalCopy(bool UseInternalCopy)
*/
public  void setUseInternalCopy(boolean UseInternalCopy) {
    SimpleITKJNI.ReconstructionByDilationImageFilter_setUseInternalCopy(swigCPtr, this, UseInternalCopy);
  }

  /**
Self&amp; itk::simple::ReconstructionByDilationImageFilter::UseInternalCopyOn()

Set the value of UseInternalCopy to true or false respectfully.

*/
public  void useInternalCopyOn() {
    SimpleITKJNI.ReconstructionByDilationImageFilter_useInternalCopyOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ReconstructionByDilationImageFilter::UseInternalCopyOff()
*/
public  void useInternalCopyOff() {
    SimpleITKJNI.ReconstructionByDilationImageFilter_useInternalCopyOff(swigCPtr, this);
  }

  /**
bool itk::simple::ReconstructionByDilationImageFilter::GetUseInternalCopy() const
*/
public  boolean getUseInternalCopy() {
    return SimpleITKJNI.ReconstructionByDilationImageFilter_getUseInternalCopy(swigCPtr, this);
  }

  /**
std::string itk::simple::ReconstructionByDilationImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ReconstructionByDilationImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ReconstructionByDilationImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ReconstructionByDilationImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ReconstructionByDilationImageFilter::Execute(const Image &amp;markerImage, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image markerImage, Image maskImage) {
    return new Image(SimpleITKJNI.ReconstructionByDilationImageFilter_execute(swigCPtr, this, Image.getCPtr(markerImage), markerImage, Image.getCPtr(maskImage), maskImage), true);
  }

}
